/* ip7110gen.c -- ipivot shell password generator
 * passwords are based solely on MAC address of interface 0.
 *
 * > gcc -o ip7110gen ip7110gen.c -O2 -lnsl -lsocket 
 * > ip7110gen 11:22:33:44:55:66 
 * 7jp5ejrb
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

char monkey_data[1575]={
	0x6B, 0xD8, 0x3D, 0x0A, 0x30, 0xA1, 0xAF, 0xE4,
	0x38, 0x8B, 0x00, 0x68, 0x59, 0x86, 0x3F, 0x3F,
	0x26, 0x1F, 0xE3, 0x03, 0xEB, 0xE3, 0xB4, 0x76,
	0x75, 0xEA, 0x13, 0x83, 0x0B, 0x0A, 0xAA, 0x43,
	0x2F, 0xAB, 0xC3, 0xF0, 0x20, 0xA3, 0x8F, 0x03,
	0x05, 0xAB, 0x0A, 0xDB, 0x92, 0x18, 0x10, 0x2E,
	0x63, 0x41, 0xB2, 0xBE, 0xBC, 0xC6, 0xFA, 0x61,
	0x4A, 0x16, 0x1B, 0xE9, 0x37, 0x4F, 0xD6, 0x74,
	0x12, 0x83, 0x3B, 0x8D, 0xDF, 0x73, 0x94, 0x40,
	0xCB, 0x50, 0x15, 0x87, 0x97, 0x1D, 0x54, 0x55,
	0xF5, 0x7F, 0xCA, 0x69, 0x1C, 0xCB, 0x1C, 0xD5,
	0x37, 0xD1, 0x75, 0x67, 0x52, 0x00, 0x7C, 0x4D,
	0x70, 0x25, 0xB7, 0xA0, 0xE5, 0xD5, 0xCB, 0x8A,
	0x00, 0x1D, 0x7B, 0xCC, 0xC1, 0x74, 0x45, 0x0F,
	0xDF, 0x79, 0x00, 0xA0, 0xD2, 0x3B, 0xE3, 0x82,
	0x83, 0xF3, 0x0C, 0x62, 0xF6, 0x56, 0x69, 0x59,
	0xF7, 0xF7, 0x86, 0x48, 0x17, 0x9C, 0xF6, 0x69,
	0x86, 0x36, 0x04, 0xFD, 0x61, 0xE2, 0xBE, 0x0C,
	0xFF, 0xBE, 0x85, 0xF0, 0xCB, 0xC0, 0xFC, 0x37,
	0x98, 0x46, 0xDC, 0x2D, 0x08, 0x13, 0x19, 0xDE,
	0x24, 0x04, 0xC2, 0x91, 0x1A, 0x36, 0xF9, 0xEF,
	0x3B, 0x20, 0x01, 0x1F, 0x57, 0x71, 0x48, 0xB3,
	0x54, 0xDF, 0xA0, 0xB8, 0x9C, 0xDB, 0x24, 0x38,
	0x3D, 0x64, 0x56, 0x92, 0x86, 0x30, 0x8E, 0x4C,
	0xE1, 0x23, 0x17, 0xE7, 0x01, 0x62, 0xCE, 0xF0,
	0xF4, 0x7A, 0xEC, 0xFA, 0x20, 0x94, 0x69, 0x3F,
	0x0F, 0xB3, 0x62, 0x2B, 0xA7, 0xAF, 0x4A, 0x82,
	0x0A, 0xB7, 0x8B, 0xAA, 0x79, 0xAA, 0xAA, 0xB7,
	0x08, 0xA8, 0xA1, 0x82, 0xD5, 0xC9, 0x2D, 0x2E,
	0xC3, 0x82, 0x6A, 0x2A, 0x46, 0xC2, 0xCA, 0x2A,
	0xAA, 0xAA, 0xFD, 0xA8, 0x7F, 0xCB, 0xD2, 0x98,
	0x09, 0xA3, 0xA2, 0xB2, 0xEF, 0x6B, 0x10, 0xE7,
	0xE1, 0xD1, 0x90, 0x13, 0xE2, 0x3D, 0xE3, 0xC0,
	0x4C, 0x2B, 0xDE, 0xEA, 0x99, 0xC4, 0x21, 0x78,
	0xF8, 0x50, 0x41, 0xB0, 0xD5, 0xDC, 0xD3, 0x70,
	0xFE, 0xE7, 0xAB, 0xB6, 0xF8, 0x2C, 0xCA, 0xEE,
	0x9B, 0x19, 0x92, 0x19, 0x58, 0xA0, 0x66, 0x8C,
	0xA0, 0x81, 0x8C, 0x87, 0x07, 0x12, 0xF0, 0x31,
	0x17, 0xB5, 0xC5, 0xB9, 0x8B, 0x2B, 0xF2, 0xD9,
	0x1C, 0x17, 0x2F, 0xF0, 0x3F, 0x95, 0xD7, 0x15,
	0x84, 0x44, 0x11, 0x6D, 0x9A, 0x47, 0x01, 0x4D,
	0x68, 0x52, 0xC0, 0x64, 0xA6, 0xA5, 0xD7, 0x82,
	0xA4, 0x36, 0x18, 0xE3, 0x2A, 0xAE, 0x3C, 0xA6,
	0xE2, 0x86, 0x84, 0x48, 0x48, 0xFA, 0x51, 0xF2,
	0x97, 0xC8, 0x28, 0x3F, 0xBC, 0xE3, 0x2D, 0x02,
	0x64, 0x91, 0xA4, 0x98, 0x4D, 0xBC, 0x9A, 0x5F,
	0x04, 0x78, 0x7F, 0x7E, 0xEE, 0x27, 0xCC, 0x69,
	0xDA, 0x31, 0x2D, 0xF0, 0xB7, 0xEB, 0xCB, 0xF9,
	0x80, 0xA9, 0x3C, 0x8E, 0x69, 0x0B, 0xFB, 0xF8,
	0xAA, 0x83, 0x7C, 0x9A, 0x42, 0x13, 0x74, 0x9E,
	0xFA, 0xDB, 0x58, 0xAF, 0x43, 0x87, 0xBD, 0x1E,
	0xDB, 0x59, 0x06, 0x06, 0xCC, 0x42, 0xA2, 0x4B,
	0x3B, 0xBA, 0xBE, 0xA3, 0x20, 0xF3, 0x80, 0xAB,
	0x2E, 0xAA, 0xBA, 0x8B, 0xAE, 0xA9, 0x3E, 0xC8,
	0xE9, 0x33, 0xDD, 0xA9, 0x0C, 0xD1, 0x16, 0xB6,
	0xBF, 0x9A, 0x8F, 0xDA, 0xAA, 0x74, 0x07, 0xC0,
	0x8A, 0x6D, 0x09, 0x45, 0xFB, 0x0C, 0xD5, 0x55,
	0x57, 0xB7, 0x3F, 0x8C, 0x51, 0x32, 0x3E, 0x88,
	0x4A, 0x08, 0xE0, 0x08, 0x4E, 0x96, 0xD2, 0xD3,
	0x14, 0x88, 0x67, 0x86, 0xAC, 0xA8, 0x66, 0xAA,
	0xA2, 0xBF, 0xBB, 0xD9, 0x26, 0x8D, 0x7F, 0x13,
	0x65, 0x63, 0x05, 0x04, 0x72, 0x67, 0x70, 0xC4,
	0x73, 0x90, 0x11, 0x06, 0xD2, 0xD6, 0xB3, 0xD1,
	0x68, 0x99, 0x99, 0xE5, 0xFF, 0x21, 0x01, 0x69,
	0x98, 0x44, 0xCD, 0x0B, 0x83, 0x7D, 0x64, 0x53,
	0x35, 0x4D, 0x3F, 0x61, 0xC3, 0xCF, 0x55, 0x51,
	0x28, 0xCE, 0xF7, 0x2A, 0xA8, 0x35, 0xA2, 0xFD,
	0xC1, 0x83, 0xBB, 0x8A, 0xC3, 0x8B, 0xD9, 0x4D,
	0xE5, 0x89, 0xCF, 0xDF, 0x59, 0xEC, 0xF4, 0xB6,
	0xE1, 0xB2, 0x60, 0xB6, 0x0D, 0x30, 0xDA, 0xC6,	
	0x82, 0x98, 0x84, 0x45, 0x4C, 0x76, 0x80, 0x08,
	0x59, 0xD9, 0x04, 0x98, 0xFB, 0x2A, 0x9F, 0x97,
	0x63, 0x06, 0xB9, 0xE2, 0x6F, 0x9E, 0x59, 0x07,
	0xFD, 0xF0, 0x03, 0xD3, 0xA6, 0xDA, 0x7F, 0xAA,
	0x9A, 0xAA, 0xAA, 0x8A, 0xA2, 0xA0, 0xAB, 0xAA,
	0x2A, 0x6A, 0x61, 0x34, 0x9A, 0x9A, 0x27, 0x77,
	0xA0, 0xA1, 0x50, 0x7D, 0xA1, 0xF7, 0xA3, 0xEB,
	0x46, 0x90, 0x3D, 0xA1, 0xB6, 0xFE, 0x40, 0xDF,
	0x31, 0x24, 0x5A, 0x9B, 0x6E, 0x3D, 0x9C, 0xAA,
	0x20, 0x47, 0xB3, 0x89, 0xA8, 0xA1, 0x7F, 0xBD,
	0xF1, 0x26, 0x26, 0xC1, 0x02, 0x04, 0xAB, 0x81,
	0xDE, 0x3E, 0x2A, 0xAA, 0x75, 0x61, 0xB8, 0xBE,
	0xB3, 0xE8, 0xCF, 0x48, 0x44, 0x31, 0x38, 0x65,
	0x63, 0xB2, 0x35, 0x78, 0x3F, 0xFF, 0xE8, 0xA1,
	0x30, 0x75, 0x8B, 0x16, 0x80, 0x19, 0xE1, 0x65,
	0x4C, 0x4B, 0xF1, 0x41, 0x89, 0x19, 0xFD, 0x1D,
	0x07, 0x46, 0x36, 0x34, 0xF7, 0x04, 0x74, 0x3C,
	0xFF, 0xDA, 0xB6, 0xEA, 0xAA, 0xEB, 0x83, 0xAA,
	0xB9, 0x2C, 0x29, 0xEB, 0x6C, 0xAA, 0x03, 0x9D,
	0x52, 0x17, 0xFF, 0x44, 0xC3, 0x86, 0x6A, 0x80,
	0x37, 0xFD, 0x3F, 0x32, 0x46, 0xE9, 0xD6, 0x03,
	0x72, 0xEF, 0x43, 0xA3, 0x11, 0x1C, 0xCF, 0x38,
	0xA7, 0x49, 0x5E, 0x62, 0x72, 0xC9, 0x13, 0x81,
	0xC9, 0x1F, 0x35, 0x8E, 0xAA, 0x21, 0xF5, 0x6B,
	0xF5, 0xD4, 0x6F, 0x7E, 0x01, 0xCF, 0x15, 0x6D,
	0x43, 0xC9, 0x76, 0x4B, 0xD6, 0x5E, 0x41, 0xE0,
	0x36, 0x56, 0x9D, 0x55, 0x58, 0xED, 0x7A, 0xAC,
	0x1A, 0xF3, 0xBD, 0x4B, 0x43, 0xD6, 0x75, 0xF9,
	0xF4, 0xAA, 0x2E, 0x28, 0xEA, 0xAB, 0xAB, 0x1A,
	0x52, 0x6A, 0xCC, 0x82, 0xA0, 0x80, 0x40, 0x00,
	0xD7, 0x90, 0xB0, 0x61, 0x9F, 0x1F, 0x20, 0x27,
	0xC3, 0x05, 0x1D, 0x43, 0x47, 0x55, 0xF1, 0x51,
	0x42, 0x35, 0xC9, 0x38, 0xBC, 0x40, 0x4D, 0xE8,
	0x5F, 0x25, 0x92, 0xF6, 0x98, 0x84, 0x01, 0x48,
	0x89, 0xE5, 0xED, 0x87, 0x2F, 0x9F, 0xE3, 0x9C,
	0x78, 0xC7, 0xBE, 0x4C, 0x9D, 0x6C, 0x9A, 0xDF,
	0x0F, 0xFF, 0x7A, 0xCF, 0xF2, 0x5A, 0x05, 0x03,
	0x1B, 0xEF, 0xFE, 0x9B, 0x26, 0xE5, 0xF6, 0x1E,
	0xC6, 0x3C, 0xEF, 0xFB, 0xE3, 0xD1, 0xF1, 0xEB,
	0x97, 0x13, 0x16, 0x2F, 0x17, 0xC7, 0x9F, 0xF0,
	0x3C, 0x3B, 0x7E, 0xC3, 0x88, 0xB3, 0x0C, 0x2D,
	0x9E, 0xF8, 0x27, 0xE2, 0x54, 0xD1, 0xCE, 0xD7,
	0x4F, 0xC0, 0x24, 0x21, 0x98, 0xF5, 0x98, 0x84,
	0xB1, 0xFA, 0xD7, 0x83, 0x0C, 0x34, 0xDD, 0x95,
	0xB0, 0x37, 0xE9, 0x31, 0x88, 0xBD, 0x7E, 0x64,
	0x6F, 0x06, 0x0C, 0xDE, 0x3B, 0x2F, 0x1C, 0x08,
	0x3A, 0x2D, 0xCF, 0x51, 0x17, 0xA1, 0x60, 0xA8,
	0x72, 0x55, 0x51, 0x28, 0xCE, 0xD2, 0x2A, 0xA8,
	0x6D, 0x8F, 0xFC, 0xC9, 0xA9, 0xB0, 0xF0, 0x99,
	0xEA, 0x90, 0x66, 0x8E, 0x6A, 0xAB, 0xA6, 0xF3,
	0xCD, 0xF7, 0x0D, 0x26, 0xC7, 0x02, 0x1A, 0x28,
	0x81, 0x1E, 0x98, 0x26, 0xA2, 0xAA, 0x31, 0xE4,
	0xEA, 0xAA, 0x77, 0xEA, 0xEB, 0x8F, 0x12, 0x48,
	0xF5, 0x30, 0x0F, 0xE1, 0xBE, 0xF0, 0xD8, 0x8D,
	0xB3, 0xB3, 0x90, 0xED, 0x7B, 0xFB, 0xC3, 0x3F,
	0x3E, 0xB9, 0x1B, 0x71, 0x6C, 0x89, 0x21, 0x3D,
	0x35, 0xA4, 0x83, 0x2A, 0x14, 0x77, 0xFE, 0x20,
	0x62, 0x52, 0x95, 0xF9, 0xBA, 0x7E, 0x8F, 0xA5,
	0x9D, 0xA5, 0x30, 0xEC, 0xD8, 0x35, 0xC3, 0x88,
	0xD2, 0xD6, 0xE0, 0x28, 0x2B, 0x5C, 0xCF, 0xA7,
	0xF6, 0xB6, 0xA5, 0x71, 0xD6, 0x14, 0x33, 0xD5,
	0x1B, 0xA9, 0xB1, 0xE8, 0xC5, 0x57, 0x37, 0x5C,
	0xEE, 0x9D, 0x72, 0xE0, 0xFC, 0x6A, 0x71, 0xA7,
	0xB1, 0x54, 0x0F, 0x8A, 0x87, 0xAA, 0x8F, 0x8A,
	0xF9, 0xAA, 0xA7, 0x6A, 0x27, 0xA1, 0xBE, 0x9A,
	0xD8, 0xE3, 0xB2, 0x35, 0x81, 0xA7, 0x8F, 0xCE,
	0x65, 0x04, 0x10, 0x1A, 0x9F, 0x27, 0xF8, 0x93,
	0xF1, 0x95, 0x98, 0xA0, 0x48, 0x27, 0x43, 0xD3,
	0x03, 0xD1, 0x37, 0xFC, 0x58, 0xF0, 0xB3, 0x34,
	0xD4, 0xF9, 0x7C, 0xC7, 0xC3, 0xEE, 0x20, 0x7B,
	0x16, 0x4F, 0xCA, 0x1F, 0x79, 0xC4, 0x31, 0x08,
	0xBB, 0x9C, 0xEE, 0xB7, 0xEE, 0x82, 0x9B, 0xB8,
	0xD2, 0x48, 0x78, 0x43, 0xC1, 0xE7, 0x7C, 0x74,
	0x47, 0xDC, 0x04, 0x48, 0x6B, 0xFC, 0x1C, 0xD0,
	0x5D, 0xCC, 0x3D, 0xD8, 0xBB, 0xC5, 0xEE, 0xD4,
	0x75, 0x81, 0x91, 0xFA, 0x5F, 0x6B, 0x6A, 0xA8,
	0xAE, 0x3A, 0x26, 0xDD, 0x9D, 0x46, 0x26, 0xC3,
	0xA3, 0xB4, 0x28, 0xCC, 0x56, 0x0E, 0x2E, 0xE3,
	0x2A, 0x32, 0x64, 0xDA, 0x43, 0xDB, 0xD2, 0xD1,
	0x8B, 0xB1, 0xFC, 0x7B, 0x67, 0xE2, 0x5B, 0xB1,
	0xAC, 0xA3, 0x4D, 0x78, 0x78, 0x4F, 0x72, 0xE8,
	0xB7, 0x1C, 0x3D, 0x8E, 0x59, 0x3E, 0x82, 0xF8,
	0xF3, 0xA0, 0xDB, 0xE9, 0x21, 0xBE, 0x8E, 0x97,
	0xFC, 0x33, 0xC6, 0xA2, 0x26, 0x3B, 0x48, 0x29,
	0x29, 0x02, 0x9F, 0x9E, 0x6B, 0xD9, 0x06, 0xC1,
	0x6A, 0xAF, 0x62, 0xD6, 0x7C, 0xE2, 0x5A, 0xCC,
	0xCC, 0xC2, 0xC7, 0x1D, 0xB1, 0xC2, 0xA3, 0x09,
	0xC8, 0x88, 0xD9, 0xCF, 0x88, 0x7E, 0x36, 0x39,
	0x92, 0x31, 0xF2, 0x1F, 0xDD, 0xFD, 0x6C, 0x30,
	0x74, 0x15, 0xEF, 0x44, 0xE1, 0xAA, 0xD5, 0xD1,
	0x0E, 0xDD, 0x0D, 0x24, 0xBA, 0xF1, 0xC2, 0x3F,
	0x34, 0xC4, 0x4D, 0xAF, 0x59, 0x81, 0xEA, 0x63,
	0xEB, 0x71, 0xD7, 0xD6, 0x55, 0xC8, 0xDD, 0x13,
	0x41, 0xD2, 0xB8, 0x0E, 0x26, 0xC1, 0xCB, 0x1C,
	0x01, 0x26, 0xFF, 0xEC, 0x17, 0xED, 0x84, 0x4D,
	0x1F, 0x05, 0xC7, 0x75, 0x3F, 0x97, 0x77, 0x15,
	0x55, 0x50, 0xA6, 0x46, 0xA8, 0xFA, 0x37, 0x2D,
	0x5E, 0x1D, 0x7B, 0x9B, 0x89, 0x2A, 0x60, 0xE8,
	0x26, 0xF8, 0x74, 0x48, 0xAF, 0x37, 0x31, 0x38,
	0x44, 0xB6, 0x0B, 0xD6, 0x17, 0x42, 0xB1, 0x32,
	0xB0, 0xBD, 0x68, 0x52, 0x9A, 0xCF, 0xD5, 0x9E,
	0xC0, 0xA6, 0xC4, 0xE0, 0x86, 0x36, 0xEB, 0x56,
	0x76, 0x3A, 0x82, 0xB1, 0x3D, 0xA4, 0x31, 0x03,
	0xC9, 0x3A, 0xE6, 0xA0, 0xB5, 0x77, 0xCF, 0x5D,
	0x8F, 0x64, 0xB0, 0xBD, 0xA3, 0xBE, 0xAF, 0x10,
	0x2C, 0xFA, 0x65, 0x55, 0x84, 0xB0, 0x8C, 0xC2,
	0xCC, 0xC4, 0xF5, 0xDE, 0xAD, 0xDA, 0x6F, 0xB6,
	0x2F, 0x29, 0xCB, 0xD2, 0x76, 0x36, 0xE3, 0x55,
	0x55, 0x51, 0x28, 0xCE, 0x7F, 0x2A, 0xA8, 0x69,
	0xBC, 0xE6, 0x51, 0xAC, 0xEB, 0x68, 0xEF, 0x2A,
	0x33, 0x35, 0x8F, 0x2B, 0xB8, 0xA0, 0x0A, 0xF3,
	0x99, 0x5E, 0x59, 0xAA, 0xA3, 0xA6, 0x28, 0xCF,
	0xC4, 0x32, 0xAA, 0xAA, 0x50, 0x3A, 0xEB, 0x37,
	0x71, 0x38, 0xCE, 0x49, 0x62, 0x3D, 0x66, 0xA6,
	0x24, 0x13, 0x5C, 0x55, 0x55, 0x9E, 0xE4, 0x63,
	0x7C, 0x36, 0x76, 0x4B, 0x47, 0x67, 0x6D, 0xD2,
	0x93, 0x6E, 0x7D, 0x31, 0x38, 0x44, 0x8A, 0xE8,
	0x72, 0x0F, 0x42, 0xB1, 0x32, 0xB0, 0xB8, 0x48,
	0xFA, 0x98, 0x63, 0x55, 0x9E, 0xC0, 0xA6, 0xF9,
	0xB4, 0x22, 0x3D, 0x20, 0x95, 0x0C, 0xCA, 0xD3,
	0x99, 0xEF, 0x31, 0x03, 0xC9, 0x3A, 0xE6, 0xA3,
	0xE5, 0x44, 0x18, 0x51, 0x38, 0x4D, 0xA7, 0xA1,
	0x2E, 0x20, 0x2C, 0x5E, 0x2D, 0x3A, 0x7D, 0x55,
	0x84, 0xB0, 0x8C, 0xC2, 0xCC, 0xC4, 0xF5, 0xDE,
	0xAD, 0xDA, 0x34, 0x26, 0x8B, 0xCB, 0xB2, 0x38,
	0x9D, 0x8D, 0xB8, 0xD5, 0x54, 0x09, 0xEE, 0xB3,
	0x77, 0x35, 0x99, 0x8D, 0xB4, 0xEE, 0x14
};

char monkeyset[32]={
	0x9E, 0xDE, 0x92, 0xC2, 0xCF, 0x99, 0xDB, 0xDF,
	0x9F, 0xC9, 0xC1, 0xCC, 0x9C, 0xD2, 0xC0, 0xC7,
	0x9B, 0xDA, 0xCE, 0xD8, 0x9D, 0xCB, 0xD0, 0x98,
	0xD3, 0xC8, 0xDD, 0x93, 0xC4, 0xCD, 0xD9, 0xC3
};

char out[9];
char defpass[]="saint";	

char *monkeypass(unsigned char *addr);
struct ether_addr *ether_aton(char *s);

int main(int argc, char **argv)
{
  char *pass;
  struct ether_addr *pea;
  char octets[6];

  if(argc!=2) {
    printf("usage: %s <macaddr>\n",argv[0]);
    return 1;
  }

  pea=ether_aton(argv[1]);
  if(pea==NULL) {
    printf("invalid ether addr.\n");
    return 1;
  }
  memcpy(octets,pea,6);
 
  pass=monkeypass(octets);

  printf("%s\n",pass);
  return 0;
}


char *monkeypass(unsigned char *addr)
{
  unsigned char *pftd;
  unsigned int x,i,j;
  
  x=((addr[4]<<8) | addr[5]) * 6;
  
  pftd=&(monkey_data[x%1569]);
  
  for(i=0;i<=5;i++) {
    addr[i]^=(pftd[i]^0xAA);
  }
  
  for(j=0;j<8;j++) {
    out[j]=(monkeyset[addr[0]&31])^0xAA;
    for(i=0;i<6;i++) {
      addr[i]=((addr[i]<<5) | (addr[i+1]>>3));
    }
  }
  
  out[8]=0;
  
  return out;
}

