/*

MD5 hashes of the WADs for the Doom engine 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

updated 25 Jul 2007
Contact me if you want to submit other WADs

WADs from idgames/levels, game engines and other sources

NOTE: exist some duplicates here (same name but different hash),
      unfortunately I don't know what was the most updated
      version of that specific wad 

*/

/*
typedef struct {
    u_char  *wad;
    u_char  *md5;
} wad_md5_struct;

const static wad_md5_struct wad_md5[] = {
*/

char    *wad_md5[][2] = {

    { "",                   "00000000000000000000000000000000" },   // if none

        // OFFICIAL WADS (latest versions, they were released years ago so it's easy)

    { "DOOM.WAD",           "c4fe9fd920207691a9f493668e0a2083" },
    { "DOOM1.WAD",          "f0cefca49926d00903cf57551d901abe" },
    { "DOOM2.WAD",          "25e1459ca71d321525f84628f45ca8cd" },
    { "HERETIC.WAD",        "66d686b1ed6d35ff103f15dbd30e0341" },
    { "HERETIC1.WAD",       "ae779722390ec32fa37b0d361f7d82f8" },
    { "HEXEN.WAD",          "abb033caf81e26f12a2103e1fa25453f" },
    { "PLUTONIA.WAD",       "75c8cf89566741fa9d22447604053bd7" },
    { "TNT.WAD",            "4e158d9953c79ccf97bd0663244cc6b6" },
    { "HEXDD.WAD",          "1077432e2690d390c256ac908b5f4efa" },

        // ENGINES (possibly the latest versions)

    { "AlphaFlats3D.wad",   "00a6f2fb391b96278d29a0309a008155" },
    { "CSDOOM.WAD",         "d0ee341acf49527fd6e581d7316a21b4" },
    { "DOOM1_FREEDOOM.WAD", "bd4b0a0e31fee4f9378946b6854811c0" },   // FREEDOOM
    { "DOOM2_FREEDOOM.WAD", "07cdeb209921df5e0e88a7988ff98afe" },   // FREEDOOM
    { "DOOMSDAY.WAD",       "7bfaf2eff92f8198fc3d0f242f6a26ad" },
    { "EDGE.WAD",           "a1459027b1202329306925095026ef58" },
    { "ETERNITY.WAD",       "29fd1b658a11f0eb8eca14f83674ac4b" },
    { "FREEDM.WAD",         "b4b555208a03f632559f1bf64e582797" },
    { "JDOOM.WAD",          "228e973696e585ce658e2d72aa34cd22" },
    { "JHERETIC.WAD",       "674fab4b3504ea9f8544d88797ad6966" },
    { "JHEXEN.WAD",         "9a9131253a8e1a960ad1bdf098b85891" },
    { "PRBOOM.WAD",         "7e0aec00a88d6886b7691ac6741d6509" },
    { "R3Ddemo184_04.wad",  "2d3ed1caa936b01cc728dbb4ff722a75" },
    { "Risen3D.wad",        "a55e2725b6e2061fe828bcb45661aa88" },
    { "SKULLTAG.WAD",       "9ea9b35cbe087b89a387e924f9103c4f" },
    { "ZDAEMON.WAD",        "f3a242bf226eb10c28b8c7fccb18c88f" },
    { "ZDOOM.WAD",          "7395640419c4a706885d8cf0b04fc243" },
    { "ZDOOM.WAD",          "9c647c7c22596be1b9cde3d8168a7e11" },   // ZDOOMGL!
    { "ZDOOMGL.WAD",        "3e1cfa19c289d7d331b06e82133726a6" },
    { "blargIP_13.wad",     "7a714154ecb6a1b3ffc880b4c88f4f25" },
    { "classic10b.wad",     "8d3998001ae460676fcaaa6609591066" },
    { "shock.wad",          "64d5c017cd25410091ec195aebef10a5" },

        // DOOM

    { "!CSRE2M1.WAD",       "7671fb9d29047ed358279b60b2040968" },
    { "!CSRSNDS.WAD",       "a8342778ff67747afa5acd82e2559fe9" },
    { "!POIS!.WAD",         "d85680ea977021a213135deb1d824714" },
    { "!WOW!.WAD",          "489c81a39565478e20524c3d46f442e4" },
    { "#1KILL.WAD",         "4f4b175a542a768aa01575236adf9926" },
    { "#969.WAD",           "fe7ce32a14db23903c2393a4a99d0022" },
    { "#969DM.WAD",         "e79171ea9812b610189d13d83f970411" },
    { "0.WAD",              "e2484ca90e8a1ede31447558ca1c8f5b" },
    { "00_E2M8.WAD",        "b2b39d1e8b6a381e502996acc114a63e" },
    { "01AROUND.WAD",       "99708773d11cfd6fc0b5890efcb2aa35" },
    { "01FRAG.WAD",         "ec161537557d1ff38a1d2c027bf819b0" },
    { "01RATLTE.WAD",       "59a806893db528a9181f915d53246b39" },
    { "02WHAT.WAD",         "7265b5274c5aca93b36e686a196556b9" },
    { "101.WAD",            "06074bbbf5e01d4b67070eb409d3a657" },
    { "10YEARS.WAD",        "2841b5919672e48555520770d23dbba5" },
    { "11BONES.WAD",        "3bce79964d8e5def5ff7d45bf1531e6d" },
    { "11FORTKO.WAD",       "502fca90ca185d50fec75c5eb94d9d2d" },
    { "11GETBFG.WAD",       "6b4290ad6a471b67a377235d7d9a64af" },
    { "11INHELL.WAD",       "777ae16d106bff6a18433f58fa2403f3" },
    { "11NIDECK.WAD",       "9666c698f8fb49163b5c4a8aba892415" },
    { "11SPACE.WAD",        "7939e1d29696bf8e5d5ceede09b43c6c" },
    { "123.WAD",            "f846fcbd03f51820f19c72870ee4b2c6" },
    { "1500AD.WAD",         "57e52baa8d092ef4acc68c8bea79b30e" },
    { "1500MUS.WAD",        "253d3be96769f3f864c961fd3d3bf9ba" },
    { "1666DEMO.WAD",       "74d55b6c52f8e7a635803b278dc068aa" },
    { "1BERSERK.WAD",       "3a7a62f68899af946414b2a7a292c33b" },
    { "1DGDM1.WAD",         "66cd008189d537aef1415f6a2af23bb3" },
    { "1JUMP4IT.WAD",       "f2db6b0cb17899d4f690741ce31d430f" },
    { "1KDEATHS.WAD",       "22e7609c1569f8d8975c04e3f34e68a6" },
    { "1PHOBWAR.WAD",       "d2e895c9e3b6b844ca7dde5795b6baa9" },
    { "1STBL2.WAD",         "f6d7e5dfef5a05fc32dd4557c1e64a81" },
    { "1STBLOOD.WAD",       "f3ffa132b99d7ea7460fd10244955182" },
    { "1STLEVEL.WAD",       "598aa49c7d3ec57db063783a4ade7a72" },
    { "1STTRY.WAD",         "2b7f601755a8d43c72fa826cb87af4e1" },
    { "1_ON_1.WAD",         "45b0677530b7318917f18637674da280" },
    { "2001DM.WAD",         "87efb7a0c864b5f29d41fad137795bd0" },
    { "21HEX_PN.WAD",       "3c5614f13e8d89b069c9ff2363e204aa" },
    { "21JPXFIR.WAD",       "ffc299fd6465a3f76320382ae9f0e7e3" },
    { "21RATMAZ.WAD",       "5cda4e3e9ac6333ff8e0b805b47cd170" },
    { "22LEV.WAD",          "d792d6838453d40760e80c6f68c1bcff" },
    { "22SPRITE.WAD",       "152a2a2540af563143f33f059908bf01" },
    { "23CASTLE.WAD",       "22790dc9ab8d01d43a5e0168addb3436" },
    { "2BAD.WAD",           "2d6c301683e65754a34e2b1ee3be2af4" },
    { "2BOSSES.WAD",        "e0e48c4a0d63da77ec9c2b6e3c553153" },
    { "2HELL.WAD",          "6b9d64dc9f8c8d5d4eb1354db8f72124" },
    { "2PHOBWAR.WAD",       "3f86c4d30b5da766fc62a89d0ded4826" },
    { "2SIMPLE.WAD",        "29985291bdc3610684df8a653d8b0632" },
    { "3.WAD",              "470529e43572ead6ecee5b8039caf5a2" },
    { "303SUX2.WAD",        "dee95b7b9b5b2aa506b3a4b5963cca67" },
    { "3WAYS.WAD",          "8d447d81a6dafa1107d2bb7a08a356ff" },
    { "4CORNERS.WAD",       "6b1dfe35c27cbaabcd3c14b8476108ef" },
    { "4CYL12.WAD",         "f560caa94aeff937cb12f615ec31c058" },
    { "666EPIS.WAD",        "6656b9dea655b62d720c47f83eaef169" },
    { "8ISENUF.WAD",        "b5bc3df9bb870c14ad13ba1c05b482d9" },
    { "8PAK.WAD",           "52d73b574bae8e06140d1422e82b5fea" },
    { "9-TO-5.WAD",         "b512407a9f161c68f912961a29a5d812" },
    { "9RING666.WAD",       "ca258212a5870d85ba6dd7ea8bbe9c93" },
    { "A41_COOP.WAD",       "11d26ab528dfaca45df2ec188000a5cc" },
    { "A41_SPDM.WAD",       "5e7659dbeab188323da4755400021f5c" },
    { "AA21.WAD",           "b2c014ec4f8bc2a7e8a2c41c9d3e370a" },
    { "AA22.WAD",           "a4ec1bcba4ce56cd3f0b895c70e3eff3" },
    { "AARRGHH!.WAD",       "3a62a41fbcf1396408e3f9e0713050c1" },
    { "ABANWARE.WAD",       "6d9ce526c851bea39b41d1750baf6454" },
    { "ABDITN.WAD",         "aaad40c03eee8107813d7a8fc1679d23" },
    { "ABYSS.WAD",          "596ace98f1a327ded5907022bf665445" },
    { "ACADEMY.WAD",        "36faa012297beced98b2c865c715b897" },
    { "ACASTLE2.WAD",       "ae5bfcc934e3dda52b17d93c3cbe09ac" },
    { "ACHERON.WAD",        "5ce4dd2c49e132d8c5315593680e7af5" },
    { "ACHERON6.WAD",       "b37e3fe6f979b8308092d5a375f30e84" },
    { "ADAM.WAD",           "44e456d75fe4a12c9a4813b2ef716b7a" },
    { "ADV1.WAD",           "80faa0c6a1a9f578ef430edf4d2ba31f" },
    { "AE_BKE.WAD",         "e253b699907a55b75f4bc0b5a18af55d" },
    { "AE_FZE.WAD",         "0df4fe9978293c2b05848facbb0a48b7" },
    { "AE_PROJR.WAD",       "bf75a26ad87afac3e2fd5e429fb03087" },
    { "AFRO.WAD",           "295afc731bfd7d745df4b2708d598606" },
    { "AGGADOO.WAD",        "b7d1ab83a1d95631f913020a45496517" },
    { "AHIDE.WAD",          "ca5346e681c8cafe01ac37ffcfc5bf04" },
    { "AIRDTH.WAD",         "5f75940f10103f1794f9edc4b1e7c621" },
    { "AIRWALK.WAD",        "36b35f093a77660e7339e0de3dcb5c7f" },
    { "AIRWALK2.WAD",       "9ff6928ce31d60616f5a4ed4be497584" },
    { "AKCE.WAD",           "ae1c29074a9e42a2c368e748c4d52fb4" },
    { "ALAIN.WAD",          "6b5c3f9b7109a4b63f4ce2fc48bbb224" },
    { "ALBILLO.WAD",        "4580afa955d7a1e99e086f4df74913a5" },
    { "ALCATRAZ.WAD",       "983246e365a00beda71bd191cbc463d1" },
    { "ALCATRZ1.WAD",       "3eb6dd47c3ec2c06465f5909023fef5b" },
    { "ALLROY2.WAD",        "7e7593a38f03a94518ebcb0c58c1bec0" },
    { "ALOHA911.WAD",       "6a2a71442195d16ea4c58ae9163a77d8" },
    { "ALOHA999.WAD",       "10bf80e496b7c74b8ad8f9994d2228c8" },
    { "ALONE.WAD",          "967ac789c6e2747af899015c3b1d06d6" },
    { "ALONE1.WAD",         "a4382a1dae5d8c36c30cfc6666c1eacd" },
    { "ALTIMA.WAD",         "142be8ec2d99b063e8d57de5c4219f52" },
    { "ALTNECRO.WAD",       "f57ae31a69b6b6051cb09635ddb4df63" },
    { "AMADEUS.WAD",        "23d846be8d51d94c9fe9713bb239c6dd" },
    { "AMANDA.WAD",         "194d1894fb089b3b522fe4d4835c3785" },
    { "AMANDA2.WAD",        "fe296895ef889e54a2485ee12828a1b9" },
    { "AMAZED.WAD",         "e888f95a6682ec79f309e9bb95aff9d1" },
    { "AMBIENT.WAD",        "efb89f6fc3911805957b0b914bdee1ad" },
    { "AMBUSH.WAD",         "aa32f71eb8d0fe3729729c4cd4e791a8" },
    { "AMFDOOM.WAD",        "17da7709ced8434203fe26fd4961e85b" },
    { "AMOK11T.WAD",        "df533e354b292c9c1c3ceb689aa3782d" },
    { "ANDER2.WAD",         "1e6328815b7b5068a846619dd3ea214c" },
    { "ANDREW.WAD",         "d21620cb38a698a0bfb36ec55603ad79" },
    { "ANDY.WAD",           "cf54f004eb0a1e01b45394a827195b30" },
    { "ANDYTRIG.WAD",       "584d15469eaa747aac9020d47eae9038" },
    { "ANE1M3LEVEL.WAD",    "23789934a06a388394a0360b98c06f21" },
    { "ANGUISH.WAD",        "95592a7b51a4413adf7f3a32d755cbb9" },
    { "ANNEX.WAD",          "7ae49b750431379d4947946f005b7eca" },
    { "ANOMALY2.WAD",       "3c37853b2fa2d8d96b2a9c75df2c7eee" },
    { "ANOTHER.WAD",        "eb12dab6f800491f182b263bb2c51d8d" },
    { "ANRRTI.WAD",         "bf630a65078be69264316a8be65751c7" },
    { "ANTEROOM.WAD",       "e150ea82bc2342431cc259bf533e0f23" },
    { "ANTHILL.WAD",        "71f7cf8474bf841b58daf18773a9c756" },
    { "ANYNCE11.WAD",       "e4a71138744ad0e5b5ee8600b566f604" },
    { "AOX.WAD",            "62d591b12dda4cde44b2ef00a251f805" },
    { "APHEXIUS.WAD",       "e4ea6bea90e9ff4386fe7d1d836a964b" },
    { "APOCALYP.WAD",       "2799c9290702d13ab830a95127ac2a05" },
    { "APOCH1.WAD",         "36f40c85a4470a1c0080794709533fe2" },
    { "APOCH2.WAD",         "d2fb52df5c6d17be7814ab237e4292bf" },
    { "APOCH3.WAD",         "9473d23252a5a716dc63e2f2a60bd686" },
    { "APOCH4.WAD",         "d7f78d50f3b62ea2c09f0c29640e090c" },
    { "APOCH5.WAD",         "9ff345701067f2c6ad96192d2c3205e4" },
    { "APOCLPSE.WAD",       "9da7e9dcf75863f9aa91db24bb869f36" },
    { "AQL.WAD",            "6acba41b9dc0e09c19c182fa379fb994" },
    { "AQUILA.WAD",         "67abd689ff075d2a440555aeaa80a634" },
    { "ARACHNA.WAD",        "083ad5ce2ba57d689b8d253586ec7f6b" },
    { "AREA53.WAD",         "68bb5de2d8bbb586060a85a06a744e60" },
    { "AREA8.WAD",          "4495e2ce11a1ca7410f9529eeb911422" },
    { "AREA_HD2.WAD",       "51705dd1a584043f52acb8ebd3403456" },
    { "ARENA.WAD",          "ab82554c314ed649e9a08b52afe9077f" },
    { "ARENA.WAD",          "c32b7e0afa83063b38aa33da62a67602" },
    { "ARENA3.WAD",         "7492b353fb3d6a6a9a51b1594b24007f" },
    { "ARENADTH.WAD",       "37fe5169bccd8f1035b7e81f3dc917fe" },
    { "ARMORY.WAD",         "6fa9358b867ce15db2eb13ea1f393066" },
    { "ARMORY.WAD",         "dcade0570b68dec13381fd580d5c6796" },
    { "ARTIFACT.WAD",       "2b85b0f47fd7b5dd393a59230c1e019c" },
    { "ASCENT.WAD",         "4e7d14237c95a99499580270c844ac38" },
    { "ASDOOM.WAD",         "0e9e52dc90e438345effc8959849990b" },
    { "ASMO1_1.WAD",        "8d3e949ccd32d86b56b991e68c620c1d" },
    { "ASMO1_2.WAD",        "afb79f39959c760a53159159bc641b8a" },
    { "ASSENT.WAD",         "fded82bb470c975ccd8630a947a8cb00" },
    { "ASYM.WAD",           "0ef1ea7f30653deed16706e5601ce7de" },
    { "ATHEIST.WAD",        "2cce5a3b3d5e43c86476c50fd4ccd6e7" },
    { "ATICA.WAD",          "25961ab13955bc477d612a5080595761" },
    { "ATLNTS1.WAD",        "102e6ee0523220df0d09a4e94e07df2d" },
    { "ATRIUM.WAD",         "2a25da3c41d50d1a47c3dd41ca7da126" },
    { "ATTACK.WAD",         "c91cd0773db8f61ff96a5dc79387364f" },
    { "AT_WORK.WAD",        "1f5e958b1e086fe687c5c896f7e9cd94" },
    { "AUDIT.WAD",          "18d1c30965c89bdafbe74effde4bcef9" },
    { "AUGUST2.WAD",        "f5a7326d712a76f8e5424f7b73d30bbc" },
    { "AURORA1.WAD",        "2499c873d5a0f343dd87a7a2ca13eec6" },
    { "AVRAX.WAD",          "5eb756d7ab1ef2b124bd1e7a85dbd0e2" },
    { "AWAYTEAM.WAD",       "96f5f480813992fb5406aac4e1c6e8e3" },
    { "AWEEMA.WAD",         "842840cb53a9f5b72bdc702db663f918" },
    { "AWP11F.WAD",         "ce601d25e891cfbc9632c3282cd6768f" },
    { "AWSOPALE.WAD",       "6fc47d2e4bf5ed36785b67803538c08e" },
    { "AYRTON_2.WAD",       "8b86567a1d39e736273ce33e6240d407" },
    { "A_RUSH!.WAD",        "8c1edc21567e9dc0857c584fddebc891" },
    { "B21.WAD",            "00bb8a877637e468457596b76e9fdaab" },
    { "BAAL2.WAD",          "373e107d0c6d868f6f752a84666da225" },
    { "BAAL3_1.WAD",        "aa1c6957236ca2f89b21368ec35c486b" },
    { "BADBLU.WAD",         "7b650896a24fdcb3bcc99637eb113064" },
    { "BADBLU35.WAD",       "7b33d9d19ce6d5401ef425223be6c93c" },
    { "BADDREAM.WAD",       "26f82bfed864a55696b40f975aad6264" },
    { "BADMOOD.WAD",        "94e930bdb0486fdfa2024843ffbfadd2" },
    { "BADWATER.WAD",       "d697845d675bbc2fafb40c42bedc6fe2" },
    { "BAK2HELL.WAD",       "06e3d254476bbf397cdd7853313f045a" },
    { "BAKAROO1.WAD",       "c3ff77b31dec9dc722dda265bae0bf8d" },
    { "BALLLOCK.WAD",       "87884dab52fba6b6361d48fba52cb715" },
    { "BAMSE.WAD",          "27e0cdff6af80bcad66feee8b57de41a" },
    { "BARBELL.WAD",        "60a9eca59904dd5fea9723ee8e596d4d" },
    { "BARON.WAD",          "62c3d2b0aa412ce98068f4ac757719c8" },
    { "BARONBBQ.WAD",       "9340d408e798080dba2941a1a76f9aa0" },
    { "BARONHSE.WAD",       "1bd9536eba5a7e0e79ed2dce980118cc" },
    { "BARRACKS.WAD",       "58624cbe0799461acbc675594f26b93e" },
    { "BARREL2.WAD",        "63ba4c726087ce77702dce58e053c7a3" },
    { "BASAKWRD.WAD",       "81560a316512c6b3f9b270979a70832b" },
    { "BASDEMO.WAD",        "59f4b6b2bd2d0e120719953a3efe84bd" },
    { "BASE TROUBLE.WAD",   "bf9e25adfc8409f9d67b450214fdaa19" },
    { "BASE.WAD",           "b560825eb47efcef446e9ae9598fac8e" },
    { "BASE.WAD",           "d5a6c069236a6da4784f5951cae76c51" },
    { "BASE12.WAD",         "b401bcb6e756747ea6438bf3f292db55" },
    { "BASE21.WAD",         "5163296ca3530fa83b68059a017c9f50" },
    { "BASILICA.WAD",       "b88d3229e168cf19ad78f9fb8bd6d151" },
    { "BAST.WAD",           "b38d4126bcd22b8ae9aed68a225802dd" },
    { "BASTARD3.WAD",       "a0a75c2650a46577973b72ac1bb0a5d1" },
    { "BAS_EVIL.WAD",       "d31ca29eeff1f4de26a32bd3d8fd5ce3" },
    { "BATMAN.WAD",         "153ce77f3f8574ca2e45eef2193964bc" },
    { "BATTLE-F.WAD",       "8d7f4b8e60e32f70f4c095713d932f28" },
    { "BCDEATH1.WAD",       "711b94822d765d0713ba594539163191" },
    { "BCDEATH2.WAD",       "59dd6d9c110ec2b35adb66f1749ec61a" },
    { "BCDEATH3.WAD",       "4c5fee484952dde0e9e4e9848fe32d1b" },
    { "BCDEATH4.WAD",       "5703da45528212f633ae9bc5efb8fe33" },
    { "BCDEATH5.WAD",       "40628c65dd578bb3006f91d41b398dba" },
    { "BCDEATH6.WAD",       "346edd6f1bd86e5153bafe1c7ac69103" },
    { "BCOMPLEX.WAD",       "adadf0b95d22cf7873695eb6b987d40e" },
    { "BDM.WAD",            "b1dda328a704d013a0b72f36c89c241e" },
    { "BDW.WAD",            "02b257bd1de76ef6bd907f4f601a57c8" },
    { "BE1M1.WAD",          "ba9dbbc7873adc22cb8107b72bb45cc4" },
    { "BEAN.WAD",           "60ecea00a3a4c0ab2798f0eb95f888f4" },
    { "BEATIT.WAD",         "e7fc6e25c9e965aa4e3f5711dc4b64dc" },
    { "BEEHIVE2.WAD",       "f56d49f6bc786498bfc3f757a2a043c5" },
    { "BEGUILED.WAD",       "a96bac69083868fdf0f5f6ebd7547ec4" },
    { "BEHOLDER.WAD",       "049bb71cc35aa6e9c966645924249949" },
    { "BELISHA_C.WAD",      "f3344b1495ed9a0bebb9e8ac96c55ed8" },
    { "BELLSNDS.WAD",       "8e8eb676f30021e95863cd1ba083dcf4" },
    { "BEN.WAD",            "8e609ab3fa06f28a596b9072d9417c17" },
    { "BERSERK.WAD",        "013d9a4938ede70b53838c12097cad17" },
    { "BESTDETH.WAD",       "f9c9dc895d520a9a4bd3d7718b6af4fc" },
    { "BETA7_8.WAD",        "fda9f7618d40451eaf3c44bb3f3a3d50" },
    { "BETTERM4.WAD",       "49fe1df7397da4a0f656b70b9d9ee599" },
    { "BEUKER.WAD",         "6079bb23c2a25cf7bb31fd4966cd674a" },
    { "BEWARE.WAD",         "d3150ff929f6310011225ee36079ed8f" },
    { "BEWARE26.WAD",       "6185a1fdeeb2a4f56f3e10cae4b5de85" },
    { "BEWARNED.WAD",       "2496eb5509c1b09ea68886d071df156c" },
    { "BEYOND.WAD",         "441d7c05697b69027e428b6489840449" },
    { "BFGTRAP1.WAD",       "eed0862d5c1c94e454b7bc4a92a41ab6" },
    { "BFLATS.WAD",         "f9c70e8a550f0d58e0d05e4206bff55e" },
    { "BIGBOY.WAD",         "5e4e991cb7184f9914792c8430bddf3c" },
    { "BIGBRO.WAD",         "87fb88a7c69e029112f502e536928b22" },
    { "BIGEMPTY.WAD",       "85789fcff2392086deca6c962fc0ccd4" },
    { "BIGJUICY.WAD",       "a4a66841cc9c696aac8e2b0b372ca8e1" },
    { "BIGMAC.WAD",         "bd838ef87e7aa437cfaa64b37cfe4e70" },
    { "BIGMAZE.WAD",        "497a431f672535b4966b4dcf79c76f6c" },
    { "BIGTRAP.WAD",        "1186abc521c2d00834663000fb917afc" },
    { "BILBO11.WAD",        "773ef9cbb7957fbb2e666937f08089f6" },
    { "BILLY.WAD",          "a0a940eea182db4f4cd05ebb4196f25b" },
    { "BIOSCI.WAD",         "70d4d507805bf2b76f161428d957839e" },
    { "BIOTECH.WAD",        "2341e3310192ea9362d3b3d4a03a9145" },
    { "BIP.WAD",            "ea7160264e77ba7e280836e04d000bfd" },
    { "BITEBWAD.WAD",       "4bbcb65a4dbb1f28abb03e4cc5bf4b98" },
    { "BITEDUST.WAD",       "031b75bee6948ea05d0c0036693b4b3b" },
    { "BITEDUST.WAD",       "11c713de66a63caaf491dd43d517dea4" },
    { "BITES.WAD",          "780557fba7bb0117bc0296e407aaa496" },
    { "BLACKOUT.WAD",       "5155a1eb963ac514f1d18c6ce30a1598" },
    { "BLACKWID.WAD",       "685974e6b2aca42390d15029a65e6f50" },
    { "BLADE13.WAD",        "9886d5dba996e472e7a98478066112a1" },
    { "BLAHBLAH.WAD",       "be95a876ba4d078ea190340ad58eed2a" },
    { "BLAKHELL.WAD",       "853e98004d1d69da0b00dc28b7feb18f" },
    { "BLAST.WAD",          "30281a3d97f20355c8f8139cec456558" },
    { "BLASTEM.WAD",        "f3bd35a9c8107c9ac07440bdb3c33d62" },
    { "BLAZE1.WAD",         "bc23d93327c2a32b29fa0fc92f201809" },
    { "BLDGIII.WAD",        "2d44561b4e8b380b0c00966b882d27f2" },
    { "BLEHA.WAD",          "27425d2a17f0250734f9052a847a4444" },
    { "BLEW.WAD",           "d36fb57781d0d29e2652e73af91aa787" },
    { "BLITZ.WAD",          "6f25336bac5aeb1e51d1ddd817a4448d" },
    { "BLOB.WAD",           "cf297890dbd71f371b7e742a62d8eeb0" },
    { "BLODBTH.WAD",        "921614d1d1d1583405f7481a6fd15198" },
    { "BLOOD.WAD",          "b38c1029f1e7024ce7272b3ed6a8c918" },
    { "BLOOD.WAD",          "fdff28487e346986cd2e439e2d0db48f" },
    { "BLOODFST.WAD",       "6b68f804a9def17020e1e2dfee7b0b0f" },
    { "BLOODKEY.WAD",       "76b58601ca4b94fa6ef4fcc46167e255" },
    { "BLOODREV.WAD",       "82e7b5548cd9a8c757dc0fe7b39a4109" },
    { "BLOTSND.WAD",        "12944c067f287c029f24eef41fe461e9" },
    { "BLOTWALZ.WAD",       "ea76d4a62b54501d2cadc4d703c99f80" },
    { "BLT.WAD",            "1c034866471cac79bb9881669e49dd7e" },
    { "BLUDBATH.WAD",       "d07e579ae7c412b9dac0ae1db7f85f38" },
    { "BLUDFEST.WAD",       "66ac7547423e9335f65299ce9e10d5d2" },
    { "BLUDLST2.WAD",       "03c6052d979be63d3480a6cf5c011d04" },
    { "BLUDLUST.WAD",       "e4f84c0a4caa78ba6a92b4f9ab5aa53c" },
    { "BME1.WAD",           "9a03a5df106093cc7c9f4e6d889c2fbe" },
    { "BNBEYOND.WAD",       "565736938628d2afd86a975517e8c979" },
    { "BNEDUEL.WAD",        "efaea151f59d75649b0e328e1b27790a" },
    { "BNEMUD.WAD",         "eaf06693c7270b8044a4f0b7b90563c1" },
    { "BOA.WAD",            "487075c78c2dfc61a1f82a9d87681760" },
    { "BONUS.WAD",          "d28a54893148a9be151c3d29d8bc4459" },
    { "BOOBYTRP.WAD",       "bcbdeb68743a52d0adbed41b515f9749" },
    { "BOOGERS.WAD",        "1e32eb8a38481fa477cafbf6f30281c5" },
    { "BOOM-TC2.WAD",       "7d26a037bf0465ab375f1304bba11003" },
    { "BOOM.WAD",           "b22a03faf511d5d7ea53af72e1cd3a81" },
    { "BOOTCAMP.WAD",       "87571723ad0a8f7784b1884e7f0de897" },
    { "BOOTY2.WAD",         "9b875d8feb54c0b502ce5575b9dd9745" },
    { "BOP.WAD",            "ce01a8afb930ecebfaf516d29bca719e" },
    { "BOTWALZ.WAD",        "f6e8c6cfeaa675b189672856f1858a3f" },
    { "BRAIN.WAD",          "12f3c9b6a8296ac53da4952421676d2f" },
    { "BRAVE.WAD",          "c24fa5daa2db49ef123b658aad494e98" },
    { "BREAKIN.WAD",        "fb2f2f947060732984febbf11160af9b" },
    { "BRET2AWE.WAD",       "720d5623e40066c07bc9ea671f755882" },
    { "BRETT2MUS.WAD",      "13b5a80b02ab07f09713bff71a396960" },
    { "BRIDGE.WAD",         "11deedab749914d5916a68f51343ff65" },
    { "BRIDGES.WAD",        "632a81321cfbc80213934c54675fa77b" },
    { "BRNSOFUN.WAD",       "663791aca1835abfe5a9694e2f80d65a" },
    { "BRUNDLE.WAD",        "2b5629baa9dae8ec464d059b5b0a4b49" },
    { "BSB.WAD",            "60ccb513ebb06d23fc0974f269316fcf" },
    { "BUGGER.WAD",         "f9ba664bee671a85a11d6db9d4d7e0a6" },
    { "BUGGER95.WAD",       "671e0888d9245b9511fa132a9a27122f" },
    { "BUILDING.WAD",       "ebbf0c5d14e5e971754e337c4080d44e" },
    { "BULLA.WAD",          "5ed35c99a15d74272df6b170d050e85f" },
    { "BUNGALOW.WAD",       "5c58559d6e0ddda8e45d9aec80e49ec6" },
    { "BUNKA.WAD",          "00156363c2e68d44456f547ca5323cca" },
    { "BUNKER.WAD",         "212c1cca6c8bdd156902bd638d10599c" },
    { "BUNNINGS.WAD",       "72cc09ec4b77bf9d848d868af7bf437c" },
    { "BURLBASE.WAD",       "9915fb57f43d0572022bf1d69539b9c3" },
    { "BURNER.WAD",         "af9688f5a3f94202fc70fc56e4d1c5e2" },
    { "BUTT.WAD",           "25ae2f3339485c632b4687a8e3a81c20" },
    { "BUTT.WAD",           "94cd960ce69efe74feb153a0932c3a21" },
    { "BUTTV2.WAD",         "e7f8a1c24dcc125e1bb7e1a34de60d85" },
    { "BWALLS.WAD",         "8760fe2a146af0591df3e1a7b2735f58" },
    { "B_RISK.WAD",         "1cdc9effd60ea0675a9a236abf846f6d" },
    { "CADET.WAD",          "f7f8d7dff97bbafdc87461484633ed1c" },
    { "CALGON.WAD",         "808836404dee80644fee6ff3c0785ab0" },
    { "CALLISTO.WAD",       "fbac123dcd16767a6ef35013038f0701" },
    { "CANYON.WAD",         "908ba37792188b11cec2299ee1eefe50" },
    { "CARDIAC.WAD",        "351bd5a95be90c4a6c1333ad67730250" },
    { "CARE.WAD",           "38fa29ed638f504917adf30a7995acdc" },
    { "CARL.WAD",           "fa28977917f642a55a421d1a807d80df" },
    { "CARNAGE.WAD",        "a213e67acb6c39b639a9d464c4c9959d" },
    { "CARNAGE.WAD",        "e49569990f9636cf05c65af450e2e0a6" },
    { "CARREG.WAD",         "0e546d6af41ede7e2abc97c9d0021016" },
    { "CART.WAD",           "c3b9c31b0463d0cccd0adea9e2ff9f75" },
    { "CAS86.WAD",          "401d5e9c1231bc9c612bbe4dadbff100" },
    { "CASAD1.WAD",         "634dc75e77dd6fe3d6b8ecafa4a012b6" },
    { "CASE.WAD",           "6050ecb77b6cdc958ee272b1a2c50f82" },
    { "CASLOTR.WAD",        "8d5ad83f14f78754d4ab24d22c8f74e0" },
    { "CASTEVIL.WAD",       "dae656f8460200633c534ead9cd63e76" },
    { "CASTLE.WAD",         "fb7c0c8059bd84b888ffa864cbf72f29" },
    { "CASTLE01.WAD",       "24e41627a893094d75399a4fddcf70be" },
    { "CASTLE5.WAD",        "0c15d9745cdf1c0c0c30cc3a5a56e21f" },
    { "CASTLEM.WAD",        "2965928d64190e5fefeb573cd5caf980" },
    { "CATACOMB.WAD",       "68d0ba0bbab94c0a270c008a481f6e2f" },
    { "CATAST.WAD",         "d5f18587f4c4daf0b34d55ebc1cc78c3" },
    { "CATHY.WAD",          "274acc83b8481fa4eb8ed873b652c015" },
    { "CATWALKS.WAD",       "eaa0bba2cf525f3ab5319afd510c6faa" },
    { "CAVE.WAD",           "9c98dc2dbd9e70d8587f152df2a3b311" },
    { "CAVERN.WAD",         "bddf119dba2024f48dd8b96627e0c02e" },
    { "CAVERN4.WAD",        "75b802b4dc29ed7c62b1e24f4223107b" },
    { "CAVERNS.WAD",        "1a41b1d9eac28803044e453bf17bf4a2" },
    { "CAVLAB11.WAD",       "715e9733015f14ddbe1c345dc6728b7d" },
    { "CBCMAIN.WAD",        "2e65345af328224b3e130ebb586b77d2" },
    { "CBCSND.WAD",         "b222f5c0aeea0b7a530c4474e8f46ff9" },
    { "CBCSTG.WAD",         "c389cdb51de33de86306bcb32851a126" },
    { "CELESTE.WAD",        "1cd18a8531e245d4e86af3a422141b07" },
    { "CEMENT.WAD",         "4d73ff5b5b6085d733f2f630379dd91b" },
    { "CERBERUS.WAD",       "4ba44a2d4e9dc262f87164030d9b8bf7" },
    { "CHALLENG.WAD",       "a48599453be8aeb1077d84dc03cd1c7c" },
    { "CHANESAW.WAD",       "dc223fcabb013321ee5040acc57e0ee5" },
    { "CHAOS.WAD",          "87d49f0b802983b2c06062be3a2b7e55" },
    { "CHAOS3.WAD",         "f127d417b37ebfa7fc146ca8ad071013" },
    { "CHASE.WAD",          "cc331cf3a7809a56d3ef285d57d99556" },
    { "CHASE21A.WAD",       "c80e84ee28cd96710bb0a84e3be01ba5" },
    { "CHASEME.WAD",        "c29f892d19e4b0fe46cb71facf667edf" },
    { "CHASM.WAD",          "78dde51a1d459080c92138c5f4a44fa9" },
    { "CHECK2.WAD",         "b33184145e1fedc44a72cb5f5e5b54a5" },
    { "CHEMPLNT.WAD",       "c1f6b1555fe73e899d756f6e0f0cb9b8" },
    { "CHEQUERS.WAD",       "948275ea4dd72989a4d9e5b7cd124949" },
    { "CHESS.WAD",          "3b1c53385f1d11dc2230391bf3c760b8" },
    { "CHESTER.WAD",        "98ea4b2b47287558ec6b6b46822ab81b" },
    { "CHETRN1.WAD",        "fc83db8f1186b517b0f5dd7070e4fcd4" },
    { "CHICKEN.WAD",        "0b2c57e8701e25f281b2087cad01c58b" },
    { "CHODE.WAD",          "d7893209940509398437e411edeb0e77" },
    { "CHOICES.WAD",        "5e72c85328e65171c3fcf5dd125ce32d" },
    { "CHOPPAS.WAD",        "d6381459163507e6a0c81db442a3347b" },
    { "CHRIS.WAD",          "b5e8e61829638f799d44ff9d9bebe2a7" },
    { "CHRISK.WAD",         "128737fb278a9ddd4895dd992e774676" },
    { "CHRIS_E1.WAD",       "4dae11fd76f07ec40a5813344eddfa1c" },
    { "CHUMP.WAD",          "42bd5091a5ff8249670f2599c8e50e1f" },
    { "CHURCH.WAD",         "5db5f2e7e5216ede456e1b6eacd09718" },
    { "CIRCLE.WAD",         "99811c1afd1e3c6a90d33abf9aff55ea" },
    { "CIRCUS.WAD",         "0f64b6424c8891177dbc35ceb5827c5b" },
    { "CISTERN.WAD",        "7b5a6b43c77d104f05a0c0c7a0bd1b31" },
    { "CITADEL.WAD",        "78b75fa91869cc5c4a63e21d3c7ce97c" },
    { "CITYLFIX.WAD",       "5f37ee3a42eca8b524ce277f5182be7b" },
    { "CITYLIFE.WAD",       "7ede1e8ab4766721053b784b1b67a1bc" },
    { "CLACK.WAD",          "b2c3f54566f78ff388da050645dd08b1" },
    { "CLAFLIN.WAD",        "8ff1cff2a5d907487a32ebe44c9f907c" },
    { "CLASH.WAD",          "d29523aaa09eeb892e35731688cf493f" },
    { "CLASSIC.WAD",        "d8647e0589783455c20781fd63d51865" },
    { "CLASSIC1.WAD",       "e0d020a8c499755f4cbd2f056fb3337b" },
    { "CLASSIC10.WAD",      "97f7dcc7d583bee84520c51bf82c3ed9" },
    { "CLASSIC10B.WAD",     "6334bac086f1e5d430c5b40745cf2ca1" },
    { "CLASSIC11.WAD",      "054240aad61c479c3383134243d4c8b6" },
    { "CLASSIC2.WAD",       "45cabd80561689b62a1211e80fcfbb76" },
    { "CLASSIC3.WAD",       "7a5d277e28ca09ac61143b2e72c1c24d" },
    { "CLASSIC4.WAD",       "77c939efc0948b05b13598979743d68f" },
    { "CLASSIC5.WAD",       "00f0ec0e6fb297bb61deee3a65da1bc6" },
    { "CLASSIC6.WAD",       "2bad5b91eed9b14c92d8d9560a856336" },
    { "CLASSIC7.WAD",       "9acec0910e55ab1446c92185694e0ad5" },
    { "CLASS_EP.WAD",       "8fbb3eacc269e45c9e949d2cbeceec62" },
    { "CLAUS_01.WAD",       "5029c9a73afeaea64ec69e0781280252" },
    { "CLAUS_02.WAD",       "d0116fe268c035a088148c0fbac62d20" },
    { "CLAUS_03.WAD",       "3ae83fd8f1439a3a8a342babdd98f5e8" },
    { "CLDF1.WAD",          "b23d855b6abc1efac50a20e5b5a69318" },
    { "CLEIM10.WAD",        "beced3b6c213065857b1ea36bd43d3c9" },
    { "CLIFF.WAD",          "20aaf8578d20a8258a0cdbcb0bdad663" },
    { "CLIFFS11.WAD",       "6b986432eb1fd409aa1013a3fd9f92c1" },
    { "CLP.WAD",            "f450c4ddb08e0130c5202d5669d7d5a8" },
    { "CMORTIS.WAD",        "8f41d5f624db647ceb6a5c4a234d158b" },
    { "CNFUSION.WAD",       "27ba19db391851eae0b14e11f6e32cc4" },
    { "COAK.WAD",           "2809954488d5e56d5b5382b9e4d88b57" },
    { "COCOHEAD.WAD",       "cea3dcb426998fc1f877886e886a3600" },
    { "COD2.WAD",           "9ac164a61fa977e23965d8ddd61a64e5" },
    { "COFD.WAD",           "9483b1e6151524647972b27c0733c38d" },
    { "COFDS.WAD",          "48317278f38af0fde5802c51148fe926" },
    { "COFFIN.WAD",         "2efdf49e111b82c65c01f4948f0f3026" },
    { "COLONY_1.WAD",       "903b68eb9250f0307d1fa93710c20524" },
    { "COMBAT.WAD",         "bdbe02915a581ff3ad645420f7f6f046" },
    { "COMBATZ.WAD",        "83ae7b905475ce424b15989374efb317" },
    { "COMBAT_2.WAD",       "ae71f571d4f5a69cd8a6633f6f346fab" },
    { "COMCON.WAD",         "a93329aeae2d022c02c67882df35112b" },
    { "COMP.WAD",           "898e0c8d8c5c764bd100f9269ee9ee82" },
    { "COMPBASE.WAD",       "dbf5a5e5cf02ac6794d0a715f03731b4" },
    { "COMPCORE.WAD",       "2f0ee9dcc189e11d82b11da405c800dd" },
    { "COMPLEX.WAD",        "67baf7444342032fa6a15e44530a9e3d" },
    { "COMPROOM.WAD",       "ed4491db4cad66e395aaa016b21c432e" },
    { "COMRADES.WAD",       "84fe2cc0c34adfa8f152675fc71d9144" },
    { "CONNEX.WAD",         "5f48853819a17469912a18d95f35ee22" },
    { "CONQUER.WAD",        "914a46662a1b1757abe82c01eb5dcae4" },
    { "CONQUEST.WAD",       "217450fa8303bb73b11d5c4d9a7ffedf" },
    { "CONTAM.WAD",         "0e7b707ac648eb5f248d18cd9e10cd13" },
    { "CONVERTM.WAD",       "15973152ef8a084b52efcfe8383010db" },
    { "COOL.WAD",           "64319d8f348c2251e2b8bb34f0e0277c" },
    { "COOLDOOM.WAD",       "786f52be69ef9d9c8b76a4085c3d7c22" },
    { "COOPERS.WAD",        "0cd6b91624172b6df04a896ae6927f81" },
    { "COR81.WAD",          "96e54b096369e30561b83328910ab3fd" },
    { "CORE.WAD",           "ed43bd066e309a14f782dbcdfc03490f" },
    { "CORN.WAD",           "20f2736b2a6e471fb61b4ad64ae123c5" },
    { "CORR2.WAD",          "e2cbe02e97e2e5b7e85b5783a65c8d16" },
    { "CORTYARD.WAD",       "ea8bfd61b919955411f0f173da8e2d38" },
    { "CORTYR_B.WAD",       "18f7a75a0bcd59dbd4960a8fbda117ac" },
    { "COWARD.WAD",         "05954eb49ead4a67d2c0e1725c67102a" },
    { "CPDEMO16.WAD",       "0f977b47e7d98b9c58d2dd195e3765a0" },
    { "CPHOBOS.WAD",        "db3027216eaec033e2f8135d05dba855" },
    { "CPHOBOS2.WAD",       "fab13b2c31ba950560ba5fa73fdf1d30" },
    { "CPHOBOS3.WAD",       "887dc2cbc7193cd0f324a5603238ed8e" },
    { "CPM11.WAD",          "07b6a28e201d8df339cc4894d672e6ec" },
    { "CPUNCH.WAD",         "a3e26d8ef572c3d7a37013556d1b6cae" },
    { "CRAP.WAD",           "184355b4aa2253ca4b8c00e0d2e8c1bc" },
    { "CRAP115.WAD",        "679d2565b8d251ed9574f7082c4509a5" },
    { "CRASH.WAD",          "9340d25f16a3c034ca5ed320e5a4dad7" },
    { "CRATER.WAD",         "5113942cd49f7640df49a7918df06be6" },
    { "CREEPY.WAD",         "a6ccd48ba88f020d9ed198caca038701" },
    { "CRESCENT.WAD",       "88c79764a030aa8b8fb19ff62bec9d9f" },
    { "CRIMKEEP.WAD",       "6114dd569e12ee6662e9ce8fbdb2303b" },
    { "CRING666.WAD",       "b0088e5890f17e3dd2b223a346fef549" },
    { "CROSFR01.WAD",       "53c39f0acd108db082c408657913b365" },
    { "CROSS.WAD",          "6c8d152f608f430b09db0737c06e43cc" },
    { "CROSS.WAD",          "761aaaa8681bb23f5d5bfcaef93a93ff" },
    { "CROSST.WAD",         "645112f3eb9b14d85389145d5dd7b7fc" },
    { "CRULHELL.WAD",       "c2f1b11216a4e4ede0859b24ac44ee64" },
    { "CRUSADES.WAD",       "fbbbc2ed7e28b6cdba1b4dc7c6b38a2c" },
    { "CRUSHER.WAD",        "6d3f0fbe15fcf0def694ea5914d9a8df" },
    { "CRYPT.WAD",          "d2ca6da5492ab53ec942a06725e02cfd" },
    { "CSTLDOOM.WAD",       "62a159a26e46b54af2c928520549cee5" },
    { "CTRL57_1.WAD",       "ec9ea1f590a44defb7797eaf5b475871" },
    { "CUE.WAD",            "eeaba581e104ca26b2191690860de9c9" },
    { "CUIT.WAD",           "46a0a2f9798454abad22a76b5ddf6ce9" },
    { "CWAVE.WAD",          "2887f5eed82b62f23817e17282143427" },
    { "CWWAD.WAD",          "43aa888d98247b0a090edf950812fb45" },
    { "CYBERPIT.WAD",       "5904f1d3211e92df77ec54dc0b0703f3" },
    { "CYBLAIR1.WAD",       "a6fcd66ab65b09fe2d89c177342a7966" },
    { "CYBLAIR2.WAD",       "c99d17eafdeb89aa67795f0d3ab356ce" },
    { "CYBOKILL.WAD",       "ea70e22d285ccc3b2e6dfe2c43540914" },
    { "CYBRDETH.WAD",       "3d790e50b99688f4f8efdbfcffeaccf8" },
    { "CYBRDICK.WAD",       "de7d876b17bff762e0bc7eda10039a46" },
    { "CYKE.WAD",           "cf07c0b0eb4a8113ab939a1bb01bbb0e" },
    { "CYRC.WAD",           "6917fb547eeeb1466253ee15ed080a4e" },
    { "CYRIL2.WAD",         "82ea51d317e60ba3aad1e5e1e99ec520" },
    { "C_W.WAD",            "db227231f16ea0f8eedffff17fa3b6fe" },
    { "D!NEWCSL.WAD",       "82d13b2bf374791d758ec69e996af288" },
    { "D4A.WAD",            "1f87ba630bd08b1dd84e8be6f0109be2" },
    { "D4B.WAD",            "b03b56c1c1febfaaa652350474af9d9b" },
    { "D4E1M3.WAD",         "fddd63f422b9b33a5b42f880a21b4aaf" },
    { "D9.WAD",             "8e0bacf54c16c4ca467349be05a9d3c6" },
    { "DAETHBY.WAD",        "dd0f785708a7e6a64bf902b4104b7b77" },
    { "DAFFIE.WAD",         "df6ccbe3245d2aab9a6c8ebc64a88c68" },
    { "DAKILLS.WAD",        "ddf954b5f97645007594e78b45451e3b" },
    { "DAMN.WAD",           "e95d36fb88ab3c512a80598fb7f82d3a" },
    { "DAMNED.WAD",         "8b9385d437608f36e6046023f78ce594" },
    { "DANCDETH.WAD",       "e1e1d3adc117ade8f5d1b632e30ba9d2" },
    { "DANDETH2.WAD",       "6ab0e9d8c79f1ff8c579caacbbabdb03" },
    { "DANGERS.WAD",        "b44e423d41cc316828f894a7201ba1ce" },
    { "DANTE12.WAD",        "63a27d232cdfebac3ddd3a6c3fd36067" },
    { "DANTE666.WAD",       "6e009647cfacff660fcdcabfe9432f7f" },
    { "DARE.WAD",           "8b7783e698eb0a7243daf885497bfb8c" },
    { "DARENA.WAD",         "599fb542f1e20ac65a38daa9834e00c7" },
    { "DARK.WAD",           "5cf36c0d58ba7e0eda8aa962669e1de0" },
    { "DARK20.WAD",         "c05240b635d704d945d52c1f5d92de95" },
    { "DARK20II.WAD",       "3b551ae2f7959e74a390a3293dd1af77" },
    { "DARKAGE3.WAD",       "38714a8b052537b6b060573331b9e7d4" },
    { "DARKDM.WAD",         "5bb7ebce8bcbf39f13c05080021fb1c9" },
    { "DARKGATE.WAD",       "3e8d1346ce51aae1180b3505dbc03ef7" },
    { "DARKHELL.WAD",       "e4f7fc9eb9440ac72333b4005d70e46c" },
    { "DARKWAD.WAD",        "5dddfd8898c9b673b3b00d829edfa29a" },
    { "DAVE.WAD",           "44dc904070fcefdbc7eb2b962f6ec05d" },
    { "DAVE1.WAD",          "7aed420fe4f27acb47875c74ac8c7175" },
    { "DAVE2.WAD",          "5fe07aefe38318b403431dd0ae34432d" },
    { "DAVE3.WAD",          "b8f47759683ed9ac6b6701f91517875a" },
    { "DAVES2ND.WAD",       "c8f5aa61b16c51a91176cfe832bc7ffe" },
    { "DAVID2.WAD",         "8644cbe4968c79902aa09e23fd85a9c3" },
    { "DB-E2M1.WAD",        "e06cd12e9ea6d8bc187ed325b93a0f4f" },
    { "DB-E2M2.WAD",        "4b379acfae898a85a789155e125af5f0" },
    { "DB-E2M3.WAD",        "f3032163002be4c9413cf151208df524" },
    { "DB-E2M4.WAD",        "bb1861272c8e17b73c9a127db4a5173b" },
    { "DB10.WAD",           "d60b72853811755c7575d7412f9bade2" },
    { "DBASE.WAD",          "6dd1e1bde8d60966957ea85cf0a01e11" },
    { "DBLCROSS.WAD",       "e3764c858343a3022d42dd8e7bc9e83c" },
    { "DBUILDK.WAD",        "5cf87afa1a3789055e4f393b66b04df1" },
    { "DB_OPOST.WAD",       "ab6a23e2bee15a0063ca9864ee7d41d1" },
    { "DB_PCC.WAD",         "280a9c86e4f36d4e52450d6669239268" },
    { "DB_PPS.WAD",         "ce2d15d6cb402451a28e23fa40b17ec6" },
    { "DC.WAD",             "823c3d8e83d553f17ccf8bcff120e761" },
    { "DCAT.WAD",           "a576a366de7e910280a74d752b14205b" },
    { "DD1.WAD",            "1f8d895a971a1872cb240e84c90b95d4" },
    { "DD11D1.WAD",         "9bf74a0ec5326721cb8f37241a7a25db" },
    { "DDMATCH.WAD",        "cbd17585b361007bc31cd8a130195cfc" },
    { "DDS1.WAD",           "285ccada31c4e38b1acf209b9530e51e" },
    { "DE2106.WAD",         "315c7ffc771762465f60ac5763cdac2f" },
    { "DEADBASE.WAD",       "700b73e49b9c0578e3515565478b1298" },
    { "DEADLY.WAD",         "188abc4ba932e0306d7183aead201072" },
    { "DEADMAN1.WAD",       "fdac6b21aa3a02a03da3a9c38f988db5" },
    { "DEADSHRI.WAD",       "2a64b3586696d0f9e0aaf04d70bb25bc" },
    { "DEADZONE.WAD",       "0f380a842bbb67785931154e258bec08" },
    { "DEATH.WAD",          "07b171632c884323be6ce4ed6f4a19d9" },
    { "DEATH1.WAD",         "b34aa7a3a726ffccc1feea874f58bd78" },
    { "DEATH3.WAD",         "97d43b6e13d93226ebef45ee8d2ddb45" },
    { "DEATHDAY.WAD",       "167eeaf4751425defe4e56087c223c2e" },
    { "DEATHME.WAD",        "4e3f93b2be568084a850bb310fd26c35" },
    { "DEBUT.WAD",          "2c965f1f8d42bdb67ff5fd19bf3a5962" },
    { "DEBUTMUS.WAD",       "08c72d8258da4db874e37dee72b22e27" },
    { "DEEPCRE.WAD",        "d3d0b46fb98ba3de614a3f4a22af74e8" },
    { "DEEPS.WAD",          "d37615f4e694501e1691f4f4e215010f" },
    { "DEEPSHIT.WAD",       "336ba1a1e16045b3a301407d390d4348" },
    { "DEGENRTE.WAD",       "887a2390f113c4ff574882f2fcd6d2d3" },
    { "DEIMOSCC.WAD",       "80887deb3e587e82a7f58c621f72db7f" },
    { "DEM.WAD",            "9153b93f0aefb65081733a270cb8703b" },
    { "DEMONS!S.WAD",       "233cb63fdd6fab4b03d5c8e3862a3c45" },
    { "DEPTHS.WAD",         "3492fd3ce049fadfce460112b2bdf2c6" },
    { "DESPAIR.WAD",        "9f6616f80ca7ef0e0475f2a1d1c1fd22" },
    { "DESTINY1.WAD",       "4b4b6881b7d3fa59f9e8e3aefa355c23" },
    { "DESTRCT.WAD",        "9a48af18217eed46b7ac12da5d4285c7" },
    { "DESTROY.WAD",        "d1718ac3f5dc52c39572b690bf16b321" },
    { "DETH1.WAD",          "7f4d00aad987a93cc78a6dbcefa27747" },
    { "DETH2.WAD",          "ace14ab505fdad319ca30ea022445c48" },
    { "DETHARNA.WAD",       "6e2cbe90caeafc5e7d45bb45098c457e" },
    { "DETHDAY2.WAD",       "aeff34209bb5c1a4ddfc7905d9e20234" },
    { "DETHDAY3.WAD",       "882a582dd8eaa4fec76a955c3e2403f1" },
    { "DETHDOOR.WAD",       "9e32ead8d594a6f3936311c69f944371" },
    { "DETHE1M1.WAD",       "45995dadb640e84e02cbaf632b2f5b43" },
    { "DETHE2M2.WAD",       "f99cd12ee15c4978da1dbd35d63d6fdb" },
    { "DETHFACT.WAD",       "502cf927ace23026e49af35721df268f" },
    { "DETHFLOW.WAD",       "46cf67678d667fa1ad5ac45f7419334d" },
    { "DETHMAZE.WAD",       "1768d3affd84fff534b02886733e35ff" },
    { "DETHPOND.WAD",       "56ced92796bda918976f4bb23fada506" },
    { "DETHSTAR.WAD",       "77bb05736f60414975bf1f7e9b15bd70" },
    { "DETHWALK.WAD",       "1b1ffa76632cc7715f57614fd005c818" },
    { "DEUL.WAD",           "4650044badaca5479a84681bf9f96057" },
    { "DEUM.WAD",           "aa35a66323102e8def1bbd01cb1cf35d" },
    { "DEUS.WAD",           "75ecfa5921f40d14c5aac57c14e77815" },
    { "DEVIL.WAD",          "371268436f724c565a7dcfe94265aadc" },
    { "DEVINC.WAD",         "13351e8d98bfeffa89a4d24b2ab54ad2" },
    { "DFIELD.WAD",         "44478d276819cb6c6bbe6232cd3f7746" },
    { "DFOR2.WAD",          "589f5f48cb0009f40a6d1135b9232ee7" },
    { "DIAMOND1.WAD",       "c6a8bbfd754f883355379a4a81cd6501" },
    { "DIAMOND2.WAD",       "d8eb097da5ca4a46c0c0ab89cf866d14" },
    { "DICKWAD.WAD",        "7806a0a1ed7bf3c9cdec443dfdc81985" },
    { "DIEFAST.WAD",        "fa316c357869e7ce744718d45b275b23" },
    { "DIESCUM.WAD",        "8cb87fec6cf25046464b8e6e31961bae" },
    { "DIETDOOM.WAD",       "91aa50eb02674eda6ce45d70085630cd" },
    { "DIETRYIN.WAD",       "b245e8d08feb014d01e635dcdfde07df" },
    { "DILL.WAD",           "90b8ef6ae2f62ee34c97b5eae8055399" },
    { "DILWEED2.WAD",       "20805800eeabbcb680f23e940f0f2701" },
    { "DIMGATE.WAD",        "db110773ca66ffa4a32bae76daa341a4" },
    { "DINNER.WAD",         "3e1b85be87d453cf5ac9861156667fc7" },
    { "DIOPATRA.WAD",       "b7607a32a36322fac729001024747743" },
    { "DIRTYTRK.WAD",       "2cd3c7f06d7a9d7c262141683f4ef477" },
    { "DIS.WAD",            "4ca083a3c041932fabedec079adb4d01" },
    { "DISGRUN5.WAD",       "33c344b2476e0990f38168ea76c8cafb" },
    { "DISGSPR.WAD",        "d648d13f4f236074de27f67a480b0a8a" },
    { "DISPLAY.WAD",        "8c7ec52321520aadb709b8ca071690c3" },
    { "DISTORT.WAD",        "47ed0c4c47e6c3838664e88ecb1e5c67" },
    { "DIVA.WAD",           "11a244ef913ce79fc5cf504af016383d" },
    { "DIVIDE.WAD",         "949d2916b238ea7ceae442fbacb608f1" },
    { "DIVORCE.WAD",        "b9d0971995fcd78dc518c71f250b115f" },
    { "DJW11.WAD",          "faa820c7265fef20a721512db81dab26" },
    { "DKS-E1L1.WAD",       "31a7b6a07be3e762b974cfe5ee63eaec" },
    { "DKS-E1L3.WAD",       "4b69bcc42940a1fcad46007e61adeea0" },
    { "DLTFUL1.WAD",        "e190553236caa12ddd9c82cc56276964" },
    { "DL_ALLEY.WAD",       "5d31227c28c404ddc5c97e75c880f17f" },
    { "DL_BOX.WAD",         "5e8b6acfa9005315ff91d7c9bba4ce56" },
    { "DL_DARK.WAD",        "b672b21c653d9a04b71c4a282800c1c7" },
    { "DL_DRILL.WAD",       "30c922befb6149b1ceafae105649a9cb" },
    { "DL_DTOWN.WAD",       "125e0976cf0eb2a416a8a09cec83d52b" },
    { "DL_NUTEK.WAD",       "9aaf1d0c093ce0ed3e7b289a989399be" },
    { "DL_POLAR.WAD",       "31ae571e2b9699d8dd8dd77809732c95" },
    { "DL_SHADE.WAD",       "5ed6f8ce11f7042266c3fb936fddd8f6" },
    { "DL_STONE.WAD",       "4c017bb3a0a34f28b1fe4c14cfacba28" },
    { "DL_UFO.WAD",         "c39c840d4737df247e0b7eafe0e85a75" },
    { "DL_WOOD.WAD",        "b6350ea02681f6fdc00db999a5d2f2b4" },
    { "DMAFTER.WAD",        "6f5bf7e943f20308c2898d88d4f4ee2a" },
    { "DMANMLY.WAD",        "1e30a519d6478a83393d9e8a2e19a0e3" },
    { "DMARENA1.WAD",       "c5db25dfcce868e1860b0661e1e4ef96" },
    { "DMAT4.WAD",          "a9adc8d3856aabee0768644c1b239ff0" },
    { "DMATCH1.WAD",        "04b960805d11a754b27854adf40e613d" },
    { "DMAZE.WAD",          "9d7db8001f97658f03f49b8b3b23aded" },
    { "DMBBATH.WAD",        "a71003eef222edda665bae9b83ce3b80" },
    { "DMBOX.WAD",          "6b2463de46e411ef626e29eed6976c0e" },
    { "DMCARN.WAD",         "9996239099d28778927ce9cea9d5121b" },
    { "DMCATH24.WAD",       "ba4100437bb43f7dc75a78b1bdebf910" },
    { "DMCHAMB.WAD",        "68d27688e76bf484ce1fc3b77e47f9ef" },
    { "DMCHAMB2.WAD",       "610a27a6a86084b57b28c8636cf48c81" },
    { "DMCHAMB3.WAD",       "2ae6a0c7b2a56551fe7b565e8422066e" },
    { "DMDTH16.WAD",        "bf525e279c36dd2ed4c58a149b40f0a2" },
    { "DMDV.WAD",           "daae30161725e6697afa40c73e6f2a42" },
    { "DMEXPO.WAD",         "78dccb95c6a54fdee70740333d48e6e3" },
    { "DMFRED.WAD",         "5819a2e44086885672cd2e8c5efef01e" },
    { "DMGWAR.WAD",         "aac1b3c607fdb92d0966aeb23b378fb0" },
    { "DMHIGH.WAD",         "fbfaac052ec65b8a1e89bbd440cb3716" },
    { "DMHQ.WAD",           "9459bd91dadb8bb398a0201c493c22b4" },
    { "DMJH1.WAD",          "2914e9a2de98637fa699977ed5246bdd" },
    { "DMJH2.WAD",          "69a1161d6942fdad806895949b03f18f" },
    { "DMJON.WAD",          "1a71a2ed64c7a8b2c531510366f07e4e" },
    { "DMKART.WAD",         "79026ad097bf36fbfa621339c476be8e" },
    { "DMKEEP.WAD",         "239a639e034f1772ec551234f6f8279a" },
    { "DMLAMOU1.WAD",       "b7309a5c685979573c821d18f1c13097" },
    { "DMLAMOU2.WAD",       "f7a94c3af60a430ae06178d6f34bb37c" },
    { "DMLAW.WAD",          "be525dafdf4d90525c40fc5aa67a6e42" },
    { "DMMARS.WAD",         "83222c8427e3a8ff7797a295a683554b" },
    { "DMMISI.WAD",         "e55ec3a5a5d3b67421c31ef677fc8a92" },
    { "DMNG8.WAD",          "e94e858e7e6e63df8c65fa73c9129568" },
    { "DMPITS.WAD",         "bba6ce984a5bd338a3b572a28ee7f28f" },
    { "DMPLYLND.WAD",       "afeb35aa889f2848808427fa6cac222a" },
    { "DMPRTL.WAD",         "e8293d21fe4f1de5e01dda7f0bc39b11" },
    { "DMPURGE.WAD",        "ba3a2cc66cbd513ae3c8301a3e249127" },
    { "DMQUICK.WAD",        "ddc81864824963f56a35c13c1ee7a6cb" },
    { "DMSEWER.WAD",        "b62ccd19a6d4ef9a202c4173ad180c44" },
    { "DMSFG.WAD",          "d17d2065d5e6c6e2a13ecca84ff72a2e" },
    { "DMSOF.WAD",          "564301d2fd27c0a73b05763551684462" },
    { "DMTEXAS1.WAD",       "1e3abb794245e8adf6e3a4373aec6318" },
    { "DMTURM.WAD",         "2cc3189615e0525dac8f850762b90f01" },
    { "DMWARG.WAD",         "f9689f703ce5793cfcab021ceff7b022" },
    { "DMZOO.WAD",          "3b210561283ae89c92ee47b6ffad0b1b" },
    { "DM_ALPHA.WAD",       "ac3f39efe8bf94f6f989500aeb14dd90" },
    { "DM_FLEUR.WAD",       "a0e1538421c6e00683f2755743901560" },
    { "DM_TPA_1.WAD",       "a4a04881aff83d3baeeae169bd47bc91" },
    { "DOA-11.WAD",         "3b00372218ad64f6d6604fc598c09e17" },
    { "DOA-12.WAD",         "9d19529a58e9d567f27625f80bdb5a87" },
    { "DOA1-1.WAD",         "88289b00bbae6ddfb9638d44decfb559" },
    { "DOA1-2.WAD",         "c4ab7bf4716148ed1c5df596b6674387" },
    { "DODEAD.WAD",         "f7712c24e229190d67d1af882f8ddef9" },
    { "DODGE.WAD",          "e5ed9f11be6f56b5fb84d7a2a531a36a" },
    { "DODMUSIC.WAD",       "24d373d128aa1c599e14edaa5d72de2e" },
    { "DOMAIN.WAD",         "8a9973dc334484cf890d2571b831ee96" },
    { "DOOM-PIT.WAD",       "833acc5798f88ff828b8382fdb7b9cea" },
    { "DOOM1-3.WAD",        "4dfbf5cf8605fbdd07526079b9c6d601" },
    { "DOOM4-6.WAD",        "8ae7e56d528331fd739292119cc5df3e" },
    { "DOOMAWSM.WAD",       "5f3600d768c888cbce6117b1ac9a4420" },
    { "DOOMCAS.WAD",        "3df5c24668acb08feb8dacb3f440dccf" },
    { "DOOMONAS.WAD",       "bc2d75835d2da38f050af8e3a821395c" },
    { "DOOMPOOL.WAD",       "17f76bfe8698d9d3a016f6a2b7a6d58c" },
    { "DOOMSDAY.WAD",       "46baa09924aef8c0611a7c53da1f734d" },
    { "DOOMTOWN.WAD",       "370dbe514a7f63b10a5aa95c58aa192c" },
    { "DOOMTRK1.WAD",       "ad6d7ba8e3c5f0b1c68cc563c304940d" },
    { "DOOR2HEL.WAD",       "07117a902b8138aca67d5ae7d6575292" },
    { "DOORS.WAD",          "dfa161a294ec4fc97cc881aaa540c341" },
    { "DORK.WAD",           "802afda9d18aacdaa191cc92d0add447" },
    { "DOTHTIMP.WAD",       "46aac977d2547e96b40745cd368607d8" },
    { "DOUGH1.WAD",         "a5bbf6fb69fc1d02195f720b15b0ac10" },
    { "DOWN.WAD",           "55a8de7ef213963da3e41e9c91f84b2b" },
    { "DPRISON.WAD",        "ef5a7daf388b60f77fe23ecc9b3436d6" },
    { "DRACO1.WAD",         "9eea178029461029b3ec91c28eebbb64" },
    { "DRACO2.WAD",         "ce47d67ca0bfda1a0d17e76c045d0a26" },
    { "DRAGON12.WAD",       "86718b95aaa6965233c7437429115328" },
    { "DRDEATH1.WAD",       "b752e0e52bc18d577da35b5286f436d7" },
    { "DRDOOM11.WAD",       "8a7510e710065edfdcfd717f5d048b6d" },
    { "DRKSTAIR.WAD",       "6d0b7486d8a35c4798c8a2cd9c9e1069" },
    { "DRKWRLD1.WAD",       "0341d6e12551d1f0517e7405bb47744c" },
    { "DRTYHARY.WAD",       "fc8bea35d6555a231d57a7ddfd3aba90" },
    { "DRUG_ME.WAD",        "16e69ab89d95b913c666e8f35c16873e" },
    { "DRURY.WAD",          "c4c043586a3e75e44a0dcf595dcc69c4" },
    { "DS1V3I.WAD",         "8c1a0b37568868c739aacf8e9325378b" },
    { "DS1V3II.WAD",        "184f04f22c32610094ef35f62017949f" },
    { "DS2V1I.WAD",         "726ed0555f6165ca5f4a438fc77c7cf5" },
    { "DS2V1II.WAD",        "5551e0a2005b1ef1c29cd0a05cd7c099" },
    { "DSE1L4X.WAD",        "ea05289331190da101f4cd974ef2710a" },
    { "DSGRP1I.WAD",        "6564ec4c9bd4f5bb24bbbf350b64341a" },
    { "DSGRP1II.WAD",       "72ebe492add297c3ff55580aac3bc5be" },
    { "DSKULL.WAD",         "de5353584c87313e11f1d7464674a239" },
    { "DSPIRAL.WAD",        "820c08ec3bbd93574362d2b632607984" },
    { "DS_NEW.WAD",         "dc7ee7bf2d225f55155f565d5fa700b5" },
    { "DTEPIS3.WAD",        "d22ebeb0f7f0e18946775c33590e9be1" },
    { "DTH1.WAD",           "58806606c56e65109961cdf8636d6709" },
    { "DTHBOX.WAD",         "b1a6265cc1e4a0293ecf7b2baba062fc" },
    { "DTHFRABV.WAD",       "4d491e694dc2bb3f22757806c54bba7e" },
    { "DTHPARTY.WAD",       "2d97bcc0320590c68f7413ecd7b65e54" },
    { "DTHTRAP.WAD",        "7dd5b23e86a73a0feb4ca74f6c5dc17d" },
    { "DUCOIONI.WAD",       "e93a21e6d6346f42663fd704f54b757e" },
    { "DUEL.WAD",           "4650044badaca5479a84681bf9f96057" },
    { "DUNGEON1.WAD",       "a362ecc8f64078c267cd3b97c35e06eb" },
    { "DUO_1.WAD",          "b5f53792c9e66903d20756d05867013d" },
    { "DUPE.WAD",           "ccd6e97fdcef7bec22b6785ef461b858" },
    { "DUTCH.WAD",          "95bde2a0e6589d5131ac80b1bf741772" },
    { "DWARF1.WAD",         "7de96d4e71a121ed75858aa1a0d9e914" },
    { "DWHEEL.WAD",         "1b4c838007e1e55aa42181ffb187d901" },
    { "DXEM.WAD",           "512baa389867ad0e75adaf935fb0ca91" },
    { "DYAGHON.WAD",        "0cc28cae1100de799542409dbcb8aa38" },
    { "E1L1.WAD",           "9fb8ace9918525805c769399324efc2c" },
    { "E1L1KP.WAD",         "33c343a7aa7c3330d1c22a6dec6bc5e5" },
    { "E1L1RQ.WAD",         "5938c816caa576f36b8522ccda63ddd8" },
    { "E1L3.WAD",           "1358f9ad1db7bd8009901dcdc62a756a" },
    { "E1M1.WAD",           "638865f2d172b6916b1c4bcea0e5f9ff" },
    { "E1M1B.WAD",          "310efe883700b084a7bda9d0e55a8b0d" },
    { "E1M1SAS.WAD",        "3d6a2948107033fdeaf04000b3480d29" },
    { "E1M2.WAD",           "99165127d41e1520663fb75679f8a2f3" },
    { "E1M20010.WAD",       "605580a783fa4ed67fc8e270ffe00131" },
    { "E1M3BEN.WAD",        "5877b41c44ad83b62f9ae9626f80adad" },
    { "E1M4.WAD",           "affe2b4515c48b0c970841adda95082b" },
    { "E1M4BEN.WAD",        "58acb22c8118dd0459a4057d3a7a1666" },
    { "E1M5.WAD",           "b7f38d70fd341a8384fe5f1f0ff0c035" },
    { "E1M8.WAD",           "78d381b2fef35781d0393df129805d46" },
    { "E2GC.WAD",           "5b99339b1fd0595c3a36ebc316fd16fc" },
    { "E2L1BIN3.WAD",       "188e22be7d2a82b651aff24cc051047b" },
    { "E2M1ED.WAD",         "70e2052db22b79b25a288387696106af" },
    { "E2M1ER.WAD",         "82ca6fac59239e7744a0555b30981040" },
    { "E2M1_JOE.WAD",       "073b1809bbbafc9717553097187631d7" },
    { "E2M1_MT.WAD",        "185917fa2a27738faf24548e17f27b74" },
    { "E2M2.WAD",           "79edcfd356add51024c81c971ba472b2" },
    { "E2M2BCE.WAD",        "070430e483afc8e3201fffe6a9ad3a63" },
    { "E2M8.WAD",           "d247ebe3102be55d9e1e81abb3bea15f" },
    { "E2M9FIX.WAD",        "3afa9d8f237e924017b5f5fcb02fde73" },
    { "E3M1.WAD",           "78e848104744d93ce0597839afa2cdf8" },
    { "E3M1BEN.WAD",        "d64769fce70e85c3ce42a424dfd802bb" },
    { "E3M2.WAD",           "23e39de098af500ecdca6082c0b9a6ac" },
    { "E3M2BEN.WAD",        "c9049f9666c7f13f2fabec4ff46aed06" },
    { "E3M3.WAD",           "1b1abba524e233f8112b40c5872b44a1" },
    { "E3M4.WAD",           "861dc7f86ed14fce38d1c8820305ba27" },
    { "E3M5.WAD",           "9a1141f06c7a74eefd94ec7fbc7b6fa2" },
    { "E3M6.WAD",           "b63978d50159a5b6d8be19f3c29d5009" },
    { "E3MOONCM.WAD",       "dc358aa812bdfb50cc7ff8594d7f4c06" },
    { "EA-POE.WAD",         "eb2bbc3d6021467f2633b9a54a56b4da" },
    { "EARTHWAD.WAD",       "5925cdd43e8b078ce22110518d688e4d" },
    { "EDR1.WAD",           "55e52b044c95189e4f2f1ad47ec37586" },
    { "EDWARDO.WAD",        "5a0a90b2e26e9ba1cf716d2081f5a150" },
    { "EFBH11.WAD",         "8b27ae7228cbf6bdb4f5ac0124f25ed6" },
    { "EGYPT.WAD",          "401f85e73d440064aa56f7e1b6eed52d" },
    { "EHD11.WAD",          "8f0b8acc5a7c0b977178ea7aa0e19655" },
    { "EHD12.WAD",          "5af4e6898b5bbd80aca9a7c34b21673c" },
    { "EHD14.WAD",          "3ca01c2ea16ac9a39ada245140726380" },
    { "ELEMENTS.WAD",       "e77ef7fb493fa46b14cacfd40085e289" },
    { "ELFSTOMP.WAD",       "983090927f4cb280a6a16806167ffb5e" },
    { "ELROND.WAD",         "cb8b9a556395504cbc065ce3d8582907" },
    { "EMFHS.WAD",          "8da36aeb1e23c08d5a1388be5ccddc58" },
    { "EMPIRE1.WAD",        "cedfdfaf414e83326d53c6f16a09189f" },
    { "EMPIRE2.WAD",        "c797958cf291b89e0ae4be9e08002e39" },
    { "EMPIRE3.WAD",        "b3fc9e89e2c04b0df600b669dcd9b5ee" },
    { "EMPIRE4.WAD",        "9881d87fea9db8666c5d93044ac96f56" },
    { "END1.WAD",           "1a8be1769981816e8b107a974550ab93" },
    { "END_SND.WAD",        "f82ec5a08ee07c74f8d7ee8237aa6c40" },
    { "ENGINE.WAD",         "5d968c5301b6a4b1eea1c42a3c6effed" },
    { "ENIGMA.WAD",         "70fc36068c3fc0c9ead8b0b1fdfac8d6" },
    { "ENTRY.WAD",          "1c5192dd4dd32aedd2d0da9ec52d723c" },
    { "ENYGMA.WAD",         "80f927cad30d04f863982383c7608d01" },
    { "EP.WAD",             "9528242176c5486192a15eedebfb3732" },
    { "EPI-HELL.WAD",       "5ce50b01ef7d22832c1eb9357c3d52ee" },
    { "EPI1BEST.WAD",       "3704f02d840b73fd9522036af2f4b3cf" },
    { "EPI2BEST.WAD",       "5d4d9e188e94238420b7adbf9d435843" },
    { "EPI3BEST.WAD",       "911f70835514097750d5a455b952ea55" },
    { "EPIC11.WAD",         "6ef6c5e8bac1d09c21a3b0976b418db5" },
    { "EPISODE1.WAD",       "e1d166ce0c4d320bca56468bda5a2c58" },
    { "EPISODE5.WAD",       "bde9bca37790c8a3535b52b1e3dd1210" },
    { "EPSILONE.WAD",       "c0fdb7c0fe3fb927fab7bd466d455651" },
    { "ESCAPE.WAD",         "ab47bfc0c8afa950f743922cc48553cc" },
    { "ESC_WOLF.WAD",       "60c655a4c209f64b07b43931c1623186" },
    { "ESHORT12.WAD",       "ae234ac6bca6b6218553a29396faa1e0" },
    { "EVEBARNY.WAD",       "93ea8e9d9a9da232ce4f942d57197107" },
    { "EVIL1.WAD",          "6719eba389419552a06a34854536a40c" },
    { "EVILR1_1.WAD",       "7dc0e34f3a2b6c90024e900c068f3ce6" },
    { "EVILTWI2.WAD",       "73d9926a8a122c1347015126af3b8bee" },
    { "EVIL_E.WAD",         "8a35dbf40c6423262521614e4c5a00d8" },
    { "EVPL.WAD",           "639637f4e8db884f240ea32709c49470" },
    { "EX.WAD",             "b5f0b9fb035ce705276327152b882c32" },
    { "EXDOOM.WAD",         "d5342d0dc99fb06c7d8307e8f3027773" },
    { "EXECUTE.WAD",        "a81a30b372b3deeeef34cbc2994f7d62" },
    { "EXECUTER.WAD",       "1e3e3c8121bad1bc8fe7b6a2d3eb6efd" },
    { "EXODUS.WAD",         "5e39d5460b5ad0235232fa905305c1c5" },
    { "EXPLORE.WAD",        "3f9a0f14f82b1b8324808de62541db8f" },
    { "EXTREMAL.WAD",       "2400ea661b1a0a5bc7854b6df42328fb" },
    { "EYESPY.WAD",         "6a5bfc22ac2e8b9b9172e2f403aa7753" },
    { "EYESTORM.WAD",       "9d197512afeb3d4096438b7b555c7e97" },
    { "E_AMBUSH.WAD",       "8bb7f8c6e4e30db9beb64026ce79ceb8" },
    { "E_DHOUSE.WAD",       "a336ea232da5ed675a9f59838e48a71c" },
    { "E_OTTO.WAD",         "076fe08889f8263c60b2762505676924" },
    { "F-HOLD.WAD",         "a7094dfb6030b8827fa8bc2c261c0880" },
    { "FACELIFT.WAD",       "f34d9cf6e743e17181b3bc64d525989b" },
    { "FACILTY1.WAD",       "24b2ee397eb8e17635e10761dab594b2" },
    { "FACTORY.WAD",        "ff617dc514c37613d4a94566630ebacf" },
    { "FAME.WAD",           "a7e7d4ac985e211c43ed43b8115ce29c" },
    { "FASTER.WAD",         "59b1046d59caa94092da12ae966d1844" },
    { "FAVA.WAD",           "619a7190ab91ae6b71e12d95c773007a" },
    { "FBDEMO.WAD",         "e2ef0e1ddc88c5de2db285595cd3af56" },
    { "FC.WAD",             "055a70d1b24113aeae281f6666690a97" },
    { "FEAR.WAD",           "0d0eefec427ed331be7b88a39f49a0bf" },
    { "FEAR21.WAD",         "b0def86c885d0809fdcc9b04179a5484" },
    { "FEARLESS.WAD",       "e85c1bf1978bc7ffa40173786434e9db" },
    { "FEAROFDK.WAD",       "8142215b393f6778246d1ff8fdcff78d" },
    { "FELDHAUS.WAD",       "d8898e38197c867675d6341b8f7e0648" },
    { "FENRIS.WAD",         "7d6660a1f5259e21efc1a5f440555bb4" },
    { "FERTILE.WAD",        "82d7ecb523fa7fb89ef8f86eabdfc613" },
    { "FEUDAL.WAD",         "71447ec0d68fdfb403325afb84797c68" },
    { "FEZ1.WAD",           "5608ae1b9ff223a24d05b55a936b5615" },
    { "FEZ2.WAD",           "15ef50de745b5d288a0f6961583275eb" },
    { "FFDOOM2.WAD",        "75b6ad29f0a7927f0b424ba71bdf5063" },
    { "FIENDISH.WAD",       "fc4bfd81cf1dfef9dafe2791e40b825d" },
    { "FIESTA.WAD",         "ebc3999350d0eb52d828774ab0237d4d" },
    { "FIFFY.WAD",          "f96dbe6118b833f71e28cbae06cd0094" },
    { "FIFFY2.WAD",         "49d19a6b240f3a912bf0dbab1da81c8e" },
    { "FIFFY3.WAD",         "2134eb98354d531f5f894385e3cf2ccc" },
    { "FIFFY4.WAD",         "84bf2d728e46200c80e95a69749c4f94" },
    { "FIFFY5.WAD",         "b27fc6d29776a3c98760efa0a49a8446" },
    { "FIFFY6.WAD",         "f4f8410f7c7bdb729d040265153cbefc" },
    { "FIFFY7.WAD",         "848dbc7a25223707bc78ea75d929c8db" },
    { "FIFFY8L.WAD",        "f5d6a145c02e758ddd127789f56f76e1" },
    { "FIG.WAD",            "2b272075198f75cbe587a46b105432b5" },
    { "FIGHT.WAD",          "5154b6c0474ca32fdee06b0250be235b" },
    { "FILTH.WAD",          "42bd5091a5ff8249670f2599c8e50e1f" },
    { "FINAL.WAD",          "34d5e0436f145bf8ca0f1fcbaeec1e76" },
    { "FINAL8.WAD",         "c79e9bc0b41e145ccb109ed6146e6d3f" },
    { "FINALDTH.WAD",       "830f2c530a9d68dbe0fd20c4906f22a5" },
    { "FIREBALL.WAD",       "54db2a4827448f18d37f42a50bc4c0b7" },
    { "FISHCAKE.WAD",       "57ff8dcd1fcf24e2135d5021231b42f4" },
    { "FIST_EM.WAD",        "11bb948d7e63b4ce7bbb6970d24ed4fa" },
    { "FLASH.WAD",          "97c41e07b0823ff15a46021055958681" },
    { "FLAT-692.WAD",       "b7f4e5512bb6b68e08b5d18b48b727d2" },
    { "FLIP.WAD",           "8393f1c3876cc0fd291a9063d47ebee0" },
    { "FLIP.WAD",           "976d2d5752ac6559408141a82d692438" },
    { "FLOP.WAD",           "94eb63bfeb74d7927c4dda14fbc83324" },
    { "FLORZOO1.WAD",       "1d23249616b5d29c2f03be38430ebc57" },
    { "FLSOFDTH.WAD",       "472834975463d4e19cfd06fd0e6ff2a9" },
    { "FLYBARON.WAD",       "cbd531a782789fe4d1e9fac7ce2cf817" },
    { "FOISTY.WAD",         "14b8c26b912ecd4955546cd6f4be28ff" },
    { "FONTI.WAD",          "629daccb5a3f96c518659be66dc9a4da" },
    { "FOOD.WAD",           "23bf5d664a1db8d899b42520cc67c5ba" },
    { "FOOTBALL.WAD",       "6e0483cfde33311f37a7eb8342b1c7a9" },
    { "FORDHAM.WAD",        "25ea30f287e2f2d8bd1b57db031616a3" },
    { "FOREST.WAD",         "8f17ab16f3313fc024fb9e370ef0d36f" },
    { "FORGEX.WAD",         "cf8a9f75bb46a31726ee9a4354d195b9" },
    { "FORT.WAD",           "ad31bb74de0dc3cc92e47c5740c5b68c" },
    { "FORT1.WAD",          "232a0f5d8da6971cb5cb87a14154145d" },
    { "FORTDOOM.WAD",       "baf40a4b6f1bdd966877885ae92c9aa9" },
    { "FORTKNOX.WAD",       "259c0202f4e5f30172473b4aedb62212" },
    { "FORTRESS.WAD",       "02659de1e8caeb5555d9e0a7018c3795" },
    { "FORWILS.WAD",        "a9733d677e3a80cf1cc4f4e46f02e62d" },
    { "FOS.WAD",            "2f3eb5cdfadf93145a39649d8f792980" },
    { "FRAGASM5.WAD",       "7e0d3b83b4b4c670ab9fa156bc7223ae" },
    { "FRAGCITY.WAD",       "ecb1688ed0a8f9730b39d5bc90b048c0" },
    { "FRAGDAY.WAD",        "92fa87f94b55b61078f7c27f45ca78ed" },
    { "FRAGFEST.WAD",       "7f179ae8b692ed4d32da405ae1705884" },
    { "FRAGGON1.WAD",       "3ea8d22b2d719c6622684a4782d5e8de" },
    { "FRAGIT.WAD",         "8d5db42c671203f1a28dc75f31fb22fb" },
    { "FRAGMAN.WAD",        "2889a4fa21b6905fb31cf73b1ac73bff" },
    { "FRAGSIE2.WAD",       "f2d881a520b15d11c4c3dd5d6f7f471c" },
    { "FRAGVILL.WAD",       "8b4f1f097d7a3d57aa1e35de5250a6b6" },
    { "FRAGYOU.WAD",        "77e2ed8cf15bb790fa348e59c9411366" },
    { "FRAG_O.WAD",         "72810074a74fbe1bd460e230a97d31fe" },
    { "FRAG_YOU.WAD",       "958e98a97fe6625020f08277a3bdf735" },
    { "FRED.WAD",           "27cb56fc49770a7348aa439f8b57a789" },
    { "FREE4ALL.WAD",       "c445bd65675b625d0c16216bb9ac1bed" },
    { "FREEDOM.WAD",        "47b16fb90adfe785237990f0dc96a1f2" },
    { "FREEK.WAD",          "e64c9b79eb8b6981ea99224c979dbf44" },
    { "FRENZY.WAD",         "1592796dbf8d3cdcbd6d302a2cf9b16c" },
    { "FRGBLAST.WAD",       "1d62c731429658407c7934b12b83f538" },
    { "FRGFST21.WAD",       "5470f09dfc909b46b477c0724b202e2d" },
    { "FRIED.WAD",          "f15638d74a479d6a5a932ae0565cb4c9" },
    { "FRIGHT.WAD",         "038adb85f69f2ffa39a0002902c387d4" },
    { "FRODO481.WAD",       "cebd68a2c467be5584b9883dc60141e4" },
    { "FROGGER3.WAD",       "063bc7b0d66c76803678ce891e459fc0" },
    { "FROZEN.WAD",         "44d46099e38a64c1f62b26907f072b01" },
    { "FSTATION.WAD",       "43aab41642dd69d59f52ca54cd06a217" },
    { "FULLCHUB.WAD",       "7be90a6cda2f96d28a527632ebcd11cf" },
    { "FULLONL.WAD",        "e69d8773a1edf917e708ae3cd1dce8e9" },
    { "FUNHAUS.WAD",        "5cefb7872186d6641cb915c7b4b80cfe" },
    { "FUNWS.WAD",          "723a7c45dc3dbe4ebb8977017ff4cea8" },
    { "FURY.WAD",           "6b2fbfef395eb24f53ee59bcfcbe2fa9" },
    { "FWA_____.WAD",       "841e4d649d01e8f2183dfc01cdd1119f" },
    { "FX.WAD",             "3484f9ee23c0a8f34f7398c48072aff2" },
    { "FY1_1-2.WAD",        "b25f63dfdb9b8f35367b55845d2ed662" },
    { "FYWYTHRU.WAD",       "5f13e4d022530db18268d526f1033a46" },
    { "G-B-ARCH.WAD",       "0a4ef42d90ede2071be64e0a976435a1" },
    { "GALAXIA.WAD",        "1268745a553bf0675d3b5b487cbea3ac" },
    { "GALILEAN.WAD",       "1a771c08f200aba5ac9e5a11158f1af4" },
    { "GALLERY.WAD",        "62b011f0afcd9b8dd349707bfa88fa09" },
    { "GAMES.WAD",          "5d2d814fc99068b737da2de87c34818b" },
    { "GANGSTAR.WAD",       "27ec351b12ad97a84bbcab6e7bb36583" },
    { "GANYMEDE.WAD",       "15dc14ae2a67793eddf5e0178cf23c03" },
    { "GARDEN.WAD",         "a71ae40c227e605c967dbe109cf256fd" },
    { "GARDEN.WAD",         "b2639585cdbde1471f6257538e627d22" },
    { "GARDEN2.WAD",        "720418dcf38964dfdc55449f869aaa5a" },
    { "GARY.WAD",           "23043b418605c06717d954f8d55e4fc3" },
    { "GATECRSH.WAD",       "9df26f3851caacf653937db1ccd449f0" },
    { "GATES.WAD",          "0c47fd1eec84d285aa6821ee0692512c" },
    { "GATHER.WAD",         "3b52704afad987c34d683016ad95b5b8" },
    { "GAUNTLET.WAD",       "ffb0172f80f53b761525703e227ad169" },
    { "GCS1A.WAD",          "12bb7c89909ad740a57a6d3cab5411fc" },
    { "GCSDETH1.WAD",       "89bed7dc81aac773ddf840741a386538" },
    { "GD-O-DA1.WAD",       "03a10101200c209a7efb327520f0ed51" },
    { "GDESTINY.WAD",       "62b8e218654f42efec282d5b0ae637e2" },
    { "GENETICS.WAD",       "5414d2fc667b29e89563db33830b83c0" },
    { "GENOCIDE.WAD",       "4d66ff6dce0d344039f9be04feb93d4c" },
    { "GERBILZ.WAD",        "90f2a2a7b6dcbd9f8ddda010f375f545" },
    { "GERONIMO.WAD",       "fac2933f04a46e83dc7898c1a82a253d" },
    { "GET1.WAD",           "3e69fbd114fb8e4589e41b6d656fba13" },
    { "GETSUM.WAD",         "440352cc879eb94ac6c14a2ff87b2db8" },
    { "GGORE.WAD",          "7fd24582fa0c72583332d0ed2525e838" },
    { "GHAST.WAD",          "8cfcab3ed0d9cce20371bd57271dc90f" },
    { "GHOST02.WAD",        "7555002f35afdc3ab445ad7771da870d" },
    { "GHOSTOWN.WAD",       "24275667b82c860d7294b21d896f3229" },
    { "GIT.WAD",            "49e0c18771ef8176d928de3e2b88e74e" },
    { "GJ_E1M2.WAD",        "3915805a0125657be7edfad9eb76b335" },
    { "GLADIATR.WAD",       "10d7a2a37563a69a0a446cae849da315" },
    { "GLOOM.WAD",          "433dca5b0cb4120e74489724c93688ce" },
    { "GLOOMY.WAD",         "3afd5b311c773e33f04bf426958384e1" },
    { "GLUCKAUF.WAD",       "9916c7fd99659bd36f869b590bf37b6c" },
    { "GOAT.WAD",           "d5c76939169ea097014f87b853966c7e" },
    { "GOD2.WAD",           "5e39bb415c65197018ee0e71bd2d9b14" },
    { "GODDISCO.WAD",       "427fbe8586f39129e4a8c54667ce79f3" },
    { "GODSEND.WAD",        "37d7552a2557744e30acf7e9a378ac6c" },
    { "GOLGOTHA.WAD",       "65006204e3965163d68fd0c77a0d140b" },
    { "GONZO.WAD",          "ff6995824fee82437f1066c5f6a4c108" },
    { "GOODLUCK.WAD",       "3e91edc9a704244f80ef84213f302018" },
    { "GOOMBA.WAD",         "698267017f080ce3b707ada5b1a86865" },
    { "GORE1.WAD",          "b78b052c5304e45d612b31d1c83f5646" },
    { "GOTCHA3.WAD",        "bbc971522ffed09e424f62bb28c14e42" },
    { "GOTH1.WAD",          "e5988a65a5730bcc2799814f90c7810c" },
    { "GOTHMOG.WAD",        "2a3522a8eeb90a148eac18bccbac6cf5" },
    { "GOTHMUS.WAD",        "e5bd838449da2ad1ab9004e6c879d5b5" },
    { "GRAHAMK.WAD",        "c8c51bc2dce325b92174dfa19247d50f" },
    { "GRAPHICS.WAD",       "347cd7544babeca25f87e5018b13600f" },
    { "GRAVEYD.WAD",        "e32dd76e4a31e50dfa42174af9747f95" },
    { "GRAYDAY.WAD",        "f11fd98b9440ed367158e96f858110f8" },
    { "GREASE.WAD",         "76ef3d8e66f283f84c8023aa5551df4d" },
    { "GREATMUS.WAD",       "25734caad8f2f215ddfc48b87863b5ad" },
    { "GRECO21A.WAD",       "a75f3b941e3fe7573620c3c4c74eca5a" },
    { "GRENDEL1.WAD",       "b53e15295e01cf8673e1d9c3079370b1" },
    { "GRID.WAD",           "88e422b36a65034b5fb3d2d2abb7fc79" },
    { "GRID1212.WAD",       "6a72d9e7233de5c93596fa00724d1047" },
    { "GROUNDS.WAD",        "e466860e21aaa2fb2c65935e621e51ea" },
    { "GRRFY11.WAD",        "07bb593bd5f5cd9bc2777c68df8599cf" },
    { "GRUVA.WAD",          "1b78bcbaa9ceda4748e49d4df1792bfd" },
    { "GRYBLOOD.WAD",       "48aafa3e05c6efbf89a0b74df7423b83" },
    { "GS.WAD",             "2a3713fe88e835f261548f39555f433b" },
    { "GTA.WAD",            "7e7bf5669f48699fe719b7210aa9f20f" },
    { "GUETAP.WAD",         "2eb7bf196d377e653c091569d2e6008a" },
    { "GULCH.WAD",          "6a4349cd4ee37ce14057ad13c411d875" },
    { "GUM.WAD",            "1ab58ec528f0a663627730770b62a3ab" },
    { "GUN3.WAD",           "6a7e3da361389f812f23c1c24127ed34" },
    { "GUNCITY.WAD",        "61c9abe79d903b51c74079b7806e542b" },
    { "GUNFIGHT.WAD",       "0e0002e4d0153ddc98ad1e427286fc85" },
    { "H2.WAD",             "7d77ac24db7894eab5a94e643bb4bb36" },
    { "HALFACRE.WAD",       "30f268607ec49734c09a3d6612aba4c5" },
    { "HALIBUT.WAD",        "829d82e0b864453bca1a2e019994a886" },
    { "HALL.WAD",           "2e99f908e2a41ca80d8d1529da20b6fd" },
    { "HALL5.WAD",          "aa91903aed5414ddd359bb350c6077c2" },
    { "HALLMONT.WAD",       "686655b8309712b15d18b54620017195" },
    { "HALLS.WAD",          "ee58ed2b5f9ef6b3616a34f837aca068" },
    { "HALLSPRO.WAD",       "0d0393a1cdf72e02e94d53e461002333" },
    { "HANGAR.WAD",         "5522535c6b34b8ff1ce693e95c382b51" },
    { "HANGAR.WAD",         "e82a8c4ed229aefc4decaa42403e4cd1" },
    { "HANGAR41.WAD",       "2e7bc3b021ae9286a7c6a1408dd80470" },
    { "HANGR1L1.WAD",       "1eb430d43637f461d352e8133561a5de" },
    { "HAPVALDA.WAD",       "35efbb2fdbf2dc381650217eb863f449" },
    { "HARBOR.WAD",         "7c7606d2b6f0f775d2ffae98e29a2fc9" },
    { "HARDCORE.WAD",       "e1ccbca2d75cb163633031ef0ddc499e" },
    { "HARDTIME.WAD",       "91815f98893d378f3074629b812d60cc" },
    { "HARRIS11.WAD",       "3888d9062dfe2d91b288d52eace4f33b" },
    { "HEADLONG.WAD",       "a91c0fe808fc720de5bfa198108cde8e" },
    { "HEINY.WAD",          "de36bfcd3b6640c3af3b32dc34bb0f01" },
    { "HEL@HOME.WAD",       "8c5e8dbf6da24917f1e15fdf66e0c723" },
    { "HELFORT1.WAD",       "4625fbcc13bada83194e981b66528d29" },
    { "HELFORT2.WAD",       "fa157ff4e845ebeaf037a9ea699bd51c" },
    { "HELFORT3.WAD",       "341461cd1b229ef9292f449227ecd7f9" },
    { "HELFORT4.WAD",       "78cdbc026add9d45d7a5dd3fc4fa796e" },
    { "HELIPAD.WAD",        "4dadbd622da236f87662d8c34293845f" },
    { "HELLBLK2.WAD",       "8df3bcb9e2e0e470f593b74dd5c1104c" },
    { "HELLBLOK.WAD",       "2a0349b79d49059d88e7d1bba9ce5243" },
    { "HELLBND.WAD",        "7dadcbd0dd362d520344e437a0c2701d" },
    { "HELLCAST.WAD",       "46cf924f250ca2101ac4562b71f1358b" },
    { "HELLCH.WAD",         "29e99e395a637cf98f4e2ae107c1f7e9" },
    { "HELLHOLE.WAD",       "3cb096430e2939d7fdcb896ac414f3e6" },
    { "HELLKEEP.WAD",       "ae2962d55d158d0403493848d01ca018" },
    { "HELLMART.WAD",       "88ae9c7ab37f20ede1e9122d8e816e2b" },
    { "HELLONHO.WAD",       "3e4cedf50773d2d277997494b0e77a2e" },
    { "HELLPALA.WAD",       "195c018df85ed401cd33f20f953fe78f" },
    { "HELLPORT.WAD",       "17e73aa325959b857c9f929816cf0120" },
    { "HELLPOST.WAD",       "2da7fce73529ba257e274b906a5e37f5" },
    { "HELLRAIS.WAD",       "67e153dfcab8dd5818d70daa8424bd7d" },
    { "HELLRUN.WAD",        "75aa58182857db551c21572bcba705b0" },
    { "HELLSLEY.WAD",       "43c167c8945583a17137760703b38687" },
    { "HELLTEL6.WAD",       "c2f228964417e3b5b9c4fea7fee8fa68" },
    { "HELLU101.WAD",       "59dae8d8699a8eac0e168ff5aa09cb4b" },
    { "HELP!.WAD",          "4be5c24845c4854cb2935ac8efa683b8" },
    { "HEPTIC.WAD",         "308c019a2f28809eb2367876236f87ca" },
    { "HERHOUS.WAD",        "8a71d2f9a4f08db02a01be0188823258" },
    { "HEROES.WAD",         "30508a42c5c04dc93f1719bdac2990d5" },
    { "HEVNHELL.WAD",       "6128c87a8b80d195f8dc944686d83dee" },
    { "HEX1.WAD",           "ee529b0351bf83845528627e529c6845" },
    { "HEXXED.WAD",         "9f4079c1db909088b9c094d36cc96150" },
    { "HGFX.WAD",           "5449118a598d74c2c03a9d1ac086b5e2" },
    { "HHH-21.WAD",         "64121fd8ca752231c9a4ec2d9eaf8843" },
    { "HHH-22.WAD",         "15f243f45ac52f99ca2fcc5d0ec90961" },
    { "HICLIMB.WAD",        "0c4f1ab4dbef35a628acd5629e9e4f3e" },
    { "HIDENSEK.WAD",       "9d49f3fd51f52c7336b9006db5e4433e" },
    { "HIDING.WAD",         "6e32c84e088dace6341f7d04761382ab" },
    { "HIGH.WAD",           "8ce47e5d5c071c1d0faafca94be8e972" },
    { "HIGHLOW1.WAD",       "ae2df1aa38a7d1b9a01e147babebb30d" },
    { "HIGHWIRE.WAD",       "4b5757ab778d0310fbe3696872949843" },
    { "HIJIM.WAD",          "d74be967e8b408c2442294289e7780ca" },
    { "HIMA.WAD",           "35fe2fd1a72875e19ae769bd6da06032" },
    { "HIPPIE1.WAD",        "680ea6fbe90b1a5146b4c1f100a716e8" },
    { "HIT&RUN.WAD",        "6e5b1ece244c0e72a7d0711a8ebf1746" },
    { "HITMEINF.WAD",       "ff346f74b801c7be20e092f7e082c91f" },
    { "HIVES.WAD",          "5e1021525bdd6d38253d7ed17d647adf" },
    { "HJ.WAD",             "cb37485936e8d5b7860ea04a88d8a8da" },
    { "HMARTSND.WAD",       "4eb35f3902aa998179e644b60ed87162" },
    { "HOCKEY10.WAD",       "725772c47925b8f4c60966ae18478529" },
    { "HOLE.WAD",           "abf2c299a7bb141f2b1073d311528900" },
    { "HOLYMOLY.WAD",       "af3f90d82020eb13a1412c6626167edd" },
    { "HOME.WAD",           "efbee11b58d110f645cba87aa0bdd126" },
    { "HONYCOMB.WAD",       "fcfe1928e91a5f96c33b5c66f10f8118" },
    { "HONYHOME.WAD",       "99a551f38a1ee233f2df98861aea36f8" },
    { "HOOTER.WAD",         "3be97434eae8fd5f18d10a54a8399f10" },
    { "HOP11.WAD",          "d3d68636d868e10a248ac8d755d57b20" },
    { "HOPELESS.WAD",       "d2b81d354a7a28b697a079d146208d52" },
    { "HORROR.WAD",         "ae6b608e51397106a77b6da5d482c53c" },
    { "HORROR21.WAD",       "57e9f26c4d2dbfb704021ed78a1d461f" },
    { "HORUS.WAD",          "f7a493b7ef752d57d4d77d925a79a9ab" },
    { "HOSP.WAD",           "bae8325f1b57155aded42a6d0fdd0565" },
    { "HOT.WAD",            "07d4085765b97d9ac0ade008d3381567" },
    { "HOTELCAL.WAD",       "ebed205c92cec88562a76cace2fc2405" },
    { "HOUSE.WAD",          "7a8d5941de6fcf16e6d818abd40e2b2b" },
    { "HOUSE2.WAD",         "6e93a2373e6da8557b67b67ef2b7af55" },
    { "HQ.WAD",             "52a456ba1a1a506f689e1ed8f229f5f1" },
    { "HS&S.WAD",           "4f8f2267485894f445ab797a304705f5" },
    { "HSPR.WAD",           "119040f50bb163d449ef5f907380fcfa" },
    { "HULKDOOM.WAD",       "2744005814457c158d57dc50bd63093e" },
    { "HUNGER.WAD",         "4a4d621623eefe51b11eff72798660f1" },
    { "HUNTER.WAD",         "baa5f09209524e37f3811e7e710de686" },
    { "HURTME1.WAD",        "7a89d2502e94007aaac2157b25664ce5" },
    { "H_HOTEL.WAD",        "6b6679feb083b0742e0ec4e23b635060" },
    { "IB2TUF4U.WAD",       "8e768a875de9de17c84b1b0e889798ae" },
    { "IB2T_ZEN.WAD",       "1544e3d1f651abce0ee469899a0c11d5" },
    { "IC11.WAD",           "60d67f46fa9a283720a7ddff5b07fe32" },
    { "ICK.WAD",            "7ec038001a6e3dc95e4bc2e7a9e1bb20" },
    { "ICON.WAD",           "de314c7784a016a97f40ec558dbd7df6" },
    { "IDBEST.WAD",         "b637594a8e00d42f71e022a30fb9d99b" },
    { "IHRKE1.WAD",         "bbe27e32185e9bf653c0853a26bef318" },
    { "IHRKE2.WAD",         "091f4a728e6c68bddf34d1fd91ab872a" },
    { "IHRKE3.WAD",         "fa3dfb957a519c1e8203b702b6658630" },
    { "IHRKE4.WAD",         "0ee47a055767a3b2b6dfbcaf855ee7a7" },
    { "IHRKE5.WAD",         "8b81aec7cc1802ba2314578cd37211d3" },
    { "ILLUSORY.WAD",       "5ce16a486da418d15afb4e06ad671a07" },
    { "IMMGFX.WAD",         "e76fecb5adb2ff734358253cca9583fe" },
    { "IMMLEV.WAD",         "7f781c3f0ef8fcee6e887e927b2e3bee" },
    { "IMMMUS.WAD",         "faa9d13c41fd15600ae5443fa8bd05d6" },
    { "IMMSFX.WAD",         "0d9523ff3fb989b9db6cbb62bc59ac82" },
    { "IMMSPFL.WAD",        "68f53858fa0e3ad5061431403efb3bc0" },
    { "IMP1.WAD",           "a40612824aade666142f1ba903cea5eb" },
    { "IMPROV.WAD",         "629c92e4d0cb7b6a05bd511827950473" },
    { "IMPS.WAD",           "ec109171752dc2fe63fa390b4ad9139e" },
    { "IMPSKULL.WAD",       "9b26d41f53355b6e0f843bfa98bf291f" },
    { "IMPSRUS.WAD",        "e5c2585cae6437413c8bafd6b3a2eecf" },
    { "IMPZONE.WAD",        "8d185651d0c5050d667965693f22eebc" },
    { "IMPZONE2.WAD",       "b6b511e010c5f92e99a4c5b7d7130897" },
    { "INCA.WAD",           "46eee4cfb8e42d86aa4000cefa6b8b97" },
    { "INDIFFERENCE.WAD",   "a9e38aa3dab329e67be86cbd4f74f9c7" },
    { "INFBETA.WAD",        "fa9c1e701041cf4c038f1b1e8fb1e2f5" },
    { "INFERNO.WAD",        "780feb1c5352be6600355ddb1abe971a" },
    { "INFEST.WAD",         "2fea09ef25f61a0446e50f1aca3ce699" },
    { "INFINITY.WAD",       "75be5648678eab75ff5a1ed35befc353" },
    { "INFINITY.WAD",       "8ec3301cb4186fc17a33742d37869c2f" },
    { "INHELL.WAD",         "3458c9c08e7af584234a4900d1862ac2" },
    { "INIQUITY.WAD",       "ea59811b3d5d13e7cb6724ac57f516f8" },
    { "INSANE.WAD",         "ea5c929f619dc9e43ae8bd7e13147d8c" },
    { "INTRUDER.WAD",       "669c165511eda9e34ea7c3ea6b7bacf5" },
    { "INVADE1.WAD",        "416aa96c273b8520abbd5d37c157701a" },
    { "INVADE2.WAD",        "900c2aed6bb2da4f1addfa631b38df92" },
    { "INVASION.WAD",       "169a664bf132a8111061f90fdecf2d33" },
    { "INVICTUS.WAD",       "21860ee23eca29e7820ec348363ee4ab" },
    { "INYF_DM1.WAD",       "14db648e00d5ab1eff44260131b62518" },
    { "IOANOMAL.WAD",       "27ca363943cf94a3d14b093073e00057" },
    { "IODSE.WAD",          "bc3da3adc5305c41ae38d25d46f5c0e9" },
    { "IRU2-V2.WAD",        "57c60bfd1a09bc2de886c02dbadce670" },
    { "ITP1_V1B.WAD",       "59cc49163061aea8b4ca1b8e2f40fa06" },
    { "J1.WAD",             "a4fa0d72e3cc211c5fe39c016b94ec5a" },
    { "JACKINBX.WAD",       "da9951d1a5b62887a028494b18bbd5e8" },
    { "JADML1M1.WAD",       "dc8ae8d98c4055fe6b48e4ed16ecea95" },
    { "JAIL.WAD",           "eaaadf75b425a022781d8da53b7269ed" },
    { "JAIL11.WAD",         "2e6c099dc54abeac25ea9575617dc602" },
    { "JAILBAIT.WAD",       "fe9cb3f76f2beb5e50153b42590a2683" },
    { "JAL_CAS1.WAD",       "594ebb2038e753fcc00e209e9e055dc8" },
    { "JAL_DM1.WAD",        "2f6aa322135ce2e0478409fdb0953bae" },
    { "JASON1.WAD",         "d44c14169ee50672352288982e539f73" },
    { "JAWA.WAD",           "2752caa011a67737f64179630629dce3" },
    { "JAWA2.WAD",          "119c71145b41ecb833122f56b43c6f32" },
    { "JAWA3.WAD",          "e2891ca92fdef89096cf11259f36f745" },
    { "JAWA4.WAD",          "f2ae90ed0aee255cf891846caf9d8a9b" },
    { "JCM2-16.WAD",        "f89ece0eee4f126da0f221347d3fccc6" },
    { "JEFF.WAD",           "ae15709218f4039da10cfcbf1114bd3f" },
    { "JEFF247.WAD",        "3ef51dfa5db9096bac2f14e55d5da0ee" },
    { "JEFFHELL.WAD",       "9dcce15d57cb2e4b31f5d8af59422d2c" },
    { "JEG_E1L1.WAD",       "b11b029252bbf3fa6b9d918ba1a53bd4" },
    { "JEG_E2L1.WAD",       "86e82ccf959b2646a6c42f028626192c" },
    { "JET.WAD",            "674fe03fa0a4da34f3d008a8ca1abf1c" },
    { "JHLDTH1.WAD",        "02c94e63b8fb387c15f385c159a4becd" },
    { "JIHAD.WAD",          "ceac93b4b2fd27a8463a1a10006c1594" },
    { "JIM0201.WAD",        "5889178fbd751b8f70438d5a1628ee82" },
    { "JIMMY.WAD",          "8dd7fc251ad837ebc735dee7ea459e18" },
    { "JIMMY3.WAD",         "54ec03f94b288feccab1abba1667d1cd" },
    { "JIZZ.WAD",           "d43a77eeecb73b341278a8e114fbc2b8" },
    { "JJE2M2.WAD",         "3d5adf1bae1b982baa914ed2fc1e8743" },
    { "JMPDM2.WAD",         "ff0284fe7e81388b1bc8ed426d38fd23" },
    { "JOBE.WAD",           "bdf79242561741cd0939e667270a6154" },
    { "JOE'S.WAD",          "48ecc8e1a273f0132255973ac348595c" },
    { "JOHANN1.WAD",        "0407ed956e656235d04d8f49e9ddcdac" },
    { "JOHN1.WAD",          "950807a2ee405d01836b5235c0ad9cd2" },
    { "JOI-CM1.WAD",        "a0719c8c104214a8d86740432c6c5695" },
    { "JOI-CTC.WAD",        "5e7012a35c4917e106cff02228153cdf" },
    { "JON31.WAD",          "2384e6e53245c253c085b421eda7a698" },
    { "JOSFUN.WAD",         "282dc1cb8491c3bd9b8db65abc143ec6" },
    { "JOUST1.WAD",         "849413df4bfa2b79f2f5d8e7f628d4d8" },
    { "JPZOO21.WAD",        "de5faf91550e9721da5ef61b388e5309" },
    { "JUNGLFVR.WAD",       "c99a596e68da677aed7a8c958d1db92c" },
    { "JUNK.WAD",           "e589669a04f7adc9ba38f62334df51e9" },
    { "JUSTEC.WAD",         "2dd52a156c15066f13170e3413b864c4" },
    { "JUSTIN.WAD",         "4611692481e93f8c032412d3b7db82ad" },
    { "JV.WAD",             "17735c53ed873d026462742d763b793a" },
    { "K1.WAD",             "7d642e7590030381ba750b166b357424" },
    { "K2.WAD",             "fa4333ec7f7a0ee7c82d2dbb13d9473a" },
    { "K3.WAD",             "8172f49fd1ee2cd198ae259f470e4d1e" },
    { "K4.WAD",             "b3805ce6ee5cda91f1645c1199aa89fc" },
    { "K9.WAD",             "3036b65c89ea3fea164391e45b208b12" },
    { "KAIOWAS.WAD",        "884ebad22c52b0a941e7fea088d4a264" },
    { "KAISER_2.WAD",       "fd8e8da6ab2f439faf2f67dab2280566" },
    { "KAISER_7.WAD",       "aa69c2b4f37d1f12182439871c501552" },
    { "KAMI2.WAD",          "3ac288d513faf99c73d0f10d80ff471b" },
    { "KANSAMSE.WAD",       "6121bbe064a9b12a2b6999a9e9ce403c" },
    { "KASS_DM1.WAD",       "14e8e633677042cfe8bc9225177b5f65" },
    { "KAT.WAD",            "653612c388766e53c063ce3303d5a1ee" },
    { "KD1SP01.WAD",        "502e6905cc779bd646f2faaec74d7f54" },
    { "KENDM1.WAD",         "cdae71479221e80fbf14554aa1ab16a5" },
    { "KENDM2.WAD",         "c348bc92a871225b4127fdaedf2afa2f" },
    { "KENLEVEL.WAD",       "b97846f623562ebadf11ffe5c412ad86" },
    { "KENNY.WAD",          "c17bda3b8ba764cf5e0648f3750060f7" },
    { "KERSPLAT.WAD",       "a7e8b851ac47a0bcfbee1e752aadfb7a" },
    { "KEYS.WAD",           "446462a357e98a1f1649eadb967a8219" },
    { "KHOON.WAD",          "9e6196221da56ab60b487c20972835d6" },
    { "KILEMALL.WAD",       "d53c89a08c912c0e908fc0f9c995beac" },
    { "KILGRND.WAD",        "63959f7c000b576980c0d93db01a8740" },
    { "KILL-ME.WAD",        "e0ea9403681cfaa1822a3982a8a62606" },
    { "KILL.WAD",           "526ccdb474d1267710551da8734ec119" },
    { "KILL.WAD",           "c9980cb6675898283be6a282d8704ec9" },
    { "KILLEM.WAD",         "ce2354b67a711e96391dba2f6d209d2f" },
    { "KILLER.WAD",         "b803180422cab9f9726f7afafa5a2128" },
    { "KILLER21.WAD",       "c93e02de7202fbaf1ee0a4a3901aa8dc" },
    { "KILLIN.WAD",         "bc484645ca0c2c8087031c4364104c33" },
    { "KILLME.WAD",         "a5c9690ca032ad4e8f271d67ca59aba3" },
    { "KILLZONE.WAD",       "ef7ad0bccd811ed2b6dfb1e785df8c20" },
    { "KILL_EM.WAD",        "1691e8f1ad6da1c75562c4ebcf04a616" },
    { "KITCHEN.WAD",        "cbd90594a9379fe520b306fb706af35a" },
    { "KRONOS.WAD",         "ce8ee6957fa4d908c17d7a3d8ceeb5ef" },
    { "KSWOOD.WAD",         "56015645781121cfc34207e7f2e1abc1" },
    { "L21.WAD",            "fce386b6cbb52f28261bdf30fb18c22a" },
    { "L22.WAD",            "e7375f0fcb559af28649003a0111eea1" },
    { "LAB.WAD",            "2926c7df5a28da7379dc67140820a24e" },
    { "LABS.WAD",           "09b47b24dc61790ef5a14b43fb15abdb" },
    { "LAITOS.WAD",         "51dece61e898f241fcbc5aa43834413f" },
    { "LAKE.WAD",           "5048ff49ff5adcb544202906efcccf00" },
    { "LAKE4.WAD",          "f6e2a8a15da6732f4f530a2ff8ec47b6" },
    { "LAND.WAD",           "ead70b536f3ea6afc90e62622b171f66" },
    { "LANDMINE.WAD",       "75f5899d5f6bebb753550db4190dec48" },
    { "LASER-D1.WAD",       "37cec6a27446184111de316d2e83dd7e" },
    { "LASER-H.WAD",        "023b95fbe898b5561cd120e5d5caac59" },
    { "LASER.WAD",          "b7e1b30d605c5af17816fc81b953be39" },
    { "LAST.WAD",           "4b20d403c6795c8d8dae4cd7b96cb3b5" },
    { "LASTHOPE.WAD",       "f9dc30a549b05e8a84fecf89769de6dd" },
    { "LASTREST.WAD",       "daeaf668bfc7ddd1beccf8e63c81f0d1" },
    { "LAVAPIT.WAD",        "8eb03f46dcd38daf2974bb7448c76edb" },
    { "LBGFX.WAD",          "60cb334eb5584dd9f94a62c08c321bef" },
    { "LBSND.WAD",          "57b543d3fcf4a254ebf67b7b7b96e6e0" },
    { "LCFRGATE.WAD",       "7c29d37f68186fa58bdee7f467cc203d" },
    { "LCFRSHRN.WAD",       "2ad7a4dd3b5fcbe710452b2c7210c0e8" },
    { "LED.WAD",            "2f255493dc3f94221ce66fd7096ab351" },
    { "LEDGES.WAD",         "17cb7f82e95953b963a3579c2f0f0df0" },
    { "LEDGES2.WAD",        "0cee2902e176194f02f2eacb319e00f8" },
    { "LEDGES2I.WAD",       "3cfb31eb0414c65310e82535dae98cce" },
    { "LEDGES3.WAD",        "141784b89813fc6ee4ab867ca65ef2df" },
    { "LEDGES3I.WAD",       "ff16d8a4a25f6ce51e5e91017b2f2275" },
    { "LEDGES4I.WAD",       "8ce2afb45faa0f269bfc8f2de2173da6" },
    { "LEDGESI.WAD",        "dfadc928cf391074ce2ce03c6594e20b" },
    { "LEDGE__I.WAD",       "bdcfa1c860bc6919245a642c644e3896" },
    { "LEDGY__I.WAD",       "4a47e3030b678589c1518e92e3b8e675" },
    { "LEGEND.WAD",         "ae3d3062b64bc45b4871cc0c7afb2162" },
    { "LEGEND1.WAD",        "61bb92ed8a08ebc65991db08395df43f" },
    { "LEGION.WAD",         "d1f281ba1b2ed2adc575b8771cf876b5" },
    { "LETMAK.WAD",         "8f661c06762bf91896bc71df73b188b5" },
    { "LEWIS21F.WAD",       "6e9e40cfd14dbfdf6a002025fea49318" },
    { "LIFTKAOS.WAD",       "2576007170b2ee04b2dc8142afaab848" },
    { "LIFTLL.WAD",         "53530e175ec7588799705dd5a666e260" },
    { "LIFTOR.WAD",         "3a0deb026a60e07b8a81d4b702f9dc2d" },
    { "LIGHTS.WAD",         "6b3f0dc4a0fb1c8dde72da0751de9762" },
    { "LIONSDEN.WAD",       "2165e96cda90bd73d67aea4818ff3d1f" },
    { "LITEODAY.WAD",       "ac17a87218c125525d7f634872dd7dd2" },
    { "LITHE2M1.WAD",       "38885a9eee78ffa00cae12b882c20dd6" },
    { "LKDETHV1.WAD",       "99f7df7212976388e0a5161722539048" },
    { "LOCH.WAD",           "6271b4dd7f02f1f0293788a34f062c3e" },
    { "LODGE.WAD",          "fbdc310717d01e796bdd5dd135aa991f" },
    { "LOF.WAD",            "93d21836a87d150f5037a41400878488" },
    { "LOGCABIN.WAD",       "467a93002d2c4f6397f79075f6826a0c" },
    { "LOGO.WAD",           "81fd77109588046a91035e24b4fb617b" },
    { "LOKI.WAD",           "e6700c9a11e8ead1117e167de02360b0" },
    { "LONGMTCH.WAD",       "bd232e58f152fb5d7743d0551cf2d766" },
    { "LOOE1.WAD",          "665a4b6879721795c61ee6621b327b55" },
    { "LOOE2.WAD",          "d6f3840bbb20a5f81de0b572f100a476" },
    { "LOOE3.WAD",          "8c1dd1388152bdb710e90151bb708d87" },
    { "LOOKOUT.WAD",        "5acc5bb8a18190a1b55fcf3b85da6e48" },
    { "LOOK_OUT.WAD",       "13459fd6727173268320bbc24db6eb85" },
    { "LOOK_ZEN.WAD",       "f27b08edb4bc27f79410916202936a9e" },
    { "LOSER.WAD",          "43e1205f38608ffb4c11cca0ac70f433" },
    { "LOST.WAD",           "9ba16dc82147712a36d22cb5c5d6d26c" },
    { "LOSTLEVL.WAD",       "ecafe9b4a5526b83bd31d628396577ab" },
    { "LOSTMIND.WAD",       "f6342a0d869546fd5d15c42d740db660" },
    { "LOST_DTH.WAD",       "392ae4f23f48e0704b5e75980b2a3827" },
    { "LOST_GFX.WAD",       "332b42a5aeb56300eff703f333e094c3" },
    { "LOST_LEV.WAD",       "eee71755288ed82e750d2ac83c9fbd8f" },
    { "LOST_PIC.WAD",       "5e819658a0e2900eb4f2c95ae4244c6c" },
    { "LOST_SND.WAD",       "e1d2f44c26e23ee3b0442bb15ad21b44" },
    { "LOWDARK.WAD",        "67ce23fd77dad626a02dbb396cbd69cc" },
    { "LOWHIVES.WAD",       "9157f27685086f25f9e16a29d1d63ca4" },
    { "LSMULTI1.WAD",       "60d99d78e103dbe2d936c6f3b94d76d2" },
    { "LUCKOUT.WAD",        "e0498427e6b2f8825883b4f1b09ee283" },
    { "LURKER.WAD",         "a6a106b9606d7d2b26a7687dad78c947" },
    { "LVNGHEL2.WAD",       "2b939a54f50e2aadaa2fc2b1408bb7d7" },
    { "LVNGHELL.WAD",       "97ccc60abf0beb51fc453dd0dcaadd6f" },
    { "LWFIRST.WAD",        "cfbc3f90c34534943dfbfb57a4e0ff23" },
    { "LYBRINTH.WAD",       "7069e906b4d8128a1a2cfb43d2e7515e" },
    { "M2ALL.WAD",          "df2cdfcc51d391f33de24eb7b6c97282" },
    { "M2ALL2.WAD",         "3ac768eeaa22e85970902f5e0a7f54c2" },
    { "MADLAB.WAD",         "a0fca80a50d65b19d84615449c4d4cfc" },
    { "MADMAX.WAD",         "40391548abd4067223e91e82c77ace46" },
    { "MADNESS.WAD",        "7f76302218bc2b0c32fb61d20a6b1495" },
    { "MAGIC.WAD",          "32675dd4a201f5a75afe37f35f9f34e4" },
    { "MAIN.WAD",           "b89ccd4b2121235d465de6537fdf9a3c" },
    { "MAINDM.WAD",         "61986e1c9af2faa397aab168fd2bd2ae" },
    { "MAKMYDAY.WAD",       "a29037f22438eed6fbb04f41e6cd238b" },
    { "MANDIX11.WAD",       "c8929b361d5efb54ca9fa0280f231bcf" },
    { "MANIAC.WAD",         "399cc1e579183bc77bf372cefd6d8006" },
    { "MANIC.WAD",          "a3672f665cde9f189e48a842f7f61dec" },
    { "MANSE11.WAD",        "e9b417b0cf5c8303925a253f0c24a4f6" },
    { "MANSION5.WAD",       "b0b4d120490efbb217d5de7095209b6d" },
    { "MANTRAP2.WAD",       "eca91a7f7485f4c3ba3264af86c0d45d" },
    { "MAP1-3.WAD",         "ebe6d70ae282c18f086764f11ae0da73" },
    { "MAP3.WAD",           "6653dcb997e711c09c07fa34ee8e36f4" },
    { "MARBAS.WAD",         "400435256152572137c923322c33bca8" },
    { "MARBEAST.WAD",       "584d7620b9b85dbc80da3ec774d2742f" },
    { "MARBLE1.WAD",        "19cec1bfd03704dba1566d19100c3bb7" },
    { "MARBMAZ1.WAD",       "b9fef422ac6a9e3e490b66adf9a3a700" },
    { "MARC1.WAD",          "a3a6230b48747ac5d7b44dc767f26a8b" },
    { "MARKET.WAD",         "0fb7f245b220850b57aa74b9f2cb2bd0" },
    { "MARKRM2.WAD",        "e25d2ce8868fa8546a2d8d9065cfb40a" },
    { "MARKRM3.WAD",        "fff6785331d551ea9150a946351c5394" },
    { "MARKROOM.WAD",       "d3cf472fcd92938c4b22316d51cc43ce" },
    { "MARKS1ST.WAD",       "451aae48e9b4e7eb79b74470694d4ae2" },
    { "MARS.WAD",           "1b9bd54ea33dcbf064389f7d5eba56bb" },
    { "MARX1_1.WAD",        "440308c8150c87ade675948984091d1d" },
    { "MARX1_2.WAD",        "8fbd8e649e5c38758cd93d9afd6a7e25" },
    { "MARX2_1.WAD",        "ba90e068ec69c45d3138fc8da624d8a0" },
    { "MASTER.WAD",         "f31180eafc8e0d256a9f0824a14b7117" },
    { "MASTER2.WAD",        "16703ed4f6fc52ea2ab95d8580ed2071" },
    { "MATCH11.WAD",        "f7246b9968ae7d2a1135e5774e95d8b3" },
    { "MATCH12.WAD",        "606d11c570034047af1d2da46ba17b45" },
    { "MATCH13.WAD",        "5515f4974310048e0fa64c69549e9ef5" },
    { "MATHOUSE.WAD",       "d5fae390638e2378a0c017999d724277" },
    { "MATMATCH.WAD",       "1119744e191699cc2f6c60acc7e2bb04" },
    { "MATRIX.WAD",         "8d16ca5782505a434b528ef15e224bf0" },
    { "MAULHIGH.WAD",       "d28a0289d4436e26431932ae5b4efe0e" },
    { "MAV2D.WAD",          "4a806bb9052162004e75aaad30f0e074" },
    { "MAV2M1.WAD",         "88ad74aabd9054bcabcd2e2057a200a3" },
    { "MAVERICK.WAD",       "d7b9146c030f801411c687fb5fa98a7f" },
    { "MAX2.WAD",           "a14d824e8cd2ed77eeb39e2750707632" },
    { "MAXBAD11.WAD",       "612a1ff18fa23076bb411195ab2ce467" },
    { "MAXCASTL.WAD",       "38fdfd63980634ae35086d414843f528" },
    { "MAXFRAG.WAD",        "a5413e6ba386723e641fdd217d14ea95" },
    { "MAYAN667.WAD",       "0fcebd19d5d3fa035cdfb884ca808d75" },
    { "MAYDAY.WAD",         "aa97108d186bf07e8b48392e32c36d20" },
    { "MAYHEM.WAD",         "ac6d399e5b936f6ae59af5387f301903" },
    { "MAZE.WAD",           "b5a687d153cb2b11e95ef396b265c8ca" },
    { "MAZE1.WAD",          "b083d28199eb62e13ed9df19e9002ba4" },
    { "MB_DCT.WAD",         "e6fd63ac567b9d82cc58600a149b2aec" },
    { "MB_DTSAD.WAD",       "7606326cdcbbf3deee4b77b5152845fd" },
    { "MC94URB.WAD",        "82f0122dee862733bfa4552d66a638e6" },
    { "MDDOOM.WAD",         "381b4307dff0cf17e919cce883ecd11b" },
    { "MDL.WAD",            "f6b950a40efb77d55c6f11e13291ad59" },
    { "MEAT.WAD",           "c35c3df1ad617b67138bfeba1b24368a" },
    { "MEDLEY.WAD",         "be30792bc5e3ec0ce008c9ba8bde9d41" },
    { "MEDMAN27.WAD",       "904b1d57d184fc16a501656a14bb1749" },
    { "MEGADETH.WAD",       "32b1d4e362e4d8d8ae80f7087bce2a37" },
    { "MEGALAB.WAD",        "6f344262cefee27995569579e11545a7" },
    { "MEGALITH.WAD",       "9b4411d434c78d6fef3c8aa417b14bff" },
    { "MEGAMAZE.WAD",       "9aa8666aee2785656757eed71f9723d3" },
    { "MEGANUTZ.WAD",       "bc35230c7a4df898452fa26089815470" },
    { "MEGAWATT.WAD",       "a31b17b913ed879f019e5d82ce2d3d0e" },
    { "MEMPHIS.WAD",        "e773c7753305d465566e7bbd2814fa95" },
    { "MENTAL.WAD",         "5fe23ed763f792dc95f3fd109df6164c" },
    { "MESH.WAD",           "c0f83c0e2413f181aecd940494b5f4ad" },
    { "METAD1.WAD",         "1b5cc6a19173528648dc9ae90c4c1456" },
    { "MEV1I.WAD",          "51b25f49916a23556f4d9eb08b383284" },
    { "MEV2I.WAD",          "a10f1edc991c8a100f62367cf6eb7699" },
    { "MEV2_I.WAD",         "6ea191b2862fbf4c05b498c1feb2d71e" },
    { "MEV2_II.WAD",        "7b3f380c2fa2d32037c9d95e869fa365" },
    { "MHACKER1.WAD",       "5998d7149634a90f7b5c09bad1ed9af8" },
    { "MIA.WAD",            "52a22532f7a05deacbc1b16fc569ee8e" },
    { "MICK.WAD",           "1a197af649a03b07b5894a6769a3b7ca" },
    { "MIKE1.WAD",          "14420001bc057332cfb68c53f7e4eb3f" },
    { "MIKE8.WAD",          "4553383404e4a524460d20511fbbe803" },
    { "MILBASE.WAD",        "9923247cf9d7653a865cae7c3a7794a9" },
    { "MINDBEND.WAD",       "c695f7aed40e772e3b0036c3b1374603" },
    { "MINE1.WAD",          "bac4436c342481064413264ba7015613" },
    { "MINECORE.WAD",       "737794a1da81a0fd7565874bf098010f" },
    { "MIS1.WAD",           "8a3285a1be418d270b2c7e7132686c49" },
    { "MIS2.WAD",           "2a4802362d190c41fc91a6555c786640" },
    { "MK.WAD",             "ef6b289cc73a677dc3521c83e984ddc2" },
    { "MNTDOOM.WAD",        "734af895b957ac1d30f6464b3bd010ed" },
    { "MNTFIRE.WAD",        "af0e19cf4f01a6ae15bd97263e6d757c" },
    { "MOODIE.WAD",         "4fd4a0ad9f92fc93c772bec5733a7531" },
    { "MOOED.WAD",          "f09e83236cf2cf031ce4d747ae138d16" },
    { "MOON.WAD",           "e8fea16b2f2e66cdfed00c723d8bbeeb" },
    { "MOONBAS2.WAD",       "8bec199e09206200b0b780e3d732522e" },
    { "MOONBASE.WAD",       "52752954e43970a901fb3e0e35f08956" },
    { "MOOSTAR.WAD",        "af7d7f69f1de9a69a07eec0f903c679f" },
    { "MORBIDSCREAM.WAD",   "e4113f39696235242df95415fbe1ecc2" },
    { "MOREHELL.WAD",       "f67b2344e08b466e33777463884eb36a" },
    { "MORTEM.WAD",         "b95adfde659fe2ee49db876bd70a5be2" },
    { "MOTGRAPH.WAD",       "906b38b1135c6b9576e653f735a46ed9" },
    { "MOTION.WAD",         "a1df77ee102ebdb9d1320fb811baa2c0" },
    { "MOTION2.WAD",        "18559a13c09e3110ad827d51f92952d5" },
    { "MOUNTAIN.WAD",       "cc08d88637565417712687de44a41c3f" },
    { "MOUNTGOD.WAD",       "10a80bb8fca8fa662115eb2b8ca3ebf3" },
    { "MOVIEMUS.WAD",       "6efbf02bac7bf804444acc1533481a23" },
    { "MRDM2101.WAD",       "7a027e82063832c062b6944f47ec3200" },
    { "MRDM2301.WAD",       "ef6494a8d0f1c2555ec6d977109a0843" },
    { "MRDM2401.WAD",       "f8e6d72941ee1de3ace1f01a9a93fca0" },
    { "MRDM2701.WAD",       "57ba29957cdd0dbb8e8b7ee97f7f4c68" },
    { "MRFRAG.WAD",         "6e1692e91cd3eb5572528a5c0da5dd90" },
    { "MT.WAD",             "6f7acca5df934e6a1d36d0eddfa40849" },
    { "MTDOOM.WAD",         "3614849c3350676642476f615e8d72ca" },
    { "MTGLEVEL.WAD",       "95d7acfb66854074d9db9588b7073b3b" },
    { "MTH.WAD",            "1209c0d8152d5069025c5695cb6612e3" },
    { "MUD1ST.WAD",         "d95b1de4ef3c9d44ec93f9bd384a59ae" },
    { "MUD3.WAD",           "09280f4bd2db85098689d565202ccc33" },
    { "MUDMANOR.WAD",       "dcf04353b48b8ccb7a50ddc20daf105d" },
    { "MUDRAM.WAD",         "8c92717dd91d634aa22f3a1512243172" },
    { "MUDTOWN.WAD",        "9c27283878b124feb32827619eec0de6" },
    { "MUDVILLE.WAD",       "e53a9ccec195b7578dd4f04207f81800" },
    { "MULTI.WAD",          "98492e4e02301e0849b688287ed5db2d" },
    { "MULTI1.WAD",         "f3437c32363f2297c11077bfc60d251f" },
    { "MULTI2.WAD",         "ceb7e8eea89770bc17417fb34d1a2ff9" },
    { "MULTIGON.WAD",       "0f3430f7f37456c3538230b0bb8de708" },
    { "MURDER1.WAD",        "9897d9f8039d0b467e417a96fb100178" },
    { "MURDER2.WAD",        "f6676fbc68d06f420dbfc4fbe17f1a51" },
    { "MURDERUS.WAD",       "600b7b547fcf5080449e7b540ec88d0f" },
    { "MXK_C-11.WAD",       "707a2e1a3b211fe84c8b8989b8de5578" },
    { "MXK_D-11.WAD",       "4f5e8bd995d474de5dc3f2c38c60f2e6" },
    { "MYHOUSE.WAD",        "6ce13317b6791c3760713d27f1376793" },
    { "MYHOUSE.WAD",        "c216487a0b05c52a836f9b3673b1cc54" },
    { "MYWORLD.WAD",        "b754aed3ecc822b9a1bbeb67d04cf663" },
    { "MY_1ST.WAD",         "3ff81b4e77c67cb1f2e422f56bdc0f23" },
    { "MY_SECND.WAD",       "3b93563e63eebf71ac8e4ffa59a8893e" },
    { "M_ROHE.WAD",         "7c8247eb92f50312ca124f6c26c997db" },
    { "M_SPRITE.WAD",       "5252cac806aa6755636f54be104d43b6" },
    { "N-RIVER.WAD",        "a76394985f06cac86a6ffa72561f1184" },
    { "NASTY11.WAD",        "9bc1747605004a0da49a7fd2b790221b" },
    { "NATEE1M1.WAD",       "0951f5bce0aa21cb53dd82100d743817" },
    { "NDITD.WAD",          "9d458348541b8db0f2bccd505d61ee09" },
    { "NECROPOL.WAD",       "596bb890d8af34d98e6308a12aee475c" },
    { "NEC_LVLS.WAD",       "930669a442e7e29344b0522e383a5962" },
    { "NEC_RAW.WAD",        "8b832a21f81d1787d6cfcb9843910962" },
    { "NEC_SNDS.WAD",       "53f71d708cf34cc7cd27b6569152f857" },
    { "NEITH.WAD",          "8bd38d51f822cd82a8ab000aef09ac2d" },
    { "NEITH2.WAD",         "78b6ee698aa67b76900c2cbf0a0e17dd" },
    { "NEMO.WAD",           "b5aba336ad6bc3e7dd8f2bfb2ca3d63f" },
    { "NEMODM.WAD",         "8e9c07e934b66f109599648a9cf805d7" },
    { "NERVES1.WAD",        "b5ff92f34290b1aa11b2141c717d2d56" },
    { "NETBEAST.WAD",       "c874034fbd329305cac90a352aad67a9" },
    { "NEVER.WAD",          "80afcf3a404c6dc4ca498d8240612457" },
    { "NEVEREST.WAD",       "622e0625ebbea588fdc3666b93cf313f" },
    { "NEVERSND.WAD",       "113bf2d2591ef7ddb92c59a82b50fe45" },
    { "NEW.WAD",            "245e6a302fa65a7bf3de1c1f5bac5a86" },
    { "NEWBD3.WAD",         "0e1b3f43907c77e38bf7943710f55bee" },
    { "NEWBONUS.WAD",       "34d9fa5c75de4bb6ce4232f5daba5d8a" },
    { "NEWCITY.WAD",        "2362240ac7114a7f2be445f90341da52" },
    { "NEWDAY.WAD",         "167ce4a66f8dfd05c8a4d65ef967925b" },
    { "NEWDOOM.WAD",        "f2a22ff562a31c3cea6e78cf2174f72a" },
    { "NEWFORT.WAD",        "4eecd7748d89e6fe2ae8f35a79f5e4a7" },
    { "NEWTECHN.WAD",       "1d11eb790a8b775cc46dea90a3d9837d" },
    { "NEWWAD.WAD",         "def4cd649989d1ef64bbc96067249de4" },
    { "NGHTMR.WAD",         "924dd99f5853022ce1d02eb194d851b3" },
    { "NGS1.WAD",           "aff45680bcbd729d83608fbfd285b1ea" },
    { "NHOUSE.WAD",         "ea16ce4bca194983a4f874373d26d453" },
    { "NHOUSEDM.WAD",       "a4c884ac76a1d8838e6544409375da89" },
    { "NICK.WAD",           "5e1ec87f010e7cc39f99380594d1313f" },
    { "NICKDOOM.WAD",       "a05b46b92e5fa34f7e85b69b17dd4736" },
    { "NIFTYLVL.WAD",       "de76956b5bfd2907893215d43e27534a" },
    { "NIGHT2-0.WAD",       "fe972cf5589119976ca8430d8825882c" },
    { "NIGHTFAL.WAD",       "962cb72396c700901b8c499ce8e106cc" },
    { "NIMBLE.WAD",         "f97d0fc6a1e4c265bb69982f55ae0e0d" },
    { "NINDM.WAD",          "f5a042569c7f2529c077101a91ac241b" },
    { "NINJA.WAD",          "d678173e7b653360ed3752cc49c3e404" },
    { "NIRVANA.WAD",        "079a67aeafdccb601949c75f872520bf" },
    { "NITEMARE.WAD",       "3703e6d71d5e6d1b4e749a5637531d9a" },
    { "NITRO1.WAD",         "bfe0ba143204cee1a405da3371c510a2" },
    { "NITRO2.WAD",         "842c6b57c0866f161229a9a6046b382c" },
    { "NIVELES.WAD",        "5f6e0bc8d656828bc6258f565d2fc4d5" },
    { "NJDOOM1.WAD",        "0a114cd20b6fc5a2ef671d8962113bf4" },
    { "NJKD1A.WAD",         "2c47539fef9062f06e3371465f0b5c7b" },
    { "NJ_CASTL.WAD",       "ec788371eac5006a5f6dbb1d44e64103" },
    { "NJ_SOH1.WAD",        "5c9a5c4c7ceec8db289b7516ddc0dd65" },
    { "NM0001.WAD",         "11f372f29222430b979c873b9555e3c2" },
    { "NMARE2.WAD",         "b88e17548d7a2e79a89a6e051a263656" },
    { "NMARE3.WAD",         "9aca924996b5606d7522be246e75b7e7" },
    { "NOCHEAT.WAD",        "0d324f3251faa059aece58f79000fc6b" },
    { "NOHOPE.WAD",         "fce92d713d1ce1b42aa295e555b45c9e" },
    { "NOMERCY.WAD",        "84b35e7ffaad0b4fee00161d2c6cf651" },
    { "NOMNLN11.WAD",       "f0ef5fff8951b0fcb2d174918ae3f7a7" },
    { "NOPANIC.WAD",        "007d085867d76f2be383f7b69b1bdbdd" },
    { "NORKNOW.WAD",        "e87efe07d95b8045678235a133114de7" },
    { "NOVA.WAD",           "d1a8720ff80f0fc8b53dd4ff1c6e6c1d" },
    { "NOWHERE.WAD",        "57f1fdea08fa88f204e3711ea3f082b8" },
    { "NO_REST.WAD",        "ee502a12ebb20d7e01560381e075ace8" },
    { "NUCLEAR.WAD",        "bdd55c689337c1c715f13900eaf4b4df" },
    { "NUCLEAR2.WAD",       "76535a751550c909afc0e13cf663f619" },
    { "NUKEIT.WAD",         "2e3baa7718737fe057f8c5c9b3ee220f" },
    { "NUKEMINE.WAD",       "5394e828fc04d24593e0dcb187d95dfa" },
    { "NUKERAIN.WAD",       "b34b14be0b109eed902bdfabea4f3b86" },
    { "NUTS.WAD",           "377a5c52dafec7a8b4c3c3a8cdc85716" },
    { "OBSESSED.WAD",       "c449dc4cddcee21d284dd0dd3edf220c" },
    { "OCTAFRAG.WAD",       "ada5025945327a30f7d305272ee76a62" },
    { "OCTAPIT.WAD",        "9a9640a3dc7d2828bde332128fcd6275" },
    { "OCTFRAG2.WAD",       "4daf7423e93784a7cc68a7a99b102633" },
    { "OCTO.WAD",           "35be67f37ce235b57a686aa5ef72dff5" },
    { "OCTOBER.WAD",        "ce34e9e6ba3a7727c32418803262ba47" },
    { "OFFICE.WAD",         "22fea991b546a205f579c9bb03740b36" },
    { "OFFICE.WAD",         "46e2cfd0de768e2adc1bd634cd9a23a3" },
    { "OGGI.WAD",           "c609f0b7764fee23a346bf25dc50f356" },
    { "OGGI2.WAD",          "a17a5aa1119f06e5c5c6182e1c2e1458" },
    { "OHMAN.WAD",          "52e7be9dee2c9c80aa66aad6b73892db" },
    { "OH_MY.WAD",          "fe12d5d2d879a273a99f7280b6489071" },
    { "OK1.WAD",            "0824c15ea6e456eccd341f9cb4d9239e" },
    { "OK2.WAD",            "4a2c0c69678d2c8d30cdbf98b329ffb6" },
    { "OK3.WAD",            "b0528cfa3db608593b45ba93fca885e6" },
    { "OK4.WAD",            "caf06bf51937744dd2a5e3130e1c7639" },
    { "OK5.WAD",            "aedf1b3d3f508945d41f668c2e495c1f" },
    { "OK6.WAD",            "b212164cd0e1ca317122b96a30af7571" },
    { "ONE.WAD",            "983e0896987b0707404e23cdba2247cd" },
    { "OPEN.WAD",           "5f108f98264b1b10119f556661efb5ce" },
    { "OPENPLAN.WAD",       "6d625b80100cdbd0db192706b72a23a0" },
    { "OPEN_AIR.WAD",       "8742338adb1345f759a7aae4aee53667" },
    { "OPOST21.WAD",        "f21b29f0d2f5a9c653459f4bd254b6e6" },
    { "OPS.WAD",            "9a7c2492b6bcb3de3eb71eafc5313f66" },
    { "ORBIT.WAD",          "2b0dad550eb1caa3589248c1e470c531" },
    { "ORGEL.WAD",          "5c6189e5b975532a1bc8072089ea6f50" },
    { "ORPHEUS.WAD",        "735a52b2d9c45f08ea1260777a543d5f" },
    { "OSKYRT.WAD",         "c8b62d550fe924eef0a5bb35d3dbb6e6" },
    { "OSP.WAD",            "c672e2b6a9223e2a40b93a7828f17a8c" },
    { "OTTAWAU.WAD",        "5624c778ee07f028771977fb458a7f78" },
    { "OUTLAND.WAD",        "3a5dedfb4ade40660c0091c985e2588b" },
    { "OUTSIDE.WAD",        "ab9968de267d0ace5b0d070122a41ecf" },
    { "OXYGEN.WAD",         "b22c7e7b0dbca78ead182b01fcffa2ee" },
    { "P-PLANT.WAD",        "4d8dd683b85e0c106e43a22b9ff74598" },
    { "P2AKILL.WAD",        "4b6eefa33268a5d18a52e32cb189b9dd" },
    { "PAGBSPD1.WAD",       "87a4b593d706e538176ad9aca985bd65" },
    { "PAINLESS.WAD",       "5dd442accf428e625c23e9b0b4be9793" },
    { "PALACE.WAD",         "380cc66edf317102a090c165420106bf" },
    { "PANDORA.WAD",        "7a0d87258c41dcb4a2be3ea2a06ea4e0" },
    { "PANIC!.WAD",         "f4afed72344a08fa6bd6f1b048e3d015" },
    { "PAR-002C.WAD",       "474714102c2cf8a0c3525c9343cbab99" },
    { "PARADOX.WAD",        "26a3bb01d8a1e93ab528fe6b9452abd0" },
    { "PARANOIA.WAD",       "24469f49bc7054347f5ffd8c5dd30164" },
    { "PARTH11.WAD",        "4ff1919100de1fb0b71437125a553fc5" },
    { "PAT1.WAD",           "30a2e587a032e96f875124fbab664a61" },
    { "PATATE.WAD",         "024e59e68eb6d76dd2207daa9613bcf0" },
    { "PATHWAYS.WAD",       "c08aff8e75bd6dbb6bbb46ae9a2337da" },
    { "PAUL.WAD",           "4a55158913b5484dc48600caa5e10336" },
    { "PCFCONT.WAD",        "5422b781bdc069260989e811cd90624c" },
    { "PD-BASE.WAD",        "70923273c07806f1c282aca71077a344" },
    { "PD-EVIL.WAD",        "d5e6bdb4c5bb680398ce0cc425773acd" },
    { "PD-GATES.WAD",       "c7cccb3cb61eb4b8f78776520ad0f5fc" },
    { "PD-LOST.WAD",        "c84fda40cb7a56a0cfa347c677dee854" },
    { "PD-TRSK.WAD",        "f60b853e6ca1d3f333a5ce89bd390060" },
    { "PD-TWR.WAD",         "6b57ae8a2d12ed24fa4e42271445790a" },
    { "PDDM06.WAD",         "f6066f87057152d11a34d9fdc6dfd839" },
    { "PDETH.WAD",          "d376abc878a913c9f6110d1cd829dfa6" },
    { "PDSP14.WAD",         "07c4672d7c1fc56cefc4b3ea7a09b8e7" },
    { "PDSP15.WAD",         "a90cc3a35fedd01386838e7a6f9e9144" },
    { "PE01.WAD",           "4fd329c3ad8b4b0deae253b4cb506e25" },
    { "PE1_PHOB.WAD",       "35f15d0c61cff9761126919c198ed5ec" },
    { "PE1_TOX.WAD",        "a541791dab3383e0824df4dd4377291c" },
    { "PE4M_ALL.WAD",       "bc4f99760fb4b2fb4137ace109a49227" },
    { "PE4_DT2.WAD",        "87da6717e24430626415cd24adfc003e" },
    { "PE4_SE.WAD",         "dc1f8fb8e72b14348448f81a60cc0127" },
    { "PEACE.WAD",          "a6277d2e9b25d1ae87f051a55b82d2e0" },
    { "PEACE_20.WAD",       "68cead1baa89053d1a630fcfb7d48f76" },
    { "PEANO.WAD",          "a5e8c36058ca2916a6471e99011af966" },
    { "PEARLJAM.WAD",       "0272a2bb85d7c5de1a110b50857bd2b9" },
    { "PEEK.WAD",           "79cc9d7404cf66d567c57ccd6968ca36" },
    { "PELLEJOS.WAD",       "b9655503adc7a0fdd81c41cbcd4194bd" },
    { "PENTADTH.WAD",       "0bbd700257b8693bbcae868309ff9cb3" },
    { "PENTDROM.WAD",       "43d058253696815db3574034f0f73b24" },
    { "PENTGRAM.WAD",       "de7899e5e34b6d37da5ad0cca9f55f32" },
    { "PENZE1.WAD",         "99847c546ab9feecd74e130fdc4f91b1" },
    { "PENZE2.WAD",         "ba77e13946b696150a4993f8e6e7e07b" },
    { "PENZE3.WAD",         "3d4cae21eb365c40b3de24824b560e6e" },
    { "PERI11.WAD",         "1701cefbe12cd19e44be0a961d42f4b1" },
    { "PET.WAD",            "cc1cc1aef932f9c0ef6bb8f3519b5041" },
    { "PET2.WAD",           "be2c620b49c08379d40e6df7be052cb4" },
    { "PETKILLR.WAD",       "7aeabcb2282cf61fab8bfb4e6f802c1d" },
    { "PGGM.WAD",           "0eacc571a37e275c466ee7e305ad59cf" },
    { "PHM1.WAD",           "5e7dffc14677fc5c4ff7633c842bd99d" },
    { "PHM2.WAD",           "791578dacd010fef7ef96a77def5f7b8" },
    { "PHOBOS-V.WAD",       "a336476fc14321b81ab07873660c24d3" },
    { "PHOBOS.WAD",         "30d9f5470828551958c03d36ad83ba17" },
    { "PHOBOS1.WAD",        "1a5fb0d6638cec8db97d15b71bc88125" },
    { "PHOBOS1.WAD",        "6161b4f74e45c664fe4a2e09798006e5" },
    { "PHOBOS2.WAD",        "76d3d29d2ff685587d276fab43db9d8e" },
    { "PHOBOS3.WAD",        "f6db9218384ec78ff2f1f9e2019049c6" },
    { "PHOBOS4.WAD",        "47139401f639e6c9cd5582e0139dc43a" },
    { "PHOBOS5.WAD",        "bcf6dc8bf112489d2d51c12a45a048ee" },
    { "PHO_OUTP.WAD",       "bf6dbff983bb80e4a124b2d7e772d433" },
    { "PHRAG21A.WAD",       "eae245a8733d10c9eed518e29581b5c1" },
    { "PHUCKED.WAD",        "288fe2331a75c99284f04848c5d08ce5" },
    { "PICTURE.WAD",        "c4b5526e1754b1f0802f8837a6da2123" },
    { "PIE.WAD",            "3f5cb3ff331e0ca4157bcd6c3790e725" },
    { "PILLAR.WAD",         "225ce17d454673b945b280cffa74dfa8" },
    { "PINA01.WAD",         "210c368ec420cf4dc4e55cbb4a78804f" },
    { "PINA02.WAD",         "550ac0e8ecfbf51bd9fb26b1632d554a" },
    { "PINA03.WAD",         "1b9ca8e4decc438ec046ed5668840b69" },
    { "PIP.WAD",            "ac291713d931e63c9ead1c4c284c3939" },
    { "PISTOL.WAD",         "0ba793f3e310933755e4739a1064b516" },
    { "PIT6.WAD",           "ee274927b4f04cbcf03b21b8c44e3e8a" },
    { "PITFALL.WAD",        "d5994393835c59f7dd5202a3621b7b81" },
    { "PITSOFD1.WAD",       "e8962db65981661108254473f63b0e89" },
    { "PITSOFD2.WAD",       "47fc3afc295b062b010f885c51a20f20" },
    { "PITWELL.WAD",        "d11c64579288b3e222e50b13c81e0e3b" },
    { "PJS01.WAD",          "88fbf1a66c1a5a3b9f0d87ee6f387875" },
    { "PJS02.WAD",          "3211c800f41788d0a7dd7e5e9162368c" },
    { "PKBO_DM1.WAD",       "cf7970f3f6415c2945a4185a24f48124" },
    { "PLAGUE2.WAD",        "15bef7930c7b9a7197723beccdaf94ed" },
    { "PLANET-A.WAD",       "af6d6a88bc539ff04483c08ce34dcf7d" },
    { "PLANET-B.WAD",       "7c9c074b8d7bc87939ffce19f44ad640" },
    { "PLANET-C.WAD",       "e3aa57b7e0b1d98d1cceb4cf66339b89" },
    { "PLANET-D.WAD",       "946a39f74c56db6c0844ce65737727b1" },
    { "PLANET-E.WAD",       "0fb5b74629c0d8f5ad7bfbd433daea00" },
    { "PLANET-F.WAD",       "6ec7dbbc10a1deb828723ce55f7ef2a6" },
    { "PLANET-G.WAD",       "9f7ca99ad0ef100154602203af17898f" },
    { "PLANET-H.WAD",       "3b262b26bf28f865c9bcb23f57e9f900" },
    { "PLANET-I.WAD",       "f85feb3a163aee225e7a473ac0831bc3" },
    { "PLANET_A.WAD",       "7166d071f32e78cdea7046b477a1042a" },
    { "PLANT.WAD",          "e0a035f02155f0c93a4bc68a22e7905c" },
    { "PLAT.WAD",           "209f2a3c45b1a2627e8c8cd5332463a1" },
    { "PLATS.WAD",          "7eec1c6f48dc86a1fd661d690a441e93" },
    { "PLAY.WAD",           "6216a59a77b0b526f6ad31fedcead167" },
    { "PLAYGND.WAD",        "f3f87fad241655bd51021aae3d79617a" },
    { "PLAYTHIS.WAD",       "fe5bb61337e22d4342e9b24b144534be" },
    { "PLEASURE.WAD",       "4d7e36964e46acaeb2f5d2abb9ee0780" },
    { "PLUCKY.WAD",         "0c95deceb909078a78698e98af23a774" },
    { "PM2129.WAD",         "619a21ba90732730ecca275c76ae27a6" },
    { "PMAPI.WAD",          "a4869eda886b714b07981c4e1d97d87d" },
    { "PNP13.WAD",          "377082738d51faa22ac2fd1a914e4c27" },
    { "POISON.WAD",         "44143072d5ea3009684fa1a732d68bec" },
    { "POLE.WAD",           "aeae26c9bb983873de505aaeb5b5df43" },
    { "POLYMAD.WAD",        "eafcdadf3cb7d8c04c5f11c6158a8bb2" },
    { "POOL2.WAD",          "1af0958ccfc5f312fd8461108a124b0a" },
    { "PORTAL.WAD",         "2d277a591995c545cfd1a1f7fca007d3" },
    { "POSSGUY.WAD",        "5dc5d6073b2dcff67655493c6c7062d6" },
    { "POST11.WAD",         "f149c96033ea4c5c27027b55b0bc246f" },
    { "POT-2.WAD",          "bbd603b511c3b7f579420b7c0aec53f3" },
    { "POT.WAD",            "3af5462d158725cd07453a5529af79b2" },
    { "PR1.WAD",            "dd80837777e65ca9940367aee3930004" },
    { "PREDATOR.WAD",       "a5c264d458be5998a9da7d150429e47c" },
    { "PRIMUS.WAD",         "805561d293144b8b322efb75e6f8fd4b" },
    { "PRISON.WAD",         "7ed8f4ecec8268712afeb3399d59c92e" },
    { "PRISON10.WAD",       "cf1daa77887fbebb71869584689dd2e3" },
    { "PRIVATE.WAD",        "a05f7b6abc2b0a06450067a67368020a" },
    { "PRIVATE3.WAD",       "c2afbb9bfc8fe4e9a663492cabe127b2" },
    { "PROCESSR.WAD",       "b37c1f38822c59728a6cd2673ac26a9b" },
    { "PROPHECY.WAD",       "cd27f4402eb37251a4b8e9d614a8f822" },
    { "PROTO1.WAD",         "4f0959e4cf0c394c496a5f617d1ad77d" },
    { "PROVA.WAD",          "4af614c81ac9b803f9914b89ca2ce630" },
    { "PROX1.WAD",          "7a2213c14a118ec8b87aaa284bcf2281" },
    { "PRWRBASE.WAD",       "a3fea17a8c0daae568af3aef2c2d8fc9" },
    { "PRWRGATE.WAD",       "031484bbc13678ef7ec18771af38891e" },
    { "PRWRRVNG.WAD",       "3196ad28bb7ea5a2e64c81c58269b29c" },
    { "PSYCH.WAD",          "aa4d42d637c8f9ae7c8d75800ffc9d78" },
    { "PTALIENS.WAD",       "8d01c3a77c04f4d8ad46343bda963271" },
    { "PTULTRA.WAD",        "618c977c0fd254bc729524bbee481c44" },
    { "PTWRATH.WAD",        "9cb84ceafbe90b40c8a2ea65ba9812bb" },
    { "PUEBLO.WAD",         "eedd16fb4ffd9af777265ea3e8a00ac5" },
    { "PUMPKIN.WAD",        "26463ed6e0e60a43c033b08e90b6f1bb" },
    { "PUREEVIL.WAD",       "ab2ea59948c957f572fe6e9f90ec571f" },
    { "PURPLE25.WAD",       "dbcd081227d16f9decb5763c85df65e0" },
    { "QUAD.WAD",           "e3c5decb921de0d0582e440e908b7420" },
    { "QUAD_DM1.WAD",       "76f981b1621faa45be03bb963738c22d" },
    { "QUAGMIRE.WAD",       "fec54cbe65b1f5f3b9673016fe0994fc" },
    { "QUAKE!.WAD",         "12f25149819f9bfd912180f928fccb34" },
    { "QUARK1.WAD",         "50c1e21ae18d18e660abf587aef73584" },
    { "QUARY11.WAD",        "81dd260bcfe568690c22e622ae24f44a" },
    { "QUATRO.WAD",         "510eeb8f99fea37dea2250e262b18317" },
    { "QUDOOM.WAD",         "f2887128c59f640099703f77422618cd" },
    { "QUEEN.WAD",          "3e40bf23ce739c610c3fc023b83dab38" },
    { "QUICKILL.WAD",       "d4f3676b481d6d569965ea36a6c0ac4c" },
    { "QUIKFRAG.WAD",       "e1024756e3ef63c1194daec1b2cc867c" },
    { "QUIRUL.WAD",         "f0549e337bba0e2fae4873a7dcc722f2" },
    { "R-DENS.WAD",         "8ae0a8e2592125eb1688458075119d27" },
    { "RABID.WAD",          "0fe04ee7e08f00056e23591d57cda188" },
    { "RACE11.WAD",         "06bef887b1a52f00d21378cfe3cd1bb6" },
    { "RADBETA.WAD",        "09c84ffc83183d98f90e481595928a10" },
    { "RAGE20.WAD",         "efe4e836e1f626be6a6f50099623e78a" },
    { "RAGE_11.WAD",        "130298dd002d15ba9c84dbb9df488481" },
    { "RAGE_12.WAD",        "02b9070c5c9795f3a9f15d5244893e57" },
    { "RAGE_13.WAD",        "3dbd0f0b6d543b677243d007c646a094" },
    { "RALF.WAD",           "f8120b0a6ada05a541b9802c7374c27c" },
    { "RALF01.WAD",         "76f7bce59f58c2c0d2b1a7ff05da88d3" },
    { "RALLE.WAD",          "1e974ab83b29bf46a0d98fc819e738da" },
    { "RALPH4.WAD",         "40965b57e21b9ad68f0873d213d947bf" },
    { "RALPH5.WAD",         "abb02119198a572acd3795d315ac48f9" },
    { "RAMPAGE.WAD",        "5c7f0577b5e64d44367ca07541b537b7" },
    { "RAVEN.WAD",          "befd8d8d62877d5f917a934733296265" },
    { "RAYGUN.WAD",         "c0f2bede1f735fe63dace3c55d2afa13" },
    { "RCK.WAD",            "d4703ceddaf0d7dbd118e28b0997f5b6" },
    { "RCK2.WAD",           "4b0c6bcc57165092db514723f59d5d54" },
    { "RCKTDETH.WAD",       "d3131759a2348e10d00b738acbc667ee" },
    { "RD1.WAD",            "b1be1f332e43218a1421e064d1ade9ae" },
    { "RDWALLWD.WAD",       "85e05852cd048fdd34dca3f3bdadb5a2" },
    { "REACTOR1.WAD",       "9400558343013abdf4cee57e85dd8e22" },
    { "REACTOR2.WAD",       "d6929dadec31f452cec74c9ed59fe59b" },
    { "REACTOR3.WAD",       "b4f7fea2667deec50d0714f6636ddda1" },
    { "REALM10.WAD",        "62c55dca93e33f5865e2306755d42afb" },
    { "RED.WAD",            "2729cec6ba824f03700391b1445e8e7f" },
    { "REDROOM.WAD",        "77aa35fc0fff36606202aa297a36bf27" },
    { "REDRUM.WAD",         "3845b06b6e8893a4e0317cd85f3583d4" },
    { "RESCUE.WAD",         "fb089b260c03458dd913ce5d67ede367" },
    { "RESCUE1.WAD",        "cd774a07ce96f46204a2a91529d84bc5" },
    { "RESEARCH.WAD",       "ba9b9cd6457ad336354b78161771b252" },
    { "RESORT0.WAD",        "c000fb2b87e675413263b7408b9bc374" },
    { "RETROEPS.WAD",       "eae455e31ff1b90bcb2371ca39879fb0" },
    { "RETRO_DM.WAD",       "822b260a53555596a234b60ac954ccd0" },
    { "RETURN01.WAD",       "ca0d74b77ebeaf924ced10a272943e1a" },
    { "RETURNDA.WAD",       "57e5c1da3ec0b3ed42e428f6a1fc4d14" },
    { "REUNION0_1.WAD",     "81e420178c7baac0d6851c35403375b7" },
    { "REUNION2.WAD",       "41f8f04b541cca452fcffe93e9517b27" },
    { "REVPHO.WAD",         "7ed06be37ee2deae5c8927f5fbafd6f6" },
    { "RFRAG.WAD",          "aab61de552f0a4a3d44932388bb15265" },
    { "RF_LOST.WAD",        "dc6e3c1dd02a333d33a65bf0a46dcbd3" },
    { "RF_OUTER.WAD",       "88bf2a6eb1aba03bb29aea784a84f085" },
    { "RH21A.WAD",          "d02139cf6827a5fe13aecbd491c45073" },
    { "RHE2L3.WAD",         "469797be29eb874edf2b079a970f4a96" },
    { "RIANA001.WAD",       "da44263ef3661fbe769c96dd35d9d6db" },
    { "RICKDOOM.WAD",       "cfa1d87eca19516aaffd039bbda9493e" },
    { "RICKS1.WAD",         "8e189a4b4076e26eead268b456ffdff7" },
    { "RIFT.WAD",           "121a2d9ff93afc468a01c448c39516e7" },
    { "RIKER11.WAD",        "5a4630d74a31157946a7dc851dd98b94" },
    { "RIM.WAD",            "7da97014a3347b296f34f5623eecfcf9" },
    { "RIM2.WAD",           "b344f211ccf2b2ee85cb7eb4e979ae29" },
    { "RINGDETH.WAD",       "4af6277cbed23db87757f776b1189a1a" },
    { "RINGS.WAD",          "86efcd8b8e8908b3f744944d49867873" },
    { "RIP-OFF2.WAD",       "17f2cc44f51beb6ae8a4f52d5ce52853" },
    { "RIP.WAD",            "85f3b4f5e38eb31da6628792042a9824" },
    { "RIP2.WAD",           "f4aae36d84614e6a105de4a334ca6001" },
    { "RITESMIT.WAD",       "5c166a81fc0ef622dc768f667ced7643" },
    { "RIVER.WAD",          "4eaac9e3419d21fbf7e8dd01e6fd687a" },
    { "RIVER14.WAD",        "6c33da93837f8df5ee91c6382349ac99" },
    { "RIVER33.WAD",        "8ddc158fb0753cae1c9f81d501566219" },
    { "RMH19.WAD",          "e48df62518c2bc75821935d4e646c40d" },
    { "ROACH12.WAD",        "1fa07f33be93b3602e02667d046ba618" },
    { "ROAD.WAD",           "570ba7aa76ac331dc6b159aec83fb93e" },
    { "ROBS.WAD",           "d70a7205f0f39fe046c1abecb34327b0" },
    { "ROCK-IT.WAD",        "a0230c3e0a7c637951425bd352d0248b" },
    { "ROCKYVII.WAD",       "198ba8b8ded895bd0c5de1acade0ea6f" },
    { "ROGUES.WAD",         "780f31067bb7e0606daffa0c678f5505" },
    { "ROGUES2.WAD",        "1244256ec847dfec83f650bcc2c0b9a3" },
    { "ROH2.WAD",           "9be8d45a20244a692c0a0258cb83765d" },
    { "ROMAD.WAD",          "1fde4b61a365c139729041587d95fbde" },
    { "ROOMY.WAD",          "4c5f7a0eb1c4947b7c9a7fb33a74e9c9" },
    { "ROT.WAD",            "599703732425d1f2d4f65b3a99578ff3" },
    { "ROTOR.WAD",          "05b13d8f39823cdf4af3ef39fce1735a" },
    { "ROT_E2M1.WAD",       "4aabad5b373d19f1a2ba28119a708e15" },
    { "ROUNDBOT.WAD",       "4a865ec4b4c5a9d08ce8d61c6c279431" },
    { "RRV12.WAD",          "2d215b9c02a686d34d5385f5a6e39462" },
    { "RRWARD01.WAD",       "ec8e6945c179bd1e7468729355b272b3" },
    { "RRWARD02.WAD",       "dd1a71a11e6cb3d13630f1e0c87e7ccf" },
    { "RRWARD03.WAD",       "a1a41adc915811a8f341a2e70b104a56" },
    { "RRWARD04.WAD",       "46f09c5f725566693c9285057938d1b9" },
    { "RSRCHSND.WAD",       "a18d6e41a81a183c0b1daa05e6ea5ea9" },
    { "RS_OOZI.WAD",        "9e150d73a6dcf3bd31cb866b74876c5b" },
    { "RUBA33.WAD",         "f94557dd6bd29636ff712f0e6d422002" },
    { "RUINDM.WAD",         "2280bf52f9c748118afdeeb1fba57054" },
    { "RUINDM1.WAD",        "c50fd3a0cd9ff8f6889aceda9b6a71ea" },
    { "RUINX.WAD",          "082e21ea74c96f18448ebfc88ae1e0d1" },
    { "RUINX1.WAD",         "209b52a9c439162ebe4f065fe2560272" },
    { "RUN666.WAD",         "3e613a25abf69ce143180b12fa7d9d77" },
    { "RUNDOWN.WAD",        "3e613a25abf69ce143180b12fa7d9d77" },
    { "RUNES.WAD",          "a8aa283f18664c3fedf60cee47ea858b" },
    { "RUNLKAMF.WAD",       "9b574e5def4db708d211d1f41bfaf7b1" },
    { "RUNLKHEL.WAD",       "527afd0ae565facd6d5e2eedd0f761d8" },
    { "RUSTY_CA.WAD",       "7254f87363d2a64f783836b0adeff5bd" },
    { "RWK0110.WAD",        "2a7ec7598b5fcb68f83a787387d8f81f" },
    { "RWK0210.WAD",        "094ab5a71b2546a8d7038f22dcad4688" },
    { "RY11ECR.WAD",        "ed4491db4cad66e395aaa016b21c432e" },
    { "SACRFICE.WAD",       "f38e42fd395e38fa5238d15fe1da0b7e" },
    { "SAMPRAS.WAD",        "1c1d535dc7400ff802c5bff0358d1075" },
    { "SANCTUM.WAD",        "9dba095f540ed4f93989481475350f0a" },
    { "SANDSDTH.WAD",       "b0015d8a1f93e1b1e342fc0545b17759" },
    { "SAPIDUSB.WAD",       "ff31705884ff0dcb97bf302c7b8fd542" },
    { "SAT.WAD",            "5c37830d040accfdd2391c1741bdcc00" },
    { "SATAN.WAD",          "bd8d762c7de9e9ade7e325e80234fea0" },
    { "SATANDEM.WAD",       "222ca9c5091a6ce2d1d057926ca0c69b" },
    { "SATANDM1.WAD",       "b2c6a937ae6a76b0052c4606f44186b0" },
    { "SAWTIME.WAD",        "cb676b2164d989cedc267e231aa0deaf" },
    { "SBAW.WAD",           "3e84a1c4ea453613a63b5b05c427e975" },
    { "SC.WAD",             "504430ee935e217e8d079ae552fcdedc" },
    { "SCANYON.WAD",        "26065dc4a7b182674a4411abf66f03b6" },
    { "SCARVES.WAD",        "968fd4544a79d4518ef7c67e2c4eacaf" },
    { "SCC2.WAD",           "b56ba5d55189587ed2867c941b9dfa8c" },
    { "SCHOOL.WAD",         "7f81ea6b2b4816511e7737badbdf5644" },
    { "SCHOOL.WAD",         "e65718dd18f2442ecc6a65719e89d676" },
    { "SCHOOLDL.WAD",       "6765702f5d0c8a1bee4197a3f77e8528" },
    { "SCION.WAD",          "7b9c083613d55ab9cd6bdb0aa0bfac7a" },
    { "SCORCHER.WAD",       "03eefe623749ad704c4a4e9f3a57adda" },
    { "SCORPIO1.WAD",       "47767d09fa623bab08edbedba57a6dad" },
    { "SCORPWAD.WAD",       "1d5eb9ad60283cd0ed3db507109bda1c" },
    { "SCOTDOC1.WAD",       "194e5ff515f13661552918c1c45ae920" },
    { "SCOTDOC2.WAD",       "9f409552709ba451f34d51e4ac5bca13" },
    { "SCOUT.WAD",          "adcf1d453d3d69b6193e6a90959245e0" },
    { "SCREAM.WAD",         "1b1eb09a06c00690c54b00405856d1c0" },
    { "SCUM.WAD",           "17b97f95d78ec32a72b3c3a4af8c5bda" },
    { "SDMATCH.WAD",        "c074938b85a34e37c295c2267dae287a" },
    { "SECBASE.WAD",        "bdc1cadf5cee2bac1db8cedefede98c1" },
    { "SELFDEAD.WAD",       "46f706dc29192ef3bb378cfa14d692e4" },
    { "SEQUEL.WAD",         "315e6c724bac27dcc8ad28300476ed4a" },
    { "SERENITY.WAD",       "8f8a0697c6eff4dd64aa038002a0247c" },
    { "SERPENTL.WAD",       "36746ba020adfc842814285734caed66" },
    { "SEV3.WAD",           "54b143794134999fb0e94d3ec3441f7c" },
    { "SEWER.WAD",          "a7f68dca83a474894c46b735eabf0e5b" },
    { "SEWERS.WAD",         "293240d48a1f924f4f8e91c0282f9fbd" },
    { "SEWERSL.WAD",        "f66de33f617e262acf3a43cc2392e46c" },
    { "SEWERV10.WAD",       "23fe0e348068e9f592c5157acc894e23" },
    { "SEWRCORP.WAD",       "aa4879adf6506e912968772f0b6d5410" },
    { "SEWV12R.WAD",        "ec5a57632e966681bda53ff5277b3004" },
    { "SHADOWS3.WAD",       "0854fcf9b4db01eeaf646e29d38c1cb4" },
    { "SHAFT.WAD",          "46f661ab79deb4f604e6b52bca4a5e04" },
    { "SHAFT22.WAD",        "8f83d3ae965cd14370fa88dd3929cf7f" },
    { "SHEPHERD.WAD",       "55fd194cdddfed07e5dab96060b04aa1" },
    { "SHINOBI.WAD",        "63b2d34b374581aa9c0b74ea579433d5" },
    { "SHIP.WAD",           "e051cba21c05ef8ac59e106b41b25d52" },
    { "SHIP2.WAD",          "84c12134bc107ff86e4d5965c426cace" },
    { "SHIPROCK.WAD",       "da51ed1fb1381e33ff434992838fa390" },
    { "SHIT.WAD",           "9e903eb2028fa2375202e39b0af40355" },
    { "SHOCK.WAD",          "916ba709569c9559679393531b9cf7a8" },
    { "SHOGUN.WAD",         "1776361d32db4a6b1f1fd25a4aafce15" },
    { "SHOOTS.WAD",         "dd0956d07a8dc191c32d26b37f349e90" },
    { "SHOPBALL.WAD",       "a120df62b7b9c2719373b32101096177" },
    { "SHOTGLRY.WAD",       "90f66488aab181396334c8b99ae36f72" },
    { "SHOTGUN.WAD",        "e33b6451569804e612313cea5dd0fb79" },
    { "SHOTMY.WAD",         "91db6a4e4889fd77c70d8143c9cf956a" },
    { "SHOW.WAD",           "f93f883a9a6ec31a06f868dbdd0a2511" },
    { "SHOWDOWN.WAD",       "85bf492d23c5098e93118ac77cb983a9" },
    { "SHOWDWN2.WAD",       "6e63121e33f7bc8c5d39c25e09e391f5" },
    { "SHRINE.WAD",         "1ef1ef96a09f74faea634b2643a79860" },
    { "SHUTDOWN.WAD",       "faf593fed3d6f445f7976c2be06e879e" },
    { "SHUTTLE.WAD",        "3c55822355c928439455febec9501bdc" },
    { "SICKENED.WAD",       "2617963dae4dd798be3f1152e33eced4" },
    { "SIC_EM.WAD",         "b8066d5390aa90549d7bf32d54c8a592" },
    { "SIEGE20.WAD",        "c28f3f71ce576be799dcbcd19e788624" },
    { "SIMON10.WAD",        "7b3c69288453cde51306d28cf6fc53bd" },
    { "SINTER.WAD",         "0a86570a4d64392f00127c20904ce222" },
    { "SISTER13.WAD",       "f0c1bbbe1e989ee41aceb2145d959d26" },
    { "SITE459.WAD",        "b6a9488b7cf2ae7e4b505ac5d4a48efe" },
    { "SIXAREAS.WAD",       "31a157075e597fa11d8f0cc485113061" },
    { "SKULHALL.WAD",       "18158f9b057fae130b95164bada9f3a0" },
    { "SKULLS.WAD",         "421bb6c9825a98c023e26c887d2f5121" },
    { "SKYCITY.WAD",        "103b193df01370e9a88d6700ba6e7257" },
    { "SLAPME.WAD",         "5e9f0009671a692123186ee96223f624" },
    { "SLAUGHTR.WAD",       "b2abb87eb7217bbb8f2c57862d112efe" },
    { "SLAYER.WAD",         "47fd55003ba972e8ea6aa162c605a13b" },
    { "SLG-E2M1.WAD",       "43ed0434a0da2a9b31ccb0dbfb840686" },
    { "SLG-E2M2.WAD",       "2480f2b7027fdf2d3ce5a7dc1963ac1d" },
    { "SLTRFEST.WAD",       "0306130e6f2b937298d840af6fbdea7c" },
    { "SLTRRAMA.WAD",       "6851fd2333afc35e094d662e793fea0f" },
    { "SLUDGFAC.WAD",       "2e091b51939a9c9c531b0f5a69b29e33" },
    { "SLY1.WAD",           "d942427028890131d087f72b835a460d" },
    { "SMALL.WAD",          "78ee8ce9e550560e6664b0932e776148" },
    { "SMELLY.WAD",         "97ef83b7a128f0b3e1b63a139ab4f40b" },
    { "SMILE.WAD",          "623373f5534a0f7415985776603d0a53" },
    { "SMPFRG2.WAD",        "bea10f2596703f4f0286a44c71705d49" },
    { "SNIPE99.WAD",        "354e82d483d85d084e09ff64b91d56a7" },
    { "SNIPEME.WAD",        "f03a84bfba7eefc4a49eb8794df05773" },
    { "SOD100.WAD",         "54bd0e4f4faf17af69ac6e2a684585ef" },
    { "SOFTHELL.WAD",       "e74f63d05d3e92d7093473f3c622158c" },
    { "SOL.WAD",            "9f19de53a87f153935d6cae6c0d779d4" },
    { "SOPHOBOS.WAD",       "d80927e70bec203d5a64069389298314" },
    { "SORROW.WAD",         "105dbbdea275e0a775a6db27acd742fb" },
    { "SOUNDS.WAD",         "23169f5f9d11fdd23dd65ac89d16ec9a" },
    { "SPACE.WAD",          "eb6245ce18cdf1cac5696088f65f3a1d" },
    { "SPACE.WAD",          "fc252edada2413907b6af88e01cee143" },
    { "SPACED.WAD",         "b6eea2e96298637e28d0623d431bbbe1" },
    { "SPACELAB.WAD",       "6925d166194c5c10445c65be013d1eca" },
    { "SPACES.WAD",         "186592841c9f423b405c570fce3c513e" },
    { "SPACESHP.WAD",       "783050086faf881c95c863e9457b2fee" },
    { "SPACKLE.WAD",        "11d623c95b845e6a44e73283032af57e" },
    { "SPANKME.WAD",        "2886ab2dad2955976a8d9ff806acb531" },
    { "SPAZ.WAD",           "225959a2f672c1531ddab908a2be3bf5" },
    { "SPCHAUNT.WAD",       "8d42ca100c601c373d9eaba387ab93c2" },
    { "SPEEDOOM.WAD",       "88b7e31d0009b446413ff36de8a25ecb" },
    { "SPERM1.WAD",         "907fa6c9c6f8d001716fd76e59366a20" },
    { "SPERM2.WAD",         "9ced7d954f46ca280fb622babc0c43b2" },
    { "SPERM3.WAD",         "f679f42009b992688ac7a85be7864d6a" },
    { "SPERM4.WAD",         "cd1f580d1eea6ccda45609024998632c" },
    { "SPIDER.WAD",         "5f9d972bd3aedbb6fe03627b40e2837f" },
    { "SPIDERED.WAD",       "f4be487cb6ca4a82d67ac1b2ce31470a" },
    { "SPIDER_1.WAD",       "533cd4ecb91bc18babc93cb9c0d51146" },
    { "SPILLWAY.WAD",       "35319198c7c5d88779635fe8085adbe8" },
    { "SPIRAL.WAD",         "d8f61655b34a9e50413a75b019cf6613" },
    { "SPLAY.WAD",          "d76331b41b2b0b6283e107e8705f50a8" },
    { "SPMPEPI4.WAD",       "7b7732c0f7ed1671068764df8ccdd83c" },
    { "SPOOKY01.WAD",       "af80464ea8c52ab6187f1baa11f73698" },
    { "SPOOKY02.WAD",       "737ca9751b3845eb67b83e003156f0fb" },
    { "SPOOKY03.WAD",       "35cba35798ef7ed8f8e3926d7e7268de" },
    { "SPOOKY04.WAD",       "293d112663d3548d92255a6ab7d663b4" },
    { "SPOOKY05.WAD",       "44aaf51a94a59c7588b0fd7b1a182bf5" },
    { "SPOOKYDM.WAD",       "1e5c488094fe1e3eba48d5b437216292" },
    { "SPOON!.WAD",         "589c9d45450e14400fc959b0b0c3f873" },
    { "SPORTS.WAD",         "c920befa2bc7a25350d9894b4f39da21" },
    { "SPOSGUY.WAD",        "3af8763a17eaa291251981ec6169cc41" },
    { "SPRING.WAD",         "23317a6422715b3739bf0b8be6924418" },
    { "SPRITZOO.WAD",       "ff66dda5d1f480f1c4fa411786911c26" },
    { "SPUNK.WAD",          "26625942f973a3f8bcccc38c2774e6ef" },
    { "SQUD1.WAD",          "9f9e892f53096ecb58806c7a0e003c09" },
    { "SQUD2.WAD",          "868c016fe73b8ffb8a3cb21db6757b54" },
    { "SQUID.WAD",          "7842d4136d12de43ffc6bca6b72ea51f" },
    { "SQUID2.WAD",         "6e96df22658b7c6d319222e097699208" },
    { "SR21.WAD",           "57120780a2da2aafff209eae48a1cd3e" },
    { "SR388GFX.WAD",       "ee239ae10589790e15bf8dd790b17712" },
    { "SR388LVL.WAD",       "ad3ea66d6ebb522ef36700049215518e" },
    { "SR388PAT.WAD",       "0296ef9c1720987ba913fca36cadeaee" },
    { "SR388SND.WAD",       "fb156643d112e22ab31c0a927ac88d25" },
    { "SR388SPF.WAD",       "c9ef8327834b81948b9caa652705d321" },
    { "SS27BET2.WAD",       "89760d208552401f0ade842c9eb9afe8" },
    { "SS_E2_M1.WAD",       "ab7cdd4560694047a6eda65448764424" },
    { "STAIRS.WAD",         "fd9324f41f737a37bd79a9a0a32390b4" },
    { "STAIRWAR.WAD",       "88251bd1240bd02a6aa17ac34affece6" },
    { "STAIRWAY.WAD",       "fdf4c63a4e93e468c45f8cb5255806f1" },
    { "STALAG.WAD",         "1186d928c1d4465597a31cc3e9435642" },
    { "STALKER.WAD",        "26baec555a69ec661c5ee0a6efd985c0" },
    { "STALKER2.WAD",       "928661f6107ed80e211072d16e79fb85" },
    { "STAR-B-Q.WAD",       "6802ecea64a238bb97a190a3a4755d68" },
    { "STARBASE.WAD",       "ddfc64d3f357781eccf7f3091caf0e92" },
    { "STARDETH.WAD",       "a6ca1cd44150b898ad769369568bc4ff" },
    { "STATION.WAD",        "999450571765fefb2e7cc099700bcb53" },
    { "STATIONX.WAD",       "8ea1d3b058a8bdc6d9bab3fd8b0761d4" },
    { "STATN12.WAD",        "328cefc19048dba82f0b8d9a077cc8a3" },
    { "STATUES.WAD",        "f6ce2a598a67b4628eeeef50aa3952b0" },
    { "STAUF.WAD",          "c5d725c09700870ef838524250dcacb1" },
    { "STEALTH.WAD",        "9237c5b5d2d81456ce57eb0180eb7d0d" },
    { "STEELS.WAD",         "f4098797ebc86fe8a1c85c1b67dd8c25" },
    { "STEPPER.WAD",        "06d45816bfdade91977415c3c055dbc0" },
    { "STEPS1.WAD",         "ca3fdce22f1ed5511334ca281bc9f33b" },
    { "STEPS2.WAD",         "6189dfcaad0a6801d33d0289d6008ce9" },
    { "STEPS3.WAD",         "15acdce9a450407066b0ac2f6673504b" },
    { "STEWBETA.WAD",       "42577ccae8b4d583d7fa726c705e3ef7" },
    { "STOLEN.WAD",         "c59483dcade9dffe142ddc475bfc54d4" },
    { "STOLEN7R.WAD",       "04eac832fbdf616fad39cb3061b4cd6d" },
    { "STONES.WAD",         "1732e0c191ad5887be7a28de31600199" },
    { "STORAGE.WAD",        "3d90e3587574e75a895a240c75848f3b" },
    { "STRANGE.WAD",        "34b06397b191f1bfcd3d6979729661a5" },
    { "STRAWBRY.WAD",       "8a5e9e55d8af77bbdc952fb4e5b5c6ee" },
    { "STREAM.WAD",         "dc5da08d4ec245f8e4331d968a06a3a4" },
    { "STRENGTH.WAD",       "9047243811d913ec795ff0dc68c2df80" },
    { "STRIPPER.WAD",       "7f06c91c325f094eaaba51ae0a66fe55" },
    { "STRMSTR.WAD",        "e50ba247462f53b92deb9b4ca989444a" },
    { "STUD.WAD",           "7c0e4f999cb14342ed660be17be99374" },
    { "STUPID1.WAD",        "08af28b71c798ea02dfd77b9cbdaeb25" },
    { "STYFST13.WAD",       "73ce1c6c2122bb83d1aa71d1f49c4d0c" },
    { "STYX.WAD",           "694a9ae1d67f3e511a63e39cf6dd65c3" },
    { "SUB-EP.WAD",         "93a66e9f5355988406b40b92aaf622ea" },
    { "SUBWAY.WAD",         "bb02d920c26fa7ff321c02cecd1c0a21" },
    { "SUBWAY11.WAD",       "5c8c1a315117212d8a097c8f740d71b0" },
    { "SUDTIC.WAD",         "071d86ef2c5e0487a77dec13ac82bbaa" },
    { "SUNGOD.WAD",         "b9f1316cd386f6c4ba02e9f8ddfc5f7f" },
    { "SUPER22.WAD",        "456d87ddd46cb162ccd30f87743cdcdf" },
    { "SUPER33.WAD",        "8c27627f72bbc60ce8d2246aac5f649e" },
    { "SUPPRSN.WAD",        "a4e76574cd04b8f321eaf793890f108b" },
    { "SURMONT.WAD",        "536db41ff38f099ae29de9f7c785f9d0" },
    { "SURPRISE.WAD",       "e4f261c046777c32a4ddc58f9375030c" },
    { "SURROUND.WAD",       "22cdb06ad0e972eb94ac7a99f6012385" },
    { "SURVIVAL.WAD",       "578c083353bec97273ba4f7a0a4c725c" },
    { "SURVIVE.WAD",        "53ca159e1e5efcb8ae3bae0dfab50d5e" },
    { "SUZUKA.WAD",         "edd2ef07dfee372d25d83adbaf96733a" },
    { "SWAMP.WAD",          "255e8c3b693a5cefdf1776917be326f0" },
    { "SWARM.WAD",          "9f4a16ba80f5a358ba6690aa229fec3f" },
    { "SWEET.WAD",          "581b26e1014faa876c71cf2515150530" },
    { "SWETDETH.WAD",       "3f4bfabcd1dc4772dd1e2ec019f67ed5" },
    { "SWIG1.WAD",          "fb9e1eca9e56c75d4d4fc65dd279ab0a" },
    { "SWITCHES.WAD",       "9de0c8ccd0ce2af9416853c25017bcbe" },
    { "SWORD.WAD",          "c5739f3fe46dbee40c67d4b50371a0ab" },
    { "SYDDOOM2.WAD",       "94b1eed3795e9e5869fb8e6a4ad60f5f" },
    { "SYMBOLIC.WAD",       "0664d900ce94f5313c662318c0dee58b" },
    { "SYMMETRY.WAD",       "47c40e6cadda188a4d37ae1be72a48fc" },
    { "SYS.WAD",            "a0878061288320ff6ceaf9414860b073" },
    { "T-BASE.WAD",         "92bb86e5b53b8dabd9dc139b93c588c2" },
    { "T2.WAD",             "76277548ce357afee5849e472ae62cd8" },
    { "T3.WAD",             "da47ef23070c37227cef6efd1a999084" },
    { "TAAWTS.WAD",         "7d38f78e59c649d6f41774f79596887b" },
    { "TAKEOVER.WAD",       "195ea695e397a8c471d16b2c80d3ed61" },
    { "TALLON.WAD",         "3d9e705ac9547feffa1a8777567df2f6" },
    { "TALPOIDA.WAD",       "0c5659e661e5b553dda826cead9a57ee" },
    { "TANGO.WAD",          "402695a7edbac738a5fe91803b6a159a" },
    { "TANNER.WAD",         "d517f27149d3662499641e37a4331477" },
    { "TARGET.WAD",         "3893b2f5f9f332b36fa34021b7a7e7de" },
    { "TECHBASE.WAD",       "be717e9fa9a18fc0b592e95d7ec405b8" },
    { "TECHNO.WAD",         "2e5f0ab5f91863955c8555f8496b42fe" },
    { "TECHNOID.WAD",       "fa1ca1491d59170ed70d4430105e5388" },
    { "TECHTEMP.WAD",       "c1488ef140a6af2ab8e5d7d3a5f5b9e3" },
    { "TECH_DUN.WAD",       "a0f2769d338d3a76e65e6721e9832f1c" },
    { "TEK.WAD",            "0d44f21352c042e90b79b5c265f731d8" },
    { "TELEDOOM.WAD",       "15c6eda9f7a829438e12700e0b001c74" },
    { "TELEPORT.WAD",       "8329dc446e7e1aaf720b9ce605e23de7" },
    { "TELEWAR.WAD",        "b4fd5cba17513ec360d371444f48c116" },
    { "TEMPLE.WAD",         "48d6b1172610600e1da8387ab6e76e67" },
    { "TEMPLE.WAD",         "b5df6fce66e890e32563453cc3fc9b2b" },
    { "TEMPLE11.WAD",       "1ba84f97d6cf82c55119201ab3b914d0" },
    { "TEMPLE2.WAD",        "c345a05240ccdc5a662fed8c1197975a" },
    { "TESC1_2.WAD",        "f717fbd7f8287ceba1a6beaa3eb1694c" },
    { "TEST.WAD",           "47f93b361d62377a3ca87f251f8b90cd" },
    { "TEST2KIL.WAD",       "209634905eb52b154c48821ea93e8fcf" },
    { "TEUTIC.WAD",         "909d8c604f149766991978313381dc4e" },
    { "TFC.WAD",            "04d94f18d4db9b35f26016fe8f81421b" },
    { "TFW1.WAD",           "6accc5a88bc8db7c768bb6fba63066db" },
    { "TGMO2.WAD",          "d6dec8d4fc626619185121040375d8f2" },
    { "THALIA.WAD",         "e724e0c1931910a81f0cb24163b6539e" },
    { "THE-END.WAD",        "7a1b556b9c0c09162f04df432e118d65" },
    { "THEATRE.WAD",        "a113a560633857d292dcecab5b9c2fc9" },
    { "THECAGE.WAD",        "13948cd436d8cddbe342f14065b38279" },
    { "THEEND.WAD",         "b2d4b8d1742937c7c8564600804b687e" },
    { "THEGATE.WAD",        "cbf8a227d69bd1e17bea6f7235b1d6d4" },
    { "THEHIVE.WAD",        "ae28252311f1204dabe70b88a5c1542d" },
    { "THEJOKER.WAD",       "a53903a666a16c6e067a6a4b54c9ed60" },
    { "THEKEEP.WAD",        "6956d0fc6d6a62492e6f2ac062f9e119" },
    { "THEKURSE.WAD",       "1afe16af3575f75dcec2e5e81ba778b1" },
    { "THELAST.WAD",        "80f8ec5057a586a7150322b4f7b75483" },
    { "THEMAZE.WAD",        "a3083f3fb3f2b1069cbd16d64c625cad" },
    { "THEMOATD.WAD",       "d7c123a38465de3eee08f6312a291678" },
    { "THEMOATH.WAD",       "96d0b7e8a2fd5c4d4f5c481baed21261" },
    { "THENEST.WAD",        "da1db7257fedf4bd256955d197abe82c" },
    { "THENEST1.WAD",       "ce247e381a9191d6aece56bb7cd53116" },
    { "THENEST2.WAD",       "623703b6822b2cd135a100bbe3f656b1" },
    { "THEPIT.WAD",         "9560741f74a882604b6e7154e6875473" },
    { "THEPIT.WAD",         "96d262385b4711b7875644046af7d44e" },
    { "THEPIT1.WAD",        "931bb6796f31a44b372c80f5a34c24cd" },
    { "THEPITS.WAD",        "afab722ee86002ab13b21fe19d40973b" },
    { "THETA-4.WAD",        "5519e909d247467b3c05722c9a9244a6" },
    { "THETEETH.WAD",       "18e20976db94c5224d5d195412063cf8" },
    { "THE_GRID.WAD",       "951e07c96cb958a4c63446bfcd4a0325" },
    { "THINK11.WAD",        "92a86b00d91f6bf32d228ac8c9b74ca7" },
    { "THINK12.WAD",        "dfbe98fee3889a4d903e6c72eb152722" },
    { "THINKER.WAD",        "20aba99cfc586e68a94857073f556d8b" },
    { "THIS.WAD",           "a38bf4481e5a1d250635aef1b2eb5451" },
    { "THOS02.WAD",         "96ab1ab91a573b2d01fddeecf8fe8b82" },
    { "THUNDER2.WAD",       "b33038abb09e7989eec212043bb44ec5" },
    { "TIBET.WAD",          "c222d90a07c1b37ae987cc71d19e4374" },
    { "TIE.WAD",            "9a2beb3b7c2adcc394ece98f75f1789a" },
    { "TIGERDEN.WAD",       "24b4780897132cc7d2630283f7e8a3c2" },
    { "TIME2DIE.WAD",       "c7235d5bec090d00274355bb94f2809f" },
    { "TIMELESS.WAD",       "6fab5f94c605a456fa9572f9a75eb0ea" },
    { "TIMEWARP.WAD",       "234077ab6652f860054d18430073e5fb" },
    { "TINK.WAD",           "909258911ae482c731fecf7ef1a03529" },
    { "TLB.WAD",            "1fcbc0924ce93f37788a2db3beacd3dd" },
    { "TLR19.WAD",          "bb46fd1a8d3b6c72b6c2970b664222de" },
    { "TMALL.WAD",          "838db5c312297bc3ba058c8d4f91cd13" },
    { "TMATCH-1.WAD",       "2974cb3c0b56546b5afe55791ccb9111" },
    { "TN-E2.WAD",          "9a2f4b2dd6f0620887b8d9b3de9465df" },
    { "TNCROSS2.WAD",       "075f30865bf75c311ee054fa42c3ab7c" },
    { "TNPLHOME.WAD",       "831d48222f22d05da360326544bb23d3" },
    { "TNSGEND.WAD",        "53b91b5bda5b4c08db4d632a2548c641" },
    { "TNSPIRES.WAD",       "7aeee85c98cb4b094fb51383dd47ec9c" },
    { "TOJ_E1M1.WAD",       "a8fc42dc18ebd7d52cd5ba038327ac23" },
    { "TOM.WAD",            "42dce559b7606d2c116925efc805ca80" },
    { "TONE2.WAD",          "bdcb13998500626b375daf31db7a6a9a" },
    { "TONY3.WAD",          "ee72eebd93f44ca3b89e5d484e9c774b" },
    { "TOOHARD.WAD",        "991e2eb3aaf3a909b1665bd38f0dc4a5" },
    { "TOONFLT.WAD",        "88c8816a8d07fefc4bc83539e771c037" },
    { "TOONGFX.WAD",        "a574e51c9358a156ebba5ca051ccae33" },
    { "TOONSND.WAD",        "ccc4ed019238199fe07390915b597c41" },
    { "TOONSPT.WAD",        "629aaf57d11040f58567727d272e9122" },
    { "TORCHED.WAD",        "c9eab35f3d30e4f1e61d62cebdb06dca" },
    { "TORCHES.WAD",        "6f203b56d1a37cbd5603084df45b7cc7" },
    { "TORCHLEV.WAD",       "afc63092fdbc27f958560b353ae99845" },
    { "TORMUSE.WAD",        "3ef3d7bbebee03976c2acef1d8a652b2" },
    { "TORNADO.WAD",        "fb82a689aa359be3929aea15792ca249" },
    { "TOUGHGUY.WAD",       "a3867ca1e2edcf75508b6b1219150bcd" },
    { "TOUR.WAD",           "ac28a4b147583dd1872e2ee39ff824ab" },
    { "TOURNEY.WAD",        "0d003049578a5fbea032cd639f519275" },
    { "TOURNEY3.WAD",       "d37fb000d9729986ae048a2fdb746b33" },
    { "TOWER.WAD",          "0d90eb62464024686fa77c093cc5d7ed" },
    { "TOWER2.WAD",         "ca833c2dcf6a9b9ef7136fe65a097b0d" },
    { "TOWER53.WAD",        "f89b0f8efcb430ca0c8a991daacc6dc5" },
    { "TOWERS.WAD",         "e5b8c1233e3243e1699d131e5a9da9e9" },
    { "TOWN.WAD",           "3caf4b8bb056a6f0eda05ce45d850901" },
    { "TOWN4.WAD",          "8ce074b4cfef96fa57d6c394bc76eb94" },
    { "TRAIN2.WAD",         "6d9c382c4e7cf1f8adc73aaaee63c921" },
    { "TRAINII.WAD",        "b7e08e1835df12e9eea85f1336bd1e82" },
    { "TRAINING.WAD",       "810958c6eb448c7b5b22da774c1cc82c" },
    { "TRAINME.WAD",        "cbecbbb98e3fc31b80f639e1606684bf" },
    { "TRAPPED!.WAD",       "6fffd31119af8c1fd75b58e040d9a57a" },
    { "TREE1.WAD",          "70f4d19fe9f459c95fb8fa15513f6479" },
    { "TREE2.WAD",          "f4a542bfb6f18afeb4de56aee4513393" },
    { "TREE3.WAD",          "9ef79e7f8a4c5d8f5dbec57e3295f374" },
    { "TREEDM1.WAD",        "3e8b047e79ffc606d11e6f92f2eb91c5" },
    { "TRENCH.WAD",         "6248ed3963dcc0044dfa1c4911eeac4e" },
    { "TRENCH.WAD",         "90e5b75109811611f8a78949bbeab383" },
    { "TRIAL_B1.WAD",       "74d69d10d6c477432ef3bcb52565276e" },
    { "TRIANGLE.WAD",       "017057068b610a7dd6145eced98f6e75" },
    { "TRICK.WAD",          "cb82495ee407b3230fad99882b800a40" },
    { "TRIDEATH.WAD",       "37fcaf105687a5fd1677742fc44ff2d1" },
    { "TRILOGY.WAD",        "bcbab81e98a6822474028a4e8a3bc356" },
    { "TRIMANGL.WAD",       "e06b9eaa3a217d83a19a6953c7ec151c" },
    { "TRIMATCH.WAD",       "661a44b7101857b1b26687fd6531cb55" },
    { "TRIPWIRE.WAD",       "bda18c96fb7dddc684690a74278440cd" },
    { "TRUETEST.WAD",       "78747924376a84ea67b3a220366fe74d" },
    { "TRUNK.WAD",          "0a6be693702f94320988df71ea622616" },
    { "TRY_IT.WAD",         "0fc1bda1c4e24ff35389d60646e3d2c0" },
    { "TSHCK1.WAD",         "ad279d348b151d3ab3c804e3debe8e9b" },
    { "TSOTSOFL.WAD",       "52d35261363574c5627fa7eabf8d82a4" },
    { "TSTORAGE.WAD",       "97280d76ac9b56c6787e843db3bef6a6" },
    { "TT11.WAD",           "38e52f6cd75a3745c8d3152c72bab455" },
    { "TTA-CHUD.WAD",       "fadbe080e5c571be5e9b50f1ba3b6377" },
    { "TTADOM11.WAD",       "dda3b212b3dce79cbc594b6615a30d66" },
    { "TUBES.WAD",          "6460c1cb88f5ee76b80ad4d0f9d1bfd4" },
    { "TUNNEL.WAD",         "711ad218e02909744eb89151ddf42a37" },
    { "TUNNEL11.WAD",       "ada9c4e2ea10e4a6c863d910b4ad7cbb" },
    { "TUNNEL96.WAD",       "6c350e09102007fc871ccb5f693034b8" },
    { "TUNNELS.WAD",        "07ca71420fe9e59d4d0ff3fdf4a2917b" },
    { "TURBO.WAD",          "bac015703241b2f5af266cb5e25fedc8" },
    { "TWILIGHT.WAD",       "c8ef38278aa5e28b12d124560246e48a" },
    { "TWISTY.WAD",         "8a8dd89731cb450fa3a9e72f4a413228" },
    { "TYROS.WAD",          "bcbc857b0c2b5faa3bf5c9f0e727b2b0" },
    { "T_DUNN01.WAD",       "e47493d78ef9a2ba7ce8eb8d81e86dce" },
    { "T_HOCKEY.WAD",       "7273986b2e52b191f6a44e707b13c003" },
    { "UAC-HQ.WAD",         "abf2b57cf26a2f487e77cb08b55e85ff" },
    { "UACBASE.WAD",        "abbe3c0aee3c51b0f5b7d91ee9a1ae64" },
    { "UACHQ.WAD",          "9cef96d8e37b20761cb8e52e92f6442e" },
    { "UACMEAT.WAD",        "995b7ea2ef90f2d6d1723296161388f7" },
    { "UACMINE.WAD",        "2ea54fab9c1ef88265e98b07fe8655fb" },
    { "UACMINET.WAD",       "b392990b5a16413d27d29766f29d8e5b" },
    { "UACPEN.WAD",         "381acf10bfe7538dae123b725e56d920" },
    { "UACSEWR.WAD",        "242b5778e093c79503a0cdfd4d838cb7" },
    { "UAC_DEAD.WAD",       "0f29930e33b9f94f2207a73a0b6e8ea3" },
    { "UAC_DEAZ.WAD",       "1bbb1b0544fe25446d875ebbcb4cb689" },
    { "UAC_TRN.WAD",        "8f26a0ce39377382e55c0dceb084d27d" },
    { "UB.WAD",             "b491e935e98ab68d44c7b1856a372bfe" },
    { "UBSCRWD.WAD",        "017a5dbf92212ef2d638af2a09d3001a" },
    { "UBSC_ZEN.WAD",       "a88ed5a99cf24c3bfed7c4f2745130f1" },
    { "UCA.WAD",            "0f3960c2da7e8de9db5d4f1c97d60b92" },
    { "UD1_10.WAD",         "2386fba667f9b608ff8cab52c510a8fd" },
    { "UDD.WAD",            "94b2da3cf6cfff387a7a122fe3afdf54" },
    { "ULTIM.WAD",          "149407973259345d8c1d0e44f880c99d" },
    { "ULTIMA.WAD",         "5ae8c36aa28d339b65e3ad8ee26bea3e" },
    { "ULTMV202.WAD",       "286c62bf5aa4dfb83a31df94cb22376b" },
    { "UMBRING.WAD",        "8581af983ded6cbf951ac040b561a3d6" },
    { "UNDER.WAD",          "afbfd03d707f1496469198fa1e0460b7" },
    { "UNDERG.WAD",         "d8c1ed6459264f8258e8ecca037374cb" },
    { "UNDERSEA.WAD",       "ae21f9c12ab2946b8cc194f9ca461669" },
    { "UNDRGRND.WAD",       "45d774a7ca94a96eedac938b5550d276" },
    { "UNFUN.WAD",          "71f4a015b93470e473f65ce1497dcc37" },
    { "UNHOLY-X.WAD",       "1ea01c626a5fce6f1dcace4ebdd29637" },
    { "UNIDOOM.WAD",        "fbcdb557299f02a029526482735587f4" },
    { "UNKO.WAD",           "f6fe90cc76a01bf518850b1d7009159d" },
    { "UPDOWN.WAD",         "0db765f9bc2ec95c726ecfc4b640baad" },
    { "UPLIFTNG.WAD",       "98801547ea88fdc5d419da7234d705cc" },
    { "URANUS.WAD",         "58835f0917a309f7152860f42337620f" },
    { "URBAN.WAD",          "88c14cd06c9324249b06b5c741f56612" },
    { "URBNBETA.WAD",       "47ab0f444af145869dae25ccf849c98a" },
    { "URMEAT.WAD",         "c24605af5d4ac7519dff1cfae6043d0b" },
    { "USQ2.WAD",           "53293f88e628d5e81302973eed4508cb" },
    { "USQE1M1.WAD",        "f8eb018b112e331528f760209ae6ee79" },
    { "UTOPIA.WAD",         "7ab0d0697f5d5493a6618032feb3b7a7" },
    { "UWHOTEL.WAD",        "37d3e118a6133d73ab25fd88a3b28d80" },
    { "UWORLD.WAD",         "5d94f968f7be71561e73c64cee076ff1" },
    { "VAMPIR51.WAD",       "afdb283b13f5d5a685b0d06b2e986bf5" },
    { "VENGENCE.WAD",       "784acaf7ce55627686639d1202a1f83e" },
    { "VENOM.WAD",          "90f60c29c2de6dd78b0419826f21a1e3" },
    { "VEX1.WAD",           "48efe2287874efb714356545a1f1a7d3" },
    { "VICTIM.WAD",         "0f514400a86f76968e6ff21afa15d30b" },
    { "VILLAGE.WAD",        "8fc9bb8850f9e5c579a68bddfd647095" },
    { "VIPER.WAD",          "87b130e54eaa927a65457570fdc24b6d" },
    { "VISC_2.WAD",         "a1c0a78a0e8eddb3541a59dbae6d3ee2" },
    { "VOIDSHIP.WAD",       "2884deed5dc370348779acf7f47d0533" },
    { "VORTEX2.WAD",        "c57b606b636dfac3630470ba183e5ae9" },
    { "WACK.WAD",           "c612ac40a00c165414af6583001da8d9" },
    { "WAD.WAD",            "efcd9750ec37af06bb02132197a2e4ac" },
    { "WADODETH.WAD",       "55038671155ddb0f4eeab081d4bafaaa" },
    { "WADOFGUM.WAD",       "c412eb0b6b28c67f3cb61aeff94932c8" },
    { "WADPAK1A.WAD",       "d5e6354435b42f6c0d798913be08dfe8" },
    { "WADPAK2.WAD",        "9dd2fd1cfb6806aa02c06923c15a5aa4" },
    { "WADPAK3.WAD",        "3aad7f32097015ebb735222c04141b08" },
    { "WADPAK4.WAD",        "cb609fc9dc9f73c08b8ea73e48668047" },
    { "WAGESSIN.WAD",       "fd2cc407750b0d97043b8a3be8b483d3" },
    { "WALKER.WAD",         "25ea0228a7baa10251a0ede1ff01a982" },
    { "WANT.WAD",           "d0040438e084cad2e2cdb3e09e8c989c" },
    { "WANTMOMY.WAD",       "1e184b3e97394b9617d60591d628adba" },
    { "WANTON.WAD",         "b0381a625a69e13565ca0c945959afcf" },
    { "WANTON12.WAD",       "93ffc7c8043745b4dc2232189f662cb1" },
    { "WAR4.WAD",           "40bfa8de56fc8419b19134a2cc4b3019" },
    { "WAREHOUS.WAD",       "bc3d8f85283979e1cd1f4116517bbd8f" },
    { "WAREHOUSE.WAD",      "1676d141d7ebe3382401bedd44856970" },
    { "WAREHSE1.WAD",       "581d0176e0e228dc53dbcc52ce0e4572" },
    { "WARHELL.WAD",        "4f605b658bbb8f02e4a198fd2eb57493" },
    { "WARREN.WAD",         "96253997d4c1f22aeaf3297b5826df3a" },
    { "WARZONE.WAD",        "6370d9946be8ead8c26b379173cb6d40" },
    { "WARZONE0.WAD",       "bc5e332be0ce166a575f777bd43727c9" },
    { "WARZONE1.WAD",       "1a04caed9fd55e47e7491c441136f37e" },
    { "WARZONE2.WAD",       "b68fa3c7f561c550b08c5d9790b3a2cf" },
    { "WARZONE3.WAD",       "4a5e06ad4f8cc63f173444f5912a4198" },
    { "WARZONE4.WAD",       "9eb29d6ee3250e500eff15c0c39c7799" },
    { "WARZONE5.WAD",       "200ecf2cd097864af163d1a89ab24308" },
    { "WARZONE6.WAD",       "6ee3f9b40193b974d1f8ffad33ce1fff" },
    { "WARZONE7.WAD",       "4dd27b9a5c69c4518485595f90b96482" },
    { "WARZONE9.WAD",       "c4baddd550bb73cea897504eb10dc697" },
    { "WASTE.WAD",          "0f00de27e918c0db627477a9bd6de6b5" },
    { "WASTEPROC.WAD",      "a1eab046f23903eda65378d183a5e430" },
    { "WASTLAND.WAD",       "899a9603a5fee70d91bff460c3412cc0" },
    { "WATCH51.WAD",        "a56a34540ba9f4e40f673dd2e8a06c3e" },
    { "WAYCOOL.WAD",        "979391394234bed01dd31526501a12a2" },
    { "WAYNE.WAD",          "98339ee21e7822866b588d2e91f50821" },
    { "WB1_LOF.WAD",        "5c491aa47616787c85e442b2ee5a0e90" },
    { "WBGY_DM1.WAD",       "86c61836aee43523e42dff94d7bfffe9" },
    { "WEDDING.WAD",        "dead22488170c2f5afd0d2b4a4059dc7" },
    { "WEDGE.WAD",          "8f4e15901026916d895b1a2d7fd185f9" },
    { "WEEZUL15.WAD",       "49989d63a007b7c0d6228b6b18f16e09" },
    { "WELCOME.WAD",        "fa5d1723c563be6a1d85fa86a768ca1d" },
    { "WELL.WAD",           "6976dc0591e12b0ce8c59111c2f62ca4" },
    { "WETNWILD.WAD",       "d2c80fbeeb0e39fd09d25a168a53ff24" },
    { "WETWRKD1.WAD",       "c3b27611e7157d276e66616c74dc5a81" },
    { "WEXMAN4D.WAD",       "22837e0258646ad746100f67fb32f337" },
    { "WHACKR.WAD",         "1e16f6d75d9b9befd269123477373339" },
    { "WHARE15.WAD",        "e61bcdb4cb17d539be9befb38628144c" },
    { "WHEEL.WAD",          "0a597f45fb74a4763f752e92e979ac10" },
    { "WHITE.WAD",          "a94738794129303fdc00878edf6df1b7" },
    { "WHITROOM.WAD",       "98595e21063af0c4d5682d5384576332" },
    { "WIDOWMKR.WAD",       "3d7211b87509cf5ab99a1284dfd37359" },
    { "WILDMTCH.WAD",       "3cd0c406184d73e6b82c64211fab2d77" },
    { "WILDWATR.WAD",       "e9014e1f7bc68dabf1cec3cc01353064" },
    { "WILLE1M1.WAD",       "a475daabc2824077f8b7adcd2de7a06a" },
    { "WILLIAM1.WAD",       "f1bec241b54e7d6aff6871ae09541219" },
    { "WIMP.WAD",           "9c3ece49f839e27cfe9c6bcc5e8a766b" },
    { "WIN7.WAD",           "f80623ca8f7894c38b546c127003b4c2" },
    { "WIRE2.WAD",          "a2c9b36f3f250df0770d8910fabbea47" },
    { "WIRELESS.WAD",       "42dbb106b0bf5a661ad7571919b20425" },
    { "WIZDM2_5.WAD",       "a08401f1846c4fd25d16cd2ce197b9d6" },
    { "WIZDM3_5.WAD",       "ca52f309184ac6eac3c4459fa0b578c6" },
    { "WIZDOOM.WAD",        "e9de1f42fbea85afe3e6d1cc6f730ccb" },
    { "WIZDOOM2.WAD",       "b13d588946e35eabba897f67bc67cd39" },
    { "WIZDOOM3.WAD",       "eccb3724c9a5ec634e1ff952d03a344b" },
    { "WJSHS.WAD",          "4e98bb7ae8e0723ded8218239a7535ef" },
    { "WLABS.WAD",          "4dd40661189c8383523cd66ccdda5562" },
    { "WOGA11.WAD",         "013d798d4286972c4aa781211b65566e" },
    { "WOLF.WAD",           "abb13f8ff547a091b28a1612ebd8d608" },
    { "WOLFB.WAD",          "892f4c69f788cb164533cd74ab7c037f" },
    { "WOOD.WAD",           "e715a833f20f4f1a31272304317d93b8" },
    { "WOODHAL2.WAD",       "4234072fa0ec5fe5bb7e294be33810f2" },
    { "WOODY18.WAD",        "5c452051d43d56e1526e76e5024ff917" },
    { "WOPWORLD.WAD",       "53a7a7810011b2830459a2f99660801a" },
    { "WORMS.WAD",          "5fb2e5c5c3f076337d54db69973905d1" },
    { "WORMSHT.WAD",        "229429b04ea5a13a7c289011f61c9dec" },
    { "WORMSLEV.WAD",       "1e451aa1058c2e5e055d4f66e0b6afd2" },
    { "WOW.WAD",            "f598111c5da138a41d9ab2c39be6ba35" },
    { "WRECK.WAD",          "9b3efd19d245ea22eff637e371136b17" },
    { "WSARENA.WAD",        "69af60bddbc332f31f7b9198d7e05001" },
    { "WSCHEAT.WAD",        "536c1c7d83a3cc95eca26acbe7aaaffb" },
    { "WSPRISON.WAD",       "78fbc197e3e94fa77884a70988774263" },
    { "WSTLAND.WAD",        "8a40db72ec93a679990518ec5eb3feee" },
    { "WSTOWR12.WAD",       "08a39b543c804c98426f6e2144bacce3" },
    { "WTC911.WAD",         "36fb141417388e2fee817d6d13f90854" },
    { "WWF.WAD",            "585c1311f6d01c7fe801a1399d08b2fc" },
    { "WYB_E2M1.WAD",       "46a4a06f7f9372257b0e0f77936fb41a" },
    { "X.WAD",              "7e1c9b67ed0329af8eca3b4c4b076135" },
    { "X8A7.WAD",           "e5c81735d08b096e51f58d02f8012869" },
    { "XCALIB11.WAD",       "1897643890c81791216d9633c5f35b2c" },
    { "XENO11.WAD",         "33e64e4f1479d905f2cb002d2cb37da1" },
    { "XMAS1.WAD",          "29da06ccdb14979521bae5223d467df3" },
    { "X_INGS.WAD",         "daec1563ced06a3bdbda29dc2bc46e8e" },
    { "YAKWORLD.WAD",       "c93e17603303776ec2bc5f6dde2fe208" },
    { "YARD.WAD",           "03e6221e91a8fec2d71ea6754baeae6a" },
    { "YCRBYCH.WAD",        "e9fba074b48ea3f547d61d7c730a38a3" },
    { "YES.WAD",            "0c74c050131c989f03ef205f0981f8b7" },
    { "YIKES.WAD",          "23346af88b4bcfd66e831c398893b2f3" },
    { "YING1.WAD",          "54bd91bd87f35751504cc2859a8820d7" },
    { "YOHO.WAD",           "ab62f88888c54506e9de38d83c0cb1ca" },
    { "YOLO.WAD",           "087348500eccdd673dd2026564aaf8c8" },
    { "YOUNG1.WAD",         "76a1d545760483e0902c149cddf93b6f" },
    { "YOURDED.WAD",        "db9b39b5f3293e4c6895207bbda776d9" },
    { "ZAPHOD12.WAD",       "b5fe746218fdfeb1d82006c2d422f420" },
    { "ZMAZE11.WAD",        "9717ffa862b9c29b18a94eb63629c232" },
    { "ZONE.WAD",           "874a6b3be1906293c227729ff9014d8d" },
    { "ZONE13.WAD",         "d0cd30e99db9d3241ff95590772adfe2" },
    { "ZONE3.WAD",          "b25921c209e90d6c65ebc910d7d31cd7" },
    { "ZOOP.WAD",           "a63ac7630633588ea5d8332fd2b8b224" },
    { "ZOOPH.WAD",          "b70c549c80da6bac64a16efeec96ec97" },
    { "ZORF1-5.WAD",        "ec3fb64064484f32a467dd71d3ce22b9" },
    { "ZPHSPRIT.WAD",       "5ac65705123f7d3e5ace7c1c869c7f2c" },
    { "ZRAT.WAD",           "7efdea5147040a26b828a54f7f18cfa5" },
    { "ZZONE.WAD",          "9cacf44c6d45184f4c0442251e3fbb6d" },

        // DOOM 2

    { "!FUBAR2.WAD",        "480fe9b1c0fccf9d9d4efed477aa7515" },
    { "!FUBAR3.WAD",        "234ef02112a390ac453dc1dc9af6c27d" },
    { "!ZWADED.WAD",        "8bb23ca60cf15a135acbfce007f9489e" },
    { "#1GUMBY.WAD",        "2e8d736e20a71688fb81fde8bc9884c6" },
    { "#AFTERLF.WAD",       "63b3e98699e2666f958bc5cde5407496" },
    { "#AVENGER.WAD",       "3801c256fd4240fe58c4432aa5f806d4" },
    { "#BLOODR.WAD",        "6a5002ae80b17a50506b87462e5157c8" },
    { "#CAVEMEN.WAD",       "6731e86373e2c93f4087e4533ed11082" },
    { "#DCYCLE.WAD",        "5bc4f07d90af8566d62b61e42d2d2778" },
    { "#HHARBR.WAD",        "11dab67cc613e62117990394e636d9d6" },
    { "#LIVEND.WAD",        "095c6b8188ae1c0befea19c68e82dc4c" },
    { "#MSHIP.WAD",         "5e3f6b613755c674c8f9c37d1cc70b58" },
    { "#SENTNL.WAD",        "161150e1e005e530f6007b888f69d5e6" },
    { "#SLAB.WAD",          "3fbed802f36b0f92d16cc354741e1209" },
    { "#STATION.WAD",       "2e4342e728ecec80256bd90eddebdacb" },
    { "#STHOLD.WAD",        "6122e6d4f6a4f4bb0c68458818892b58" },
    { "#SYMPHOD.WAD",       "4d35fdcbda31ad93f983a9cfe7ddc79f" },
    { "#TROJAN.WAD",        "4070d4e53747066381549c9c44d5374f" },
    { "000EMG.WAD",         "c7f1420897f97913c0590f0850c4b8af" },
    { "001.WAD",            "8918030791feed89389e035ae7a5d9c8" },
    { "002.WAD",            "ebaf6f3757c1a3b2888a69d608bf8734" },
    { "003.WAD",            "8384f01de01c90131abd7b244ab50187" },
    { "007TOWER.WAD",       "d5220ce23272f21729d67d7a615cca77" },
    { "01.WAD",             "3092fd818f709be11032c4c54aefd2da" },
    { "01ARND.WAD",         "367fe2c400a954c0de517b3f714fc7d3" },
    { "01CYBRDK.WAD",       "010e64d1b6701fd87d446c1f157948fa" },
    { "01FRAGEM.WAD",       "6a96321070fc932fd95f2c5b8839edcf" },
    { "01GORRY.WAD",        "56630eb5552908a1ac93066cc598e27e" },
    { "01JMP4IT.WAD",       "e80d22c08ddeae5be723ec0f45487fbe" },
    { "01MKSTND.WAD",       "72f746531cef7653e7a88fe6ab921013" },
    { "01MRATLT.WAD",       "8068f79cf83c9f442b75a570875761d4" },
    { "01PHBWAR.WAD",       "4be714060e33e286257f28b08748877a" },
    { "02.WAD",             "0f92ce06f7449736c89615c7b54bd261" },
    { "02PHBWAR.WAD",       "99ce22e432d8d8e3b398ca9a9d91c5df" },
    { "03.WAD",             "616d255bfe0b04293b8797ef1e6fa6f4" },
    { "04.WAD",             "b83c667e0c8245dde8e9178bacf99741" },
    { "05.WAD",             "2fecb8ee364228ce9ce5945a17e83250" },
    { "06.WAD",             "3767fa08d7347650b60fa30751e0442d" },
    { "07.WAD",             "791274b5047ca16752da06338c171fd6" },
    { "08.WAD",             "3cc9303e10921f4e988c1acc0e192dee" },
    { "0LEV1.WAD",          "f9f64349c501b42a3b2660f27f2e4867" },
    { "0SCRAPS.WAD",        "b0e592c3fb963f45c48e3e70b5b710a7" },
    { "1.WAD",              "0131798062586a95dfb3df2c9224fb03" },
    { "1.WAD",              "5d00d4aafcf6e56070468feddce72427" },
    { "100%DTH.WAD",        "56f8871918ba9a88cbdda5e87c15ea9b" },
    { "100PCTV2.WAD",       "d82af88e6144b7bababa86369e6c8dba" },
    { "1024PC01.WAD",       "486d823b56eac426405f0ad56df2b7cd" },
    { "10KNL.WAD",          "5f3f0038ced8eac5a7fd306f496fc8e7" },
    { "10LEVELS.WAD",       "99c5da26e16950cf5089f2e1ca65111d" },
    { "10MUSICS.WAD",       "949b450b64f3e23159645cc6f8e2b682" },
    { "10PAK2.WAD",         "dfa1beb707cab5777997f544cdf74e94" },
    { "11D2LVLS.WAD",       "655ef3771dcb42395bce4e852872e094" },
    { "11LVLS.WAD",         "f6c27cd4d96be3d2171ff49a9f99394f" },
    { "127TECH.WAD",        "d8701a5997c65a4d56529580fb86acb9" },
    { "12DIE4.WAD",         "6a3f72d779699c759f080ea0f4e5f087" },
    { "12TUNNEL.WAD",       "ec63b2e55caca4e298c276bc3cc3ace1" },
    { "13.WAD",             "713133e58c5e0f8062a8bfb6b6630aaf" },
    { "1337.WAD",           "7141b2247ae9e2528500d24a2868f9d4" },
    { "1DOFHELL.WAD",       "40e45995213f496ab1d2208e3010f23e" },
    { "1FORTRES.WAD",       "cf6153d1606020c377b0f06f8fcffff6" },
    { "1KILLTNG.WAD",       "ed85ad279ef3620f66e9ab414aa3a720" },
    { "1K_DM2.WAD",         "04606998b3859fbe8ad34e0a0c05ecb5" },
    { "1LEV5.WAD",          "6d53292c2ac30044b848f51f0ef54412" },
    { "1NUKPLNT.WAD",       "c2f43b8d0fa449fc13056054c1ae0ac2" },
    { "1REDUX.WAD",         "fdbb4deb4a8864b940bce588968500c2" },
    { "1SHAWN.WAD",         "97f09e8107b03481432eaaa170c54873" },
    { "1SHAWNDM.WAD",       "f15304d3d565c6a04080d3f399894304" },
    { "1SQUARES.WAD",       "74a82fb17f3cf88db05a3aa825cb74c8" },
    { "1UNDBASE.WAD",       "09aa4be753668981b02328481caa705e" },
    { "1_FUBAR.WAD",        "a48abf2002ec684af9c7c0f385eac790" },
    { "2.WAD",              "b80adfc47525b6981d55d90279687144" },
    { "2004AA.WAD",         "1406b4650f94fbffa99d302dae2e8def" },
    { "2099LEV.WAD",        "53fec45d26df32ee681a106f5b3565cd" },
    { "2099SND.WAD",        "58235ac003b9cc95f12055511115bb14" },
    { "2099WALL.WAD",       "21658141cd7aca8d4a88b2b54c4770bb" },
    { "20DNHELL.WAD",       "363e4e391da8d0d159a0741ec75e1041" },
    { "24HOURS.WAD",        "dbdbd6d7718c57aed8b38d2e9ee135d1" },
    { "24SOUNDS.WAD",       "3f3463d5d2ebf654f5317847902346e7" },
    { "25%DOOM2.WAD",       "8a2548c65350b288a0af820a463f4495" },
    { "2ARENAS.WAD",        "3fc3609c8db07c18453c487380ad963f" },
    { "2BESIEGE.WAD",       "77334e1ec736d758d9962edec3e53623" },
    { "2BIGRMS.WAD",        "53b5b98dddb3dd4ef5942df61f6c18d7" },
    { "2BRENT.WAD",         "910b4b53402091fc2677d66807681b61" },
    { "2CCENTER.WAD",       "1538fe42c418dd179c7e477d3ee4a868" },
    { "2COMPLEX.WAD",       "013ed5efbafa2bf6880bd5dc67753b19" },
    { "2DEATHS.WAD",        "8b70302ed4a2a7c499f0b33aa9963f94" },
    { "2DEFWADS.WAD",       "61e72de450bb1581cdc1674aaa8aba46" },
    { "2DESERT.WAD",        "288e3fcfe6b4a805d3f2a03a3a80b8c1" },
    { "2DGDM1.WAD",         "93522f6a57c277712a9484dc61aa8410" },
    { "2DIE.WAD",           "defbc2c5e3c5266af999b2df41aa4d93" },
    { "2DIEFOR.WAD",        "7da0c679fc11d144609161941a02b628" },
    { "2DIEHELL.WAD",       "d4fa4ba245d52e1d045b9ba8b0da5bf9" },
    { "2DMMAPS.WAD",        "fe959bb578bd9f274f1ad2da00897866" },
    { "2DRKPRK.WAD",        "8dfb6a090a6d0cef8f734de179f14870" },
    { "2FOR1.WAD",          "2df346ee3da98ea1182b714aed4c07ad" },
    { "2FORTCTF.WAD",       "c1d5cce4e42de6c35b1085b6df0425b1" },
    { "2GETHA.WAD",         "f510637cbb1cb3168a550650269decad" },
    { "2GOD2.WAD",          "898fad5ceffe63110419f9288544578d" },
    { "2MEGA.WAD",          "0ac6e8d0a5a6b9be8f5424b4c8e8d615" },
    { "2NDBLOOD.WAD",       "7256fd95be78ebd82e0e675aa7d81c59" },
    { "2OBERON.WAD",        "3f0c6375a9ab7ebe3cc0e8365944ddd5" },
    { "2RFINERY.WAD",       "0ace571e57f6604a577877f16337e326" },
    { "2SCHOOL.WAD",        "8170f188e51f4eb6513c98779350cb7a" },
    { "2SHAWN.WAD",         "964ddff6f6d81329bcc7bab8d334c33a" },
    { "2SIEGE.WAD",         "0f5b97279f7c89854f0337f81314fa31" },
    { "2SPOOK35.WAD",       "bf365b539264c5cb158a1e6b2d5f59ab" },
    { "2THEDETH.WAD",       "2bbc71f7b35a5b437a200b69ab9f05d5" },
    { "3.WAD",              "9065be5f2aa94e0e5d8219f8c414e54a" },
    { "3.WAD",              "f134620da6d4611a2d3ded7ac2e1aef5" },
    { "30LVLS.WAD",         "7a307168ed9ccf0109726ee6f0e4b7ef" },
    { "30WADS1.WAD",        "8e41dadb1aed9484ec3230869827d14e" },
    { "30WADS2.WAD",        "e81ffe57e017b32cea25677075967fbd" },
    { "32.WAD",             "a57b575e68e545f9644d2c96760df639" },
    { "321DM.WAD",          "0bea6b487752dbd65f7a17d92a9a63c9" },
    { "32HNPAIN.WAD",       "8e558dd35f12f70010e32ed049ad8fb8" },
    { "34.WAD",             "7f620b3afffd6c09d7d52b2f7f18ac3a" },
    { "3DAYPASS.WAD",       "de9b94d79660764899a978190a144e98" },
    { "3FUN.WAD",           "f70691d7b3f261783fabda543d62d236" },
    { "3KAAE.WAD",          "0ad0860067f559dd7a6b3f992dd62e08" },
    { "3RING.WAD",          "567a87d4881bef2f36006bfda0a4d0f4" },
    { "3SHAWN.WAD",         "2bc148fd42d87774e52760d2bdee8a41" },
    { "3SMALLD.WAD",        "547761b782fe0439e65bc030494a0030" },
    { "3STEPS.WAD",         "ac4a8b55742f7eb872f203de69d9ae53" },
    { "3WAY.WAD",           "bb4371086911964dc7383902819d2e5f" },
    { "3X-PLAY.WAD",        "5f6b833622082e9c2c0e28d31ab988a2" },
    { "4.WAD",              "785bdfa85da6245f93bee858ea24cd33" },
    { "4A.WAD",             "4ab0566004380f003d0a9a9b694502c3" },
    { "4CORNERS.WAD",       "4d666b5bebbb3c07cef3191b23f11957" },
    { "4DAFRAGZ.WAD",       "51628336e887bd41ba74faf42f71ec98" },
    { "4DESTROY.WAD",       "1eaa33c050c993e8735a4c6db5cf1e88" },
    { "4FACES.WAD",         "4f1da340e2cc910b2dde4e2ad7f90b76" },
    { "4PDEATH.WAD",        "540a207b443f80cb04687e103b2cc401" },
    { "4P_DIE.WAD",         "3b0126f5aea1a3eddf5c08dcc073b405" },
    { "4SEATS.WAD",         "179398fef5c8d1fbcf3388934a553889" },
    { "4SHAWN.WAD",         "af1e901866a007e32e494b156a681e11" },
    { "4SQUARE.WAD",        "2c249ad91291af1fd7b6c88a68a35baa" },
    { "4STARS.WAD",         "d3c076b52ac2162e4a11a7a5174359b9" },
    { "4TOWERS.WAD",        "5dddb7d1308207fd3df03bef4ce90e80" },
    { "4TOWERSG.WAD",       "5fc49a32af430df10763bf89ae03575d" },
    { "4TOWERSM.WAD",       "ac0cdcec76f95ee3a70a49b68e145787" },
    { "4TOWERSS.WAD",       "7cee5f31142ebdcf7da24baf32c781c2" },
    { "4TR2.WAD",           "c0ca00fa1b85a195ebb06b8a28bfb7af" },
    { "4WAY.WAD",           "f1ab4d000c54c50da8ba720c105d53e3" },
    { "5-LIVES.WAD",        "488ae0dbe34f34cffe6fea0365948a9b" },
    { "5.WAD",              "d79ca38a52698c120cd85423be3d9fa4" },
    { "50FRAGS.WAD",        "03c034587c5f22274fe8ea2c9d858a9f" },
    { "57EAST.WAD",         "f479a53743d27f9217a3ba78cc7c4fde" },
    { "5SHAWN.WAD",         "acc70179dda743e9e7b9d3727a802e1f" },
    { "5THDOOR.WAD",        "127c09c1ec14855bc48c6f5fc998ff0e" },
    { "6.WAD",              "6bbfee46020e2d325dc383dc98b1214b" },
    { "64.WAD",             "9f528b176d0fbc77faebb29ca3f27ed5" },
    { "666-T2D.WAD",        "8f922bedda83badd15325046abaaa803" },
    { "666_TNB.WAD",        "ab5c1c6cd36df9b5755ea8758944bd31" },
    { "6DM2LVLS.WAD",       "15a803b9e21fda9f8aa5a538eae9249a" },
    { "6LEV.WAD",           "ce22fdf199a91ba264d9a030f8f78874" },
    { "6PACK.WAD",          "7151c8fbfd3d2530051c0eca36f5d791" },
    { "6SKULS01.WAD",       "5061c59ca7e7b5d11fd6f06eac46d0c1" },
    { "6SKULS02.WAD",       "fa1919369cc62b051fb97d7c5a38fa36" },
    { "6SKULSX.WAD",        "d44e492d6a49a78729db72aceef86ecc" },
    { "6SOUNDS.WAD",        "cf2b2961e7a41c44bda8d19d453c6e99" },
    { "6T9.WAD",            "a0222067f7ded678687ffa7db8785e1f" },
    { "7-10SPLT.WAD",       "1232b4d75cd47ccdb24d6b161a7933b9" },
    { "7.WAD",              "4046627edb90ef32c4a46ab4e18759da" },
    { "7CYBDEM.WAD",        "9b4100ab0a628ceb1cc0a9a662353577" },
    { "7DMXDM.WAD",         "d82a78feeb6066cf5603e8574618cbb2" },
    { "7SCREAMS.WAD",       "98d1d89cb26f1c2337e7de496782896b" },
    { "8-BALL.WAD",         "3860eaba989eab6ea121e2e5e434153f" },
    { "8BITDM.WAD",         "3f6d905499b128ae4c0a40b3c0ab03de" },
    { "8CITY2.WAD",         "51dc0cc998fa16a22b9934d648c72372" },
    { "93TALIO.WAD",        "078c9e21421ca1c339ae4ede3f12bd74" },
    { "99WAYS.WAD",         "986b4ef1813bda9faad569de041fd0a2" },
    { "99WYS2DI.WAD",       "cff0e4d54d6a46920509dcdabe2c1b4f" },
    { "9THFLOOR.WAD",       "0e765b720246094f1a855dc6cb6e1944" },
    { "A1-SNIPE.WAD",       "caae8ead32b34f2087fb54b4ef6273a3" },
    { "A1-SNPD2.WAD",       "0351dac4924497c9c2d2c25218554a63" },
    { "A1-SPACE.WAD",       "4b55db9ff1b3254d2938aa0a40f6d7ae" },
    { "A1.WAD",             "a52a81dd411f3f59b9ca62e4d17bec31" },
    { "A1.WAD",             "e97e9da69d0998e47978b22d4b60722e" },
    { "A1BEST.WAD",         "dace3c15064b5c67bfca6cba3686a52d" },
    { "A2.WAD",             "637a10410d6a40cc0f1ef680ed7b41c1" },
    { "A2.WAD",             "b1ef81991e3ad52868ca1ef296c3d17c" },
    { "A3.WAD",             "842623a9d23ee926468a11f44c9130d9" },
    { "A4.WAD",             "f152b41e6c385ef4a6cd89b0a9defeec" },
    { "AAAR20.WAD",         "f7636508962f14948b96cee1831b566e" },
    { "AAK_WAQ.WAD",        "87f4c4f8884b6e21aa9acbb055dcdd07" },
    { "AARDVARK.WAD",       "7fd1851fe8b675327b873f7d7eac3a59" },
    { "AA_BTH.WAD",         "02582b2586a9b2fb0ad9f8664e64fd92" },
    { "ABATTOIR.WAD",       "b533c53a47f5ca85b6c9a0773603b0aa" },
    { "ABATTRD2.WAD",       "b906939b19aa339ad4551f6e8ef15b43" },
    { "ABB2.WAD",           "0fa32b1e3cb28341e7c57005ea87d21a" },
    { "ABBSDTH2.WAD",       "3db9db246095c2960f0034cc6b8812d3" },
    { "ABDELAZE.WAD",       "448f1d8fd3a5c57bd20f5689c9309e24" },
    { "ABIGJOB.WAD",        "cea9665938e19fb9e0874cd72a941d61" },
    { "ABIGOR.WAD",         "61528bca7405782294cf8f9d87a3201b" },
    { "ABIOSIS.WAD",        "16ce1846d481aff678db39b65dbf4f16" },
    { "ABOO4.WAD",          "eaa53d41f9485fd5d66c71d876790f6e" },
    { "ABOOCEAN.WAD",       "1270848a40df0066beb1598bcd17b81d" },
    { "ABOOJAIL.WAD",       "53ae0f17efb2b2218542df81c53b1401" },
    { "ABOVBELW.WAD",       "86f768631e23de27197428be8375fb37" },
    { "ABRAXAS.WAD",        "25c906f2d1b9159eba130ca061a16c90" },
    { "ABSOLOM.WAD",        "f5a65cce988812f563cc55c5d7f2276b" },
    { "ABUVBELO.WAD",       "e89acb87684fb49b1d2636123c9c9c52" },
    { "ABYSS.WAD",          "f8584798392a8aba63314c6ed40f94a6" },
    { "ACCURSED.WAD",       "ee1f0af11c2183ef0c429223076a50e9" },
    { "ACD3A.WAD",          "553bd8aa088f482454fb6570d430cda6" },
    { "ACE1.WAD",           "44fac4ce8041ec124b5f61839c2d2a11" },
    { "ACHERON2.WAD",       "269b816e7457ea24d0fca81059d1b3df" },
    { "ACHRON22.WAD",       "58fdafefd08cb2e1841aa49052ff78bd" },
    { "ACID4.WAD",          "02da10a140a0e1ecd4dadd4b48980a5d" },
    { "ACIDAREA.WAD",       "1a82b2d0063f7cc9f2050ce4091d2ae5" },
    { "ACIDFALL.WAD",       "0a8b9b2d677ddc9afefb1af609f402c6" },
    { "ACIDHELL.WAD",       "b3041ed1bec70531faeb4dbe4e0234ff" },
    { "ACIDTICK.WAD",       "095cc62ab5b7e4c139edf6078ca327a5" },
    { "ACITY101.WAD",       "cbd6e461c1db1bcdf938c44812839e41" },
    { "ACRPOLIS.WAD",       "541bcde6ac363167afd41251b70ea40f" },
    { "ADAMDM1.WAD",        "14202c2411ae25ea424259b5dbcba6f7" },
    { "ADAY2DIE.WAD",       "bf03a827c46925bf9e8269c657a71112" },
    { "ADCOOP.WAD",         "8f7bae0903a52180e666df0254d8eee1" },
    { "ADDICTED.WAD",       "c0cd120f44139c86d231a85de9c65a31" },
    { "ADDICTIV.WAD",       "9e8020df86f2821ae60f5801b8d54840" },
    { "ADDMUS.WAD",         "a648c946638e1c7fa29ea2101e428697" },
    { "ADIEU.WAD",          "e473967292427224c8c6f2911ec2eede" },
    { "ADMORTEM.WAD",       "c7cabdc1a9efa97c91bca51bea24378d" },
    { "ADMORTM2.WAD",       "3bf6392fc01394cc9ab6de210358d83e" },
    { "ADMORTM3.WAD",       "e3a6d5c4a4ed36d9852130944ac3d526" },
    { "ADMORTM4.WAD",       "5f7a624f3a5b7a38c961c67d3a1023c5" },
    { "ADMORTM5.WAD",       "b9ae514b07488be69e48c50e12db8316" },
    { "ADOLF!.WAD",         "e4d2985391002bdf753bb2a896333d53" },
    { "ADOLF.WAD",          "043fe70aa69b4fb81c2f718709bca215" },
    { "ADRNILIN.WAD",       "bf0b9f32f7882bec779a54a6eaac78bd" },
    { "AD_4_DS.WAD",        "e8e77beec0519b0ccf3e5b32ed9ce6bb" },
    { "AD_DEMO.WAD",        "37956ecfa9c22e7d2fee7e86194dc58c" },
    { "AE_TUPS.WAD",        "a4de5f6b6c274def39962a754feaaa9d" },
    { "AE_TUPS2.WAD",       "ec019a7935be52f2db7466b339fd52a0" },
    { "AFRO2.WAD",          "19ed8b93f7e99d06f95c258f6c75315e" },
    { "AFTERDM2.WAD",       "f321392b108ecc4ff017a8e3b46b4c94" },
    { "AFTERHRS.WAD",       "ccf197f6b8d17570be8996f0d9b29737" },
    { "AFTERIND.WAD",       "05e6b7f3c5025ca6f9683daf4b914f26" },
    { "AFTERLFE.WAD",       "7bd376433999f778a409565b826480c6" },
    { "AGAIN.WAD",          "82e6f1fb6c6d70c45e7733ca0992effc" },
    { "AGEO.WAD",           "0d1a283e3f0785b7f60a5a4a272b09d7" },
    { "AGMAX.WAD",          "b5a1d4bea8616f7007c52319c480b650" },
    { "AGONISM.WAD",        "f66cf5b359f241e1d13b5332cb177dab" },
    { "AGONISM2.WAD",       "0edbf3e581857198cc9af4f01e4aaf77" },
    { "AGONISM3.WAD",       "7acddef5ee27839385cdc1e542af2c0f" },
    { "AGONISM4.WAD",       "8f2b261b134370b22c06306b67381ec1" },
    { "AGONISM5.WAD",       "54f7d62f5fabeea84587b1c6be67a7c9" },
    { "AGONISM6.WAD",       "de11f6289b3d84637c6298ddd36299a5" },
    { "AGONISM7.WAD",       "2caf6ca750802dbec9d4be113fc7ec31" },
    { "AGONISM8.WAD",       "0347736e17e48b150da69c2f0683b966" },
    { "AGONISM9.WAD",       "212a9796b07b3c3d0cfbf4d27379dded" },
    { "AGONSM10.WAD",       "e94c3756585cbd8aceafe0caabca2dff" },
    { "AGORA.WAD",          "841e3f1d30778c11d09b3ca9c48ac02c" },
    { "AGX22.WAD",          "f14aa4e7dd31a8df8bd2179b0502a25d" },
    { "AHAUNT.WAD",         "ad0bc9cf120f45fb24b77bcf70f7dc86" },
    { "AHELL.WAD",          "f696e25679c055bc2b2b847fdd613f2e" },
    { "AHFLATS.WAD",        "123c25bb8a0f220a98840c390b897e45" },
    { "AHLEVELS.WAD",       "20262060e322ea0d127555ebe59da33c" },
    { "AHMUS.WAD",          "fbb236ecf74c5fda43e876af98433c70" },
    { "AIMLESS.WAD",        "fa8d3f1854ccc44226ca3cb111b65e37" },
    { "AIRRAID1.WAD",       "f0fadb2342accb6cfce5774444917f40" },
    { "AISTMF.WAD",         "3837b8d47efd771e891d1acac38f341e" },
    { "AKMWAD1.WAD",        "ec49cc7af92ec267e4d101172fcff317" },
    { "AKQ5.WAD",           "7ce7b04e6061e4ed427ae39832c2db3a" },
    { "ALAB.WAD",           "21a9be5b9ae69fa579bb517ea5a09620" },
    { "ALAPOLGY.WAD",       "9993603de75bd9817f45d6c544e7c424" },
    { "ALAS.WAD",           "fa6ca0616924582068a2c9ebab5b9a19" },
    { "ALCATRAZ.WAD",       "85d0a60a568bd631855890883d785f9a" },
    { "ALIEN.WAD",          "047043e86846fd5ace46e1d058ddc9d9" },
    { "ALIEN2.WAD",         "4101444b0d07a1ad4808a706b2dc109f" },
    { "ALIENDM.WAD",        "c344f58a66268ecebfdb7b7c4a09c43f" },
    { "ALIENFX.WAD",        "7470696552119954736dff3c6d7acf2c" },
    { "ALINEALUS.WAD",      "ec7c5b67c4a69fcb94063f5bab7f7aa1" },
    { "ALLALONE.WAD",       "2e8612a73a36d5d71a6fa3f551969d76" },
    { "ALLEY.WAD",          "49c731273b47f3a50f220fdbee6a331d" },
    { "ALLEYPAK.WAD",       "163bad1a4c8aeb3aecf1a1b797d55d46" },
    { "ALLEYS.WAD",         "04d83343873c802f4c8257c7c75f4f79" },
    { "ALLHELL.WAD",        "ff9e5551e5a993070e3cb84a1d620c77" },
    { "ALLMXDUP.WAD",       "bbb35351713ca30ed768983087a9ccde" },
    { "ALLSKILL.WAD",       "5cf0ac17738eb3aa8527f78f9d2f3b36" },
    { "ALLWRONG.WAD",       "0a82e3b3cd0bf6d0f256675efdced57f" },
    { "ALOHA2X.WAD",        "20a232e4b69d8587e5c5cecffc29f603" },
    { "ALPHA.WAD",          "d97752c4dce747a7107be08caac65413" },
    { "ALPHA1.WAD",         "8db5c92aa70ec725647772a543d1f188" },
    { "ALPHABET.WAD",       "0765fe986f35efcd7bbc3ad0efe5954c" },
    { "ALPHADM.WAD",        "23d624edda15039beeda4f3326df95a5" },
    { "ALSDM2.WAD",         "28fe96c8a0033c63c61970fc5a20639b" },
    { "ALSDOOM.WAD",        "1ed241768d1e911810a5c6b53ffb5067" },
    { "ALSP.WAD",           "10bca8a52933a8ceeb40afc684d878c9" },
    { "ALTAIR1.WAD",        "7cc7c198ca3349527ddf140af59a44c3" },
    { "ALTAIR2.WAD",        "e9d4a04a1d5477d3bb4ec2eace23cc75" },
    { "ALTAIR3A.WAD",       "0f4bb760710748f15fcc76c552d087ea" },
    { "ALTAR.WAD",          "922953e155379cbcb8a0007dcea55bce" },
    { "ALTD2.WAD",          "6cf597ee0233e446fd4025396d075084" },
    { "ALTIER6.WAD",        "3233f1323cac3ab6f47e01c169773e5a" },
    { "ALTIMAC.WAD",        "c4bf6b67ed215415cce049f68d98897f" },
    { "ALTRFLSH.WAD",       "81dfd323ed2d8bb3ed20fdf4da787114" },
    { "ALXDETH1.WAD",       "223bea5951b2e346e5a187d170522c8e" },
    { "ALXDETH2.WAD",       "eeeb7c9320d333af8b46187c15fa58c8" },
    { "ALXDETH3.WAD",       "b68c7757daca4f2a8d3f8c63e555f8db" },
    { "ALXDETH4.WAD",       "85a91d0ad33e6a5c27342e93d50ac1d0" },
    { "ALXDETH6.WAD",       "e728b0d58295606c54301369d64a51e9" },
    { "AMADEUS2.WAD",       "0c91ab1b1e3b5a5c9ab816abca147c26" },
    { "AMAZING.WAD",        "3dc4829a63851b8ad2b9c5dc0fe4437c" },
    { "AMBER01.WAD",        "e8d1962f6c8c85bfcbf95c1d803a243a" },
    { "AMBER02.WAD",        "83bb7843ea298c2025b1406a9c82ee16" },
    { "AMBER03.WAD",        "ba5d73048078648ac23c04efcbd2b912" },
    { "AMBER04.WAD",        "024339470933a41bf88bfdcb181e6a71" },
    { "AMBER05.WAD",        "94370d133493d90d9f73a8dfe1453e68" },
    { "AMBER06.WAD",        "9242058e32d938c8ac2f2f52bd669090" },
    { "AMBERX1.WAD",        "aef7c6cbef792556b5f94bfe6c0a079e" },
    { "AMBUSH.WAD",         "8f5760d3fca534a6e57c647da0769b16" },
    { "AMBUSH2.WAD",        "b877305347ac7e3be1756aa3e37fecbd" },
    { "AMBUSH4U.WAD",       "295834802042e665d30e4b230726f031" },
    { "AMBUSHDM.WAD",       "b0c31bb6ce5dec007ff1aac2a9f1e08e" },
    { "AMIEVIL.WAD",        "c449e2ab6861603e617161a77cbc7f21" },
    { "AMINESII.WAD",       "c90b1f06011d5067f528ee8cd434fb4e" },
    { "AMOK2_11.WAD",       "d9ff3819fb10ce50c6547989fd47f2c7" },
    { "AMTM.WAD",           "41bbeaa7dae8e03a64540ccdf2123283" },
    { "ANADREAM.WAD",       "14acc045914ddc28a8bfeab0ebb9566b" },
    { "ANAKIN2.WAD",        "46aa147885f9ff7466ee0ef809a9feb2" },
    { "ANARCHY.WAD",        "f5718b34604584123c0852ed09cc1fb0" },
    { "ANCIENT.WAD",        "c4c1fca8c10ba0e5209993906e2b9094" },
    { "ANDR.WAD",           "57e00431957ff8bf97efca1c7d1c11d1" },
    { "ANDREWB.WAD",        "75f696615d92b6f65520cfd46136dfae" },
    { "ANDREWB2.WAD",       "82b948e2843dfd5335b638d8ae8eb7cd" },
    { "ANDYHOME.WAD",       "7485f04745e59a55db6d160d8113cb5c" },
    { "ANEFECT1.WAD",       "03549d86f8fa2942a16a890d350bc21b" },
    { "ANEFECT2.WAD",       "9277db75811a0a5f400c6d5416bb9057" },
    { "ANGRY.WAD",          "8e2ac0da5c35986c57fea34cd737a3b8" },
    { "ANGST.WAD",          "8de776ba7f05d8d2d390072e81166506" },
    { "ANICEDAY.WAD",       "739d8db5c1f89488b24d140d100371a7" },
    { "ANKH.WAD",           "75520eb154c01b3428d03b0dfc8ba907" },
    { "ANKLBITE.WAD",       "bb8e65d712129060c19b4bca19c24dc6" },
    { "ANOMALY.WAD",        "00a605251b95e4a4853d09cfbc151399" },
    { "ANOTHER1.WAD",       "d13cc020d7e8a1fa9dbafb1b5f452d1a" },
    { "ANTAGON2.WAD",       "39b7583ffe62cb4a81ffa8370a0a36b8" },
    { "ANTARES.WAD",        "c916f479c774f9eb45318b684a9a3067" },
    { "ANTRAS.WAD",         "1e69fdf0c0ff6f8ce3a74e3d8cd57f9d" },
    { "ANUB_GRA.WAD",       "b416d02b656206f4cb8e0bf1cebe1ba7" },
    { "ANUB_LEV.WAD",       "c72aec4086d7816c5b1520a143529ad7" },
    { "ANUB_SPR.WAD",       "7e100c831f49568d33adc7a1c48088f6" },
    { "ANUB_TEX.WAD",       "45cd2f72935ae3c951b789ca5c17825a" },
    { "ANVIL1.WAD",         "8b62eac7c29575d12fe875bfc27792d4" },
    { "AN_COOP.WAD",        "3f78147d81b7fbf01c3bcacf6c641c9d" },
    { "AN_COOP2.WAD",       "62134bc2e6d378cb22259439d5260867" },
    { "AOA.WAD",            "611980de0230c2f6b9dfc2aa937a9cb3" },
    { "AOD.WAD",            "eadb7a5dd09d08f791e56b4ad44c986a" },
    { "AOLGIRLS.WAD",       "8bd3e170be461260d7b165beb8d535da" },
    { "AOTW.WAD",           "085963d1bcd51270d5be8bf1e47a209e" },
    { "AP.WAD",             "667e539396cbf4ac0c2abb22932afbd2" },
    { "APARTMEN.WAD",       "0093a2a4f2772b41665f9d0a4a3aa3e0" },
    { "APES.WAD",           "21b14b7a8767caa82054a403af6bb296" },
    { "APOCALYPSE.WAD",     "3496c4ae085c004ce73fdda4a70cde93" },
    { "APOCLPS2.WAD",       "e280c4a94d6fc73381239c3bd85d2332" },
    { "APOLLYON.WAD",       "7e39abb8a680dfdc2154d9359b1116e1" },
    { "APPARITN.WAD",       "da3b2bb1d5a380afeab85d01a97c87c8" },
    { "APPLE27.WAD",        "fd405f16fb7364c54168842a7a705dd0" },
    { "APT.WAD",            "b9bbc7d7b554ad42f09a3c0b0738f1d5" },
    { "AQUEOUS.WAD",        "ec970425f68c6581ae606667ac30a894" },
    { "ARACHNA2.WAD",       "60de84b645a8b59ccee3878f68b189af" },
    { "ARBOR2.WAD",         "0d0f2995240192e3003595501fce55da" },
    { "ARCADE.WAD",         "30d3f56412d9f6166842e1fef9ee667d" },
    { "ARCAIC.WAD",         "f24e0e7cb67aee336349a87ae2dc68af" },
    { "ARCARENA.WAD",       "eaf788830cebf0870ad5801bb789b6fe" },
    { "ARCH.WAD",           "a107658d6bb66eb12598d475c3a74220" },
    { "ARCH10.WAD",         "2da85ccc5f9c469d7922fd8f154ffb75" },
    { "ARCH3.WAD",          "a6a731483ca1f6cc9277fb4ed8c40cdc" },
    { "ARCHDLUX.WAD",       "d948febfac04b5d2072f9510a0123351" },
    { "ARCHIE.WAD",         "87677099be906b774826c33d38ea318f" },
    { "ARCHPIT9.WAD",       "559e87334120fc07c41cada28e64157f" },
    { "ARCHPITM.WAD",       "925f8f951637db7ab7a752618672c007" },
    { "ARCHVILE.WAD",       "eeee1e21a5759c94f249af14de45ccc3" },
    { "AREA49.WAD",         "6172a4002cbfcf638f432bbac01f19e0" },
    { "AREA51.WAD",         "0153b950f92a36ed2c69bcf04eb6af1e" },
    { "ARENA-II.WAD",       "4f48e8c5388679707ee127c2b3979cb4" },
    { "ARENA-X.WAD",        "4e1f30332388bb8047fda336f1ea2d76" },
    { "ARENA.WAD",          "6fe6f033d6c4663aa10bcc404e497cc5" },
    { "ARENA.WAD",          "9192aaa91e02eead9570741fdf17d492" },
    { "ARENA123.WAD",       "88af9cc12ca4d8d972ca9a5452d2fa9b" },
    { "ARENA51.WAD",        "fbcd7ad3569a3d07f3e0bd7806e85bc5" },
    { "ARENA666.WAD",       "d4f1ec6465b62c6a284e0ee93fa22a23" },
    { "ARENA99.WAD",        "6c9d34cf44e830677680582a18e9facb" },
    { "ARENABAL.WAD",       "d5921d76d79760198a046ace7b408507" },
    { "ARENALX.WAD",        "4ce15f44160ff54698ee0e7a2e852680" },
    { "ARENAS.WAD",         "057d9eb09fdc34a9a6ed39679be6e663" },
    { "ARENA_01.WAD",       "9052cd7ef4da2551775a32eb7d1d709a" },
    { "ARENA_D1.WAD",       "0dffca2382d615719d3504525e33c423" },
    { "ARENA_D2.WAD",       "ee6b6b0f65f372bd1d9b795225874550" },
    { "ARENHELL.WAD",       "72f840ebc73cffe99a96e38e9a027892" },
    { "ARES1.WAD",          "a761554e1de758776f3783b06ef9ef5e" },
    { "ARES2.WAD",          "b2c9da7fdc1dd35c37ccc8772168439f" },
    { "ARES3.WAD",          "8a00bfa4e49ce3a5439935b6898d0340" },
    { "ARES4.WAD",          "d46ada2e53274bec3a85ef200da9904c" },
    { "ARES5.WAD",          "42737f0114311c4553cbf4a13750eb8d" },
    { "ARES6.WAD",          "345b25c9a094b06c861bd1d1d066bb71" },
    { "ARES7.WAD",          "7e507aec3d75803e7a928f625061ad7b" },
    { "ARES8.WAD",          "23f660d550d6c768329cf9f24b0b5962" },
    { "ARESF.WAD",          "2939eeb616b854aa5e37706e182c456a" },
    { "ARGUS.WAD",          "7f276197caf8ac3414e2813cee2e4ec4" },
    { "ARMADILL.WAD",       "f0dfa43f845fbb362849bfb9511df23d" },
    { "ARMAGED.WAD",        "65b6fbd441ab719dda55c1440d67150a" },
    { "ARMAGEDN.WAD",       "e71b4ad7b59497ea3adaf1fb7ec90c48" },
    { "ARMHAUS1.WAD",       "1e2a3c8e7a28ea33ae09adb742062e3a" },
    { "ARMORYDM.WAD",       "b00e2c77e75a010207cca74d676cfb87" },
    { "ARMUS.WAD",          "44cc988bc27d53747ce7a254bbeb7609" },
    { "AROUND.WAD",         "5a4dd9f79e649c78b3e49a0c25e2eda7" },
    { "ARROHEAD.WAD",       "c1ff04a890ab4318bbf3babcba76ccff" },
    { "ARSENAL.WAD",        "caa49e58c7a8ae9cf37a0242c259052e" },
    { "ARSENAL2.WAD",       "533f2b80117278a4097a2a0285a499a9" },
    { "ART.WAD",            "390108e210c3cfe1a5f2d8e3045c2893" },
    { "ARTURO.WAD",         "4063333859cffaef91da30adb22b3aa1" },
    { "AR_DE2L.WAD",        "91fb1231ae36be17c8bbff6f6c8c154e" },
    { "AR_DEST.WAD",        "b6bcf101ac65bca9c8f4e87ba513a443" },
    { "AR_DEST2.WAD",       "2f03082a8bcefce63f868cec551df856" },
    { "AR_DEST3.WAD",       "163645fbe5efe20b06042486723927dd" },
    { "AS7.WAD",            "905af7e7bd9c1560e3cebeda0c14490a" },
    { "ASD2.WAD",           "24cd01595447261095c301b475bbb7b0" },
    { "ASEWER2.WAD",        "c140088c1fc69ff8fdc2f24c8610ef1c" },
    { "ASHBURY.WAD",        "42aed69aeb29730bec765ebed6fe0826" },
    { "ASIMPLE2.WAD",       "f38d6095ada293adba508b634193e4f1" },
    { "ASNEW8.WAD",         "32a73c23222a61271c25d7edc946ad3f" },
    { "ASPRITES.WAD",       "a00caeeb861a4984acbfc5c6fae70d19" },
    { "ASSAULT3.WAD",       "375e5d9a72ea7a0b60f7fd387a7f05b0" },
    { "ASSAULT4.WAD",       "662e9301a4d027587a92ba5811ddcbc8" },
    { "ASSLT13.WAD",        "75898d3dfe7a18e75b70f6c3cc4fc476" },
    { "ASTRO.WAD",          "5355e494194222fc68b0a22786d88de7" },
    { "ASYLUM.WAD",         "294d751367f1cc315eb9b7c5edd86992" },
    { "ASYLUM.WAD",         "8f3188e9af3bba93d4df3b97eff15e44" },
    { "ASYOULIK.WAD",       "ae4de329e4b258511232d9bec890544a" },
    { "ATARI.WAD",          "a3325401732870ce7b4b5d63dcfb2f96" },
    { "ATB.WAD",            "6ec75af42db232d330349d21d0121d94" },
    { "ATHEIST2.WAD",       "7790b8ec5438ecc93f9ac8464c302d32" },
    { "ATLANTIS.WAD",       "ec5524c053476ac6537d9e7e3a8bf286" },
    { "ATTACK.WAD",         "5ee3be4595af65e008e1a657c4a15847" },
    { "ATTACK57.WAD",       "d434d8aa760a9e0996191eab5be815e8" },
    { "ATTACKED.WAD",       "b8ddad380e7fd9f28d51c9c2ecc5b26f" },
    { "ATTIC.WAD",          "155e4788c08a64753b559f1c50706320" },
    { "AUGUST.WAD",         "680e3283289ab827ffbc0c63e7032caa" },
    { "AUGUST02.WAD",       "c6fa0da17978f2c7c25a9b8c0d3a3405" },
    { "AUGUST03.WAD",       "b0c5aeb73cc1d782a92288a4657c64ad" },
    { "AUGUST04.WAD",       "66965c7a90308500fc4c676acba9927a" },
    { "AUGUST05.WAD",       "35eba5b8b62a26a2cb847fb89d0574e1" },
    { "AUGUST06.WAD",       "20008d92f8fd338daa0344f10a4b88e9" },
    { "AUGUST07.WAD",       "35be54321b404a6015d55320eae7b3f2" },
    { "AUGUST08.WAD",       "fb6035e2f6264e8a18aa5b10e68635c9" },
    { "AUGUST09.WAD",       "dec743e2f6a994d9011231cd70e2d0f8" },
    { "AUGUST10.WAD",       "b4dfe40d0c0a17fcd26312c61a4b81ee" },
    { "AUGUST11.WAD",       "b7b344c9e4d0c08243b61cc3f80f9f13" },
    { "AV2FLAT.WAD",        "fe5f9e81803fee0df2a5fa6b13dc987d" },
    { "AV46SP01.WAD",       "497c227c6f6382e57dd151483efb006c" },
    { "AVALANCH.WAD",       "bda06d428a13e9ac5abb5abf9fc71fc7" },
    { "AVANTGAR.WAD",       "2854737a5bd49bab0382b2d534986f3d" },
    { "AVATAR1.WAD",        "ae603aed48c1a2fbc08d303e02ef9491" },
    { "AVATAR2.WAD",        "7d4b18e256f57f508bea0adf25c89c4d" },
    { "AVIND.WAD",          "ba1a74ad6e16d416e2048b4e105077a9" },
    { "AWAD.WAD",           "d0c1cdd05084a2f90bf904751dcb1ec1" },
    { "AWESMDTH.WAD",       "59c6e20a856c06b786eb1cf6badd02d2" },
    { "AXE1.WAD",           "1ee0184bb310678db44d185a21ecc2bf" },
    { "AXE2.WAD",           "1c51ea48445aa1940e8dd0368f3b1b30" },
    { "AXE3.WAD",           "cabdab4bb0dcb672bb78259bb104ed2e" },
    { "AXE4.WAD",           "83e90275bfa4cee9f0596eb537519681" },
    { "AXE5.WAD",           "fa90a5aabb6ffe7ce3cf9aa303460091" },
    { "AXE6.WAD",           "4ff1e1dd1136ca193b7b020f02d84669" },
    { "AXE7.WAD",           "5550a0e71bbfb27a7f7e977fd7fca6a2" },
    { "AXE8.WAD",           "417a20b417581e26486fa6e13db6de70" },
    { "AZTEC01.WAD",        "eb603ad08ffd10c75661cbee341abb19" },
    { "A_TASTE.WAD",        "a312f16f0a77f25fb8d7a6d6601ab6f4" },
    { "B-SWIRL.WAD",        "b38a0a7d2e5ed4cba0cd94f7af6087d5" },
    { "B19ARENA.WAD",       "24806871064c6ef434bdc858fae63f18" },
    { "B19_1B.WAD",         "bdca7f22a435abe71cc5f3cab184ea39" },
    { "B3.WAD",             "a89fb170ee45d8121eb7273fceaddb63" },
    { "BAAL4.WAD",          "4eeda2f98c279a93845c896097e05594" },
    { "BABDM.WAD",          "f6ba174ce24e0ae7f9c816050a42dab5" },
    { "BABDM2.WAD",         "917a67813ef2ec6ad126bce723a1c33a" },
    { "BABY-1.WAD",         "d76f51c65d961b0bf8259acc6f84f250" },
    { "BAC01.WAD",          "7966b43ee83f8cee7fb4dd64bab61ef6" },
    { "BACARDI1.WAD",       "180f911319eada333c5ab67163c47d7e" },
    { "BACKHOME.WAD",       "b3589b19502e358f0f1b3a877419d185" },
    { "BACKN4TH.WAD",       "043180aa398d56f757c671ed09a77624" },
    { "BACKYARD.WAD",       "6995052a2a2a8632a53a8cd8fa92b09a" },
    { "BAD3.WAD",           "d50d1b9bed73be42c035dee748534fda" },
    { "BADARENA.WAD",       "afab3d2fbacfdac0f76f350082942202" },
    { "BADBOYS.WAD",        "8ce3d1180085bf8812e7e2c6be985d9f" },
    { "BADDREAM.WAD",       "deac9076581de0e039a7230b55c6116d" },
    { "BADFSH15.WAD",       "708a5ff4c0299223368b422ed0094280" },
    { "BADLANDS.WAD",       "b43dd1c3d2792c6d2bc9b9e530ec4618" },
    { "BADMANS.WAD",        "85507d6a6e12c54ca19e6f04fee74952" },
    { "BADTOOTH.WAD",       "8bedf46a632e105acd029eda2da07813" },
    { "BAD_ART.WAD",        "8a6f528393a1182b54bc5d16909620ee" },
    { "BAHDKO1.WAD",        "89f5c2dfb1bcf0d36ef03dc205a4695f" },
    { "BAKPK21B.WAD",       "b39b8f8b5e4b0a7f7627f1cad5670710" },
    { "BALANCE.WAD",        "f8b49b6568c3c9838d1b828d6c847f22" },
    { "BALCONY2.WAD",       "0bae1f8ed7c584b394eb6cfda8624b43" },
    { "BALEZE2.WAD",        "7df4ac5438211c34510cf52b57287cea" },
    { "BALLBUST.WAD",       "661214ccef3b8b52e8e32fc9c0fc220a" },
    { "BANACH_1.WAD",       "a907d435016cbe4404c5ef7c93a4da10" },
    { "BAPHOMET.WAD",       "72e7be3b02454a140d03cb1767e8bf9d" },
    { "BARBELL.WAD",        "abace095c7395076e52376d241cc39e3" },
    { "BARBELL2.WAD",       "6a01d46edd43a107431e8243e8aa42d9" },
    { "BARFIGHT.WAD",       "b4bfbdaca3ab6ab81c57a8c5df88ed60" },
    { "BARO3.WAD",          "119cef0a7291920aa573a784d533ffa1" },
    { "BARO5.WAD",          "221a4469f2b00857762cca946156f507" },
    { "BARON.WAD",          "e78d44bffe42480aa7e6d05e4da550c4" },
    { "BARONGAT.WAD",       "2565d7b3c0323ad1539dd00fc105ae3c" },
    { "BAROPAK.WAD",        "9393af2a14402d5e4f03469a77a78d98" },
    { "BARRACKS.WAD",       "6573ad492aedf968d67674ef218e009f" },
    { "BARS.WAD",           "ee428e6fa3fe2ec196ccdbd4762a9102" },
    { "BARTDKE.WAD",        "cf2d79c78642ee27d7941719abc425c4" },
    { "BARTDM2.WAD",        "341e9992db7f5e0893f7908a49ca2d1f" },
    { "BARTDM3.WAD",        "286fc0b0d1b9189f17c5fc92423e37f9" },
    { "BARTDM4.WAD",        "edf0be6103929200f5536b24492bf41d" },
    { "BARTDM5.WAD",        "70b537f3fff054bde91aa4847b699e11" },
    { "BARTFX.WAD",         "1dda4d2f00479a0012204c47fd2fa70a" },
    { "BARTFX3.WAD",        "2aba64dc06eb2a6edc6017532688e018" },
    { "BASE.WAD",           "73ca723b57bcf1e09f7da0b9a1ce6e61" },
    { "BASE01.WAD",         "0434302ecfeb38a19df10a2cbdacf065" },
    { "BASE02.WAD",         "444816d01b4e7c45fef264aae18eb6ea" },
    { "BASE03.WAD",         "f8643ef83e9fd3fe1df8f73c8abba425" },
    { "BASE04.WAD",         "0ad26aae0b99daead15b1697bc0880aa" },
    { "BASE1.WAD",          "223774913517ec50e4b514ad77c03326" },
    { "BASE3V2.WAD",        "e7654fe8a116332b2c4d11d67f9544b8" },
    { "BASE666.WAD",        "3deb0c6414aff0c5bedd3ca0debda1b9" },
    { "BASEDM1.WAD",        "5e14adaf12c22a6adaca95aba7d7beee" },
    { "BASEDM2.WAD",        "01faadcb40ca12f696a0f58683658424" },
    { "BASEDM3.WAD",        "7d77c8381a34c3aa89c629887a7ebb56" },
    { "BASEDM4.WAD",        "ac251ca5978999a993f3cac024ed62f9" },
    { "BASEDM5.WAD",        "a2f192961d9ea5cfbd5057ed78d02973" },
    { "BASEDM6.WAD",        "b96a8fd17d6e60e520be0f7e1c79ea6e" },
    { "BASEDM7.WAD",        "4545a0b3a0afeba56374d8f648fd26bb" },
    { "BASEOFDM.WAD",       "db8c84b0f73cf6b6b5f3a647e9def2b4" },
    { "BASH1.WAD",          "d0e978787b7ce88524d55b99ee4856c4" },
    { "BASTARD.WAD",        "11a30ab27dc90cfd12930c8a0f6bd8b1" },
    { "BASTETDM.WAD",       "b0430d9798070221f411c1f93c6ffbd0" },
    { "BASTILLE.WAD",       "07ed7322e603130443aea6870bedd72c" },
    { "BATMA.WAD",          "d1b489b3bd40ebffcc843639b5198b81" },
    { "BATTLE.WAD",         "9b5358da994cabdf77a22de3583d66ea" },
    { "BAZIL.WAD",          "aa9d6f32b2dc9e671aba743040500676" },
    { "BB.WAD",             "5c686d2e67947c42c555e15878e3e353" },
    { "BBCASL20.WAD",       "53c1ce785d6150e035db728470dd3280" },
    { "BBETWEEN.WAD",       "58e9ca0d3bb976add5e4a3938e4e77b5" },
    { "BBLAST01.WAD",       "0359d4904be683e1f0f418dae88e1d3a" },
    { "BBNZPAK1.WAD",       "8d00a739c3927fd8d0b0e7caff094428" },
    { "BBNZPLZ5.WAD",       "f3434a803d751f448f6e5d583165b4a0" },
    { "BCKTRCK.WAD",        "a903b96b2d230487091ac7a266ba960e" },
    { "BCS01.WAD",          "7a6b62ee6c0b9d08d0c0192435fef876" },
    { "BCS02.WAD",          "7516c29da0941397a914624a385e5d11" },
    { "BCS04.WAD",          "cb73393d7cc4bdb8545ff80a1acb8322" },
    { "BCS05.WAD",          "bd3ac45d644fcee86fb9816b2d5ae3fb" },
    { "BCSMW.WAD",          "472a350363bdef36164e14e8da68265b" },
    { "BC_GUTS.WAD",        "1fc99c168c0fd51572961d62ffa76ce3" },
    { "BC_SP_01.WAD",       "345930476c7a2278042cd6d1903a620b" },
    { "BDEMOS.WAD",         "df849c7391fbce27330cc4516674cb40" },
    { "BDL.WAD",            "7cd1d162fa80e4eb88658bdfb4c3edd1" },
    { "BDM2_F.WAD",         "0a95b0be0ed50109f7691f3ab1216549" },
    { "BDS3.WAD",           "0397bb91fa813fb231c58d10c1dd05cf" },
    { "BDSDOOM2.WAD",       "bef25c34214ad1b9db0d863a5943d2a3" },
    { "BDWHELL.WAD",        "bbe603ae04fd5f8c62d6e2c39b49a31d" },
    { "BEASTMKR.WAD",       "028399429ca01a28e6460e91e89e5661" },
    { "BEATDIS.WAD",        "e892abba050484ff228eaee60a9519b4" },
    { "BEATLE.WAD",         "74f9f81a1f2a073f4b3756f048355b14" },
    { "BEGUILED.WAD",       "a96bac69083868fdf0f5f6ebd7547ec4" },
    { "BEHINDU.WAD",        "185c5e3dde320f8d237d5136b91fddf0" },
    { "BELCH01A.WAD",       "59e8ab988e46328bde9cbf69b80896ca" },
    { "BELCH02A.WAD",       "dead197cb362c196c06904da006047ce" },
    { "BELCH03.WAD",        "dc98b163365d4363cffba4d0230de129" },
    { "BELCH04.WAD",        "3e4c6699ff9bd4a7634c21fcb7e9fe71" },
    { "BELLAETARMA.WAD",    "c8d57f7a26bbd75dc5622796321cb89d" },
    { "BELOW.WAD",          "449e412a2db30c99fad605d3bbff5fe3" },
    { "BERESITH.WAD",       "df354e1cdf40cb843e750442cab06521" },
    { "BERSERK.WAD",        "a51e140b2c44db5d10e352536542240d" },
    { "BERWYN.WAD",         "5901d854eacc5360cc5b1c30afe601b8" },
    { "BERZERK.WAD",        "9f01fe24d678f8abe081a8567476d257" },
    { "BES1.WAD",           "24486764aba7da490295586ad87b7588" },
    { "BES2.WAD",           "5305f3da336051131fb6da0b645465d1" },
    { "BESPIN.WAD",         "935fdb93a7275ca5e14fee2e395fb530" },
    { "BEST.WAD",           "8dcd4bca4ac2d0a6916e789026a026c9" },
    { "BESTBEST.WAD",       "c4b2b134e81c7e057d6892d5c42b8ded" },
    { "BESTDML1.WAD",       "671d04dd006216b561b3c3fcf2367c36" },
    { "BEYOND-1.WAD",       "9fb19124d31a131741d955f75fbf5665" },
    { "BEYOND.WAD",         "bc6eea2981ab8dacc79774d818de8842" },
    { "BEYONDIT.WAD",       "10a79d40d830f394d414efc25ca6b39c" },
    { "BFALLS.WAD",         "7c22364352696988893699b906ec9e4d" },
    { "BFGARENA.WAD",       "f77d4033ec9a223f3191cc254287de97" },
    { "BFGDEMO.WAD",        "eac78be53209e94e77accbd87ba7d256" },
    { "BFGFUN.WAD",         "1dbe2f3752b5d2c0818ab436c03eeb2b" },
    { "BFGHELL2.WAD",       "4b5f28138e7b8ca4ae499f3e4e9ee483" },
    { "BFGHUNT.WAD",        "c287fecde48716aed638dab8e14a6b14" },
    { "BFGSPAZ.WAD",        "66d310f6f32efec84e51a9eced5a9626" },
    { "BFGTRAP.WAD",        "d3170b5b0517e944a5ed4113490ec01a" },
    { "BFGVAULT.WAD",       "79795e6924a7c5962ae20cf26c77f4c1" },
    { "BFIELD.WAD",         "440fa7c3becacc61f13668d833aafd36" },
    { "BF_THUD!.WAD",       "66f9508bf2141fb32b844520c3cf7289" },
    { "BGARENA.WAD",        "5f23e1f90b4650dbc118029fcf542f98" },
    { "BGCASTLE.WAD",       "8fc920a372f15a2c9bfbf51a6c01ee59" },
    { "BH.WAD",             "77cae0e72a2fc2933e19bc15e9bd58b2" },
    { "BHEAD01.WAD",        "37a0dfca66000a80b8b664be20adb4ab" },
    { "BHSP.WAD",           "85d644201d773017416937e0cd0cfdef" },
    { "BIBLIO1.WAD",        "76f41ebe6bd9c8550e067da882eb2253" },
    { "BICTOAN.WAD",        "76391c3afe3204be0d0ca9dfb3b21ea8" },
    { "BIG&DUMB.WAD",       "de6e791f3113ee535006769dfea38abb" },
    { "BIG-EASY.WAD",       "c78ff5ecf9b4f1c45fe01b3d9f1d5569" },
    { "BIGBAD1.WAD",        "1d4f27e0c6bfab13913e4b0f2de6d868" },
    { "BIGBASE.WAD",        "97c9a2e7d04d10d4b46f47d7603a9c9c" },
    { "BIGBNU.WAD",         "31d75e6f5a2d524c67b8840b45a8b668" },
    { "BIGBOMB.WAD",        "3fa3cea94d09317da62021223452d0eb" },
    { "BIGBOMB2.WAD",       "3e34073e6172cee60b26f555bf207acc" },
    { "BIGBOMB3.WAD",       "549b38c1abf038e07cd7ac5ea82fcb94" },
    { "BIGCITY.WAD",        "83c3ccdd9696c4b5b264fea7938f1f86" },
    { "BIGDARK.WAD",        "04da90384b8cd1f47419f1f516ee563d" },
    { "BIGDEAL.WAD",        "612f9bc1d078ad5ee4bed02ad224387f" },
    { "BIGEARLS.WAD",       "cf670505781fa7c9079870569f363d05" },
    { "BIGFIGHT.WAD",       "c28a6135dcc3fa9687d8d4c66f80ead6" },
    { "BIGGCITY.WAD",       "a48195633e9b41d9e4d6f3a607ed2807" },
    { "BIGGER32.WAD",       "405718333302a63e62d6a40118fa95d0" },
    { "BIGMAP.WAD",         "d63020b5d4526b30d1e5488a077bb4a4" },
    { "BIGMAPS.WAD",        "2b2cccf72c58fd137d8c2b924d1945a7" },
    { "BIGOPEN.WAD",        "ac7173419923e6e8c9318ac79fe0dd5f" },
    { "BIGROOM2.WAD",       "4b76386a9db28b1a0732624b00c774bd" },
    { "BIGSKY.WAD",         "85d9e6ab096e3c89c0cffc536ced71aa" },
    { "BIGSTAIR.WAD",       "97db81abc9016a7677679cf6de9b1bd7" },
    { "BIGVAL2.WAD",        "a76a79bcaecaec709f61b3eefbb45c84" },
    { "BIG_D.WAD",          "1e3d01ab05970b2e204cf7f37c4c75d9" },
    { "BIG_GUN.WAD",        "614342200dc90af99c5f56e3f046a1dc" },
    { "BIH.WAD",            "39c4c8948e2ba0467a200ee9345cdab5" },
    { "BILL2.WAD",          "6f9fd48962eae9520f7199fca1dd0e00" },
    { "BIODEATH.WAD",       "9a2e7451b10aa829a05f51e0511ac1a6" },
    { "BIOHAZRD.WAD",       "7f7baa76c17ff830df63f147e5d1fa95" },
    { "BIOLAGE.WAD",        "79af23e19aa4ad20e7a26973e88f8c02" },
    { "BIOTECH2.WAD",       "6dd9e5307df7f404ee6a79ad901a618a" },
    { "BISHOP.WAD",         "1e221c98dd9aea999bfc29542e936504" },
    { "BITEDUS2.WAD",       "7d197c8e02f7865a42e232bd151aa4cd" },
    { "BITE_ME.WAD",        "52e8d731fefb405d3b9765878c245ec4" },
    { "BJAY_F3.WAD",        "50bba935682b56eb2007137ce67f17b6" },
    { "BK.WAD",             "38a5335f6997eadbade7c308ec8ec028" },
    { "BKW3.WAD",           "f99f72623af3974b9c1bed4d6e3a05d0" },
    { "BLACK.WAD",          "c886c8ffb7944829cec560e3ee0232c1" },
    { "BLACKMOD.WAD",       "4a602e6ba4c43b4396bcda1722dbce14" },
    { "BLACKOUT.WAD",       "edf4eb9314974fa9e9d8668091fd4ec8" },
    { "BLACK_DM.WAD",       "dc629bf0eab190e9a9a389e25547a388" },
    { "BLAKE.WAD",          "21a9a79b67adf8a485f4a063651de17f" },
    { "BLAKGATE.WAD",       "7d809e166b616d529896e8a73d47fd56" },
    { "BLAK_GFX.WAD",       "fd755a81997f3c324d782b8678c91511" },
    { "BLAK_SND.WAD",       "df87078363a1d64428946d0a36d34654" },
    { "BLANK.WAD",          "de9134a441eea06915d8378b33a2313e" },
    { "BLASTEM.WAD",        "8cab8a9e8b5951b70abb3b0e0892de27" },
    { "BLASTEM2.WAD",       "5ada7cec00286eae568ec80259b0c8e3" },
    { "BLAZIN2.WAD",        "6643e8d8343de7bdb1400695eaff32ae" },
    { "BLAZING.WAD",        "e21460836fb8e193a291776fdfd66bcf" },
    { "BLDGUTS1.WAD",       "a73efb7b338e63a69a062569e8791077" },
    { "BLDGUTS2.WAD",       "2eb623f1f476e8ed6f0b66f843c149bd" },
    { "BLDLANDS.WAD",       "5ed50e9eee2279fe5b9c9f2e80b37df3" },
    { "BLDLETNG.WAD",       "5c73c3fbf812efe54a4364bb93f54b6c" },
    { "BLDMTN1.WAD",        "6929a79b6a539eca3f0cf1a5179316b5" },
    { "BLDNIGHT.WAD",       "52a9624e38917849ef8942a68ae7a3e6" },
    { "BLESSED.WAD",        "437cf3c3f61d13667183bb69b069a100" },
    { "BLIMMO4.WAD",        "bc5131f3ea9c81e65844839d701976ec" },
    { "BLINDED.WAD",        "f0e3bc196d526fe6d8f399ee00561c9b" },
    { "BLINDSDE.WAD",       "6f5a10a99d89b72d1973e15d84ba69ca" },
    { "BLISS.WAD",          "23f56402f796f61a72abd3bc04841f6f" },
    { "BLISTER.WAD",        "3612016ef0a809abc7a20287d6878cc5" },
    { "BLISTR21.WAD",       "54e75021bceef8d071ac76f54de8e01c" },
    { "BLITZ.WAD",          "abe65da1abcaff5955e1d6d023315f13" },
    { "BLITZ2.WAD",         "22cad681b7fe8ecd21b97d8b5b2fc78b" },
    { "BLITZKRG.WAD",       "905f8fd83424e157efeafa23f9e33033" },
    { "BLOCK.WAD",          "82304e5837bb00280fbfbd6203126836" },
    { "BLODLUST.WAD",       "683f2429ac967cabca1ac4ff70ed680c" },
    { "BLOFELDX.WAD",       "026c8667411b2b1760b77e40915c10e5" },
    { "BLOFIELD.WAD",       "5a30a2d6d950fb96dc0c669176845a52" },
    { "BLOOD.WAD",          "872c8065dc1df6754f27f2f8d393cfdb" },
    { "BLOOD.WAD",          "fa1968303e5947c01f052bcea5301563" },
    { "BLOOD4.WAD",         "fb025fce5aedb443ecb67d6fb02edd02" },
    { "BLOODCOR.WAD",       "21454c4111ce14a93020e2804e97cb9a" },
    { "BLOODY.WAD",         "c5bac4671d8abcf999f4d7f100093bcc" },
    { "BLOOM.WAD",          "eea1996f741bbc332eb5e3bcfa3c318b" },
    { "BLOWAWAY.WAD",       "9b196771292e6ed036a8c9fdd130627c" },
    { "BLOW_A.WAD",         "413e167c8d0e3efca149a4a9976ef7ea" },
    { "BLSIDE2.WAD",        "de0c13382e92e2c13a340995b30c0005" },
    { "BLUDBARF.WAD",       "4a67ecd8a953290ccba442e714f9ae1a" },
    { "BLUDBATH.WAD",       "085c2543c21d6818f1f0894292f310f7" },
    { "BLUDBATH.WAD",       "5f690daea84e0a7b49e7eb9cdc8a8324" },
    { "BLUDBRF2.WAD",       "0dc350bdfa9a844d740520e3705e35b3" },
    { "BLUDBTH3.WAD",       "4c486e927452556ebb54d272cb5c0b29" },
    { "BLUDLUST.WAD",       "e327aaae86ca0f85b8248955095399d1" },
    { "BLUDSPRT.WAD",       "6967d028270a9b99deee8ff67e9676e0" },
    { "BLUE-UP.WAD",        "90caa3c80cc710efecd23d28acba881d" },
    { "BLUE.WAD",           "95e5062915677e45f401eccf6566b8ad" },
    { "BLUE01.WAD",         "de0e004503f545d4c355aa1774fcac8b" },
    { "BLUE02.WAD",         "d4f0d0bb4edf3a80a5ca6a1b7ae02f2f" },
    { "BLUECHIP.WAD",       "e25e0ea54a87097bde8e855350fd99c7" },
    { "BLUEDETH.WAD",       "f17f5e90ed4bcbd35a8b0105d93b147a" },
    { "BLUEGFX.WAD",        "c98a31506905ae181fdc69f1d3d9418f" },
    { "BLUESND.WAD",        "56a6e30f72c3d67a332e700de046e37c" },
    { "BLUESTR.WAD",        "0bdbad733a22d0c36131cde981bcf755" },
    { "BLUMON.WAD",         "ad587ef07f094af64cb228cef2250576" },
    { "BMCRAM.WAD",         "b36a5c08d7b342de1ee28d1a2987276b" },
    { "BMDEATHM.WAD",       "e6d70216de5817d874af0c16902cbd60" },
    { "BMGARDEN.WAD",       "9f6fc4f5cb8efc7c8e1c94dfbc634a50" },
    { "BMOTHIC3.WAD",       "9775a484f71c63f2ed748b7f5886e68c" },
    { "BNDALY8.WAD",        "f4cd7d4f66f30296cc9637dfbc58b3d1" },
    { "BNDALYB.WAD",        "851c17f8c230b60eeb5e4f9600ceca97" },
    { "BNDALYE.WAD",        "69a1e851f9b9c98e74c2508383702faa" },
    { "BNDALYM.WAD",        "a79094e6c61740f40eaca871deca14ad" },
    { "BNDALYO.WAD",        "0465b1fe40c2500d04cd2541768030b1" },
    { "BNDALYP.WAD",        "d10774641257cfdaf8faa493ddc2fc95" },
    { "BNDALYQ.WAD",        "735a4be97a27690f5ffcf2879a24cfc4" },
    { "BNDALYR.WAD",        "1c6a0b59cd7a17874f3936aebac5fc7e" },
    { "BNDALYS.WAD",        "ae449b021720942b81c9f216eccbcd14" },
    { "BNDALYT.WAD",        "84de6e96e341a357f2fbe6c32e64ba69" },
    { "BNDALYU.WAD",        "b3cc5743bda4f18396ae858ad8b61c7f" },
    { "BNDALYV.WAD",        "56f34897284dcc3d2b0157da69422172" },
    { "BNDALYW.WAD",        "9a8fd80222f171872b6d7c99df9bb27d" },
    { "BNDALYX.WAD",        "bc505444d1f3cf8a5c25d48d377206bf" },
    { "BNDALYY.WAD",        "01f2df2a0e15b10b34b63d333451e30c" },
    { "BNESOUP.WAD",        "7628e834e5b20f43509e52b26c044276" },
    { "BOB1.WAD",           "fe815a75ec2dab4960de6dbfc06e0f8f" },
    { "BOB2.WAD",           "ff33fd5ae512ca35963eeb52ac5fd33d" },
    { "BOBCATD2.WAD",       "fd26bb5b34d889c0a3bd813ce169577b" },
    { "BOH.WAD",            "cec8afa2f91a9869db7a6c5ae9048892" },
    { "BOHBORG1.WAD",       "b740f17952eb0eab3c43d51dfeea1264" },
    { "BOLEX.WAD",          "f40782b1db06a027448dbb88e1f45b48" },
    { "BONAR5.WAD",         "beab0375128c511a76f8ab0d63654293" },
    { "BONAR6.WAD",         "b6b9fdc4fd7690e644b44b9be32d6729" },
    { "BOO.WAD",            "ba22090279c079827225d26c623f569b" },
    { "BOOK.WAD",           "a425677ea075b7f29cef615ef79301d5" },
    { "BOOKS.WAD",          "cf54f029f522fefbd466a4586ff193d6" },
    { "BOOM.WAD",           "8ca2b7dc3286c6fadc3889cb84c2ecc5" },
    { "BORDOOM.WAD",        "02204b552c02e3ed0bbca79d43a01450" },
    { "BORIS.WAD",          "959f12a0ef5b20e2ef708bab1f077cc2" },
    { "BOSS1999.WAD",       "7dc2ca764569326661cb37935c08a01b" },
    { "BOTHERED.WAD",       "22ce585b5585a0ab0352a72e58e7c35a" },
    { "BOXES.WAD",          "e7ed298dc7115517e01e847bc1a21daa" },
    { "BOXING.WAD",         "ee82308f593bd42dbfe55c51609e6fd3" },
    { "BOXINGC.WAD",        "ee9d07241362186ef54d4cedc9dd8283" },
    { "BP10.WAD",           "2d3d01132a9e61a33f33cd05244248df" },
    { "BP10D.WAD",          "ce16ef2ba6c11bdfe7dabd3cdcb78959" },
    { "BPC.WAD",            "3937b4d7d4d72961681b00676d6e2940" },
    { "BPODM001.WAD",       "068158776c3fdeaa5504b7b5ff7b7dec" },
    { "BPODM002.WAD",       "5e3dd8c90195c5647cbb16cdee43f4df" },
    { "BPODM003.WAD",       "924b6263070e026791dd61c9136c1e21" },
    { "BPODM004.WAD",       "bf9345a34db8493b99ba2e5622c2524d" },
    { "BPODM005.WAD",       "b0697dd7b74f29fc2b5a175b725ecc6c" },
    { "BPODM006.WAD",       "c834cd1a01e177b04e6dc87ff9765825" },
    { "BPODM007.WAD",       "e74bcf375586c2c9f71e7fdc4a7b048b" },
    { "BPSND.WAD",          "cb227ce1b2c1f15bca176ab26a07831a" },
    { "BRAD&CO2.WAD",       "33201cb47d7ad38de8113e94ee61e28b" },
    { "BRADGRFX.WAD",       "baa5d1b8fcc09c60844356c947204641" },
    { "BRAIN2.WAD",         "378eb4159ac32f0ceeb3183e425d6acd" },
    { "BRAIN3.WAD",         "ff6df4cc3622d8ecd2dc6ac0bd68b5b2" },
    { "BRAINS.WAD",         "f1bfd505acd8e334fc05a25149f6c1e5" },
    { "BRBETA.WAD",         "4149d8c1af578e1f8ba9b2216da33c55" },
    { "BREACH.WAD",         "f66a0740c3f99f588232bc6cca7dd9ce" },
    { "BREAK.WAD",          "249f37d81c0c3de02c940e21c51bf981" },
    { "BREEDMAP.WAD",       "b331fa39ce103cf86388fd8b96729c1d" },
    { "BREEZE.WAD",         "d191a5d08fb92547d30c45649f318f2b" },
    { "BRIAN.WAD",          "4e08d1e702fc40793592c0b432c34a3c" },
    { "BRIANS.WAD",         "5fd4b78e98c91a12c04ec211e85937c9" },
    { "BRICHTON.WAD",       "b6c00d683fbc1f0c08c4818ddead03d6" },
    { "BRICKDM.WAD",        "64c27b0f9a9998b8a32a2844c5b245fa" },
    { "BRICKWAR.WAD",       "748928a7cbaaecb0343e41f5addab93c" },
    { "BRIDGE01.WAD",       "22c4b287f5ff5859e342e29f367a8b8c" },
    { "BRIDGE1.WAD",        "54d616ed633246f30ce9003f9da8443b" },
    { "BRIKBLAT.WAD",       "c2beb97efe6fc1067c0854b457c3ae98" },
    { "BRIKS_DM.WAD",       "d510b1a4eb6397f593e3c55541ec0bfd" },
    { "BRIKYARD.WAD",       "d26a88806d55e38fda82c22edfeeb525" },
    { "BRIT11.WAD",         "4657cd2c84b10dde3ff10ad1bd686224" },
    { "BRONZE.WAD",         "c83f1e04912a1c821a88f0cf776b280f" },
    { "BROWNIE.WAD",        "5c7d4718de80b9974676ed9a972282dd" },
    { "BRUISED.WAD",        "e8d29e12849771b350d80fe1be471787" },
    { "BRUJO.WAD",          "be7a28c741195c19122f4cfb6a6384f6" },
    { "BRUTALDM.WAD",       "59a3bc5d2470927bcd0be4d3cc0affc6" },
    { "BSERPENT.WAD",       "94b59974346df949cdb4d45f5b179d54" },
    { "BSTGRU17.WAD",       "9ea12a62c7d7c776edf895f8ded86d1a" },
    { "BSTRD11.WAD",        "aa340c277024c4121aa978835fbe6fda" },
    { "BTCHN97.WAD",        "6e5871f5bc0c1d36724c23781da5c193" },
    { "BTLROYAL.WAD",       "9147f2099f750ef1fdcda7dd8e0d2a1a" },
    { "BTRAIN.WAD",         "8971f41813fe633c582c146a67062515" },
    { "BUD1.WAD",           "41372984270dc7b70afd23bb186cda62" },
    { "BUHBUH18.WAD",       "663a62154a0637d289915f4c51d8277d" },
    { "BULL1.WAD",          "9ee814705c3b543cd0a6cabb8147cf90" },
    { "BULL2.WAD",          "00ddba980e6a91f38afefa35b5bae646" },
    { "BULL3.WAD",          "44a095d03923ba06fb39f90244dfd3a9" },
    { "BUM.WAD",            "d08cfbccfd68d74aa9c13753d14d188c" },
    { "BUMMER1.WAD",        "3322d8c2589552f82aaedead0190a5da" },
    { "BUNG.WAD",           "1438da683b7ef2e58f523d4ac05b0209" },
    { "BUNGALOW.WAD",       "469d23df2ef4962ce0b99d8044259fc7" },
    { "BUNKAD2.WAD",        "13320fb18af7d04ce951c2b4a4a8b63a" },
    { "BUNKER.WAD",         "8375f946d20b93cacfd25fa2dbdc7d97" },
    { "BUNKER.WAD",         "d0549f5e832a784705a5e3f79c82239f" },
    { "BUNKOFUN.WAD",       "a85f790c94cbd9f564ed3d26a98d7d2d" },
    { "BUNNYDM.WAD",        "f3ad2be672f250617886badebac66fca" },
    { "BURDETT1.WAD",       "8c67c762f997fb7c847220dd057a1ec9" },
    { "BURDETT2.WAD",       "c4c1b4163891776b44fcb639bcd17ff0" },
    { "BURDETT3.WAD",       "63adb008e0f703bf3b41a0de70d50f7e" },
    { "BURZUM1.WAD",        "154eb494e1e93dad9da0d3e6dfa3cb04" },
    { "BUTCHER.WAD",        "9df32c8a7776f80231af11fced274273" },
    { "BUZZ01.WAD",         "619ca72eb7609b7f3e8e5f9ca6145d23" },
    { "BUZZDM01.WAD",       "9ac0845b0c64bcc154c468e07f60716b" },
    { "BUZZY4.WAD",         "7a6ddf2a1f965fbff3f586552f5500f4" },
    { "BWORLDAV.WAD",       "ebdafe813ed2e490683c1b72e55391de" },
    { "BYAZAZEL.WAD",       "a5ea310e501599b1e0e8320136ca0b06" },
    { "BYGONE.WAD",         "7b6513d6207548d863039b69555fcf4f" },
    { "BYSTCAVE.WAD",       "56d33f883377497d70b3fbebbcf00d22" },
    { "BYSTCVE2.WAD",       "6d7f8bfa5fe3551449808e84f1f0783f" },
    { "C&CD.WAD",           "667e04366579d733e327b0b8c0008932" },
    { "C&M2B.WAD",          "d12d9bd2c77f8876fb27714324db6830" },
    { "C-KILL.WAD",         "95c9c11faadf3a5d106214c00a248e71" },
    { "C1V1.WAD",           "97c565f2d93558952c92de85a5bc30ab" },
    { "C4MAZE.WAD",         "aecac543fee14f7a1f14d187e470cd51" },
    { "C4SUBWAY.WAD",       "36f2d8b07d87620ff8fb47286c12db15" },
    { "C5GOLD.WAD",         "0f252215beded7f81b8fe8bb4d6fdab3" },
    { "CABALA.WAD",         "72567c463d39114f35da768df849f9d7" },
    { "CACHOWAD.WAD",       "8eed26cae8cefbe3fb0d1860f4fcfe77" },
    { "CADSDM.WAD",         "e02149185697a46ddb3ddee02ef9749b" },
    { "CAESAR.WAD",         "8bfb31effe448a0762a795aee243f9f0" },
    { "CAGE.WAD",           "7dccc7ea92e76308a494684787c74dd3" },
    { "CAGE1.WAD",          "5cc8dff47b921c8a16121d25f05e12cc" },
    { "CAGE3.WAD",          "9e06c9d2b9dd1bf61e8f83b6d29f7b40" },
    { "CAGRAG20.WAD",       "6cc26caffec1aeaad7ccdbcd95a0d904" },
    { "CAIN.WAD",           "247f0bc7eb557427c05b782f89fd389f" },
    { "CAINA.WAD",          "56f778689a5b572f9b6df35b14237348" },
    { "CALGONFX.WAD",       "3c26934e2abee8e2e21a46d2a6ab82e3" },
    { "CALMA.WAD",          "f51638404fdf83a6ed5300ef4e9d2ce3" },
    { "CAMELOT.WAD",        "83c72f412c3a0def3b75574f957fe6e4" },
    { "CAMERADE.WAD",       "8eaaecd0190c9de1932b18882e8f5acc" },
    { "CAMP2.WAD",          "33b59a7d1ac26223eff29f4ef334e965" },
    { "CANCAN1.WAD",        "aa57de3ae9542a1645d6db92aa157575" },
    { "CANTHIDE.WAD",       "588929abb9d59b7b47e545b1cb7bb2a5" },
    { "CANYON.WAD",         "40ca2494514c021b3ad3db40f8bd2a75" },
    { "CAOS1.WAD",          "87be782952a9f8a1a31a62191b251f4b" },
    { "CAOS10.WAD",         "74be76ac04f36fd83f34b1cc2145588c" },
    { "CAOS2.WAD",          "cf9391367a0c7ef3363e3d7864ebd6c7" },
    { "CAOS3.WAD",          "0b60ff4c1c235ae2a78ef9cbc771aae1" },
    { "CAOS4.WAD",          "60422a70dfc55ffe4a331bae9128efda" },
    { "CAOS5.WAD",          "d5c527cc9891dbd73319f2945be613b2" },
    { "CAOS6.WAD",          "09dbcdf4d63aa15693deafa4cdf86d60" },
    { "CAOS7.WAD",          "731ead3976481cd67b13bd3cb575644b" },
    { "CAOS8.WAD",          "098b27688c0ecbece92fb48694d296e6" },
    { "CAOS9.WAD",          "e1be876b85d21b25dbb9a1ced13c1417" },
    { "CAP.WAD",            "c434ca7d8d763f61385bfb95bef4e8b3" },
    { "CAPDBASE.WAD",       "2b1fdfa09d4042549727c1ae92c58254" },
    { "CAPEFEAR.WAD",       "bcc4259d0c301721d292726a4fe64e75" },
    { "CAPEMOSS.WAD",       "c2f55fb48b5796b276ccf3015eb23655" },
    { "CAPFEST.WAD",        "449a9ef9bf3943142f9c8a361b88fcfb" },
    { "CAPFLAG.WAD",        "48e63bfcee98059edf1bb2931abae26e" },
    { "CAPTIVE.WAD",        "e7b89ec2978579fdb56e3a86d690b4fc" },
    { "CAPTURED.WAD",       "3e1522d74a58c169e1ec7f2a2ca3b7dc" },
    { "CARDIAC.WAD",        "a98fc0f0f7196c805378b101588d2894" },
    { "CARNAGE1.WAD",       "84fcdd880ba0596f85a591a287f1fe38" },
    { "CARNAL.WAD",         "ddcaaff8b5f061d6dd774533e951fa3c" },
    { "CARPD.WAD",          "195782fd226ed84f86d6fb529227a4fc" },
    { "CARPET.WAD",         "e730af0dbc307322850ad8871a574e0a" },
    { "CARRION1.WAD",       "35922dce7eae185f7033171b4c89f353" },
    { "CARRION2.WAD",       "c0cfdf985577a0a503d1ff6ec4231aff" },
    { "CARTELL.WAD",        "f1d75cbb0367e1ce75aa9173a23d7fa5" },
    { "CASAD2.WAD",         "5a7d8b5d907c783fa1b7a693c964138d" },
    { "CASLDETH.WAD",       "8c0d5e5230f6a161f6717dc4683931ff" },
    { "CASLEVEL.WAD",       "b76c59901c515d0b0749826c3fdfb101" },
    { "CASLOTR2.WAD",       "74b596da850d6d30f5ec7367e2127097" },
    { "CASMANIA.WAD",       "5ef97e981bbe063e4b0e6a39d40c47cb" },
    { "CASTATOR.WAD",       "9c6ddd7195da57aaacc8ebc54c33444a" },
    { "CASTLE.WAD",         "9f415bf51f2c64d354f6f155110bcbe3" },
    { "CASTLE.WAD",         "e48f86c077281c1472c69c8c3ab39759" },
    { "CASTLE28.WAD",       "2b11b6148d161fee49399596810c70d2" },
    { "CASTLE3.WAD",        "84424b9b04cf043431f2f6a6d556272d" },
    { "CASTLE66.WAD",       "7d41dda9074ff68a19071c17558c3f00" },
    { "CASTLE69.WAD",       "a51ff71f470a3a97120d227bdc3e370e" },
    { "CASTLEDM.WAD",       "14821de193b478a1e1174eb3cfecefdf" },
    { "CASTLEOF.WAD",       "e654d9c38815d33c6a44fd00bb6e7cfe" },
    { "CASTLES.WAD",        "3139edabbc9c6e6c93090429fdaf67ce" },
    { "CASTLE_B.WAD",       "6cda5a6ddb993a35fe7db76cc8674ee6" },
    { "CASTLE_C.WAD",       "a6f25c0c65ff48ea607a94bdaea62bc4" },
    { "CASWAR_G.WAD",       "18271bb3e51c7cb4e022341e67b1cd7c" },
    { "CATACLYS.WAD",       "d2bd8cfc62e8ad777d419ae6db7ff24b" },
    { "CATACOMB.WAD",       "e6a0f3bb9fb3ce35dc0743d955463a57" },
    { "CATHEDRL.WAD",       "6291d0b8348ea9046b7e0479fd8160da" },
    { "CATHEVRY.WAD",       "95dd41157b4dc25e7585916acb27849a" },
    { "CATHRSIS.WAD",       "d5304ab48c1875df0ab7460b4cfb93b0" },
    { "CATWALK.WAD",        "21cfcc4e9e468db0ed1449bf01609f0a" },
    { "CATWALK2.WAD",       "e0b4f53d01a5af4ddc9a9878e02a6a26" },
    { "CAVE.WAD",           "c870d91e861425a59d1cdafcdb7723a4" },
    { "CAVE69P.WAD",        "15fcaaebd16e37b1fd837b3132ea22d3" },
    { "CAVEBASE.WAD",       "4de59d7e603ad6232878b863abc5b1af" },
    { "CAVEOD.WAD",         "12506818c22380398875386f9040ec9e" },
    { "CAVERN.WAD",         "374074f70b1cfb2d5b8b345c0ed21d50" },
    { "CAVERN.WAD",         "c329f86d9ff9f552a781ee09964afdcd" },
    { "CAVERNS.WAD",        "c4bf7a61889a51b53f77eed60d662b5d" },
    { "CAVEXX.WAD",         "3243c15dba5f01f8b57a7cb1b2e0e430" },
    { "CBLEDGES.WAD",       "f1d66f2730c2522f0466525d74d70253" },
    { "CBS1.WAD",           "fbbe7172f590d5fe1caadf61e9cef930" },
    { "CBS2.WAD",           "755762f952e6166bfbab60d79a27f0e1" },
    { "CBSGHX.WAD",         "439955061a2cee7393e14d41829698a3" },
    { "CBSI.WAD",           "29cc01d097c1008cf606c9c74a311d37" },
    { "CBSMID.WAD",         "cc5f282015254aed26298fb469faed73" },
    { "CBS_SE_11.WAD",      "08458434ff9dc0d67b0b9dfe6bc99d45" },
    { "CC3RDBLD.WAD",       "dd8a5659c6081f8ebcedf05caf9d77a8" },
    { "CCINTRO2.WAD",       "3340b7d4e93086db35480406a0100f2f" },
    { "CCT.WAD",            "697efa158106e016ae86ba6d3b699637" },
    { "CC_DOOM.WAD",        "521e5f74c8280c45fbfc35307fe6b5a7" },
    { "CD3.WAD",            "2dec95e6efe1dc6395fc90389b28a1ef" },
    { "CD_MAZE.WAD",        "d3b81d56f52bf7cef1ee5d7aa045ba59" },
    { "CEMETERY.WAD",       "c97bc42d88a0380053ee0307c6298e93" },
    { "CENTER.WAD",         "b8a795b0ccb02e937156a907f56f1c0e" },
    { "CERBERU2.WAD",       "5da5d5300118f7d108e5350521aaaf2a" },
    { "CEREMONY.WAD",       "ec52fb7c9dd5e6cf46fd040c20329186" },
    { "CERTDETH.WAD",       "b28f44e9cd82cf570031139874c27bdd" },
    { "CERTMUS.WAD",        "af757d3d7d1eb0b0873c859b79844bea" },
    { "CESSPOOL.WAD",       "dee2bcf0e0be0548caf64ded9d9cf30d" },
    { "CETIALP6.WAD",       "2aa6080364549685cc58a8209fa7398f" },
    { "CFFA.WAD",           "b185782768cfd2c158c4dc598d882cbc" },
    { "CFORTD2.WAD",        "90c69d83d2ccd34a61239bdb69817ead" },
    { "CGARENA.WAD",        "e0b974f2de0ece4451c835398001a7e2" },
    { "CH.WAD",             "873b4855ecf9c2415b4bd5684a5d6dc5" },
    { "CHAINS.WAD",         "a45790c4524d18953433271ad1d0e74b" },
    { "CHAINSW2.WAD",       "7c1c71e7268de0a8bee8f34de3ec6f36" },
    { "CHALENGE.WAD",       "c2c00024c69babe828d37fb872d13363" },
    { "CHAM1.WAD",          "2ea83c3bd452fe5ae33ff5e3dcbc2eca" },
    { "CHAMBER.WAD",        "1ba02a6200a5c83e5456590862d1b882" },
    { "CHANCE.WAD",         "2bf2681c96723b06ff1eca29f203e99e" },
    { "CHAOMUS.WAD",        "a46944d5c302d157436922f4d0599fab" },
    { "CHAOS.WAD",          "4f3bae7ce9e57935d5e17fc9263093d6" },
    { "CHAOS01.WAD",        "4aaa2619a9e2cf81edd5589326679ff2" },
    { "CHAOS02.WAD",        "745fa62f05dd0b2fc1f66d8c378770f9" },
    { "CHAOS04.WAD",        "571ee30b8a61bf591cc6f4854dc001ea" },
    { "CHAOTIX.WAD",        "a3494a01ee0d4da7f786b1bd9167e76e" },
    { "CHASEME.WAD",        "c29f892d19e4b0fe46cb71facf667edf" },
    { "CHASEUM.WAD",        "b0d6c3d4daac57bc76c1af2d84eebce7" },
    { "CHASM.WAD",          "bfd4de580e6652f1af5d5a1f4c8a2d2d" },
    { "CHASM.WAD",          "e5b0ed1615120b59313d5cc8fa63da42" },
    { "CHASMS.WAD",         "be456c14e6a270cfbba79df4992a6a56" },
    { "CHCKMATE.WAD",       "15c7cc4b75698621a26e7969df355889" },
    { "CHEAT1.WAD",         "b09754dd014bdd1f92825b3aa51bca8f" },
    { "CHEERS.WAD",         "780c68edbc6d9969d84747472fa52afb" },
    { "CHEESE.WAD",         "3ab7277642796967c64cff4fef511173" },
    { "CHEETER.WAD",        "0e03f12537718a8f9e69a14301e100cc" },
    { "CHEM-01.WAD",        "5f75af62bde9a649372a66fc2c255ed1" },
    { "CHEM.WAD",           "be5d23a4f162c60ac968948400fa5a0f" },
    { "CHEMICAL.WAD",       "cdd59177e01b51f8dd06d42bc21106d4" },
    { "CHEMLAB.WAD",        "807341d46344e53b131a37b474e4c7c6" },
    { "CHEXTC.WAD",         "4433fc2dee1dd6ddc21a69df5efbb0b9" },
    { "CHIA!.WAD",          "4602b3c701b29b612123588fa918cb91" },
    { "CHIEF.WAD",          "d0310e11577e3ad78ba1b249b42d1e3c" },
    { "CHILLY.WAD",         "4155f4b412f7157536a7eba06c92a188" },
    { "CHKURBAK.WAD",       "5a436d4abe53979b52d069611458958e" },
    { "CHLORINE.WAD",       "1283b7132385d8f7958599d0dbc069ff" },
    { "CHORD1.WAD",         "e577d0e05787ae6807510c4e7adb4ba9" },
    { "CHORD2.WAD",         "8c69157c0cbbefd0d50a98a23d154093" },
    { "CHORDG.WAD",         "2934abc26d4b7a913cf67fbfd39aa053" },
    { "CHORD_NG.WAD",       "c6dda8572baa97427da33f19d0e25543" },
    { "CHPDMLOL.WAD",       "86e55eb6b2ece41b539eb3c25192a16d" },
    { "CHRIS4.WAD",         "f87e9c80a1b64c02b6c42f13c1dc9d59" },
    { "CHRIS61.WAD",        "60dfe8d5280d3feac39ff7b9209272c3" },
    { "CHRIS7.WAD",         "2df72d64c3f07a1fa1eb72f100de5287" },
    { "CHRIS8.WAD",         "981de1b8cff946ba496a8ad1de15f782" },
    { "CHTOTAL.WAD",        "d00c971f28d66cc52c27528ff547b115" },
    { "CHTOTAL2.WAD",       "abbe5ae95c045fefd611f0d584e7ed68" },
    { "CHTOTAL3.WAD",       "1b8dff23223f5daa091166d7ce43cea8" },
    { "CHURCH.WAD",         "973d63553f088e9d7980e9924dd4a371" },
    { "CHURCH2.WAD",        "0880721416284c52fee4dead2af56b3a" },
    { "CIC.WAD",            "088a87bf6785fec8257216c5e02041c1" },
    { "CIRCAREA.WAD",       "1d9b66ac37e81710528d80f775b495e8" },
    { "CIRCLE08.WAD",       "e78aba407556253a2f304cd4c9d0f2ca" },
    { "CIRCLE2.WAD",        "3f98f81eb232dec4fae4f6b93e5d80f1" },
    { "CIRCLEDM.WAD",       "e7ce73f6cb167838c29d788323486dd3" },
    { "CIRCLUS.WAD",        "0045439ec61990985aafbbd4ad16a489" },
    { "CIRCUS666.WAD",      "aa61d64e0f3b6bc850de269a26ea5003" },
    { "CITADEL2.WAD",       "5db37c4dcdc6a181cffc55c84f725045" },
    { "CITADEL2.WAD",       "e9fb66043b4a27cf13ae6373dd8aed8a" },
    { "CITADETH.WAD",       "02aebb3631b106ae1aeb2b91187213bf" },
    { "CITDOOM2.WAD",       "5ca2a303ccf9ecb768260d00ead1704e" },
    { "CITY-DM8.WAD",       "620d20acb9f6b27053cc3c3280071d7a" },
    { "CITY.WAD",           "6ed04aef76254917268a6aebce6e24aa" },
    { "CITY1.WAD",          "f186f0e29212821783e87ece4700171f" },
    { "CITY2.WAD",          "17ea25dcfc9ee6431d5511ebc671b2bd" },
    { "CITY5.WAD",          "ee696209ddd9eceadf9e098a0919360b" },
    { "CIVSAW.WAD",         "093b9eec281157154563e24de71b618b" },
    { "CJZSOUND.WAD",       "635cd6fbd42824a07716512bce585bdc" },
    { "CJZWAD.WAD",         "6bd52987cebf48cce5dd1e801c2974cf" },
    { "CK1.WAD",            "e1172cd942a5e6699972fc9facdcf6db" },
    { "CL10MUS.WAD",        "074fcdf746576f040b438278979bee10" },
    { "CLASSIC2.WAD",       "a6dde17e667ec0c68f36bbbab1498467" },
    { "CLAUSTRO.WAD",       "7707a86ed7a440daaf4933a473cce7c6" },
    { "CLAUSTRO.WAD",       "f9625a61911bab5e090682d9921523f2" },
    { "CLAWSON7.WAD",       "9cf9762e9cea8f055573765abd212372" },
    { "CLDF2DM.WAD",        "73253ab2fdd1b49d8dd260848b517ac1" },
    { "CLERDANG.WAD",       "3042da7906b825e561ecd058b76a33ab" },
    { "CLIFFS.WAD",         "d2001c48f84c8ddf803da83f2724756d" },
    { "CLIMB_ON.WAD",       "c6a82a4082cfe8840367919cc7fc5071" },
    { "CLINTO01.WAD",       "66feb48eb9a5ceaf83ccc7609f1c90bf" },
    { "CLINTO02.WAD",       "8e99c21165977314a81aff0e69f3f3af" },
    { "CLINTO03.WAD",       "ee55b46fc32202bdbb2818e417f083df" },
    { "CLINTO04.WAD",       "a2f1389b36a91e6727dedd1bcc2c3429" },
    { "CLINTO05.WAD",       "0a8922840c3534f6cdd896c5cda230f2" },
    { "CLINTO06.WAD",       "97f442d8f4535beb43fbc0c27346b8bb" },
    { "CLINTO07.WAD",       "bdaa68c1831f07d07fb9bdc7328a4d0e" },
    { "CLINTO08.WAD",       "acd463d663cc8d66f038e6a2117e1560" },
    { "CLINTO09.WAD",       "bf69f4cd17a5e953b9a54f0ddca7d699" },
    { "CLIPPER.WAD",        "e7e6ca4586ff386694e17965c31cdb51" },
    { "CLMNFRAG.WAD",       "7faca7cb071015fc603cf95090b43a40" },
    { "CLOACE.WAD",         "a849ae78564d0e59a13024e112ee7782" },
    { "CLONAGE.WAD",        "cdc45bb6b2f968a25a18a4565fc464ef" },
    { "CLOSECOMBAT.WAD",    "eb154dbebdfa62d6e4dc1746939792eb" },
    { "CLOSURE.WAD",        "fe48cc6bca9344c588b6788d7b722a7f" },
    { "CLOUD01.WAD",        "7ded8acf559df3a27cfc3d8fb8815d91" },
    { "CLOUDMUS.WAD",       "1fa05f4165977e77a37fddd79aabeaed" },
    { "CLOUDSSG.WAD",       "160a28ce85bbe571829187b6765e2e68" },
    { "CLOUDTEX.WAD",       "84a3a799b22632d66e8f6c5b5905b752" },
    { "CLUE14.WAD",         "6fe27648027698cc83482ffaa9712687" },
    { "CLVRLEAF.WAD",       "1cdebd00ca5646ac06f8069fe5cd1088" },
    { "CM.WAD",             "1575ba29c125b2ddd8dc32e5e2f9b496" },
    { "CMF.WAD",            "51eebe21648c8f8d5999650982b33e50" },
    { "CMINES.WAD",         "a302c68356730e7fbf779cf2fc617acf" },
    { "CNTRMSUR.WAD",       "9a183acac386bb22a655a8825c6dfde5" },
    { "CO.WAD",             "ec45b113d1ecba6240e622298a16ef1d" },
    { "COAL.WAD",           "354ff9984f0e6210bbd7c43d62fda588" },
    { "COCHRANS.WAD",       "804a46165b09be750d345bdac7582922" },
    { "COCTA.WAD",          "bf216a54061c8df6c127f11a5473008e" },
    { "COD1-11.WAD",        "f154e8d8f2577df4da3f1cc2ccd0f7cf" },
    { "CODA.WAD",           "aafea388fa5f95bb7de8fb47599b9857" },
    { "CODEAD.WAD",         "f2180cbeca3ccec1e243a016bd8ef18c" },
    { "CODEAD2.WAD",        "8f2bb6fce91599af8a6510f2ce0a430e" },
    { "COFD2.WAD",          "b278c64adfda19d861da36ca0472bcce" },
    { "COFDS.WAD",          "48317278f38af0fde5802c51148fe926" },
    { "COLONY.WAD",         "5c975f86d0dc13df762f56728aca855d" },
    { "COLOR2.WAD",         "fe4ea2ccd056f2df99a879792d4caec7" },
    { "COLORS.WAD",         "82243f4e53dee1ad3df61674313be05d" },
    { "COLOSEUM.WAD",       "fae7f19164344a4aafd514d37c948dac" },
    { "COLO_DM2.WAD",       "7c2d209374af5677cd93419f6670bf71" },
    { "COLRCODE.WAD",       "fa3e3626b47d697f558f61abcb4bb6c5" },
    { "COLUMNS.WAD",        "3fcc77514b45ee3f31dcfaa1ac4aa35b" },
    { "COMATOSE.WAD",       "927754b8c14d51a1f2a454a44f40c2bf" },
    { "COMBASE.WAD",        "eb51cd413469a4a3a20c6b1ddee0aac4" },
    { "COMBO.WAD",          "f71f11b33aee8936f1f1081fb88aff73" },
    { "COMEASUR.WAD",       "256d630cad7fb229ecbbadac301455cc" },
    { "COMEIN.WAD",         "eb6ab7a7ff7b4bbdcd89a5739acdbf81" },
    { "COMMAND.WAD",        "48c7b19977e115abca4886bcb3cc71ef" },
    { "COMP45.WAD",         "5a1e15030b3bbe22fbe38064c10361c8" },
    { "COMPLEX.WAD",        "e58ec3ad09758ce2beac7c624a7a34b9" },
    { "COMPLEX2.WAD",       "ecfb24b6492305174d51bbcb8c3226ea" },
    { "COMPOUND.WAD",       "ee4595f8937e3f02c37442903a7d599b" },
    { "COMPOU~2DM.WAD",     "bbb171ed9a5cd619c9d1c81eff13e748" },
    { "COMPROOM.WAD",       "ed4491db4cad66e395aaa016b21c432e" },
    { "COMPUSA5.WAD",       "ce92937a645806137a931d8a91feef30" },
    { "CONDO.WAD",          "8e6899554b40b2bf82d18f2ffab2b2e2" },
    { "CONFUSE.WAD",        "f5742ae88842ac198e1bdcd41e7f006b" },
    { "CONS.WAD",           "0688004ea4107494ed8a8dc99395ab2f" },
    { "CONTINUE.WAD",       "44f1fb83e73686be5d5a877ff7622193" },
    { "CONTROL1.WAD",       "f11676caf2fb251ba8fb0292fd15a874" },
    { "COOL.WAD",           "ae41caba681ce3eef309b509c8f7312b" },
    { "COOLCITY.WAD",       "23b54518cfc4afae1eda07f0d2b85c2d" },
    { "COOLCTY2.WAD",       "7e4a9b836a276931f1adbdf800d2913d" },
    { "COOLDUDE.WAD",       "8adb0604816bdcffdd7905ecc5a3da43" },
    { "COOLEY.WAD",         "7877b8ea62ba5fc32f21a47cf06f3fa3" },
    { "COOLLVL.WAD",        "2597d6ac2090786429146fa99ad80031" },
    { "COOLSUB.WAD",        "2b61267a3e09f2507e3d24645f7e94fd" },
    { "COOLTOWR.WAD",       "ebd35dd1f221a4edb823d0388224bbfc" },
    { "COOLWAD1.WAD",       "419e06f3db3c26e8b95e6a7c30ddd829" },
    { "COOLYARD.WAD",       "d1f792fd491fc4534e38956186d70783" },
    { "COOPQ1.WAD",         "dc950c6df1800f848061b37abdbc3d3b" },
    { "CORE.WAD",           "880a754e3b22bfc1482a9d0c5abcce82" },
    { "CORELESS.WAD",       "cc4a5281f01e40a3016994c0a5a113bb" },
    { "CORN2.WAD",          "6749a669eeb6550ba97cc0cae5654afb" },
    { "CORNER1.WAD",        "7af010f942af4214b2f3df9d80f984a5" },
    { "CORNERED.WAD",       "f4d42194418ff10c34d057d8bc3c82c9" },
    { "CORP.WAD",           "905b200702bcd7dda177f92770c93b5f" },
    { "CORP3-B1.WAD",       "fdd0329c54ad983ccdfdb18faaa64afb" },
    { "CORPSE.WAD",         "01a97c7494f7670f6dd017f4f3b8653e" },
    { "CORPSE1.WAD",        "b533b0ee2c0b30f9095e525079e28099" },
    { "CORPSE2.WAD",        "7057d854f6719d2cdd4c0051bafcfcbb" },
    { "CORRIDOR.WAD",       "5fa8d8f3ceb86c6183599f4d1a769a65" },
    { "CORRIDOR.WAD",       "6f110f9b97f71b0eb563f8da376da0a5" },
    { "CORRIDOR1.WAD",      "6205b9b3f4b7f46b7fd4a7117fc35627" },
    { "CORRUPTE.WAD",       "bfa03c28d9b978c0ccd6f427d5f7c359" },
    { "COR_HEL4.WAD",       "4c2192efda0c25af49b21885c0c53c09" },
    { "COSDETH1.WAD",       "29d52ef71eddd39153858729beee9bfa" },
    { "COSTA01.WAD",        "35a56e9857423e80f7b074ccae23ef88" },
    { "COSTA02.WAD",        "d5b850508fe6c58a42ddccea60154cc1" },
    { "COSTA03.WAD",        "4a66fecd8e3e1de1b8109f5d4613de92" },
    { "COTA1B.WAD",         "7ca2b3f2efeb1d2c7a22d334f5bcc9a1" },
    { "COURT.WAD",          "d9b399dc31bebba1c4681a0b1d0155bd" },
    { "COURTESC.WAD",       "31a8d2840218ca1cb6bfe62286e16ef4" },
    { "COURTYRD.WAD",       "137a4372adaa0a637866f77b987371d6" },
    { "COURTYRD.WAD",       "fd28e186609597f57e93d49e915ecdd4" },
    { "COVER-ME.WAD",       "a8e986d357589f965d40e61cd496655a" },
    { "COYG.WAD",           "23be06e9b32c3036cf31979dc2ab6382" },
    { "CPHINT16.WAD",       "a7078e1f6f830e8efb0ca5d420603fbb" },
    { "CPHINT17.WAD",       "f121fc28926bcf6f682f15ea5b27d848" },
    { "CPHINT19.WAD",       "bf8f6c478a674bc79c8c87d4c73f5de3" },
    { "CPHOBOS5.WAD",       "52321c923ae16fc1be8646bae9a368d0" },
    { "CRADLE-1.WAD",       "6ea7e74325bb5a7db36eb5b7af1446d5" },
    { "CRATERED.WAD",       "e94bc5464e07ba644636fc14decb1e8d" },
    { "CRATEWAR.WAD",       "b401df4e2e058ac7dc744fec4264fd4a" },
    { "CRAZY.WAD",          "d04375333880efa58350427ee9a14810" },
    { "CRCHAOS.WAD",        "8f5cea1ddab5a0f8a484892b192e6bab" },
    { "CRESTFAL.WAD",       "e8f655d6a27780ccf1c3546cea8e7fcf" },
    { "CRITPATH.WAD",       "58ab7482c30cba7f8fb918d28f8ee1df" },
    { "CROSFIRE.WAD",       "7e493eddb133bbfcd18e3c5abb9c22b6" },
    { "CROSHAIR.WAD",       "1a22c8ed17bcc6b734a95498fb3c4893" },
    { "CROSS.WAD",          "714afa321bb562c9fa752a58837e3b26" },
    { "CROSSCON.WAD",       "ab82ef9125e67cf7fb523ecd59778113" },
    { "CROSSFIR.WAD",       "d6a476f59b5781438ea9fb5ffa7dd028" },
    { "CROSSING.WAD",       "fa02570e0ad41c3bc4d5bccbf80f1f77" },
    { "CROW.WAD",           "f7afa677275600d9e2dbf5517b7d7893" },
    { "CRUCIFY6.WAD",       "b20273c3088383cbd2b1c238a71fda49" },
    { "CRUISER.WAD",        "fcdee8eee4abf41ab54bc64bfed108f0" },
    { "CRUNCH2.WAD",        "140089cddea78d0a4746f37521dcd346" },
    { "CRUSADE1.WAD",       "e66fa54c9dba4ffe9f75b7976029101c" },
    { "CRUSADE2.WAD",       "983815b2682cd6db0a5ed4e4a6e53bdf" },
    { "CRUSADE3.WAD",       "13a69a7f6185c6f60773b930eedd2571" },
    { "CRUSH.WAD",          "41bc29b4d85ac866ae0f51d6aec8638e" },
    { "CRUSH01.WAD",        "08c055aacead4de52f4fc54f110e794b" },
    { "CRUSHER.WAD",        "439a33da3a907a9301131e318668450e" },
    { "CRUSHER2.WAD",       "779b9f58563549f72d820644eb5cd1e8" },
    { "CRY.WAD",            "7bdf107c1fe30019fa556526e80be72f" },
    { "CRYBABY.WAD",        "1b116e1737fab9292558898aa90285f7" },
    { "CRYNOS.WAD",         "deba662017d19aadae712b2a90fa8415" },
    { "CRYO.WAD",           "c5bed90dc9b0a185d53abdbdcc17bbd3" },
    { "CRYPT.WAD",          "52b2b9c820808ab031c9f883f30a972b" },
    { "CRYPT.WAD",          "56e6a83f717e615d74c148964f91029c" },
    { "CRYPT2.WAD",         "eb7a6b0dfd6fcbc4941fd0d378fe6876" },
    { "CS3.WAD",            "9ff7a21993e75d2a467e4f82e205ce77" },
    { "CSDM_57B.WAD",       "ca703041daff23447b7ce6ffa3b2774f" },
    { "CSEDMV3.WAD",        "2ada60881aa2726df5d78fca7fa2bfa7" },
    { "CSKG_57B.WAD",       "8d0a04f8ebc82e8efbb81f1e07d37afd" },
    { "CSRD2-01.WAD",       "e7266a0ca71335f8af1223e3ae896073" },
    { "CSRD2-L2.WAD",       "7f22e6a83762d7d6492be1eb6725895d" },
    { "CSTUBE.WAD",         "f11001829ab9ecc3a599478b8c2da034" },
    { "CS_57DM.WAD",        "9db225976ddb412890c785ad7ee21da9" },
    { "CTF.WAD",            "a7c2bf17b5f1e686729b2ee07d7aa63a" },
    { "CTF1ROKS.WAD",       "35c4d7d80a188726f3d4982ab1fb9cb0" },
    { "CTF2ROKS.WAD",       "a87f57746cdf01c60d1c446da4de864b" },
    { "CTFPACK.WAD",        "95ac02a9eea4ccd3cf1157b218217cfe" },
    { "CTHDRLSE.WAD",       "232ed1cb3616392df47d7006dd679c3f" },
    { "CTLRUINS.WAD",       "8775252d5c8097fe06fb0a1c6450273e" },
    { "CTRLCOMP.WAD",       "2cd213aa0978d9e91f892e49baadb3bd" },
    { "CUB.WAD",            "2a47b4b0039738a76389c331dfd1aeaa" },
    { "CUCHILLO.WAD",       "e4dfd5d2f27caee8bf1dbf03c4e45195" },
    { "CUE2.WAD",           "c7811d5790c26e956bbba76065c9f890" },
    { "CUINHELL.WAD",       "091dfd26f1e9c1156c1e670b26d137e3" },
    { "CULT-PIT.WAD",       "20e6d16d6abe6b174c8b314741f2ba1e" },
    { "CULT7.WAD",          "6046ec5631979848a231547d5e6224a9" },
    { "CUN_GFX.WAD",        "40ca1e01dca2d9e1bc773b482b067c5c" },
    { "CUN_LEV.WAD",        "815123012aca4f4f8df8f261d13b69cf" },
    { "CUN_SND.WAD",        "960c39a8660668804cfc1910c005891e" },
    { "CURTIN.WAD",         "19a3c1395bf2373a1cdc6000bc90f3b8" },
    { "CUSTOMS2.WAD",       "08484b69f09a5fe56f4c6f8a18409cc5" },
    { "CWAD1_1A.WAD",       "bcc52a5792ecee71798883e1fcf261b4" },
    { "CW_NIFTY.WAD",       "18cad6c2b95a49f99c3ed93e435c999e" },
    { "CW_SWEET.WAD",       "6a58eb29c9206e7e14153ec44bcfc7aa" },
    { "CYBER.WAD",          "469118319f7b5d6d0b9237ae867ec594" },
    { "CYBER1.WAD",         "2b3982751863493138acba35989d2e7a" },
    { "CYBER110.WAD",       "4beb1d45c04864304d2af0511ef870e9" },
    { "CYBER2.WAD",         "3931a994a9e1ebc36502d8d70dd9870a" },
    { "CYBERCRIME2.0.WAD",  "8f378a5d71ff2d0c8b7478779ee643f8" },
    { "CYBERFUN.WAD",       "72c2e79efa3a100456d5206db93e17e1" },
    { "CYBERGIO.WAD",       "d2d53211d4108e4ce731a3e2c1cc644c" },
    { "CYBERLND.WAD",       "07d54f1eba38d516f7ab2cca4026b403" },
    { "CYBERUL2.WAD",       "9bc2c42b7dfceaa49fedef4ff42e0798" },
    { "CYBOFUN2.WAD",       "6dc7b59833d274a584208242128a4e9d" },
    { "CYBQ202.WAD",        "22ddbfce364af67d2859210600445e07" },
    { "CYBRDNCE.WAD",       "f6edd106178a0b56555ae1fa7d22f768" },
    { "CYBRDTH2.WAD",       "47bab2a648eed70b654bf6e4db83141f" },
    { "CYBRFGHT.WAD",       "e08d1c8b4d551530da30ec1b67a7aac0" },
    { "CYBRFORT.WAD",       "ac7e97c28c5ea935d8e31942603269d6" },
    { "CYBRSECT.WAD",       "6cf9ac0daf49667026fdf7bcc2e44425" },
    { "CYC-A.WAD",          "02640899266ab50ef5e83ce51fd4231b" },
    { "CYC-B.WAD",          "51215968010d3b8051444d776dc48542" },
    { "CYCLONE.WAD",        "1380d98bb5b032cb3f92faff932fa62c" },
    { "CYCLOPS.WAD",        "6fbaa72c9d79700eb83852be759a5e60" },
    { "CYGNUSIV.WAD",       "926c9b985bd3127ea3c152512b6571a5" },
    { "CZPSYC11.WAD",       "6c3273d00ea973a28503ee539277b345" },
    { "C_CHAOS3.WAD",       "a486a5132e411ab0663e32c7139d40dc" },
    { "C_SAND.WAD",         "40b4cd8d23b76606c9c995dcb4ae2635" },
    { "C_STRAFE.WAD",       "3e2a013a9eaa4e43e14fd334eda97ef8" },
    { "D-1.WAD",            "7c21018c1b662ef6f7e57c2191660b53" },
    { "D-2.WAD",            "2befa9f213dbaea8aee98c8232c94cac" },
    { "D-2MTNR.WAD",        "853e4c73e1ec9a1292ae36582f0659b4" },
    { "D-3.WAD",            "a3631574961d8b7dd9c84c926ab01056" },
    { "D-O-A.WAD",          "c080349f1b1a77244113f3ec018403c6" },
    { "D-SWIRL.WAD",        "208471cd0e6dd6661e4ab5aface2b881" },
    { "D00PID.WAD",         "e3b6f2ad3331e1ba4817f7a0a24ebeaf" },
    { "D2-BULL.WAD",        "2ff3f2e28fd03312e8258f4d9569f935" },
    { "D2.WAD",             "e8b7cd6858c224f8b73269236a32f282" },
    { "D201DH07.WAD",       "af4656b93a8fe1fe761d1f72c4aad73b" },
    { "D208.WAD",           "2c08a804fe965b9ad88d4025b7f7613e" },
    { "D214-PT1.WAD",       "a5a7de5928dea62f884bc0dc6103d437" },
    { "D2200EP1.WAD",       "3932725241024b51b517ca0026182dfd" },
    { "D2200GFX.WAD",       "8448b2aad0315272565d77b8ea387577" },
    { "D2ARENA.WAD",        "fe32cbf6e6c522f0b5b3c1b1ece2b425" },
    { "D2BATTLE.WAD",       "b3629f76c0dfaaad80a2029b6cb6db8e" },
    { "D2BROYAL.WAD",       "c909ae656cf5eca51058f5b2f1227485" },
    { "D2CITY.WAD",         "577a82be2aec7e515bcb5a57cb2b65a7" },
    { "D2COOL.WAD",         "5f5e4da2f8c5ab6ef49c069fee73d8ba" },
    { "D2DEB102.WAD",       "f2fd3fc81715ba2e2b0814f650bb9889" },
    { "D2DTHEPI.WAD",       "5fe00a7d2984faa0bfdec0a926d1cf19" },
    { "D2ESC.WAD",          "7dda09d8edd6ab7fb060d423ae621a44" },
    { "D2FUNK.WAD",         "65170a820eee351f19597cdaeb5e128b" },
    { "D2GRIM.WAD",         "eacf85ec616d51c7e10f20287ac11160" },
    { "D2HOUSE.WAD",        "86fc0535b155f3746366c363d1e8e7f5" },
    { "D2LEDGES.WAD",       "6e751b3b74fedd5cf7369840551cf61e" },
    { "D2NECROP.WAD",       "83bab4191283f5ee486a34273d985a89" },
    { "D2POD1.WAD",         "22fbf1c4d462845d0aed0477877d63c6" },
    { "D2PYMID1.WAD",       "383946e6b32b8f85c3e0d2a334be5bec" },
    { "D2PYMID2.WAD",       "b2a53d833d5ef4e15a4125cc8e48c221" },
    { "D2QDM2.WAD",         "6452f853c55e750a662736384b951618" },
    { "D2U.WAD",            "9e5abdbf19ba330a14ae7bb1751f3d88" },
    { "D2VAULT.WAD",        "a584ae4f98eb541c61599422b20e6bd9" },
    { "D2XTREME.WAD",       "fb81508cd23109746dd44229d3b6d7ac" },
    { "D2_KILL.WAD",        "c44212f6987073fb968d6c095256f060" },
    { "D3D2DM2.WAD",        "c553d94305ff38a1b922b2a464d538e8" },
    { "D9-2-2.WAD",         "d0c11784376f9a409ea48d4588244245" },
    { "D9-2.WAD",           "32d73085e86de34e691c1d6307fcc435" },
    { "DAEMON.WAD",         "d6e4f05e8b12d5471f32bba541c76fbc" },
    { "DAEMON2.WAD",        "b4ac42887ec8c0741c5824abf0d75ae3" },
    { "DAEMON3.WAD",        "7d9e1a4eff00f69f8a01ed880bfc9787" },
    { "DAGKEEP.WAD",        "e7014baa375fef21984269bad53428a5" },
    { "DAHOUSE.WAD",        "7b298e0263bcf52fce6080708ada188d" },
    { "DAKILLS.WAD",        "150ab1748bfea3946c96402df97a84fb" },
    { "DAL01.WAD",          "6284c15d324bd2fa3d9161c0f0ed4ec5" },
    { "DAL02.WAD",          "1141a543744da229cf168c660a79cd70" },
    { "DALI.WAD",           "536d8e1782fbdbc0129824c2dff4760a" },
    { "DAM.WAD",            "4760fe3cf63d878b56284d2d935b4e80" },
    { "DAMAGE01.WAD",       "0b4c41be6750e876bd33d55b4baab44f" },
    { "DAMDOOM.WAD",        "0df8e8421157dc3e09d9bcad5e865ef9" },
    { "DAMN!!!!.WAD",       "9bbba7e88a183e983e28d633b9914139" },
    { "DAMN1.WAD",          "1d1053c9835c65942763473823406ad4" },
    { "DAMN2.WAD",          "b870d6e1c127e3139c31222dcd3e3349" },
    { "DAMNBOX!.WAD",       "d6927fe3239b4991a9783776978b00b2" },
    { "DAMNED01.WAD",       "8e7b625d9855d736baf7c68edcb5ca40" },
    { "DAMNED02.WAD",       "778082b0a4c6e09b95f2be0fd77b75c5" },
    { "DAMNED03.WAD",       "c947f26df29ceb3dfd37a6a195538640" },
    { "DANCE!.WAD",         "666db483087d127bdd74e0c3b312a4ee" },
    { "DANDD.WAD",          "839c68bf0e0e976c109b4762bec59beb" },
    { "DANDETH1.WAD",       "b5b7fa31943afe6e40c510dac6929ff2" },
    { "DANDETH2.WAD",       "0646a1532d97c9f9bdc5063d8d4db490" },
    { "DANDY01.WAD",        "c956424f8bdd55f4cef9249854624991" },
    { "DANDY02.WAD",        "09c0c44ded2413f982a6b80e6dd06f48" },
    { "DANDY03.WAD",        "6e56a1b6001959948cc506fac4518600" },
    { "DANDY04.WAD",        "e0338ca9a63095ff802dd710bb135140" },
    { "DANGER1.WAD",        "10ca21ef97bec073854b757777fc745f" },
    { "DANTE25.WAD",        "bb8269f8ec1fe408ef946e48b2b185d1" },
    { "DANZHALL.WAD",       "b1f6d226e1b7ccf16804ed36861e5834" },
    { "DANZIG1.WAD",        "2f9fd867de8db8a3d3bfaae7c92fa792" },
    { "DANZIG2.WAD",        "63cdae166b4bdc2f5070497b8c1ff791" },
    { "DARK-T2D.WAD",       "df0136fecb0f7acfb46a4fb17ffea898" },
    { "DARK.WAD",           "5b2c5b00bed321eceda1b613ef20b9eb" },
    { "DARKAGES.WAD",       "efee71130cae64053e456e16160b11c7" },
    { "DARKBASE.WAD",       "58c30661d4df4c5c49466ff100cfa0ff" },
    { "DARKCLUB.WAD",       "e9e22aa70bb79023f6b18feefa914c77" },
    { "DARKCVNT.WAD",       "876f29cba0523d2bdabe42ea7d0a6fab" },
    { "DARKDM.WAD",         "fe8084d63ca1bf142604c68e1020d8a1" },
    { "DARKEDEN.WAD",       "ec786094c5eb99677f561cf386cefb9e" },
    { "DARKEN.WAD",         "4950d0990c576157b585c3e88c2d83c8" },
    { "DARKEN2.WAD",        "1f73606389281c41a8ff89acc9053b15" },
    { "DARKER.WAD",         "0ef4e3f60715497f81a5d1d54d43d20d" },
    { "DARKHELL.WAD",       "9d4147bc8f48b5472acb710824d2eabb" },
    { "DARKLAW.WAD",        "a86a5e4269d17d0aa3cc9c5a25bd0a4c" },
    { "DARKM1.WAD",         "86b3fe495da451cfc63be62365966f48" },
    { "DARKM2.WAD",         "5d5778ad95d71c1d9676ce278495540c" },
    { "DARKMC.WAD",         "b5ab41d35907e314428cf16287381196" },
    { "DARKSIDE.WAD",       "644ffcf450e2bea0854fd6f41be1b12a" },
    { "DARKTEMP.WAD",       "db2c79e24a22a88821cd1e9428d639ba" },
    { "DARKTOWN.WAD",       "e85606ab3ce58737a4e32150917f9152" },
    { "DARKTOWR.WAD",       "92f02625505b230c07b127c3526a8eae" },
    { "DASBOOT.WAD",        "3918116535c73230a0344be1f399a1e5" },
    { "DASB_TFX.WAD",       "4d622250295f2939cd807878d4d468ce" },
    { "DASCOTT.WAD",        "d4838c595e0ada30275218d4cb4eda3b" },
    { "DASCOTT2.WAD",       "cac7edcd1fd3a3e7b7943c1bf852d405" },
    { "DASCOTT3.WAD",       "0385db02f8878ec9a4239e04ddb81637" },
    { "DATHZOR.WAD",        "552ecc9c8f095c35be6156a86457498b" },
    { "DAWGW00D.WAD",       "1fb849fb3b4065336aeb2b4336291d73" },
    { "DAWN.WAD",           "2afacef7fe138cb76d4fcda2fdca2499" },
    { "DA_CROSS.WAD",       "f212b487d95b47adbeea0477bd50209b" },
    { "DB.WAD",             "0984b6df0dcf975528a5e87a5cd73584" },
    { "DB2TWR.WAD",         "b01c674836f043aa76dff3c56df98065" },
    { "DB2_GOLD.WAD",       "859d4a0c1af4c00b1861d77a9cb74bbf" },
    { "DBBVDM.WAD",         "9d29a9f097e52ddd692713eb57b28161" },
    { "DBDM.WAD",           "00fa941365bff3cf62fd813c4ecd6bb9" },
    { "DBDRAG.WAD",         "8fa8b5824e2f04cbc48fd590ee63f52d" },
    { "DBL-TEAM.WAD",       "16becedf2f06ebbf3443e1101604d7c1" },
    { "DBPYRDM.WAD",        "8997b636aa0f973e2fbc824efc08ca47" },
    { "DBSET.WAD",          "b7e3e7ee172e9ef605736c4edf430bc1" },
    { "DBSINCTY.WAD",       "02521f712126beb6efefb242f582589d" },
    { "DB_CATH.WAD",        "661596964f9e617de19ce68a566596de" },
    { "DB_QAD.WAD",         "b3b707145b8c2fdd893f9d05b96e67f3" },
    { "DB_QAD2.WAD",        "b8cd6a5bda1521624286e6d00d1b53f7" },
    { "DCDWANGO.WAD",       "e6bd345fbf8ac0a20849ce38b9b3fdd1" },
    { "DCEPTIVE.WAD",       "b9afd1ba10fd7e304f06687dd0256346" },
    { "DCHRONIX.WAD",       "bb782c4e8e5804bf20b7a9f98ec9cab9" },
    { "DCITY.WAD",          "fdc6ec91446df59dbe7b5e0eea206154" },
    { "DCONT.WAD",          "b8412a5ec09e16abacca4a1aeb36bd43" },
    { "DD01D2.WAD",         "7f81e66bc9bc5c700c9fe09aafcd0e64" },
    { "DDAYSNDS.WAD",       "a2d63cea8e2f9a34b250017efa8f96bc" },
    { "DDSOILDM.WAD",       "a58c672df2fed0185516491e18a68837" },
    { "DDTW.WAD",           "dfc6feaaec1960e47b36212d9e97dab4" },
    { "DEAD10.WAD",         "68ed11c8d5941182d8a8690d3c467078" },
    { "DEADBEEF.WAD",       "459f1bb8ed59833d3a8fe0755ef9c558" },
    { "DEADCAGE.WAD",       "d367accebf48a26233f95ad71d3da303" },
    { "DEADCITY.WAD",       "4c2c33dae786bf7f2a4b267962a46624" },
    { "DEADLOCK.WAD",       "7e937c66a187a67c23166cf8ba7129e1" },
    { "DEADMAN2.WAD",       "304b64f8cd45527cdef345034385ca40" },
    { "DEADMEN.WAD",        "98d7f130b267e171020e5bab3d7d8dfc" },
    { "DEADPOOL.WAD",       "f93bf8aee148b2708cdd34e16d6211e6" },
    { "DEADRUN1.WAD",       "ed9aa43d74d26a3dc9c4e0b112aee888" },
    { "DEADSHR2.WAD",       "b4a3ffc805a6179f877704c4bf4987c9" },
    { "DEADSOIL.WAD",       "9fa23025131fffd5c43ddd043dbe960f" },
    { "DEADSOUL.WAD",       "72c86657da0ace2df69c814980a1b048" },
    { "DEAN.WAD",           "c6a0be6ce96e5cf265cc7a74f23d6c65" },
    { "DEATH.WAD",          "1d918dd1a619cc11257e87af2f319c62" },
    { "DEATH1.WAD",         "8b570258ed164a9345a790c9247c695a" },
    { "DEATH16.WAD",        "3285d56fe00d73bd965c3cc5feafe2ce" },
    { "DEATH17.WAD",        "d43f3e771c849048fc22e52d08c0bf47" },
    { "DEATH18B.WAD",       "8ddabfc961a144e274ebd175a364dd84" },
    { "DEATH2.WAD",         "637eb83c381e800fc287ea0d00c2f872" },
    { "DEATH2U.WAD",        "0b2d736f6d1169da8841b2205818e8ff" },
    { "DEATH4U.WAD",        "59da22ee198158018f19b88335280f84" },
    { "DEATHEB.WAD",        "ac198df6d5fe5949ec1821581a83d08e" },
    { "DEATHEBN.WAD",       "c073a6a80b277a3119da6023a0553ef4" },
    { "DEATHL8R.WAD",       "a40ec0cdd89167181c02c1bfc7ae15b2" },
    { "DEATHPIG.WAD",       "b2c7cea81656619e47d9a0a0761c4210" },
    { "DEATHPIT.WAD",       "0a5c5a112b099215a16277b542c0abfc" },
    { "DEATHROW.WAD",       "07499819a13d9046d369524ae81ac5c6" },
    { "DEATHTRK.WAD",       "1de8e0b84f8a547c4d50f40d66d5c8d2" },
    { "DEATHUNT.WAD",       "e48c960349c85c7857527982e8252858" },
    { "DEATHWAD.WAD",       "614e54570b97955b692a0b46f7bb9990" },
    { "DEATHZON.WAD",       "cc8e597b4d7099bd05b36fa7551aea56" },
    { "DEATH_F.WAD",        "d4da648186c45b6e70c1c2ee61c3cb7c" },
    { "DEATM777.WAD",       "44068d9ca7e98645b11b14e0b0697f47" },
    { "DECA.WAD",           "aba29c08eaa09919f9e3e5a7e206daae" },
    { "DECA2.WAD",          "0ddb7dae95172677737586508542ce1a" },
    { "DECAP.WAD",          "c7f093ef5dcbf53dc7455834200a35b8" },
    { "DECEIT.WAD",         "5211501e4e39e39438e7bc1bc4eb98ee" },
    { "DEDMATZ.WAD",        "cb09e460ee29bb55fa0311ea741567fe" },
    { "DEEPCORE.WAD",       "d005a43cbe1825e422384d10427ce2ef" },
    { "DEEPFRY.WAD",        "28fd4c41ef0c3dcfe9deeb95720eaa7f" },
    { "DEEPPAIN.WAD",       "2cb3316ad51fb78ac6291de27b6484a7" },
    { "DEEPPIT.WAD",        "91c0990e3592105ba16acb1ff0bf9833" },
    { "DEER.WAD",           "6a01c616f63bb02701f7aed13af9e07f" },
    { "DEESPACE.WAD",       "4c48d285a7515c9115fb6967c57a04c6" },
    { "DEFCON13.WAD",       "9c3b343793148dc10b643fb24305ef13" },
    { "DEFEND.WAD",         "3c867e2a2b904da42baf64e78fb07b13" },
    { "DEFMAT.WAD",         "804701c1f715b4d67e1d5c7c8b9f84b9" },
    { "DEFRACT.WAD",        "4a19cf1f4278446b9157fcd4d9a4b2b9" },
    { "DEFRAG.WAD",         "2e49aa13ab5c1af8dd11e3d82bfbec50" },
    { "DEGREE.WAD",         "7c244620b4dd68061750c312aa5d1000" },
    { "DEIMOS.WAD",         "f38c59fce7a3db70a7ab3a36df46b5b8" },
    { "DELCRET.WAD",        "48e4978d9b3e074394aa6d89cc3b252c" },
    { "DELETED.WAD",        "b24ecaf1ace50ac0965b3ab55932a86f" },
    { "DELETED2.WAD",       "c05bbb052375a374cdcce8d7c15c4783" },
    { "DELIRE1.WAD",        "90a1a62c9a7e3191b9d893ba2f93b969" },
    { "DELIRE2.WAD",        "99d4f762cf29a2b2a540dd079306c822" },
    { "DELIRE3.WAD",        "d61632696b3c98893cc2d2b9e9bbdd90" },
    { "DELIVER.WAD",        "95f9566ae232a963ae86a339489d0274" },
    { "DELTA1.WAD",         "018ca3c95646d32d79366a2c9280c0d8" },
    { "DEM.WAD",            "206fc2bcd027859ea0b878e5a893eb34" },
    { "DEMEURE.WAD",        "b9e8ebc4c50239524a687a5994356c32" },
    { "DEMILESS.WAD",       "183007632fc321b3b18867eb447bfe58" },
    { "DEMISE.WAD",         "be188acff7b57c9ee64f62e8fd5fb178" },
    { "DEMOLISH.WAD",       "2181b7234aae2fde5de3751c501bfcff" },
    { "DEMOLSH2.WAD",       "8065f376439bfb34afbbb04a44fcf45f" },
    { "DEMON.WAD",          "fd7dc2563aeac711190e8a385ce2d1b9" },
    { "DEMON7.WAD",         "2763511c4bd65ed84b6d3522960b72bb" },
    { "DEMONALY.WAD",       "b5a38590396bb81ba0ed2e89ab255e9b" },
    { "DEMONDRV.WAD",       "61b718c69e6436a60c3f0ec38a89cceb" },
    { "DEMONHQ.WAD",        "fa0484adf819c1690e02ce38852e1eb4" },
    { "DEMONHQF.WAD",       "e33c177a3cc4a930f44ce6d9547f6a3f" },
    { "DEMONIAC.WAD",       "41eec9747167c4996f08166dd8e3d66d" },
    { "DEMONIPA.WAD",       "8cbfd7ef2f8941c9b6d19621f908fea7" },
    { "DEMONPLG.WAD",       "472700f1b922e6822cdb0f55b9c0d78b" },
    { "DEMOS.WAD",          "b5a36abfefcfd62ab48b376bdfb169f5" },
    { "DEN.WAD",            "f67406eca3feddd6d069646c24a43e16" },
    { "DENIAL.WAD",         "668c3492d7d306b6eae7cb00db5a48dd" },
    { "DENSITY.WAD",        "46f9791d51987ae42ad50b4bafc2f5f4" },
    { "DENTIL.WAD",         "e3c5f150533ca7ce192d777dd6a84d05" },
    { "DEPTHLAB.WAD",       "9434c561d092b3c2e64131bcd2d1ef12" },
    { "DEPTHS.WAD",         "318414ffc6e12a4f4943c3b140b7cdaf" },
    { "DERANGED.WAD",       "accdb8a85a70d34b0f3496e45d8c66b8" },
    { "DERELICT.WAD",       "fd0e4eae3ba3a6c2a7f7403b2176a410" },
    { "DESC345.WAD",        "ca7d6753e89ae1a76b4f753d88b97fff" },
    { "DESCENT1.WAD",       "1f0ccbdf564722253193385af82fa4b6" },
    { "DESCENT2.WAD",       "8e4b60fd426bf0e13e0a029a3ff6e32a" },
    { "DESERT.WAD",         "e1588f765910714f875c272dfd4ba126" },
    { "DESERT.WAD",         "f9d95b481125ebcf8ad8f77c27271a95" },
    { "DESIMATE.WAD",       "7f0e834b17ce5918b34a6915d8783aa7" },
    { "DESIWAD2.WAD",       "77f7bda1fd0c7340f26756386842ccd3" },
    { "DESPAIR.WAD",        "dca6514eaf86007ee1e1971a9947bbf2" },
    { "DESTINY.WAD",        "1d9c578d475c411909285e962ef9474f" },
    { "DESTROY2.WAD",       "6af6243ef03d8b3a9c874c8610dabc60" },
    { "DESTROYR.WAD",       "3f4fd976a4c58bc8e8c1e2b517bd7a2c" },
    { "DESTRUCT.WAD",       "591a2f0145ade4e1279282beacfa2764" },
    { "DESTRUCT.WAD",       "c241a3991f7ba620f84fbd26d5ae945f" },
    { "DETCSLG1.WAD",       "ba081699a9d9a0318d8f48866466f83a" },
    { "DETH-INC.WAD",       "cb01cf09e101674614340c9bcf135a92" },
    { "DETH2U.WAD",         "7c334d9e85e43589a1c6ee86e3caca52" },
    { "DETH2YOU.WAD",       "e299aa738298769239a38e43064a0971" },
    { "DETH4U3.WAD",        "75f04ace5343737c10acb3c58797ab84" },
    { "DETHBASE.WAD",       "eac3ff0d85c0674a8af91394a3b623c4" },
    { "DETHCAST.WAD",       "180ff1abbbbe75b1a7ea00e9fb895d07" },
    { "DETHCH2.WAD",        "3f04b84dd0f040aca985dfb43fce8be2" },
    { "DETHCITY.WAD",       "8db3b330077838ef5eb11f721186a42a" },
    { "DETHDOR2.WAD",       "6f34063a7e65b6b97304b1b963b9edab" },
    { "DETHDUEL.WAD",       "feb418525d74f5d3f4511c3542555279" },
    { "DETHFEST.WAD",       "01babfeb93d31054368b2e40b030ba51" },
    { "DETHFLWR.WAD",       "4c83016846961a0f0a77caa6083aea09" },
    { "DETHLAND.WAD",       "083fd0b3a0d48f73f7a4d93fd9d1ebdb" },
    { "DETHPIT2.WAD",       "687758dd0a36f8e66ae279465365e753" },
    { "DETHPLZA.WAD",       "4e40a2a3a4bc7c27934a84c5f532e1ca" },
    { "DETHPOOL.WAD",       "6b98b60dd0b538aa5763de5e805a9f00" },
    { "DETHPOST.WAD",       "954f48552c5df53f96cd15e4e3e6ec56" },
    { "DETHRACE.WAD",       "847f0340ef7f321af0189bb3092ae420" },
    { "DETHRAID.WAD",       "e19956525cccf3c820bf17614b739706" },
    { "DETHRING.WAD",       "d668ed411cdea6f243402b24449179e0" },
    { "DETHROOM.WAD",       "5d4429f93f48616425cc1263b32fa5ae" },
    { "DETHSTAY.WAD",       "54e85e1526b5fdc1fe5605bf18b46b06" },
    { "DETHSTNY.WAD",       "023ae8ad0ec652294b15b0f9906ed1bb" },
    { "DETHTWER.WAD",       "1feb61b458fc8ec33ec71f74637888df" },
    { "DETHWISH.WAD",       "fec35237ec965ad8f15476d9e73ef4d8" },
    { "DETHWRLD.WAD",       "b926c21c197be56bb5bd567c1d0d9c00" },
    { "DETOURS.WAD",        "c8b8a7ab19a2041b471217662e44e51c" },
    { "DEV.WAD",            "a1a31089bc37ad1e52069f024457cef3" },
    { "DEVILISH.WAD",       "725c4b28ef73348c63f68ade798be438" },
    { "DEVILMC2.WAD",       "6d91f6b17d0b47599f29a8644b027e27" },
    { "DEVINC2.WAD",        "de5d73808c530dc3966e774691d853b7" },
    { "DEVOURDM.WAD",       "ff2ba268eb27b1f5a58cc9edbc7b586d" },
    { "DFORTRES.WAD",       "cb81c0d302bb40276dafe083a4258962" },
    { "DFT.WAD",            "2dda245da18db91e4e9e5634553bbd49" },
    { "DG-CORE.WAD",        "55efb7ff65f1584bed1d934f52068784" },
    { "DG.WAD",             "b970f1d23fe82f43a565585aa36877e3" },
    { "DGDM2.WAD",          "070cfdc4bc24e65e34d7a105c4ca8353" },
    { "DGDM3.WAD",          "98010b961796b8def7cf9b7467b7a968" },
    { "DGTC.WAD",           "2766099d570ff89507d4ad5a50b11a7d" },
    { "DHC11CO.WAD",        "8b887b34bebbe092077a2585e4fbfdcf" },
    { "DHOUSE.WAD",         "7c501faefa07c7d38180a7a6f6d6b183" },
    { "DIABLO.WAD",         "84265e491149eb47a55518a7268abb43" },
    { "DIABOLOS.WAD",       "d366129fce25a836bc30e07f939d27f8" },
    { "DIAMOND1.WAD",       "80a9aa472063cd8091047253e089fc75" },
    { "DIAMONDS.WAD",       "65e27008b0250528bc85bfe096481510" },
    { "DIAPER.WAD",         "c8ebaaaf4b7697b5091324e4bfdd5d90" },
    { "DIAPER2.WAD",        "806d50aa0c663700757850b05a9312d2" },
    { "DIARR.WAD",          "fa3d6f723c091ebfb106673e52511813" },
    { "DICEDIMN.WAD",       "e6557a2c2d180b35abc2f3c8da238c26" },
    { "DICKIE01.WAD",       "ef065f0e93fa4bf5d1daa1196040362d" },
    { "DICKIE02.WAD",       "ea6bce70a2e3d289846a07bc04ec2ba9" },
    { "DICKIE03.WAD",       "f9fcd3312620f4bb30e91f4f580740e6" },
    { "DICKIE04.WAD",       "75dae68e5f14c91f709562462f5ffd9e" },
    { "DICKIE05.WAD",       "06bb81c1a7e4f7d5b794adca97613f2d" },
    { "DICKIE06.WAD",       "4aab28d708efe5fb15ca5b774a617d63" },
    { "DICKIE07.WAD",       "be707bf1a8f76192f68945234fd30c95" },
    { "DICKIE08.WAD",       "0f6cb3719a795f493166c9e0ff2f6639" },
    { "DICKIE09.WAD",       "dd2c1eae4cd9194c78a0801b98cbcf19" },
    { "DICKIE10.WAD",       "b623aeff244a098b8d2bc662f3db2870" },
    { "DICKWAD2.WAD",       "def5757ce39e8af52219eb9b4ecfa24f" },
    { "DICKWAD3.WAD",       "e7989fbd7c8a4f393d2b5ae0c488f6a2" },
    { "DIE.WAD",            "b0c53d97589c81ee888a8c3b6a0022f2" },
    { "DIE1.WAD",           "d9c61a7f1317c524432e62347d05c06b" },
    { "DIE1RV.WAD",         "ead63484c11fd8c19a05977e56d9faab" },
    { "DIEBREA.WAD",        "b04e5a8c5deb9d98f76da57540e2ea65" },
    { "DIEHARD.WAD",        "8af7d913eda866aa8485b713c6dc0c96" },
    { "DIEHARD2.WAD",       "152776e97e6949be364637fbf6deb0c3" },
    { "DIETH.WAD",          "d74730944bea5d8b5f5a68a2b039418c" },
    { "DIETIME.WAD",        "f795b944949eeb1d5bf9397fb3913436" },
    { "DIE_TRAV.WAD",       "d03e3a317f89d6ef0d3e4b0343270731" },
    { "DIG.WAD",            "dfae409f21428535238efead2529f42c" },
    { "DIGENCT.WAD",        "9ac5aaaeb17365fc59b9b9ef0e74af59" },
    { "DILIGENT.WAD",       "10b71253c6948a5c64a75e2c884e105e" },
    { "DIS2000.WAD",        "f33195d76ccbbc1b88aeadfd87452d98" },
    { "DISCO.WAD",          "31ab6ed21649fcadb86b38ead1b8bd0b" },
    { "DISIDENT.WAD",       "15ba76cf83b0116b043eeb2a5640d4ec" },
    { "DISPOSE.WAD",        "24ef2f63781a2d0c8e5fdb82bc68e3a9" },
    { "DISRAELI.WAD",       "a81a249fb30e3325195473bb6912aa01" },
    { "DISTRIB.WAD",        "d0b2b33ec891be8a0d18f4366f9f9653" },
    { "DITCH.WAD",          "442aa4f7eb47d6f54058030c89c63a40" },
    { "DIUJDI.WAD",         "ae251b155bcbcc0c337c001919c52d65" },
    { "DIVOTS4B.WAD",       "b4e188cd0099885bafb085ddeeec3e9e" },
    { "DJARENA.WAD",        "fd6f5e205688bc424601dfd166f73c55" },
    { "DKSHRINE.WAD",       "6851a08fb39525ad61e1ed45a534918c" },
    { "DLEH.WAD",           "710e30c06f2c7dccdfee8cf4f38b7578" },
    { "DLFRAG.WAD",         "23ad9042092903abf15af9c6593ce93b" },
    { "DLFRESH.WAD",        "b6cdaaeda19b521bd613a43b6925cc81" },
    { "DLUXHOUS.WAD",       "59e4888e9d44fc66420529ed76cf0225" },
    { "DM-MORPH.WAD",       "8a3abf48884b35b5a73758e22d9e6dd4" },
    { "DM1B.WAD",           "804ca439e1f792c7bb38a894e22ceb34" },
    { "DM2.WAD",            "ea270e3c3a773d14b0f96d6c9977270d" },
    { "DM2COLL.WAD",        "d24e5fdf275b9aace06eb9c61555a90f" },
    { "DM2DEATH.WAD",       "20243f94d3b000a193f13aaa93063518" },
    { "DM2DTH1.WAD",        "153580d9ce2e4f8492a6623d9c118e55" },
    { "DM2DTH2.WAD",        "30796f402247fb22d3077bb2ac627a11" },
    { "DM2DTH3.WAD",        "131de02ad7804fdeed13ac4b97c2c302" },
    { "DM2GH2.WAD",         "cb0f9e00683c68c30b63bc56b10e701b" },
    { "DM2GM1.WAD",         "1d62c731429658407c7934b12b83f538" },
    { "DM2GM2.WAD",         "6d21cc34774a835fa6936f0897ef90dc" },
    { "DM2GM3A.WAD",        "a8206980a7c8d85a5a086f51c1d3dbe8" },
    { "DM2GUEST.WAD",       "98c28eb858455177d3f88e692ae0115f" },
    { "DM2HOUR.WAD",        "0c0621ea882f2bd1beb132a7befa7210" },
    { "DM2INFIN.WAD",       "980ebab30b77c79c8ab45e659f07c2b1" },
    { "DM2KEVED.WAD",       "228168a3604ed940f4b261da7ec72e80" },
    { "DM2LIGHT.WAD",       "d824bf2754e559f6d6c448c8f799c91a" },
    { "DM2MUD.WAD",         "967478b08ec9e6139942e743fb85dfce" },
    { "DM2PAIRS.WAD",       "55fc3ce6349cfe7153d9e76c436f7c5a" },
    { "DM2PRI3.WAD",        "f599172616bcf86c751f8070c28f9c1c" },
    { "DM2PURGE.WAD",       "4b2c9713a2348992b218ab5ff9a7763f" },
    { "DM2REAN.WAD",        "55c45ed0e4c465b967bce4bf3443996b" },
    { "DM2ROOM.WAD",        "c930360c19a8c719bf31345d4949bf09" },
    { "DM2SPI.WAD",         "a2a14f1049f3a996018dffc5c8faf62d" },
    { "DM2STEIN.WAD",       "46057962fc3d16a5148e20af4ae067f3" },
    { "DM2TIGER.WAD",       "cd1ba9a8a26cb383b6c344cdc44015f9" },
    { "DM2VOL1.WAD",        "a966921d2b9f34b7a896fbb102328b5b" },
    { "DM2WAR.WAD",         "c4bfecd7c29897d80cc7079afe4e31b2" },
    { "DM2_DROP.WAD",       "40729f724d8886180eed16758755d382" },
    { "DM3.WAD",            "0b46d232ae956d52d35c0edc71e9ff17" },
    { "DM4ISH.WAD",         "f154bf327542e28bb1056e36b5bc9365" },
    { "DM6.WAD",            "5c44daa11c15581b693b371e7e40daef" },
    { "DM96.WAD",           "8a12e25e93abb00d0b3893d4a3fe87db" },
    { "DMACH.WAD",          "54eeb97fbae6003c2cafa99cd9ba78c5" },
    { "DMAFTER.WAD",        "6f5bf7e943f20308c2898d88d4f4ee2a" },
    { "DMANFACT.WAD",       "4afd6ec950abcc9270abb41f143e6023" },
    { "DMAP.WAD",           "b47bc07d77f49ef3759116908a4371ee" },
    { "DMARATHN.WAD",       "9c007ea8ad0a3777193551e43ead07ca" },
    { "DMARENA4.WAD",       "d03e38856d608ab0909cb11649f06ff4" },
    { "DMAT4_2.WAD",        "c9866ce6d4b94b2471b14b025dcee62e" },
    { "DMATCH.WAD",         "7a4625d0d17b2c153e10555662551f02" },
    { "DMATCH.WAD",         "e1bacf9e0a2b3ded9ce2dcd7f2fab6d2" },
    { "DMATCH02.WAD",       "42773216cf8c522686bef65cb522208a" },
    { "DMATCHES.WAD",       "7dade365db2940cad199f9c83bd56611" },
    { "DMBLD.WAD",          "8c8fbf8e9f76d6d8a744d09ecc84b426" },
    { "DMBRIDGE.WAD",       "137c59995c0e19d6d74431648a09cd21" },
    { "DMBYMIKE.WAD",       "9275232134df78d7113e63f03d887c06" },
    { "DMC2.WAD",           "1bed3f26d25e14b8bad75af2e1a6bf8c" },
    { "DMCASTLE.WAD",       "a2419b25ed69b531535c875dc8233163" },
    { "DMCITY.WAD",         "b75d7cb5532f8d27e235cc6bc5d838e2" },
    { "DMCOUNTY.WAD",       "434d1345b949e8ec7c13340196510695" },
    { "DMCY2.WAD",          "830d03d7fd3f3ca1831186499b30b820" },
    { "DMC_DM.WAD",         "986a9d5f140302d89bf9139b1f353eb0" },
    { "DMC_DM2P.WAD",       "232f5152b9371cd18e520203b87188b3" },
    { "DMD07DM.WAD",        "ae684abe4387763271c24c69acc41456" },
    { "DMDAYONE.WAD",       "7f5f786847830384bda773d90b13a5de" },
    { "DMDLAMDM.WAD",       "bd5e44e0fccd634ec37bac24e55f5ac8" },
    { "DMDSAC01.WAD",       "1111dc8727870696bce0a471dae95384" },
    { "DMDSAC02.WAD",       "007154166e6866f3b92c0b2c2094e2ea" },
    { "DMDSAC03.WAD",       "afaadff341f173cb4e34152ca6439977" },
    { "DMDSAC04.WAD",       "dfbf0be8128d453332bddea721a5a6c0" },
    { "DMDSAC05.WAD",       "649cc7bf7e404ee6f7d29004257adef3" },
    { "DMDSAC06.WAD",       "05eeb103cabcc0114da56bee3b2e9180" },
    { "DMDSACDM.WAD",       "4b854d9ad96e6e356bb1a80d722e16e3" },
    { "DMFIELD.WAD",        "51f34fa2e65855223db78e0def2bee2f" },
    { "DMFOREST.WAD",       "cd9decd1e1f141c37eaef82cf64c3469" },
    { "DMHMORT.WAD",        "fdc5633e724c233e645014ac53970308" },
    { "DMHOFTD.WAD",        "227b26f8afc247e8597cf329cfd7e6f6" },
    { "DMHOUSE2.WAD",       "17b06b1afd8a721b77640e09a193b548" },
    { "DMHSEWER.WAD",       "c6a0bb90915061bb1475ad6a433ee2e9" },
    { "DMHSIEGE.WAD",       "ee738de6a7d182285e82af74f03dae26" },
    { "DMINCAR2.WAD",       "65f97b27751eb858e4faf6151007d8b9" },
    { "DMINCAR7.WAD",       "08f985057b264bef271f7174400d90bb" },
    { "DMK.WAD",            "b9e932dafc96db26a979728c59621d72" },
    { "DMK_DM1.WAD",        "1d2ebd1428a8ea4ad32b234736d5569f" },
    { "DMLAMOU1.WAD",       "bcd789d6124c4a957de6f45d527a94e2" },
    { "DMLAMOU2.WAD",       "32900ff3b7fa522cf330fe3e993b8365" },
    { "DMONFEAR.WAD",       "2e3adb2560edb03147d39f3293412a32" },
    { "DMSEEK.WAD",         "8d9399caa4fc098b25b2a762e5557a22" },
    { "DMSFX.WAD",          "41969dbaeebe3dcf6ca52651949a36bb" },
    { "DMSPORT2.WAD",       "373291f1f1871f7286bfb6dab60a269e" },
    { "DMSRV1.WAD",         "84b70a0bc9b52f02ddc7771a68786a2c" },
    { "DMSTAR.WAD",         "61fb86cdc6ec2b2d3bbbfd5f8f879d6a" },
    { "DMSTREET.WAD",       "450ecda242216ff494abc0782a050005" },
    { "DMT2X.WAD",          "dee0dc23a4db7f3d7142033f54ee0876" },
    { "DMT3_R.WAD",         "2bcd08d8ac38b917349e4cd1f86c6303" },
    { "DMTRIAL1.WAD",       "0bac01ea1cc140dcd2fa189dd9dc6c0f" },
    { "DMTRIX1.WAD",        "70a8283abc39f974365d28285d4451bc" },
    { "DMTRIX2.WAD",        "b75261a2c8d50ffba3bee0bdab3bbad8" },
    { "DMTRIX4.WAD",        "f61ea3082715e39fb578d0cdaa2bb9dd" },
    { "DMUMU71.WAD",        "e871d14fcfa33f36229b6d8b95b636fd" },
    { "DMWAD.WAD",          "afbff52b1a92e413a58aa8c4a6ed3c8b" },
    { "DMWORLD.WAD",        "d49d2d61abc3b084fc4dcf5aa93abdb7" },
    { "DM_ARENA.WAD",       "415fd48d891b93441dab61dca94ede62" },
    { "DM_DN01.WAD",        "d6382ebbfb9c9ea47024598f0927cd5e" },
    { "DM_DN02.WAD",        "e32beb21919184ac113fc94fe4d9f99d" },
    { "DM_DN03.WAD",        "210931cb58dcd3f987b1dc866a4d4b5d" },
    { "DM_DN04.WAD",        "18cb0212355eaabba1aaecf6fbdd9a6a" },
    { "DM_FAVA.WAD",        "f2beba6c3541414d40f401159ee46ed4" },
    { "DM_HALLS.WAD",       "05386cd28af1c68d92ab4e4ff665b1f8" },
    { "DM_KHAN1.WAD",       "23a77486c622b16182d2d99cc95dad2e" },
    { "DM_KHAN2.WAD",       "a605257f22e658dc2a5f10f0f44595ee" },
    { "DM_RU_1.WAD",        "886009b8dfdc287f0f18efaeddf18b0e" },
    { "DM_UDIE2.WAD",       "0eb5b4ead52a48826c9dd76595d3db29" },
    { "DM_UDIE3.WAD",       "8a5a1df93e3620dce397687797b65c33" },
    { "DM_VILLE.WAD",       "ebc4251f2f86afada072bcb98d880346" },
    { "DM_WAD.WAD",         "58c30bca51cdf24c209cce304c2b40de" },
    { "DM_ZIGS.WAD",        "ae7c683c3573e611fd82a2829a077487" },
    { "DNA_GRA.WAD",        "a25640801b4ffa461b22cac91e2d8346" },
    { "DNA_TECH.WAD",       "86f27192cf1bdd4ee841d1885139cd24" },
    { "DO2.WAD",            "43efb6fb79734db0f49d860e6023e09e" },
    { "DOABETA.WAD",        "df4ef3d50b1c9e31dbdb0cacd3403d02" },
    { "DOAGFX.WAD",         "342287406797cc85a83fb8b63521ba86" },
    { "DOATEX.WAD",         "89fbb2e31119fe24f3725ac7ff33a989" },
    { "DOBATTLE.WAD",       "770c9a6db986dc3afe4a996d20f6baa3" },
    { "DOCK1.WAD",          "30b5d21ed7cde6c4f270fb3a0fe2c8fa" },
    { "DOCK69.WAD",         "9092a5a8b5e835f6e7901b2ea16c7d4d" },
    { "DOCKS.WAD",          "049ebaaee21090b07025e8fbdb1f5db5" },
    { "DOH.WAD",            "de275e17142ed859c1ba5fa5e6e9b6d1" },
    { "DOJODM1.WAD",        "8cc3d05edeeff9f89edff7fef32be526" },
    { "DOMSTONE.WAD",       "7251803e0f1853e3585ec6fa13b6f606" },
    { "DOMUS.WAD",          "1bea113099f052e610f6233af1a0b0a2" },
    { "DOMWORKS.WAD",       "4c4100f2c5fb1921eef26f5d50781dc1" },
    { "DON01.WAD",          "e8738acec1c662e43ae615e4a5f43fbf" },
    { "DONTSTOP.WAD",       "602e03e2fb0930eac73edc9838684c5a" },
    { "DOOM-PIT.WAD",       "c2400a61f20ba6ebd7d9b106d8b2804a" },
    { "DOOM1-2.WAD",        "bb0f7edfb5b8c53467f4b7c6d9a810bb" },
    { "DOOM2099.WAD",       "1e5e61fdaa2ae35e4c242a6f1a892b34" },
    { "DOOM2DM1.WAD",       "b30f60d2b9fb8a28271e7d59dfa6a84c" },
    { "DOOM2DM2.WAD",       "9be532f80473fcb4ab107c1116b33236" },
    { "DOOM32.WAD",         "ffaf7fe48ae035664c10611b81c8bb6d" },
    { "DOOM333.WAD",        "ba516740d9838332bf482aa4363b5db1" },
    { "DOOM3D.WAD",         "308aa598fc84e22f0c15e90bcd9d9dbf" },
    { "DOOM3M.WAD",         "7824d6da98ba534c0a0750163303306a" },
    { "DOOM3V1B.WAD",       "de51c0bf49aea15ae3209ed97d55ef22" },
    { "DOOM666.WAD",        "d30982c1975a82859222e4fbe06296c8" },
    { "DOOM7734.WAD",       "4b6aa9aca94ebe86863277b219c23ec4" },
    { "DOOM97.WAD",         "d5a5cf74c3cc3e8cc46e3c44b3707e2a" },
    { "DOOMAGON.WAD",       "38f61f262ea9b7a215af3190c4ca3adc" },
    { "DOOMAM.WAD",         "416354ba603c7a97ba4d362f3a482960" },
    { "DOOMAREN.WAD",       "ea3c79abdfbc2ff4b0b71a897da13cf3" },
    { "DOOMBAL2.WAD",       "7f6ca259005dbe072bc1367a6147e30e" },
    { "DOOMBALL.WAD",       "06ae96a6fe6feac07c336f85aa5a3c8c" },
    { "DOOMCITY.WAD",       "5183ea099756045a9001b67ffb37d954" },
    { "DOOMDDM2.WAD",       "f6cb703bfb4d3e37c0f08e57ea150471" },
    { "DOOMDUKE.WAD",       "ffe571ccd767e3580c4ff66fcc679912" },
    { "DOOMER.WAD",         "8bdcb021b9f6e26bc5bf024ff73879d1" },
    { "DOOMER1.WAD",        "c8204277bc9b3c76854659d09ba203de" },
    { "DOOMICE.WAD",        "02a051fb6e480f1e317bc6323f4e5466" },
    { "DOOMIV.WAD",         "f5e306e8b83d6269228c8660e01a8e98" },
    { "DOOMJR.WAD",         "31872d09b4c0dced1b615232922e50e9" },
    { "DOOMNIEL.WAD",       "5f1383a7fe2735462f79a6a3c3559923" },
    { "DOOMNUKE.WAD",       "9a8ce6de31f30ccdc3fa9ef9378bf763" },
    { "DOOMPIT.WAD",        "11ebd105789f22be9da4ac5d39945d3b" },
    { "DOOMPRO.WAD",        "43a8d5da8143896a600aa4a3b858bd56" },
    { "DOOMSDAY.WAD",       "b7326c7ade1ba13d497478fa12d8b9b5" },
    { "DOOMSTAR.WAD",       "acccf0581f5e5db60b8b3f4dd82df26b" },
    { "DOOMY.WAD",          "a91d3a0a6f6ebf0e9c1b110d3547eb81" },
    { "DOORLITE.WAD",       "b12f3349b524b96bd4ba028ed2fa78c3" },
    { "DOORS.WAD",          "58af2db67d7c203c5bc583de804b965e" },
    { "DORA.WAD",           "da4f08bdcba4b728590f37efdeeec7af" },
    { "DORUNRUN.WAD",       "cab4f0b8b54fb9c1183ea8f53edbb12b" },
    { "DOT.WAD",            "95abe80f9fecd88c080350f64112821a" },
    { "DOTHEJOB.WAD",       "624346ec86d97016ab6ce7fa1e8f360a" },
    { "DOTVOID.WAD",        "f7b49b74597ba7ead53ea1626088d005" },
    { "DOWN IN THE PARK.WAD",   "a1b69002e01460adee014b5d1951a2b5" },
    { "DOWNTOWN.WAD",       "db733df70c83621063e48ff3cf757240" },
    { "DOY1.WAD",           "c32d346c51a073db8fffa1db5a2da250" },
    { "DOY2.WAD",           "2d1426ac4f6cab0fbeb637a3e1f2bffe" },
    { "DOY3.WAD",           "de7a6fef996d4be45fe4703823c3945d" },
    { "DOY4.WAD",           "f714de1e2becc6f504d205e90a2ce6a3" },
    { "DOZOD_D2.WAD",       "868ee9033b8e97366984d9bdc95fad5b" },
    { "DPRISON2.WAD",       "14d285c5ee3ec88f1cf51bc8d31fc682" },
    { "DRAG001.WAD",        "e19045f06a3203c94e96b12f23e14b28" },
    { "DRAGON.WAD",         "f89f58c8880ed43665e7a4bbbe7842df" },
    { "DRAGOON.WAD",        "f83a85f6e5732ced8e3f1d3001055dcc" },
    { "DRAIN.WAD",          "f17b4db7a89ede954a999e05c52cb349" },
    { "DRD2MAT1.WAD",       "26e0c0e94765fd9d054cc999cfd12fa3" },
    { "DRD2MAT2.WAD",       "3ef05667e8c1d1769b04f7e9c0b71274" },
    { "DRD2MAT3.WAD",       "ee781b61bed6affcfc49430537425cfa" },
    { "DRD2MAT5.WAD",       "04d31e4aca1a679be287c0f915121b0b" },
    { "DRDAD-LL.WAD",       "2e5bd74edebc46fd27230f8d5b3fbc0a" },
    { "DRDAD.WAD",          "a9f5b66f9fda6549526ccf6de080303b" },
    { "DRDCORTY.WAD",       "a619540ec6c885af5aacd05da7471953" },
    { "DRDETH.WAD",         "017eba6ca72ab710735f2f996baa3655" },
    { "DRDFORT.WAD",        "faa6c3986f837843af7c7bf3abfe2a75" },
    { "DRDSUDTH.WAD",       "8629d5f7d4aaaf43c0526d2974e8e781" },
    { "DRDTEMPL.WAD",       "67533724e393e57aecdc8ccd43727a35" },
    { "DRDWATER.WAD",       "5216264f03b80efc6a3851e156fafae7" },
    { "DREAM.WAD",          "bfef68f3494a48cca7b0f6d46bd22fad" },
    { "DREAMS.WAD",         "ce544c88e0c9b439199ebf7284a7b6c9" },
    { "DREAMSOI.WAD",       "64a3dd75eb3bda1e47e9ae7d49f72135" },
    { "DREMHOUS.WAD",       "26822f3089d838eae4ac10bdfc278389" },
    { "DREUGLAD.WAD",       "3fc785f900d5203312a6a8cd4655e952" },
    { "DRGM1.WAD",          "f4787d325e214376b3755f1dc1407f87" },
    { "DRILLR01.WAD",       "2d00ae6239664a2ccd94b8de8e3fcac3" },
    { "DRILLR02.WAD",       "3d8b764cad6b9e327f6e7a71b93e48a5" },
    { "DRILLR03.WAD",       "6ce44bb4160045ed7ff59da9e953420e" },
    { "DRILLTWR.WAD",       "89878f16325dc82ac09d4fc54acd47c9" },
    { "DRILL_U.WAD",        "1119e39afaf0f8bc7d2d5dd0e6131c4f" },
    { "DRKANGL.WAD",        "514ede5c897bd56f8a26af643fa76cce" },
    { "DRKHOUR1.WAD",       "b0c3c2cadce85ea3e471d54961674a24" },
    { "DRKSUL.WAD",         "4e654f5571f8e101d71b90d01568f348" },
    { "DROPOFF.WAD",        "6b818cfe6bef5090f6a84c3bea350190" },
    { "DRTYSCAR.WAD",       "190b67af2acc3497235d74bd4f795e1f" },
    { "DRUNK.WAD",          "d2a6c6a837a5364dff90bcdaad669766" },
    { "DR_DEATH.WAD",       "26743f7e25cac998d05e589a1a55a36d" },
    { "DSA-STAR.WAD",       "966d855b5731f5d353fc0d7d9492e685" },
    { "DSCIENCE.WAD",       "75b420ffc95e404545061d80ac220e3d" },
    { "DSCPLINE.WAD",       "72ca4dc14dd5d8e8df1b81621b9b4af7" },
    { "DSCREATE.WAD",       "2b9ac92ef204d662fa139b19a3eaa915" },
    { "DSKRT.WAD",          "ef5c4e7e6f06353bb25f0524ceaa379e" },
    { "DSLVL1.WAD",         "4f13609a9947f688a8abd8378abd67a9" },
    { "DSQUID.WAD",         "c6fbd66f368a4d235ded019ee66ee5f4" },
    { "DSTRAITS.WAD",       "8a92ac5f6dc7bee4f5d12ad82c71c6ed" },
    { "DTBOCHIT.WAD",       "c98b2856afc3a0ba43497b745fc1069a" },
    { "DTCA_LOBBY_OLD.WAD", "60b6a7b65fa94d7edec2917401d38aca" },
    { "DTHCYBER.WAD",       "e6b01234378fe89dfc0746b50d6c7ceb" },
    { "DTHMAX2.WAD",        "062729090dd44295406dabee9394d386" },
    { "DTHQUAD3.WAD",       "2afa54d342c2293533acd82ca25b2b68" },
    { "DTHSPN.WAD",         "d3d65059c7f98c345b901eb4c349d8ac" },
    { "DTHTOWRD.WAD",       "fc233ede890fd98f7037d16159f342ea" },
    { "DTHVILLA.WAD",       "dff4913da0e79e723f4ba8a7c540b1ec" },
    { "DTS-TDEM.WAD",       "94a91051e728891827a84061b1c8cb39" },
    { "DUDE-II.WAD",        "4fbdf186d167783622b6665cc288e7fd" },
    { "DUDE0.WAD",          "3aebcd3b9e92e7db43c4975d25cfa2fe" },
    { "DUDMATCH.WAD",       "acaec9b21f7588c2b008ba53e1ea3cf3" },
    { "DUEL.WAD",           "f5e635307931b70a84a7d701511f5056" },
    { "DUELKEEP.WAD",       "3aa52c2074be0b2f44543ff1496d2851" },
    { "DUKE2.WAD",          "5c84efb082c3517b48f67d75a580bbf2" },
    { "DUMB.WAD",           "b73350404cfe5559cffb204ddcb57ecb" },
    { "DUNG.WAD",           "c1cc92c63bf663c0f2f02c5b659af29a" },
    { "DUNGEON.WAD",        "42ce5a9233be33daad58a92bdc19d5b8" },
    { "DUNGEON.WAD",        "49837225d6e5565924f78e35ef96a81b" },
    { "DUNGEONS.WAD",       "e98cb69f855d5ba0c6a62b6070f5ad13" },
    { "DUNGEONX.WAD",       "68744f82a12be5a2c9e236bfed9818e9" },
    { "DUSK.WAD",           "747d8a77579297ec6c72a3e789e83fd4" },
    { "DUSTHOLE.WAD",       "513ef4779e3d688ba21a5f1cfb88e7ed" },
    { "DU_OR_DI.WAD",       "598144767c35747de9cc733b1b7e181e" },
    { "DVPA.WAD",           "b6bee03a9c4ade7ff37df38d0e4e8088" },
    { "DVSTC.WAD",          "e79bb04bc21ea3c89f6e9bf55bb3b96d" },
    { "DWANGO.WAD",         "cc15b2be668a33d0755a91485669645e" },
    { "DWANGO8.WAD",        "f82487959ca92f466655f956feef01c3" },
    { "DWELLER1.WAD",       "54472ae27ff9d3f020ecff96d59acc0c" },
    { "DWELLER2.WAD",       "ae031835efe0b36c618378a18d7ccbc4" },
    { "DWR_DM1.WAD",        "e2f602c11d2c10d81e907d1cd5b81c17" },
    { "DYNAMACE.WAD",       "13478c6f7099dd0693aeb3f2ac05c84c" },
    { "DYST2.WAD",          "c28cae597f4e1ac61154f21e8f09328f" },
    { "DYST301.WAD",        "981374226de8692eb19f329393f4df46" },
    { "DYST3LEV.WAD",       "8f4c3d43931ec518317dff1978ee0b9d" },
    { "DYST3TEX.WAD",       "531754f40e64310a3092887c9899bf04" },
    { "DYSTOPIA.WAD",       "981ea0b7fe78d87113ce62744967ef0f" },
    { "D_M.WAD",            "eef531e71f314372fe7d53c4197c8b22" },
    { "D_MURE.WAD",         "9af62ccbe9df8b24e4d3a1be2a33a14c" },
    { "D_PDATA1.WAD",       "67bcae58e83b555397909a3534f23361" },
    { "D_PDATA2.WAD",       "b03ceb97537e61b7b9c0f3862e9f821f" },
    { "D_PIT.WAD",          "2dde25af36a2da6c823a34ad13df5b80" },
    { "D_TOX.WAD",          "82374eca047ff22e45aa9f52b6642782" },
    { "E-THEATR.WAD",       "a53af48f3d61241979e330b18fb118f0" },
    { "E-ZKILL2.WAD",       "6f9bee19ebefa42fa06cabc3bfd7365b" },
    { "E.WAD",              "f9f45cc3f2f836af242436b1754411e7" },
    { "E1M1CTF.WAD",        "ffe21d8284e9fd09c302b98d71ee84eb" },
    { "E1M1RETRO.WAD",      "927a2d14f9b3aa5254e704e8186b7514" },
    { "E1STYLEF.WAD",       "eca4cebe9677067f472b6e4b7ac901bf" },
    { "E2.WAD",             "97b56861586c1e84d94550a79dbec859" },
    { "E2M1RETRO.WAD",      "7a406a7771dd9cfca784ee84b61ca8d6" },
    { "E3M1RETRO.WAD",      "3aab2c55a292d8917d599f9ed1777a08" },
    { "EAE1M1.WAD",         "887c512fc2c13efaff91cf697b038a7d" },
    { "EAGLE.WAD",          "6bc32eb0460831266e866b4738d31ea1" },
    { "EAN.WAD",            "8a065e7f150252d1ad11314b112da1bc" },
    { "EARTH.WAD",          "37837aa266dcc3c4c25ba1df07ebb55a" },
    { "EARTHB.WAD",         "c7c928f77f219b0663aa2f270b1472c1" },
    { "EARTHCOR.WAD",       "5c595f68dba8090911b4a81ebc995d96" },
    { "EARTHSCM.WAD",       "bb106a1b12ef8a98eaca88791a34bf27" },
    { "EASY14U.WAD",        "111694228b4525b70d2b7e0017ec3ebf" },
    { "EATME.WAD",          "93a949ee17bd612db62dfaa8054df8ea" },
    { "EAXT.WAD",           "2bea7f975c9b4d6717a42253936f531f" },
    { "EBOLA.WAD",          "7738b815f5f692b0cf837278f72d9bde" },
    { "EDDETH1.WAD",        "93623955f0ea9e3cb3c8107774145db3" },
    { "EDDIE.WAD",          "0b6eec39dd9c32e545d1d73fd091c87b" },
    { "EDGE.WAD",           "eafb21fded3595d6fdbef072a4b42130" },
    { "EDG_2.WAD",          "c63dec66a384b1fefe94fc5b029cf6e1" },
    { "EDNA.WAD",           "795cfeb188e4ccbce70a05d190c134da" },
    { "EFD.WAD",            "28e02ff051e28bec67d002c70dd2b7d9" },
    { "EFFIGY.WAD",         "84f6f3f39f52a6075bf07d362544d087" },
    { "EFN.WAD",            "753b4d19cfc08f26c687b4e162cf6a6a" },
    { "EFORL.WAD",          "befe6a8f02b72b1df6edaa4312f25133" },
    { "EFP.WAD",            "3e5a7f729e92939f0574b7ac40848492" },
    { "EFRAGS.WAD",         "ea94c1536405dac6c02ddc642e2601b9" },
    { "EGA.WAD",            "514f128e0a2819d6fd85c08613cf80fd" },
    { "EGYPT.WAD",          "4742d004e9fef0acc75270d3699a602f" },
    { "EGYPTEXT.WAD",       "9e3994e2329b78a0c6919959c89a859f" },
    { "EGYPTSPR.WAD",       "e764d9fc3a54a9f4ea78baea4e678133" },
    { "EIGHT.WAD",          "06c494b8ed8f4ac896ddc06aa60c126b" },
    { "EKPTCH11.WAD",       "c3900d5eb43bec373fc0cb04b88275d0" },
    { "ELEVATOR.WAD",       "e9ca7efbf260707956b99ac50e9cb527" },
    { "ELEVATOR.WAD",       "f700796fbcc4081ebd1ed351c0dc263c" },
    { "ELEVHELL.WAD",       "fcc892cc96f0432696a8bbed93573090" },
    { "EMBASSY1.WAD",       "d4619ec120e0351d51a18a33ae8c995d" },
    { "EMBRACE.WAD",        "50e2f3dcd292e1c88150fae6f8e3ea4f" },
    { "EMPEROR.WAD",        "15a58a0271a878ac4e2338b238d42b0d" },
    { "EMPEROR1.WAD",       "223371633d40c8917b48e0e4ff411ab7" },
    { "EMPEROR2.WAD",       "802ff7f28717346acc9e020ae49eab7b" },
    { "EMPEROR3.WAD",       "3102b2bdbfbe8ba98d6266572e092c27" },
    { "EMPEROR4.WAD",       "19adadc7680c3c5a95973486a6e21afe" },
    { "EMPEROR5.WAD",       "2ef4d780ee55e939460cc7286503fa51" },
    { "EMPEROR6.WAD",       "2f390e0f5f2b9442155826ed24b9e4d8" },
    { "EMPYRE.WAD",         "aa5ac18ccac0c9afa0aa7f837b2cebbe" },
    { "ENCOUNT.WAD",        "dcf83949968816d9ffd7ba21d1efc960" },
    { "ENDGAME.WAD",        "43b2ed9482b651e5fb604850c80a99aa" },
    { "ENDOOMED.WAD",       "845958989ad748f8e454675effb6fcb0" },
    { "ENEMY.WAD",          "071fa29779b8e9b42beb20b73745951a" },
    { "ENERGIZE.WAD",       "46aa068c409e0e0b43a2690a1f1f3455" },
    { "ENIGMA.WAD",         "51aee2126b08b0cc6512f024f55a8c6d" },
    { "ENIGMADEMO.WAD",     "bcd72087b4378eb1c51a3d04bcdd0771" },
    { "ENOCHIAN.WAD",       "7a3ee8d56e9f258037183c9215efaad1" },
    { "ENS.WAD",            "181ed4e9fe22b45fcf9166b40a1135cb" },
    { "ENSLAVE1.WAD",       "643b2878c74fd29c682957d92b70e614" },
    { "ENSLAVE2.WAD",       "ea092238878961f9b0ef174b40338f68" },
    { "ENSLAVED.WAD",       "6070487dbf03ccfa6dfd6d2771fb2e78" },
    { "ENTAPRIZ.WAD",       "8f42c53dc83af2ef2be76a79fdc0906e" },
    { "ENTERPRZ.WAD",       "38decc5bef3bd17bbe7910c7751a2548" },
    { "ENTRANCE.WAD",       "12b6aa20eb358c9da74dd70d8bf49d70" },
    { "ENTRAPMENT.WAD",     "8eb5fbb693f99ee83a1c3621c7152f04" },
    { "ENTRNITE.WAD",       "d69d868ac90a31e1c02d6a0ad69253e2" },
    { "ENTRTAIN.WAD",       "a32bde5dc2987db3e317d3611b4e4ccc" },
    { "ENTRY.WAD",          "c6cfb557fb5abef6b25a362103ccf617" },
    { "ENTRYWAY1.2.WAD",    "5fa0f691db3c225c9db966cbc04f7a1c" },
    { "ENZEMICA.WAD",       "548fc8fb49ca0464ff25623efb04b9eb" },
    { "EOB2S.WAD",          "8a7c3465dca4f3092e30e816def09580" },
    { "EP2LEV.WAD",         "6875dd5676785561d77214a3845bebdd" },
    { "EP2SND.WAD",         "5931462703b8047ccff1aaf877078b8a" },
    { "EPAHOLD.WAD",        "1bc162c3290d535d729a1fdb05d84bed" },
    { "EPIC2A.WAD",         "e60cb0a1b2800652a28c54c76bdc6362" },
    { "EPICENTER.WAD",      "93e19355e8be880bbecaaa9e3e6d5beb" },
    { "EPISODE.WAD",        "1006eca66f9fb600b711387bd0b73ba1" },
    { "EPISODE6.WAD",       "d414e487c6faf1b2953bd2148469957c" },
    { "EQUINOX.WAD",        "79eec00904f8a5b9d8ea93652228168e" },
    { "EREBUS2.WAD",        "3500d91168a6e7fb6e0a47dfe079577c" },
    { "ERIC.WAD",           "3482e144b1495d2194936bdcf2d0b4d2" },
    { "ERROR.WAD",          "35d9fdc9a6dd491ab03ec135a7a14893" },
    { "ES1.WAD",            "a058b2d3a0d2fbebf1fb76677e8804e4" },
    { "ESCAPE.WAD",         "6a11077a1684f9d7d82c52a16d7cc0b4" },
    { "ESCAPE0.WAD",        "80cabe36def90b256e17bd9317c53648" },
    { "ESCAPED!.WAD",       "8395498eb79bcfdaf334835abb12f270" },
    { "ESCAPED1.WAD",       "51a56cc106dde552312fc3871f56a266" },
    { "ESCAPED2.WAD",       "ddc63abc9c733f03ea2d7d1b7abca205" },
    { "ESCDEATH.WAD",       "0166390f5dbc8191991e7952878025a3" },
    { "ESCHER.WAD",         "019310eb9aa64d1f91cfae16e1da3951" },
    { "ESW2.WAD",           "7cf05f1895961b87f500a5b30f77e111" },
    { "ETHIC.WAD",          "81d7fae092731eec48d56c850ba22fa7" },
    { "ETHRWRLD.WAD",       "a815953e269975a5d8e5d7c91994951f" },
    { "ETKHAOS.WAD",        "4fa299e4c2cdd134c75636f09c18d9a3" },
    { "ETPT1.WAD",          "f1d01aabfbe55002c8f57bee3cd8a46c" },
    { "ETPT13.WAD",         "e88e8c37b58a9990666dde981cce73a9" },
    { "ETPT16.WAD",         "78b6c59c6f2337272696c65cd7bb93a4" },
    { "ETPT17.WAD",         "4b7e36d904f6d6ae496f6637a2170e02" },
    { "ETPT18.WAD",         "cf5ffa1c6ce484787248852c8ad3484c" },
    { "ETPT2.WAD",          "f1df12058126e0ec6d39d26c8d49014a" },
    { "ETPT3.WAD",          "c5bc2016d8dc0975313c4598485fbfbc" },
    { "ETPT4.WAD",          "69e2fadee80b0ac02b0ec18dc0423371" },
    { "ETPT5.WAD",          "593b709e048fa7c51d8f4da97694514e" },
    { "ETPTTRIO.WAD",       "29d915fa9420b03d005f5a129f63ec8c" },
    { "EULOGY.WAD",         "e105c37cf5de1de1041855732a18fa3c" },
    { "EULOGY2.WAD",        "e0b2f7434693a2fa74cc9eb2bb834f49" },
    { "EULOGY3.WAD",        "23478568ca49ac68137575200802c519" },
    { "EULOGY4.WAD",        "1ee85d861f31fd15b7739ca887ae18b7" },
    { "EULOGY5.WAD",        "cb229bea2817c8b781053cd7a603a9aa" },
    { "EULOGY6.WAD",        "8fbddc71196c1873304ae1fc19ff0dac" },
    { "EULOGY7.WAD",        "b4f93505d3765779586fa08a064e0b7d" },
    { "EUROPE.WAD",         "e764fa8149fa7c7372ad6c9ae11d3e5a" },
    { "EUTH.WAD",           "ae2ead5f7da6b29f1acfe9ba242841e0" },
    { "EVA.WAD",            "0661125994d7736fccca357e3b654111" },
    { "EVATREE.WAD",        "35b2a49b9f9cb9f94abc4f9add4cc78d" },
    { "EVENTIDE.WAD",       "7abb85c1d281dc084802e36563ec596b" },
    { "EVIL.WAD",           "3165a22416370a9c7f56ce3267e665d7" },
    { "EVILDOG.WAD",        "a73ac36c3400c5fa80dcb424e6ec92ce" },
    { "EVILEDEN.WAD",       "d24150510df1eb5154f078592d8a6537" },
    { "EVILR1D2.WAD",       "574196e76d4bda18da8d73c25671fefb" },
    { "EVILYARD.WAD",       "5aeabf32039cf8f8b12b7778f7039d6d" },
    { "EVLCTF.WAD",         "fcc8dc90cdb807ac066e375fd5d55c33" },
    { "EXCORPSE.WAD",       "9906c51f3394b4309fad21d88cedd3b0" },
    { "EXEC.WAD",           "3dd514a851af4360971c793034c10d6a" },
    { "EXHALE.WAD",         "3225e44aef59abec87dbefe3ba188c96" },
    { "EXPANSIV.WAD",       "16d5b397b896719c2c456fb1ef592bf2" },
    { "EXPIRED.WAD",        "2f498d85d385fa7775cf3e05b254681e" },
    { "EXPLODE.WAD",        "71cf1562f423bd17f28d777b27424403" },
    { "EXPRESS.WAD",        "86c729f38413b387dfc482ee45d3de04" },
    { "EYELESS.WAD",        "6b02ddb44bab3ff4a08a74867a4087c3" },
    { "EYETIG31.WAD",       "7de92758bb4b111bbfd051b3a17a2d9d" },
    { "F.WAD",              "82c44b2d81ad2cdb04b029a19e9f1642" },
    { "F1.WAD",             "2b2fa1b4a4e5f434c1cf5e8e830d75a1" },
    { "FACFDUEL.WAD",       "e00ccb1e3fe139ec607693e3574b1394" },
    { "FACILITY.WAD",       "c665697e81dc82022f7e4d04ecadd0c0" },
    { "FACTORX.WAD",        "940bc0fa13b4405b316cb270381738da" },
    { "FAFA.WAD",           "f571c21b44440f9a715d09e8159844dc" },
    { "FAFNIR.WAD",         "c260f0ecdad6a04ac43f8225019aaa68" },
    { "FAIR.WAD",           "fd8a27d31077a887b2c2d7391bc8b5ff" },
    { "FALCON.WAD",         "c0a76e96fa2a5bf6967b329f0e3855b0" },
    { "FALL.WAD",           "8a608a9bed9d26b69025369e84b7a1d3" },
    { "FALLEN.WAD",         "580fc746b5b9d71588955c1654f27d87" },
    { "FALLOUT.WAD",        "885ee739903cddec60b8820d17ea2674" },
    { "FALLS.WAD",          "9850c9d598f6c776a73d99e6bbbd35d4" },
    { "FANG_G.WAD",         "54ef47cf774ee8f87718802abd68bdaf" },
    { "FANG_SND.WAD",       "07b27e7502a24a80f953af6ad8c93242" },
    { "FANTVIOL.WAD",       "043248aa4ba5cf8524d35c2e73401891" },
    { "FAREWE11.WAD",       "803bea088d6b34a2d32b5517ebbe9bd0" },
    { "FARSIDE.WAD",        "857933d2018470d49a15381f34c124b6" },
    { "FARTNOKR.WAD",       "598ec5a595f47e79f2c631c68b6e2069" },
    { "FAST.WAD",           "50ef7b3d0f327d3e4b8b2cc919203711" },
    { "FAST1.WAD",          "7bd41b9ccfd68a03537456fb43e5f488" },
    { "FASTKILL.WAD",       "752255b384b4a449860240324e4566c1" },
    { "FATE.WAD",           "c7497032e4eb9ca9b8598850583249f0" },
    { "FATE01.WAD",         "7d7a78dd852d100ccaae417597b606da" },
    { "FATE02.WAD",         "12c07ee2ad9b074f3155cb01278b912f" },
    { "FAUST2L.WAD",        "8eb50b4865cfaeec4590803d92842326" },
    { "FBASE.WAD",          "a1f9ff4877e5172424c3326e4a05d377" },
    { "FBASE5.WAD",         "40de61f0af645b045732864125f772af" },
    { "FBASEICD.WAD",       "180821e1cc551c119de0bd4ed439e808" },
    { "FBASE_SE.WAD",       "551c0acf6c82d45208dc6f619d676c35" },
    { "FC2.WAD",            "69a51f1212474bf493f4c837e33fe39c" },
    { "FCUTION.WAD",        "793d4e097e6625e68246f7ed6cdb09fa" },
    { "FCW17.WAD",          "45e2df94d8d7ea1f8754abb46e8bd64f" },
    { "FEAR.WAD",           "5a50ddff7eb233f7c083a0912388a828" },
    { "FEAR2.WAD",          "2df305fa11547556509e16bd536e1b40" },
    { "FEARDETH.WAD",       "2167df57bbc4ffea715f9a6b6cdf8271" },
    { "FEAST.WAD",          "b86ef6971acbab6ccd6a8e6947411461" },
    { "FEDERAL.WAD",        "3d30bb928db8bc2c469d4c6ee97c3c66" },
    { "FESTER01.WAD",       "0304819439c8fc0cb9230344f38ead31" },
    { "FETALDM3.WAD",       "cd143c48520e62fb3a93ba77d332c106" },
    { "FETALDM4.WAD",       "04d4f381746fadbc0bca8e92bbc24400" },
    { "FETALDM6.WAD",       "81f9c66d4501a8d21f3dbc47713e51af" },
    { "FETALDM7.WAD",       "d5dbb880e082c4642acc086e3b7f53c2" },
    { "FEVRPTCH.WAD",       "f9cbf4e36041789b1235884688d2833c" },
    { "FF.WAD",             "9d1e159f8b335934f3216523942d9293" },
    { "FFACTORY_.WAD",      "315cc3173257d8e7b3f712679cb31e21" },
    { "FFI_B.WAD",          "c60f4244d60c50a3919e07203e7de594" },
    { "FFI_Z.WAD",          "f7a9a02164e24ff29e5f647589a5cc01" },
    { "FF_PART1.WAD",       "b2a0b8c08580c98f2fea4cf236e47570" },
    { "FIASCO2.WAD",        "1f56ecb8b068d9cea669c0fd09047af6" },
    { "FICTION1.WAD",       "6babf359c10f8cc4c53719a714f5197d" },
    { "FIFIII.WAD",         "4a3bf9bf3aefadeaea5469512dcb67f7" },
    { "FINAL28.WAD",        "9c71a97220a41fdc3f2ce9f05a704e24" },
    { "FINAL4.WAD",         "7b69dfc7062fb0c665efcf0da99f7aa9" },
    { "FINALCON.WAD",       "c9129627d55fbd995fe720c8b809c7f1" },
    { "FINALITY.WAD",       "0c3f0a1e042d9be91918a46e55c6231f" },
    { "FINALT.WAD",         "a3fcc30f591164f712778deb076326bc" },
    { "FINAL_2.WAD",        "9aed5ff5cfdaab1ce2d2eccd3bb84b1a" },
    { "FINAL_DM.WAD",       "c36e1bb5fee5fd1ad728c3fb5fa779eb" },
    { "FINIWAD.WAD",        "4cf6b70688c4ae7c5a531edaf8fb9407" },
    { "FINSTAND.WAD",       "46a14daf55b3b67fbddb8392195fbca3" },
    { "FIRE.WAD",           "b864095e8cca6b2e9a0bdc5df5281111" },
    { "FIREB.WAD",          "00f4b028bfba64888acb1b28a0ff9842" },
    { "FIREBALL.WAD",       "03240adee2472700f821d80d16f992b7" },
    { "FIREC.WAD",          "209c6f68b4a6f616d67b658e66a82751" },
    { "FIRED.WAD",          "57d9bbcab4403fcab20f19691afcef96" },
    { "FIREFIRE.WAD",       "91034dd883f59f15fe23c12c745a01b2" },
    { "FIREKING.WAD",       "d9447ee9750b65c3abc2e74b665fc657" },
    { "FIRESTM2.WAD",       "0a944d0bf3472e85fbc0c5241bf72e1f" },
    { "FIREWALL.WAD",       "112f9a503003390b6865ac8b249ef6fa" },
    { "FIREWRKS.WAD",       "c2a383c112ebc54b33a3d1c841f30a36" },
    { "FISTFIX.WAD",        "708313db5e39b8405a67574f1ace9a68" },
    { "FISTFUL.WAD",        "252d7f7612017232f6f9b8e7c948e2a5" },
    { "FISTFURY.WAD",       "cfd889d6935ea5ec1eae2919e25e5656" },
    { "FK2.WAD",            "eb01d937d7c3324d985ec613d23850d4" },
    { "FLAG.WAD",           "ff6504b435f959b7b90c29cba10acada" },
    { "FLAMEON.WAD",        "de898fd85d5cf79066b81ff5d9806dbc" },
    { "FLARE2.WAD",         "d276a72bf4fbcb0924447e28ce69d4ec" },
    { "FLASH1.WAD",         "de8bc60834feac7df2308a13f7a9f283" },
    { "FLASH2.WAD",         "836438e486a8dd1fae1d3fa89e62f4ec" },
    { "FLASH3.WAD",         "3d4fa0b505ea1b00a1716b74e49156c5" },
    { "FLASHLIG.WAD",       "0603133bb20c701a55a957c393d551da" },
    { "FLAYOB01.WAD",       "4027b3c34d361cdc80dea40decd166ed" },
    { "FLAYOBDM.WAD",       "648f5f8984db99b60a5c8250b1475d00" },
    { "FLAYOBS3.WAD",       "aa23508b4ef72f7dffe5974815f7021a" },
    { "FLEGM.WAD",          "1ad7f2873f8ed535066296e8eef83839" },
    { "FLIGHT57.WAD",       "d8e5b431ebb7358715103cf4869ca8cf" },
    { "FLIP2.WAD",          "5724e3847c86d3b74ad520d1ff9af2bf" },
    { "FLOOD.WAD",          "558394d90b78f72ca571aafd2db6b327" },
    { "FLOODGAT.WAD",       "c08c620c6dedc848c8d404e1b8c025aa" },
    { "FLORCEIL.WAD",       "7820e24c25374c6cbac7bef2129eedba" },
    { "FLOWTHRU.WAD",       "abed6c4adc42682788bee18ca006d63d" },
    { "FLUVIAL.WAD",        "85d42df2ae8f8959b50d01f915b1600a" },
    { "FLYMAPS1.WAD",       "d470f966985d85beaa74e8113a515118" },
    { "FLYSAUC1.WAD",       "f56961ce16413ef49fea05bf92861d9d" },
    { "FOM.WAD",            "73db44f833af5128d879c9278d4a0a37" },
    { "FOO.WAD",            "aad15c5a44d4cf02027537a438a6f26e" },
    { "FOOLS!.WAD",         "83f5e718004ef3a9e1f466b675756c14" },
    { "FOOTBALL.WAD",       "fa1e51448e473006add9b3190afb3b25" },
    { "FOOTHOLD.WAD",       "30a28f0397d999f605b33a63991e2026" },
    { "FOREST.WAD",         "faf3cd241f45e93a903d364bccd523a3" },
    { "FOREST1B.WAD",       "b71ebcffb1d49b8cb3f421a6e90f9f7c" },
    { "FORESTB.WAD",        "44464296032464bade1dfb9fd14c5bcc" },
    { "FOREVER.WAD",        "8e1673a80be9870506d6c426e5cb6e5a" },
    { "FORSAKEN.WAD",       "746d8a4d3ca7def53b0d8433a70b81b3" },
    { "FORT.WAD",           "032d7e4e1b4bb58ed106284d147445fb" },
    { "FORT2.WAD",          "6ed12dc76dc6e801652bddf47db3a079" },
    { "FORT3.WAD",          "88b667ddfef224d40e98695e62c26b01" },
    { "FORT4.WAD",          "900fb1477c76d72800437374f644dda7" },
    { "FORT5.WAD",          "7a01a47ef9082f913b06b99e2bbdaed1" },
    { "FORTBORG.WAD",       "a990d5fc45f5c8e7aadf2003edd4880b" },
    { "FORTCSTL.WAD",       "d79533c07d4b5d50560646d8d0ecbff3" },
    { "FORTDAMN.WAD",       "de260f78d66a807da964a950de0cdffb" },
    { "FORTDBLO.WAD",       "9a483476ded7f2da30536d572c33a99d" },
    { "FORTDTH!.WAD",       "59b05b3e273f2581c8a3b240427bb35d" },
    { "FORTGFX.WAD",        "d1b561b2e2c6ca73ae1ab57c7f76bf0e" },
    { "FORTP.WAD",          "91d2745008164d1788cac7c477de96ca" },
    { "FORTRESS.WAD",       "40fb9eeedb402242230675b32825e117" },
    { "FORTRESS.WAD",       "eaddc831d184da9c1826c6b12eae3929" },
    { "FORTS.WAD",          "4f1cd42e60e1a40a08bc7c9e700d0d12" },
    { "FORTSCAR.WAD",       "277e8ba4600de27137d5137b2657809a" },
    { "FORTUNE.WAD",        "1f61fefe00d727fe99772b48c46a03fc" },
    { "FOUNTAIN.WAD",       "f49ea5a9565f501f47b180d7d3e73f3d" },
    { "FOURCORN.WAD",       "3515cefa8b66e6b00b5b60e056b0f06b" },
    { "FOX12.WAD",          "b4b49fe376b5f919f47c5d47c5f042c2" },
    { "FOXDM1.WAD",         "26c6256af049f1cd2a899b9f801b5a82" },
    { "FOXER.WAD",          "72aaf08c8b054ae40af443e14d178a23" },
    { "FOXER2.WAD",         "76354c4a98592501538d325f9f734a6f" },
    { "FOXER3.WAD",         "994d2c68c89ffe49b20f43385a2830e8" },
    { "FOXHOLE.WAD",        "f626bc9fe8ef83cee33488bcd4ab6dda" },
    { "FPH-NDR3.WAD",       "100abdf63ef3aec4ec9331fe88c6ecce" },
    { "FPLACE.WAD",         "d46baadc213e99d919a8e9d5155a2ab4" },
    { "FPTEMPLE.WAD",       "997eb6af63aa6dc6af46b69a6c4e6d71" },
    { "FRACAS01.WAD",       "9e62d86336db00bbe74b5e8503457fa2" },
    { "FRACTURE.WAD",       "5f5d545987702cd7d999276104833107" },
    { "FRAG2.WAD",          "0e87e6f43bbf5e4814bdbcb8f8b29b7d" },
    { "FRAG4ALL.WAD",       "af233d0f804e8c0ec24ad09b2efeb4e6" },
    { "FRAG5SP.WAD",        "ec4474ee3269c1580e26fee2182e47f7" },
    { "FRAG6.WAD",          "de1745c698f0da590bcc45a189ad00f7" },
    { "FRAGA.WAD",          "8f73b9e06b990dff745c405813966232" },
    { "FRAGAGON.WAD",       "6350d8be4c9f0d98f972834e43c210df" },
    { "FRAGALOT.WAD",       "ebc27d30152c4065f3f024623c104d4c" },
    { "FRAGAMOR.WAD",       "23c8481632ff9925ea0bb2deb26fd6ad" },
    { "FRAGBOX.WAD",        "65a05f2bb1cf7afff601c6399367d97f" },
    { "FRAGCIT1.WAD",       "4da2dfa10fcbe1528e2e0ce7d4df9fc4" },
    { "FRAGCIT2.WAD",       "a82f30d10bd0e2b101efbcfd478784c0" },
    { "FRAGCRSS.WAD",       "c33a505b13186ad28a471507cedd06e0" },
    { "FRAGEM.WAD",         "9c603db4aa322ec5b8b44f3871defe2e" },
    { "FRAGFEST.WAD",       "1125789cc8348ff0ebd2f0c0ba1a140a" },
    { "FRAGHOUR.WAD",       "5fe3b90115845861d4b58259da4117b3" },
    { "FRAGHOUS.WAD",       "3c9cb047af85c58676bd4a9bb8671035" },
    { "FRAGLAND.WAD",       "6c326ff7c6e2a40c4f37f5e321824cf5" },
    { "FRAGMAN2.WAD",       "1b99cfb44a29a2b5f709dd325fff7ec7" },
    { "FRAGME.WAD",         "65ea7011a6479666e11a6e0c5cd740ce" },
    { "FRAGMENT.WAD",       "bd9ad17f00a0f83472b809ebe69cbbb6" },
    { "FRAGPIT.WAD",        "2cf353bcbcd3d4cd896fb4ae3769179f" },
    { "FRAGS.WAD",          "843f8b901b8ee90f8478d703a36ffd44" },
    { "FRAGSIE5.WAD",       "4d817ae2ade567a0d63c69672b51c3ab" },
    { "FRAGSOUP.WAD",       "6668733f46449f2ef32f5c2b8f484829" },
    { "FRAGSRUS.WAD",       "b535fb784865dc7d2545cb5750a91f12" },
    { "FRAGTEK4.WAD",       "4cae0da2796f6e4da179ca891c0f9ec1" },
    { "FRAGTIME.WAD",       "eb67a7a7f64e6cf237a85b35cba44ecb" },
    { "FRAGTORY.WAD",       "df504ac7a141c03ac68e8a386986cff6" },
    { "FRAGU.WAD",          "a9d3974dc3ed7f2e4c699a086389b299" },
    { "FRAGZ4ME.WAD",       "09e9cdd1aa566dc45b20082c83cd0157" },
    { "FRAGZONE.WAD",       "2e647112e5bcc595ae27f8659551bbb4" },
    { "FRAG_IT.WAD",        "e5050f37b7128729b50d36ad9651fe33" },
    { "FRAG_YOU.WAD",       "c92a7362d84d0c317ce9affb6c1b53ac" },
    { "FRAMES.WAD",         "3ca825a90c14172cc36b5f6e03158f4a" },
    { "FRAS.WAD",           "34963bc2e9e0ee315abb8643d48a9fa6" },
    { "FRAS1.WAD",          "d8887163efab446bc805870ff3b6512f" },
    { "FRASL.WAD",          "d7bac66871404429e1834f48787f8504" },
    { "FRATRCDE.WAD",       "f7c4a153f4bc461b2f539e81a708931c" },
    { "FRAY.WAD",           "ab7f0929de365edc7ec3beabc8a97a8d" },
    { "FREAK.WAD",          "f2de88b00d870fd88d4b7f9217a4ca81" },
    { "FREAKED.WAD",        "fc0511d0a612e16c72e298b8cc1e7b06" },
    { "FRED.WAD",           "193b896c87450687e97c495dcd85b97e" },
    { "FRED_DM.WAD",        "10ffcc52515e793a0335fedf87d5abcd" },
    { "FREEFALL.WAD",       "b67137e62fdd9b35306ec838ed5e62d9" },
    { "FREEK01.WAD",        "338dc37f6bd4bd731b1d12f34e100837" },
    { "FREEK02.WAD",        "583c032a27938739d0734abc10bda70a" },
    { "FREEK03.WAD",        "caa9d530d7da285a5f49f5ad970b7887" },
    { "FRENZYDM.WAD",       "597d9820218ffb8c08d3235ff4c55df3" },
    { "FRENZY_N.WAD",       "41abb71c1cfbeb54090ac9c6e8664a32" },
    { "FREON-2.WAD",        "1ddbbe7a4d36fc41d7cc96fdbd4e2222" },
    { "FREON.WAD",          "2c2b9e91ccbc6a8485f4a74fd3cd4363" },
    { "FREON3.WAD",         "d5ffcda032d594ee78eab607d771151c" },
    { "FRESH1.WAD",         "d8d2466d81112a60ce6dd6db8e60ce95" },
    { "FRESH2.WAD",         "b661debf58a1e6564b9da2175131314c" },
    { "FRESH4.WAD",         "e1f3aaa716871f810c551ca3b9c2846e" },
    { "FRGBLAST.WAD",       "1d62c731429658407c7934b12b83f538" },
    { "FRGBWL2.WAD",        "da2958fe09d869465bad3008a6bda253" },
    { "FRGCOUNT.WAD",       "fe3ecf06b153f6bbaafa7f0be4494556" },
    { "FRGMEAGN.WAD",       "4f7361d29cf3b79a43d2db1345aa8e70" },
    { "FRGMEOMT.WAD",       "cd27ea0e030fede4c875ce6744d3185b" },
    { "FRGSOUP2.WAD",       "dda907e0f14741898e30b7632e89f6cf" },
    { "FRIGFRAG.WAD",       "ff108be1975fa5dbaac579bb2e58519c" },
    { "FRISCO36.WAD",       "611988601de02fabbaa645e3f70ebfcd" },
    { "FRNZYPAT.WAD",       "af3a8b617fdc5f2a0ebaab0b1f8458f3" },
    { "FROGFRAG.WAD",       "bcc9942bed22514e81c81b0173dea140" },
    { "FROGGIE.WAD",        "bdbd501ac80636d2884e76deb5fcab51" },
    { "FROMDREM.WAD",       "e1a140e29064bbbe497c60d27048d926" },
    { "FROSTBIT.WAD",       "66af01f42270c1f03720aad5f0c77c60" },
    { "FRTDRILL.WAD",       "c0d73dbf9046286376e8c9e67c877774" },
    { "FTCOMBAT.WAD",       "5f52bbf3698d5289676634182a16a169" },
    { "FTHILS07.WAD",       "1be7c2021802eace7b36175b0d8848ef" },
    { "FTHL1.WAD",          "d4e4e3e3c6f58ea781a4765f0ab51ec7" },
    { "FTHL2.WAD",          "28762a8af5561b768b94c0d6e5ae378f" },
    { "FTHL3.WAD",          "97a7038c843f949df656a5f854f70dea" },
    { "FTHL4.WAD",          "6203b273429619472d9ee4191927460b" },
    { "FTHL5.WAD",          "bb3abdfd243ab9f5e90eadd64be886c1" },
    { "FTHL6B.WAD",         "7acbbaae4cdafd0950abce065ea47687" },
    { "FUCKUP.WAD",         "03445e25fc33468d0e72cb67db264d2e" },
    { "FUCT.WAD",           "57c922976036f63a738e06c262a2cdba" },
    { "FUEHRER.WAD",        "e47db323bee04bd6b2464441730bb710" },
    { "FUGHDM01.WAD",       "7b1cdb89eea6887848f2b91f6f0880f6" },
    { "FULCRUML.WAD",       "ae3693278528dce5dd282f083b0238be" },
    { "FULOLED.WAD",        "eeede2c1d6183580e8a1e4b30ab2d405" },
    { "FUN.WAD",            "6142ae8676e8c2cd13d648af847558be" },
    { "FUNERAL2.WAD",       "5a137644c4e99ece11d76b819169b568" },
    { "FUNHOUS6.WAD",       "4bcb1cf68d0bced1ade1b4e24da7b868" },
    { "FUNHOUSE.WAD",       "142a41c214ec665f9396227773c373fc" },
    { "FUNWTP.WAD",         "0e95cc7ceda058b6c70a26af59a23597" },
    { "FURY.WAD",           "6b2edeb966008f44761625e6ba9f4fa2" },
    { "FURY667.WAD",        "287d7edbf4eb7abfca728fa5e40906c8" },
    { "FUTURE.WAD",         "2a975713fcea0848896616ee6a3dd4c9" },
    { "FUZZ1.WAD",          "52c2e8e5e03ae5bf721b2db5a6d4b734" },
    { "FUZZY10.WAD",        "9f06f715aa8522229493b714abed73a9" },
    { "FUZZY18.WAD",        "23de17700d4dc99e67f98e7df5bfe765" },
    { "FUZZY20.WAD",        "95a75a4c5b2c3085a1ee4690245c2795" },
    { "FUZZY21.WAD",        "71e22836d910bf3b0cb0d7d33d21797e" },
    { "FUZZY22.WAD",        "99d8a8b41d3e344911cfb1de11566e9d" },
    { "FWATER.WAD",         "75e032ab6806e4a9fcb1caa77c9c46b1" },
    { "FWF_AZTC.WAD",       "7a36a41cc7fd542cbd0a11ab7b4edf5f" },
    { "F_SKY.WAD",          "9b2bcdbb0f6477e4957d5194d6efcc2e" },
    { "G50.WAD",            "19766bfe476fd0f1daafc9c5f6f66c8e" },
    { "G8.WAD",             "646c02f1822687bf3a309e970e538513" },
    { "GAC001.WAD",         "2851af25a3534879fa1144b1f785608e" },
    { "GAD002.WAD",         "deb7bd34231e2328fa1c5391218da64c" },
    { "GAK1.WAD",           "632ea61b51bb8313bfd4566cae9bb6b1" },
    { "GALAXIA.WAD",        "65c4d40473e219229a5392c8d02ad480" },
    { "GALLERY.WAD",        "b2d7d85ecd34c132395ae322c04a9c8f" },
    { "GALLERY2.WAD",       "cde0800baa4cdd79b3ee456d791f46e2" },
    { "GALLOWS2.WAD",       "2f9a781391c80075faff35f1ec283651" },
    { "GAMBLER.WAD",        "b6b73398fdbaf984beaefb56b3683203" },
    { "GAMES.WAD",          "3961bc2d5dba4bc490c109dc0b39f221" },
    { "GAMLABS.WAD",        "a80457cfdc7374dd4e767eac8f101feb" },
    { "GAMMOS.WAD",         "ec30d780545cafbdad95b3024992be84" },
    { "GANG.WAD",           "c70edffb79a5c45f89b8fd230f0eb2dd" },
    { "GANGUP.WAD",         "eaf5e5706fd8be4e9097c9fc7f29ab10" },
    { "GANGWAR.WAD",        "a45336094534acf601973eee9641c77f" },
    { "GAOL.WAD",           "ffd5d0377f06525244950bb4efa3c254" },
    { "GARBAGE.WAD",        "7f1ecee97f5c377b1a0f6d22d00998fe" },
    { "GARBAGE2.WAD",       "326c167210cbb7cbe8a5cf27e829e790" },
    { "GARBAGE3.WAD",       "9ff0b56648e4aefd7dc3d65c867dce21" },
    { "GARBAGE4.WAD",       "3ca38b17e87a13332e475061beecba48" },
    { "GARBAGE5.WAD",       "3893b7a824af56ae4d3077af7f65b729" },
    { "GARBAGE6.WAD",       "f72fc22c53213f1f7a826ccde11838e5" },
    { "GARBAGE7.WAD",       "90f2120c026848d3e926f787c3c5693b" },
    { "GARBAGE8.WAD",       "8fb056cd39044721889882c6475113d1" },
    { "GARBAGE9.WAD",       "e62a3df79831af62697b65fb0d1e81e6" },
    { "GARDEN.WAD",         "6a94a4a781e6315e2ff26a88eb2dd01c" },
    { "GARDEN2.WAD",        "5bcb673e0434ab3b05d9a36661906263" },
    { "GARDENSD.WAD",       "58983782e965b07f77fe08b34ce7dfef" },
    { "GARRULO.WAD",        "33047f3f81d8f170802947e80028887a" },
    { "GASMANSN.WAD",       "6325cb72539827da5259174fba6e5ac6" },
    { "GATE.WAD",           "93e17af10ef9af481ed6c77354beccec" },
    { "GATE1.WAD",          "4af683be43046029c721241dce335875" },
    { "GATES.WAD",          "f9516f6c40b2a12b07a9a87f82ee0edf" },
    { "GATEWAY.WAD",        "a1bb0c9f6d66f1f296a0ecb8d8bedba8" },
    { "GATHER2.WAD",        "bf04ee7d96890c666049120026d5f19e" },
    { "GATIKA.WAD",         "c3752941b7683738c097f23efb837952" },
    { "GATUY.WAD",          "147bc050bf92009ad42c57c45ccb4060" },
    { "GAUNTLET.WAD",       "471cb6ac33a1a22063f3d3c295c84137" },
    { "GCROCKET.WAD",       "09fcf08477f89d79b50fbf26f797f300" },
    { "GC_PLANT.WAD",       "4ca72a12584a28b1b9b822b79740b2cb" },
    { "GC_TOWER.WAD",       "1503ce4dfe7a35560416d67795c56cf2" },
    { "GDM_CAVE.WAD",       "31b63c0eea9007d8b7c6534708159df8" },
    { "GDNT.WAD",           "21a038e0aaf5f90e415c0ef110364d63" },
    { "GDREAMS.WAD",        "6e3acffcfadcbd8f1ae4fdaca8eb5f34" },
    { "GEHENNA.WAD",        "545605cfbabafa5c94639f927e6d31d7" },
    { "GEM01.WAD",          "65943858a49586a8b13d2038138a1d13" },
    { "GEM02.WAD",          "259ada8ac33d9e3fc67ad16bb4bf2ade" },
    { "GEMETZEL.WAD",       "6e0293e4215bfc92464efab1debf6410" },
    { "GENESIS.WAD",        "10749136e6f98e7d16698cc58e685f6d" },
    { "GENIUS01.WAD",       "281bd61ab27875544a1af424881640c0" },
    { "GENIUS02.WAD",       "47a74ca4c069e4551ab0700d3674773a" },
    { "GENOCIDE.WAD",       "6185f82c811fee91c7dd7f4379bd8d83" },
    { "GEOMETRY.WAD",       "e3e81fa29a4d994e2e68a51ad2b825ff" },
    { "GEORGIA.WAD",        "da77c0ed0787cac187c6f1f8f0da5ef6" },
    { "GERMANY.WAD",        "abb02a3d6b55fdb306bf2728259c4dc1" },
    { "GETAWAY.WAD",        "eaee6860b16cadacb1610c5515411d81" },
    { "GETEM!.WAD",         "4153f1b588f7abace42db0f43a60c5fe" },
    { "GETOFF.WAD",         "bcb55097e7561d0b20cfd8db6217cbea" },
    { "GETREDE.WAD",        "cd29bc9aeb1008239aa3a3a4a30a7499" },
    { "GETSOME.WAD",        "c9b8800c82d586b37fea06b7504ef61b" },
    { "GETSOME2.WAD",       "ee51b95e0b5dd10cc5e32bb13fa29607" },
    { "GETSOME3.WAD",       "d2a137fea0580fd609a6b88e340e35f8" },
    { "GET_YOUR.WAD",       "178cf6352f6bc87a0ec3cd64ed7c7d0c" },
    { "GEYSER.WAD",         "0a9c875d8d26e7af5e4150587ec102aa" },
    { "GFX.WAD",            "2960c97fe2729587ec3be6e285d3a466" },
    { "GHOST2.WAD",         "ccc0d1e745478bbc4b74803611f4a055" },
    { "GHOSTBST.WAD",       "3a030955ca00557d175fb1bca61457b9" },
    { "GHOSTDM2.WAD",       "1fb067b21b2ac6a596d9c111fd1bb52d" },
    { "GHOSTOWN.WAD",       "9bbb52bcd81a2aadc6957cf0ec91e981" },
    { "GHST_TWN.WAD",       "845cc0cc1f76f8c4c801601f880d58ea" },
    { "GIAN.WAD",           "85e1049afe14a5464d8acbc34dcd59a7" },
    { "GIBFEST.WAD",        "9598984ad6c757369ab23c6ec0321254" },
    { "GIBHALL.WAD",        "47f5c4ea68822d84d72ca0bc2c295874" },
    { "GIDEON1.WAD",        "164511fd7ce6b94fb839d266282d3b69" },
    { "GIDEON2.WAD",        "902d51de1120c3ee1d94c4151992ec0c" },
    { "GIDEON3.WAD",        "4165ec6495095fd7f2e753c38192952e" },
    { "GIDEON4.WAD",        "0e6b99bcfc02f0e64c9f1d2120709d96" },
    { "GIGAKILL.WAD",       "0eaa4fd0aa592aafc966e024405721e2" },
    { "GIGGLER3.WAD",       "100bbdd30521fcf15ecc8ce971d258a0" },
    { "GIGGLER4.WAD",       "469d819036c9ff673eb151ee12aec46d" },
    { "GIGGLER5.WAD",       "78a04a87f57cc8601c39808cd6ef25db" },
    { "GIMP.WAD",           "259d47ea8380462ee752a78e034fb712" },
    { "GIMPY1.WAD",         "f527f0353cd3f820a7e94408959edbca" },
    { "GINSU1.WAD",         "a7142933f1e8e2dacf07a817ab297b6d" },
    { "GIRLY.WAD",          "2e3a894705915ba923b3310a26b825f4" },
    { "GIZNAD08.WAD",       "093ac9f709ed5267a445264cb421c6f9" },
    { "GIZNAD09.WAD",       "0c461682327ad59c97de00b85d2bea82" },
    { "GIZNAD10.WAD",       "478e337f5256eba6c6ec6efe958115da" },
    { "GKDM11.WAD",         "152f211e22ecf53693ba80ddb7d40699" },
    { "GKEEP.WAD",          "0950b87e9911bf98e84c17cd3496bfd4" },
    { "GKPAK1.WAD",         "21630148e4ff759aaa7141e2c097c39b" },
    { "GLADIATR.WAD",       "2f811daf15c1387cdb6c8d1e73ae0e85" },
    { "GLENN.WAD",          "e6f796c8217b5ce9024a6b569e47adbe" },
    { "GLOIRE.WAD",         "f642123a000c6a747e90ced93b961580" },
    { "GMC.WAD",            "7fce2d0e840efbc4300067fac6ebeda3" },
    { "GMEGALX.WAD",        "82c6af20bebb2e51ce74c6317871b37a" },
    { "GMUSIC.WAD",         "b2351dbf819a38a3408cd30316f3070b" },
    { "GNABSCH.WAD",        "a877cec259abd97943316c9e192bed3e" },
    { "GNASH.WAD",          "d0edb7dfadcfc712c7317077a2c77e38" },
    { "GNDZERO.WAD",        "e966a9ea1e0ecec733e7ec254c1d6d0d" },
    { "GO.WAD",             "208963afb5bc7aa99ec31b2dd0ef96a3" },
    { "GO2KILL.WAD",        "be610077efabcb5c728072a49353a3e5" },
    { "GOATSE.WAD",         "7f7c268ec7b0c5fa6250f6a22c5f48a5" },
    { "GOAWAY09.WAD",       "d0d2b9ad4f31742b1f7d58908342761b" },
    { "GOBLET.WAD",         "e46a51ef62d3de0520cc813eea7b5b4b" },
    { "GOBLIN1.WAD",        "b4f288e087184f9d73130d06153e6294" },
    { "GOBLIN2.WAD",        "bad6a59bc3db9eab6b97fda402198ebd" },
    { "GOBLIN3.WAD",        "5db95e8e38723ea8ca25c686ec588c51" },
    { "GOBLIN4.WAD",        "87de29948dee5d41555dfca858d581c1" },
    { "GOBLIN5.WAD",        "05b1814fc79a24312aedecc1672979be" },
    { "GOBLIN6.WAD",        "91aa8906c0803c522f2c5defd70fe11c" },
    { "GOBLIN7.WAD",        "4c7a9644211762ea5dcc6f35af7f00be" },
    { "GOBLIN8.WAD",        "5ce73ed76c01f0377638e11b7913038f" },
    { "GOBLIN9.WAD",        "78f13363baa7e1e4265a63711467ff4d" },
    { "GOD.WAD",            "f09f8b998e25ebf3adb54cf1bc10a1dd" },
    { "GOD2.WAD",           "a390f02482b84ad2b82abd16b0c4bd52" },
    { "GODLESS.WAD",        "2fcb4036e168507854eac19a3bbc608c" },
    { "GODLESS1.WAD",       "d00dd0887f04b62f2ade1c8ac3b611b9" },
    { "GODLESS2.WAD",       "f0578e24811a21cac0c894d9f61d012d" },
    { "GODLESS3.WAD",       "bd1f6a31934141155c38d843ca2d0718" },
    { "GODLESS4.WAD",       "b59a0d5c6ad3dc3b5b824c70be6680fb" },
    { "GODOFWAR.WAD",       "b64f7b3aec37e056ad2e86ae419f12c5" },
    { "GODS.WAD",           "fe969c3aae34b0572dac3f0cd8a18828" },
    { "GOD_HELL.WAD",       "28b86fd9a4a37393cbf48cf88a7dac63" },
    { "GOFFDM01.WAD",       "aefcee83a9cdf7fa209f0924493bb84d" },
    { "GOFFDM02.WAD",       "c880eca87c074e4c413483ea44644ed6" },
    { "GOFFDM03.WAD",       "03c2e9a1de146434bac57c4dbcba9d95" },
    { "GOFFDM04.WAD",       "5607e2be2f95e9ea658f82ff3416a45a" },
    { "GOFFDM05.WAD",       "b1ae96fee5c7023241bd6ad5ff92192c" },
    { "GOGO.WAD",           "8ba74ac9de38a08e97c814ce5349fc19" },
    { "GOGOMAP.WAD",        "c6a04762e14e78539b55d21881f5ef55" },
    { "GOHOME.WAD",         "a18e0f8c93b24ac84bdfacb03c1312bb" },
    { "GOINGUP.WAD",        "e7f09724a6d4de028751ab8ecd127499" },
    { "GOLDMINE.WAD",       "1b0e318e9d67e4358811a168a2e5f558" },
    { "GONE-MAD.WAD",       "82b3ae872bb2732c4ec9412870ff003a" },
    { "GONOW10.WAD",        "1b725556c15bdfe8e3c5d779a8438ca0" },
    { "GOO.WAD",            "6eec40338a884a94beee0dc431c08227" },
    { "GOOD-II.WAD",        "581e01f326a74edbe4455be314d58e80" },
    { "GOOD.WAD",           "6bfcfc3c7d91a831826a51ccdb879777" },
    { "GOODDETH.WAD",       "a692813f71c3d30da5e3de0be40414fc" },
    { "GOOK.WAD",           "4e1c2c86f927746ef331690dd767c731" },
    { "GOOMBADL.WAD",       "b518b81aecce4b965aac59b8fc273277" },
    { "GOREG3.WAD",         "98b1173fba0884e04a9566a4c5525d10" },
    { "GORIOUS1.WAD",       "d57ec97ae477adb97eeb7e1d7c74747f" },
    { "GOTCHA.WAD",         "675c91dc7278b4e21cd49afa9b950411" },
    { "GOTCHA2.WAD",        "7c7340df9ef9a516c0aa15fef7934db2" },
    { "GOTHEWAY.WAD",       "552eba455ad603d59dae09bed3d5f54f" },
    { "GOTHIC.WAD",         "077f61950e551b77e4f8ccad1cd2542a" },
    { "GOTHIC.WAD",         "42754cf3b6aa9dd96bc4204cbf5b2bd0" },
    { "GOTHIC2.WAD",        "64b013283d3c61542730190c9efa70d2" },
    { "GOTHIC99.WAD",       "c7420d6d031c373e6fec76e7196a8358" },
    { "GOTHICDM.WAD",       "e3152d666b2e8fb46b92388549a7c588" },
    { "GOTHICTX.WAD",       "455af0292472383a19841bf4692e002c" },
    { "GOTOHELL.WAD",       "1ac1c80218ad8ea847d02ab1c374e4a7" },
    { "GR8DML2.WAD",        "b42b15b20503a3e07054638dd5cd0742" },
    { "GRAIL2.WAD",         "4b617b1a9b3930c16a80cb6b92d46aa3" },
    { "GRANGE.WAD",         "5a82604199465c0b5c5cd2c443a4abbb" },
    { "GRANITME.WAD",       "13839a031410e47236e2e3cff408878e" },
    { "GRAPE42.WAD",        "2a8776d5c17eb042ded4cf25d31c9f19" },
    { "GRAPHED.WAD",        "010c08886f430584eb361e6421498b03" },
    { "GRAPHIC2.WAD",       "518c48925a46b3bdadf31ead3c589853" },
    { "GRAPHICS.WAD",       "aa15f2a19d615126ffca1671e2631155" },
    { "GRASSDMP.WAD",       "896eee0c8b68a2d310f0d27dfe4a3aa8" },
    { "GRATE.WAD",          "eb5628d44d2567decc2786fc67df4d8e" },
    { "GRATES.WAD",         "cc02660d8fa899e90e3b5a9b6713227d" },
    { "GRDNODTH.WAD",       "87be1ec98a93f5a71c0189b1013c42a8" },
    { "GREAT.WAD",          "133c429ebdf422f44dc3ea71a576ce9f" },
    { "GREEK.WAD",          "901a81d40cbcd051ada2bfc7b1988409" },
    { "GREEN.WAD",          "32326c49247ff75f3dad1527ac5a047c" },
    { "GREENMUS.WAD",       "4b8b40f48171f8bcbd354199a04a380b" },
    { "GREENWAR.WAD",       "10fddac0b2a714eb9a02a8f172e4a28c" },
    { "GRENIAN.WAD",        "e7ea8e25ccb87c446bbdb09533075812" },
    { "GRIDD2.WAD",         "41133edf6ede8d0a8fdb2e6e9b795cb2" },
    { "GRIMREAP.WAD",       "81aaad72c6c59d573e259a7fd5d93698" },
    { "GRIMRIPP.WAD",       "d2b64616768af7c8349c1efa7d2901ea" },
    { "GRINDER.WAD",        "6a6ba5e57237ec79e7a563aa096c039e" },
    { "GRINDR1A.WAD",       "1b269c63a310ac748930c89d85e15f45" },
    { "GRNDCOOL.WAD",       "a7c2ee391b4f7bc48528d344707385dd" },
    { "GRNROCK.WAD",        "15b6ee2ffdaf9910e9e3bc67b216be95" },
    { "GROAN.WAD",          "92366f5be6a5af3af9f18fcdd9c39b7c" },
    { "GROCERY.WAD",        "6f055bac33643ad74713da1960d37660" },
    { "GROOVY.WAD",         "9477438494b45920870b8a60c8ba1aa6" },
    { "GROTTO.WAD",         "11275462d85ef1ebf6b6bdf765448e9b" },
    { "GRTBTLS.WAD",        "23a30f7504985e0b324fe2f3a7cba73e" },
    { "GRTRWRLD.WAD",       "fe704a1cd24b429cc6836beae4887ae4" },
    { "GRUDGE01.WAD",       "e1d48fd1f7eb378b8454091439754567" },
    { "GRYYD.WAD",          "4cefc5b12918a4f2a0a74a3e7d4dfc65" },
    { "GS-AOF.WAD",         "27b86042dfa0685597debecd08522094" },
    { "GS2.WAD",            "9b2cd7d2a4f2119e66229d50ae859707" },
    { "GSD2E1M1.WAD",       "33489212ad556b68c20bc3c328899c36" },
    { "GSHRIMP.WAD",        "3a2edfb9db0c8763ac46de55df1ad083" },
    { "GSNAIL.WAD",         "83b1c6b14a6b9fa355f4e43168db094e" },
    { "GSOUNDS.WAD",        "93afaf07967b41d3189cb776f5f5c105" },
    { "GSPRITES.WAD",       "36f2f7b21d0334cf2771fc66d1ff8369" },
    { "GSTONE1.WAD",        "02cee34df6d4e71c760da27de1e9b360" },
    { "GSXR_01.WAD",        "ea66604de913163997bf4142109b7a83" },
    { "GSXR_13.WAD",        "6974b05f55b141a9e26b3e2fef6bb12f" },
    { "GSXR_24.WAD",        "c37baa0158d5167276e39ab62e6fb8fe" },
    { "GUARD.WAD",          "9b16b01c8bc2b1b40561e3709dfa078e" },
    { "GUARDIAN.WAD",       "365ba94b4fc9fa46a3cc9f7e45e0722b" },
    { "GULPH.WAD",          "8f189fba1dfd7664ea3e5cb03b178f4d" },
    { "GULPHGF.WAD",        "ba020741803622029c5634bf1f0e43ea" },
    { "GULPHSP.WAD",        "5ca0a9987f9ce2d85b0e1a9c5d90f775" },
    { "GUN1.WAD",           "4ca6eb09aedfdd2d019911ec440e4102" },
    { "GUNDM1.WAD",         "85c1735b6194f450ca6d9c7e53060cfc" },
    { "GUNDM2.WAD",         "40e19e9e1dc8d94882750f989d371ad0" },
    { "GUNDM3.WAD",         "ff9c0a357ace40df06ec7ed6a045dedb" },
    { "GUNSMOKE.WAD",       "861deadc5667d2a499c1d825d8c59683" },
    { "GUNX.WAD",           "a63154516f68ebf273b58b47804655a2" },
    { "GUP.WAD",            "8fb9bcb18b75986447e82b60258c8d81" },
    { "GURGLY.WAD",         "0b0dab4546fa65c8c7c44350c597e7ca" },
    { "GUT-FATH.WAD",       "792ec2b53bf77c86034689c805cbeed8" },
    { "GUTS.WAD",           "6bd47f7481f149906ddab65acaa3574c" },
    { "GUTS01.WAD",         "482f3d229463da82cc9cdd618c8147c1" },
    { "GUTS02.WAD",         "72dc074907efd2263b2a3b98eeb78dc8" },
    { "GUY2PLY2.WAD",       "9f57827c803c3dd07a970669c4822ea5" },
    { "GYM_96.WAD",         "b4bb88ee35de52608d0fea19a0d85112" },
    { "GYPA.WAD",           "d44b57cfb1817a33bf219269b317c5a4" },
    { "GZ.WAD",             "0f4ceff04b8054c4ce62fc2168794142" },
    { "GZS.WAD",            "12feee1da8ba5a056a849899dff7e515" },
    { "GZSKIN.WAD",         "7f7e193b102b2c4f49f2c14bc3b4f0ea" },
    { "GZT.WAD",            "f60b1bfbd72f72996b5ece4c7b11455c" },
    { "H-ARREST.WAD",       "7d04ec0fcc779adb9619de6d00793fb2" },
    { "H2H-TOWN.WAD",       "60049147e49ae2b03b5fdb9c956b943f" },
    { "H2H1.WAD",           "47140575cdabd36ae10160aff0e93492" },
    { "H2HCOMBO.WAD",       "670ada59da92d8f708dbf69f62e42ec5" },
    { "H2HCZAR1.WAD",       "6b796a3dda2b366b14dfc30fd56bfa8f" },
    { "H2HCZAR2.WAD",       "606c77ad404e0ef10e6fc43116bfbc2e" },
    { "H2HCZAR3.WAD",       "e23e03912c633458e39ab615d2c18829" },
    { "H2HCZE3B.WAD",       "46ac98b169573a34c393812ce927eb3b" },
    { "H2HCZEK1.WAD",       "be2dd7daf486d3ec3a0a1c4001edff37" },
    { "H2HCZEK2.WAD",       "b590cfa7893eab0d3fe10ae3e4f45b68" },
    { "H2HCZEK3.WAD",       "f4af2fb19cc256300b8040f7e9f361c6" },
    { "H2HCZEK4.WAD",       "40a9a572a7fcfa9b77547743808bcd08" },
    { "H2HDROP.WAD",        "96725924e5842fffe236b8ce9ea9d08e" },
    { "H2HMUD01.WAD",       "2ee83a0c4ef99ec0eba6e0575ca7707e" },
    { "H2HMUD02.WAD",       "6d5fd1777d05b60d8f6ebc8afd8bd79d" },
    { "H2HMUD03.WAD",       "18ca967d92d6b4e27f478fa18929728e" },
    { "H2HMUD04.WAD",       "491623b48207bf648cd7c6a649f412de" },
    { "H2HMUDD1.WAD",       "96604e33de351b0864825283f06944cf" },
    { "H2HMUDDX.WAD",       "513f1ea6b6558a09da3107fc72ac6721" },
    { "H2OWAR.WAD",         "de93a095d56dc03709b49c2da2ebc6cc" },
    { "HABITA.WAD",         "0f9cb02e23fed00dbb6db100f453b371" },
    { "HACHISCH.WAD",       "de624d8c2391c010c77e1d264686ab9b" },
    { "HADES.WAD",          "0d08de1fca68137f1d28ffb515cf2154" },
    { "HAFCHANS.WAD",       "5d3436d7428c04c4ea35f246a2c086a7" },
    { "HAIGHT.WAD",         "0e6729f00f2318989eec59ca0dd1c6e6" },
    { "HAIGHT2.WAD",        "64a7446aa61d3ee3b648fcf181c0d3d9" },
    { "HAIRBAL1.WAD",       "31fb72b8973de7173c0210baa993b5f1" },
    { "HALL1.WAD",          "68233972b3f55bda4664517f2d644c01" },
    { "HALL2.WAD",          "c580e8c6175ae8d8e97a244f79f96c26" },
    { "HALLS.WAD",          "b55b056d8718ef41a7d36114e3b394c0" },
    { "HALLWEEN.WAD",       "71f86233a536dbeb00db2e847ba6cbce" },
    { "HALL_2.WAD",         "830d60f1ba00921b41babf39875ca8c5" },
    { "HALOGEN.WAD",        "de18a8ffa7d8b6e521183b195adb5afe" },
    { "HALOGENB.WAD",       "34cacd4dd3c877b4a7c6b2dbb4ef078f" },
    { "HALOLEV.WAD",        "6e83089c2e9fcaf07c1bcb29cd7e5253" },
    { "HALOMUS.WAD",        "397bd2c782b9ce97c8ad7c44bdb1db93" },
    { "HALOWEEN.WAD",       "c47a5bff8a0bc00e6d1f1959d3dba862" },
    { "HALSODM.WAD",        "3cc9a429f1adaccb36f07671826531b1" },
    { "HALVUNG.WAD",        "8d682f8ad12ce18ec287620b263c8810" },
    { "HALW1FX.WAD",        "38e6b2ecc76030f2d90b75d868312a16" },
    { "HALW_LVL.WAD",       "a709a56baa399bcc4f44b17ba2ab72e3" },
    { "HALW_SFX.WAD",       "f7561ec1ac056a3c0d751d5110f2986c" },
    { "HAMLET.WAD",         "c72d2244676387d30deb3aa10317aa4a" },
    { "HAND.WAD",           "f8cafb85ceb1414b487272e2dc195ab8" },
    { "HANDICAP.WAD",       "f22504033ea8044e37eac41e0e29a4d7" },
    { "HANGAR18.WAD",       "bc75599b4f88ff5a87db922c6ef25035" },
    { "HANGAR2.WAD",        "5d376b361927b5f4f75f105a085a228c" },
    { "HANKFRAG.WAD",       "4cc6104b0dba3ac679e262973ad460d3" },
    { "HANS.WAD",           "06de32447450df7a83cf9f77716fef36" },
    { "HAPYDTH2.WAD",       "1cd9416336e30a7c8a49605e63aca23d" },
    { "HAR.WAD",            "92bd4cb29c5af9f0edb441b981536692" },
    { "HARBOR.WAD",         "71a4e46e2281b570bfbb8bb8badd7c9d" },
    { "HARBOR2.WAD",        "469c8edcc510965dd3a2d2aa4597e29f" },
    { "HARD.WAD",           "602eec9c80fe19befccd37ec7688dad5" },
    { "HARDCORE.WAD",       "61fe15464ee8da510de924ecc1763d74" },
    { "HARMONY.WAD",        "44813fd10529fbf30f65503e406b6e66" },
    { "HARTFORD.WAD",       "353dd9dc158a48806eca26668fe71dec" },
    { "HARTFRD2.WAD",       "e639c1a06862745c61c8d6b7c280577e" },
    { "HARTFRD3.WAD",       "35f3e5e2b6eea2614fc0c1d8bc4151cd" },
    { "HARVEST.WAD",        "78f86df02a452a8b731b391742320009" },
    { "HASLAMS2.WAD",       "9157e53ce1b297640b53d8795353f42a" },
    { "HATE.WAD",           "3c0b35ab7568d0c082eb900c2f330c56" },
    { "HATMATCH.WAD",       "428987d12d165d7d0c00fa297941e7ed" },
    { "HATTRICK.WAD",       "eb295bd02054bb80ffa54a3ce0d14e4f" },
    { "HAUNTED2.WAD",       "8b87404968c288309a2945bfdae162d4" },
    { "HAUS4DM1.WAD",       "0de82fa226fb9ef4e4f33202369577e6" },
    { "HAUS4DM2.WAD",       "2757cc8397d610265442bb28af3f5ae9" },
    { "HAVOC.WAD",          "8893daf572f9956cce54d0bfede3687e" },
    { "HAWKDM.WAD",         "da4081862231fe520ddc5758e84727e2" },
    { "HAWKDM2.WAD",        "134397963fd301fafa0e6d60266f829c" },
    { "HAWKEYE.WAD",        "0009a14d711a527a987021fb36e4c560" },
    { "HAWKFF.WAD",         "1d1784e52956f8cf9648c86f9726d540" },
    { "HAWKFF2.WAD",        "dc567a1eb84a4b17d30ee66f86f2b58b" },
    { "HAWKFF3.WAD",        "39caa2eb457c40226b4f1b85f6a2956f" },
    { "HAZMAT23.WAD",       "0194a55c8aecea65266e23434b9c8ff0" },
    { "HAZZIE1.WAD",        "70b312cead19e6c0cd8e223c84890134" },
    { "HAZZIE2.WAD",        "ebe75d4a0ff7aff725ca9941a96791eb" },
    { "HAZZIE3.WAD",        "d8987ce1de48dec5766ceed9085a1c6d" },
    { "HAZZIE4.WAD",        "c50516ee24fb671e3d5b78df348a9c3c" },
    { "HAZZIE5.WAD",        "76beb72a685049f4b4673d471dfaeb99" },
    { "HAZZIE6.WAD",        "e4d8d4193803c3863105fb6442888b40" },
    { "HBALL.WAD",          "0b01ce9671493111884f665fd9e068dc" },
    { "HBLAST.WAD",         "f8df80f1de7b64991da22758774e72da" },
    { "HC2.WAD",            "0bfeb0c3d542eda31a79fbe638544e3f" },
    { "HC3.WAD",            "86debce9b24278b84ed6269747b1a4e1" },
    { "HCDM-GRA.WAD",       "8104e5fdeec15d64dba9a56ad54ba18f" },
    { "HCDM-MUS.WAD",       "3121427d3273d303219e22704f676ef1" },
    { "HCDM-SND.WAD",       "f6dc7d7b1ad07f9b4218b42e27cbcc95" },
    { "HCDM.WAD",           "45d2e67eb438154e413a71891c226aaf" },
    { "HCMUS.WAD",          "2d79926c6937817b71d0bde517d38ff9" },
    { "HDLSSCRS.WAD",       "89d72fbde2a52e1dbfcd1f8a0bea3005" },
    { "HEAD.WAD",           "a55643df64fd43e8bf21115a0e58f565" },
    { "HEADACHE.WAD",       "1006f35e69dcc7293a3de507de36a583" },
    { "HEADBUTT.WAD",       "0c4f7114722fa9f28603d2fa599663c8" },
    { "HEADING.WAD",        "4fab853b4e78fe8ac8589e402dddf0c0" },
    { "HEATHEN.WAD",        "a46fff13f9167dc62d57eb92054a54f0" },
    { "HECTADM1.WAD",       "fce1162c4ee7bb58cc3eed9da77fc2cc" },
    { "HED2HED.WAD",        "f3367ef8598ef7048bbec23552ad8d9f" },
    { "HEDRON-D.WAD",       "ccfe3393622561ecd335de6f082f3891" },
    { "HEDRON.WAD",         "2c4c84acba71d6260a16f0afef1eda90" },
    { "HEH.WAD",            "82783a2e962b6188487c91ad8d64af3a" },
    { "HEH1.WAD",           "fe35edd6796759e71f476dd476b1f51b" },
    { "HEH2.WAD",           "d65622cf187e8bb9e88b523a798c7cfc" },
    { "HEH3.WAD",           "eeda0e3f2f01ffb41b8a3086b9a91b4c" },
    { "HEH4.WAD",           "b4b14ac9c7f2ce39ea33d122b8911f4b" },
    { "HELAV8.WAD",         "24bdfba77f19c6bcf2f73b314d0c1830" },
    { "HELCAVE.WAD",        "759673709f2cde120a8b3f844a965eed" },
    { "HELCOURT.WAD",       "51ed7d86f1bb1587a6367a4bc71c3d37" },
    { "HELHOTEL.WAD",       "067763650aa3777428d8faf44a7df089" },
    { "HELINHEL.WAD",       "62c7a961121a9979907c96d4292fe5f6" },
    { "HELL'S.WAD",         "5ceeb0e60180a9fe3d3d81536d7ee0d7" },
    { "HELL.WAD",           "3122ebb39b317bca572bed23c1058d50" },
    { "HELL.WAD",           "802f86965f94a08b159436bdee9cbdf3" },
    { "HELL1.WAD",          "3b43813b38cfd46fc0a43482d534f408" },
    { "HELL2.WAD",          "cf5e3670342649efb3916cae02797d66" },
    { "HELLAGEN.WAD",       "0a2b0d65bb1dac4d968d92bdcb2f9fea" },
    { "HELLAND.WAD",        "fcbd39680164e81b4c9bad575804d420" },
    { "HELLAREN.WAD",       "021d91ea127bc089a29c2c92186cb108" },
    { "HELLBATH.WAD",       "ac1b235a53efddc166816b035bf2df94" },
    { "HELLBELL.WAD",       "882d02a299be88b8102d3351ddf37b8b" },
    { "HELLBENT.WAD",       "90d5ca228e605c55835ad2afe546ec6a" },
    { "HELLBNTH.WAD",       "b7608878ad891dd600cc05baa2dca476" },
    { "HELLCAVE.WAD",       "baa05073f53bb976bb9daf744ce72553" },
    { "HELLCORE.WAD",       "a9cf938dfc6dc36b174b547e9edf19c4" },
    { "HELLDOOM.WAD",       "948719de2651e38628189bfcf2a71e03" },
    { "HELLDOWN.WAD",       "e6c4a930e2b574f6b95a93ccb9cd4ac0" },
    { "HELLDROP.WAD",       "1ec49f4b976b67018b39483b5380e5b2" },
    { "HELLFIRE.WAD",       "baee41f42b3490fed1a2d4a1c55703a6" },
    { "HELLFORT.WAD",       "d5b85ad1cbd097a185a72f19601a8165" },
    { "HELLGAME.WAD",       "5aa69f871425e70749e4bbe7cdde887b" },
    { "HELLGATE.WAD",       "69d0266e4ae5da40d875dae27066eada" },
    { "HELLGATE.WAD",       "8baffa42f338d9cfd8fe2a9a1d722c78" },
    { "HELLHALL.WAD",       "e54081ae825852edf8d913c5cbe808d1" },
    { "HELLHAUS.WAD",       "46fd6aa994f01eaf5d5aedd5f94be643" },
    { "HELLHOLE.WAD",       "06bcf0333b85f182efccf3c8d4156c94" },
    { "HELLHOUS.WAD",       "cc525b890545aaceda58a47685acf63e" },
    { "HELLISH.WAD",        "b9fdcca83ecaf7b5cd7cd345b808e58c" },
    { "HELLKEEP.WAD",       "89325176d7faef8b05e32d7c0bdb5383" },
    { "HELLNI2.WAD",        "367508623d6eb563c3d8bc03d93d418f" },
    { "HELLNITE.WAD",       "6e7a2738751b2f312f856e1d36f28445" },
    { "HELLO!.WAD",         "ee17b612a879a83fb33af91d91fbec05" },
    { "HELLO.WAD",          "9d25e6aca4ed1366a0423793e8e3f3ce" },
    { "HELLRAISER.WAD",     "3f75644b99c8f619162be1d4e63b12fe" },
    { "HELLSGDN.WAD",       "3d6357851d40e0cce9c00473164d11f1" },
    { "HELLSPEK.WAD",       "ce0e49f89d37511a7d385a627b234d10" },
    { "HELLV10.WAD",        "c864fb100d340e13455dfc6732b6fd6f" },
    { "HELLYEAL.WAD",       "19cf25e025f325729debb7661b7886b4" },
    { "HELLZONE.WAD",       "66f45b49af97af8e73860274a47129dd" },
    { "HELL_PIT.WAD",       "eb3bf5fadaf50646a8c6d35743c1e080" },
    { "HELRZOR.WAD",        "e8fe9db21b3f76a8ae865d0d2b6aea4c" },
    { "HEMDALE.WAD",        "81b1de04e72c19bd9b2b11824b2dfe28" },
    { "HENGE.WAD",          "4836abc7875aaabda119831b16905d8b" },
    { "HENRY.WAD",          "7ac9b27fe8b973b004925cfd0330fa51" },
    { "HEPTA.WAD",          "7c00bc77e68995fb8cc6551f2ee9a782" },
    { "HERO.WAD",           "ae01dc7105e197a60480b773c166bf66" },
    { "HEROES2.WAD",        "a6f09ad2dc57f196be4a305d1efa3780" },
    { "HEVYMETL.WAD",       "c8c5a532599a02c44b5f92d5b8058705" },
    { "HEX.WAD",            "508cd553a9a49162081ec2a246926b0e" },
    { "HEXA.WAD",           "d6027dbbda0c451c4b8313f7dbf211e2" },
    { "HEXAGON.WAD",        "237d59e8abbf7a25abfabafeee3679c7" },
    { "HEXAKILL.WAD",       "980a5fc6360d0a81de8d5e79cb9c1f4f" },
    { "HEXBASE.WAD",        "68af92abd4c0e7549ed36e15d9bc310b" },
    { "HEXDM.WAD",          "a113aceb929d7afc235a9aa6b00978e2" },
    { "HEXETH-2.WAD",       "0916dfba03b7157d7ea485deba53f964" },
    { "HEXETH-U.WAD",       "809296599f4d2ca311e1294bc3fb2542" },
    { "HEXNDM.WAD",         "ab9273a00a5529b98cb788c1256fced0" },
    { "HEXTEST.WAD",        "370380c6807316e8e6ac90e23d384c81" },
    { "HHFTGP.WAD",         "24ea2b5c118985ef11f83b7a00ff2abe" },
    { "HHOUSEDM.WAD",       "d6194690bbf508727ab7c2fa791acf97" },
    { "HID.WAD",            "b04a9ab0a0c703395c279853eb400e1c" },
    { "HIDE.WAD",           "e3342633d86b02c7f567ad0e952d4962" },
    { "HIDE4.WAD",          "4cd60df10e8cc06eed083bec43d9d503" },
    { "HIDENGO.WAD",        "6c9b7c5ab8a79aae0d1c30573d0c34b7" },
    { "HIDEOUT.WAD",        "6821702eef393c9823e12bfe8a7cbf38" },
    { "HIDESEEK.WAD",       "cf751c79b7c30d7fb8c5b6bbe98dc4bb" },
    { "HIDLAB.WAD",         "b8e467e49c58efb7503556d700ab7297" },
    { "HIDNFRAG.WAD",       "cacf09de78750bb43057bfa5d04844c6" },
    { "HIGH.WAD",           "8343c6666fe701cd2a754b13a4839407" },
    { "HIGHERV2.WAD",       "81f5206dc08e62a7d012fa1b758abf5f" },
    { "HIGHFEAR.WAD",       "38cc7152eb7cb8ed724658bcdd2e7e43" },
    { "HIGHLNDS.WAD",       "acd4c3a9d807614757ec25a7db4a2fbd" },
    { "HIGHLORD.WAD",       "63277a2c3b126b2d1d6768c6953e65b2" },
    { "HILL.WAD",           "64856ef31cbefa94fdf4688eb1b72b45" },
    { "HILL2.WAD",          "c3fd737975f20d9822c32e6cb66d9474" },
    { "HILOW.WAD",          "7188d4b2d6061cff96192c722c900994" },
    { "HIPAFRAG.WAD",       "391f2c73c02f30b8faf97181f860b75b" },
    { "HIPPIE1B.WAD",       "4dff84ed6bea455028983728424064fe" },
    { "HIRE8-1.WAD",        "29a0e64f5460185c0c69fcff722d6b33" },
    { "HIRE8-2.WAD",        "4a9132bafabcfd4fc490ec5d3f890547" },
    { "HITECH.WAD",         "144c985a7d887fd548aa10dd7f43d43c" },
    { "HITSS.WAD",          "3f9d8bd49de5eeb577e6f0894185d594" },
    { "HKDM1-6.WAD",        "2a2400842dc00ffd2ed949909930a0cb" },
    { "HLZWADZ.WAD",        "48ef5abb7571660426c9080b867dc604" },
    { "HL_OP.WAD",          "7b55cd5d5e6958f4d1e977d43d18e9fc" },
    { "HM2.WAD",            "337b8c5c674559bafd05869589209cd7" },
    { "HM3.WAD",            "bb477c6fc32784beb5b706bbe0c09f0a" },
    { "HMANOR.WAD",         "575fa1f98dda63383b737120cd9b31cb" },
    { "HMCELLAR.WAD",       "49a01b4361588ebcf1b892abd9dcd30e" },
    { "HNKSLAIR.WAD",       "977f898a5e15a768a95cc8568ce7e574" },
    { "HNO_EXIT.WAD",       "dc6a7b5c3ca7d80860e4375a2aae3c06" },
    { "HOBOKEN.WAD",        "0577574cbf0c445d92d6987cb4e400de" },
    { "HOD30.WAD",          "fc3728e1227762a746d37469fd07aa33" },
    { "HODM.WAD",           "c9fe9bddce4fba23e7913c0523aa8b4a" },
    { "HOGWASH.WAD",        "a109c08b8b133e78a43637216df12578" },
    { "HOLE.WAD",           "a152a8826972b343885f050f2ecebe61" },
    { "HOLIDAYN.WAD",       "e1723b9051ef5845207a61b74660d753" },
    { "HOLODECK.WAD",       "23645127494602882e4656b9a6ac10dd" },
    { "HOME.WAD",           "831ae69017fccc49518c4530a1a81cf2" },
    { "HOME1.WAD",          "4a88ca4de8f36261c14dfcd6f65cdec6" },
    { "HOME12.WAD",         "d97419bf07c9a958b4385e46a45fde03" },
    { "HOMICIDE.WAD",       "2c6a2a38f75183ec357233fa9c957ae5" },
    { "HONEY.WAD",          "e765fa4f307192edce572078ce4f3914" },
    { "HONGKONG.WAD",       "939ed115518184af6f468998110c85e8" },
    { "HOOKED.WAD",         "fdc1cb2b3252ac4023e5d4b9f0083c7a" },
    { "HOOVER.WAD",         "cbb41a77c52232c5c0e4f2fad9c0b3e8" },
    { "HOP.WAD",            "01344546788f388e69ce82a2f9ab0bd4" },
    { "HOPE.WAD",           "b3e38958c13e5f05d2907b89f4c3492b" },
    { "HORMELL.WAD",        "24832e20e4f0ff311c6e516278f16f93" },
    { "HORNS.WAD",          "8fb20b0505ae5cdc89d7fce584c83ba5" },
    { "HORROR2.WAD",        "92b824f5212ec1cf9847a4f1811f5e64" },
    { "HOSRTRI1.WAD",       "b26aa13ba887a6a7607e875eb18453c9" },
    { "HOSS.WAD",           "5f246d2f41d3451495f02fbf564d8262" },
    { "HOSS2.WAD",          "7a1b9eae1f78cc8bccd4ecae0816be43" },
    { "HOSTAGE3.WAD",       "5bcdfe05558c15f2f4523d3ee3763efc" },
    { "HOTDEATH.WAD",       "3228b90d07945762556f2d399a6344d4" },
    { "HOTELHEL.WAD",       "33b5e3228a03c5bc8cdf8edb7f41bd13" },
    { "HOTLHELL.WAD",       "f7d37ec8b467f6eb8e49070c47b7d0e7" },
    { "HOTPLACE.WAD",       "6cc75fc4432a2f304b1577df6aa265b8" },
    { "HOURGL1.WAD",        "3c00bebefee7153d8b9c77f308840154" },
    { "HOUSE BATTLE.WAD",   "78f4c5cd9359bf4d96c83d34af7bfde9" },
    { "HOUSE.WAD",          "2cccd834c24e3a9f52a583291bd3f7aa" },
    { "HOUSE.WAD",          "682bc52252a0f24fc8980adcccb6ca16" },
    { "HOUSE2.WAD",         "b9d8553b424d90b1082c31a84c0901a8" },
    { "HOUSE666.WAD",       "16e3cb1b18b91641b2421162c735bdc1" },
    { "HOUSED.WAD",         "b2145ebc00b3ad914bb2d86b50f7d93c" },
    { "HOUSEHNT.WAD",       "a17061b72a6fe9580f549a02baf3daf3" },
    { "HOUSES.WAD",         "ccd8e2242566318cd43d48c2475bdbdf" },
    { "HOUSES14.WAD",       "ecc59e5f2ee093686fc225c939008d61" },
    { "HOUSEYAY.WAD",       "bd00544b3793a85f69342ce89a6feddc" },
    { "HPF.WAD",            "c0cb1a588b4075e5bdff2f9f00af4f41" },
    { "HQUEST.WAD",         "ce893b849309034f03e2d23cdeb725e8" },
    { "HR.WAD",             "851717b89b3b22ab0dc8243c8311a9f9" },
    { "HRMUS.WAD",          "881e62704a574a2fe047b56437e0ef93" },
    { "HSG_0101.WAD",       "aede48773f8ef95d369fc679cb789cd9" },
    { "HSG_0102.WAD",       "dc9f02c1dc53cba09984fa8b8d6d0692" },
    { "HSG_0107.WAD",       "03bfd904fe82692722fed28d840067b4" },
    { "HSG_0116.WAD",       "e7d8ab581afb93c7decd66f615e33708" },
    { "HSH53.WAD",          "572d967ae41f24ce6f183494e5bd8a6f" },
    { "HUNT.WAD",           "12ce8b642b65dc34abb615ea30ed5e13" },
    { "HUNTED1.WAD",        "633d8e128eb7d3ced4e90d23709d8947" },
    { "HUNTGRND.WAD",       "ee0a2b2124e50e030caef20103e672a3" },
    { "HURT.WAD",           "73be43649c594472bd227930e1d6ae51" },
    { "HURTLND2.WAD",       "731a1d125df7dc94263126b978a7123e" },
    { "HUT1.WAD",           "8f5f068d817b1e46d7785f0fe4499e86" },
    { "HVYFGHT.WAD",        "2169ff31270a19796eed823baf6b85b2" },
    { "HVYGRPH.WAD",        "7d3345b82be6c347e5d6647c56cf62e8" },
    { "HYDRO.WAD",          "c132113fe673a1d6e30eff405d1312a0" },
    { "HYMERS.WAD",         "4c9ecc8096d09f95421c8d0de0da1827" },
    { "HYPER6.WAD",         "2933007620f23fa93c4752f952817e03" },
    { "HYPLITH.WAD",        "ca4527b2c73de9695a3094558f1f61e1" },
    { "IC2001.WAD",         "fa2e8d51967fd1cf59e3fe04854ceb39" },
    { "IC2002.WAD",         "81d70b995712b0deee84ab93ed08cf1e" },
    { "IC2003.WAD",         "385927b261ff334987988bba1823200f" },
    { "ICDM1.WAD",          "9afd33d21b6dcd5bbacea5ac1471024e" },
    { "ICDOOM2.WAD",        "c917c4b668a4b25217efddf0aaad0a0c" },
    { "ICEDEATH.WAD",       "1284294c77c1cf8c952183382f2e5be8" },
    { "ICENITE2.WAD",       "a07ae66b21dc7ae94383c9a7a6a652b4" },
    { "ICU02.WAD",          "1f685b87195da25b027356208ca9b0bb" },
    { "IDDAD.WAD",          "3e7b34be5c3c2ad9c9f0f3cc2b234047" },
    { "IDEAL.WAD",          "e94c21b4daa8da7ee815a9b87eb9891b" },
    { "IDETH01.WAD",        "d36b6c94b3757af4b7a9658063648735" },
    { "IDETH02.WAD",        "46630a71b1dbf78822bdb8b329dd4975" },
    { "IDETH03.WAD",        "ec719da0b6a735c3438c6db916ccc457" },
    { "IDETH04.WAD",        "36899b3c215b6f7e3a40c5b48a24a544" },
    { "IDETH05.WAD",        "addbd24653209c7e5b3d99784a4fcaec" },
    { "IDETH06.WAD",        "4f1f9a770d5fda6cd02afd284ad695c5" },
    { "IDITAROD.WAD",       "5d78f286b2e2f7a90855af602b056519" },
    { "IDMAP01!.WAD",       "b47312dc108175700faaf09cef318c7f" },
    { "IDQUALDM.WAD",       "e5991fb62cdb4c39012af9ea160c3724" },
    { "IGOR9.WAD",          "83166324ff8622a6671145e15170e774" },
    { "IGOTABIG.WAD",       "46addcb1db1a7a7d07b98166071bd5ef" },
    { "IKBROWNY.WAD",       "d2cea12bf4481a39f2b0ff081822631f" },
    { "ILLNESS.WAD",        "f0f9b3b381c7788bb8e7430da7d0dc9f" },
    { "ILLUSION.WAD",       "35b63b8926ff1a864b71c3b0ec5944eb" },
    { "ILOVEYOU.WAD",       "052e3bdfa90931a59686eb8659e6a86a" },
    { "IMAGE-2.WAD",        "ea130517d8e21a8502dcd3dea1f53971" },
    { "IMMORTAL.WAD",       "2d04790366c9178f14181c287d407412" },
    { "IMP.WAD",            "71d1691c38d87b675380a985c22966bf" },
    { "IMPERIAL.WAD",       "15874a2ba8e591c34be3c19a895bfaeb" },
    { "IMPGOD.WAD",         "028d8adb5f4f25ad6da8cd538705a2aa" },
    { "IMPIRE.WAD",         "51a4a022e222c6374ea03d72e553f3db" },
    { "IMPNDOOM.WAD",       "de2baff48baacc9308ff832014734544" },
    { "IMPO.WAD",           "555e27f5addca14a925fc9fb80c88e8e" },
    { "IMPULSE.WAD",        "bd1d3b69668a30fe11cfa84fbb242c86" },
    { "IMS.WAD",            "a40800139c44e2af6e7c86ea74e556a6" },
    { "IN.WAD",             "0180a9e7b871d29397429b2453f79f9d" },
    { "INDAFACE.WAD",       "eea7ea8e4215d96adfc473c791eff178" },
    { "INDIGO.WAD",         "10178c3d48c7807c49486c5a93256e48" },
    { "INDYJONE.WAD",       "b52e8cd168fe16519b7c5229eaba4ef4" },
    { "INFECTED.WAD",       "61372d1a65e0418350ce8aaffc6ab48b" },
    { "INFERNAL.WAD",       "5ef84854b3d55f888269971e2fc5110c" },
    { "INFERNO.WAD",        "df405fd70ba99df6357bf4605130bc82" },
    { "INFESTAT.WAD",       "cca16583daf5e451458bb1fca93081e5" },
    { "INFESTO.WAD",        "a09ffb94d17e1f2edd8a0c5e4b28fe5c" },
    { "INFILTR8.WAD",       "693dd9e7c5f17c5cade9f8764e89f5d3" },
    { "INFILTRN.WAD",       "0dbbc681f589a405c409fe3992d7746e" },
    { "INMCORP.WAD",        "446190fa07e792bbf37c5364e7ee3fba" },
    { "INNER CRYPTS.WAD",   "a65a21c99a9105bec073cffd9e040aa1" },
    { "INNER_O.WAD",        "91b2a9084e5002d1b71e50ce85b55dc6" },
    { "INNRGATE.WAD",       "0f55ac10584204e1819b9ba8a714c2bb" },
    { "INSANE!.WAD",        "9a15b01265bf0f148277fc07c4ff25b7" },
    { "INSANE2.WAD",        "c1b6d1cee8cac8a48906ae157bf20c3f" },
    { "INSANE3.WAD",        "7a2d6f9ce77cacdd6d57cc0088a0bd91" },
    { "INSANITY.WAD",       "0e88315cffa9d272c75231edcbc4a725" },
    { "INSANITY2.WAD",      "33fe66d585a2198cc5837540b00e8db9" },
    { "INSDEATH.WAD",       "5034beb77a3c4e7b349efe572e1362c1" },
    { "INSECTS.WAD",        "73cf9ea313d060bc8d002cc333a3aa0f" },
    { "INSRTION.WAD",       "d99a887f8b155490cdf6636f47eb00e3" },
    { "INSRT_01.WAD",       "91cb3418dd39cd8dd54c6d876a82f298" },
    { "INSRT_02.WAD",       "9ff93694556faeac4d92da9f1959bcb7" },
    { "INSTANTD.WAD",       "6b0bb72c99e81c4eb4fa55e662e86af6" },
    { "INSTINCT.WAD",       "eab8c9e819cf1ceac44954829db103ac" },
    { "INSTINKT.WAD",       "c65adcb541adb8f2ad747dcc2b2c86e9" },
    { "INTENSE.WAD",        "00e9c35015eca23039e9ad71c557b8df" },
    { "INTERVIL.WAD",       "3ed6bdc669f5e9e2782f5e51ec4aad2c" },
    { "INTZONE.WAD",        "608ddc23e8e58fe97e3d530047098e63" },
    { "INVADERS.WAD",       "a85871e1d88f47294b6430014cca06ac" },
    { "INVADGFX.WAD",       "2bc18218b97060e0abd55196e7f6489c" },
    { "INVASIO2.WAD",       "f2b370e16481a10fcb106af854184a50" },
    { "INVASION.WAD",       "775b48d23987f9ba067ee8caa04a3853" },
    { "INVMAZE.WAD",        "c305ea3ee86d7f27d5b09d6120c1b1c4" },
    { "INVSIEGE.WAD",       "c90aa73fbb7c0286b38c2651b14bb2cc" },
    { "INYF_DM2.WAD",       "2c5d13a15992ae47dee603a8e8db2d05" },
    { "IN_HELL.WAD",        "47bb81d1289b54db1593e6d0918da25f" },
    { "IPRAY4U.WAD",        "055c161c8d421fd93e289b54e765ad5d" },
    { "IPXDEMO.WAD",        "6350a5039db994f2893f0ccce32c28f6" },
    { "IPXGFX.WAD",         "983efc2d39d382d6220e5ffbae214201" },
    { "IPXLEVEL.WAD",       "401e84b4f6647f02ac6e6b3e3756c048" },
    { "IPXMUSIC.WAD",       "737dbdf9ff15c1b625d9054787c1db10" },
    { "IPXSNDS.WAD",        "eaa227d8db51ce5ce5eefa147c681b4d" },
    { "IPXSPRIT.WAD",       "3614b532dc1f63dfce1292efd1b3c6e7" },
    { "IRONCRSS.WAD",       "d4cdd1915adce896ef16983ff706e428" },
    { "IRONFIST.WAD",       "67faaef1b037a3b8a5096526ffc14e68" },
    { "IRONHALL.WAD",       "79e0cd56a92ac7be8ce5961dc1460d6a" },
    { "IROQUOIS.WAD",       "474068b744926c7f41f037ec5ea1e815" },
    { "ISEEYOU.WAD",        "9dcb959aab61f21a57c0cd0ffa24bf23" },
    { "ISKP.WAD",           "1b008deb97769f1c36005e1e7d112cae" },
    { "ISL.WAD",            "3d6d2aff7427a6f3af636979fe94be4d" },
    { "ISLAND.WAD",         "d7d60bf427d80cff8fccc023791b0549" },
    { "ISLANDX.WAD",        "7ad41f5ee26793b360f86dee93eacc4f" },
    { "ISM.WAD",            "e40bcfed141b77012c154607f7114092" },
    { "ISRIQUSU.WAD",       "2e983e3f16eb4daab47e3cfda5d659fa" },
    { "ISTNBUL.WAD",        "d5505ad9c01f5f70f20bc74f3865ee33" },
    { "ITHURTS.WAD",        "e0267a835c7cde9afde4f463ae8efef1" },
    { "ITP1_V2C.WAD",       "8aefcc580f3d685fd731f5a5d43e23fc" },
    { "IVORY-DM.WAD",       "8ca9993b28ceac455bab2eb71255d882" },
    { "IVORY.WAD",          "4956ea3f7da3fdace9e3a5fa2790aff7" },
    { "IZ.WAD",             "092d60b05cc563a12dbc9183153ab0d4" },
    { "I_DUNNO.WAD",        "6849608950c48444a434a46f7d4fe014" },
    { "J2DOOM.WAD",         "3ffb2e0a2835e48f09505da999736e0a" },
    { "JACOH.WAD",          "53081e1e5f489262af65f7bd8b515600" },
    { "JADE.WAD",           "d3543b768e8431c0cd96365c755ac09b" },
    { "JAGEDG01.WAD",       "6828f634467d5d77570837987fa03cbd" },
    { "JAGEDG02.WAD",       "70c77bfd01d7bae7beec8977615e1289" },
    { "JAGEDG03.WAD",       "c6e13a0c9b3062ee464f36a0fd47f5c6" },
    { "JAIL.WAD",           "5a1362e5f74f109917bd2c150a6ec776" },
    { "JAILBRK.WAD",        "fff70247fbac861fd5e500bab98fb717" },
    { "JAILDM1.WAD",        "7412d6333b2796bfc12251ce9ea55c8e" },
    { "JAKOBS.WAD",         "62174026a1c692ec3cdb55d528f69b8a" },
    { "JALLA10.WAD",        "3e8baf541756c119222c9bbda109513c" },
    { "JAM.WAD",            "20913d5f137b67823c17b3184aa3967d" },
    { "JANTOM.WAD",         "4669c032a0652c0621d2ea9189cf064c" },
    { "JASON1.WAD",         "f6eae563a60affad22facb6a9fe513cc" },
    { "JASPARS1.WAD",       "107b615be0cc3b3c3afdcbff606191c6" },
    { "JASPARS2.WAD",       "44551b94830800681d568e3d53ae4989" },
    { "JASPARS3.WAD",       "23ce7af21597590980abf2839bb4f146" },
    { "JAVIPIG.WAD",        "da6eee6005c32bf6a531f8b433e25330" },
    { "JAX01.WAD",          "c99d70583e488057aed45b35765f026c" },
    { "JAX02.WAD",          "3fd6c42aa4f666f31731f7bc9d74e50b" },
    { "JAX03.WAD",          "936b98cb140cbb95e60a0e54961a7111" },
    { "JAX04.WAD",          "3ccb503505e42d077a205fa1c5204dc1" },
    { "JAX06.WAD",          "1415ea54c32413db674b1696e81c4494" },
    { "JAYS.WAD",           "7e85c24054bf8015482fce677cf5a232" },
    { "JAYSWAD2.WAD",       "c89988016b013fadd7bee10097866bdb" },
    { "JAZZ.WAD",           "57622f9618a189a2001e8d18495771bd" },
    { "JAZZ01.WAD",         "6d96329235afc1598ac7337e56d5f36e" },
    { "JB-BERFT.WAD",       "559b48132b2b8444964cdecf2d494904" },
    { "JB-DREAM.WAD",       "0aa84200ec07684fdfa0e413f19f53f3" },
    { "JB-HOUSE.WAD",       "b371096a383760674050dcb2f4f75c83" },
    { "JB-RECES.WAD",       "246a2d5a8301c14a83dcda6fc31a0c16" },
    { "JBASE1.WAD",         "eff63631d8f67923c1b74029898e7b4f" },
    { "JBM5.WAD",           "1530e3848ea2e6dafd16510994c06bb3" },
    { "JBMDEATH.WAD",       "2798d66c6089e71f9eac4fb733f1cb56" },
    { "JCHOUSE.WAD",        "90597ba35e0d9c2859eaeb3beace4167" },
    { "JDGMTDY1.WAD",       "80f0d2723608855e2165a62d9830b267" },
    { "JDITXE.WAD",         "10b48d9c24fd489ced749491e1d187f6" },
    { "JEDAI-1.WAD",        "5f67f9f9b34aa1f3e4ecabb82b89f303" },
    { "JEFF'S.WAD",         "9066bdbf09826c23bb43dd72509c8466" },
    { "JEKYL8.WAD",         "8086fa81097b6b648e83b4d60da316eb" },
    { "JELEDETH.WAD",       "b0208e6676a023a38f6d3a292bc01a40" },
    { "JERICHO.WAD",        "3f4f5618a4b24f6b9d51e2f551cba46d" },
    { "JERRY2B.WAD",        "d1393013e78892261b31616421e86748" },
    { "JFDM1.WAD",          "3f1c13d38a4b2f7b89cfbb58bd4c8617" },
    { "JFL18.WAD",          "50c2fca7188025e44a335513441f3168" },
    { "JFOLLY.WAD",         "80804074dd0a504708d8e4a0ee233a20" },
    { "JFW.WAD",            "631558fb5dbc87749eefbdfec732678a" },
    { "JHDEATH.WAD",        "601eb8fb9f8bad0fae90d1b3ea2e864a" },
    { "JIBBIE4.WAD",        "d1c59550cec470e23830b847e410d742" },
    { "JIGGI.WAD",          "0aff29a1a98da210671440136480ced1" },
    { "JIGSAW.WAD",         "ad46914577c5d9630372dfc24360804a" },
    { "JIMMY.WAD",          "aed9246c8d7ceb66424856b2da316fea" },
    { "JIMSTOUT.WAD",       "f506ddbb1342c45b136f50c6fe23f65b" },
    { "JJFLASH.WAD",        "6a26c4d70462d130b891a914fe23693f" },
    { "JKDM11.WAD",         "6bbe9fc0c6dd128b05a063f0721ac161" },
    { "JKN20EV.WAD",       "5f7d6b3335ca48966872677ccb031c69" },
    { "JL2.WAD",            "ea0b28c16983f11314681090c415d0b9" },
    { "JM.WAD",             "ffa84b24c784e7f2cd0189b22cbd8a14" },
    { "JMOCTADM.WAD",       "de014d7d64b6d5ad101122a6846b135c" },
    { "JMPDM2.WAD",         "b23f6d9d670caf210c868a6cd1927095" },
    { "JNGLFVR.WAD",        "c504cfb4493698ff74ec1c136b3c6966" },
    { "JOJOBEAT.WAD",       "8ad79df71e62c361173849cd6def0a43" },
    { "JOKER.WAD",          "240e701850bf06bdbb792a61e4061032" },
    { "JOSE.WAD",           "6edc3858126439abe19a9a3e43d6dbd8" },
    { "JOSHDM01.WAD",       "b24cdde9cdb7fc1cb0d36487a0cecce9" },
    { "JOSHDM02.WAD",       "76a9ad51338c067d30c3faaafeee8135" },
    { "JOUST.WAD",          "64f9fad4fc9a692545e0a33a86b9f498" },
    { "JOW.WAD",            "39f2095f580244339935937dc9619b37" },
    { "JRCOOP.WAD",         "61f2ec96f8f3ea453be35148ae857ad8" },
    { "JSF01.WAD",          "e0e7db3175f9c78f1568872bce2cb7e0" },
    { "JSJ1.WAD",           "5b5e4a23745144bd67270ad1e5037301" },
    { "JSPD1.WAD",          "d90bf83ca6f202fea967b864c6831c2e" },
    { "JUDAS21A.WAD",       "ce390dcb54f3a47e1c2661c3a9334018" },
    { "JUDAS23.WAD",        "37afda7a49e02d9c70c76203c3820670" },
    { "JUDASP.WAD",         "6e68880e6f2de1929d9cfaddeed9e28e" },
    { "JUDGEMNT.WAD",       "c130d7c75dc57787e1e6763a4f0184eb" },
    { "JUENTE.WAD",         "10cf9bf19e130e0b3b465b914bf56277" },
    { "JUMPER01.WAD",       "d046d85cb6615117924137ccbd89abc7" },
    { "JUMPER02.WAD",       "a06cbd2ad8a8c994701825eb2c376442" },
    { "JUNK.WAD",           "2f5ca5f1335913322e80dc276fd05529" },
    { "JUNKYARD.WAD",       "6efbd6b07bc40505e3439928bcf5216a" },
    { "JUNKYRD2.WAD",       "cf2e2c5578a36897dca4caebeef93315" },
    { "JUSSHOOT.WAD",       "a2cd91cd4228ddbfe30a1720ee919fa4" },
    { "JUSTDETH.WAD",       "ab5dd160dc3df213583441823ecf6ada" },
    { "JUSTIFY.WAD",        "a98e759824ea46be52b535972be116a3" },
    { "JUSTIN.WAD",         "32a07e3deb932b3a96a394f809bed3a0" },
    { "J_BEAN.WAD",         "32edb5717e1195bc1550bd0c2605cab2" },
    { "J_CRUSH.WAD",        "3d24292b843206a009d4497389d86ead" },
    { "J_E_B.WAD",          "38e90263179249a81a4c3d646d8974d6" },
    { "J_ROOM4.WAD",        "1af4c35f778f722f0b898ab3cb22b03e" },
    { "J_ROOM9.WAD",        "cfcfdbf4cb515b8851842227c77318e2" },
    { "K2.WAD",             "8a62e43e7eb02e6caa8ec6c60122919e" },
    { "KA2JT.WAD",          "93bf2e04415920488c9fb927625c2f6d" },
    { "KA3.WAD",            "acf8ae738f87f13555fd9286fb25246d" },
    { "KA4.WAD",            "b280cbdf59d6040389e6762a14607b9f" },
    { "KA5.WAD",            "df8a81b99ebf0f0c9d02704dbdcbd908" },
    { "KAHUNA.WAD",         "d433253848692f3d79a8ec7d5f1f87c5" },
    { "KAIDM.WAD",          "4b282d3bd6a7b09910b7111156a57d46" },
    { "KAISER_1.WAD",       "9b59e3d828e10edaeb60887a4c373378" },
    { "KAISER_11.WAD",      "5266358fc5018e86da69758a52924269" },
    { "KAISER_8.WAD",       "c76473dd533e30afb2a12baf73a1d016" },
    { "KAKOKA.WAD",         "ba8b292c797e67418b0e6cd605c79f78" },
    { "KALRAC.WAD",         "46bad562f0aa4a883cc61302a6bfe003" },
    { "KALRAC2.WAD",        "f621ff671547455ad399cec7f4ad9c53" },
    { "KALRAC3.WAD",        "b5c6f1e5d716f8436dc3ab15be54f6c1" },
    { "KALRAC4.WAD",        "e55e2d80ff84eb26be28f07a03725c28" },
    { "KALRAC5.WAD",        "3bcfff80e29692666df27ce95b5c0923" },
    { "KALRAC6.WAD",        "ca194c393cae19b696ac55a44b83897a" },
    { "KALRAC7.WAD",        "056b075bab6cf9980696833d9d4adad1" },
    { "KANDY.WAD",          "37f931364f036a02c829dafd31233e41" },
    { "KANDY2.WAD",         "f7d1c7b167a8defce9fdb6dffc57269d" },
    { "KANDY3.WAD",         "64dc78484c4d8a1d9fdc41d30a9a62a1" },
    { "KANDY4.WAD",         "89d58ce7daba8c93659c35b992d828a1" },
    { "KANDYGUY.WAD",       "f11f03ccfff9c03614a8e8f72be1e242" },
    { "KANEKO.WAD",         "7ae6372ac6e6b96f8424cd95c09b4c6b" },
    { "KAOSWAR.WAD",        "84c7e53ebac9c26707e91ba439b1d065" },
    { "KAR1.WAD",           "b6ba6145d246c444d752c8472034e243" },
    { "KARMEA.WAD",         "88e78148398553a11b1eb56bcbd5c0f1" },
    { "KARNAGE.WAD",        "bd4e0cbfa61d0aade33d5af504eb8e7e" },
    { "KASHMIR.WAD",        "c496386b7d4152e464d06b76c8f8942d" },
    { "KASM.WAD",           "61dad3100596fef6a58a298125979945" },
    { "KASS_DM2.WAD",       "e324890aa1d42881d5a22541b41f3ae4" },
    { "KATY.WAD",           "e41e2c62a3dc8ec69f0484bf521b8b08" },
    { "KAZARENA.WAD",       "491de5bc5e521fe13342db56d637014d" },
    { "KBASE_3.WAD",        "af7d82b6d2adc8ff0b5cd2c3cc1bd2bc" },
    { "KBASE_V2.WAD",       "061de584171ca3758a662dad87a74e61" },
    { "KBRICK.WAD",         "247ee4328d5d4139a9abc02c3a1eb81e" },
    { "KBRICK_2.WAD",       "3de643dbf5965c9f1b6effb89f2b000c" },
    { "KCF2.WAD",           "61dbb77a48a6d461934c30d83b205b1e" },
    { "KDAVR.WAD",          "0fc0adb853d5a55191dcd661caa1d625" },
    { "KEBTOC.WAD",         "757422db8106da8093fcac4e8a967e6b" },
    { "KEEN.WAD",           "a833642eabbe42be93216d1b9e33e7c2" },
    { "KEEP.WAD",           "c2bd49941c6790395e396baa472c9c82" },
    { "KEEPMOV1.WAD",       "01ef2aa0e57e95a2f5beaad4b7b67540" },
    { "KELLY200.WAD",       "af2ec49ca0123e90c60fe8795014e4bf" },
    { "KEN.WAD",            "3ca999847e64f844ee880606dffe8693" },
    { "KEN4.WAD",           "5e03009ca1e7285ba3b54e89fced6845" },
    { "KEWL.WAD",           "af1a7f50ff6eedbcd411cca1f97774dd" },
    { "KEWL2.WAD",          "f0e9f54a2356d3b5a8f2c6d566522a1f" },
    { "KEWLIO.WAD",         "2adc7b38d16bb48192dfc5428c0520b6" },
    { "KEY01.WAD",          "a1caaa3be88127a15a1b88987116bb61" },
    { "KF_GNTLT.WAD",       "8470585e137d8310212099a110f6659b" },
    { "KG.WAD",             "72782003f79575eda635e26920dcfe93" },
    { "KGY2.WAD",           "0138dae6a2cb5cae7574cf38f678eec0" },
    { "KGY2_DOOMSDAY.WAD",  "31d4366520a8007ee33a36aa836afdde" },
    { "KICK-ASS.WAD",       "ef94419038b5c59efe55f6d15db81924" },
    { "KICKIN.WAD",         "66375c8a51dd3b61ed13c5fe3a014fa1" },
    { "KID.WAD",            "5a42494cae67cae6dc60ac5ce71b1794" },
    { "KIDDY.WAD",          "c8b98b0c19b4e7260c379e2218dea115" },
    { "KIEV.WAD",           "dc32e1c39c2efd1f32b8e83bc4d7b091" },
    { "KIK16.WAD",          "63a3c5b98b5218cef479172b526aa04d" },
    { "KILL-1.WAD",         "0deff0d04fc3559194d63e0f6cb59601" },
    { "KILL-10.WAD",        "d7107a6140a828b4667ecc8b5e0b7cc6" },
    { "KILL-12.WAD",        "963405bf349e1bd7be2338f488c38616" },
    { "KILL-12A.WAD",       "52631fb961a36fc67160a7d481ff17e9" },
    { "KILL-17A.WAD",       "491c586e3dd79920e4a572e6b6cc6269" },
    { "KILL-2.WAD",         "2f2bab566f01182ba32ac94afc7dad9f" },
    { "KILL-3.WAD",         "d08bacc8be099fe9cf3ad1e1aca81e5d" },
    { "KILL-4.WAD",         "93cadbdbf2c8c29e84842cd40797eea0" },
    { "KILL-6.WAD",         "842c758a856ce324417daddb4f5d4938" },
    { "KILL-7.WAD",         "f41350b4ab6f8bc968096bbd54b2ec29" },
    { "KILL-8.WAD",         "166c06bb42353cd5bdcf0a41d5ae222d" },
    { "KILL-9.WAD",         "fc7d7ef19aa4e267415300824538673a" },
    { "KILLALLA.WAD",       "65ffebc59071dfa43899ec27b7deab71" },
    { "KILLEM.WAD",         "278021c135569eddb7ddd1285db6f36d" },
    { "KILLEM.WAD",         "eedd47ac6e42e000be42a3a3c1aca7b2" },
    { "KILLER.WAD",         "d17b6925686cda12fea88218357d8337" },
    { "KILLH.WAD",          "92861f969df36e451a5e9f51bcc65b5f" },
    { "KILLJOY.WAD",        "34e963c0a9195d718eedce50fbae0017" },
    { "KILLZON2.WAD",       "29d5c41b1d37199e110927c99d327896" },
    { "KILL_2.WAD",         "2e8517502bfce8d6153366b13b25dcd7" },
    { "KILO10.WAD",         "1bab9ffd09be09e9e316360639a80159" },
    { "KILO11.WAD",         "2e45a069dfcb6977af4da9a11ed647a5" },
    { "KILO12.WAD",         "fed6cb13dd644fb96fc522c6257232ce" },
    { "KILO13.WAD",         "1ed14fc145e504bd30f9336d73a520a3" },
    { "KIMDM11.WAD",        "b8071cf6054f71d0006556e4b7497845" },
    { "KIMDM2.WAD",         "b3c4d94a645d11adaf86ba15ee6c15e1" },
    { "KIMDM3.WAD",         "b98df53128908afccf340c09d3d2cbdd" },
    { "KIMDM4.WAD",         "69fba7a7141d07c0f493fb57c2c5ea40" },
    { "KING.WAD",           "d5838151c865caec288f2a9cd7e1bebd" },
    { "KING1.WAD",          "a675ccd9d4e86a63b8f27efba8e5d521" },
    { "KING2.WAD",          "d530e0e2c3af73266838193945d63f06" },
    { "KING3.WAD",          "5e48d94b7dde84a509d18241a3d1d550" },
    { "KINGDOM.WAD",        "bfd7d99301e5a2d08de95d2971a46bc5" },
    { "KINGME.WAD",         "4d8c3cbec31e6326cfacf005a8223514" },
    { "KINGME_2.WAD",       "a7db731b10d7836017957dd9468138a9" },
    { "KINGOFP.WAD",        "7a86c0aa74f8fc0dfd9a8aef03249538" },
    { "KINGOMTN.WAD",       "4e52c03c16f73744c743a896ac5c5b56" },
    { "KINGPIN1.WAD",       "b1470bd193df4ec1bd00683059dc8905" },
    { "KINGPIN2.WAD",       "30d5500cab4e1b86077f064f536ffcbd" },
    { "KISSIT3.WAD",        "7f481a80863b58327345767b7a56d557" },
    { "KISSMYCH.WAD",       "cda30d1debd688558ecd83f8bfad22f8" },
    { "KITTYDM.WAD",        "5dc2ffa5c67fcec1aeb2a4c6d113ef53" },
    { "KK-BUILD.WAD",       "df33cb0cd27feaace9395d4f1b8f7cb0" },
    { "KK-SNIPE.WAD",       "be906b65943dd0c25f843ff80b4042a5" },
    { "KK-STAIR.WAD",       "ce4f4b5fea47c2ab43f2d919f6a9af04" },
    { "KLAUS1-1.WAD",       "127d10ee619e8c6719556e0ea479caf3" },
    { "KLENDATH.WAD",       "c369ccd674f35b12c9da628258ee5969" },
    { "KMEGA1.WAD",         "60dfd705cc48248ca30fd4f13c0696d8" },
    { "KMETL_1.WAD",        "246c570e1e434b1eb9ab66e6d36ab41e" },
    { "KMETL_10.WAD",       "2ce4f9972618c8eef82196ef36d285bf" },
    { "KMETL_11.WAD",       "3abfde49f71cd098166923fe591404de" },
    { "KMETL_12.WAD",       "fa83df339c9cba37466b2d2555eb7eef" },
    { "KMETL_13.WAD",       "459ae0e7a13dca167840684f8dfcdeb1" },
    { "KMETL_2.WAD",        "405390694f163b5e09411820df3725de" },
    { "KMETL_3.WAD",        "f6c52c212a262ee57f22cafb49356bba" },
    { "KMETL_4.WAD",        "5d66158f8e1127c9bb67deee9e241b8c" },
    { "KMETL_5.WAD",        "cc878420039743b2869aed8fb7419f74" },
    { "KMETL_6.WAD",        "2ce347f8a3d2c4fd43f9e57bc794c966" },
    { "KMETL_7.WAD",        "126be81d04f29fe8eddca776ba8b5a72" },
    { "KMETL_8.WAD",        "a19bba0dea1d0a2608e73f3bcfe1877a" },
    { "KMETL_9.WAD",        "4ea0c59651e7277b7097d9593c18eec0" },
    { "KNOB.WAD",           "dc660d4b3f62cc3c70cb6dec0a828b0e" },
    { "KNOB2.WAD",          "f3839e2393138551a9fc928f40901b21" },
    { "KNOB3.WAD",          "1c58a54e5fd48589099cf1eac5f64117" },
    { "KNOBSNDS.WAD",       "0df472f90015d9fe90eb629c5dceac21" },
    { "KOD.WAD",            "76bae1dd16a5b0a143206a379ba64d76" },
    { "KOEBRAH.WAD",        "f22350c51a577fd299f4187a1174da48" },
    { "KOHE.WAD",           "1a21f984f9fe1faf48a519e1aa76079e" },
    { "KOHE10.WAD",         "97e98cb3863a69a5670181fa65363e74" },
    { "KOHE11.WAD",         "0308cfa937ef966a1fc8397e641ce396" },
    { "KOHE12.WAD",         "92747d9b602db06e577cc29a6c0b1cd5" },
    { "KOHE13.WAD",         "48efe5112a49e45543c02b3deab672e4" },
    { "KOHE14.WAD",         "e12e71706070712ecd3c9bc2f376c6e6" },
    { "KOHE15.WAD",         "73c2477fb8f6b9201381376fc0824f22" },
    { "KOHE2.WAD",          "950cc954e26105598ac5356b322a6779" },
    { "KOHE3.WAD",          "b13a783a28304cd9987ed92af54fd8dc" },
    { "KOHE4.WAD",          "cfac51a9eb18c6f134d7fca6e5669385" },
    { "KOHE5.WAD",          "04aca25a0d4c098d2d44a5e4111d9c0a" },
    { "KOHE6.WAD",          "62d3f4a6554d923ec8291c81e707c1a3" },
    { "KOHE7.WAD",          "65d7c93713164678ed64b9bb9793ca94" },
    { "KOHE8.WAD",          "ff66ef09736de24fc15c4ff3dc5a4d49" },
    { "KOHE9.WAD",          "b5c4982e73329cf6497787ad61cedf9b" },
    { "KOKO.WAD",           "aed2ed449444c8e63ab2d82e82197e1f" },
    { "KOMBAT.WAD",         "41f53546796a8c681ed43953490b923a" },
    { "KOOLEST.WAD",        "e25bc7dbd5d374bac5a88bb7ef7bdec4" },
    { "KOOSHOT.WAD",        "aae2058056be42f737f477a790f7eee6" },
    { "KORTYARD.WAD",       "6ba5e966f0f0a1a897c36f7ec80968e1" },
    { "KOTH.WAD",           "8c11826c57fd0def0ef40689d8351e4a" },
    { "KOTM.WAD",           "55c8896813aa8228d5df8899fef15da7" },
    { "KRONIKIL.WAD",       "197df3451a520861f63da87b496c2368" },
    { "KRONIN.WAD",         "a4f26f511b084ca7c3c9a9ae7e116de1" },
    { "KRUX.WAD",           "e46a7b4ecc1fc5eb114aeeb5ad451f47" },
    { "KRYPTON.WAD",        "eeb341f2878f688b92c4f27e65ce0405" },
    { "KSUTRA.WAD",         "f22f25af9ba8c55a0e3e26de68d9b467" },
    { "KTA.WAD",            "4906deb4e7e5c77d0ee085eabd27a69e" },
    { "KUNUN.WAD",          "7cc6a8976a097bbd833643c385882556" },
    { "KURFHSE.WAD",        "777a7198f09ae5886551d67d146fefaf" },
    { "KV5.WAD",            "a38ca43852b736b352180a31ad20b79e" },
    { "KWFRAG.WAD",         "14398ef3d569cb38e341b7c4ebc60826" },
    { "KWIKSWCH.WAD",       "388b4975115c9bd8a3dad969b2d8b615" },
    { "KYE.WAD",            "71be51501dcbba5920a9fd66956dcbf1" },
    { "KZ#1.WAD",           "04e9dd8c1d5ce7c99028f4085b5808fc" },
    { "K_BASE1.WAD",        "3acfa79937938ec120a3ee2d0c8a6cbf" },
    { "K_I_L_A.WAD",        "b45d00a981907a24b0f4a94cbfb59762" },
    { "L03.WAD",            "3f4b538bdb0f30bc725cfa33a1f32065" },
    { "LAB.WAD",            "4c0e11a0862c1266bae58d82f76e94b4" },
    { "LAB01.WAD",          "294973a2ffbc17f1b37754afc22ce969" },
    { "LABDOOM2.WAD",       "d519b42028d9079d8fa61ff904537dea" },
    { "LABFRAG.WAD",        "cd9fb77cf615e0f9b1c8ff0b0b3f7b6c" },
    { "LABYRINT.WAD",       "3736c0ea5c06ee3f43dada4cca078f91" },
    { "LAIR2.WAD",          "712cd8b5fcb6938453a7af4320f47f2a" },
    { "LAIRGFX.WAD",        "c3e38b009de742347ee8f22cf7b1cf4f" },
    { "LANCE.WAD",          "ea4dcfce0c6d9bbc42148c4391f95230" },
    { "LAND.WAD",           "5d6c2d5456ec3142e61158319f4fcd6f" },
    { "LANDLORD.WAD",       "40b87966d39379ebdc7bea6ca5f47619" },
    { "LANKHMAR.WAD",       "838f4e7d104d54b068728be133f847ed" },
    { "LASERQ.WAD",         "4b7b2e35b37f67669cb64723f8ad8548" },
    { "LAST.WAD",           "ffdf776834c65a4f3919a0e4b68d8502" },
    { "LAST2003.WAD",       "184cec71dd65110800b0abae55663963" },
    { "LASTFORT.WAD",       "3872c0564f82c5b345ca5e9b1cf2095e" },
    { "LAST_MISSION.WAD",   "1a5737d52b3a8c41ca5b9744e7b1ac0e" },
    { "LAVA.WAD",           "22e9cade9298b190888e54d2d82e4446" },
    { "LAWNBOY.WAD",        "979e1b269be1edc20cbc3e4253ed5729" },
    { "LAZ-DD01.WAD",       "41eaf0fc8ccd54d0559696131135ff15" },
    { "LBDOOM01.WAD",       "0737d91e760fefa2cf704ffc5e97e36e" },
    { "LC.WAD",             "46d8b91365359230105b0d142e860a71" },
    { "LCFRHOLE.WAD",       "4902336ddfaf88ce886cd986a6e80d51" },
    { "LCP.WAD",            "c457cdcd3c1b25c32e5c8222635d4853" },
    { "LCS.WAD",            "a1ca06ba7da6a3f90bab08f08d38e4a8" },
    { "LCTUNNEL.WAD",       "2df11cec38f4c4e02341a01b64f5e5f7" },
    { "LDF.WAD",            "a89d658823efccbfd546254d95049d57" },
    { "LDF1.WAD",           "a89d658823efccbfd546254d95049d57" },
    { "LDFHQ.WAD",          "a0d0de070dd6c8d4a191bcfcdb9ccdbe" },
    { "LDL1_78.WAD",        "69e3ec9b0904a20dd19d734379c15e22" },
    { "LEDGE.WAD",          "5d226dffcd7fecfa6568d304fe825a73" },
    { "LEDGES-X.WAD",       "c41798c32d5c0744091025a04286d8af" },
    { "LEDGES-Z.WAD",       "afb73ee3ffe036e677a5f50007f78862" },
    { "LEDGES3X.WAD",       "e27571aeee62a2ac28544bbef7cf2690" },
    { "LEDGE_II.WAD",       "73e1b1362023f491aee984eda3ba8cb2" },
    { "LEDGY_II.WAD",       "c264dcb1a20fdbb9f6977da752d65387" },
    { "LEGEND2.WAD",        "1a8c636408952cb83e9e67f25e39e774" },
    { "LEGOB-OC.WAD",       "268c7e803ebc3f4694245926aa4916cc" },
    { "LEGOBASE.WAD",       "de7ab656c1f1ebe7dea3296b089f0420" },
    { "LEGTAG.WAD",         "7e1bc9d7ac7e7a392c7637227533117d" },
    { "LEITH2.WAD",         "ef402ddac1d5f95df3f539175f0d6c29" },
    { "LEMGFX.WAD",         "0c8cce3be8954a156b86384a18b232d4" },
    { "LEMLEVS.WAD",        "a77aadd7401280f7394a76d689995c55" },
    { "LEMMI35D.WAD",       "4b3523ac3b9f3550b946b4e9822b3633" },
    { "LEMPICS.WAD",        "69e207f08fbaa221038bbf91283833ea" },
    { "LEMSOUND.WAD",       "fa25c53ae801869d025afe496265f269" },
    { "LEMTX.WAD",          "3b8aa84a92736f190c72a75cd54625a0" },
    { "LEP2.WAD",           "f17c7d5a0d899de91e7a79c837858e28" },
    { "LEPCO1.WAD",         "9e1cb967d2e59cb33acca34b4f2ea6db" },
    { "LEPCO2.WAD",         "fc305fabb5165828c45775204db257c9" },
    { "LEPER.WAD",          "5f1ddf44835d36ff8e5dd540610311b8" },
    { "LEPRECH.WAD",        "3cb0b82492a96fd9098830fbfcb9a591" },
    { "LETHTRPS.WAD",       "1651b8ca0bc1e0364d9947383c686021" },
    { "LETITROL.WAD",       "27be2c7188be2761b3ec9cbfc15ee100" },
    { "LEVELS.WAD",         "eefb6cf8a16cb6f828196ee100252f5b" },
    { "LIBOFDIS.WAD",       "bed90db7e6731f2e529246e9d7666423" },
    { "LIBR.WAD",           "353f64f42cda17a3cce8467859045638" },
    { "LIBRARY.WAD",        "416fef36e15791a89c52d1750e39575c" },
    { "LIBRARY.WAD",        "80826560d339d58b38b8602063e3a665" },
    { "LIBRARY1.WAD",       "bf2ef0564a48ebee617a04a067f96cdc" },
    { "LICTORDD.WAD",       "3046d1c67a25dc0439032daeaff9ed7b" },
    { "LIFE2.WAD",          "270e644ef616a3fb882f147dc5de3c42" },
    { "LIFESA_.WAD",        "04e056da24fd58a9f590480e71e98e94" },
    { "LIFTLAND.WAD",       "66b821899d002629874941c9195a7173" },
    { "LIFTOFF.WAD",        "fcf370d546e06dfcc9774cc973b53869" },
    { "LIKEHOLE.WAD",       "29cebd96adcdbfff066665fbb7b7a608" },
    { "LILPIGGY.WAD",       "575203e0532aa5298752a1a2693a71e3" },
    { "LINC95.WAD",         "908f915df853bef96187244ec6bda2a6" },
    { "LINER2.WAD",         "5580b413af46919957d9456edca1d5cf" },
    { "LINKMAX.WAD",        "cab7e932334c79007b590babb0c371dd" },
    { "LINKMAX2.WAD",       "a6f9dfeb1dd9fe8720781f56de16b14c" },
    { "LINKS.WAD",          "c7fcb01acfd71df8962f311cf2338e44" },
    { "LIQUID.WAD",         "af524144af0f954cf46675b43e2f00f0" },
    { "LITE1.WAD",          "1f1a70fd2573dc393b24c5b5bee57685" },
    { "LITLFANG.WAD",       "4f3da9a3da2e035c39c60a22e44b7b63" },
    { "LIVE2DIE.WAD",       "790c95a1b111799ae7935b6e24d0ca36" },
    { "LIVEBW.WAD",         "7ffd25c4f71d53493d25b578922004fe" },
    { "LIVID.WAD",          "4528de8c0a10eec5d3c5c57e7e853bc8" },
    { "LKCC.WAD",           "e3f265e3018139256ad80fff30b48fff" },
    { "LLORI01.WAD",        "8d98fbff4de94be999e0afe5dd2adb0d" },
    { "LNKMRSND.WAD",       "506e6727e12f33d73350832565ca44af" },
    { "LNTFRING.WAD",       "3d385f57be755eafb47c81cba3f88ff5" },
    { "LOAD.WAD",           "710f66170f496faae658d138a1a90958" },
    { "LOBOFRAG.WAD",       "3fa4780b94d509479a9a1bd99b536ef7" },
    { "LOC7.WAD",           "e98710272874bc90d7aef9e179fedaf4" },
    { "LOCO.WAD",           "7592f9c85c6a11c5ba272c2a96b546c7" },
    { "LODGE.WAD",          "76ef7c3a649868ff7afb06eeae7967bc" },
    { "LOGC.WAD",           "f9bb542a69c1928c6a95998eea83191c" },
    { "LOGO.WAD",           "44cc52ae016618e20273d30236108a94" },
    { "LOH.WAD",            "dfa43aa707554451e2c4a651a9632c01" },
    { "LOKI.WAD",           "0d1ade81b024e404f03a5f8275374dd0" },
    { "LOKI1-3.WAD",        "334f10ba18516663247c7c7dc38510d2" },
    { "LOKI4.WAD",          "fb4dfdf9b9346666264ab68262189461" },
    { "LONDON1.WAD",        "5fff58d73e36b157417b3a62c5a71a4d" },
    { "LONGWAD.WAD",        "2512053643ec5f7ffbb1ce2d81f0bcd3" },
    { "LONGWALK.WAD",       "75b65cd919d72ed06aa4c529a6e240ee" },
    { "LOP2.WAD",           "9ab2f1a076e7f73f808fb9df00f3edb0" },
    { "LORDCNTR.WAD",       "308c567073950faa75fb7990eb42b4a0" },
    { "LORDROB.WAD",        "0a6e04c301a3e029855925e7552a6f4d" },
    { "LOST.WAD",           "7180d1d455b6019485d212c29ce16c42" },
    { "LOSTBASE.WAD",       "e0d38ad46424488fbda276ad34f52536" },
    { "LOSTCITY.WAD",       "85c60680a3f156c51cac794485e95125" },
    { "LOSTFFI.WAD",        "a44d3886cf3dcb305136cebc00753eb1" },
    { "LOSTLEV2.WAD",       "ab210b3510abdaa9f3206a1dc5d8dfcb" },
    { "LOTTADM.WAD",        "058dbd000e21a7fa12f9fbddc30df6c0" },
    { "LOTUS.WAD",          "f06b7dd656fafa329b16fd7dc15cec99" },
    { "LOUNGE.WAD",         "0cb7ca4fe8bc99d1501a928986f16f36" },
    { "LOUNGE_2.WAD",       "bbab1cbcdbeb7c1af2bc5cd923fd22d8" },
    { "LOVESPR.WAD",        "bd96bf616b82a9607d0c5f2900e5d9d3" },
    { "LOVINGER.WAD",       "d29409c146ba4d170299d91a04331667" },
    { "LOWBLOW.WAD",        "832e274fc5d56b0fa1d28e4f61493d37" },
    { "LOWERWRD.WAD",       "dd3fcfaaadf9a8220b88940f34685f26" },
    { "LSTSQUAR.WAD",       "7b81f166805f6a4a9f64fb4450e05c76" },
    { "LUCID.WAD",          "763b7a87102d4d967ddcf3d6105f99ad" },
    { "LUCIFER.WAD",        "783a202486dda599ff2732b88137112c" },
    { "LUCKY.WAD",          "317852cd3c8090ad66b0f981f2d43e07" },
    { "LUCKYS11.WAD",       "a38106b0b8a2505408058592bd41a209" },
    { "LUCLAND.WAD",        "ee736f79f4fb84a1d8735f94394e6983" },
    { "LUCLAND2.WAD",       "606ad2cd7faeb74368fceb0d32e9f3ab" },
    { "LUCLAND3.WAD",       "652ca856eeba911c61d599f7adfe0843" },
    { "LUCLAND4.WAD",       "5df921716e00c2c9a8cc92ba1fd45137" },
    { "LUCLAND5.WAD",       "5cdac1bd6f0e52f1dee2047b911c306f" },
    { "LUFIA2.WAD",         "696c6a9c5033e992df101580a6c6a6dd" },
    { "LUIGE.WAD",          "67543f04e938d043a4712361f40bd2b9" },
    { "LULLO1.WAD",         "0c87ee5b35ab4624de1169536f8daaab" },
    { "LULLO2.WAD",         "3e2361370288a0cafc7c97921b23dc09" },
    { "LUNA.WAD",           "3c83e4d31422e97d383d75aa27dcffdb" },
    { "LUNAR.WAD",          "f63e4ec3af21f66c45824747f6373f74" },
    { "LUWIE1.WAD",         "b51ccf9b2f3fd7c955c14bf00c05402a" },
    { "LVLUNOR.WAD",        "ac32f44541d65bf0423c31a54bc86624" },
    { "LVMEALON.WAD",       "8b4575c35f90ea372ce574cf5ec18d47" },
    { "LYNX.WAD",           "b6ef9bb60d369a523ef002641163c2bc" },
    { "M1STYLE.WAD",        "f658b4969799bf71a50d5dcb560ca200" },
    { "MACHINE.WAD",        "2bf38d24f1e88266165fa1885c9548b6" },
    { "MAC_GFX.WAD",        "5f2b1021edf77c07a2e705460b624d93" },
    { "MADNESS.WAD",        "92a325dc28ee95df74a9da556abf2210" },
    { "MADNESS2.WAD",       "2e3b6595e28d4db690b2b6e30e0cc593" },
    { "MADNESS3.WAD",       "79b396cc39977282e34bc409510fa8d7" },
    { "MADNESS4.WAD",       "1e706c7c79728c0d2cca957cd170aef9" },
    { "MAD_001.WAD",        "16bf92d486a2193a0193f0eead1ceb43" },
    { "MAD_2.WAD",          "d11238b5fe9217eccc8addef9c5e5be9" },
    { "MAFIA03.WAD",        "8164a07ab1f005e976dd64b199f26e0b" },
    { "MAGES.WAD",          "0e25b4d2cf4a396d70cd28004f6f3e74" },
    { "MAGHQ.WAD",          "4d68cb763b92ea05ed6be5df6928e0c2" },
    { "MAGIC.WAD",          "e7d9afe11bcc78a186fa423d5a6041fc" },
    { "MAGICMAN.WAD",       "ba25e3e383bf85ff27191f2e751cdf9f" },
    { "MAGIUS.WAD",         "a2e8cecab16db5653ca9fee1788adb11" },
    { "MAGNUMBAN.WAD",      "7440ab94cd9e12ebedf0c4a19a515b05" },
    { "MAGNUMOP.WAD",       "b902a6415c2e053d4a39057108d72d5d" },
    { "MAGNUS.WAD",         "61c207151505360533bc55c5983d3eee" },
    { "MAGUS.WAD",          "67b85f11bf20ced7249a0b7714e57fc7" },
    { "MAGWA.WAD",          "c52e3296861b03fc955d45b9da56f0da" },
    { "MAJORCRAP.WAD",      "b593a04930e89f281f0e8c6bae0d3aa1" },
    { "MAK4-DM2.WAD",       "21aa375936df74f23c986c3cf967e9f7" },
    { "MAKEITSO.WAD",       "23714a0d274704278038809cb0990e88" },
    { "MALGNANT.WAD",       "c1385797f6c540885ce360ad3ebe6cf5" },
    { "MALL.WAD",           "4fdc5c865bad624c5dc73b32121ecd12" },
    { "MAL_SKUP.WAD",       "4b036f0fb79a0a0d7050ca400286c1aa" },
    { "MAMOSA.WAD",         "d6af95d4c469b38917b01002623059c5" },
    { "MANC.WAD",           "a4d968053f01609708bab749fc9cc07a" },
    { "MANCERX.WAD",        "e8b17d6458101d6c6c79bc18121928bc" },
    { "MANCERX2.WAD",       "9d5593c5701db4e389715f653c2e6ed1" },
    { "MANCERX3.WAD",       "52d3c257b8c35c981a17dd3224db5c3f" },
    { "MANCIA.WAD",         "93f42c0b0ee11ce145351c9e61d56f73" },
    { "MANES1.WAD",         "8c232072ff922bfae542f296dcd9f418" },
    { "MANES2.WAD",         "96ad889dfc17ef931d4b5c2327bdcaf2" },
    { "MANGLE.WAD",         "933e24e64a1a4df4f899661a8b25388b" },
    { "MANIFEST.WAD",       "a3098107f098540e06923c82d4ceefbc" },
    { "MANOR.WAD",          "15c972233c950e9184c797131199ccbb" },
    { "MANOR1B.WAD",        "e88e2830d698f7aa78ce307a898b2ce2" },
    { "MANORGFX.WAD",       "f6a834547364147f732db8848b493326" },
    { "MANOWAR2.WAD",       "171bb68943d1ee4dad3f203c0224a341" },
    { "MANSION.WAD",        "63fd3df115c00a5cedbe466ca7aa97ab" },
    { "MANSION1.WAD",       "385fe41ae5ca9f696b5c6b2254235d28" },
    { "MANSION2.WAD",       "73a8ed24b18313592dcae8e24e5d6c74" },
    { "MANTIS.WAD",         "8465196bd0d7a10bc5c23157ec89e53a" },
    { "MAP01.WAD",          "af64b0ad6c3f65615de61c800b888a09" },
    { "MAP01.WAD",          "ee79a38dcc367c2b802497f85aebf660" },
    { "MAP02.WAD",          "cb0dac23b222ab50c11ffbbe3c966c06" },
    { "MAP06.WAD",          "3c7e76428f1141c816ba798a02271153" },
    { "MAP30.WAD",          "df176e828b599525350649e784175cea" },
    { "MAP7A.WAD",          "58c1963e8680022cf22a4a448e03c993" },
    { "MAPROOM.WAD",        "15ebb57da26e4f11ac3be3445ab5dbbf" },
    { "MAPTEST2.WAD",       "91492b9e5e8f6ed5d02829b0c4594ea3" },
    { "MARBELUM.WAD",       "f84f82a2939e178f6686770df91bceb4" },
    { "MARBGRVE.WAD",       "12408bd57682b397298de547ac77275c" },
    { "MARBLDM2.WAD",       "6a819151b5d602b0a152dfbea8cfb70d" },
    { "MARBLE.WAD",         "7b03db6c96c3718d8fa0908e8e257ae5" },
    { "MARBLEDM.WAD",       "c1ce46eed866a72ff6403a006a9cc4fc" },
    { "MARBLOOD.WAD",       "c3e480399cf02c2d6e5408a630cd242e" },
    { "MARBMAZ2.WAD",       "8f8239b10bcd7e8a7da3e526fc3d33a4" },
    { "MARC1.WAD",          "82280e8efacdfa7e5450e49ceef8679a" },
    { "MARDUK.WAD",         "30412065203833745e243531107f7660" },
    { "MARGAME2.WAD",       "0af4eb8253253858813f2b1e9c3c2cad" },
    { "MARINA.WAD",         "a82c7ad592044e249a83f7d0b6ea9ddb" },
    { "MARIO.WAD",          "7a7cbf005594bcb5ce9498c4ecd818ba" },
    { "MARKET.WAD",         "60d4b616524bf281b04f29cb70af9776" },
    { "MARKII.WAD",         "3ffe769a7538a9209710c57a8b81e567" },
    { "MARS2.WAD",          "6ad6375b4b7965c5cc0d861aa82188cf" },
    { "MARSBASE.WAD",       "3e4882fcaa2353307e167734376c6809" },
    { "MASHB1.WAD",         "8f899f415a71be1518f0af1ca84d1e44" },
    { "MASO.WAD",           "8bd74e4649640b92c33983cb44baa07f" },
    { "MASOCHS2.WAD",       "5ea28a853ef6bdf4304537d30e2ebca6" },
    { "MASOCHSM.WAD",       "719039b968faa2b700776ac7638a4d22" },
    { "MASSACR2.WAD",       "2263e7b31d1bb82263a3bff2cbf06d9d" },
    { "MASSACRE.WAD",       "6c70099582cfe8ec590c57d662633c35" },
    { "MASSACRE.WAD",       "8e9d7991b909800c49d14e07de002665" },
    { "MASSASSI.WAD",       "e7df1a4e30f5574cef492086fcc31c84" },
    { "MASTER_J.WAD",       "35b644fcdbb18d2b6936fa9806d4237a" },
    { "MAT-ABBY.WAD",       "734c1dc3c85f3977d37785c578a608eb" },
    { "MAT-CARN.WAD",       "c8c56c9804b34216268cf48d671d5b68" },
    { "MAT-HUNT.WAD",       "b61f67436105c22d8f54026d01e52eda" },
    { "MAT-LUNI.WAD",       "b188d61e83ab6b665ab36d9209874ff5" },
    { "MAT-MORT.WAD",       "e5129c3f4be989f6320e0ae2229b68b9" },
    { "MAT-SHAR.WAD",       "cb171d43182f44cbc7bfb77633aff5cb" },
    { "MAT-SHDS.WAD",       "023887d2ff89d2eb5b643d5007b6af1f" },
    { "MAT-TWEN.WAD",       "a65799a2bb1c4d1820834a7452660bdd" },
    { "MATCH.WAD",          "b6cb7a0a5bc8d63ade9a42498eaf8bfd" },
    { "MATRIX.WAD",         "0ef4aa3dad8f2a20cf1fac2de2674917" },
    { "MAUD'DIB.WAD",       "c03d68b70b88475b53f0c87d4ff4ff57" },
    { "MAULHI2.WAD",        "37920b8a5a5b7990ee73dbf00e49f3ad" },
    { "MAVERICK.WAD",       "94d3d1715b5ce21654219245a2b9ed54" },
    { "MAW.WAD",            "0da2d69f2ba95678722698458b318712" },
    { "MAWGFX.WAD",         "979c29688dfaf3693a6376f8509382c5" },
    { "MAWSND.WAD",         "7fbcbd50d02fbb8d0984b967dab684e2" },
    { "MAXDEATH.WAD",       "fa1617a6601555fbef759e75e4435748" },
    { "MAXMAD.WAD",         "ada2f8d970a0f36db88b8e0843de2790" },
    { "MAZE.WAD",           "210d7fded3fd534ca5faa13639b4e004" },
    { "MAZE.WAD",           "2e562ce1403035ff33b299a5360ea6eb" },
    { "MAZE69.WAD",         "0b0e4be65a17ca2069a2006fa65eac77" },
    { "MAZEDOOM.WAD",       "f5b1c9605f8cf58935c91d58d21da925" },
    { "MAZEFITE.WAD",       "c6d5adda9bc3cdbb862364aaca5ba5ce" },
    { "MAZEFRUS.WAD",       "7c0badc79f4ab8f2dbd7d4748462f1fe" },
    { "MAZEMOD.WAD",        "a248becbe05eef6652f95dfaaf4e5c45" },
    { "MAZER01.WAD",        "d4479f081d3c549e9f66e2356193e671" },
    { "MAZER02.WAD",        "60332426e6045d787fcd0602effd2c0a" },
    { "MAZES.WAD",          "29bfa029a53a842eac17c27a0fff8bbc" },
    { "MAZEX.WAD",          "87db1c6486919f67fdac452dea34f2fa" },
    { "MA_DESOLATE.WAD",    "ad7f51b5684d024d910d7e77237c2cdd" },
    { "MA_DESOLITE.WAD",    "28070148731703b14e68c8b7881d84b9" },
    { "MB01.WAD",           "8cb6775a2217926fbf667868b0086130" },
    { "MB02.WAD",           "53f8cdb588c021932e692de5b4f7a887" },
    { "MB41.WAD",           "62851ef44dbcbc34301857edc1494915" },
    { "MBASE.WAD",          "764f84bb01ee1de0e86ec5d8e15a4170" },
    { "MBASE01.WAD",        "75c01b4ed2ea329c6dc08e2635987cfd" },
    { "MBASE02.WAD",        "e4b7ebc16211438791f85cf936fb9d02" },
    { "MBASE03.WAD",        "58e29ed56b657bf7c7b25fbbf9d56978" },
    { "MBELCHER.WAD",       "cf486f925bfe7387a4fb16401e79183c" },
    { "MBFX.WAD",           "0177f068239448208d3710fde649f98e" },
    { "MBUNK1.WAD",         "bec7a4ebd1e60d9d938e4d5b1d5043f8" },
    { "MBUNK2.WAD",         "acac6b154ef847330c78001915dfb394" },
    { "MB_DCT2.WAD",        "51bbc99834a59552caa2b642254d3a3c" },
    { "MC95.WAD",           "955df134cfe0103961112b35739eccdb" },
    { "MCCRAM1.WAD",        "eaa74295a0668b783a48e400b6e6a7ea" },
    { "MCCRAM2.WAD",        "8e8e6b73255dbc9bae6ada321fe90522" },
    { "MCFEARSM.WAD",       "12d6f20f406562784cc7913bbac0547a" },
    { "MD.WAD",             "4078e1d6a48c5e4b20d1b2a79eb59c45" },
    { "MDK187.WAD",         "ca2f213d5c7f5c3e37848522fefb9eb1" },
    { "MDM3.WAD",           "92dbd8909722cab0f2ad3bab91d54d6e" },
    { "MDM4.WAD",           "42c6cfc8f8b634bbe1b1aca2c031cda0" },
    { "MDM5.WAD",           "db549e7466fc9d65f15c36dd698cf61c" },
    { "MDM6.WAD",           "630560b6bdd927f2dadd69a8639258d2" },
    { "ME.WAD",             "2eb740367f452c9203d4ccd1d23c3a1f" },
    { "MEAT1.WAD",          "75795bc77b309f8a411f67d05c024301" },
    { "MEAT2.WAD",          "8f648aa0792dd270a2071e429be54ffb" },
    { "MECHDM.WAD",         "54f7db8e0c8c2b22d917177914c55aaa" },
    { "MECHDM2.WAD",        "65257f5eb4868a88a76759a7579c03e3" },
    { "MEDIDETH.WAD",       "63899f77af32f9edb186e71204441a82" },
    { "MEDIVAL.WAD",        "264336a5a5a3b7d45b3b4d5460d60a01" },
    { "MEDUSA.WAD",         "1804dff3d14c05d4a2aca4ffd8a7865b" },
    { "MEETING.WAD",        "c8b01e144e9badad23565307f71a4f66" },
    { "MEGADETH.WAD",       "195ad6e7f744f32430b75f4ef65aeb01" },
    { "MEGADOOM.WAD",       "daf32c669486b08568c9885ab6da6830" },
    { "MEGADTH2.WAD",       "2703cbed73a8ca37b8419e3e310413f7" },
    { "MEGAHARD.WAD",       "e036495a8e0ada458c65a7c0450c4ccf" },
    { "MEGAMAN.WAD",        "87aef28a7c54788988f35419627e35de" },
    { "MEGAMAP5.WAD",       "ae94227a414724ecce7388f3e5095aa9" },
    { "MEGAPHSE.WAD",       "6ccaaf0daf9fa39ebc46f081a2ef7b88" },
    { "MEGATON.WAD",        "747afa38e323cf6e30219d251757d10d" },
    { "MELANGE.WAD",        "d588fd592d51938ef27bc221ff32af59" },
    { "MELEE.WAD",          "4fcb967a79078323046ea345d245b01c" },
    { "MELEE08.WAD",        "6b2b22c16392e32b1f75595821a17953" },
    { "MELEE1-7.WAD",       "a35358e5d8d4df163adbee6970b8e8d0" },
    { "MELEE10.WAD",        "e5ccaa5c18a4a957986ee6ffbf9450ba" },
    { "MELEE11.WAD",        "6278ad17ac6f0bfd96c33efbe0980e04" },
    { "MENACE.WAD",         "100db8a39027718ffacc5b82ceb66a3c" },
    { "MENACE1.WAD",        "6f33536a643dce206d9ed4434a6e253e" },
    { "MENACE2.WAD",        "f9383b187a58145a02545e2969f9c4a3" },
    { "MENISCUS.WAD",       "d121c7bb7555b1a242369429e315df99" },
    { "MENTAL.WAD",         "15a3f651a4b6fa4a44a49b87f8c11cd2" },
    { "MENTZER1.WAD",       "706188fc0b6ca0a7546a951c88b9391d" },
    { "MENTZER2.WAD",       "eccdb9d391790dd4890375c8b123d486" },
    { "MENTZER3.WAD",       "9c4dc228f95fc8a86c610ec708d58563" },
    { "MENTZER4.WAD",       "053810395f67fa9f52307ead91cf3fbb" },
    { "MENTZER5.WAD",       "6bae37f8c4d05c6f58d16abfb8ccbfd9" },
    { "MENTZER6.WAD",       "79f48cb7926555df6de1e9dd3b3bb8d8" },
    { "MENTZER7.WAD",       "9b9ec2839219d98249ae72dd04aaa954" },
    { "MENZO.WAD",          "cdf0b4055cdef342f9c1307c184702b6" },
    { "MERDOOM2.WAD",       "70eed9264a40bd283525a8655b52fd7b" },
    { "MERLIN.WAD",         "f5d0b62263bda58cbe0eb54975fdb33e" },
    { "MERLIN5.WAD",        "6ca9cd8377adfedb41ef3b391c8ac1d8" },
    { "MESSIAH.WAD",        "b6317ed050c442969e388ce998078b69" },
    { "META.WAD",           "3a5e8801e629cf3890224220b3dbda46" },
    { "METAD2.WAD",         "92cbc8c225b747c2d191cc3cd1724fab" },
    { "METAL.WAD",          "9a8cf37f0b8f98b79fd8640bd9101b11" },
    { "METALDM.WAD",        "2d21f143df6b3dd62495460a8365bf26" },
    { "METALDM2.WAD",       "fe6cae2e26cd6244cb6e400c48a61dd0" },
    { "METALLIC.WAD",       "8bfbf50b5ee46f3e3ea1cf1b17f042fc" },
    { "METLASSA.WAD",       "1dd486f2f270ec0bc7f652cd237daf78" },
    { "METRO.WAD",          "500f90e006bc545babaa99d2e559da54" },
    { "METRO13.WAD",        "07bc3e44ad0d1099ee3b33268a55461d" },
    { "MGMYDEMO.WAD",       "f80ade0f13723eeadd3b7b3b76105028" },
    { "MIA3UFO.WAD",        "52f9292677f774fa256f2baaeca24559" },
    { "MIA_SAR1.WAD",       "1248640aeebee731404ab64007eba04e" },
    { "MIA_SAR2.WAD",       "b39d6551cba60939b096bda53e77e2c6" },
    { "MICASA.WAD",         "a5c64dbd2f7ca345a9456b3632721a8d" },
    { "MICROBE.WAD",        "b43ca89df7fba4eb933a81adbcb8e8cb" },
    { "MICROSOF.WAD",       "cc57b3efa794e9c316867136c565e41d" },
    { "MIDEVIL.WAD",        "2f2550d343045d64879a75a7a17baa59" },
    { "MIDEVIL3.WAD",       "623f6aad81b6f47da6af420e873a3c87" },
    { "MIDIAN2.WAD",        "287435c5f7c394725fdf124e5740a90d" },
    { "MIDIWADS.WAD",       "f0945b3718cbe331b6dac01795cf0615" },
    { "MIGMAG.WAD",         "f3d34a0c253ff6eccb5f0378faf3e570" },
    { "MIKE1.WAD",          "dc69c920b768919a51cc3652400ac59e" },
    { "MIKE2B.WAD",         "7c594dd80f49a51cd3ac6514db0b0603" },
    { "MIKEBOKN.WAD",       "af0858dc526d09313d48aa3e531fcdf0" },
    { "MIKEDM2.WAD",        "0724c00bb203cc6914bda87f39086ccd" },
    { "MIKEDMC1.WAD",       "85adf36ebeafa9c4b73dc30ff93f565e" },
    { "MIND.WAD",           "1a6985bc246bed8d8a784117e823ba0e" },
    { "MINDPHK2.WAD",       "17630228b2c254e614733d00012d18a9" },
    { "MINE.WAD",           "23fbc172fd778f98fa06283bc9b31a71" },
    { "MINE.WAD",           "4a772dda9027959ce64fe428e4f05b28" },
    { "MINEFLAT.WAD",       "b87c29892f9e53a9b0060d4c77121034" },
    { "MINES.WAD",          "5103646aa939a914c19a35bc4f44be9f" },
    { "MINES.WAD",          "e83b2286543ee496d96792c99d1aad8e" },
    { "MINEWAR2.WAD",       "72b0cd2621fc4503a6b27303bae5a4f6" },
    { "MINIDETH.WAD",       "b94bcbc247a59f311f9b8d5d2c87a624" },
    { "MINIPAK2.WAD",       "52692ccd716a7597471b2293848c7778" },
    { "MINOAN.WAD",         "ac5dd1d8e2591dec79c7a91ca1971b18" },
    { "MINOS.WAD",          "6de3fe79d80bf86e7ce9b0ff8bfca4d9" },
    { "MIOSIN.WAD",         "c3d53c8bb5c34e597332e5708c73c68f" },
    { "MIR.WAD",            "331d1cc09be8bbec77a65180789d9357" },
    { "MIRROR.WAD",         "0a901a6cecfc4335ee0e8b89ad0fc745" },
    { "MISERY.WAD",         "c21f020053c185207f5163b8f2bfabd0" },
    { "MISERY3.WAD",        "1b3d6fe71200f8070e2880b3a258a3eb" },
    { "MISSIL.WAD",         "9afc217316c28ea5c542c2c484a5996c" },
    { "MISSILE.WAD",        "a921a816fb86a09f8dd5e08bfb8df9bf" },
    { "MISSION.WAD",        "0a51e7f937779a4d272cd0e552ad39f7" },
    { "MISSIONX.WAD",       "161009d7766f60b63aea465ec1c07d64" },
    { "MISSUN.WAD",         "ce92dbd800f746c3ab302861eae4dee8" },
    { "MIX1.WAD",           "4a1be78d795dca8d93643c66388124ae" },
    { "MK.WAD",             "486dab62ae64757697d2e0f0b2807a9d" },
    { "MK3.WAD",            "ac481f83b80d2de79d1914fec72f0f14" },
    { "MKBIGWAD.WAD",       "a7d0fa41a76793b9a63fd721fbe3deeb" },
    { "MKBLUHEL.WAD",       "d3e58fe3f63fbf200e2b545d7d91bae3" },
    { "MKFRGTME.WAD",       "da87a22e599fc6bf462c3163a8a8293a" },
    { "MKHALLS.WAD",        "4c5d4bc502be384e16166d3268056f89" },
    { "MKLOFTS.WAD",        "3471030c638ab92341c838eb2b35940b" },
    { "MKMINES.WAD",        "d9431186738507d9f4e8904780c85f9a" },
    { "MKOMBAT2.WAD",       "0195d1bdc4002b1e391efc7de8a786a9" },
    { "MKPIT.WAD",          "3f613404873bba48318abc2ce55b2e74" },
    { "MKREVWAR.WAD",       "92c0bb7a46806eeb1a161f6e5bfbc847" },
    { "MKTOWERS.WAD",       "475591e7e635426044d7d3ab0eb9d3de" },
    { "MM1_6.WAD",          "7500dcf24791ac4792c5f7c5494bafe6" },
    { "MM2.WAD",            "892ae6c4694b55112af11bc420294709" },
    { "MMATLOCK.WAD",       "328005a162915c757f148a5d78949832" },
    { "MMD.WAD",            "ab4cffb422526abad501dacd31c3e14b" },
    { "MMSRSLOW.WAD",       "6586a4054b2a4530e218678b87782e57" },
    { "MNCR01SP.WAD",       "5594f4277b385801a2d84773a689e3cb" },
    { "MNSTRGFX.WAD",       "aa1b40c82c716b35671717d1cbe9ec5f" },
    { "MOCKERY.WAD",        "70986b7c6adea87145b10e080af5a5cb" },
    { "MODDM1.WAD",         "3d1252781bf4c4b4cabc3dd0b0d0f617" },
    { "MODDM2.WAD",         "cb5f2dad390a9998a2c33812951a230c" },
    { "MODDM3RJ.WAD",       "5279d4e90c851c0e0237e6984f0b6121" },
    { "MODDMBSE.WAD",       "5063d403bd3dbf02fee3c1c84000b031" },
    { "MODMNBSE.WAD",       "c2b833a081d336ea1ebbccd48881b26d" },
    { "MODMP7.WAD",         "17e9e82e5c22458c003df5e762bf6107" },
    { "MODSPLY.WAD",        "63d0c76f28e3ee49b2e9b1692d0b7177" },
    { "MOGGO.WAD",          "c5fd39e17fc6c5ac2e950fa006509431" },
    { "MOGOLLON.WAD",       "ead253bee64c0bb9be38d5fac1433eb2" },
    { "MOH1.WAD",           "d413a52994cbad808dafdde6bdcfca55" },
    { "MOIST.WAD",          "00057410d2ecff83abd88a0003973e7a" },
    { "MOMESRUS.WAD",       "b37392309cd8674ec306bd5ddb73656c" },
    { "MONASTER.WAD",       "6bdaeddb3c918613decad5286981d3c5" },
    { "MONGO2.WAD",         "6f54870c5d229635d15d40e4e19939cc" },
    { "MONK-U.WAD",         "b56788f33fe5010c3f3567adab5b5d51" },
    { "MONKEY.WAD",         "0509f0cc09e4131c774613f80ce0e935" },
    { "MONLTH01.WAD",       "97e4ff866a52ca9293d4f2e0c3ac2f85" },
    { "MONSTA.WAD",         "0ba1bb24189318337d3ee0e98bf0ff6d" },
    { "MONSTER3.WAD",       "23b616445637781fc44610a41b50a795" },
    { "MONSTER4.WAD",       "fd6e569ff1ce1d13c833e91fc5d656da" },
    { "MONSTERS.WAD",       "ff43c1bfbc9098fdc6d39a834c7b8d46" },
    { "MONSTERZ.WAD",       "048b2a2042d9766c494806399d4e687e" },
    { "MONTYII.WAD",        "5fe1f3db071c2506d4bb1cf2de2330de" },
    { "MOOD.WAD",           "d2beea546e2b83f2feea29342024587d" },
    { "MOON2000.WAD",       "475be96e98b9fb777d73dd2a384dbce2" },
    { "MOONBASE.WAD",       "8fc56d57af874677fc17b14c9c31f769" },
    { "MOONLITE.WAD",       "057776cb42dee320a4a2920428fb5845" },
    { "MORALITY.WAD",       "dabec323abcd2c945893806ec6d1679f" },
    { "MORBDITY.WAD",       "66093f4bf92a111e3c52f77e740d1472" },
    { "MORBID1A.WAD",       "3a420aea2077f0b48d6ca24b966a1b5c" },
    { "MORDETH.WAD",        "db99fee82e9124ed6e1f009151589f73" },
    { "MORGRAP0.WAD",       "bb63601a03f1f3720cdc6fcd333a16aa" },
    { "MOROS.WAD",          "68bb4e439cdc14f512d9ca7f03414520" },
    { "MORT1.WAD",          "495a9a721f253f62751b9f18e8dad99e" },
    { "MOSHPIT.WAD",        "91fd13c4787ea203201e87fd86e60df3" },
    { "MOTE.WAD",           "edde3d73bf93c15f62a9de2ac9d74506" },
    { "MOUNT.WAD",          "975dc884acdd1a82e081ae9f5eca527b" },
    { "MOUNTAIN DM.WAD",    "ef4a4a8e3794754b9693c8950a87aced" },
    { "MOUNTBAS.WAD",       "3c5f2a4f83d31262fcebc7342d9f9083" },
    { "MOUNTDM2.WAD",       "e1ebb51b6a7fad52776648e39d3c258b" },
    { "MOVEFAST.WAD",       "af041b5f706d037b28e811e864b60b9d" },
    { "MPAIN.WAD",          "e2d076961ceadbbdacaafd7798c88c2c" },
    { "MRAR.WAD",           "94170d33e62c449d3ad53fd147420265" },
    { "MRDOOM.WAD",         "68086f135eab31557879f022ebd13299" },
    { "MRGRIS.WAD",         "8fa2b2b77aada7763789eac715f4c0f6" },
    { "MRME.WAD",           "f9082a2fb32e99bc6a804361ed24c3f2" },
    { "MRQ2.WAD",           "901510501b00844f68ccd074a4a43e11" },
    { "MRSBSE.WAD",         "2863653e4a050d9f5eb29d8dcab47360" },
    { "MRT-1.WAD",          "d229e629e9b03027bcd9e98169d25661" },
    { "MRT-2.WAD",          "9f78388807607a30917f19244e0dee0f" },
    { "MRX.WAD",            "acc89eeadac64eeb844434cfdabc93ec" },
    { "MSCL10.WAD",         "2463937eb123dce6220d27d9dbe5e7e1" },
    { "MTFACTOR.WAD",       "20f6f051683d6a036ddb856b6fde1c42" },
    { "MT_DOOM.WAD",        "fc05fdbe488d0a67cd3d6245c1ccf050" },
    { "MUD.WAD",            "e1a0597ecf09c1edc29d04b6060b9033" },
    { "MULTIMAT.WAD",       "936e257faa910310e9f1366006995f78" },
    { "MURDER2.WAD",        "27a8e4227b58f1ee8f4425a1a643d023" },
    { "MUSEUM.WAD",         "60cee1219f94985f7f093ebadd5eb853" },
    { "MUSTARD.WAD",        "7d8a42d78996f335c129c5064646cb80" },
    { "MUSTDIE.WAD",        "56f8186ba3dfd9aa420731a17ebf8e2d" },
    { "MY.WAD",             "d3d85467ab55d5aa4e19ec6dfbc5ecfd" },
    { "MYCASTLE.WAD",       "c551e2f2b9be16ae64db96bbdd87420b" },
    { "MYD2LEV.WAD",        "95b4c96cea673313a76f4cfe67aeee25" },
    { "MYDOOM2.WAD",        "345da4744c1cfcf7ad9d5cf845be4930" },
    { "MYHOME.WAD",         "58ef545bfb16deb24e4a33c0f52c67a1" },
    { "MYHOUSE2.WAD",       "069fc95a4676c23109f24ce315c5e5f8" },
    { "MYSTARSA.WAD",       "121d110d8f87ac39dbfc50ea06a6edc4" },
    { "MYTHDUNGEON.WAD",    "c566ec2d27624fefe6a733430e919628" },
    { "MYTHTERRAIN.WAD",    "fc461b2a48bf48fd486b1983a650a1c0" },
    { "MYWAD.WAD",          "7feedef65957082c13c5c7afb7616311" },
    { "M_ROOM.WAD",         "3ddf25ff13cc622652a831e5b973b17e" },
    { "N-SANE1.WAD",        "085879c7016daa8faea734895b9cc8d2" },
    { "N4-EVIL.WAD",        "1fdfee7b7c7282705016ef10073aed67" },
    { "NAKA.WAD",           "a107cc71d0f7ffc361106b2184b14c39" },
    { "NAPALM.WAD",         "26162fea97a56ba8bd8656e2fb87723c" },
    { "NAPDM01.WAD",        "c10a658a46de282952daec4e2f552fb7" },
    { "NAPPY.WAD",          "afbc9456d1b420aec9a4f228c57550c9" },
    { "NARC.WAD",           "ca1f537b2935ee470e49eae9ac776300" },
    { "NARCOSIS.WAD",       "0faf0550957c1e76ae8f3f3316019e8f" },
    { "NASTY.WAD",          "d33269b7a6d7e0fb5794e6f833ca0cf7" },
    { "NATAS.WAD",          "e49695dd24a10935fa0eda1693b91e56" },
    { "NAUTALIS.WAD",       "bc622cf4a4ee1ea0da7d52ec3424659a" },
    { "NAZI.WAD",           "41c9e8dbfe73e5d3a0a64161e71613f6" },
    { "NAZICAVE.WAD",       "33be4c17a8491d34e20ba8198fdfb324" },
    { "NAZISND.WAD",        "81e38274fc6d384755ab4287f4082fc6" },
    { "NAZIWART.WAD",       "11da0fabbe18f4b3a1854b99c4e6f0f6" },
    { "NAZI_HQ.WAD",        "a133967ed70132b369ac2ff1013924aa" },
    { "NBK.WAD",            "048c9f06d584e23537d668eb6a68993c" },
    { "NBMBDM01.WAD",       "03345f65d78032013749af21271b0c73" },
    { "NBMBDM02.WAD",       "27c914bc4e0d67d4e86f5c13f5b49c4e" },
    { "NB_E1M01.WAD",       "0aef0aac4f3f058cb0330b4c009a29c4" },
    { "NB_WST01.WAD",       "f3a21e921ad5b36df24bf1ec6046442a" },
    { "NC10.WAD",           "fb3ed21ad3dc0deaa44d10b75b7ea71e" },
    { "NDM2.WAD",           "3446d3ee2362e608e085662a558c7037" },
    { "NDMATCH.WAD",        "774f5d8ba8a62057fccd61289d730e89" },
    { "NEB.WAD",            "0dbff90ef2d37bf4a99047f3ce6a51b3" },
    { "NECRO16.WAD",        "a98306d98ed25cbcd8b6890767a7cc78" },
    { "NECRON.WAD",         "528393f1b907e87c2f77ab0a5e7553f5" },
    { "NECTAR.WAD",         "b89ccfceadf8f653784e3b662729ac41" },
    { "NEFCAT.WAD",         "00938f49fcf6bc93e54eabbb878f73ec" },
    { "NEIGHBOR.WAD",       "fb4943a56a242d5ba026dcb3a323d073" },
    { "NEMESIS.WAD",        "d99b0ee676d1a8ab718205b0f8d4f3c6" },
    { "NEMISIS.WAD",        "37bc894062aa6a7b6bfc19872360e67a" },
    { "NEP6LEV.WAD",        "6379a52c6354ac55cb4e58deffe8817c" },
    { "NEP6SPR.WAD",        "6d0e237960114f092db71841fe4cc65c" },
    { "NEP6TEX.WAD",        "15ad041870fe0b88b10cd10c70f177e9" },
    { "NEPTUNE.WAD",        "5841f58e2e5ea140158ccffe84b3cddf" },
    { "NERVES.WAD",         "a894bc74591ae7da82ab57c9c4c1b872" },
    { "NESDTH1.WAD",        "4e9d6c1ef6a3a9eca5dc230db285928d" },
    { "NESDTH2.WAD",        "4dfc34d8a8de734221bce426cccc302c" },
    { "NESSY.WAD",          "29505258adb61157a34d7363606ca291" },
    { "NEST.WAD",           "a8e36aabf9a5dc16621afe77df60096a" },
    { "NET10.WAD",          "5eeb4c5bbc80684aee1a17f6aaf15af4" },
    { "NET9.WAD",           "3fc41d918d415e8229f3be8d45e9eba7" },
    { "NETCITY.WAD",        "c51095bc7f0d8c197f40ab025abefb66" },
    { "NETWORK.WAD",        "ba8d490e99e159f038ab2ee615340f76" },
    { "NEVER2.WAD",         "b8d4f1c5e758231cbf70dbd60d9cea70" },
    { "NEVER2SN.WAD",       "60eae723d54d2350b4d2b7177148ea79" },
    { "NEVEREND.WAD",       "118e568a8b8a280e1eaab45eec59e6e2" },
    { "NEVERMO2.WAD",       "c5ba37151498147fd810f56aebb231f6" },
    { "NEW-X.WAD",          "4a092d42c6d3fcccdf2ece2ead98fa5c" },
    { "NEW.WAD",            "99bbb1b974bf9e9a79252599ffb6eb88" },
    { "NEWBOXE.WAD",        "2450decbc6e3fc9ca51859a12930869d" },
    { "NEWDOOM.WAD",        "f0ba9c87f6c357e63410c60faafa6908" },
    { "NEWEND2.WAD",        "53f90267f117cfa86ebce3a817c5d4c2" },
    { "NEWFLATS.WAD",       "d5be95108e89b861b1e622ba7127ad25" },
    { "NEWHOPE.WAD",        "0958461cec0b5e4650fefab6719d05de" },
    { "NEWT.WAD",           "a02815ee056bb222cfdf51817d61e569" },
    { "NEXUS.WAD",          "d67a053adb2d7f6cf5d98e6b9a4ac8dc" },
    { "NEXUS1.WAD",         "5f7b87ed220154e6d727aac895816b0e" },
    { "NEXXUS.WAD",         "f46de99f716bd86597475849ea9d86dc" },
    { "NGHTMARE.WAD",       "139a7e49054575028c1c835896644378" },
    { "NGTOWN.WAD",         "fed514ea019a104aa6b9bff1ffb147ef" },
    { "NGWOLF.WAD",         "b005b4bf337f8cf506037a4120bbcd06" },
    { "NGZONE.WAD",         "c08376af189271e1e5df3a8f4561dcc4" },
    { "NHEXER2.WAD",        "3ecf43ef661b20ca2d68a1478931f3c3" },
    { "NICK.WAD",           "cda236eb1a552c7f735a56a202fd61f9" },
    { "NICKS1ST.WAD",       "6575c59a9f3fc69620c51f2c7ad36d8f" },
    { "NICOLE.WAD",         "9481997ec2221beb1306cd1e6f55680a" },
    { "NIGHTRAN.WAD",       "7291110499c56074590f407f2248c315" },
    { "NIKKI.WAD",          "364b80dfc05793faf167e2e0220a1a91" },
    { "NILLA.WAD",          "a4d97665c26ac4b5bdf13611ded4f9e5" },
    { "NIN02.WAD",          "68bbc4205f562fad1c9e1b003a0773d8" },
    { "NINEVAH.WAD",        "82809de0257b11242dcbef4d7713ba77" },
    { "NINJADUK.WAD",       "751c41d17177128b922a528ee81f659c" },
    { "NIN_UAC.WAD",        "550ba067a1a23f9e3beeeca61e4415af" },
    { "NIRV1.WAD",          "075771434353f222d76321567fb33eb2" },
    { "NIRVANA.WAD",        "ffbb8519c222659c0282585500933148" },
    { "NITEFITE.WAD",       "a6af0e0229033683a38b70ed9046a6f4" },
    { "NITEFRAG.WAD",       "2d2a29b8a7fac14f2948b5bade9e7a17" },
    { "NITELIFE.WAD",       "940a30c5b0b38665b108ec5c2a9f5d5d" },
    { "NITEMARE.WAD",       "b6a4ecf12f7e625cced26896fcd7379d" },
    { "NITESKY.WAD",        "cb64162e26ce755e36beca8fba3d4d7b" },
    { "NITRO3D2.WAD",       "193f1fb1b3aede87065ba109338ff0a0" },
    { "NJDOOM2.WAD",        "c5fdd652c5b1de2e21a1b4ce6e523b05" },
    { "NJMAPS.WAD",         "f07a117497fea15d99d5ff0fa5d13e99" },
    { "NJTOSS17.WAD",       "c75e62b67fdb0f3df99862acbdf6d048" },
    { "NLDM20B.WAD",        "5c96d647c71e17d74abb540961c6fe6f" },
    { "NM.WAD",             "c20beeb2c1afa046630040ad377e3402" },
    { "NMAP03.WAD",         "6aba5824c4754895878b44c584aa36a6" },
    { "NMC.WAD",            "a68b9d213c9e552bb9ce794fa0120e17" },
    { "NMMNG.WAD",          "e4b18cc8e517abe90c2c425534858165" },
    { "NNHS.WAD",           "f707ff1b9f4019dad50a3143beea24c4" },
    { "NO-MERCY.WAD",       "bc09bba7689caef8f24ec8d63ed25ce1" },
    { "NO1S.WAD",           "516ffc7907401edfcc3a382f5b846e79" },
    { "NO2NDCH.WAD",        "635c57b2e686e197ebddcd772a276991" },
    { "NOCHEAP!.WAD",       "c3af7558acb5a7660b696d2830614c98" },
    { "NOFATE.WAD",         "c9ab6178fd658364cc117c058c277d8e" },
    { "NOG.WAD",            "6210105797af692387837e0e81818c58" },
    { "NOHIDE.WAD",         "8cd9ef8fc2d47f674df6f20376e4c72b" },
    { "NOHIDERS.WAD",       "4b1b3e18c884ddeb20ae5ea7203ee87d" },
    { "NOLD1.WAD",          "53e5fc96e63c9d4faf7b60657f574c2c" },
    { "NOMADWAD.WAD",       "6b221bd63802d30b279361ac9ee10742" },
    { "NONAME.WAD",         "41fcb2bc43c45e5ccf1935a327601d74" },
    { "NONAME01.WAD",       "d8f1b8f2d051fb48cc07c6de206fe8ef" },
    { "NONAME3D.WAD",       "95ae0d801edd4c179b35ae96f338e2cf" },
    { "NONDMS.WAD",         "c9ca731cfc46c46b45186925762a7b61" },
    { "NONSTOP.WAD",        "a8ae66e4ed2004f4d07ec94c1496f96f" },
    { "NOPIXEL1.WAD",       "377acae029e93222bb3319f3d40c773b" },
    { "NOPIXEL2.WAD",       "f338cf5a11b62ba30b227d23c287b864" },
    { "NOREST.WAD",         "ea5ba2a55a669cf5bd10dfa16f6679d0" },
    { "NOREST2.WAD",        "641a1dde6de029f4040d815465b94315" },
    { "NOREST3.WAD",        "9bd352138b6a4ff690be70b362fbdec6" },
    { "NORET.WAD",          "79daa0a11364f4d5263b3b6c41afa922" },
    { "NORETURN.WAD",       "12b897813f07c08a6ea6f84798d7db5f" },
    { "NOSATAN.WAD",        "0af09f146813174196e49ccf96d490d4" },
    { "NOSTROMO.WAD",       "93c8ff88902c402336b5e733edc514e8" },
    { "NOSUN.WAD",          "5acfebd7606f8f7fdb964e869624a938" },
    { "NOSUN2.WAD",         "da768b84dbaff2bf43569211fe7f56b7" },
    { "NOSUN3.WAD",         "ee814a81f102c2dc618e70eea7000092" },
    { "NOSUN4.WAD",         "80e421f956fb6ae7cfa8cf7dd6900a90" },
    { "NOSUN5.WAD",         "b6f9a5eae0959e520fc33beecc08557d" },
    { "NOTALONE.WAD",       "a2d476c3c4f1457aa6b7c38cb336bffa" },
    { "NOTCOMPL.WAD",       "a6ee1bf4cecd82aca55969341a27dbf4" },
    { "NOTDONE.WAD",        "1be62bcb32ff19200b4190262910060f" },
    { "NOTTO-01.WAD",       "4e620ab242e27aeacabdad68ce5a6da8" },
    { "NOVA03.WAD",         "09de7b7493963e524f5b70a92897af9b" },
    { "NOVA10_2.WAD",       "0f2391e3150d35b521d8706c8da8fda6" },
    { "NOVELTY.WAD",        "72a4ca1bea04d66af72d40e3aef38428" },
    { "NOWAY.WAD",          "27751b2a35a0711ac16e548d2facb022" },
    { "NOWHEREX.WAD",       "88e0b4b9b805fa1eba5bb8878480cb2b" },
    { "NOWHIMPS.WAD",       "cc6a82ef9c6d8c49ab91c156d1b598c0" },
    { "NO_EXIT.WAD",        "e38533022c313af03215059db1cb4023" },
    { "NO_EXIT2.WAD",       "9dd4327bb8fdae13ee93db2403798381" },
    { "NPP.WAD",            "23cb0b1c522de3aae9125fc16fc13dd2" },
    { "NRCPCG.WAD",         "6e4fb928fbc21c07841726d6cd24509e" },
    { "NS100.WAD",          "5d51b433c718ac34715e445794a1d82d" },
    { "NUCWASTE.WAD",       "0d1ceb3ebe690991f28e6d1931216fa9" },
    { "NUKAGE.WAD",         "1b8c2127d4539959733c1950fb72c795" },
    { "NUKCITY2.WAD",       "803f695fc276b593f7837ed5072a284a" },
    { "NUKECAN.WAD",        "ee5c198402b546e6891c4c09ce6282d9" },
    { "NUKEDX1.WAD",        "79221fd98d731209af4d4222ca1b3e34" },
    { "NUKEDX2.WAD",        "5d7f6eebf692ef709f469fe426b6ba6d" },
    { "NUKEDX3.WAD",        "bf72f0e00e8b9e846ade075e44b4ee1d" },
    { "NUKEMINE.WAD",       "1e17f617342cc7c72409d13527990424" },
    { "NUKEPIT.WAD",        "cc567e16b0d75c361a4afc43547eb4f7" },
    { "NUKESITE.WAD",       "ff70eb1f2a7f82607b7bd101137da578" },
    { "NUKFACIL.WAD",       "2174d56aadd7c2431e310d889e6b04ed" },
    { "NULSPACE.WAD",       "49c5dbcc136d0d6131549c18db2ee382" },
    { "NUTTY.WAD",          "d46511f865f85072db258ae30b19fefa" },
    { "NUTZ.WAD",           "1a25618c6a89b3edac0dbfdc9481b474" },
    { "NWO.WAD",            "702be57f34a440972376b3b0d4d4bffc" },
    { "NWTH.WAD",           "0150d368de49ebb21a6e03913ce04698" },
    { "N_E_B_S_.WAD",       "e46c82f16f57f2151cbe490875dd9ad1" },
    { "N_MARIKO.WAD",       "559cc959032a6ae9ffeb2f8c11609c32" },
    { "O'ARENA.WAD",        "04606998b3859fbe8ad34e0a0c05ecb5" },
    { "OASIS.WAD",          "d9973d4e8c55a86511b61f7eecf3fda3" },
    { "OBDEATH1.WAD",       "107252fb2c3586c119e6c94b99ac558d" },
    { "OBDEATH2.WAD",       "0e9ce7f436100d87f0912227d8f25c66" },
    { "OBITUARY.WAD",       "194a4b5e32d4cbbb39b81bb85973a258" },
    { "OBSESSD2.WAD",       "0de938609507ed800458dbee70038f5d" },
    { "OBSIDIAN.WAD",       "17c9a434b1d1c7556669fbe6517209eb" },
    { "OBTIC1.WAD",         "779ab2642f61db55c655a4af2f80bff4" },
    { "OBTIC2.WAD",         "4ffb9f7967f95fde755c155ed8e4a75d" },
    { "OBTIC3.WAD",         "c4c86cb40a92cfa2b2ac6a773aa71c1e" },
    { "OCEANBAS.WAD",       "61feded191252d800496d0fc388fa0d2" },
    { "OCT-DM3.WAD",        "0c5d0ae51d1420f04fa9ce6ce6e84dfa" },
    { "OCTAGON.WAD",        "3d7678fdf59beb4e47190bcebd5198c8" },
    { "OCTAGONO.WAD",       "afc78af13f30a3a1d46b9c69c0ded14e" },
    { "OCTAGONS.WAD",       "d1e9a0fd9984189d2b9d8fa268425338" },
    { "OCTARENA.WAD",       "4df8b1b48eb145a7e8b8a9a2e5872583" },
    { "OCTOGON.WAD",        "e9927f989f98b68d8f87f0dc8bd8645d" },
    { "ODAFLAG.WAD",        "4f2a20464b4d2df18ef7c054dee22d99" },
    { "ODAMEX.WAD",         "bf4718cdd98213f0cb68d178c618eb2f" },
    { "ODDWORLD.WAD",       "8ea448aff2bca15c5367e5fafbc093c0" },
    { "ODE.WAD",            "fc1f61555104eb6552caaef0344832ff" },
    { "ODEPOT.WAD",         "34f109946caee4c7250fff0b94b0a0a9" },
    { "ODESSA14.WAD",       "0578b7cb412bc4b7e133fc4fb725c427" },
    { "ODESSEY.WAD",        "2376475565967c83c5cc3b1887fe0787" },
    { "ODY1PCG.WAD",        "bd54b4411f6092beb9c89edcad95e343" },
    { "ODYSSEY.WAD",        "c170519ced7b8231c60ca7febc0f2815" },
    { "OE.WAD",             "559f788b6f32c98d83aa91879c02d8dd" },
    { "OE4951.WAD",         "d551b0d064e55196eadbc53c1df322ca" },
    { "OFFICE.WAD",         "52aa39bf8181d5a610f1e4887c94d09c" },
    { "OFFICE01.WAD",       "099bc1093ad8e5aa2f4ac65945f444e5" },
    { "OFFICE2.WAD",        "39fd32f33e2ff10553ef9f643ea2f23d" },
    { "OFFSPRNG.WAD",       "a5786a82e8220f4274019a5a28e3c306" },
    { "OHGR.WAD",           "093ffd1a8f8dfd14575a55acdb450375" },
    { "OH_FUN.WAD",         "5caaefc2ad50d4d0c0663b3b5f10bf82" },
    { "OK.WAD",             "2621fb8e7b47a9c841dbf9e41ccbcc4e" },
    { "OLDWEST.WAD",        "2461dc9c806909c628feb9e8ce51310a" },
    { "OLI4DOOM.WAD",       "5e38566b380780d83031e8644589be63" },
    { "OMAN.WAD",           "3d02e237e96e623bcd75b124ead8ea9a" },
    { "OMEGA.WAD",          "83380caa099132e8a7c5fed8edd5b810" },
    { "OMEGA.WAD",          "d65ab882a67213e99bdc2aef42326f26" },
    { "OMEGA_II.WAD",       "a11675e1cfaf3b66d552a85e1be85a25" },
    { "OMELET.WAD",         "3c11976999b57acc02519f6f5b4aec22" },
    { "OMEN.WAD",           "695b6d0fdde194d3343c39d4e91f49a2" },
    { "OMEN2.WAD",          "e4c680989a84e9bf4916dc6e0f7e6283" },
    { "OMFG.WAD",           "984fb5401221ed272445b3acf1bdfcfc" },
    { "OMGHAXDM.WAD",       "c5315c4f6ac844b3d42288b65eae1367" },
    { "OMGWA1.WAD",         "58825ccd2ea244f9c00c3a7bc84b4a62" },
    { "ONE.WAD",            "f9696e5cdc77fcd5b23ec1398f31fca2" },
    { "ONEONONE.WAD",       "4526d912546f599ca2352eae81da3886" },
    { "ONE_LAST.WAD",       "7304ba3d6f4e7dd91a0e2436c72a5270" },
    { "ONS1096.WAD",        "c50b5a46eaa11c6d82d5b7491b4b72eb" },
    { "ONSLAUGHT.WAD",      "858aa5521300601216eaddcc8124b165" },
    { "OOOG1.WAD",          "caf1eb4b0ebae8d7d25fc1969272c918" },
    { "OOZI.WAD",           "4572658a9cda6070d3cc53b4db1f4871" },
    { "OPEN32.WAD",         "93e1cff4b46486432023d2d4257df278" },
    { "OPENPRJ.WAD",        "6c4597deed2ccc6af269bce928d20e42" },
    { "OPEROBER.WAD",       "1455f8a4ff6a762b79c5f9cde683fc35" },
    { "OPHASE.WAD",         "11c8cd9241193df32e85fb2f7feea662" },
    { "OPHASE2.WAD",        "553a480ac744b91c025eb81e7f507e26" },
    { "OPHASE3.WAD",        "7f7916dec4e4a7e75a4c694a6685a69a" },
    { "OPNSPACE.WAD",       "cbfa661c6f4d26e36833899460d207e8" },
    { "OPOST21.WAD",        "6ee58e348af26c52b432399ce791aa2d" },
    { "OPTION4U.WAD",       "43ed2f382c3333e3d926a33f09b59b29" },
    { "ORACLE.WAD",         "8982ca7c8f151b74a4f89b5b102a7b7b" },
    { "ORANGERY.WAD",       "fce2d9c9ac182664a2821a687b1a1e4e" },
    { "ORGEL.WAD",          "a6f8234942fd93097b4fb0301fe266a7" },
    { "ORIGIN.WAD",         "7ef2982d6b8bab2a57504bdcc7616a7f" },
    { "ORIN01.WAD",         "a6da3bd28745f7e4e4fc68717df3abe0" },
    { "OS-DOA.WAD",         "3dd9af31e8d696e308b6ecc6fa7898d0" },
    { "OSIRIS.WAD",         "08c56b6c604783d2a6528e83c83208f4" },
    { "OTAKUGFX.WAD",       "82325824354d6017c21f558cd6c30bd8" },
    { "OTAKULVL.WAD",       "ffb4026a7a8a6e75e1281b5fd6ce072c" },
    { "OTHRWRLD.WAD",       "a45bf5fa6d5be0421b1461b4547de923" },
    { "OURHOUSE.WAD",       "05a9a078ce6dfe71ffabee177d9a84fb" },
    { "OUT.WAD",            "3adc74ccdfc81272b4156f4654b4cf92" },
    { "OUTAHERE.WAD",       "045326af648e0de9ab404b52b0d80448" },
    { "OUTBACK.WAD",        "46664234cdf09615681443bc5a1ec97c" },
    { "OUTER27C.WAD",       "95d42163a0737ef2c1797e0e1fd6a1f7" },
    { "OUTPOST.WAD",        "73333fc33ff8bdac4b55467f3eb7c129" },
    { "OUTPOST1.WAD",       "083110f05ce505b876ec7ec20e4a80b1" },
    { "OUTPOST3.WAD",       "7f049d049f08d66aa7e957402fa7c1a0" },
    { "OUTPOST9.WAD",       "2e05ea10d38efe0ad55936dacce5479a" },
    { "OUTSIDE2.WAD",       "10dc2fb0dcd60c925513f4447481d28d" },
    { "OVAL3.WAD",          "8198ab7241b6a03a1c9a6a07a6f02b5a" },
    { "OVERGRPH.WAD",       "5bcecbfdd483856925767925074b24db" },
    { "OVERKILL.WAD",       "1816d1c8fcff16f4e0ce468545b0655b" },
    { "OVERLOAD.WAD",       "0090df975ba3129b729a052bc8feb7c7" },
    { "OVERLORD.WAD",       "fa6f7f2de12ceff008485b5465b8b706" },
    { "OVERRUN.WAD",        "afb1ccf2f6b816e6a69399eca148cb7d" },
    { "OW_OW.WAD",          "6e5d6253fa9c64030015ab61c3ae4f44" },
    { "OXBOW.WAD",          "c40aa35f25114c324659fbe053b259d1" },
    { "OZZY.WAD",           "2aec6d58add96310457bee14032faf61" },
    { "O_LRD01.WAD",        "3433bbbf27d2ab8e8d43fe795d44d3a4" },
    { "O_LRD02.WAD",        "c7f6630be3ab4df081967633d27fd404" },
    { "O_LRD03.WAD",        "fbbe75af5cca73b8d8a585a921aa4b04" },
    { "P-32.WAD",           "86196fde2ef49e1092751b92149d04dc" },
    { "P-DTHRNG.WAD",       "38ee6f6823b1846903183273f8c1886e" },
    { "P-PIG06.WAD",        "35d82062299b3ac49045bb0ac2417401" },
    { "P-PULSE.WAD",        "547b0efec2140bf3f5c77a3f51024572" },
    { "P-SWIRL.WAD",        "cb4e50db4c6ef782cc2f0c18863011e5" },
    { "PACAOFHO.WAD",       "ed99cbcaa761af8425ed86c718b8aeef" },
    { "PACKER01.WAD",       "5e17c762edb60c231b37f56903854020" },
    { "PACKER05.WAD",       "1313eaae64f40cbd85b7dd66281deff0" },
    { "PADDOCK.WAD",        "587e704d801f972a3acfd2d6d00075c1" },
    { "PAFINAL.WAD",        "9176fed017036158ef0ccdd1564cbce6" },
    { "PAGANINI.WAD",       "669bcb058e6e3052e867e34ecd59e784" },
    { "PAGANRUN.WAD",       "936b9a3729254c438c67114c8d99f355" },
    { "PAIN.WAD",           "d5a9c6b873ae43734f1924ca0e1fd4bd" },
    { "PAINFUL.WAD",        "85ac6573e72177631e6c2d6c3582165e" },
    { "PAINHILL.WAD",       "262aec84e978b42b5f26c14bd12e5f28" },
    { "PAINMAZE.WAD",       "c4c5e47f350aefd6f2af3a4496f98460" },
    { "PAINURS.WAD",        "8271076fddb413459eca54e7d6448be8" },
    { "PAMPLON.WAD",        "5e7c8f18c07bedcb721ca27ce7df8ca4" },
    { "PAMPLONA.WAD",       "d8019dc1805e1db3a8fd6855a780e154" },
    { "PAN.WAD",            "0871bd0ecc4658178daf709101b5f629" },
    { "PANECH01.WAD",       "40eace4c00f960bc1e1386cc1f47f6f4" },
    { "PARADISE.WAD",       "5a62c03cda020b504fd3a1b591af63f3" },
    { "PARADM2.WAD",        "170fcfb30f24e0437481bd389dc59083" },
    { "PARADOX.WAD",        "31bc6b1c59e49766ecd3c37507e8a33b" },
    { "PARADOX9.WAD",       "de5a79d1a1f2a9d482b35f14ad464bb0" },
    { "PARANO5A.WAD",       "3310e0058559ddea39e181b5e636f576" },
    { "PARANOI3.WAD",       "d89df0f373a4cfbbd4611e806ca0b235" },
    { "PARANOI4.WAD",       "948b82349692aeeb73f1b1e8bad81360" },
    { "PARANOI5.WAD",       "ad5d4873c9ae7302d2e4b0b16b4ea60d" },
    { "PARANOI6.WAD",       "adfec74a3aa9ea7c678376f54d0c61ed" },
    { "PARANOID.WAD",       "a738bc9046bc9173c0da7af585faad6e" },
    { "PARCH.WAD",          "de1bda4a208d523a6dcdc3cdd2504b78" },
    { "PARDISE4.WAD",       "ffca9a8c68ff5a7325c122fc6f60d115" },
    { "PARK.WAD",           "f951c47762ccead793fb5e7f5db76e67" },
    { "PAROXYSM.WAD",       "dc62113219b763ede06200c0b4655e34" },
    { "PARTHEON.WAD",       "afea63ba184acf7bb0ae963b19b3fb14" },
    { "PARTS.WAD",          "3f7c215c4f797ead88d3791c52a1f529" },
    { "PASDM.WAD",          "fb4a0cdca2de88eebbabae317e7055b0" },
    { "PASTIME.WAD",        "07fc6b0826b2e62954cb1b8e5417e23a" },
    { "PAT.WAD",            "3fb123099392f632972a5920954e31f9" },
    { "PAZUZU.WAD",         "e518035b69e5fd957566d3661b2194a7" },
    { "PAZUZUDM.WAD",       "2f2cab53c4174039e6153d505c97e121" },
    { "PC_HELL1.WAD",       "8b690b1c48e363b9157f367e33e971fc" },
    { "PC_PLAN.WAD",        "b71a47ff3fa09938b6d80850f6b6fe4d" },
    { "PC_SNDY.WAD",        "d9590b73a62974af62bc92097a9f7819" },
    { "PC_WOLF.WAD",        "e133f35b8519e3ba8f27768588e7b551" },
    { "PDDM1.WAD",          "485d7af9b364e4f70b907d5a0b6a96b4" },
    { "PDDM2.WAD",          "65c68481cac2ecec11c6c103c6e60ee5" },
    { "PDEATH.WAD",         "c113aa908ac8bc252de212dab780bd53" },
    { "PDGATE.WAD",         "386b4c7c2d7a7ecc67280205aa6386df" },
    { "PDN.WAD",            "00a2e06a59e03862c9030ae460d84f0c" },
    { "PDOX1DM.WAD",        "38f591d0c505ce368a9b80e43bfa50bf" },
    { "PE.WAD",             "b96395d6a3550b99dbf15e62e57e7316" },
    { "PEACE-D3.WAD",       "9562bf700f04df20962d6db2c0fa91d0" },
    { "PEMASTER.WAD",       "121c848f2c634173750283cce9158d19" },
    { "PENTAGON.WAD",       "2f73fab4cf59706aef7e41b5e90c6000" },
    { "PENTAGON.WAD",       "9a33cce28bbb53d21ec6c72ec852a324" },
    { "PENTGIO.WAD",        "6b06860e7bfb360c0147907f9b93be9e" },
    { "PEONKELZ.WAD",       "32cf498c2d4b18f67449787956fc933a" },
    { "PERDDM01.WAD",       "87fe8b50d6e5570c64c3486d80a1c3b4" },
    { "PERDDM02.WAD",       "52cc4f88cf7bbb5443dc463db8ea97e9" },
    { "PERDDM03.WAD",       "baaa30164a9d6e765c2a3d0defc8c688" },
    { "PERDDM04.WAD",       "251217187e5ed9304d7a2adb148272ad" },
    { "PERDDM05.WAD",       "052104ea10759b60935394e7f1250857" },
    { "PERDIDO01.WAD",      "4586a2e04f574beae1b3b5f88fc4e929" },
    { "PERDIDO02.WAD",      "8193e768db4b006f1d8fcdb46c25cfc3" },
    { "PERDIDO03.WAD",      "cae0c20a99cf01bc21dd548212d799ce" },
    { "PERFCT10.WAD",       "a4118fc3ea6af9b4f17c4e68527522ab" },
    { "PERFECT.WAD",        "9787a7e6a996fdb77512dbd4c8d40591" },
    { "PERPLEXD.WAD",       "43dfde4b1f16aa9b4fa9e421b258cc2e" },
    { "PETA.WAD",           "b15b28b1c6c1b5d653361186f5fa3bf4" },
    { "PETEDOOM.WAD",       "9ac88abb1d68d620ca26def2b528022d" },
    { "PGFX.WAD",           "a8e7946efcbe707c99b379ee10edb727" },
    { "PG_DM2.WAD",         "008ad291a94d6900bdb6e87813b73cd9" },
    { "PHANNYS.WAD",        "850f5d9f98c3e31b5e8297880a5715da" },
    { "PHANTASM.WAD",       "67c0899d783adac5e29263455669cdf8" },
    { "PHANTOM.WAD",        "1091877935199e00806fabc4eb394c27" },
    { "PHASE_6.WAD",        "cbdec093ff0d74cecfb69a4bee6ca6f4" },
    { "PHATTY.WAD",         "7da5c5412fa0d238300926af204abc74" },
    { "PHM.WAD",            "0b77d1e41744e41f2fe710c9cfd8f9b9" },
    { "PHOBIA.WAD",         "1e49986dd43822242e251cb409e8d0ad" },
    { "PHOBOS06.WAD",       "c7fdbb6695d2014020a54cfdfbdf979e" },
    { "PHOEBUS.WAD",        "a94c0c1aaa292468cf6ef3cec884eb65" },
    { "PHOENIX3.WAD",       "75d754f417fad38d21804dcee78c4a80" },
    { "PHOTON.WAD",         "08c97c2b2314b8137ac8c4eff9dfcb27" },
    { "PHUCT.WAD",          "c3812d3aacb7ed04aab7070c031aa1e8" },
    { "PICASSO.WAD",        "5d38815135fe133d6738817118b737de" },
    { "PIGEYE30.WAD",       "78b5ec9fed0a2b5e3d58cfedbe026c3f" },
    { "PIGGY.WAD",          "6b34cd09ff3b35cc5c08c41c483f666d" },
    { "PIGGYWAV.WAD",       "f067b3a1292de2865bdf5a256a8eef07" },
    { "PIK.WAD",            "84534525c4ef6f09e834ff033addf479" },
    { "PILLARS.WAD",        "3cb27a688553c3b99b968fb012505918" },
    { "PILLBOX.WAD",        "9b54546639afb9085c37d4aa995eabfa" },
    { "PILLCIRC.WAD",       "79e1ccf714d6036dad126be9535dad3e" },
    { "PIMP.WAD",           "d5e22ae4234f04d7692bee6dcfd48e1d" },
    { "PINBALL.WAD",        "e92ee3b64f1500ebb7547d9a96d5737b" },
    { "PINBALL2.WAD",       "d59dcac85f19cbb9cc3c7d99a024180d" },
    { "PINION2.WAD",        "295d0d7a5f3daad9ee4f964c24551748" },
    { "PINWHEEL.WAD",       "4bd5319e844b534bf56b9d8fdd4af2cb" },
    { "PIPE.WAD",           "f0fe525cd1795b08523d1c29ebbce82e" },
    { "PIPELINE.WAD",       "6b634f91f16542eec36bc635561bcb8a" },
    { "PIPES.WAD",          "0212556e40ae9bf7c6b04cedddf36567" },
    { "PIR.WAD",            "3e2f4c73a04c14d8c4c9eceec42bfc92" },
    { "PIRAMIDE.WAD",       "9c7322e8edaf38536bc123240d96385d" },
    { "PISA.WAD",           "0d2cded242017e65007b81301cbed193" },
    { "PISTOL.WAD",         "1c2a606d3d22ae6c2ab28ba1878c63c2" },
    { "PISTOLWP.WAD",       "7dcee4d2c0cff59e6738a49818b78512" },
    { "PIT.WAD",            "3b252903569fad580cabbd5f13c95b31" },
    { "PIT.WAD",            "f14486a741691197817b803a3b51a64e" },
    { "PIT08.WAD",          "49513e1977b398d6873fca5180634ce6" },
    { "PIT1.WAD",           "24ff2c6273c689cb4646c22ef91e7b8b" },
    { "PIT2.WAD",           "87479f463e48e61ab303145402d8c2be" },
    { "PIT2.WAD",           "94ec9d74de96f2e7f93fe364b119f0aa" },
    { "PITDEATH.WAD",       "07d1c27f7df85d38c77caa7cdae86c4f" },
    { "PITFALLS.WAD",       "e8a1254fb198f726849eef7f7de73a41" },
    { "PITFIGHT.WAD",       "3058b560c386495fb7aa067838e8c403" },
    { "PITLIFTS.WAD",       "79a030b3c30d6a723f6bcab79331023b" },
    { "PITOHELL.WAD",       "83b294bb4ff1e9183efb672b4f445959" },
    { "PITS.WAD",           "32bb226780a764493782c39f5d208eaf" },
    { "PIZZA02.WAD",        "241eb5f5e486cce48b273d3f36ae0cc7" },
    { "PJW4WAY.WAD",        "4a01c70a204516cf4130e042231973c1" },
    { "PJWCHRCH.WAD",       "e90440c48d71c531fbb31f7441a77992" },
    { "PKBO_DM2.WAD",       "5570cc4b29ca3777cc32e672bfda182f" },
    { "PLAGUE.WAD",         "0ab1175d8aee1d21de5a26155a50349c" },
    { "PLAN2.WAD",          "2f3d9f14a57e64ec8437c06a39cfbd60" },
    { "PLATFORM.WAD",       "afc9a45e68852a2c267d9f7b5345e171" },
    { "PLAYBALL.WAD",       "e2290868c744bf31f89f38d5167c533f" },
    { "PLAYGRD.WAD",        "c055aa9f7f25b51f683acec043a6767f" },
    { "PLAYGROUND.WAD",     "c4a5e85b6260e73a8dc45d6f0f8fba7f" },
    { "PLEIADE2.WAD",       "fc4836afc8d6c5df544c8b605fd0dccd" },
    { "PLEIADE3.WAD",       "8d8712fc276d966ee870ca59f5ddace3" },
    { "PLETH5A.WAD",        "8d4e1356438ef6629db3aba20945b343" },
    { "PLINCH 2.WAD",       "ae9256a84235d5fb16a86aa7f0328a6c" },
    { "PLINCH.WAD",         "b12b0b6ef7544b964d065e87c30155aa" },
    { "PLINCH3.WAD",        "44c98926807a8390586550d1a326cc9f" },
    { "PLUMBING.WAD",       "9421a738fd7737933facd6a44bb13cc3" },
    { "PLVLS.WAD",          "57e272a2de51c673c31bd1a64e13e6c1" },
    { "PM1523.WAD",         "d5ec9766d2d8e55ce0cc1e64c58d382e" },
    { "PME.WAD",            "dedcd76d548a212f8ed0c9e50220325a" },
    { "PMSDETH1.WAD",       "9d96c4e4a2a22d1f4dca7597ee88463e" },
    { "POBLA1.WAD",         "e8f534be1edf23526b5d42202de8418c" },
    { "POBLA2.WAD",         "d84454f0bd052d637c37d2e173be84b9" },
    { "POBLA3.WAD",         "581f3720182d78d04f9765fc8025626b" },
    { "POBLA4.WAD",         "79f2196023e64c7a7cfa5ecff5da9a81" },
    { "POBLA5.WAD",         "d735e306e2e224f5442b518a549a6e20" },
    { "POBLA6.WAD",         "ddc78435ec181fac3416a2c14f798567" },
    { "POBLA7.WAD",         "8822acbf4c5b422255a923bd1c00b3e8" },
    { "POBLA8.WAD",         "c0979a9bb638b99514a2185e17500884" },
    { "POD.WAD",            "927faf04ec051c2bb36dc448177fa135" },
    { "PODEATH.WAD",        "1b576288f022013c3877627250094e06" },
    { "POLLY.WAD",          "627b2d2a217196ec4bf851cbbf77aced" },
    { "POLY.WAD",           "0b582308b5356fb622882ac0d1311874" },
    { "POLYGON.WAD",        "f79a0225c8a985442d33c2ea0a698016" },
    { "PONR2.WAD",          "55bb06f81571bd06d78cf956a4bce87d" },
    { "PONTE.WAD",          "1939c134588be660de6e1337d686ab05" },
    { "POOLPARTY.WAD",      "3973ec5d01ff60b3d2a30cc449c28031" },
    { "POPPYS.WAD",         "657ebad363e8f5ed5e6e6163ae75f511" },
    { "PORK2.WAD",          "742d02cbc31f287552d8dec110018d15" },
    { "PORTUN.WAD",         "4bd254559d77b15550a0122063d4a637" },
    { "POSSIBLE.WAD",       "0b0adedc0e48fcf9bbee1808c9708126" },
    { "POST.WAD",           "e18bce00918336eef7d115c48c926996" },
    { "POTCITY.WAD",        "9f4c35f8f4d4c2560c4b4c54e4bad42d" },
    { "POTSHOT.WAD",        "e2b39d187d3490e5cc419af8e54ac5ec" },
    { "POTTER01.WAD",       "56a93006ab7f77685bfdc345573a70c7" },
    { "POWERDM.WAD",        "80c302973f8cfc2a9a62bb0859601e16" },
    { "PPALACE.WAD",        "483f262d307d9bf8ddbf22f0ece6af5f" },
    { "PPE.WAD",            "d19df251ee7ca63e2ccf4af573a77673" },
    { "PRACTICE.WAD",       "61a78569bcfa2b391c6243bc2a25c50e" },
    { "PREDATOR.WAD",       "9e3f0c9984b3c1ddecefb16b1f8a140a" },
    { "PREMS.WAD",          "0642c5ddc5573bf245b911acf6985708" },
    { "PRESENT.WAD",        "8c74460970e241d470d00c5d0b3d4e2c" },
    { "PRESSURE.WAD",       "f2f25985aa78bfd0f6cacde992254081" },
    { "PRETTYDM.WAD",       "01e3104410e9716137a32f7b4f7e3f1e" },
    { "PRIME620.WAD",       "ac67d12012841d088f4a208cc150db86" },
    { "PRISON.WAD",         "51eac852dbdb4aec47a06a7854b0a7d7" },
    { "PRISON.WAD",         "f450c94980fb5b601a75fc88e6651cd4" },
    { "PRISON10.WAD",       "7d1040e43aa45acaf4350cab6d67f744" },
    { "PRISONS.WAD",        "7cc98d6bb0d6a216519c2f82d4b3a702" },
    { "PRJ666.WAD",         "a1844df62e2f00e1c8a988dda13952ff" },
    { "PROCYON.WAD",        "d9913f2e7f06d15069469fef0fcb6bb2" },
    { "PROJ-X.WAD",         "16d41535176bed30c78d477bc266d1d3" },
    { "PRONG.WAD",          "d1aae9b5cc483bf12fcc418c9831b4a9" },
    { "PROPHET2.WAD",       "f4a1f4b1810ac60ee2314d1fb720a4d7" },
    { "PROPHET3.WAD",       "170945dfd4721e198ec0e06986a9c3a1" },
    { "PROPHET4.WAD",       "db7d5e5be42abd035320ed6c2bc901f6" },
    { "PROPHET5.WAD",       "f30b1662a6ef8309d33cbdbe06d6df70" },
    { "PROPHT1A.WAD",       "ff430dd1f98ff766e4dfdfe7946647d1" },
    { "PROTOMUD.WAD",       "dc89a0de80e03c60ee7333b8f6796f1b" },
    { "PROX.WAD",           "bde823d30aa403ad7e9d15f305729b83" },
    { "PROXIMA.WAD",        "3ee1228809b7beffd70a1b1ec238189f" },
    { "PRPLSION.WAD",       "bd6d80b8d9cb5441056d8fdfaece6801" },
    { "PRSCNFC.WAD",        "adfbb9f7020551b660248de4cdb04fee" },
    { "PRWRANGL.WAD",       "618b206a05491ba5ade4c65fdd757f48" },
    { "PRWRBAS2.WAD",       "82761683b31d3f40315f7a53698f9a70" },
    { "PRWRCOL2.WAD",       "3d6f9f56a707227623cbc3678cdb1e25" },
    { "PRWRGAT2.WAD",       "411907305fc927b5aadc9f58f0717c69" },
    { "PRWRHELS.WAD",       "56de090f8ce970e55c90fdbe096732d9" },
    { "PRWRNXS6.WAD",       "e66b988d9c39aa95d1a41982c582d5ed" },
    { "PRWRRVN2.WAD",       "39ba0d2f31807083b6718e5e59e38d05" },
    { "PRWRSV01.WAD",       "f11e50f3152517efe6123df42b8ee9b7" },
    { "PRWRSV02.WAD",       "0dfc560af79ab1e63484d1ed1ceab932" },
    { "PRWRSV03.WAD",       "6b2ae5e3dd898a816dae66fdd8cbc9e5" },
    { "PSORIAC.WAD",        "c47bd7ccd0df597e122f683ec4e0970d" },
    { "PSOUND.WAD",         "e4f1f4c8cf37383a4d4b4576975bd8af" },
    { "PSP.WAD",            "c6822c1344dcafe560793458541f0c40" },
    { "PSPRITE.WAD",        "6ff5c9a0949cc5a544650ad0b07dadc9" },
    { "PSTATION.WAD",       "5623d61c17d09a8e8cc12ffa2a8e0b00" },
    { "PSYCHEXP.WAD",       "873619918139f4b52975aa5c8775264c" },
    { "PSYCHO.WAD",         "b4f699467e52fd3cb9c922ec4e72ca2d" },
    { "PSYCHO_A.WAD",       "d0612eedecca70326c35054388cd927e" },
    { "PSYKIKTV.WAD",       "78bae02162ce8bf2c80b29a23e9208b7" },
    { "PTL-HELL.WAD",       "3cef9c061ae027c3eb8028428e28eb00" },
    { "PTWAD!.WAD",         "002a1c48465565ec9f8b1c344399f9bb" },
    { "PUDWHAKR.WAD",       "a58209092c578f68d24eced42c9fbddc" },
    { "PUEBLO2.WAD",        "393b806b2bc34abc0c556dc506427342" },
    { "PUNISHER.WAD",       "407424b75169f81d9ce2bf535b8e2472" },
    { "PUPPYDM.WAD",        "2ca16a53eb9587049be37534219648b7" },
    { "PUREPAK1.WAD",       "9619ad7088130128448ba966adeae20e" },
    { "PURGA2.WAD",         "55e3e1bd7a5bcdb49bef40a25b2ff468" },
    { "PURGATRY.WAD",       "947a21fc801d1cfa001103ca717f9e76" },
    { "PUZZLER.WAD",        "50802c45fc68394a76557667748fb6fd" },
    { "PW.WAD",             "dd906a99e8161420763451d9ea714e33" },
    { "PWRPLANT.WAD",       "4af406dfc6e0b321f8474e19d973ce2a" },
    { "PWRPLT1.WAD",        "f2688330f7fbe9f36ef35b70d8414934" },
    { "PX40.WAD",           "f6f7dd44ebfced1525ab3a1a1ec62397" },
    { "PYRAMID.WAD",        "1e69da4a7beb247fa94f6e22bc89672b" },
    { "PYRO1.WAD",          "2ef8941dd5628290950c4926059a4127" },
    { "PYRO2.WAD",          "3acec73fe329fb18620508abc6ad3ed9" },
    { "Q-ZONE.WAD",         "0ce3e86accf3853c5cf5b9ee58a60db1" },
    { "Q.WAD",              "e1e75c073bb220c740204bd933967682" },
    { "Q1BDM.WAD",          "a55cdcebdda00119794942d575300b64" },
    { "Q3TIER1.WAD",        "78878849ab3207e1df7a971847a93544" },
    { "QADDMWAD.WAD",       "6b383c1892051d4b6b0d9ffb83469a49" },
    { "QDCTF.WAD",          "d91c617963778d2a92ad0e7b9e88d53c" },
    { "QH2.WAD",            "d53122bcac1b763025f2b8793a7b73ad" },
    { "QRK.WAD",            "c1fcf6bc5d656b819d02095708173598" },
    { "QSNDS.WAD",          "d9c83a134f134f0f9268c1b92a08deea" },
    { "QTBUGNME.WAD",       "2b950f38218467d9db9bb1adaf71293c" },
    { "QUAD.WAD",           "f81ac58452412ad8c3f6b328d23dfdbc" },
    { "QUAD2.WAD",          "0ccec462f0a9fd150a34c54233cb00ef" },
    { "QUAD37.WAD",         "fd73bfeb58a4ac418f23e8d3ab91705c" },
    { "QUADFOUR.WAD",       "ed18016e32fb71dfa37cd8b177695b0c" },
    { "QUADIUM.WAD",        "5b1ad734275567dfb2f712c6a59401c4" },
    { "QUADKILL.WAD",       "457510ae75b99fb440eed2c97be55839" },
    { "QUADRANT.WAD",       "f2e1e8e296665f81c9e8ce0cc8b8dd11" },
    { "QUAD_DM2.WAD",       "f99e09022b0a2ec4d7f875e61b2f04cc" },
    { "QUAGMIRE.WAD",       "78b12eea9dfef5b50d9b1866103cfa37" },
    { "QUAIL.WAD",          "21cffb16d650a7b4a5ad84db30fd6838" },
    { "QUAKE.WAD",          "57358c0dc16b124a3961279fb80449cf" },
    { "QUAKE2.WAD",         "a09b05d2533851e0e6581a19410d8f0a" },
    { "QUAKEDM.WAD",        "6596d4f0255442d9395ed7a5a3d15085" },
    { "QUANTUM4.WAD",       "e213752c1b1172b1fb039a685f17441d" },
    { "QUEST.WAD",          "06ccadf17cf2fdf68963f7f531d42eca" },
    { "QUICKACT.WAD",       "2cbdfbffac6d8adcf8dbf293e686bee2" },
    { "QUICKIE.WAD",        "11f4959e5dbac723c0ec914be2246ae4" },
    { "QUICKN12.WAD",       "acfb4fe1c11018547d959f20c2d6b0ad" },
    { "QUIKDETH.WAD",       "45b2f408a8408033c1a1f5239969923c" },
    { "QUIKDTH2.WAD",       "ac462b477e5827caaa28b18bad18f095" },
    { "QUIKISG2.WAD",       "7b3e6bd06382404709d4fa208298abca" },
    { "QUIKISGD.WAD",       "86613cee92efcbb1b5b6298a0deae537" },
    { "QWIK.WAD",           "f7a7bbde6a25eb7ac27977690c3973d9" },
    { "QZAR.WAD",           "e961042ca3bff7343493f62773533ca9" },
    { "R-MEGA.WAD",         "ad2bcbdf4f866f1742e3059e168caf37" },
    { "R-SWIRL.WAD",        "478c3143ed1f506c299801b41e1c98c1" },
    { "R2TEX.WAD",          "4848ce57f95085c7d560bf5f5bd3def8" },
    { "R91.WAD",            "3aebf3b38038801dd616ff2d1b301735" },
    { "RABBIES.WAD",        "09827a73526b00174fb6bdb409072e77" },
    { "RACE.WAD",           "2ce52a33f4538937b1f8e46f0bff7a6c" },
    { "RADIATED.WAD",       "c9211b60a71078f51cfc04200aea9bfb" },
    { "RADIUS1.WAD",        "2ea9d0159546f1fa40f6b5de18899207" },
    { "RADPLANT.WAD",       "54f243eb92e5f43ee9cf2b6d07eadfb6" },
    { "RAGE.WAD",           "084ec8dad47b0842d2db68020d1e7fed" },
    { "RAGEDM.WAD",         "559fee24b15a29b8a6902be812646771" },
    { "RAID.WAD",           "86f592d10da974ab3e8c25ab8d82fc3a" },
    { "RAINBOW2.WAD",       "11c66776d4f1a3e71d4ccd68924326c5" },
    { "RAM13.WAD",          "ebeb8f68018f20f482dfb443f8f6733c" },
    { "RAM16.WAD",          "a64e1b1b2bd9e9b06c0e8542df80c9ff" },
    { "RAMBLEON.WAD",       "43e15d2b63e972548f2f5c62efb28e71" },
    { "RAMDETH.WAD",        "556eeed6468c97ed2cb3d77611134d05" },
    { "RAMHITS2.WAD",       "84145934a24bce53a9fc87a1547068fe" },
    { "RAMPAGE.WAD",        "8af22ce8ace9913c2545514e13c1c34f" },
    { "RAND.WAD",           "d7d241679018d7c5bf56b673f2e53868" },
    { "RANSOM.WAD",         "8f969c7e54600bb3c41098a49c2b5ab4" },
    { "RAPE2.WAD",          "ee3ad78e00aae5c5fea8a75b67e36e9b" },
    { "RATNCAGE.WAD",       "a1029589d00b8856df7cff98ed926b5a" },
    { "RAVE.WAD",           "8ef9eb2464281cf9d50c8d17ec65ec1c" },
    { "RAVEN.WAD",          "cadc821117fcca4655622a1b9b8c4f77" },
    { "RAVENLFT.WAD",       "bf1392a36abbd4ed7c275041423c652a" },
    { "RAVINE.WAD",         "e4c3177f1b83e134f9a116f8dd09d6fc" },
    { "RAWDATA.WAD",        "c22ba628ed382bf630852af89cb9dc34" },
    { "RAWSEWGE.WAD",       "ddb61ddb82f3bbd48ffb3871cd02bc49" },
    { "RAZOR.WAD",          "5b6a60f2b9f67446d2b985344b364f3a" },
    { "RAZZOR.WAD",         "a89ea816bebe4328d9aab473128df3a4" },
    { "RBBTHOLE.WAD",       "5bcbfcc9f2088f2f37f2ea037c608692" },
    { "RC00.WAD",           "97fbd729f1119f6933c0c789f1bf7bd6" },
    { "RC01.WAD",           "7a11ea94c3676af26a269ceecefbcd84" },
    { "RCTF1.WAD",          "d72e3c823755a8421b55f7ebcf9ab1a0" },
    { "RCTF2.WAD",          "d01de6d5277d3b7c02e85ded823d4e34" },
    { "RDMP.WAD",           "f5bb69c1e80c90df2b945c909b040918" },
    { "REACTOR.WAD",        "1d841450b4c1c26cd2476ebba96c674b" },
    { "REACTRFV.WAD",       "6ae8c1201bf6ebfbd2bcf8459c8ef390" },
    { "REALCOOL.WAD",       "ca05eede67d58db824bee189c0b43b6a" },
    { "REALDM.WAD",         "df8082d24ec6f697cb24514b0b9f6a80" },
    { "REALGFX.WAD",        "db42f50b4f5e500e0c144caa05aa64a5" },
    { "REALHELL.WAD",       "09ea1c2549dbae3dfcdb59301080eb10" },
    { "REALLVL.WAD",        "10ab3696bb19302cb0933c7fbafe99c2" },
    { "REALM.WAD",          "c617cc433f9afde6ec6f2bbdd0fdb3f6" },
    { "REALSND.WAD",        "6e843f204c8be104dcbf82e63c1c1052" },
    { "REB02.WAD",          "b0c2e1be81caa145730a7c692e56d3a9" },
    { "REB03.WAD",          "d56ac7b03b0ef2ed56f94491f0295ffb" },
    { "REB04.WAD",          "06e6e24059ccc2809a62676f592de5e0" },
    { "REB05.WAD",          "e1ee423b677e15d5bfbb2eb2657cc9b3" },
    { "REB06.WAD",          "ca3f0bf27fa8c7c6857aed69f04467c3" },
    { "REB07.WAD",          "c75a16e30e9e215299eabf7daa3548b3" },
    { "REB08.WAD",          "463809efe0e3fe8a1fe3a8e943edf953" },
    { "REB09.WAD",          "49211ffcad6b7422521d227f9a50e64b" },
    { "REB10.WAD",          "4c0487e4b87ad61cbbad81a408df66a5" },
    { "REB11.WAD",          "e239da3197e54ed050dd730d6709cd4f" },
    { "REBEL.WAD",          "be8db61f9d7e6e2c937340e9687f96d1" },
    { "REBEL2.WAD",         "87bca2c58cc7df7b1f39f5fa03311bf4" },
    { "REBELION.WAD",       "092023ce4ebbda5a2d74f93bbd56c9f5" },
    { "REBIRTH1.WAD",       "f7c2ffd5dc23272a2531c3a0d4eae272" },
    { "REBOOT.WAD",         "1f4b44ee7ffa204c76608320343c2e0d" },
    { "REC001.WAD",         "2f4a2643d8080f28f4321977e305272a" },
    { "REC002.WAD",         "c7139d70c5ba52b09b4799b3759f8033" },
    { "REC003.WAD",         "aa4fe658134d16be7730386456266704" },
    { "RECLSD.WAD",         "dd98bd5abbc060d0d17d2bc4bed11535" },
    { "RECOIL.WAD",         "a497304c99c27d49eadde60de6e0f63c" },
    { "RED.WAD",            "5aa77397e7b150d4f8732db3bc8c5b2c" },
    { "REDAY.WAD",          "f98054c991be7f73c5fc8449feb7cbb7" },
    { "REDDOG2.WAD",        "f9912d58c56e34d501d73a516c7d3a0c" },
    { "REDEYE.WAD",         "35fccf4c365675b240a6f00a9250c2f9" },
    { "REDGORE.WAD",        "b3926f172cb882373b323772cd702890" },
    { "REDKING.WAD",        "ab947ba7087b363acd5f67ce1e3b374b" },
    { "REDS1.WAD",          "7cbebd0dff3c14e1810843cf6bde3421" },
    { "REDTST.WAD",         "8030a5d03ffff99be52406614d3db2fd" },
    { "REFINERY.WAD",       "94ae3f8c5b3c29179cda4931520f6401" },
    { "REGULUS1.WAD",       "19c31a34529e18c0348c0aa6c9a9830d" },
    { "REGULUS2.WAD",       "24a13d01e510d45286b4b2341578bd00" },
    { "RELIVE.WAD",         "b0f49b51d7b28e21fccc5c237cd20dfa" },
    { "RELSI.WAD",          "909c468149bb1d7cfae6ad9db2282b52" },
    { "REMAINS.WAD",        "7f8b2558df977b3e578027e7540b4dc2" },
    { "REMAINS2.WAD",       "809f2002943ba404639623efd84f0064" },
    { "REMMY01.WAD",        "139769f2297a1f2d8af72ec682aa5ea7" },
    { "REMORSE.WAD",        "aa4addd67546c6aa4c6490b142cf3240" },
    { "REOLWOLF.WAD",       "d0e64f69dfcd6bd0fab47026d83aae0e" },
    { "REQFIX.WAD",         "07e75ad232b33cebd9ff4ff4edff2405" },
    { "REQMUS.WAD",         "dee390a1a5f38a6d58697de1f27bd6f8" },
    { "REQUIEM.WAD",        "f5bdfb5a32ead6f8c642fc13555074de" },
    { "RESCUE.WAD",         "f850d31bf5a29f612bd20ff42980c660" },
    { "RESCUGFX.WAD",       "5a808f6a347c79057337d565a7cf118f" },
    { "RESEARCH.WAD",       "e1f38acb1d9e5248ecc6e4f35de7fef7" },
    { "RESIDENT.WAD",       "16f94628bca1c3a10b0fb24f5025ae99" },
    { "RESORT0.WAD",        "ac229ad0da9c9a208108548775e39131" },
    { "RESOURCE.WAD",       "95a86e7a6da646099d3e63dfb8232069" },
    { "RESRVOIR.WAD",       "031b187b9f5abda3a006a6f53c7161b4" },
    { "RESTINPC.WAD",       "bc37a4db53cffec6d649353e1f12de7e" },
    { "RETROGRD.WAD",       "0c822cbaaf9299738f1a64ed189e203c" },
    { "RETURNPHOBOS.WAD",   "34634526cdf4435b1ee562b40c085766" },
    { "REVCAGE.WAD",        "26c727d797e4c939f10dadbe596b5813" },
    { "REVENANT.WAD",       "eceff55f8aa8d51ed1ce7e71ec17cffa" },
    { "REVENGE.WAD",        "fbfb4127c121a3ecee231a43e34072d2" },
    { "REVILE.WAD",         "d16fee60eeba5ef8bf73f2cf31f6a22e" },
    { "RHAPSODY.WAD",       "5dee9d4f156354a2882a50c2d72a1ecd" },
    { "RHEA3_ALPHA.WAD",    "5bb749047bce947753bf5464e99da497" },
    { "RIBBED.WAD",         "d7c5bb68bd7f84f0253919a68b278870" },
    { "RICK2.WAD",          "cbc5f4c44404f339389bcdf940f3595a" },
    { "RIDER1-4.WAD",       "a7724240d869c2d126c7a8f74c3574e6" },
    { "RIESA.WAD",          "6b84881560876e9427bc831863472e8c" },
    { "RIFT.WAD",           "8b408f6c84f8e7b21bd4b986bc2e5783" },
    { "RIGEL1.WAD",         "6e2787da322a2b9d311f9ff4d54189c9" },
    { "RIGHT.WAD",          "72cedb517d10e27f72631d27bf26d737" },
    { "RING.WAD",           "ba8c1aa1939196d680c5e7eeb8a1d565" },
    { "RIOT.WAD",           "eeed530aa0961f3bde1e937134644564" },
    { "RIPIECES.WAD",       "f727d522622fbcc4a53a1bceb7440ed9" },
    { "RIPPEDIN.WAD",       "b34c33f488546e7fbcbf752f2b06220d" },
    { "RIPTEAR.WAD",        "25cb435fa0b53610ff72332cef3bb013" },
    { "RIPZ1.WAD",          "bc487dae520503c025d6907f737373cf" },
    { "RIPZ2.WAD",          "daf9ba5f3388c7265ec35cf91683d638" },
    { "RISE.WAD",           "a35a01df232e414a1f3facbf378c0f12" },
    { "RISK.WAD",           "afc778eff45e000efa6db163901e85ee" },
    { "RITUAL.WAD",         "999f8ee6fa71ad0e3d696040d9768478" },
    { "RIVER.WAD",          "7ec91febb14ed2904ca15e2e2fb1e2c2" },
    { "RIVER.WAD",          "a985caef5716ea5e84d6d5047855e938" },
    { "RIVEROD.WAD",        "bde0723fcb9e6d052f97526ff96199db" },
    { "RJANIM2.WAD",        "ab9ecda6c877c5bf44e9bade6dfe7c32" },
    { "RJGBLAST.WAD",       "3d979e70ca255d46b85257c2bc931eea" },
    { "RJGNIGMA.WAD",       "e172e4e609d349f84c5c75bd614c0141" },
    { "RJGSTARK.WAD",       "dd135ea8fa6a3b8765370f225ea287ce" },
    { "RKHOUSE.WAD",        "d2886f178a7c6688bb04db023f0e7db4" },
    { "RLARENA.WAD",        "ffbe1346fa6e3ebaa91e5afb164fd91e" },
    { "RLMCHAOS.WAD",       "eb34e40a6177420edb46b5c1c9de3bba" },
    { "RLMSPAIN.WAD",       "0a9247d3ece330bc41d3b3c96c7c977b" },
    { "RLMSPRT.WAD",        "e6bfe74c950bcbb11778b2c5ed9b5591" },
    { "ROADKILL.WAD",       "a60a9ffb8ec6c7738c9a5eb3cf8ddaa4" },
    { "ROAR.WAD",           "c45d6f283c8b745b26a755600a37ca58" },
    { "ROBBIED.WAD",        "b027556b233310f40eca37269a3eee2d" },
    { "ROBOTOWAD.WAD",      "6ef2e2e7f6885a9aacbba7896258dfc6" },
    { "ROBV.WAD",           "6dc7a56ed8e3a57920b2c96537c23926" },
    { "ROCK.WAD",           "74d7e80934f865a9a4c997c5af27dedb" },
    { "ROCK1.WAD",          "e3663038a6a5cacd5069475fa15e09aa" },
    { "ROCK2.WAD",          "1d80e006be01947418333119b319c716" },
    { "ROCK3.WAD",          "fca8eb8225166a5e248d1d5594daee4b" },
    { "ROCKER1.WAD",        "0da98827c783f6ec39c528525ce9303c" },
    { "ROCKER2.WAD",        "04143357552b6dce5620d1575d0a6344" },
    { "ROCKER3.WAD",        "7d9e9b84d18850ac7eae43d5a7618304" },
    { "ROCKER4.WAD",        "3be8317ae662f7e854b85048aab9619a" },
    { "ROCKET.WAD",         "8b91019e9430d13d7ac67de5671dadaa" },
    { "ROCKETS.WAD",        "f3d1d965caa1b6a74672f374de4ac013" },
    { "ROCKETS2.WAD",       "88bc18959d12f615fbd2312a1ce0fa67" },
    { "ROCKISLE.WAD",       "4f5c9160a9c221897f53404407656551" },
    { "ROCKME.WAD",         "957a7bfb5db040ebf05df70407bcd2eb" },
    { "ROCKN.WAD",          "b2cad9923c61524f239a59b057c3b5b1" },
    { "ROCKOUT.WAD",        "ffd321baf9cac4cb06c95c57e32c3ba9" },
    { "ROCKSHIP.WAD",       "ec28ffac8010fb220b5a0be2422efddd" },
    { "ROCKWAR.WAD",        "29ad4ca2f0537cc59600a85e49aa6d9d" },
    { "ROCKYDM.WAD",        "29996e881b03f32e268839133ce49fe3" },
    { "ROCTAGON.WAD",       "809eef551d5cdf97c5474ec15505eb97" },
    { "ROCWORLD.WAD",       "d9fad07fb208492a67f9f76c9d31ef77" },
    { "RODALE.WAD",         "ba33ddd6b2084c99c958fdc151fcd82e" },
    { "RODE.WAD",           "0c1b9953718401cb86c0af1696fc9954" },
    { "ROGUE ELEMENTS 1.1.WAD", "6df4a3955d6498556d18f2e66897f4b4" },
    { "ROH.WAD",            "89f9eb8c8782488129c7f4a0134df040" },
    { "ROHENH.WAD",         "8eb3de1ae208f8d82497b87c0df8ebbd" },
    { "ROKETEER.WAD",       "16a66b4709a7404ce5b65d9a5455a2ce" },
    { "ROKSRA01.WAD",       "8dbe0b92d09d2272c0751e428aa0b285" },
    { "ROKSRA02.WAD",       "dc5b972d3a5a5fddcee7eccb2df74d4d" },
    { "ROKS_MA1.WAD",       "1fb9a35b8ca6a48084883af5ed95c35c" },
    { "ROLSDEMO.WAD",       "8ffb5d2cd3ea514163f0e85038638058" },
    { "ROMAN.WAD",          "8c2219e5f4efb4730831116947ce8660" },
    { "ROMAN2.WAD",         "608c41cdc8fd855a7c92b1c6ae9b6eff" },
    { "ROME1DM.WAD",        "e2ebe3c987db4990991dd9a2cc86dae5" },
    { "ROME1_1.WAD",        "a1d0c1b266c8ebe2e6a2ce7a9a824097" },
    { "ROMERO.WAD",         "f516e6a7abefc2eeaa3969ff5582e064" },
    { "RONSDM.WAD",         "c90010e435cdc5e8f18029285a98ac2f" },
    { "RONSDM_2.WAD",       "13029cee49318f8d02ec4efcbfaf871a" },
    { "ROOFTOPS.WAD",       "1880f78a2c8e77ef42f30818def0ed5b" },
    { "ROOM.WAD",           "8870489871b33f420a0048b00d912fc5" },
    { "ROOM2-1.WAD",        "ec29576c3cba20e092f4e6d95ecd8d9b" },
    { "ROOM2-2.WAD",        "c11bbd1de48be139f2f29c111167cfee" },
    { "ROOM2.WAD",          "fd45503e2c40a6dd67127da2c2a6d5bb" },
    { "ROOM2F.WAD",         "e6e79ff698cd05dd49c3f8a85735de98" },
    { "ROOM3-1.WAD",        "160ee80498c145e3660669ea1d9b4e41" },
    { "ROOM4-1.WAD",        "5920fb49fade8838bef45d04337e5d9d" },
    { "ROOM5.WAD",          "114f04e1dba704b85dc6f7652f0b0140" },
    { "ROOMS.WAD",          "93937e43cd324e6c5cd93985a9922e2c" },
    { "ROOSTER.WAD",        "fb9c1535c5d0f1ac0d2ce8fe6c009940" },
    { "ROOTS.WAD",          "085162f5f547a65a76b4cb8993105afd" },
    { "ROPY.WAD",           "37acf812f2ea745d6cfbc74967c20aa3" },
    { "ROPY2.WAD",          "ec0c5cff7ea8aaa6a876677248117e20" },
    { "ROSLEV.WAD",         "08ca931eb9238a32870e7d0d34fec21d" },
    { "ROSMUS.WAD",         "99962bee174c008f497c3e4afdc79353" },
    { "ROSTEX.WAD",         "180f8a00bbd568d9438b1681d85cf461" },
    { "ROTT.WAD",           "750b209354f69b053052f05e554d7a71" },
    { "ROUND.WAD",          "ce772881469708e34fc9a07309c2bcd4" },
    { "ROUNDETH.WAD",       "8b149882a273083cfa5e197549356acc" },
    { "ROZINGA2.WAD",       "5436a73ccb45c768aac8353b16278bdd" },
    { "ROZ_01.WAD",         "b376c2419393ceae4a9f983483738b0c" },
    { "RPT-03.WAD",         "ba73d4ee578a895a4fb2d06d64c5d580" },
    { "RRCASTLE.WAD",       "6c834ce02a18d5b6c6cab1ec7f045fef" },
    { "RRD201.WAD",         "0f5e70aa107b05bde7132ccb603f0502" },
    { "RRW_D201.WAD",       "b48cf19654f7ed80d9cf45f3ac56f782" },
    { "RSG.WAD",            "c24af2334f7f0c2b8de5d36aa03eac4e" },
    { "RSPRITE.WAD",        "37e5204270bc1c79a7a0786bd8bdb320" },
    { "RTH2.WAD",           "427b4327a65a80083ca0966e1d297de5" },
    { "RTH3.WAD",           "b825cef4de349fd752e92a0941867a81" },
    { "RUBEND.WAD",         "180b04c009ad9ff46ba8fbf0ec68471a" },
    { "RUBICON.WAD",        "6ece2f0553256f96204c88f441eb41a7" },
    { "RUBY.WAD",           "fe5b9dc1f2f2d7624c2feabbaba8dfb1" },
    { "RUDEAWAK.WAD",       "e7c39c14f81bfbb0f5a6b3ef11e2030c" },
    { "RUDEWAD1.WAD",       "f7033c203f987fa8298cde59956502a0" },
    { "RUICONT1.WAD",       "bb2185b5d820d8eb981a67c4586407d0" },
    { "RUIN.WAD",           "f59831f7ad66270f190b9b932ed69782" },
    { "RUINBROS.WAD",       "939fe320d91a817729b1232ee4552db3" },
    { "RULER.WAD",          "f9ec17d5097a9edcd0d34d1c8b6a2a11" },
    { "RUMPUS1.WAD",        "de194489e7719207ade38b48aa365353" },
    { "RUN.WAD",            "e99be84bba9a3ae9a60687aeac4334cb" },
    { "RUN4EVER.WAD",       "dcdaf5e25e5f3869cb955c2f1d2df279" },
    { "RUNAWAY.WAD",        "48620f25eb822e3b11b4b8faa4420433" },
    { "RUNAWAY2.WAD",       "d5bc639665c5a9f62546faddb6929a84" },
    { "RUNDOWN.WAD",        "3e613a25abf69ce143180b12fa7d9d77" },
    { "RUNFSTR.WAD",        "61e228c845cbaa36b3098973496eeb0b" },
    { "RUNHELL.WAD",        "2bc630f58ff611d787932c5a91761995" },
    { "RUNLKAMF.WAD",       "9b574e5def4db708d211d1f41bfaf7b1" },
    { "RUNOFF.WAD",         "e652770a48d6288469c1a4639050af4d" },
    { "RUNOUT.WAD",         "680ae1c71b94dd166aa5b11dbd0dd974" },
    { "RUNRIOT.WAD",        "7c3e0e3030c37344a1c653a15ececacb" },
    { "RURQTA.WAD",         "45c46e52f5bd7adbe53d072994072624" },
    { "RUST.WAD",           "ceea8113cb3ad7e1a9f3068a995ececc" },
    { "RUUNDER.WAD",        "53f498249026f625f05c6d8d9fcc9972" },
    { "RU_A_MAN.WAD",       "a52b7106853c8282cf6c83c6894e5ee9" },
    { "RVROFDM.WAD",        "c72cec74feab3531fccc9e46e60c8a34" },
    { "RW.WAD",             "cf6b2f07af8b8919654ffc77f4f25719" },
    { "RW2.WAD",            "c98a320717fb1e4d72cde55a09c62a3b" },
    { "RYLETH.WAD",         "4f38ae86fd49ac9ae4b591565aebf8de" },
    { "RZ.WAD",             "2d52679d65ca1541f551822236e7cc5d" },
    { "R_I_P.WAD",          "045e4f80881fe043cbdbe17f4c16fff9" },
    { "S&JV12.WAD",         "047598098c4a1138fe0cd42633e7290d" },
    { "S-X9.WAD",           "b642e2c11318f3e63814138930bd6259" },
    { "S666.WAD",           "2504866bd70183c8e835bd72d5293c8a" },
    { "SABOTAGE.WAD",       "cb256af5a73e133cefc4d8941ed7a919" },
    { "SABREMAU.WAD",       "707fda8432d683ee0e78144a7f57ddd8" },
    { "SABRMAU2.WAD",       "48d57287eebc3fb55aa70fe7a083294a" },
    { "SACRED RUINS.WAD",   "59fe166e2e3f6195c407dc8e8e667583" },
    { "SACRFICE.WAD",       "fb89421fa649f7cf1e0244c9bbc8c469" },
    { "SACRIFIC.WAD",       "7bc1c8720a9af10b3432f0e1a166c545" },
    { "SADDAM14.WAD",       "c8caf3dc809708156768ef3d688ceb13" },
    { "SADHUSCT.WAD",       "b392082a17a517c89f2e821060cd1c96" },
    { "SADHUSTT.WAD",       "1eec917b30a24c8927c49361565d8c9e" },
    { "SADO.WAD",           "d7e9bc21666901c1f1d39912e2c18fb7" },
    { "SALAD.WAD",          "9c7d55ea1054acb39658dea226532ee5" },
    { "SALEM.WAD",          "babd7b1df626462b5b783b653672e8a8" },
    { "SALSA.WAD",          "da8ad745c3c0d4bb3645b05d4c423211" },
    { "SALV.WAD",           "92afcc7b6a0c21d5e023f8fe2888b67e" },
    { "SAMAHO1.WAD",        "b78b0814b013610d98255ff944c71416" },
    { "SAMPLEDM.WAD",       "5982ed6d8e732aa3ed828b6c3d251666" },
    { "SANCT.WAD",          "0bab822d1c741e3e00e7a4eafdecbda7" },
    { "SANCTUM2.WAD",       "96d50237423e3410682abdc6019d3dfa" },
    { "SAND3.WAD",          "bbec9e50aa5ef146ca6368c799a6c8c2" },
    { "SANDMAN.WAD",        "bce81beb82e2d6273871fa918b0f5a84" },
    { "SANDSKL2.WAD",       "3397733538d3b2b3986a603d43352101" },
    { "SANDSKUL.WAD",       "1b02af949352a58be18458d25a45cf7a" },
    { "SANTA.WAD",          "65d465758cc59ca46514a12657cd8a6e" },
    { "SAPPIE.WAD",         "9003b81aa7ded5d8d6d7028a5e4dc533" },
    { "SARGCITY.WAD",       "bc7e0498c7f53ae4a6e27705cc2db3a3" },
    { "SARGEZAR.WAD",       "058e53f8e0b018229eaefd3b709b3058" },
    { "SATALTA2.WAD",       "8f597190b0af2065415e1d754c75eed6" },
    { "SATAN01.WAD",        "f9b72fb6f099705ca19c38659e8e4899" },
    { "SATAN666.WAD",       "091f6017c5949e53e8f10e340eb3b085" },
    { "SATANV13.WAD",       "d95e60d0e840bf36d841260dc1ae1efb" },
    { "SATCMPLX.WAD",       "94dcac77798565ff7402da5f6add0cce" },
    { "SATLIB.WAD",         "465ad9e3763d65479fcb2163749ef6bd" },
    { "SAVAGE.WAD",         "1d0953de1fcd8d7f4edc620cd7cbf1ee" },
    { "SAXETS.WAD",         "8f2407cb5855bea5ddb258ff165f9ef9" },
    { "SAYDM1.WAD",         "aa46bb3fefba035cacd97888ce5cc379" },
    { "SB7.WAD",            "95e9ec5e94d7ef48946d33c1097c9c08" },
    { "SB72.WAD",           "2fc40ef49029a7b2a5405a5dc570bd72" },
    { "SBC.WAD",            "494e5c66b5a42fa7ec37fb8496c19e8c" },
    { "SCARAB2A.WAD",       "90017d87e1df9fddbad4db378af0e0af" },
    { "SCENES.WAD",         "03d4833ee5a1f4733c1beccd4f64dea9" },
    { "SCHIZOID.WAD",       "92457a366a9b0afe083241c495e5d068" },
    { "SCHOOL.WAD",         "bb40f67e5a051144889e09fcd30bffae" },
    { "SCHPIFFY.WAD",       "a8317585348d5eb17ae1cbc07cc3b53e" },
    { "SCI.WAD",            "bfeb69f367b03acc3b852bb00d0a8501" },
    { "SCI2.WAD",           "5162fc0b74d2cf0fc6ee7da37cab152e" },
    { "SCI2_zdaemon_crossbow_fix.wad", "4d8c8c663e2ed2abb3f034ecaa136e05" },
    { "SCORCH.WAD",         "7d635379c8dac77d8f68005019d0659b" },
    { "SCORPION.WAD",       "c111ebf7d25a46607fc9d393d8006852" },
    { "SCOURGE.WAD",        "637205396d706b3de5bb61c6f54b40b6" },
    { "SCOURGE2.WAD",       "1aa6d16ca9144da3f98fd7638cdc3c3e" },
    { "SCRAGADELICA.WAD",   "40d8a86503479f2a84929b0a8da4c9b8" },
    { "SCRAPER1.WAD",       "7c6c87766aab7cc071d44f0b97702881" },
    { "SCREAM.WAD",         "b7c83972b53d749013cbb7d3549d27f5" },
    { "SCUM.WAD",           "aed36aaaac4d793a566e0796466c696a" },
    { "SCYTHE.WAD",         "3131213a9413a604c5c160848ddb3d9d" },
    { "SC_D2DM7.WAD",       "36b6fa4f88ef184bd7ebf8ccf0faa4e9" },
    { "SC_WASTE.WAD",       "2420d10d1e3d9b7bb1a01894b94f42d8" },
    { "SDW_MORT01.WAD",     "87ff609b1c0926bc59d99f53971bcf83" },
    { "SEAN200.WAD",        "f1886f5ff580afe1c0bbbc75ad1e923c" },
    { "SEAN201.WAD",        "61f94d729a6d39850762494775a0494a" },
    { "SECRET.WAD",         "dd045945246330102f452375757236f7" },
    { "SECRET2.WAD",        "e189f1b6aba32a83252a20592d961840" },
    { "SECTOR57.WAD",       "a5f27482e5fb9b347809aece4d08f369" },
    { "SECTOR7.WAD",        "fb3592548f2eab17dcdebfff1f0dfdcc" },
    { "SEEDY.WAD",          "a238cd072a5dbd37823d7ba2be6df2cb" },
    { "SEEJ.WAD",           "c894657cbc3b9f687550f6ef5bdd5b17" },
    { "SEKKUSU.WAD",        "62985b27ad7fae27777dc5e7f0a7823e" },
    { "SELF-EP.WAD",        "04b0d1c9fe0e7f000c1a9d48a56d4e62" },
    { "SELF.WAD",           "9a8c1f250853421745946debc650a168" },
    { "SELFISH4.WAD",       "186bb10924d65143c2685b2007faba8f" },
    { "SELFISH5.WAD",       "308eeed114fd526823a771938260dc49" },
    { "SELFISHX.WAD",       "e41aac0b5ad57b6768952179bc9c85ab" },
    { "SEM.WAD",            "8c4c009e56495caa86709bdd58616180" },
    { "SEMATIC.WAD",        "f017d505775545c4d113c607a8838171" },
    { "SENTINEL.WAD",       "c45152c81979959afe5db72911813992" },
    { "SER1.WAD",           "7d043fb63efc9609b908137cb093dd58" },
    { "SER3LV11.WAD",       "17dca446f24e781b67a97d1aa0cc8e68" },
    { "SERIES.WAD",         "04e5df1ef499ee0599cf360751c71a68" },
    { "SERIOUS.WAD",        "b1884923debb498fa3ee9f8c93283d53" },
    { "SERVO.WAD",          "2b21a6402824b6324b5d8075d0653f6a" },
    { "SEVEN.WAD",          "1d4d706a53b8babe398a6a7a3746328e" },
    { "SEVENLEV.WAD",       "ee3f0f3a466cf1b47e5e84fcc822553a" },
    { "SEWAGE.WAD",         "6f0340feaf94189cfed964b2f9888195" },
    { "SEWER.WAD",          "4432827ab8c5c587c556de8b9639e677" },
    { "SEWER.WAD",          "83d11d306e1c4a6f767e64261ede8b14" },
    { "SEWER666.WAD",       "438b3a4c6488c43f225e0c324bd9ccff" },
    { "SEWERAT.WAD",        "34052d27ec2ded7c8fc0b3718ee98ee7" },
    { "SEWERS2.WAD",        "64dbf0162d4eada7d5d330e6063f6bef" },
    { "SEWERSDM.WAD",       "8862df1ebc3ddb0db036823cef5d7183" },
    { "SEWERTERMINAL.WAD",  "511daa71f0830bd810640d3efe3c188d" },
    { "SFALLS.WAD",         "fd033f60f7b829e69b45bd0fff2ca9f5" },
    { "SFFT.WAD",           "82c995ead6ea889908e8825412078c82" },
    { "SGEHOUSE.WAD",       "828292c6866ce7447d90799c19f66922" },
    { "SH5.WAD",            "4f1b257b1f57d313271afc8e3e058168" },
    { "SH5MUSIC.WAD",       "122f2bcda77e6c474e1daf1425d79795" },
    { "SH5SOUND.WAD",       "571ba523e19b13cc754c520666935232" },
    { "SHADOW.WAD",         "3ddffc84863e16a4b3aeb7c928675ec9" },
    { "SHADOWREALM.WAD",    "d341e799d1bcfc717f5720a759c181f4" },
    { "SHADOWS.WAD",        "0d21b5aba3ef9b951f5eaaac364e6a7d" },
    { "SHADOWS2.WAD",       "d7f1daa953212df58b87f59116c3a661" },
    { "SHALOM01.WAD",       "8768bd4cb027db117780833b1164cde0" },
    { "SHALOM02.WAD",       "95f6c93ec4edbc66efbf7d71094c1658" },
    { "SHALOM03.WAD",       "476bfcdf9bf14a90e16e488782061a6f" },
    { "SHALOM04.WAD",       "134646ac6d34f0263859d65e9f42e56d" },
    { "SHALOM05.WAD",       "4f19756ef939bf95de2e022af0188f81" },
    { "SHALOM06.WAD",       "ed82eab35973445359efb0c9304e205f" },
    { "SHAMJAM5.WAD",       "44f8639e06ca9d9a4ab2e173a6d8c0c4" },
    { "SHAND.WAD",          "9fbbcd9c97b2f933ccef044eee46ae7e" },
    { "SHAPE.WAD",          "7b937223fe073275c2f09c5d4914a0a9" },
    { "SHDWDTH3.WAD",       "df1c5016b6f70d6bd05548bfd17ef2aa" },
    { "SHDWLAND.WAD",       "5c6a798bb18605b7ab9c8b956c72c4d6" },
    { "SHDWPIT.WAD",        "cd59d98dedc21bb81cfe28a0f99aa935" },
    { "SHDWSDTH.WAD",       "9209a615632a6164443312ded69471b8" },
    { "SHELL.WAD",          "ec6d1417d851726c7241c049a3c9ae53" },
    { "SHELLSHO.WAD",       "dfed9bb101ce06c165554ff49d6495ff" },
    { "SHEOL.WAD",          "ecabd9a900c1d73000dd4f858f1fa738" },
    { "SHIH.WAD",           "2cd6f36c23f55895d02087805770e6fd" },
    { "SHIP.WAD",           "8820599e8b238383cfffdfd762a29a9d" },
    { "SHIRE.WAD",          "36ce5aba587f4a5a509619e2fe101e72" },
    { "SHMO.WAD",           "2d8beb6e9b23facd70c40c985ce72b8d" },
    { "SHOCK.WAD",          "74e03f326c2673c40b78d02cd3274557" },
    { "SHOCK1.WAD",         "6671f2bfe02996fb3cc4d25426843a37" },
    { "SHOOT.WAD",          "7cf2d11a8bef899bde76e25de6d94a9a" },
    { "SHOOTS20.WAD",       "bf499f65a1abc935dc93c8e66e0c8089" },
    { "SHOOTYER.WAD",       "0f6e46db04f8bc2bfda2a156c9e79834" },
    { "SHORT.WAD",          "c26671689e11a82f3a665016a83c65df" },
    { "SHORTPAK.WAD",       "a14f76b296e6310730e8a6a5ff6324c1" },
    { "SHOT1.WAD",          "4eb0201dab65fe5b57b7f566a67ebd96" },
    { "SHOT2.WAD",          "5f7c31c1d6f65a9ecc2143756568e5d4" },
    { "SHOT3.WAD",          "2ee7ae87ac6d5a7e7e6c478f1a18de3e" },
    { "SHOTGBF.WAD",        "d1007191bafd1733bc2d620fbdcd7f5d" },
    { "SHOTGUN2.WAD",       "0d21aa3f7c8e8d26ae49857aca71a166" },
    { "SHOTGUN3.WAD",       "63b5db1bdd8be5b08d2d2b0c508f3cb9" },
    { "SHOTMY.WAD",         "079aefd4308db4e2bdb1574b633e5e8a" },
    { "SHOVER.WAD",         "5154f9cb302d14ab1b372785c354d5cd" },
    { "SHOWDOWN.WAD",       "11e028016b3e5aecacc700bb2b06c208" },
    { "SHRIEK.WAD",         "acda50444733f1f1b1aa839d5b264633" },
    { "SHRIKE.WAD",         "8a45875129e557fbf5a5f34ec65a248f" },
    { "SHRINE.WAD",         "b12be7fe5b21810aee368b888097667b" },
    { "SHRINE2.WAD",        "e91d56b188866b4dc7e21be8fec52b16" },
    { "SHTGUN42.WAD",       "d9042dd423af2273c80a5822e0b11620" },
    { "SHUNALL.WAD",        "c165b76b0199a46bd801f89ac605c2cc" },
    { "SHURIKEN.WAD",       "f85f53fcd469e4a11b71746722712403" },
    { "SH_OF_DK.WAD",       "7ed461af5cdc391df3d58f1cf1a5263c" },
    { "SICKPACK.WAD",       "2d4c0064b308c1211772a51d8fdc3102" },
    { "SIC_EM2.WAD",        "53adcc5f02062e3fa732750f16223e97" },
    { "SID.WAD",            "70d560f1897ea8a9f0e273828381fc82" },
    { "SIEGE.WAD",          "7075977d9ded3f793502b9fe57270460" },
    { "SIGHT.WAD",          "568be34c49de33fcd62cfdad05003929" },
    { "SIGHTS.WAD",         "b7325cea7772d61d0834240edf34b575" },
    { "SILENCER.WAD",       "d2c60cb2cedeaa76424809fd0bf1b069" },
    { "SILVER1.WAD",        "5476d1db046fdfe8d45b772e46e7f627" },
    { "SIMPEVIL.WAD",       "b522f541a45363e61bd066804bfd684c" },
    { "SIMPLE.WAD",         "8f04d176508020cd11c88cfa70dbe102" },
    { "SIMPLE4U.WAD",       "8dd550181398f57541271cad801880bb" },
    { "SIMPLEDM.WAD",       "324ed1f2215ce9950505856045d4869d" },
    { "SIMPLY.WAD",         "ed08d8af70cc953e5b5740b234a177ac" },
    { "SIN.WAD",            "b04bb5e9c30e783f9586c195c3d4d4cb" },
    { "SIN2_9.WAD",         "0f5312f028fd84436acb01297ad0962c" },
    { "SINFERNO.WAD",       "bbbf1d408537054d104aa43e14a71112" },
    { "SINLEV1.WAD",        "8b22993241b1667e324405bbbb2faf6f" },
    { "SINS-T2D.WAD",       "772424642dc8ec53b21160488395d10b" },
    { "SIRIUS1.WAD",        "493aaad9eaacd8cd1561e23106d2fd9c" },
    { "SIXPSTAR.WAD",       "b0a551388a296a20060afa030b8fb39a" },
    { "SJDM.WAD",           "dc4b9e03d7f7478dd64d3d312a9ebff0" },
    { "SJSH.WAD",           "213237a68f8bae7123b4e0f79531952a" },
    { "SKELTER.WAD",        "7b83a976adae1a7737a4979c9298203b" },
    { "SKILL!.WAD",         "079efcb002b342e80d4052839c72f4dd" },
    { "SKILLS.WAD",         "346267d11929d0c13be44f6ee5c907d7" },
    { "SKLHALL2.WAD",       "48610e2741a88d40618b2871fe98fa36" },
    { "SKREWD.WAD",         "dbe08aa1a0eb487bc3db30ee9920252e" },
    { "SKROOM.WAD",         "1e16dcb2503a3757efed3143ec6fab4f" },
    { "SKULL.WAD",          "001216207ce0910138a68b6f748a4514" },
    { "SKUNK.WAD",          "2adc0cb0df01b0ea453ac0e75dc6ff9a" },
    { "SKUZ.WAD",           "85bfa6797db5428a70c6293b84803d56" },
    { "SKY.WAD",            "266238ebb6e1940f00b38303db0798f9" },
    { "SKY1.WAD",           "de1ea8c5311374ca60ce8ebdb34cb5a2" },
    { "SKYBASE.WAD",        "7169a0c21f645b3a6c7fbbe8b010911d" },
    { "SKYDM.WAD",          "105fc14986270163466989870d1e0c29" },
    { "SKYEWOOD.WAD",       "b5b9e76f8e463d3b800f4dc6ac032b69" },
    { "SKYLAB.WAD",         "8a6da6f828dc6c443def325a7fb23e65" },
    { "SKYLAB15.WAD",       "7209804b0fa731bcbacd6d1d92e5b72c" },
    { "SKYWATER.WAD",       "79ebf842d197f2005ab55589fe8029c9" },
    { "SKYWEP.WAD",         "7bcfaf38827afe2be4638a47085c5a30" },
    { "SLANTDM2.WAD",       "a05f6afe2c4791608376b5d9fdf43f30" },
    { "SLAPME4.WAD",        "ef6665f1a87d898a36390a1c859e9af4" },
    { "SLAPME5.WAD",        "8d942f337d6a9c8d38bf1b560211465a" },
    { "SLAPPA.WAD",         "10ae4c8b1a539d22ee882f8c7210ac0b" },
    { "SLARTY.WAD",         "4db5fc796707a5ff80d1899fada3ba7e" },
    { "SLAUGHTR.WAD",       "e2c35ed423f51bbfcdd3a5bb5188180f" },
    { "SLAYER.WAD",         "06e9559604fb11034ffa5a39ba515271" },
    { "SLDM.WAD",           "b896e05488f7f8ffdb7979e914d94c55" },
    { "SLEEPER.WAD",        "a510adba5aca6ff84497eec341e38915" },
    { "SLEEPY.WAD",         "31a21369e6bb29cabbab96a67eb0cad9" },
    { "SLIME.WAD",          "cbae2ce71ac063a56d2d15820c8bee1c" },
    { "SLIMETUN.WAD",       "801ca52f4194e53b38ba5ebb51e08cd8" },
    { "SLMETIME.WAD",       "1022ec4887a6c08d72ff81ce3ded7f8b" },
    { "SLOSH.WAD",          "9e2b5507beae2a9f831928d7558d9d0c" },
    { "SLOUGH.WAD",         "897cd75dd69708cd15d24e5af86a74af" },
    { "SLUDGE.WAD",         "d65b4b60cf871fce36f674c1e11544c8" },
    { "SLUMS.WAD",          "a4edfb17c793178b5f2d693e43143fd3" },
    { "SMALL.WAD",          "be3c29d2d09eb10f04ab2b0b41ab0e4a" },
    { "SMALLD.WAD",         "18f5ea6c757e6240141baf69f99c14d3" },
    { "SMASHDM.WAD",        "96a3f4f8bb39588a1fb096fe1bfb3d87" },
    { "SMDM1.WAD",          "76ccc2cb2d588cd848e6883ac69d7397" },
    { "SMDOOM.WAD",         "c88420e00058cfd6355d2ead395912c4" },
    { "SMEGA!L.WAD",        "269b2decc01f04625cf436a5db8a08d8" },
    { "SMEGAD.WAD",         "0a067b054511cb882e63e78cf138e3a7" },
    { "SMEGGER.WAD",        "0c9aed128c4510a1a917e659219e37f5" },
    { "SMEGGER2.WAD",       "5c71e631c81927a9a5876586fa9614c2" },
    { "SMELDETH.WAD",       "28a0ab9f993c30e5f4b2ef302693838f" },
    { "SMELNYK.WAD",        "0edd3ae1e31bf3108200cd397f2a6808" },
    { "SMELODTH.WAD",       "a8e69d7d452ce8bead21961cdec428fc" },
    { "SMOKE1.WAD",         "f4f59d16f62e2ed37a03ba1bd56f249c" },
    { "SMOKEPAK.WAD",       "d8ebbeb04759780c7acc3d0ee66bad48" },
    { "SMOKN2.WAD",         "a86c1fcb8de39421aca50220d7130420" },
    { "SMPLMIND.WAD",       "da0eec25366bca7e0d4a8e84e1a6ffad" },
    { "SMY2V11.WAD",        "58625284c769dac586fae32e0979559a" },
    { "SNAKE.WAD",          "b6e3f2fa12cf436641e9e5150a70af3b" },
    { "SNICKER.WAD",        "b42786fcd386a5f9502f73fe798730c3" },
    { "SNIPCOR.WAD",        "a2f44c87de7b308912ad9ec30ad5199e" },
    { "SNIPE.WAD",          "74a93558b78c8d6b29f984ccf699a54b" },
    { "SNIPEME.WAD",        "f03a84bfba7eefc4a49eb8794df05773" },
    { "SNIPER!!.WAD",       "97bdc08389a35360b600c7b98503c7be" },
    { "SNIPER.WAD",         "3a130e787ff5b2df6e1f614d4611bb63" },
    { "SNIPER02.WAD",       "bcc31a16c3bd92a972e222d6119ac925" },
    { "SNIPER1.WAD",        "a310e7cd63f4c3a64b2cad6da5d0235c" },
    { "SNIPER_X.WAD",       "53e05681ed9994c8b47c581d9294ce25" },
    { "SOCKSOFF.WAD",       "6c784b45b49aae3b018e6dc8412aa392" },
    { "SOD.WAD",            "ba5fe91b62985a365d8bf2a4daaa2d56" },
    { "SOIL.WAD",           "bfd36b5ef67e2f25ca79b39cd1ac1758" },
    { "SOLAR1.WAD",         "7a0b7764f115ec2da727c84f75d4cf33" },
    { "SOMAIROT.WAD",       "e5d3c668b7ad219a45031d12464f893b" },
    { "SOMEDM01.WAD",       "3d5510e2e81de51d43d63b38533d2799" },
    { "SONNYPAK.WAD",       "4df30db563704c674572ade7793ef806" },
    { "SOS203.WAD",         "54cc3c5ea72d56e0ae46145825cca84b" },
    { "SOSUEME.WAD",        "6f2d3859b52a1d7518154a1771ed818f" },
    { "SOTTC.WAD",          "6179190914e977d5b7f19057589bb74a" },
    { "SOULDOUT.WAD",       "f168fd09597bdd5ff0dbd6020bd0f6c4" },
    { "SOUNDS.WAD",         "d18e3f924adfe994afedfcf7a3582afa" },
    { "SOYSAUCE.WAD",       "8c62cd351c81194568682eb7b64fe2a6" },
    { "SPAC2096.WAD",       "a59ba9117c7ac02e57187c151d4ec2e2" },
    { "SPACE23.WAD",        "60f581ac40552ee9588fff1ef98a2b9f" },
    { "SPACER1.WAD",        "fb5cc792ec91e798d8c6648a7d8e5ada" },
    { "SPACESTA.WAD",       "4109bd9501df4a29bf4c2ef960fe8e86" },
    { "SPAIN.WAD",          "485d712528e8e5745a5aa080100df3e6" },
    { "SPAM20.WAD",         "289308a22d13e30e20265da6975c5a6c" },
    { "SPANKY04.WAD",       "75b6e72897c435eac5a36943a8e0b11f" },
    { "SPARKED.WAD",        "228381e3c046a8a5f48bbbfc1ad9dbff" },
    { "SPARKLE3.WAD",       "7dcc2b1435e23cd6de177db39a16477f" },
    { "SPARTZ.WAD",         "6108a40ab5aed5e37c29709b30badbc9" },
    { "SPAVILE.WAD",        "f1c02c2717846dd77fe29a0aa550b7f5" },
    { "SPAWNSQ2.WAD",       "030e1950f7295d4d501e259c5c533a3e" },
    { "SPAWNSQ2K.WAD",      "c1acf01a43fb275ba1bfd6a57e3b0d3a" },
    { "SPAZ.WAD",           "d28b86b1016269f65947cf99b6a5dc9a" },
    { "SPDOOM2.WAD",        "2c2a118055c25a8cd75469f93638ee9a" },
    { "SPECI.WAD",          "6f904a7eb4bc65928476a96f051b2fb2" },
    { "SPECIAL.WAD",        "bd1023eb4a0ce6f230d8c5d43193d5a1" },
    { "SPECTRE8.WAD",       "2aea0f235f08d379f115e97ca9332fcd" },
    { "SPIDER.WAD",         "8ded6b00d27f6aa39d5d9bab5026f09a" },
    { "SPIDER4U.WAD",       "a85f0f04e5c8258e8f04220361a6467f" },
    { "SPIKES.WAD",         "afbe9fe83686c7c1fbc4ea626d7f7f25" },
    { "SPIRAL1.WAD",        "5de17947d64067e26a4f2328624dce46" },
    { "SPIRIT2.WAD",        "092d3bc72a544082a72b2a67176e5f88" },
    { "SPIT.WAD",           "0430df840c55eb7183b4307805bc1780" },
    { "SPITEDM.WAD",        "db13cf4ebb717159ff72eca335339a24" },
    { "SPLATTER.WAD",       "311677193ebfffc951bfc28d96754334" },
    { "SPOCK4.WAD",         "4f4ef14dd974652763b3708387434a39" },
    { "SPONE.WAD",          "f23015e84ce63b58c826721fb75371b6" },
    { "SPORKTPDM.WAD",      "e4bae59f75f415346e66c5682be2db73" },
    { "SPOTLITE.WAD",       "113aa48ac18020a91e82974f41fe2e35" },
    { "SPRDOOM2.WAD",       "d2d600487369a39a2c60bb69e733453d" },
    { "SPRINGER.WAD",       "7a449ac828c1ea62fefee629d2eea207" },
    { "SPRITE.WAD",         "dde184b1a6ac9ba7a612e9353d665d6c" },
    { "SPRITES.WAD",        "18d5329842886c7a2c02d7d5d6136264" },
    { "SPUDEM.WAD",         "2373b3c36d6c667fa34d3bdd6486b014" },
    { "SP_BKEEP.WAD",       "52bad35fbfa401f7711abbc5ae2bd535" },
    { "SP_CHAOS2.WAD",      "47db37d8a7292f669ae2d54fcd9c630b" },
    { "SP_GEO.WAD",         "15608faf6f1e51009449fcb48db3e250" },
    { "SP_QUAD.WAD",        "e73f24b984aee20242f3db35ceb0fd22" },
    { "SP_WINE3.WAD",       "2d3c2abb852baa867b337ae6386a8fbd" },
    { "SQ2.WAD",            "539e4b4284b42b6728cd3b4ab9848379" },
    { "SQABALA.WAD",        "c45f531595ac28b5c943dfbaf2262db3" },
    { "SQBASE.WAD",         "da2f279598d55b45ddc61823f97c2e74" },
    { "SQRING01.WAD",       "25032462373abdac74cc9f16d3d1be74" },
    { "SQUADRON.WAD",       "c279c465f7290ab383bc86e70a6258f2" },
    { "SQUALOR.WAD",        "582be794cc4e9f5744823baa20f3a14a" },
    { "SQUARE.WAD",         "8aa7ccb267cdf6b768dc5b7bddc5b7e0" },
    { "SQUONK.WAD",         "e1304c26920b2d2ded49b0126579ad4c" },
    { "SQWALKER.WAD",       "ce1e19f1493eab63cd82b6eb47bbd933" },
    { "SRCHNDST.WAD",       "5dd52493124984d5b2a785bfccbe8da2" },
    { "SS-T2D.WAD",         "0c34d6c346719a1109346129d87d4aa8" },
    { "SS.WAD",             "1627aadca54fb002924aaa46d0aa0362" },
    { "SSARENA.WAD",        "7a3935d3c3d0a6307ab956054c967799" },
    { "SSATC.WAD",          "37d7580ded9aed43f7c6b424dc32b6ed" },
    { "SSATCGFX.WAD",       "580e25f4e1c9734021040fa9031ef52a" },
    { "SSATCSND.WAD",       "958b33b8aa5712cad4e354d88e6d43b3" },
    { "SSCHOOL.WAD",        "a16fe1cb84ee1a2d8f967bb45cb89c1b" },
    { "SSCTL_01.WAD",       "d3438c5d0f60e80b971a81ef8be2453e" },
    { "SSDM1.WAD",          "f3cb13a990246269bf576086800dc777" },
    { "SSDM2.WAD",          "254e380c45e9f4a658d8af15455b9fe4" },
    { "SSDM3.WAD",          "361198ec095be584e0ead7602af7a337" },
    { "SSDM4.WAD",          "792275a733a20aa6b9380d1fb81f9da4" },
    { "SSDM5.WAD",          "7a73daca339a1557e3a2e54c45389810" },
    { "SSDM6.WAD",          "0ac7254445f5dcca76e99d27a8984a50" },
    { "SSDM7.WAD",          "35edf5c8ed475c0f2a06affae40f5f05" },
    { "SSLLAOS.WAD",        "d16fe7017e43a00ad44c2eb97b74ff02" },
    { "SSTLEVL1.WAD",       "3d7c08b0505d67a73482fbbed22da0bf" },
    { "SSTLEVL2.WAD",       "ae7d96637cd9251ce97049ce5274a175" },
    { "SS_SK5.WAD",         "5bab75112139bf0493e29ccaecc064da" },
    { "SS_SK6.WAD",         "87f1b4f653a32ddc8894be51a5c6b731" },
    { "STABLE.WAD",         "d83a315ead211c56594421968e7bb06b" },
    { "STADIUM2.WAD",       "25b7764938161739be186bd64213df5a" },
    { "STADIUMS.WAD",       "c6856ef5546ca4af88092474bd3cfbe0" },
    { "STAHL1.WAD",         "778437db542f6e4404cd62bd4588922c" },
    { "STAIRS3.WAD",        "6233d4db3e208596317526678ea9b4d2" },
    { "STAIRS4U.WAD",       "2d23ed5864ac11f9a8ce0c41c8cdddc7" },
    { "STAIRWAY.WAD",       "a6a342893603a58e936b7c32f066bad7" },
    { "STALKER.WAD",        "079fe8ccce773ff972e6ce002e8a25aa" },
    { "STAMPEDE.WAD",       "e0af0228c6dadff4d00627d62724f276" },
    { "STAND.WAD",          "b02c74b013c3d94c7200c0418296aab1" },
    { "STAR.WAD",           "b3ac04d4fcc2f7a7f6abb8e48c6facf2" },
    { "STAR02.WAD",         "e7012af1f72d87fb82730103e1dd87ab" },
    { "STAR8.WAD",          "dbf1a5b88a0c12b5e056aae21364e360" },
    { "STARCITY.WAD",       "79b695b5b5f3abe078ba6089b7096753" },
    { "STARDOG1.WAD",       "bb7ce483cc05affd46f28d93bd871a1d" },
    { "STARFGHT.WAD",       "dc97ce6df31252dba2e729ab9f44d516" },
    { "STARGATE.WAD",       "6a720f6d57ad55d43f0d5b0f0430c3d0" },
    { "STARLITE.WAD",       "41dd411f9f4aa3ffebab57a37d8cc7b0" },
    { "STARMS.WAD",         "69655521ee70e19d54c9c7c363b28c42" },
    { "STARPT17.WAD",       "334c8cd0cbb899e59082fe652dc743b4" },
    { "STARS.WAD",          "d38945a11a6ab371fd3a2b778ca2f5dd" },
    { "STARSHIP.WAD",       "74fa57b9a0e27616418de9dbac0b2427" },
    { "STARSHP.WAD",        "9ca78290de7df9e6b89dac6a817ad6b7" },
    { "START.WAD",          "2c7e69fcb964600d3048970ceedd8cfe" },
    { "STATION3.WAD",       "d3e5b7deb775e5938f783bb766496ce9" },
    { "STATIONX.WAD",       "b30c6ee1d5ac6067592fb426eb37f6a7" },
    { "STAUF2.WAD",         "18ee8c45b60103187aca5f0e2fcf2b51" },
    { "STA_ROS2.WAD",       "4e70c6c0bc6aceb171f8498dee4fff80" },
    { "STA_ROSF.WAD",       "a1f9a30af735385f4d2fa4698b6e844a" },
    { "STA_ROSW.WAD",       "9bc96ed96faa363ed05c4ecb8fe696be" },
    { "STEEL.WAD",          "38eb8ad5f7328c3938582ecfba642b6a" },
    { "STEPS.WAD",          "4b6e8c3b24d8c2931c2111c14c9d6a8b" },
    { "STEPSV2.WAD",        "bda1cadaf4a3c91f911940274c34a94f" },
    { "STEVEN01.WAD",       "8479848f3bfb0419954f4dde8bf4ed68" },
    { "STEVIE_1.WAD",       "4d7e77e5ed1e6581d710ad461f71e2ed" },
    { "STEVJOBS.WAD",       "ee659edda8df11e6f2b92f6d5ef18cd7" },
    { "STEWORL1.WAD",       "3d6534ab82bf4214d79aff2790eb178a" },
    { "STIGMATA.WAD",       "d98d4fa8f743e9222dca07e98f217409" },
    { "STIX.WAD",           "5a6d4d46fc8f817a09d582d95c369816" },
    { "STNKEEP.WAD",        "07606b70f1537f2c33e648925b60a716" },
    { "STOKER2.WAD",        "41888998442e7b31f0ebf91e411a2689" },
    { "STOLE.WAD",          "42041777d2b7af5875f90bbe79622318" },
    { "STONE.WAD",          "30657e334829c2f6ec767994a6a277a6" },
    { "STONEHNG.WAD",       "cf927f5f0b1c77e37ac0170ccc137d90" },
    { "STONEMAN.WAD",       "c15581737ea5ea48836d767072448a3e" },
    { "STONEME.WAD",        "0fe0574d696b4d584b643a49f9da41fa" },
    { "STOPME2.WAD",        "2c26bcda0e7ed12a635d5aa1b279175a" },
    { "STOPTHIS.WAD",       "c289521551af3e8344d3331e238cc7df" },
    { "STORAGE.WAD",        "fefcc1ad5cdefeded939bdb7cb56040b" },
    { "STORAGED.WAD",       "320f5856ecf63bb49c7be21daa8fc78b" },
    { "STORM.WAD",          "e2f6709663973e356833216546b0ae14" },
    { "STRAINDM.WAD",       "e2468bddf8c8ccbe16a248c228a2b489" },
    { "STRAPS21.WAD",       "5479fafade4c340eec7b480356a8a398" },
    { "STRAWBRY.WAD",       "7a95fa807058faff8b5790670a6f4369" },
    { "STREET.WAD",         "e416ae181fec161d9dc380b81c6cc641" },
    { "STREET.WAD",         "fccbcbbb2bfa5f1918782874b0f8c18c" },
    { "STREET3.WAD",        "fa3ab32cbd654bbc0cbc890e8568a1e5" },
    { "STRENGTH.WAD",       "1edccba523a0f83bd25c9926ed830937" },
    { "STRGATE2.WAD",       "a97e8a6dd62a2e2a5a8a358d910037af" },
    { "STRGHOLD.WAD",       "75c09553d3955e7b8dd8a747cb8a7dd9" },
    { "STRICKE5.WAD",       "c9bc3b72362cd2f0e9affe2a8df17e78" },
    { "STRIKE.WAD",         "8135ed9da3cafbb26c0f99c8ea465c91" },
    { "STRIPBAR.WAD",       "085d9e9641b394a74e352adbee92ef9a" },
    { "STRNRC01.WAD",       "f580a7afcb3f50a2689821e090a66f3d" },
    { "STRONGHOLD.WAD",     "5d863ecad2d288dfedd997845bcf9f62" },
    { "STUFF.WAD",          "19a19a8879ec2ebb5b8541e1624d2963" },
    { "STVCAGE.WAD",        "3f34ea22384fc5a60ec97a8ccde9f628" },
    { "STVDM.WAD",          "71f3ff48ff8797955790b8af1fa3a8b3" },
    { "STWDM01.WAD",        "2fda183b6cbe902d7154e3f7e4387bda" },
    { "STYX1.WAD",          "45e3af1bf63cc4bcda299749b23e8381" },
    { "STYX2.WAD",          "fc19d5ac4b3b1ba723cbb98b314180d8" },
    { "STYX3.WAD",          "37034b80c0f7bc048e627ce46898fb25" },
    { "STYX4.WAD",          "798c9c20915a51e4611fe0273bad3c14" },
    { "STYX5.WAD",          "dc7bd56472828a88358ca30e6bad6d12" },
    { "STYX6.WAD",          "f2b0382cb7da43b501517d6e7bf48087" },
    { "STYX7.WAD",          "37e27821f7e095c74fd40043636d6ca7" },
    { "STYX8.WAD",          "add9ac52c18a04ee07e783bf133fee5f" },
    { "STYXDM.WAD",         "938759ac0fb543bea56d0efb965debe2" },
    { "SUB-GR.WAD",         "2b0a94edd74f6ad9dd46f11cc45791b5" },
    { "SUB-LEV.WAD",        "3efdf4009c6bd8fa8388b23393536665" },
    { "SUB-TEX.WAD",        "a61c1e1d78c87d11aded10450568dd89" },
    { "SUB-ZERO.WAD",       "515af8701c9c9e242575a3ea74226610" },
    { "SUB.WAD",            "6bd134018876a2a3b1f7fb9188130ba8" },
    { "SUBJUGAT.WAD",       "796db266f22eec22e7daff22db68cc00" },
    { "SUBLIMIN.WAD",       "f489fd167930ed4fc1f81237c603c208" },
    { "SUBWAY.WAD",         "ad66b486dfec742822292060feb8943b" },
    { "SUBWAYS.WAD",        "a5913253f16efbc07ee95f079bc1174d" },
    { "SUCKSAGE.WAD",       "03aff8cdefad85297cc08616f045e21e" },
    { "SUDDEN.WAD",         "687d449874df4863b7c3538b39a41fcd" },
    { "SUDDEN1.WAD",        "f5c4cd021822984680d0b6784a329113" },
    { "SUFFER.WAD",         "c735b423676a5702fe8471abb62241c2" },
    { "SUICIDE.WAD",        "d1a884db03316decddc01c20443a12fc" },
    { "SUPAWAR.WAD",        "72cbbac71b8f0a99968059a809975dc3" },
    { "SUPER.WAD",          "7ba5c21c006a32165982c6b36c5dfc76" },
    { "SUPERDM.WAD",        "94ba3e8150f452bb9ed8f7670c64014e" },
    { "SUPERFLY.WAD",       "5a0d5312dabc337490b4c4158e6974b2" },
    { "SUPERIMP.WAD",       "46de4f5718a740ebbdb50d1bda6d96c4" },
    { "SUPERM.WAD",         "9d15cc3cc11b12abffb14cfbc1c26fb4" },
    { "SUPRBASE.WAD",       "420a16e7a3d3377224d83482b06465de" },
    { "SUPRDOOM.WAD",       "44628db72952c378b119f3f106d23388" },
    { "SUPRISE1.WAD",       "9e3d40fbd27d26dc836baee69738cce7" },
    { "SUPSTA.WAD",         "6daa1a09f9a0a5a0e0fb587c060b2bc7" },
    { "SURGE.WAD",          "631237d8f7e10d475f53651ae2ffcdea" },
    { "SURGE2.WAD",         "33d717a40213983076bef8900ceb68a6" },
    { "SURPRISE.WAD",       "a4970896452fb3425c24e354c8c2a3bf" },
    { "SURREAL.WAD",        "a5d60c7116c82d56b76314a013898f9f" },
    { "SURREAL2.WAD",       "4321c035bbfcf9fcb075418b7b9a635a" },
    { "SURVDIAB.WAD",       "77d225c811e97ea8cb665ccf16fab8b6" },
    { "SURVEY.WAD",         "2c7e68c494e6dca1225c72841047a053" },
    { "SURVIVAL.WAD",       "d02b1901ed443672dcd4e73bdc3d6f6a" },
    { "SURVIVL2.WAD",       "58fde4475270772a897855bb475f0558" },
    { "SVEIN.WAD",          "f4dad3746ea7b9035c4d03441c06205b" },
    { "SWARM.WAD",          "f1d537424754feebbe5a48ce0136cd9b" },
    { "SWARM12.WAD",        "2aebc675b1b3a17873075d23c60559f0" },
    { "SWARM13.WAD",        "a9bdb51c7f4062d47f4bf79ecc844593" },
    { "SWARMDM.WAD",        "ecd08100e010c859b5264f138640bbbf" },
    { "SWARMDM1.WAD",       "d0b0bc514c7d9f5ec2658d55ab955642" },
    { "SWARMDM5.WAD",       "ce4eef554921fbd81ecaa4bdcadd8b1d" },
    { "SWARMDM6.WAD",       "53314bcbbb518fb9addcb4519b2b4f0c" },
    { "SWARMDM7.WAD",       "c083cf0ba9364e8acbba0eae5edf2fd2" },
    { "SWARMDM8.WAD",       "9255a2bf7085d12d47ebe36cb906641f" },
    { "SWARMDMX.WAD",       "235921c516b7e4d8ee36e8b45afc82e5" },
    { "SWATTEAM.WAD",       "ced6b4e9d2ac15ea05530c6dbdeeaa05" },
    { "SWBLSTCS.WAD",       "f8a53855dac277d14d49e8d6cd92db34" },
    { "SWHAVEN.WAD",        "d314866f754d0a67ce3fdfb0ebb6366a" },
    { "SWIRL.WAD",          "b243f55b377838e237f5386cf18f6105" },
    { "SWLAVCIT.WAD",       "26791ec293d9d2e6af70513c05d860e3" },
    { "SWMORT02.WAD",       "6e3d79743515f2f598bec3418ce0884a" },
    { "SWMORT03.WAD",       "bcfe8da5653658aa8992496ba234abb0" },
    { "SWMORT04.WAD",       "143895e51ed7822af0e3673f53bf792a" },
    { "SWMORT05.WAD",       "2069e06c98adc717ad58fa26650275aa" },
    { "SWOCKHAM.WAD",       "b8ff44b4ba6638f1028d63b9a4da3283" },
    { "SWOMEGA.WAD",        "a81a5d7ea0b5216b5b14b86f376f5831" },
    { "SWS_ECV.WAD",        "1df585f5bd892aefd87e235cd6e38005" },
    { "SYD_1-3.WAD",        "dc884cd0aa4a72c787db6963e835098d" },
    { "SYMMETRY.WAD",       "279361fe4042eafc016fbe1100a6dfda" },
    { "SYMOCEAN.WAD",       "d9cc30ff45026350736681af9d14ea2a" },
    { "SYMOHOME.WAD",       "bb73d21b9b874af1adf872aedf5bcfbf" },
    { "SYMOPLAN.WAD",       "56c116fc656351e78c3dd9f186b50f12" },
    { "SYMOSHR.WAD",        "3cb2ca7aa492369e019c739e17cadd50" },
    { "SYMOWOLF.WAD",       "daad53d0b5eb32875e861df55ce0f418" },
    { "SYNJ1.WAD",          "cc214217394c66d4266ca53953fd05e0" },
    { "SYNJ2.WAD",          "afb673969202b2a094f8439b17f993c1" },
    { "SYNJ3.WAD",          "6e4ca9cb7bdf999f8dc76ea2246afeda" },
    { "SYNJ4.WAD",          "a45c639805ff20065e7f7bfe347c0a98" },
    { "SYNJ5.WAD",          "7b43d5baab419872d283551ff992fc32" },
    { "SYNJ6.WAD",          "2ed308b13e844b4d84eebaa91296ba0f" },
    { "SYNJ7.WAD",          "581a42fcdbca5f9c53839f628c790f94" },
    { "SYNJ8.WAD",          "4e55aa2a0043f66c868ef7afcf623d2e" },
    { "SYNJCO1.WAD",        "50fc0d5ee8dcec816d80b4f5e5a8ee5f" },
    { "SYNJFX1.WAD",        "4fcd33200d6f6b252641413f6e697175" },
    { "SYSVICE1.WAD",       "4fe23c052bdec48564d576647ef7c101" },
    { "S_CRISIS.WAD",       "54221e58861d9ec42583ed9af303dff2" },
    { "S_LAIR.WAD",         "1748b8b66d160e6a14f2cf319a52ee1e" },
    { "T-COVE.WAD",         "f458f12141a04a8049efe260da41b5fd" },
    { "T-DEATH2.WAD",       "f22a08b785c25d8d1911214b47371aa0" },
    { "T-M2MIX.WAD",        "5f2af851b72af9a1e18694c665d1a9f1" },
    { "T-M3MIX.WAD",        "5e5a9365b1143a4940e8e28f27293e9b" },
    { "T-PAK.WAD",          "e81aff2fbe1af884711ab0ff73e6c2b5" },
    { "T-SPIRIT.WAD",       "12ff275f808bacefe441623298305b99" },
    { "T3FOH.WAD",          "a740a51e6ce83f2fc4b5d18d54e3a945" },
    { "TACTICAL.WAD",       "fb1c987b6851a8b6fdbb330bd6606c40" },
    { "TAKETHIS.WAD",       "0db81cf7846c501e6e8a2cd728eda7a1" },
    { "TALONS1.WAD",        "ae628a93dc7f7715bc5840a8ada0176b" },
    { "TALONS2.WAD",        "3c53613dfc501d69e3656f967a9e01d6" },
    { "TALONS3.WAD",        "bc8fd30d848628a5182d30ec91e4327c" },
    { "TALONS4.WAD",        "e9391ec7c869bd831aa2f220c20949ff" },
    { "TALONS5.WAD",        "c4f31fcd3e211aca9315252caf66f8bd" },
    { "TALONS6.WAD",        "cdc789fb300bfb23bc56344f3ed9d41c" },
    { "TALONS7.WAD",        "eb594b7356517ac474b1d855288fb2d8" },
    { "TALOSG.WAD",         "abb9635d9f44c815ff282f7140778285" },
    { "TALOSL.WAD",         "5a415d1fe528ce91c5994b0b3503c641" },
    { "TALOSM.WAD",         "6562730e82ed8c8d78b2122afd639270" },
    { "TANG24.WAD",         "6bfd3e14c2a4e73e870e35b1697eec25" },
    { "TANISBASE.WAD",      "f19a5c1550521ef53668b93fa3200935" },
    { "TANTRUM.WAD",        "82db7f3851a66c6c6ec309c8084606e2" },
    { "TANTRUM2.WAD",       "343ca86b57f659b226ee26d495d2c22e" },
    { "TASTE.WAD",          "5c7d76270161ccae454a8c8cda43b56f" },
    { "TATER01.WAD",        "3c8ee0b1cd7bd2e80a34e65ccaa94f48" },
    { "TATTOO.WAD",         "f658318876123fa7c243a936c646dc30" },
    { "TAXI1C.WAD",         "e4e178217dbf55f9fa6cb3d4add06771" },
    { "TAXI2.WAD",          "be14c14a8b955afb2e365718c6c1d111" },
    { "TAZMANIA.WAD",       "8f02fc962aa6274e933eeeee5907f157" },
    { "TBB_1.WAD",          "a047ae1f6f028a1f01127869179874cc" },
    { "TBD21.WAD",          "460b711b0145943d6829b3be2c0e3017" },
    { "TBEAST.WAD",         "aaacd8fb4b415c8967338420a7f148df" },
    { "TBRIANS.WAD",        "a20b51415bedc990ce094200488d630c" },
    { "TC2.WAD",            "5002cdae9d2bd5b72cf2c74ad7784daf" },
    { "TC3-II.WAD",         "add394b33e64fc21b4dc02b9997d2df3" },
    { "TCCDEATH.WAD",       "684305947164ddc6cc525beba0c2c2f1" },
    { "TCHBASE1.WAD",       "a0758382fd3e41f3078d58f07b6e4468" },
    { "TCSAS.WAD",          "53aa79f14e81002a4faccdb3ea63c27a" },
    { "TD2.WAD",            "522196660642eceec4f2b1e3ba56bd67" },
    { "TD4.WAD",            "827c52eda249ba072402da6e52c6247f" },
    { "TD6.WAD",            "a541ae3bc7de37542cf91bebcffba197" },
    { "TDKRT.WAD",          "eff873f6382d6f1e4e7f685b7486abaa" },
    { "TDNGN.WAD",          "3eb8450bb536f9efef28f41f790ec4ac" },
    { "TE.WAD",             "830c87f56fc3316626f67d5543726542" },
    { "TEAMFRAG.WAD",       "9743edf029cf395b6a297be1c9f8108a" },
    { "TEAMFRG2.WAD",       "1bef8bf855a6f0715c8c5c764e04cfc0" },
    { "TEAMFRG4.WAD",       "ed398eef821dde063d68c5e808a578ce" },
    { "TEAMLEDG.WAD",       "6d446eed31feb87aa1ac060c3793897a" },
    { "TEAMS.WAD",          "7804a1a799ef2414e95c31a33f8790e9" },
    { "TEAMZ.WAD",          "7f672dfa5d74617e44d8866a58511ee9" },
    { "TECH LAB.WAD",       "f496ed5a6df25238515fb567473c31c7" },
    { "TECHCNTR.WAD",       "c303323cc087c889fbe72f1070c198e1" },
    { "TECHNICAL.WAD",      "72eaeda6f6ab81be99a3c4606b95a1d9" },
    { "TECHWARS.WAD",       "f4197ef6d16690f60701e459a5d0aecf" },
    { "TEK.WAD",            "e7fadac6f8cfe7a0891d3d7a17d6bcf4" },
    { "TEKBAS3.WAD",        "af153af292b21772d729d4f012f2c993" },
    { "TEKLAB1.WAD",        "34602a7def04b5fc69004689b048d84b" },
    { "TEKMINE.WAD",        "e1458eec617082c9a04eb857aa8fe9ff" },
    { "TEKRKBRN.WAD",       "b689b48709ca6885d919c2c06ab34690" },
    { "TELE1.WAD",          "9bb53217a575a39103ecdde4b8d834e3" },
    { "TELEBASE.WAD",       "39b72f1e676fe82c3657f9dca8047a2d" },
    { "TELECROS.WAD",       "6391a1dc955c786cab25a113d7a73f76" },
    { "TELEFRAG.WAD",       "7c2d209374af5677cd93419f6670bf71" },
    { "TELEKILL.WAD",       "f2b7329487253cf9aa572c799a6535a4" },
    { "TELELAB.WAD",        "5c871684891ce9fc84f8eb5bfd1c4af4" },
    { "TELE_ME.WAD",        "4cf12f06c45633fb5647c0873937c8fd" },
    { "TELLY.WAD",          "b59772a3663175e874e9d4e7d842d862" },
    { "TEMPL2_0.WAD",       "34625b7503b3ed0e67ecffef8198ad0f" },
    { "TEMPLE.WAD",         "3381b2694bfaba92a8a98a9f846da9d1" },
    { "TEMPLE.WAD",         "a1de2d24d57c73e14fbba32e5c231d5a" },
    { "TEMPLE2.WAD",        "7e4f56384f520626a590faa3f67d97eb" },
    { "TEMPLE21.WAD",       "f8b3106c9f0b7b55547ee6bc467fd2d8" },
    { "TEMPLES.WAD",        "750c0e3cbccca68cd7970ed753f987cb" },
    { "TENACITY.WAD",       "09e466811610ccc5b578151a9ef5de4f" },
    { "TENEBRIS.WAD",       "b595e61ca38a25a80bd88512887a202e" },
    { "TENESMUS.WAD",       "61b4e58488c5ab55ac9d4dcc0419d658" },
    { "TERM.WAD",           "fdf47a9bb6871962a7122ef1e7fb025e" },
    { "TERMINA2.WAD",       "7b614b13880dfdd1a41629ec392e7460" },
    { "TERORIST.WAD",       "156450e7ef00cd92113971ef3b34e7ac" },
    { "TERRAIN.WAD",        "dc120946b69ce0cc3b03bb54bb48a2e2" },
    { "TERROR.WAD",         "7bdca05d253ca9110ef3c0a580509dd6" },
    { "TEST.WAD",           "be4381489114e36c4b6d864440034b14" },
    { "TEST23.WAD",         "bb47af6a709c78f5f51adc7f892aec61" },
    { "TESTSITE.WAD",       "5ba0507224af423f40a0d8d8e7850b8d" },
    { "TEUTONIC.WAD",       "f92290d91fa2d6f4355a89ca9e349a3a" },
    { "TEXTURES.WAD",       "ddc8f68a5a5fc692feac9189b97bd6a9" },
    { "TF1.WAD",            "d78d68816bc883830bed30a39e91b390" },
    { "TFA.WAD",            "a67662a4c5c14f832cdffc335790003c" },
    { "TFB.WAD",            "a7ca93f45d58b43e651513aa37600402" },
    { "TFC2.WAD",           "1867992ef1fe518e2dae81a493fdb5c7" },
    { "TFWDETH.WAD",        "6a0d226d65ee89215076bef3d3c0a81d" },
    { "TGC.WAD",            "58347bbb8873b5868a2ccccd1c1860ea" },
    { "TGREYES.WAD",        "b4e0ca1cea4d78f8d4a60386979f6ead" },
    { "THAB12.WAD",         "dea8207c58284c9a228139bdefb4e955" },
    { "THANATOS.WAD",       "e2fe82509d4f9a4742c7d67c7bfc1858" },
    { "THAPPY.WAD",         "1337eb3d648e9b52f4a1cf94372f9504" },
    { "the hell is here (+by hensoft).wad", "95fe405aa397620145ee26874d77d26b" },
    { "THE-END.WAD",        "bf30854a76c5de4645a71d074c99d4ec" },
    { "THE-Q.WAD",          "65b662adad7b099d625e8c7f0dc35191" },
    { "THE-ZONE.WAD",       "565af8922ab23446ddb4698bd7164f95" },
    { "THE.WAD",            "534c77098a75de227d2ef8cb4258d761" },
    { "THEATRE.WAD",        "475086bd06fa8669db6008add759e7cc" },
    { "THEATRE2.WAD",       "b1bb5b6b373e07fb49c2594ac1ffa610" },
    { "THEBASE.WAD",        "55b40e88269ace8e4b54ff559a17f655" },
    { "THEBEST1.WAD",       "eb7320f0f183a9f0b1b8aedaf6a75d4c" },
    { "THEBEST2.WAD",       "462023cfc7c5e957242d9656d8850b01" },
    { "THEBEST3.WAD",       "ee94a9fe142867ef90af7835654a1267" },
    { "THEBEST4.WAD",       "3178795317d19820517325c5e0ee3342" },
    { "THEBRDGE.WAD",       "a3f69b6df1921b64b5668c7b70b81722" },
    { "THEBRIG.WAD",        "c3da2a22923f94c829055be9acddce82" },
    { "THECAGE2.WAD",       "3841db1bd95b08bf1edb9b54a8a5d4d2" },
    { "THECAGE3.WAD",       "9784994ac2d628a1935a30a524499a2f" },
    { "THECHASE.WAD",       "76dcbd9224349f69b376303891043040" },
    { "THECHOP.WAD",        "e6cd2c2083dd48e317ecb34794a70c1c" },
    { "THECITY.WAD",        "d8011b608a4731c40301b8253cc55f05" },
    { "THECLAVE.WAD",       "3429d9da54ff0f9f6dd77fc152bf6779" },
    { "THECRAZE.WAD",       "66f6e7f535a6ceb005231d5c14845d6a" },
    { "THECROW.WAD",        "1049a95225664db54c0c10ab829fb0d3" },
    { "THECRUSH.WAD",       "70bf7278201d1fd83f5ab830f39b7213" },
    { "THECRYPT.WAD",       "dbb30eddb3fc83a8525b1e1aa36a0eae" },
    { "THEDARK.WAD",        "52bcd2976206c00740c1420db589f6ec" },
    { "THEDEN.WAD",         "917f6924160bf9eb4ea087cd75c42566" },
    { "THEEND4.WAD",        "a4a76f19133d4dd86c46906a90149605" },
    { "THEGATE.WAD",        "58565e60f4019317c7887c1921e11f84" },
    { "THEGWAVE.WAD",       "fa9660d1f2508f53311c7e1f53d8404a" },
    { "THEHOLE2.WAD",       "7907fe704b0f640b7ce42f74adf4ebaa" },
    { "THEHOOK.WAD",        "bc9dc2d00410dc394c62b9f0526bd963" },
    { "THEHOUSE.WAD",       "119f7930abe0e09ca25c716ff821750a" },
    { "THEHUNT.WAD",        "d42545c556a247155fd19ba79d7beb39" },
    { "THEHUNT2.WAD",       "e864da97721392e0da0b525b42c2f9b0" },
    { "THEKEEP2.WAD",       "99ff346e99c5c03d9d96dbdd2780fcc3" },
    { "THEKULT.WAD",        "41a2b4b1fbaec875ba1cbaff1b3f9d1f" },
    { "THELAIR.WAD",        "7b85bee2ec54eb5340623eb53e942f72" },
    { "THELORD.WAD",        "e5c15d7793737d8eedbb34ffa73a9168" },
    { "THEMAZE.WAD",        "7dd279be33787469d104d44eeb5c07b1" },
    { "THEONE.WAD",         "944637f2fc0926d8b78ba6684152e7ea" },
    { "THEPATH.WAD",        "4126e46bb93aafd48de547ac050b9832" },
    { "THEPITS.WAD",        "a33485d8e869d2fd8ec8cf1bf1b54028" },
    { "THEPLANT.WAD",       "7f5ff33fc5357ee00232f5e5b493ff2d" },
    { "THEPORT.WAD",        "009e4f49a445a2915522b73599699f8a" },
    { "THEPRIZE.WAD",       "876f75decc33fe89034576ecfd670a59" },
    { "THEPURGE.WAD",       "a3f806bfe83e75ee8b1dc2505043b93c" },
    { "THERION.WAD",        "a7dbe2268963d3962749814856d52607" },
    { "THERMITE.WAD",       "6ef20a7ac45547b3d6586b3382f8da20" },
    { "THETOWER.WAD",       "2720085ecf8591b74e6700c021c60a8a" },
    { "THEYARD.WAD",        "ea24ef5eb364803dd81545c5438a5ca7" },
    { "THEYARD2.WAD",       "043c6b0ccca8d8cad4cc9de8f157523e" },
    { "THEZONE.WAD",        "461e80635495ada0baae14bbd7493c5d" },
    { "THEZOO.WAD",         "c009a4fad9e04f3a1aac490a7651ea49" },
    { "THE_BEST.WAD",       "74bfe3a03d90bf6fc2238c79c7d3ef31" },
    { "THE_BOX.WAD",        "f8fbba8df5425e9a12fc5b33cfd2d6bc" },
    { "THE_CAGE.WAD",       "f43a8b3091a7edc7990cfa9314451e9b" },
    { "THE_CPU.WAD",        "b346e39e3a3f60f9f6b09a3c68c00764" },
    { "THE_EGG.WAD",        "214d837e4bea1998ade0c01c18c46608" },
    { "THE_EVIL.WAD",       "d942a6ab4486e78e2558126a5cda61ff" },
    { "THE_HOME.WAD",       "bb641f1ec3efeb26066ad94289cd992b" },
    { "THE_KEEP.WAD",       "ceea6a86b07d3d1579ba37b530cbe7ea" },
    { "THE_POOL.WAD",       "96075c22f573a5408af6ef60e2b00642" },
    { "THE_PUMP.WAD",       "3e1c8100607accd555a367443396115e" },
    { "THE_QUAD.WAD",       "2af1bebc9c3f12dcc7c032911e3596c2" },
    { "THE_VOID.WAD",       "23c0287d0c09d7c968ade9c7a18da2f9" },
    { "THIEVES.WAD",        "24d87db2bf89e2449ff361a67611e4ec" },
    { "THINGIES.WAD",       "870132e9984f15aa1b6261aa6d546765" },
    { "THINK2WC.WAD",       "77104d0c3912a167191f006ee77ddf6c" },
    { "THIN_AIR.WAD",       "51b3ef7c5a2a1cc2c2d57925f81b452c" },
    { "THIRST.WAD",         "aa8ee418c5d3d17976a90dd5cc4a7fab" },
    { "THIRTY3.WAD",        "db21187536511bd065d9847620494ff4" },
    { "THISSUXX.WAD",       "d146a74fea874e3df7b3e04b85f8b6b8" },
    { "THOR.WAD",           "8bf3b1b03ca2a0615598be30ba4d6f7d" },
    { "THRASH.WAD",         "56f408e8f2258f3430487973b213034d" },
    { "THREAT.WAD",         "7a3196c0d1ef8d24dbfd70106f65afe0" },
    { "THRESHOLD.WAD",      "7b2cc9ac907ea4cc822768e29cf718bd" },
    { "THRILLME.WAD",       "dad1b628240cf9909bdf69d0fda33e41" },
    { "THUNDER.WAD",        "038009ed6c9fe35de5a9653414bfa20c" },
    { "TIBER1.WAD",         "ebbcaeb9e410f0bb59b0158dfb3100b4" },
    { "TIBER2.WAD",         "3ad71a94f3370a5537934924c2080428" },
    { "TIEFRON.WAD",        "30d7b521c86bd09640c225b0273d900f" },
    { "TIGHT.WAD",          "c41d58e4eb8061c16c8abbbf1f9df8a1" },
    { "TIKAL.WAD",          "52d976533df1932eff7db784b9ae1ec2" },
    { "TIME.WAD",           "119f749424c02245b0f985bede0da070" },
    { "TIME2DIE.WAD",       "07b049762024bb3996d2d9cb1e63b960" },
    { "TIME2DIE.WAD",       "cc6b7c64838284c4987780fbe2cd6a3d" },
    { "TIME3DIE.WAD",       "3d2fc8dc2fabf4f794f5e78ca278cbdc" },
    { "TIMEDM.WAD",         "2f1515140235c34d7e4b3eea9efaac05" },
    { "TIMEGATE.WAD",       "f7e4f651019e26d1ec1818c466052f4e" },
    { "TIMJAYL.WAD",        "cfd6dda187be2d1016f9365999376b24" },
    { "TIPTOP.WAD",         "031c7d1d1a403218eec3af8b42672648" },
    { "TJM_HAUS.WAD",       "ac209068d4b70648ce1c1a7a1cc9cb7c" },
    { "TL1A.WAD",           "8df38c11a781678553839c65eb9df23a" },
    { "TLABS.WAD",          "05c042795709098153a5e2d094c8e8fe" },
    { "TLEFEX.WAD",         "3dd2eba9807d35cd31931bd725c5f3e8" },
    { "TLHOPE.WAD",         "c553ef035f9b301a780365f116147a4b" },
    { "TLR219.WAD",         "5d79b2d063ecffec747fc0f4a837a763" },
    { "TLSD2003.WAD",       "468686918f1d590c2412bdfa1390bc6f" },
    { "TLSD2004.WAD",       "1ed8a96147291262ff02f8188606efd0" },
    { "TLSDM2K3.WAD",       "1e64b348dcfb5892b931df3828d40eb5" },
    { "TLSXCTF1.WAD",       "0af8b239b239b2adbff494fa4c604622" },
    { "TLW_1.WAD",          "a98d01903051a77301b4d74e1a40fbaa" },
    { "TLW_2.WAD",          "d82b3154d8d19bf4ef9e2d4947333920" },
    { "TLW_3.WAD",          "cfff1ddd65fe5be49edfb6ab3d5ef7de" },
    { "TLW_4.WAD",          "2601b9509e07b858e4b2e85d4ce9598f" },
    { "TLW_5.WAD",          "8010c958be7cf1d9cbc4944cd896b82e" },
    { "TLW_6.WAD",          "e23864dd90310f3b083596ecfae9eab4" },
    { "TLW_7.WAD",          "3090c7bdc7949f980b6fbca4ef20dc2f" },
    { "TMASON.WAD",         "1837700ebcde883ec53cff98957a169c" },
    { "TNLSOFUN.WAD",       "88d8bf5661f6e72f5b8a536783529c43" },
    { "TOD.WAD",            "784e54db51e895b6a0934fbe067a1b4b" },
    { "TODDTHE.WAD",        "42e5b0b77e9805f4e6099c0a742d8448" },
    { "TODEATH.WAD",        "c8283e86d805878484930c8f076264ef" },
    { "TODIEFOR.WAD",       "5bf4c7c4b527acbf2f4b55016337a704" },
    { "TOF01.WAD",          "61fa893811b98fd4e9f408ede58e9dce" },
    { "TOKZIX.WAD",         "93119feefbf6d1acbaa496548cf08aec" },
    { "TOM-WAD.WAD",        "837126ae59abaa8099231ac7b012b22c" },
    { "TOMBDARK.WAD",       "5b9bbebf549d98d30fabe2f71bf1beff" },
    { "TOMSROAD.WAD",       "fb2ceffbaeaccf7abcf03d2d02dbedb3" },
    { "TONIGHTS.WAD",       "a8058103fda982b6f508afaea8b90b5e" },
    { "TOOL.WAD",           "be4381489114e36c4b6d864440034b14" },
    { "TOOMUR.WAD",         "d61e82414dd7aba6b078e2fefe4d9599" },
    { "TOON2B.WAD",         "de3710dba47d365358c95135d502f807" },
    { "TORCHES2.WAD",       "a68a1819c11900fef963408b07e6c1d0" },
    { "TORMENT.WAD",        "87e63f82340a171eb3ae4c93a1b4eb40" },
    { "TORTURE.WAD",        "a66c50bd378ad144e2c2b1b8054d4def" },
    { "TORX.WAD",           "1868bfefd71833ff2e555e4e4fc54802" },
    { "TOTALCONTROL.WAD",   "404e7bd71ff97b044565cc40eab1bf74" },
    { "TOTALDM8.WAD",       "d0588502e9d3f5e48238ca2102e71115" },
    { "TOUGHDAY.WAD",       "239a9cd869db0c3a04ea49749c31fbff" },
    { "TOWER.WAD",          "c7fb68ac6176b9c3a7d21c014478d803" },
    { "TOWERANG.WAD",       "65f85d6629a9a0a504329da622f637fd" },
    { "TOWERS.WAD",         "073b2f98af6780d245c80ea8ebd61491" },
    { "TOWNHOUS.WAD",       "e9031e5d999eb1eb96aa343896a9d418" },
    { "TOWRDEMO.WAD",       "913a0350b5f59f380938af187b07fa2d" },
    { "TOWRMAZE.WAD",       "69ee14082247a300d8eaaf0842804e60" },
    { "TOXDM1.WAD",         "748d0fe7d901d951ca42e4dfa1487e6f" },
    { "TOXIC PIT.WAD",      "58c25ea39170adb6209e0246e4d74a8c" },
    { "TOXPLANT.WAD",       "dd86f0ff3eb7fa3223b96e06f05fdf2e" },
    { "TOYFACT.WAD",        "c4f24ef6f4147dc0710c80b66fb4c2ea" },
    { "TPMANIA1.WAD",       "b87f9f6bbe85db9950ac1994cf4a939a" },
    { "TPMANIA2.WAD",       "184e8dbddf4f8fda93c9970aa465043d" },
    { "TPPAIR.WAD",         "da7e7063d65af9107313fb6299d8a446" },
    { "TQ-MAP03.WAD",       "4e403d6b9df131675bb322aa70eed78e" },
    { "TQMAP1.WAD",         "c24a96ffdb66b97fb480217d9285cf5a" },
    { "TQMAP2.WAD",         "f3bcdbe10f3192f1246a14e3f00ae566" },
    { "TRAIN.WAD",          "20b4ad25462d3c637471e02a13dc02fd" },
    { "TRAINER.WAD",        "7195a43fdb257e3154e88896540745ab" },
    { "TRAMPAS.WAD",        "3590182bae4b5a8c46992e8409478725" },
    { "TRANQUIL.WAD",       "ccd9d429c5cba950751b018f25d8af77" },
    { "TRANS.WAD",          "22b7ef17850f4bdafeab62357f99f30e" },
    { "TRANSFRM.WAD",       "4b6d2f94275427ebe470230132079701" },
    { "TRAP.WAD",           "2e4952cdf4c7c28d5f65abb734fb635c" },
    { "TRAPLAND.WAD",       "c15edce79e589b67c94a36e4dd54e904" },
    { "TRAPPED.WAD",        "a3b64b239248914f9870c0e70af24164" },
    { "TRAPS.WAD",          "22f140189141863402d9cd6458945c5a" },
    { "TRAVIS1.WAD",        "30196eb29a5be7ee1e0bd7c1c4a1a3d6" },
    { "TRAVIS10.WAD",       "c622e5b5c2b0026d0f871b8d734d7bbb" },
    { "TRAVIS11.WAD",       "ce6cfd92a69131f056adddc091b2b507" },
    { "TRAVIS2.WAD",        "3bd176b7ee33c9c26e51d09438180dcd" },
    { "TRAVIS3.WAD",        "d325b7a6474a6a08b6336e0871c84ca4" },
    { "TRAVIS4.WAD",        "02227f2fbbea4b067389b3c41f6ba706" },
    { "TRAVIS5.WAD",        "a4d129e5035256b6b6d7227dd7ce4c43" },
    { "TRAVIS6.WAD",        "f2edf3ce2eac5f91b11dfc358961b9d2" },
    { "TRAVIS7.WAD",        "6e688db3e46a84506b030f015cb64f43" },
    { "TRAVIS8.WAD",        "e9b22fbf5e838e576260a53285374569" },
    { "TRAVIS9.WAD",        "c3b03fb1938b8b24f21c8849d8b9925e" },
    { "TRECIAS.WAD",        "57fbfd2f2ad3b0f8418ab08b80cf8d1f" },
    { "TREDSOFT.WAD",       "ce4ebc2042d9a5a97693e0be5c32d60a" },
    { "TRENCH.WAD",         "872e7c91fc7e0ffe01414431a46ab085" },
    { "TRENCH2.WAD",        "7a29096640c2fb24bdaba3cefbc313e8" },
    { "TREV1-8.WAD",        "5ead8ca17f2871d446fb8043f6ba9f0a" },
    { "TRGRHAPY.WAD",       "ac5565e5efe5b831e830acdaf30ea55c" },
    { "TRI.WAD",            "c65f94a8d77bb448258489d93fd89c8c" },
    { "TRIAL.WAD",          "dbfdf7c17c1869a1b3facb33d57b8eb5" },
    { "TRICKS.WAD",         "86d5d68ab3f7f70bde3844273560b7a8" },
    { "TRICKY.WAD",         "b7fb1f4ac5f8df3520835a04a8c9a768" },
    { "TRIDENT.WAD",        "8381beb017fafa7d152e92e4db911849" },
    { "TRIDETH2.WAD",       "8c0f43d8e97a47c6e5d2836b7e7a212a" },
    { "TRIEX.WAD",          "e530270cf0b64792e81a9af64a05c55e" },
    { "TRIGGERS.WAD",       "41a0fe48f3941cb080f9021b61c3e7e1" },
    { "TRIMATE.WAD",        "780e9c0116e1c3ae94a1232ed083ad9d" },
    { "TRIO.WAD",           "19a631d1f1875dce86fa8a83dfc53bda" },
    { "TRIO_9.WAD",         "7b0bf15e50c4dbb249144e068cd3e70e" },
    { "TRIPLINE.WAD",       "49266464974f6217143d748673bf8892" },
    { "TRIPN.WAD",          "850625e854f5bc538553a5963e8d0b15" },
    { "TRIPPYS.WAD",        "388eaede34635369c7749a9ab4ea7920" },
    { "TRISA.WAD",          "273ed3bcec74bee69cdf23b5a4a2c496" },
    { "TRIX-T2D.WAD",       "6b380f4ac61e2dd5d2c35f6d4011626c" },
    { "TROLLFL.WAD",        "ea758f77f3be2b72a4835903fc663fcf" },
    { "TROUBLE.WAD",        "ee7a0adf490b495de1a4ad8388dbe3c6" },
    { "TRPDWLLS.WAD",       "3d61fde67e021bfcb730f53e32c3256a" },
    { "TRRORFLT.WAD",       "ec2f89d13ba5e9e2fa7cd2397b5d9499" },
    { "TRRORSPR.WAD",       "b65522a37f587458c61a1f2ba4ae6b83" },
    { "TRUCK.WAD",          "7ce63adfb97fe960fca8cdd128ecdef9" },
    { "TRYDENT.WAD",        "38bddba4eeb28a11ef278b141007ee72" },
    { "TRY_ME.WAD",         "43860d7a6771408adf8d7c059ed9952d" },
    { "TR_LVL11.WAD",       "75b92e43a9eae384be7321794fca9cf0" },
    { "TSC2.WAD",           "05aa59a7ac93f87338dd4a78483dce04" },
    { "TSOBD.WAD",          "d78b6ef924f2ba58aed1bedd20427b19" },
    { "TSUNAMI1.WAD",       "7c6f020f4c9f0e719a338d69b1c15d9d" },
    { "TTD.WAD",            "81a97484326ddca4003e95b9e453514f" },
    { "TTP.WAD",            "d46a8e155f3e1133ac7dc92a1073ed19" },
    { "TTPBONUS.WAD",       "6168663380da2a4829bc51febb553723" },
    { "TTPDEATH.WAD",       "b6f163850db1220ba5e777e17e3f5b1e" },
    { "TUBE.WAD",           "9e278f5d796541ad6634138c4581b61a" },
    { "TUFT.WAD",           "64af993256bccde4869480b767dfce42" },
    { "TUN-RUN.WAD",        "e5a241ab9ccdda8a7063e12466d5afe5" },
    { "TUNNEL.WAD",         "2c0bac46a1ca17da3148142362ccdcc8" },
    { "TUNNEL11.WAD",       "eba6b2366e553b567e8c1171e775a794" },
    { "TUNNELS.WAD",        "888b258979b61b00f13035f50df149f4" },
    { "TUNNELS.WAD",        "bfa82e7102e9cdcf60c3d650c0b9f3bf" },
    { "TURBO_12.WAD",       "b9bcaa2f8e5d9c0a7ac6143654b96ef1" },
    { "TURDHIL2.WAD",       "42d80ccb0b1e767df2acf67aa9f28205" },
    { "TURNARND.WAD",       "785b3c41aeef467a41a01c44facf207e" },
    { "TURRETC.WAD",        "f675b0311518e8e37587a9e70a0d8103" },
    { "TV1998.WAD",         "9792348de36e55d42d8b5e6b3f03b548" },
    { "TVR!.WAD",           "1af281c0fbba582df7a541f5d7d5b286" },
    { "TWEEKER.WAD",        "0519c6c5c018939aeb9c70d519ef92ee" },
    { "TWELVE.WAD",         "523c0a7c519ecafd94285d4177860c5f" },
    { "TWILAB.WAD",         "4a805c3f0ef5db4b24510bcf55981032" },
    { "TWING.WAD",          "c3edd3221ac530f6fd8e497e0c0746b5" },
    { "TWINS.WAD",          "ef4a4e8033008e0f230e81bb0472175e" },
    { "TWISFX.WAD",         "97727c17cfb7234623033dca7a6c079f" },
    { "TWISTED.WAD",        "b8e405f6158fedfb7edb75ac538f8eee" },
    { "TWOHOUSE.WAD",       "bdf9e13b094c3f22e6c34babd1de1374" },
    { "TYHALL15.WAD",       "af83481fe7f1635908e70099150be566" },
    { "TYRANNY.WAD",        "ebeb544120d4116c6e6c7000b0c292a4" },
    { "T_DUNN02.WAD",       "055b7df693f104fdaf8aac0c74ca01ba" },
    { "T_MEDEVL.WAD",       "a538cde394d9d227b84f9cc2d32b2c33" },
    { "U2DOOM.WAD",         "1003e97122de3e1f7ac7e2c5e3ecc8a7" },
    { "UAC-CTF.WAD",        "22996ddfb42a30dcccf8c4a8da6a095a" },
    { "UAC.WAD",            "2a1620eb08cbc58ca79209adff93adb8" },
    { "UACBASE2.WAD",       "703a28eeaa0505634bd70aaca5dacacd" },
    { "UACBUNKR.WAD",       "05d34b3c474cb26e1ec9c77b281e0182" },
    { "UACCNTRL.WAD",       "498278a02994b0f6ffb467285dbd8288" },
    { "UACCORP.WAD",        "3e7aa91cad815d0adc410c78c48d7898" },
    { "UACHQ.WAD",          "6c41b8c1b11d4b16f9815a5c34473815" },
    { "UACHQND.WAD",        "a1a2cc1e67842192f8148f2d140a745e" },
    { "UACOMM2.WAD",        "3d37c1069be34b2157a5037a62bbb693" },
    { "UACPLANT.WAD",       "5d14aba9b5dc2affd338c7b1702b6fb4" },
    { "UACPS.WAD",          "746fe11bd4a2c36f127db7c9f7ad51f1" },
    { "UACTOWER.WAD",       "10383c2168abd6b33672ec75bec1a6b5" },
    { "UAC_CAVE.WAD",       "1c3187d27b08ae2ffd36528e9eb972d9" },
    { "UAC_CNTR.WAD",       "b0862e2f5b47bce6e08fe382315356bf" },
    { "UAC_COM.WAD",        "ca8e552f93375f4ce7b3292f1e2127c7" },
    { "UAC_WET.WAD",        "032024c6f34fd36a28424056f3cf3e84" },
    { "UAE.WAD",            "0158e0585018c3eeb9470db78e0081e6" },
    { "UC.WAD",             "b488d1725bf9f0049c1372e5106bbdd0" },
    { "UCONDUCT.WAD",       "1388e028cc81347746c2e06a2954c00f" },
    { "UCTF.WAD",           "a6cfd7483bfb504dccec71c708ed7357" },
    { "UCTF12.WAD",         "133a84507a705120a58dd9c3ab8f7e2a" },
    { "UD.WAD",             "d9368f7a8a841d3d0f9e505302e958c0" },
    { "UDC12.WAD",          "79d871456aa73ecf6893513b3a4209ee" },
    { "UDM1.WAD",           "bec209759eab1aec9321dbbc935f1785" },
    { "UDM2.WAD",           "06f1883ea108665f03ae191d0b402222" },
    { "UDSM1.WAD",          "20217f49b883f0ab477431271b67d06c" },
    { "UD_10.WAD",          "9b6f401de0c48a274ec64d72346f75d3" },
    { "UF.WAD",             "98df7f0ff70624e68ea86dc758ea1340" },
    { "UHLY.WAD",           "e92f72359fdd3e8d6273f1d78effb403" },
    { "UHREMAKE.WAD.WAD",   "9e82feda6cd6d9371298db5e3dd35c16" },
    { "UIA1.WAD",           "9ccb3db6347b996beb6a14927378666d" },
    { "ULTIFRAG.WAD",       "c924d1c9028ac7ed29957b6f766a5f6c" },
    { "ULTIMA11.WAD",       "59f18d870b401ceb6f0ad21bcd5e7d7d" },
    { "ULTIMA56.WAD",       "6336353b99cfa5727135ae9e6475accf" },
    { "ULTIMA6.WAD",        "43f13810ecc4ec7d57efb97943f5af35" },
    { "ULTIMATE.WAD",       "d0752a55373bbab7ccbf8a59b00ec6dd" },
    { "ULTIMO.WAD",         "fdf92eea90a7c6b3e3856c02e2e32871" },
    { "ULTRA.WAD",          "05af5a5e79c39d6a49cdf241c01adf52" },
    { "ULTRA11.WAD",        "89494f2db50d441126efaec4c36eefa5" },
    { "ULTRA54.WAD",        "ae7ec8b3b1468cb86ec2ed0e3d2ad251" },
    { "ULTRADM.WAD",        "cd90fddd55d9ebec3cd06306e5ac07b2" },
    { "ULTRA_DM.WAD",       "7d36936bfc0ba0b383d0094b414cf12b" },
    { "UN4GIVEN.WAD",       "60fd6ae18cafb35d2be973dd97b81b8d" },
    { "UNAIDED.WAD",        "1c186f9b53f7d23276e5deaab1d0f10a" },
    { "UNAMEIT1.WAD",       "229b716ada53c0556a7b93c9514f96ba" },
    { "UNAMEIT2.WAD",       "d8dd16f2ef9ef4e279d0043e9e11b92c" },
    { "UNAMEIT3.WAD",       "9b0dd4c3d258c0bd519b363493c1393c" },
    { "UNDER.WAD",          "32c87706ed3ebe6e78bb9f4a7cbb5aac" },
    { "UNDER13S.WAD",       "1e06976d4072c034d329ab6867bc833d" },
    { "UNDERGND.WAD",       "4ae3d2aeb75cecb4fce973b7eb3c6161" },
    { "UNDERGRD.WAD",       "813d21d5bce1bedb1a5d1792de9367d8" },
    { "UNDERTOW.WAD",       "56b3778c0abcc4ad44754eb926cea274" },
    { "UNDRANGL.WAD",       "a2fab210d2408d4d854c20b549ade90b" },
    { "UNDRDARK.WAD",       "6aaefd1d879d6082e2122c9a8fd4deda" },
    { "UNDRFIRE.WAD",       "3be74018f80c11f8b399c2d338d922b5" },
    { "UNDRLAND.WAD",       "b55f1182089a5cf2d80447effb099ab8" },
    { "UNDRSEIG.WAD",       "670f6b917366bc1e1d808f17a721d1a5" },
    { "UNDRWRLD.WAD",       "c47d47ebc0983fd42fd4eb8a9c58b4be" },
    { "UNFORGIV.WAD",       "9a38b3fceff751ffafdc5c6bc1fea258" },
    { "UNHAPPY.WAD",        "6472e52f6e36050ffdb0160974b38f16" },
    { "UNHOLY.WAD",         "db752a368b59b0eae5d19a4a530b0533" },
    { "UNHOLY01.WAD",       "b1751502942b6fdb7e1847848305cd96" },
    { "UNHOLY02.WAD",       "b8a2bdf20628dcca9dca1bb7445d972b" },
    { "UNHOLYD1.WAD",       "d36b42efc241e2ff3a2d29fb1cfcb8fb" },
    { "UNHOLYKP.WAD",       "a3cbbb3c7bacc9dba39ff003036c60a8" },
    { "UNI.WAD",            "fc1ed763647f554cf02d468cafc9a1b4" },
    { "UNISIN.WAD",         "337808ca033027f99a156c14e40e82c9" },
    { "UNLAG1.WAD",         "e02a26417844a231c91b944a5abab3e0" },
    { "UNLAG2.WAD",         "c3509bf8d7611ffe072cfbf181b8eaab" },
    { "UNLAG3.WAD",         "c6c2a718e207c37113a82a8cedb3c99b" },
    { "UNLAG4.WAD",         "3dda2777ea742fa727abcac15243b64e" },
    { "UNLAG5.WAD",         "6c33eafdc32e514a56b5b78f6cc8251d" },
    { "UNLAG6.WAD",         "85e966ed428f4dec91e39862347b2ed4" },
    { "UNLEASH.WAD",        "1998adcc47cb25df4568374f17cbba2c" },
    { "UNO.WAD",            "fa466f759fce42245d8a6225dc1eabaf" },
    { "UNO_EXIT.WAD",       "0cb1a1ff023cc1bd6d98cc83ffd405a3" },
    { "UNREST.WAD",         "d709c62c23066797b2b902f0a2384e29" },
    { "UNSEEN.WAD",         "a4a5fd92f178f77195578b5eda8ad429" },
    { "UNSEENEFFECTS.WAD",  "07bf22fe3377950130cc30b346c3cf02" },
    { "UP.WAD",             "1dac99798d23cd07ac9a970a31035e74" },
    { "UPFRONT.WAD",        "062eb205ff861632a7d3c228aaea1e77" },
    { "UPNDOWN.WAD",        "d743c0aa22af01ab68d578ea260ae098" },
    { "UPR.WAD",            "4bfa3b8d03899a1c598782a81c72645d" },
    { "UPSIDOWN.WAD",       "1a1cac0417c6dde607067e0aeb98e226" },
    { "URBAN.WAD",          "8ee89aa196aec8cd35b3ad3daab50132" },
    { "URBAN01.WAD",        "753baa20e5d7c9cd12c6fcfcbb3adf77" },
    { "URBAN1.WAD",         "5e67d7472e3f8b18f25cd7983a6374f6" },
    { "URBAN2.WAD",         "0f7d861b1e04b4fc1b292311a6f1f9f0" },
    { "URBGFX.WAD",         "cba98176da06b0ef97be87849ab8d979" },
    { "USQ.WAD",            "b76b32ae5fbc4b24eb0a229d20f86033" },
    { "UTERROR.WAD",        "e6f378cd78330d96813859e490f99b44" },
    { "UTOPIA1.WAD",        "bf1aa3a1c56e71372214b828e86cb9e8" },
    { "UTOPIA2.WAD",        "c9b7ba6f14b2f8176f1be5331ecc2e33" },
    { "UWCENTER.WAD",       "8734816cee6ddab79655f8c005446bfb" },
    { "UWIN.WAD",           "2d5e710b74df85382b20113ef7b79e3b" },
    { "UW_PART1.WAD",       "094b5808036879c862a79d3d13b0f5f1" },
    { "V-DETH.WAD",         "b125388d9189b8ba259b179a7754b5fb" },
    { "V-SOUL.WAD",         "0e0b003a50ad4c2feb768b8fc189ca2f" },
    { "VACATION.WAD",       "42123f5eddf7b63aef30773f104ac630" },
    { "VAL002.WAD",         "075890e935f6abba9e2200e06ecbf51f" },
    { "VAL003B.WAD",        "2d295d0800c58150f23287eb5d91b6a2" },
    { "VAL004.WAD",         "ee71bc308e7fc18915bb0ca4191cc3cc" },
    { "VAL005.WAD",         "dfa1f22c05f4b35ba906646b6448254b" },
    { "VAL006.WAD",         "8e2b42a6207af37bf2c1fe6b705e901d" },
    { "VAL007.WAD",         "8efa7a5de81dada69ce9103f9e08db0d" },
    { "VAL008.WAD",         "7121286ff67b6c216421ffa959cfad6b" },
    { "VAL009.WAD",         "9965f16324af71a19bb95922b5d82afc" },
    { "VAL999.WAD",         "975b0c16538363806473c09eef357b24" },
    { "VALHALLA.WAD",       "f4c8ce596e3043e565f0946eb07f9567" },
    { "VALK122.WAD",        "48420436760a5f97f176187090c4f90d" },
    { "VALLEY.WAD",         "a952f06b2bf82c4747411230e94bc151" },
    { "VANIA.WAD",          "d9f8e9edc90e444ea897ab9863dd1de6" },
    { "VAPOR.WAD",          "902866086a83176b4f70c47c765cd407" },
    { "VATS.WAD",           "6038493aa3004ae0de859995826254f8" },
    { "VAULT.WAD",          "18087de6e33b2104ff834b746108f480" },
    { "VDPAK1.WAD",         "cb867b2e3126a75c2ba9cf63528e6b23" },
    { "VECTRA.WAD",         "a6d79ea5f0993625152e61dedf264052" },
    { "VELOCITY.WAD",       "fb3ed57c9e93625abb0232061165eae3" },
    { "VENOM.WAD",          "7b6c58dc10af4d2d585ae97d42909a11" },
    { "VERADA.WAD",         "0bfdac446ffe824901bd1d893a825528" },
    { "VERTIGO.WAD",        "4867a1a569c986dce4f51ccd65f503b7" },
    { "VEZENI.WAD",         "3e18e33aaa87a46dfca59dbb51388b8b" },
    { "VH.WAD",             "bfdea7c5449ecab36158eeefd87d8c9d" },
    { "VICIOUS.WAD",        "8a65261af689f02b42e68c679d5c992c" },
    { "VICTIM.WAD",         "cc36f5b9af378dd4b719b7f90d4ed4d4" },
    { "VICTIM4.WAD",        "05ee2a3720192b30e7310af649c06075" },
    { "VILEBUG.WAD",        "e966d654f3cc4f94aac57e33fcadea20" },
    { "VILLA.WAD",          "eb10f0165f64860c188cc4051b91468f" },
    { "VILLAMEX.WAD",       "8aed13fccf6e04f9b3c8ad22cb43309f" },
    { "VINFDETH.WAD",       "473ae00024c6b69064a56e8430837fa9" },
    { "VIOLENC.WAD",        "54ace3ed8ad6c12738d8cfb9b82b279b" },
    { "VIRGIN.WAD",         "696023df4449fa07bf83d77b3c6d1485" },
    { "VISCERA.WAD",        "547563b785350c994b04eab4c2a36ff0" },
    { "VISIGOTH.WAD",       "2baff1214806dcfa07404b21838e4cca" },
    { "VISOR-1.WAD",        "b4af39ab0021db15bd4bc5f1fc39cf4c" },
    { "VISTA.WAD",          "c785e1721cafeac7112a19056f5949b0" },
    { "VIVALDI.WAD",        "2c8806ff0ab323dff63d830210736114" },
    { "VIVALDI.WAD",        "661db02b1a8cd68117a6c6d6f38954f2" },
    { "VOID SPACE.WAD",     "88a1f4318f049a00e513ca67c6bca886" },
    { "VOIDSHP2.WAD",       "bf7b4a0bf94fbceadc6398712c4bfb1f" },
    { "VOLATILE.WAD",       "2f0d77de413db63fc09cf7366b400c28" },
    { "VOLCANO.WAD",        "b5f9d9576563b5ebf61d418df63a0384" },
    { "VOLCANO2.WAD",       "514e94af67e74d19bc4f3ee60833fc18" },
    { "VOLT2.WAD",          "a311d02f61265f7f8ed548ec3c0a6c06" },
    { "VOLT3.WAD",          "facc64e7a621d4e873ec564679079a07" },
    { "VOLTAGE.WAD",        "2c8930f443c4c6e19c135a58b52d7110" },
    { "VOODOO.WAD",         "461176d75abca39b0a19817603d30339" },
    { "VORTEXDM.WAD",       "32b93695484c0900a8cf487879a171c6" },
    { "VORTPAK.WAD",        "656f44e090a944253161362d073b2467" },
    { "VOYAGE1.WAD",        "57aac35948193692e71f5009406435b4" },
    { "VOYAGER.WAD",        "66fac3a6e50f17b46fb4ed564531c37b" },
    { "VPACK.WAD",          "bbe97161d8b19e1bd44f034d6162e2cc" },
    { "VROOM.WAD",          "64655b026cad8f354880d91896d9ac99" },
    { "VS-1.WAD",           "c3033d077ffef97fefab16a16598967f" },
    { "VS2.WAD",            "2c3fc04187f72b49d6daf321d25c1b64" },
    { "VS3.WAD",            "726eace4120fb95e808c64c1edac1bd3" },
    { "W-TERROR.WAD",       "1d79f19c592c7efa654f5c44d8f6ddcf" },
    { "W7.WAD",             "0079952a75857b1f1ca935e922d4d693" },
    { "WAAHH31.WAD",        "83568269005e6d82402ca3c777aee510" },
    { "WACKER.WAD",         "1468aeb11406d5aa139c58de4e8a78db" },
    { "WACKY.WAD",          "f341b8b3bddc7c2a1e7eca83545d6aa9" },
    { "WAD04.WAD",          "04a5ea22dad83b983651e5e16addac40" },
    { "WAD1.WAD",           "06b71a1d53eec9319fd6dbda9891307f" },
    { "WADPACK.WAD",        "c76a998e7d5cb2b21fd6fa7ef4f91f64" },
    { "WAHWAH.WAD",         "ecb1245d0280fc2c696240fec449d868" },
    { "WALDO2.WAD",         "493c3715562f0d6cb52e5ec0847f71e1" },
    { "WALDORF.WAD",        "9cefbe4424422117aeee822c4ff31b38" },
    { "WALK.WAD",           "5977408f0b9eccd813b8cb1e62701b2a" },
    { "WALKNAME.WAD",       "96c16a0b0cc58d3491cb534cec9383ad" },
    { "WALLS.WAD",          "2df54ea9dd1a9c34134b7c2e44832ec8" },
    { "WALLS1.WAD",         "a9000322f035a586cee178eb7dbc6edf" },
    { "WALLS2.WAD",         "cd281c8b5059a3f646315925cbf686be" },
    { "WALTZ.WAD",          "ec19958eee8ddc97323c2870c1fcdf7c" },
    { "WANTON2.WAD",        "930ac3ffc5ed9e58d318defdba38c7b9" },
    { "WAOTD.WAD",          "215bb37574588daa88e4f0d03f22ab7b" },
    { "WAR.WAD",            "53a1221add1012a823125a1cc23cccd5" },
    { "WAR.WAD",            "9f71d3183550e43001795c01c4ed02c6" },
    { "WARCADE1.WAD",       "46038c9be389b22d7936380490fe9998" },
    { "WARCADE2.WAD",       "df2776999e31982a7cb3a56bfc96e31e" },
    { "WARCADE3.WAD",       "2dde276ce71fe79f131064bdb33c8122" },
    { "WARCADE4.WAD",       "8c170e3d54677cbca74fd357963b37f8" },
    { "WARCADE5.WAD",       "2269c3d7077af241dea1f514338a4c90" },
    { "WARCASTL.WAD",       "ac1674a21a6713acf0da0025e060864c" },
    { "WAREHOUS.WAD",       "e9c3b17e8bbf6c4265386f9812ba1531" },
    { "WARFIELD.WAD",       "37fd28e86ff44ad697d1add47d942442" },
    { "WARGAMES.WAD",       "89401d5d4867b3d8dda5605c1bc9670c" },
    { "WARGODS.WAD",        "96abbcc849332edf23d1f04038c1cbc6" },
    { "WARHAVEN.WAD",       "ec1bd08a230b9c44361b46e9c7602b6d" },
    { "WARHOUSE.WAD",       "9b9cf02e3cf4f14e1029313c7b453519" },
    { "WARLORD.WAD",        "d27410e0ccb0edcfb663f41f834e8a61" },
    { "WARM2.WAD",          "168ad8f2137c63ae4bc4020195e71da3" },
    { "WARP.WAD",           "332a56234aae6a32a34f6d6584cf75f4" },
    { "WARPED.WAD",         "a93577ec4021197d33cccdf22849def5" },
    { "WARTEST1.WAD",       "11f7df1bab8f3b583c8f944020e5763f" },
    { "WARTIME.WAD",        "6e8772cf7ed506d7da64a4793db372f2" },
    { "WARTOWR2.WAD",       "2d23ccda39cc2d092516e1d8a49a654a" },
    { "WARZONE.WAD",        "30d5ef6e2f99d7b01c08104a8e23a30e" },
    { "WASHMONU.WAD",       "c0093fcd0162e46f985b1539cbf91b37" },
    { "WASTE.WAD",          "754f0ff2324e8a81057662b2f91a9b4e" },
    { "WASTED.WAD",         "e276338f3e735f265834886ff77d8a99" },
    { "WASTEDIS.WAD",       "534fbf2a9cd4ffebcbc2e7d897add9cf" },
    { "WASTEME.WAD",        "c5cc5b6e1b01da3f858b8887d62293bc" },
    { "WASTE_P.WAD",        "223eedf17867b549d0dda111ff858c1d" },
    { "WATBOS.WAD",         "2e5b066aaeeaa854a7c809ef8f9f3786" },
    { "WATCHER.WAD",        "186d4fc3ec1f8c2190aa649a03ebf53e" },
    { "WATCHTWR.WAD",       "2b44550170579ffc98c8ba826207d16f" },
    { "WATER.WAD",          "16f8e4f39de54c6aa2f3188b57b362fa" },
    { "WATER.WAD",          "2ddfc05f4dbd21371de12c651e07c3b9" },
    { "WATERFAL.WAD",       "7329938c5f9691808692f1e025715219" },
    { "WATERFLD.WAD",       "f2263e9a26ad8c78648a029c6c4cc095" },
    { "WATERWKS.WAD",       "7ad44abc5221cd6ed865cfc606bd778a" },
    { "WATRFAC.WAD",        "3360756d138b60583397b990a59c1644" },
    { "WATRWORX.WAD",       "e1bcebedd06dde433ab17d7f6530e8d8" },
    { "WATRWRKS.WAD",       "6a3b40b56510b79c8c98f7852a5c6332" },
    { "WAVERLY.WAD",        "bc87e0b7dbd98bdee37be700bc8636d1" },
    { "WAX.WAD",            "5071dd42f976c2dd6e88ebb53a00ba65" },
    { "WAX2.WAD",           "dd091d4e5c835c077061d0a90234be59" },
    { "WAY2HELL.WAD",       "2cc09316ac0d3386eeffddd2fb66c7ae" },
    { "WAYBAC2.WAD",        "c627613e32a49d81ba7ac3378727b484" },
    { "WAYBACK.WAD",        "9d1e54c14b5ba6607a8a76d6955e732e" },
    { "WAYLAY.WAD",         "2c51b4f4ddb25fe56f58d612eec107eb" },
    { "WAZDM!.WAD",         "af7a65577481ff8a2de0bae943bf18f6" },
    { "WAZPLUS1.WAD",       "a850448f29b74a475d1ea4270043bb84" },
    { "WBGY_DM2.WAD",       "ec25a2db176ea63942f95e513c8cf5aa" },
    { "WEAGLE1.WAD",        "4ede26d4b74e3c365a1ebd5eefaaf81d" },
    { "WEAPFAC.WAD",        "b56e80bb8cce24febc71b16c9165aec4" },
    { "WEARAMI.WAD",        "1d1ee97dc64bb816b804fb333fcb4171" },
    { "WEB.WAD",            "004e639ee183731c8f4bbe3579f726f0" },
    { "WEEKEND.WAD",        "d09bf538e6e8e76bfed8e98e7a8611a2" },
    { "WEENIE.WAD",         "0b19d6e00c59a7434e5bedb0b4e2ee0e" },
    { "WELHELL.WAD",        "e7f1d73574e2f14213524e2dfd1ceb3a" },
    { "WELLSLAP.WAD",       "6ce262c83773f9f76c13295cffbe71f3" },
    { "WEST.WAD",           "10f29553e779d2f09c47404d47e32797" },
    { "WESTFORT.WAD",       "02e11bf4e1435740de7dec824a71d2e3" },
    { "WESTGRFX.WAD",       "bc95a11de79c9ba6450ffd1f7997e189" },
    { "WESTSND.WAD",        "e90745e03f2dc062a4e1ef923daf880c" },
    { "WETDEATH.WAD",       "325dee82c9997603736c2abd555f3bbb" },
    { "WETLANDS.WAD",       "c4fe19f2bed9d90e2b2ba3e3914b6432" },
    { "WETNWLD2.WAD",       "e33be9527a9de383082aacf404e5b672" },
    { "WETWRKD2.WAD",       "8aeb7cd78db5bd766397741c05cb71ae" },
    { "WEYHEY.WAD",         "8e3759831332159941e28463e576b874" },
    { "WG.WAD",             "fbc3b5bebff690dfd89f88b1a7194d82" },
    { "WHAT.WAD",           "03c5bfb5240f592311d9a2ff39bfc5b9" },
    { "WHEEL.WAD",          "aac696d444a22c820c610a5dd331b07d" },
    { "WHERE2.WAD",         "519af369793d7ff9169440c1878834ba" },
    { "WHIK.WAD",           "b98d89d1015f563bbfe271d84d6cbaf9" },
    { "WHIRL.WAD",          "e1e57ccd097c76a57eee859f03404680" },
    { "WHIRLRES.WAD",       "a3ee34e23941b31969bfcca455bdd00c" },
    { "WHITEPM.WAD",        "2e56b5c7af4664a604088f0b5b33faff" },
    { "WICKED.WAD",         "ac8a687d8721b2a9f3ee4afdb05d1655" },
    { "WICKED_1.WAD",       "0bcf6d1b3ce32dbf39bad52e2e1e12cd" },
    { "WICKED_2.WAD",       "9ed53715f2cf1eb94fb4404fe81d1e02" },
    { "WICKED_3.WAD",       "628f46aa8608b82d5d1cdbb8c26df17c" },
    { "WICKED_4.WAD",       "adc2d1a35e4c99c5a91486f0aeefbf18" },
    { "WICKED_5.WAD",       "a0ae9ead87046836a774c23c21482b33" },
    { "WICKED_6.WAD",       "1b9bbb3ea62f5374b52e90fc3493ec9c" },
    { "WICKED_7.WAD",       "11523a1548fa22fdd3347ed8df0255f3" },
    { "WICKED_8.WAD",       "24deeaf2500207ba60d33a1efcc02ed9" },
    { "WILDPACK.WAD",       "46e3478d46c3822cf7014efba8dabc0d" },
    { "WILDWRLD.WAD",       "109b71a7f0d01be96d30aeb299a4ac47" },
    { "WIMP1.WAD",          "9c3ece49f839e27cfe9c6bcc5e8a766b" },
    { "WIND.WAD",           "1434720b65d0aa8ca715ef4ab7642c2e" },
    { "WINDB.WAD",          "632cc9fd50787edd8c8eb9ca70daff2a" },
    { "WINDOWS.WAD",        "2c36c07cc243719ff7470cba2459df16" },
    { "WINDOWS1.WAD",       "aa61b9339c78a8424941afff669740b7" },
    { "WINDSOR.WAD",        "474e62996bf40be4cd0501b5f7811875" },
    { "WINGER.WAD",         "05b55ef9dea8621403ba98f108a5108c" },
    { "WINGS.WAD",          "55dff18c40c3bf8a2e67fd1ed3084aa3" },
    { "WINTERDM.WAD",       "3aaeda738af2ca3d712f9e611642b885" },
    { "WITHIN.WAD",         "c8a2a875e78aea1f63282c5a3278d1a6" },
    { "WITNESS2.WAD",       "3b50e40dbe7369d7052ab8735b822e36" },
    { "WIZDM201.WAD",       "369d4a8ecd23b147f8567c494b48e173" },
    { "WLKABOT2.WAD",       "dde6f050acebcc3b50a0980ee958ef41" },
    { "WOGAN.WAD",          "a2510f9ef691ce1ca57f81e6fb5abde7" },
    { "WOLF.WAD",           "6f5142d06749b4e2e9fc164bf1a027e1" },
    { "WOLFCHAR.WAD",       "7a015e36b098e6076d12b46c9bed13bf" },
    { "WOLFDM.WAD",         "8f82301c9cb2626a56f89e0bc727537c" },
    { "WOODBURN.WAD",       "339d7aea4e97263788137c04baa57f49" },
    { "WOODEN.WAD",         "771a34bf29b14e94a5ab248dc2be4cbf" },
    { "WOODEN2.WAD",        "5e38bca900415532127f12cad0c287fb" },
    { "WOODWAR.WAD",        "5750c3b34f8043685a7ce7c52aff99e9" },
    { "WOODWRK1.WAD",       "5dbb152384251d5725c35597b5192f5f" },
    { "WOODY.WAD",          "34146a77cb22f20e562b22d629df7f2a" },
    { "WOODY3.WAD",         "9a1ae76cab4763391e953ccdfbe041fc" },
    { "WOOF.WAD",           "59643c09815c962a2bd17e521cb735cf" },
    { "WOOLA.WAD",          "0c9283f6ad82ccce3a6f00d4bda1ebb4" },
    { "WOPHOM.WAD",         "9e6fe9be180910361ecf9ae7ff1df517" },
    { "WORK.WAD",           "3a50f2f00ddb476a7990956a76fc2e8f" },
    { "WORNPEAS.WAD",       "6b6a1469e81e01c4f95ad356fabad148" },
    { "WOW23.WAD",          "6d37746d30114501feabd42bb71784b5" },
    { "WPLANT.WAD",         "a40a0f5ab3a8ecc403b142420270d0e9" },
    { "WPUMP2.WAD",         "377f3c84f76da1ed3ea7eca73ca4a416" },
    { "WRAITH1.WAD",        "9a5e87a3407fe65552c10653f19f0220" },
    { "WRATH1.WAD",         "efc88ba8fa1d8c7eaf3cbf6f792d397b" },
    { "WRETCHED.WAD",       "7e36f03cbfafb77a9ff67b73d38eb189" },
    { "WROAD.WAD",          "087724fa196682dcc1b0b9a21d298788" },
    { "WRONGKEY.WAD",       "9196ed6c10fa4308a2e752e25b2f9c81" },
    { "WRPWRLD6.WAD",       "372d1772a7f29c715d805bde58b322d7" },
    { "WSARENA2.WAD",       "c87a2980c1e34380fd3f1ead9bdd7a05" },
    { "WSPRISN2.WAD",       "edb66182e60b91fa94e440436799f94a" },
    { "WSRUN.WAD",          "dc78ebc32ee80cc6a47b6759232602c9" },
    { "WSTOWER2.WAD",       "f653cfb37d9adfbb18eb467dbf0eb88b" },
    { "WTREAT.WAD",         "52be9d066ed808a3a59b4c09c5da5893" },
    { "WTRFRONT.WAD",       "fc4d50e6b4aed36aa3f2fbc999a0e475" },
    { "WT_MAIN.WAD",        "32cbff1b8aa1b30fe17023c6b595a638" },
    { "WT_SP-FT.WAD",       "7b060a818161ab236fde75846b868c0e" },
    { "WUDDA.WAD",          "b30aa3f5e53d4d260b73caaabb204d23" },
    { "WUPASS1.WAD",        "daa16f0f919b4d0891561410b3dfb5c0" },
    { "WW2.WAD",            "8431a14e1a6dc85e1e9b493452b05cc0" },
    { "WW2_01.WAD",         "b6c23e3dc272744b92ce8464c150b5f4" },
    { "WWCC.WAD",           "f251ff31b76c17e00464298997c4b67f" },
    { "WWCC_SND.WAD",       "9332ac811483018d9e7a96f788fc63fd" },
    { "WWFDOOM2.WAD",       "f309bc9bec1084ede874a399fed5dbcb" },
    { "WWHEEL.WAD",         "92885d897132fd49e0e6bb0126bb2f47" },
    { "WYB.WAD",            "4f9489146f0d48d7610a2df300b789fe" },
    { "WYTCH.WAD",          "66ac5f43f9e35eaad0817997d332a063" },
    { "X-DOVE.WAD",         "7446411ea5abb04620b2ff9b2b0984b0" },
    { "X2SNIPER.WAD",       "ee7d4a9bd145e8012cd9cf98795fd03b" },
    { "XAOS.WAD",           "3216e70167b4d3f7911847b2298cf5b9" },
    { "XARENA2.WAD",        "3a08ceed052a44c2eeaf184835dc7139" },
    { "XCAL1.WAD",          "ed48d6cf7beecc7e07c83d5af42951dd" },
    { "XCTF1_1.WAD",        "b3dc656d39dc0d0f477b167d62a8e59d" },
    { "XD700.WAD",          "447d8e90a5810328fbbaf4dc6078a14b" },
    { "XENOSX9.WAD",        "32b3176a9df3192e45e6fd82206d6d50" },
    { "XFIRE.WAD",          "d38ce705452c10b256b90181f6217073" },
    { "XMAS.WAD",           "55041f6fa67e566df4963d764042832a" },
    { "XMAS2.WAD",          "6cb036820d8f628ad02c23e2c827f3a7" },
    { "XMASDM98.WAD",       "9aa596576d2cb7ea064ed7b22bbc44c3" },
    { "XMASDM99.WAD",       "0a4413c2ed52cb86148f885698581fa9" },
    { "XMDMLT99.WAD",       "b26067c334b8fdf63a05491989dfc6e6" },
    { "XSPRT.WAD",          "2d01645382d541e2be46bd21c6aff43e" },
    { "XXX666.WAD",         "00a462d6f150ba5bc2de3a3d4b133a19" },
    { "XXXCITY.WAD",        "ea7a61d11caa130841ce44d0fff05cdf" },
    { "X_FILE.WAD",         "609b63af27af97995d7f54553be204d9" },
    { "YAA.WAD",            "a348d753945da155111199cd57d2c31d" },
    { "YAB.WAD",            "6668fe85f7b0fea562d4c0af4cafdb11" },
    { "YADMPWAD.WAD",       "960007ece7060d433d5b1411e9c2adc5" },
    { "YAOTZIN.WAD",        "6a2bf7067e38ec792f205a0c5b1148c5" },
    { "YAPPER1.WAD",        "0ac226a06931ad9282e5ad29b07efa76" },
    { "YARDZ.WAD",          "d3c1f84360a7559661be6fa16c29953b" },
    { "YARG.WAD",           "4f26b39641111ce7389219133178d63c" },
    { "YDHWB.WAD",          "01522e4ce6bb7cc9002f797de8515c81" },
    { "YEAHMAN.WAD",        "7f11529cecfa749f6f79fe8cb0be3fdb" },
    { "YEEHAW.WAD",         "3ccc87635fc7a6fd7aefb407f544eec2" },
    { "YELOWKEY.WAD",       "434e3db5c691dfc7352f3aa7664c71f6" },
    { "YERDEATH.WAD",       "9d9665c68a8dd52b5e4ee31076a3cf10" },
    { "YESTRDAY.WAD",       "bfa3468b4ba8b1e8eef5864c12c23810" },
    { "YFDM01.WAD",         "1a8b4ffa747d8cc6d2a4255984109b57" },
    { "YGH1.WAD",           "10692abaab8ae46de968ef1c484aefd2" },
    { "YIKES2.WAD",         "1b4d85b5c9d39bbd78b2083d68125ad5" },
    { "YMCA.WAD",           "a9805625ac8cc3e300aa58c9ccde0da1" },
    { "YNGVE1_2.WAD",       "5ea521deed1cc9d8a66c63831b21bab9" },
    { "YNGVE2_2.WAD",       "9fe15498c9daee4b1dd255210a38dce5" },
    { "YOURDEAD.WAD",       "47e1872bb108c9a7e468c1ab59ea31db" },
    { "YOURFUKD.WAD",       "b340b26403ea9a4bbe0dff486165eb77" },
    { "YRSTICK.WAD",        "d0ff041d28eb15f4bcc0650ef00c5b29" },
    { "ZAK1.WAD",           "89f4a76a5cbacf893ee65f59b1533c9a" },
    { "ZANDOR2.WAD",        "f42ee1001d3457c450c4b538a91d4b8e" },
    { "ZAP07.WAD",          "58bac63f10a57cea6f11e9ba4277793e" },
    { "ZAP18.WAD",          "d29a9899ebc45146e24a06033816d7c3" },
    { "ZAP28.WAD",          "c99cdcfe436a3b465d127ad5233a79c2" },
    { "ZAP30.WAD",          "d6875c772aa648004573a6fe4390dd9d" },
    { "ZAPNRUN2.WAD",       "6ef038c259f8894d97034e7c4ae747be" },
    { "ZAR.WAD",            "45893ff1bb2f125a7b0b32ba3e1fcd67" },
    { "ZAZZY.WAD",          "51bca894cb41edf8ffddbf1a9fb77a78" },
    { "ZBOAT4.WAD",         "ad58719c7a9af770efe3681fa3909d32" },
    { "ZCIRCLDM.WAD",       "40b8bf102ef2655dc0fe461e34beadc0" },
    { "ZCON_Z0R.WAD",       "97ef2722e83b0be8328d8b3a18e7242f" },
    { "ZDCTFMP.WAD",        "e739adb34bef310311bbb50d6711646b" },
    { "ZDCTFMP2.WAD",       "3359d1560874812fabd41fd9619b1dc7" },
    { "ZDCTFMP3-.WAD",      "68300bc9fcf6f124b618a069a5d6911b" },
    { "ZEALOT.WAD",         "15328228e6e5224018ad8fd566889209" },
    { "ZED-BIG1.WAD",       "e0ec289f74b94ff71c43658cafd15c7f" },
    { "ZEH.WAD",            "8a7665de1c1e5b4f62ab55cfd11f9f6f" },
    { "ZELDA.WAD",          "9197deb93b142a0348e30a49e84a9a54" },
    { "ZEO.WAD",            "25868c9c487e27039c859007b7d78210" },
    { "ZEPPLIN.WAD",        "bde3e80013a8ea0fe72f20505dbf8598" },
    { "ZER0.WAD",           "c83d32d302eafb3a83849a951db8cf44" },
    { "ZERT.WAD",           "eec19e34d7df068d1efa092cf4e21d51" },
    { "ZERT2.WAD",          "1af5118345d3d164bbbfcffcba287807" },
    { "ZESTFUL.WAD",        "6599ef1867e2dc28d6bb2216639ca55d" },
    { "ZEURK.WAD",          "a634117f3035901d68c8093a46e11cbc" },
    { "ZEURKC.WAD",         "722810a0186aee0c58ffd17adbda271c" },
    { "ZIGGURAT.WAD",       "f5fda68d80af8beb497024b0a8b463ac" },
    { "ZIMMER.WAD",         "6a4bd90b89be506a7d151639b7a2f661" },
    { "ZIPPIE.WAD",         "1e8d13ee2438e7a9d475f1d80708bfce" },
    { "ZIRP.WAD",           "777b98f7a219dee4b0c37902ee7e93e2" },
    { "ZMANPAK1.WAD",       "6a64550d19be20a1424c949b69b49937" },
    { "ZOA2.WAD",           "039202efda4cf423f203cd2d4a582e59" },
    { "ZODIAC2E.WAD",       "5f812dfddbf7fbf7affa0d43fdc9fe9b" },
    { "ZODIACDM.WAD",       "fa6b4202982baa95db08317b150e264d" },
    { "ZOMBIE.WAD",         "8e6316489db78c6f273b1631a6080ee9" },
    { "ZOMBIE1.WAD",        "f703b0b17837237fa549d9ca34ed5c39" },
    { "ZONE2-X.WAD",        "60538c6e25c4e418297a26c0d3f3dea2" },
    { "ZONE666.WAD",        "d5724fe487915b930ea98e24b2a71b65" },
    { "ZONEHELL.WAD",       "6f37ec68bdebff9995b79a3dcbc4d01b" },
    { "ZONES.WAD",          "0a4ab2f32819b42c92c119be23b681c6" },
    { "ZONESND.WAD",        "b0459dd7b30edb5f9c2c1c06ecaf2b1c" },
    { "ZOO.WAD",            "c48160d83f6526ae7c4b960411dadd1c" },
    { "ZORK.WAD",           "98d7631bcdf6d76a9545590b49a8b275" },
    { "ZORRY.WAD",          "1a7ed852b5db4d4fe191f1e86acc1d3a" },
    { "ZSPINCOL.WAD",       "417cc334dc32654528d47dc9e7497d62" },
    { "ZULU.WAD",           "7250f3241453f74d0062bec95d3e85a9" },
    { "ZUMA01.WAD",         "253dc1196661cf2b99a7dd7a25d1de80" },
    { "ZWIEBACK.WAD",       "08d2c4eccacc0b43a0d89e9dbbc68ec0" },
    { "ZZZ.WAD",            "bec510e43aa7acacc3b8a47a0185bf78" },
    { "__STIANS.WAD",       "623b775b1da169b6c1237b0044c58e82" },

        // HERETIC

    { "!TSTONE1.WAD",       "bd111be314f9485fa47c18dcef8cb620" },
    { "4-ACES2.WAD",        "46c689b496d68017209f73861ca8c1fd" },
    { "4HEXENSD.WAD",       "a46d7d2ae5037e2c96738c0c0c883c7a" },
    { "4HEXENSP.WAD",       "c4851cae8937be2aae8b282aec865185" },
    { "666TOWN.WAD",        "dfee21d9d125d4d8b3dffd11d283380c" },
    { "7THSIGN2.WAD",       "732dcdca46ed072ba98716eef9132ca8" },
    { "AB-TEAM.WAD",        "8db20b6b37d9c35154264aed655328ac" },
    { "ABBEY3.WAD",         "db68eebfc2b073e3f84c6a742ebb675a" },
    { "AGLOVANE.WAD",       "abe9d6e194dfc08d695eaf57fe39fe4d" },
    { "ALOHA.WAD",          "e16127ea7d94a825d35ca1f357fa6676" },
    { "ARENA31.WAD",        "d2b2e02a09eb357e67fc5647f6134334" },
    { "ASCENT.WAD",         "ffd7ba3f6ef99e6f153dffe62af715e2" },
    { "ASTERIEL.WAD",       "0a1a5031b13b69421c3d27c4edb31e7b" },
    { "ATLANTIS.WAD",       "ce0973368a9bccf38644d75c97884f73" },
    { "AVATAR.WAD",         "341f262bf7fb4e42b9c7d8f0c8156db2" },
    { "AXES4.WAD",          "3a3824b4b7ef6c980f9371a94a3e7136" },
    { "AZTEC.WAD",          "ccd3e55b877f6a58a6c9f85417bd03a6" },
    { "BABHTDM.WAD",        "427373e239f9750abbe557af7f4b9ecf" },
    { "BALLS.WAD",          "7bef62042237cace571411a5c1599514" },
    { "BARTMAN2.WAD",       "7cd8d3d958ce96e6463bc39853309cfa" },
    { "BARTMAN3.WAD",       "633ff3fb325b46f559362c3ff5ff7e6a" },
    { "BARTMAN4.WAD",       "1613f64139856198e6cd3e4d777dd3c8" },
    { "BARTMAN5.WAD",       "848a7e3cd6a0f1a791dab89b6218d898" },
    { "BARTMAN6.WAD",       "4e9a9b5c11f56d87f5e110bbe4c5e56e" },
    { "BARTMAN7.WAD",       "04f909a3552fabe5747effbe69e9872c" },
    { "BARTMAN8.WAD",       "f0c30c7932a4aea5f501f20926835704" },
    { "BARTMAN9.WAD",       "7bf34d7863f8fc1b972df9084987c6a2" },
    { "BARTMN10.WAD",       "638a581fa54f2db72579b284f744674f" },
    { "BARTMN11.WAD",       "2639becf0c3ed5c36011adf3d7d35dbc" },
    { "BARTMN15.WAD",       "f32f33bc192034b0947c3b4f9e75e559" },
    { "BARTMN16.WAD",       "37d2d76de407de565a5df7afabfa943a" },
    { "BASCO00.WAD",        "47873ddb4beab5e4a0203bf4a96f0c37" },
    { "BECAREFL.WAD",       "389c59cbb69a2ddb0f42e0baa647ee02" },
    { "BIGRED12.WAD",       "12a7edd8f101b23b0b88ddb5fa295ba6" },
    { "BILL2H.WAD",         "58d26244068a57844f8a11b4a0e12616" },
    { "BULLIES.WAD",        "a42146017701b2b5d7f0d33a3ce92042" },
    { "BURIALGR.WAD",       "5c1671b27c9f942986007fec20f26249" },
    { "CASAH.WAD",          "e38c69b0f45662e2f7ec36f49448ad79" },
    { "CASTLE.WAD",         "7f748e0d759c871f1948eac9d87402ac" },
    { "CEMETARY.WAD",       "6d1e8d5dfee0cec8e1811b0d0b4e522b" },
    { "CHAOSDM.WAD",        "57daf71a840e105cb22c7ecf8c263c6c" },
    { "CHAOSIAN.WAD",       "e5f40e0db2055d420d82004f6f5ccbfb" },
    { "CHICK.WAD",          "41ecb8a6113f16203622ecc9e5751a08" },
    { "CHUBBY.WAD",         "f71434067c14b7ab656f16cda5da2dc4" },
    { "CIST-II.WAD",        "d35b2e450894325083359ef441cb1d8a" },
    { "CLAWS.WAD",          "19193c0f8919b5438966b4880b3c8522" },
    { "COLD10.WAD",         "8d2b846b7a471f611d33d785810ec7ea" },
    { "COLD20.WAD",         "a8ef0f8cd12574001c0f73ee02203840" },
    { "COLD40.WAD",         "fbb49d4339d560493f1803d05271db7c" },
    { "COOKIES.WAD",        "092e8b4ad8baa184c112d99da89fd403" },
    { "CRYPTS.WAD",         "660aec2a96d72f4f0b615b6a58b1cabb" },
    { "CSTLIRES.WAD",       "57b7900e4f255d7ace4ca64809036e6a" },
    { "CWOLF1.WAD",         "8d4969b81c13a66472761cef14044550" },
    { "CWOLFHTC.WAD",       "f6970e55bd7f083eb8deba74fea31398" },
    { "DARKDAY.WAD",        "281162344c36fbe6051f8566fe88aa2b" },
    { "DARKFALL.WAD",       "8078957ec6c190074ce04ab7d17044eb" },
    { "DARKMTN.WAD",        "235526dbe4627997ac72b5ae1f82cac9" },
    { "DARKMTN2.WAD",       "c2395cbc57f7632c2d19fbd2fe36af95" },
    { "DB_TAC.WAD",         "99f5dfa9f12905622daac45264eecb77" },
    { "DDMM.WAD",           "f63433121df46c2a4740d3bd5ed240e9" },
    { "DEATHI.WAD",         "0f8904c7fff7e5a4907dfb540adbecec" },
    { "DESCRYPT.WAD",       "c845031c9774f2ed1ea8e3abd37dc260" },
    { "DESTRUCT.WAD",       "3d5ef305121f555c196e32f9fd0f432f" },
    { "DETHKASM.WAD",       "baf5049e0b7cb5b2c42c3f092b9d7660" },
    { "DFORT.WAD",          "b373e671a4120cecd44af07550206c50" },
    { "DHSPD01.WAD",        "99b4c5ff673167f09afc3b6f01f625b8" },
    { "DIABOLIC.WAD",       "a9e938dea2878c4da8e48b471ffe0191" },
    { "DIEYOUNG.WAD",       "edcef67b37139551662d86294e3bb31c" },
    { "DLKEEP.WAD",         "95c95164ea7118f7d197ce1a9bf6b812" },
    { "DMATCH.WAD",         "9541df649c0a29880be4198f2276e3cf" },
    { "DMCHASE.WAD",        "2615d81531fd76edb5d13f5f19bccc28" },
    { "DOA.WAD",            "b7e2961e98f23be2629b89f16ac67af9" },
    { "DOZOD_HT.WAD",       "4289ee61b98920a90d818eddc4c8ff99" },
    { "DREAMSOH.WAD",       "e4b53a5b9c08110952c6e5466cc123aa" },
    { "DROME.WAD",          "d262537b2fbd14e0506952fc760a07d6" },
    { "DROP-IN.WAD",        "7089f1fa23f8973d63e35982e138e834" },
    { "E1M1-3.WAD",         "9f96e2acaa3e22a4368b29d207aaf42f" },
    { "EATDUSD.WAD",        "177c8d81fae362823daa29bbcc7af70b" },
    { "EATDUST.WAD",        "0ffd0099646fb0fe55894cf254a04846" },
    { "EIDOLON.WAD",        "f9c4b0f037167f3a8e8e9d16c8d4eb3e" },
    { "ELEMENTS.WAD",       "78da677e4b142ff7d9e558ee3bba10e9" },
    { "ENCHANTR.WAD",       "8bffb9a98528f228a73049e607317b76" },
    { "EXORCIST.WAD",       "45b607608c8ae1278f2dbe55f8f362e7" },
    { "FADEAWAY.WAD",       "8362550a17525fd12ac73ec3cb0e5109" },
    { "FASTFART.WAD",       "c10b91bd0181925e1da01b1274d3c889" },
    { "FETAL2.WAD",         "5d32680c20ea37a832129b750db4c03a" },
    { "FINALH.WAD",         "f7e968aeefa08e073a37b65335eafeab" },
    { "FIRECRAT.WAD",       "d7aa3e26df236fc422a2d0e65e426ef0" },
    { "FIREDSC.WAD",        "a1b89d774c805567e548ec1edd517b48" },
    { "FLENZER2.WAD",       "d0a4b0e6a3d55ac4d40009f47e12b05d" },
    { "FLIGHT.WAD",         "5af29eaf5afa501c61ac7023de3e4a20" },
    { "FOOG.WAD",           "5a2603e5d137a17275da8298aa6ffb77" },
    { "FORTLAV2.WAD",       "8e4317a41782c10a111b3f52997bbecb" },
    { "FRAGS96.WAD",        "f8462c05e7217c461bbc59629f7a0587" },
    { "FRO_D2.WAD",         "12b9679b3b4424167bf789846c2e1899" },
    { "FRO_HTIC.WAD",       "c5d979220c959cb6a715b0aa9fd5f7c1" },
    { "FU_CAST.WAD",        "59170235203a13f2d2ceaf3120329e1d" },
    { "GATES.WAD",          "87bc03ca264f5ddc07ac869a73aa13e9" },
    { "GLADATOR.WAD",       "659b7ff4502377fee9904ce2a8e17d03" },
    { "GLADIATR.WAD",       "1c8d4aec910e4d82db69b07f5ec52660" },
    { "GLADNS.WAD",         "a7c776cdca8d01c8b4331bd03eae8e1e" },
    { "GRANITE.WAD",        "0933d5c685e317fca3501c5968064abe" },
    { "GRAVECVE.WAD",       "9586c2e08d10d1efb0fb6b8c8f929db7" },
    { "GRCIH1.WAD",         "ab67979909477d924e6d26af2f3ea16e" },
    { "GROK-IT.WAD",        "3ae1ef7e2369f588f9839428fbd61154" },
    { "GULAG.WAD",          "4be273d893a79fbd96f54b2e6bf1cb5f" },
    { "GULAGGRF.WAD",       "5f3a1c4a891d0f9bdb20cd5df6d38c8c" },
    { "GURUDOME.WAD",       "633500a6d4a714ebbaed470cdcb3770d" },
    { "H-BALLS.WAD",        "20009c024a08dd4c658c2d479ee76721" },
    { "HAHEHIHO.WAD",       "46c85747b926268fe02132a76597f8eb" },
    { "HARDROCK.WAD",       "ad4ceade5eda7d0d4baee54d8db45cb8" },
    { "HARENA.WAD",         "83a3c0641b2931e5ae5fe1b062d14a10" },
    { "HBLOOD.WAD",         "c2260c0cb471dfaf4650e86ed01b9ccd" },
    { "HBUILDK.WAD",        "0cef9ee00d4d4b736865128656e78981" },
    { "HCARENA1.WAD",       "c0b6aaa7d144866d952dbf9ccbcfc5ee" },
    { "HCASTLE.WAD",        "2cad3468d3ca5ed36db59309ba899ce7" },
    { "HCHURCH.WAD",        "c6edd2d9dcfca0f0d2afa271bc6c4d04" },
    { "HCITADEL.WAD",       "104fd14d0d2e96b1de15c0779d2a3d40" },
    { "HCLRDANG.WAD",       "3db4d51d59086d2405a24ef8ea9e1ee1" },
    { "HCRTYARD.WAD",       "c9099d608e700a0f9a4fc8491fcc8f88" },
    { "HDLB.WAD",           "4c9ed862d120495e746b30f9278510ac" },
    { "HDM.WAD",            "ce42220abee99cc0e108c916a35e8b89" },
    { "HDORK.WAD",          "8a41314f0b566a359d8fc7746e52ce48" },
    { "HDUNG1.WAD",         "948b2e1f703ce06a9f76bb4fb115550e" },
    { "HEADYRAM.WAD",       "7622203ca0cc0f16c5ed0cf96c1a7bf0" },
    { "HEATHEN.WAD",        "4d6941edc90975cc4e8b4fb246e06d32" },
    { "HEINOUS.WAD",        "ea88e426bb80ab3de891325d3b64b57c" },
    { "HELL2.WAD",          "bacf12a984adda26136a884eb56231c9" },
    { "HELLMAW2.WAD",       "bacf12a984adda26136a884eb56231c9" },
    { "HELLPIT.WAD",        "5432b483172c4f0820c9b95ab25ca73c" },
    { "HELSHALL.WAD",       "356a4a719628be8bb5af8d3553f45d06" },
    { "HERARENA.WAD",       "3c99dbcd834723ab3cc621df14211253" },
    { "HEREDANZ.WAD",       "51eecb0b8f9c77173c3a3dcbcdeb2d6c" },
    { "HEREKEWL.WAD",       "751de2129095fbb19553ce973e0e9832" },
    { "HERETECH.WAD",       "36ed57cbad7c4f77e7b221b9f754f998" },
    { "HERHOUSE.WAD",       "43dda8c40aeb19f810d8b173b6739adf" },
    { "HERPIT.WAD",         "bf43c96d71df12dd7d846237132507a4" },
    { "HERSNI02.WAD",       "739b84e89aba0a804eb92866df14622c" },
    { "HER_DUEL.WAD",       "89abe2d176d88db9d26e365c58a910da" },
    { "HEWETIC.WAD",        "3fb735ba956bbd68b044fb450d516a9b" },
    { "HGRENDEL.WAD",       "303c10aacef642bd26e3e3b42b0f89e0" },
    { "HITCH.WAD",          "f43686055b03f0fe7fc1d2ec72cb2116" },
    { "HKHAZD11.WAD",       "14eaad1e07b99b005c4797cdc9a24064" },
    { "HMAIN.WAD",          "f64981c6b1a6e305bb48055b2fb07108" },
    { "HMARKRM.WAD",        "cc2a851d0989f92c72321e656439c63f" },
    { "HOC.WAD",            "8bf78cb517c1363cfec9889ea7623e04" },
    { "HOC2.WAD",           "cfd78cb4f6f0360e7741a2f31ae919a0" },
    { "HOC3.WAD",           "c001640c21448d3a44287fd937e0b3ef" },
    { "HOCX.WAD",           "889ec9170a1c37c59a61b37c8e33c4ba" },
    { "HOF.WAD",            "03c8735f5e2c44337c224bd0bf18e53d" },
    { "HOMELAND.WAD",       "70c9f127a409f710bf63654470535291" },
    { "HORROR.WAD",         "72f789bee1933e42f5eb9bb17437aff0" },
    { "HPOM.WAD",           "8a057bf00af924c7ffbaa89d75be01fd" },
    { "HRCAVE.WAD",         "1e289677f8ac7be08821d6219a0fb6ec" },
    { "HREDRAT.WAD",        "1bfa0acc7d7fae382f6641241231d336" },
    { "HRMORE1.WAD",        "057be6ae82769555bf44e0b7216c4f08" },
    { "HRT_UN.WAD",         "39b18e2e4d1518df91c85eb88d19853e" },
    { "HSEWERS.WAD",        "5598fad8b50e86e43b29043f21f67cd3" },
    { "HSKULL1.WAD",        "a48a9bbac84841103dcdee245092a24e" },
    { "HTCCHICK.WAD",       "47da35adf1d362c66cc7e26901f85fa2" },
    { "HTDC_RF3.WAD",       "2f3c2a3336d5c82020eeb82b04b0f6e9" },
    { "HTLZRSTM.WAD",       "6d871f5e33a6624b686eaaf829688ac6" },
    { "HTRILOGY.WAD",       "7d5c1122b30453275907ab9f136dc34e" },
    { "HT_CTHDR.WAD",       "c9fa0111dc918a1da90f0bab4f726953" },
    { "HT_FRAG.WAD",        "61ad37f6a8f8f7eae84e74d57958dc67" },
    { "HUNTED.WAD",         "3ab644bc641f790d2f03268164c0cc7b" },
    { "HUNTER.WAD",         "bfa51c48302e2417c3959dd8ff3ea36c" },
    { "HWH.WAD",            "689235514150bd6dd6ed3e3ae58da901" },
    { "HWHITE2.WAD",        "c99322d7dbb8e40c863c18bf90327357" },
    { "HWHW.WAD",           "87ec576824877236360c6fb00eaf767b" },
    { "HWIZRAGE.WAD",       "f4a8b5857b211fd788dc3f9a2cc9b71b" },
    { "H_ALS5.WAD",         "38dd12ab7df096396fac9135018fbba3" },
    { "H_DM1.WAD",          "7628c89ba9acb0354883a69ba35f29a0" },
    { "H_PDATA1.WAD",       "d4dd2d1bf619519a5c049925add04050" },
    { "ICHOR.WAD",          "00f4512d01279e6980102625e8c6836c" },
    { "ICU.WAD",            "1ea572507bcd1e9df4fe8de9ef7dd999" },
    { "INCUBUS.WAD",        "d5c72a9d2015db6276d2d2aaadd8b72a" },
    { "INYF_HRT.WAD",       "b44872ba77656cf0d7caa1819233c1e3" },
    { "IRVEL.WAD",          "0e51b936e90d0ff50ef8a9495e348793" },
    { "JASANAND.WAD",       "5ea57cf87d91996f51ecd1c4f30cffeb" },
    { "KALHTIC1.WAD",       "bcf61c785e67cd5b88b5d76c27aafb46" },
    { "KASS_HRT.WAD",       "ca5559983d502555b5e1221314de396c" },
    { "KILLALL.WAD",        "db9f55e854e08a2063ec3d21b52d2c83" },
    { "KING.WAD",           "f0b192e48481a054621e7813b9a2c981" },
    { "KNT_KEEP.WAD",       "72aa9a1bbb60a8b0c24e5de9c360e323" },
    { "KYOPI1B.WAD",        "3edfa41d4e9e542b6ab2f7899435fdfc" },
    { "LAMEHERE.WAD",       "8db27a2b6a7ecb792eb7c4da422163bf" },
    { "LAVALORD.WAD",       "355a486c8bd99ae9a56025a2126a3877" },
    { "LAVAPIT.WAD",        "b2fd9d682629432ccc312e92a66b3fef" },
    { "LAZ-HD21.WAD",       "85baebb8dfeaf1268174a76a4ad73809" },
    { "LEDGES-H.WAD",       "f336e4f25d4c70ee340c672043af21d3" },
    { "LHET400.WAD",        "ecd6882e7e699a283f0f35842d92efee" },
    { "MALICE.WAD",         "599f59c9cdffdca4e75e73a2e8d99d35" },
    { "MAX.WAD",            "96f2cb518ef7ef6ea7ee0c25f7ee904a" },
    { "MAYBE1.WAD",         "8c57933075b02278cfdcb819c67b55f5" },
    { "MDOMAIN1.WAD",       "f2003baea6777d556c4f58f3f516ac56" },
    { "MERIDIAN.WAD",       "1091b55c7f28d685b9ba4f59ffa1e097" },
    { "MIDIEVAL.WAD",       "4eaec824232d5c19711291fb3b7ba4ef" },
    { "MINURAMO.WAD",       "e8db7f0e98bdf2ef65772a452937467b" },
    { "MK1.WAD",            "f6e58656c1594ee5b1ee06cf83d4ab6f" },
    { "MK2.WAD",            "df6d0ff0a05314990060a4fc7aaa3f0e" },
    { "MK3.WAD",            "a54f52e8ad8dbed6f49ea4aeb6cee42c" },
    { "MOJO.WAD",           "ffd0fee2d86f934ce82a50d7da441fc4" },
    { "MOLTENHE.WAD",       "25b524409106c44fd2892bf3d9035efa" },
    { "MUSIC.WAD",          "3ce9fe150d7c2a9deabe7e202663bcc1" },
    { "MYSTKEEP.WAD",       "a9de1c8cfcac536976d69a4e460e4cb8" },
    { "NEWFLATS.WAD",       "c3ef1b80523a71a18aca45cb387a8355" },
    { "NICE.WAD",           "70f5a2f96efe9ed3e5abc5778e1bc4d6" },
    { "NICHES.WAD",         "c4f4ca67b03cebdfa1fecd6099ad9428" },
    { "NITEMARE.WAD",       "b4c8ed2b2e6d12e11898c5a19100b2fe" },
    { "NJHTHIEF.WAD",       "9a8be900772e0dabf4de04a140ad0f55" },
    { "OCTA.WAD",           "53a7595796ead1e391eec8e936a0b30e" },
    { "OCTAVIA.WAD",        "b03ae8e1533bc1a924ff5b94a4b39530" },
    { "OCTO.WAD",           "a82dcade5f4d97b6e0009725cb1f83be" },
    { "OH-NO.WAD",          "6f8b357cee7a940e7f55d719e7a789c9" },
    { "OMEGA_H.WAD",        "4707f17c54762f86e65b5b76d5a2ddf8" },
    { "ORBQUEST.WAD",       "b654923bac3e7ce1b070121c6c51357e" },
    { "OUAPOOL.WAD",        "f4fc2f36b8efcdddfd22f8e4bcaae078" },
    { "OUTPOST.WAD",        "589198aeaed4845d213c263daaf4af65" },
    { "PARR.WAD",           "8a800476fc5638fc3e03e1779335a3df" },
    { "PAWN.WAD",           "951ef8ae5155b5442a055a2b3bc437f4" },
    { "PC_HERT1.WAD",       "317acb581105c22aadd05c70af2edce7" },
    { "PDDM3.WAD",          "0964f22ecb3dc92fae9484c00dd726fa" },
    { "PIAZZA.WAD",         "c91caef8da0c08e3ff0370b3d4f0ca7a" },
    { "PITOFREE.WAD",       "2f880eca12b0befc22628deb6b36cc79" },
    { "PKBO_HRT.WAD",       "4a5e3252ac45e151f8f45a5b7e1a9fa7" },
    { "PLANETX.WAD",        "66f9a436032d424e8ee0cb62635c6eaf" },
    { "POOL.WAD",           "dd88bf19633f0576fc507c1f90fa7021" },
    { "PORTALS.WAD",        "b7d7ac2922cd24c213929188945c2ba0" },
    { "PROVING.WAD",        "7d1be51acf72c736efb002e8dc57b339" },
    { "PURPDTH1.WAD",       "6c2cf668154ab7a22446867781eeb479" },
    { "PURPDTH2.WAD",       "84637141695efebb542c5a24543de0a8" },
    { "PURPDTH3.WAD",       "b01725845e7d7ec7aea6591b20e55c65" },
    { "PURPDTH4.WAD",       "9c61aa8897857f7a5c12133ebaee9372" },
    { "PUZZLE.WAD",         "02deaf42d804aadfad907d948a36bdf6" },
    { "QUAD_HRT.WAD",       "8cb1ad55f1df902dd6ae75787ec0136d" },
    { "QUAKE-H.WAD",        "75c325ff5309141c99ad124a66e3a233" },
    { "QUARIX2.WAD",        "7f4122c503b2957a1caa40836fdccd26" },
    { "QUARIXD2.WAD",       "ae7c8e0e186b63cfcca171fad4c9acf4" },
    { "QUEST.WAD",          "e13799419b2e401bd45f4e3c1b1e9571" },
    { "QUICKIE.WAD",        "2f00867675ce137a308740d56427f899" },
    { "RECANT11.WAD",       "5440ac4dde2eef274c7049e0b1bfd2cd" },
    { "RECLAIM.WAD",        "07b8fc9f35237c5c2596b15d49be7932" },
    { "REDKEY.WAD",         "c3c74ecbe5a6f01c6adbbb3840a29082" },
    { "REMOTE.WAD",         "ed5621471c8bb05b44880992725f46fe" },
    { "RESVDOGS.WAD",       "edf7bc926e5c9a7832b5836c83529451" },
    { "REVENGE2.WAD",       "8ea02c31c2a3f61e01cd021c6ccf7adc" },
    { "RIVERF.WAD",         "6b62bc6f031530d6c49369918ecf2a13" },
    { "RIVERUN.WAD",        "ce4eadd52e4a1a5c3bd77341192b5ac9" },
    { "ROBBIEH.WAD",        "66a517c6f645010db1dbfa9304346818" },
    { "ROOMS3.WAD",         "e514a54050feb94b512f0d2863ec5231" },
    { "ROUND.WAD",          "2760dd77653be94d0f8aa492736949ab" },
    { "RUBIK.WAD",          "a4be4f3ea7fad11f1768d5f6c2b3c43a" },
    { "S2NBEGIN.WAD",       "930f3ce4a1efdf03786a7b9e194a18d6" },
    { "SACRED.WAD",         "22e6f6e144c6ba8f7feb0e12de69fff7" },
    { "SANCTUM.WAD",        "376152141b665e275d5eadf1a5573a9f" },
    { "SATAN_01.WAD",       "d6023be752c91cbbf6298d6b54241e67" },
    { "SCRAMBLE.WAD",       "7bb46b06f4cdb15bf6e73f975c4c152a" },
    { "SEVEN.WAD",          "f51bdda6d2c76f2d99e3d6aeb6a1bf88" },
    { "SEWERS.WAD",         "b63af4d9c79d9dd8221312ac398d4128" },
    { "SHADOW.WAD",         "544c2b6f32403d6d5ad0d86579b8ad28" },
    { "SHFOREST.WAD",       "d81d01302bffe3ea19595be8fb6f740d" },
    { "SHRINE.WAD",         "5a40352642f2ad0ea055c6d50d0f0361" },
    { "SINFUL.WAD",         "ad5d4a2942a4261b9f5f10c0532565a1" },
    { "SLUGFEST.WAD",       "94e1dca267891e9324c2f4ef4bb93c80" },
    { "SLUNT.WAD",          "2361dbdad876792a85e7f96793ad17a3" },
    { "SMKHDM.WAD",         "eb97d46094035fd1801bbaca1ff75fa9" },
    { "SMUDGE.WAD",         "46a705f7956fd7cdfa0d0265b406c867" },
    { "SNIPERS.WAD",        "5c057bb84ef0644cdd882041070e5138" },
    { "SOUNDS.WAD",         "cf925c10da965d0df54d7323abd55d2a" },
    { "SPRITES.WAD",        "9de28c233511d866ea47b0b9a1570d28" },
    { "SRHDM1.WAD",         "a23c74578e5fbd7149c18586230a1cef" },
    { "STAUFH.WAD",         "50afd8d5427abab77639e5907e9326f5" },
    { "STCHASE.WAD",        "9a753d9b33e83ffce65e271a303b1f8d" },
    { "STEALTH2.WAD",       "86c20205cd4e57ac232e6946c04a7294" },
    { "STEEPLE.WAD",        "5b48fa35d6cdaa2b1043005f868a6e81" },
    { "STONHENJ.WAD",       "2ccce5e9626ef65315e0d1697619996a" },
    { "STUDIES.WAD",        "7a9a2f6bcfee55ea437fe5a35056bd24" },
    { "SUBRIVER.WAD",       "5ce8a3c7efdbe5c00cdb3dc2aef7911e" },
    { "SUPERMAN.WAD",       "6c535dd36ebd7a59078973bb24e1fb04" },
    { "SUPPLIES.WAD",       "b3dd3bf1cafbed049845458a0c6653b9" },
    { "SYM.WAD",            "a80461475ce81138c88967623fdf35f0" },
    { "TANASH2.WAD",        "16aedec77af2340beff739c8937024cc" },
    { "TCWATR1.WAD",        "3f9b2719a542a299d5e797c0ca1e6270" },
    { "TEMPLE.WAD",         "386c0e614913d5acb4a7cdd946827833" },
    { "THARK2.WAD",         "04aad6a0c98bcb1761163b79629d8bf0" },
    { "THEDARK.WAD",        "963f303f2e34f215353798d2117ca2f9" },
    { "THEHDM.WAD",         "0f50739ad3ac5b2dfbd118a0e70b8b23" },
    { "THEKEEP.WAD",        "50c855cb0b883957a1072778901238df" },
    { "THE_HUNT.WAD",       "cb22310672c403a332df0108be8b09b4" },
    { "THE_INN.WAD",        "e3c4fd057fe2549707bbb45531fef2bb" },
    { "THINGY.WAD",         "2d5c1493d5d223c97af6d80882c6372e" },
    { "TIMEZONL.WAD",       "131f110f0662041f1f238d9202d838d5" },
    { "TMBTHARK.WAD",       "9e90744b75fb52caef7d60ba85556088" },
    { "TOFPAIN.WAD",        "c6843451f5d9d002f633baaea74cfa81" },
    { "TOWER.WAD",          "f803db6e09526eeabfb7ebf3ae0ab388" },
    { "TOWERSOH.WAD",       "9ed1c75e2f8a2014cc097bb3ceff5c20" },
    { "TREE1.WAD",          "c6ae2120334d337e3c49f7f0bb5a442b" },
    { "TRIAL.WAD",          "e00a313865ee1bb21f4b5d2a989d95c1" },
    { "TTRL.WAD",           "ca4b1cbdf68eb614d8f2055d3f203e8c" },
    { "T_DUNN03.WAD",       "ab91e4f0ee2758faf652547ecb945336" },
    { "UNCATH2.WAD",        "57b0996223b21ea602c3105418db28a5" },
    { "UNDERW.WAD",         "0f11e800a038fef885207bf23f72b0ff" },
    { "UPASSAGE.WAD",       "f42e41794056c7534cfdc04f98603774" },
    { "VISION1.WAD",        "c4a1cb782f6781d302d483eacc1c303a" },
    { "WATER1.WAD",         "16039e864fca731d4ae34c05ab9856f1" },
    { "WATER2.WAD",         "0b9b35719881fd71ed2ee2358fba4878" },
    { "WATER3.WAD",         "885f1105c45e94848064b17231ca9463" },
    { "WATER4.WAD",         "861a6f92fe169efa0dc70e19c27ff140" },
    { "WATER5.WAD",         "c23761d516482c4ebd6d7f1e4e8fdd1a" },
    { "WATER6.WAD",         "0b3402fd11493b79378caf6119a532ee" },
    { "WATRCAST.WAD",       "d77fd5a08411fcccaee085042b9d5375" },
    { "WATRCITY.WAD",       "a9000ba7eb652f66bb608e552cbb5a52" },
    { "WATRWRKS.WAD",       "7ec2e884275ba25b20236b202ff26463" },
    { "WBGY_HRT.WAD",       "649cb2eb1fca244bf5e363d845335af1" },
    { "WEEKEND.WAD",        "c48e66c528b22f0ba661bba165b874c8" },
    { "WIMPY_X.WAD",        "1b055e1cc8ba642bfe69db2935f2ecaf" },
    { "WINDS.WAD",          "6a6d32aa04c5d883eed5f08e94ff1f8a" },
    { "WIZARD3.WAD",        "999f22038e05e5a6689b70df95e4e4aa" },
    { "WIZARD3.WAD",        "f2098feeaa5832c3a05f51a6e683b3a3" },
    { "WIZARD4.WAD",        "51189ac9b25877b2b95e7f2aa5ae211e" },
    { "WIZWARSA.WAD",       "757fec308ccf7fa17c72c2050f717b83" },
    { "WIZWARSB.WAD",       "39596423dc4985b350c86830617347d4" },
    { "WIZWARSD.WAD",       "67f17f1684225b27cb6d864a2af45300" },
    { "WNDBEACH.WAD",       "3e226096f7a7466f2a1baac0ca20f89a" },
    { "WOLF1.WAD",          "3ad952d9afba351a201aff7e4f489a18" },
    { "WRATH.WAD",          "f20d98b52feef9dcf0f101ee3e0cfce1" },
    { "WYBB.WAD",           "f29f89a1c7663310081d97f8244eb064" },
    { "YOULLDIE.WAD",       "0a4db4311abb23a5cc156aa168300a7e" },

        // HEXEN

    { "4WORLDS.WAD",        "be17f5191280680c16c22790ae507b50" },
    { "ABANCHPL.WAD",       "eceb0e87cc607a579ad21ca7c9accac1" },
    { "ABBEY.WAD",          "fb7b3d1ce15b1da9e1028c0397e7d8cf" },
    { "ABSHEX1.WAD",        "a1f1e22fb41378d2db37901edf8f5942" },
    { "AGILITY.WAD",        "e6ac95183afe10617f35d271d6b7291f" },
    { "AMOKHEX.WAD",        "6149db5e38abfb2fad539f1842783030" },
    { "ARCHMAGE.WAD",       "d1a05c6cb8332faecce9b4ca1d56caff" },
    { "ASSAULT.WAD",        "c1254aeecdfa5ef5c3ef98970569477b" },
    { "AVATAR.WAD",         "cb09b5f15786405cf58e816e6aded794" },
    { "AWAITS.WAD",         "25e99ed5e19682d86bd920bab4cd609c" },
    { "BADLAND.WAD",        "1f51523943842319ca58bc04c9371ea8" },
    { "BARTHEX2.WAD",       "c71a933750584ef343472a791055e0f2" },
    { "BARTHEX3.WAD",       "1b7db0124b6a78f7d7b7fec0a1d942f8" },
    { "BAST_CHA.WAD",       "8cfc2a0f4692b59bc80b644c50dc85b5" },
    { "BIGDROP.WAD",        "069c7e99936995eef4d39629925d5e46" },
    { "BIO2.WAD",           "759f64d3fdaffe05bd2b8422c605fcf3" },
    { "CALDERA.WAD",        "79668459091b414bbb24a9cc26cf4789" },
    { "CANNONS.WAD",        "7201a99934b306738d672be8997a6b97" },
    { "CASTLE.WAD",         "044525ac3464d4ac52f84916a55bd909" },
    { "CASTLE.WAD",         "0bf7e186d202212c4c26d179d855f322" },
    { "CASTRO.WAD",         "9223fac1adbd2afb586c095ae1089043" },
    { "CENT092B.WAD",       "4ed361d8839f6599a5d1dad30d7d3941" },
    { "CEREN01.WAD",        "70541350556ae56e267fb080d64a58e0" },
    { "CHAOSFTN.WAD",       "854473332ba3a0179dd89a196a7fa44b" },
    { "CHAOSRSH.WAD",       "4bb813d638959b514db421e92c4f1d52" },
    { "CHUXEN.WAD",         "360d1fc63db9d06a3cfa8c46dc3b1d17" },
    { "COLIN4.WAD",         "d07588475ab865fbd5c8c083da2d9989" },
    { "DEAD.WAD",           "510de8d1e729496681262f0b62487ed1" },
    { "DEADMANH.WAD",       "4bde3ac1925e00f48fbd7a0e546c11fa" },
    { "DEATH.WAD",          "57d5dbb7f1a7c229ffc67f1958021532" },
    { "DETHTRAP.WAD",       "15a60d3bb38f48bb1c74df06c8ee0b89" },
    { "DMHEXEN.WAD",        "4cb3077ad49e0bb4b836e2a06c6b6530" },
    { "DOOMSDAY.WAD",       "ab91b4b5ff476ae01763b801458a9730" },
    { "DOZOD_HX.WAD",       "2976e4ea01dd3d60379b35d4bf3534cf" },
    { "DRACO7DM.WAD",       "3fa1904b2937d360a2d3b38993b61d8f" },
    { "DRKPORTL.WAD",       "ba7cae7186aa2246fbdc633f45ccf30e" },
    { "DSHEXED.WAD",        "0ac5817f9146bd4feb2248cc50bbb6a4" },
    { "DTBATTLE.WAD",       "e4f2fea567aed9bdbcba9607e2a59095" },
    { "DTH.WAD",            "d3523646a8b20f5aefd65fe0648675f5" },
    { "DWARF.WAD",          "f97f81796d2463b9de5230c1181fc7e3" },
    { "EFFECTS.WAD",        "77dcc76872b22c6112320348578a7c1b" },
    { "ELEMENTS.WAD",       "eb65b839e9b3314077e85974260f554a" },
    { "ELETOWER.WAD",       "04a5d2b2fac13f35bc92c1dc65fc9b1a" },
    { "FIREFALL.WAD",       "7b660287081cfa3987c7516b7f859dc5" },
    { "FLAGHEX.WAD",        "4d548e8fea6ac1a587495da49a26eeb9" },
    { "FLENZED.WAD",        "8b3aedac5253a2cc8235646f6f5be146" },
    { "FLYBOY.WAD",         "b7157d8678aeb924001915c2990f9910" },
    { "FREE4ALL.WAD",       "b8f931da172f94d4904175046fcbbf27" },
    { "FURY.WAD",           "2890001144bb8869fa8a4ea8e27a1da8" },
    { "FURYDATA.WAD",       "673dbd65ecc3e3442184df98ea5f3a22" },
    { "GALLERY.WAD",        "cccbb4333c7f9c80bee0661a889d335d" },
    { "GNOSIS.WAD",         "841212def8f5f1ded497577953f0d800" },
    { "H#969.WAD",          "fd8bda8214ff9d2614932999dbd5a1b8" },
    { "HADES.WAD",          "3d480b3ade224634f28e53308d48e9e0" },
    { "HDRKTWR5.WAD",       "2676bca08967300ef71a857714f1e8c0" },
    { "HEXAGAIN.WAD",       "7db6abf674d46b8a271fe2c2f7b9921d" },
    { "HEXALOT.WAD",        "410530b8aad1bcbafab4e4b6f145133a" },
    { "HEXARENA.WAD",       "51cc4f9b33b5f7e56a5bb8b40f7a34a3" },
    { "HEXBAL1.WAD",        "2d29332a54dda47cb46f2ae1a116319f" },
    { "HEXBART1.WAD",       "a1bc5d6ca6ab6ce82b0c9b9393f26c41" },
    { "HEXBAT.WAD",         "ace0a2958a1cca79d6f83d8f84bcafe5" },
    { "HEXBLIZZ.WAD",       "1353806a94efd9900e08cd839f371500" },
    { "HEXBRAWL.WAD",       "3939db45a762d042957a8546ca9ac6ad" },
    { "HEXCANYN.WAD",       "b3a73a4900ecb170e3734097bdec48ab" },
    { "HEXCAVE.WAD",        "877c94ada22e1a25366b088c64d47305" },
    { "HEXCHICK.WAD",       "807b562775fb14c4981db41e0c206a44" },
    { "HEXCITY.WAD",        "4829dee6f1d16fff369136c6bfc1a951" },
    { "HEXCOO.WAD",         "fdd3cadf23dee73ad933e11459b58005" },
    { "HEXCRATR.WAD",       "3e993ed10d65eb0c7fd9c0a52ecd394a" },
    { "HEXDM.WAD",          "2b2cf8f07b1835a2735a818e103e29a5" },
    { "HEXED.WAD",          "723aa471f42b2444469ec3dde08ffb4a" },
    { "HEXELENT.WAD",       "ea7f36ba30fb2152387e9f1c6f8fd22c" },
    { "HEXENDOH.WAD",       "b86cb6fbdfb5916ebc8691800447b425" },
    { "HEXENPOF.WAD",       "f9df395c7194d1bfd9612fbe80a9b008" },
    { "HEXFALL.WAD",        "65ec989cf758063e5891ed3e7a7b342f" },
    { "HEXFODM.WAD",        "99e324d02284fe5233b43b265515faa5" },
    { "HEXGATE.WAD",        "9d5c50766d948103032c12dc25f7dc65" },
    { "HEXGRAVE.WAD",       "0ccab67cf79adc7de1c3735bbac3e61f" },
    { "HEXGUN3.WAD",        "d2f8feaa27f64f0734762fea7f49daff" },
    { "HEXHAVOC.WAD",       "1e6767e11e899b19c6fca9afb1fd9b6e" },
    { "HEXHELL.WAD",        "9d03eb4d4c1007ed7f2c62ef333cda9e" },
    { "HEXHUB.WAD",         "7e9438bfea1d8a5c680a79993282e6e5" },
    { "HEXICU.WAD",         "261eeb361dbabe2a6de72cdfe1be2301" },
    { "HEXJMPDM.WAD",       "1eaf278fb16db3b60bdad44f93c5ed47" },
    { "HEXLIGHT.WAD",       "8c25b5da92a3440451b55ab89d5bf063" },
    { "HEXMINO.WAD",        "8bcef7b0d649a29a6bb4e7d867b0e8a0" },
    { "HEXMISS.WAD",        "078f0513a9ed62d73b9f0dda4e2642fd" },
    { "HEXNCOK.WAD",        "401a27a4e907cdfa0593248298a84177" },
    { "HEXNHUB.WAD",        "b3d4daaeb9007cda014222716c98ae16" },
    { "HEXNIM2B.WAD",       "49c72b1847a54928eb4950bcf4ded4b9" },
    { "HEXNMOK.WAD",        "30c7c69e9a5758bc4c56e06fe1d38b60" },
    { "HEXNPIT.WAD",        "86e68b79c50c64e44cada145599a63d8" },
    { "HEXNSLAP.WAD",       "7ce588cc1ae3b4aa26316c11b67bc903" },
    { "HEXNWARS.WAD",       "a1854837037f13b0be2a17fbbcd2d12b" },
    { "HEXPHUK1.WAD",       "cc485144098fcae8a2623c9592d75988" },
    { "HEXPHUK2.WAD",       "0cac88bdfe7b7fe18af8478f6e643ab3" },
    { "HEXPHUK3.WAD",       "6533b53b54f32e3d3eb8e93b003ceede" },
    { "HEXPHUK4.WAD",       "49e478f216ed7df6d958b9e86b560e55" },
    { "HEXPITS.WAD",        "a950c0bce17871685e6b140bf9ef4fd6" },
    { "HEXQUAK0.WAD",       "1d3e72972a63b7fce810a51e1525c78f" },
    { "HEXQUAK2.WAD",       "6d8cebf1e80376177699565cc210d4ab" },
    { "HEXQUAK3.WAD",       "0ddf5e4611edc2341fb45f73e04fad74" },
    { "HEXQUAKE.WAD",       "86733b516a9eb326ce8e34ec34aa4a35" },
    { "HEXRAN.WAD",         "70fa907e8971cc5e7de0af0ff766e25a" },
    { "HEXRING.WAD",        "66a37810e65e2c0a9434202c3fd46fad" },
    { "HEXSOUL.WAD",        "85173737795be8a46f43c9bda1dea42b" },
    { "HEXSTEP.WAD",        "d886ddbd62af939f303d2e57e32d232f" },
    { "HEXTHIEF.WAD",       "9cebaae99dbe94c2ad4b89fc4a2bcaaa" },
    { "HEXTUN.WAD",         "5e9b27eab9705f1ab8ecaa15e22b3049" },
    { "HEXUS.WAD",          "bb6d5d48aff355032de800daab111967" },
    { "HEX_BF.WAD",         "88321807f4f458222f8b2d2b910115c7" },
    { "HEX_CTD.WAD",        "ada0eba50f73ec15f7ef31a63c0d2767" },
    { "HEX_UN.WAD",         "789359882845cdf95cff809bd1928e8f" },
    { "HI.WAD",             "451e96977c0ae2e01732e3b36ad1bd17" },
    { "HX0_TMDL.WAD",       "d1624405e351e07f6f628c3a2ce4ead1" },
    { "HX1_TMDL.WAD",       "71ab7f0dbb73acbe6988280ddbfa4808" },
    { "HXARENA.WAD",        "d5843f0b622d677a7f188bbe6738e9d8" },
    { "HXCLOK.WAD",         "666cf47864264c30e187f0d747e90577" },
    { "HXCOD1.WAD",         "7b44e2cc4787b0ba28a5483d47434ace" },
    { "HXCOD2.WAD",         "a41d2c7dddfcde3c082ad17af32177ac" },
    { "HXDETH.WAD",         "4477d8e299bd82fe6c312d1889e0a949" },
    { "HXEVIL.WAD",         "9a722ab683265afe5e923fbb4a1f9d9d" },
    { "HXFOGDTH.WAD",       "b69f4f50192f3a0ca9d82673f214afd3" },
    { "HXFRAG_U.WAD",       "d8ae8971167fd10ba724c5e50f5f3ffb" },
    { "HXKEEP.WAD",         "4a5c12cc92987a597ccb6ce078231921" },
    { "HXLEDGES.WAD",       "10fa4839ca08627a1e054af55d9f965b" },
    { "HXLEDSMP.WAD",       "b8d0fa1f12edaddb0375b160beea0b42" },
    { "HXMORGUE.WAD",       "7cc5690ca6d66fe6849d64da3868f50d" },
    { "HXPGARNA.WAD",       "05e885c24a3cff7e7a64f2f6b6b0fabd" },
    { "HXPURPLE.WAD",       "41a5bc87df733a13368a6f6cec0670e6" },
    { "HXSKATE.WAD",        "a2441e1861f752a7844b4503b9b7428d" },
    { "HXSPUNK.WAD",        "2425a25e8f145a2f7db93ded390b96d6" },
    { "HXTERA.WAD",         "6076ecd6e5172efd29b0e4045a537f9b" },
    { "HXTHEBAR.WAD",       "db97ba2f678958149d424a15237954ad" },
    { "HX_BASE.WAD",        "56897d3fc4c6448735655a28ca714a40" },
    { "HX_SALT.WAD",        "f46ce1ea8e432682b5d26f8a94014dfd" },
    { "INDIANA.WAD",        "31cf6e04906ba22af9e0d35860513e96" },
    { "ITSAPIG!.WAD",       "a9c554e572569abf8a63197194d75551" },
    { "JUSTIN01.WAD",       "986794397a0e00e500eb908f5e07b6b6" },
    { "JUSTIN02.WAD",       "b0dd0c78946cf4127febf6b6497fbdb7" },
    { "JUSTIN03.WAD",       "3193753c7f62de6767e46bdf16c8a717" },
    { "JUSTIN04.WAD",       "0f52b1c654b69e819ff58135e326eaa9" },
    { "KALHEX1.WAD",        "0fbac3210ce43fdff230f21d742cde81" },
    { "KICKING.WAD",        "08e30c69cf682033652325ad1dee4225" },
    { "KRULL.WAD",          "6d3f859d2a92493531af9c9eaa212957" },
    { "K_D11.WAD",          "9781a735881e425e81be7c7bfab6b34b" },
    { "LABYH.WAD",          "0227e87eebb5e81f8bfc6a4db46a8090" },
    { "LASHXLED.WAD",       "b67fc59452091157f3fdd7f2bae28699" },
    { "LEAFWELL.WAD",       "1a823a086be4035db6ccf15e2f94fe79" },
    { "LITEHAUS.WAD",       "3b2110e7bb7a704862e02180943d92cd" },
    { "LYCHGATE.WAD",       "9e60b1dde6f8913644ba8c59109b7f8f" },
    { "MENZOHEX.WAD",       "5f8c79cdc600461dbb91ed81a45fb85e" },
    { "MTNBETA.WAD",        "f0850d528d57e6c0e33a7a17644158fa" },
    { "NECROS.WAD",         "6dab64421dca2532e2eb398e13ec783f" },
    { "NEWHUB4.WAD",        "8cb195516497f16805a5d31486b84478" },
    { "NEXEH.WAD",          "d0523c24aefbcf8927e517d99646bc84" },
    { "OCTARENA.WAD",       "e53d416f958af6f524e8a45f43293e9d" },
    { "OUTWORLD.WAD",       "0ca1658940d7de5161ae0aaa3080671f" },
    { "PLAY.WAD",           "08e30c69cf682033652325ad1dee4225" },
    { "QARHEXD.WAD",        "1e7bf3c085a0a829117f02132aadd288" },
    { "QARHEXDB.WAD",       "254d123e6897b0e2deb436d0c1c086e6" },
    { "RANHEXN.WAD",        "23dd1fd78e07f0f124600dd5aa78ed13" },
    { "RECKON.WAD",         "4dffa1c1274c11a557bca8930a25757d" },
    { "RIVRWOOD.WAD",       "dcad8ba802aaf68ef4bcb4f999efbc8f" },
    { "ROC.WAD",            "445fed9f5a794fccd02b9fc5df6c469e" },
    { "S-HELL.WAD",         "ac5504af4aa2bb9f41fefeccc501dc25" },
    { "SEWER.WAD",          "bb1150cfec3ca9b5fc7da34c90ec37c9" },
    { "SHADOWX1.WAD",       "3ed0b683d1a0a2ecd0faf44ca20c5087" },
    { "SHANNARA.WAD",       "6a32f7350643625de6eb2e41e3dca2d9" },
    { "SLOT.WAD",           "74e8c6a393484a0e0559560ad10a36ae" },
    { "STARSHIP.WAD",       "f6ae9931fccd9e8563580bb537724d22" },
    { "STNGAT11.WAD",       "e6c59fa9a3bf4f1c22a85f38fb70e0ef" },
    { "TEMPLE2.WAD",        "84b924f823230cb016cbb8cab06528fe" },
    { "THESWAMP.WAD",       "122f3cc66b7e56a547e656f2125eb7e4" },
    { "TOMB.WAD",           "8f18823c5642f3b26e48e108ccfa688d" },
    { "TRUEDETH.WAD",       "1a2029b1b224d7a1bc32e7881191b97e" },
    { "UNDERHX2.WAD",       "e5fce0bc2a829586f6aa420ace7d99b2" },
    { "URBAN.WAD",          "234d213149ef8910e94d3dc77d765d62" },
    { "VAULTS.WAD",         "dd37cb2e856095dd14cc5fc08c628186" },
    { "VENOM3.WAD",         "5a14c0b89e0a9232aa03b95b7d39750b" },
    { "WALK.WAD",           "9c5e1ffd345d9bff6cf9db9816e036d7" },
    { "WOLFEN.WAD",         "1510ecee5e5e7566954d895452b7f4f4" },
    { "WORSHIP.WAD",        "29e540be83b5d34f8b7bbaa8cce18301" },
    { "WSHEXDOM.WAD",       "34960b0ae4414af6443c6520b8b78832" },
    { "XMELEE01.WAD",       "fa7d104e20685b4d1eccdcedc92e61f4" },
    { "ZENITH.WAD",         "538bf63bbb9fd8aa1753d90c89d34adc" },
    { "ZOWEHEX.WAD",        "1c6d6ee7250ef6fe466e07107cb412c5" },

        // OTHERS FOR DOOM

    { "1CTFMEGA.WAD",       "373ff00f8a227158242add9e3241cb04" },
    { "1CTFREF.WAD",        "4b75905a4f65936ba5246bf27dae5b61" },
    { "1CTFULTA.WAD",       "60b6cbf839562b72705decfaf37845d2" },
    { "2CTFULTA.WAD",       "88615a3993b010c5d23fa584c139bde0" },
    { "2DMMAPS.WAD",        "fe959bb578bd9f274f1ad2da00897866" },
    { "2ZDCTFDC.WAD",       "c771dd9a1153caec79424671875e2122" },
    { "3CTFULTA.WAD",       "c0257ade967e73c788f92e241fef24a1" },
    { "4CTFULTA.WAD",       "a908c91878309c8c9fe7d4c28b51855b" },
    { "5CTFULTA.WAD",       "187eb278ed1eced4a868abd727b40a4a" },
    { "666DMPLUS.WAD",      "180dd7b9f0137193a07637b335d069cf" },
    { "6CTFULTA.WAD",       "8f3b4c74508206678b877b34dc49c7b4" },
    { "9CTFMEGA.WAD",       "92992d36818f942b45ca47780c623cf2" },
    { "ABCDMV1.WAD",        "0d5f8175affbc685edac0c221acac668" },
    { "ABCDWANGO5.WAD",     "3392cca36fe4ec02c7e6545d7a1dc517" },
    { "ABYSS.WAD",          "4ed7e9c72b2581e047e54413cbcf8639" },
    { "ADDICTIV.WAD",       "9e8020df86f2821ae60f5801b8d54840" },
    { "AE_TUPS2.WAD",       "ec019a7935be52f2db7466b339fd52a0" },
    { "ANDYS_COOP-BETA.WAD","9db423b30316d9b783680b5204182b9b" },
    { "ARGENAPART1.WAD",    "2a8ac475dbd77db6876e934063bd63ff" },
    { "ASSPANTSCTF.WAD",    "2258dc8e86c0f97518ac8a15d19dbc2e" },
    { "ATLANTIS.WAD",       "ce0973368a9bccf38644d75c97884f73" },
    { "AV.WAD",             "6006c3a370aa1dc0be04e0f3976f1ca4" },
    { "BADBLOOD.WAD",       "361d3c88d8bcedbc0cbc15aeb5ab8edf" },
    { "BAHDKO1.WAD",        "89f5c2dfb1bcf0d36ef03dc205a4695f" },
    { "BANG.WAD",           "db7d6ced60a32445fe6938b4f466f883" },
    { "BAZOOKADM2.WAD",     "ce8fe88b8086b3125f7a1b9af781129c" },
    { "BEERBELLYBRO.WAD",   "37c9fdb248bb1798b6e5fec901a86b2d" },
    { "BFGBLAST.WAD",       "baceae07522de597adb894c822327e9a" },
    { "BIGRELLIK23.WAD",    "8c18ee1097e2e26d44bbc124fed060bd" },
    { "BIOWAR.WAD",         "28009a1dcb1c26aad04c397cd3fa0db0" },
    { "BLOODLINE.WAD",      "a4d90fa98338d598aebf4968f7695d60" },
    { "BMISIL.WAD",         "3d2ff542efa1716d5a80aaea090f9dba" },
    { "BOO.WAD",            "1f42a0d0d202d5361313914b3213b465" },
    { "BRIT11.WAD",         "4657cd2c84b10dde3ff10ad1bd686224" },
    { "BUNKER_1G.WAD",      "7529fb93e1affec2e00e2cc09a99e3f5" },
    { "C-FX-D.WAD",         "aabc9a5ae0c6ff1ad5354d3c43264d5c" },
    { "CADSDM.WAD",         "e02149185697a46ddb3ddee02ef9749b" },
    { "CCARNAGE.WAD",       "5b7221c253632dc5799815a1986e560c" },
    { "CCTF01T2.WAD",       "846849fbf8420cedfddf86bd00a6750b" },
    { "CENTER.WAD",         "e160316e41397717f5adf034b2fc476a" },
    { "CG4FCTF.WAD",        "15a9892f435f4801a7981a0d4b5a3274" },
    { "CGCTF_B1.WAD",       "76aea5d5961090f21b167a8a916a09e9" },
    { "CHDM1.WAD",          "1b2ed5bef0edf661e05c9ae6c9b1cd47" },
    { "CHESSNERD.WAD",      "060ff2835df6660ccc3dc808831bcc7d" },
    { "CLABSDM.WAD",        "10d08db6d2d38fa2e699e6cb55e25134" },
    { "CLASSIX.WAD",        "6d66106745d0853d49cf6e2b7db388b4" },
    { "CLCREWJUMPV7.WAD",   "beed0b8613e1445eddfb9c4420b04263" },
    { "CLCREWJUMPV9.WAD",   "c18bf3b7303cdb1337d31d5767b07c28" },
    { "CLCREWV2.WAD",       "9677f6241af2f238d53254d25be9ce35" },
    { "CONVMAPS.WAD",       "08f3156b0468ad10aecd91060ece0981" },
    { "COOP_ARENA.WAD",     "8f43d2ebb7cb7c76d9b91d16bcfa23e8" },
    { "CORTEXHQ.WAD",       "5f4e09fb143649661a91a50265b06246" },
    { "CRAWLSPC.WAD",       "bee71b1c898b69b572b27cea4826a009" },
    { "CRIM-B3.WAD",        "4b094ca92425285cb7451b6518e745ff" },
    { "CRIM-B4.WAD",        "9de3cbb0f398686eceb1c39369328335" },
    { "CRIMSON.WAD",        "5ea4a3c1a921f7f833e10f460cccab36" },
    { "CTF1A.WAD",          "d4c741d8c3f7bd77c40a2d4c027851b7" },
    { "CTF1B.WAD",          "90de64d8d6bf94be6a27b60d95ce5ac0" },
    { "CTF2A.WAD",          "34e035607fecc042e79ab7b2d2dda447" },
    { "CTF2B.WAD",          "0badfd1ff168f05c3a2d407b3c01bb6d" },
    { "CTF3A.WAD",          "7362dbc9f2da3e39fdddee5691292b4d" },
    { "CYBERWAR4WAY.WAD",   "43e11d49c17dcb69f87792928e2e81ae" },
    { "D2DTHEPI.WAD",       "5fe00a7d2984faa0bfdec0a926d1cf19" },
    { "DANZIG1.WAD",        "2f9fd867de8db8a3d3bfaae7c92fa792" },
    { "DANZIG2.WAD",        "63cdae166b4bdc2f5070497b8c1ff791" },
    { "DATAVILL.WAD",       "75709d81bb017d54a7e65d80d675ad7f" },
    { "DCDM01.WAD",         "51ee541b4182a1a0e9d267a4925b9416" },
    { "DCDWANGO.WAD",       "e6bd345fbf8ac0a20849ce38b9b3fdd1" },
    { "DECA.WAD",           "aba29c08eaa09919f9e3e5a7e206daae" },
    { "DECA2.WAD",          "0ddb7dae95172677737586508542ce1a" },
    { "DETHTAG.WAD",        "2bec20a4a1feaa86db6c4ff68fcb46da" },
    { "DIETEST16.WAD",      "dc18a5c4d36c3e6be3b3e724efa8fb74" },
    { "DMANGO.WAD",         "e9da32fb243d0f758ad92dc8f0122807" },
    { "DMANGO2.WAD",        "71e858201706d09ff1385806b5579187" },
    { "DMANGO3.WAD",        "f3676479812a62ad60e6e34296bbee10" },
    { "DMANGO4.WAD",        "f22a6baefac7319c9aa8ca371e89672b" },
    { "DMANGO5.WAD",        "1bf627f7c9e1120dc5b59518f1c69b59" },
    { "DMANGO6.WAD",        "226e2bf753d4b364b9a4dc3d5efce6d2" },
    { "DOGTAG3.WAD",        "6c2ed0109db95922e5995f3eb5d44e40" },
    { "DOGTEST.WAD",        "efa64b7a4b92a0dc69c35deb45c7fe17" },
    { "DOGTEST2.WAD",       "782f998474b69934d01a5218fe32867e" },
    { "DOH1.WAD",           "b0e03283329993da43b027e4f8b2fcbe" },
    { "DOMWORKS.WAD",       "4c4100f2c5fb1921eef26f5d50781dc1" },
    { "DOOM1.WAD",          "f0cefca49926d00903cf57551d901abe" },
    { "DOOM32.WAD",         "ffaf7fe48ae035664c10611b81c8bb6d" },
    { "DOOMCITY1.2.0.WAD",  "c6a0d5c1f549ce3a3caf877e225fffbb" },
    { "DRAV35DM.WAD",       "6b89d00211ee89a4fcf4e7d018f39f70" },
    { "DRCLIMMIX.WAD",      "71898612c9839c97d3d2cdead9950663" },
    { "DRM1.WAD",           "4def4b621cf4e28bb6bf205f382346a4" },
    { "DW14C.WAD",          "2503d8896458e0566f797f7bb3dddde4" },
    { "DW26G.WAD",          "48a7b69c50169c5d30023ced2a8919a8" },
    { "DW27K.WAD",          "17d441484f93f1ca6e5232e3c1c88094" },
    { "DWANGO4.WAD",        "f5bdf394ba89256956b5f3db98b1616b" },
    { "DWANGO5.WAD",        "333ca955620fd1678619e62976fb96bb" },
    { "DWANGO6.WAD",        "38e41ffff78afd4b1a75e198ae3f5a5b" },
    { "DWANGO7.WAD",        "82170841f48367ad87f6e81cb5ce58bc" },
    { "DWANGO8.WAD",        "f82487959ca92f466655f956feef01c3" },
    { "DWANGOT1.WAD",       "d3fabc283f803d48ea6edaeeb5faf62d" },
    { "DWELLER2.WAD",       "ae031835efe0b36c618378a18d7ccbc4" },
    { "DYNAMIK.WAD",        "b208bfc2599895620eea78467ccab20b" },
    { "EAE1M1.WAD",         "887c512fc2c13efaff91cf697b038a7d" },
    { "ESTRANGED.WAD",      "957642b22e980ef1aeb8c30629a5f824" },
    { "EXEC.WAD",           "3dd514a851af4360971c793034c10d6a" },
    { "EXPOSED.WAD",        "f4cd38238f59bf02278f9fc7cef0de56" },
    { "FACEVOX.WAD",        "79895e46652285a278db82099fa85d7c" },
    { "FD1E.WAD",           "e48a2c305ae065dab444a91e5e0a234d" },
    { "FD1F.WAD",           "4592d33f8cf3122c1ee3f99d302b3f23" },
    { "FD2A.WAD",           "952960e1bed818f011e33fd24a206481" },
    { "FFA2A.WAD",          "443d82cedff484fd790cce0623743061" },
    { "FFACTORY-.WAD",      "472f3d1c447d7b5fc1e524eeb6bc4449" },
    { "FINALFRG.WAD",       "44f81b942dfb6433a72e7801a6248959" },
    { "FLOSPCTF2.WAD",      "6ad8f938f8bef1e6e9eec3aca5bc816c" },
    { "FLOSPCTFF.WAD",      "2c756d0880e1d5fd7e0f2ba50f31b44f" },
    { "FOREVER.WAD",        "8e1673a80be9870506d6c426e5cb6e5a" },
    { "FREE3M.WAD",         "7356aa3a3f95dd61f6998d79fc9c0388" },
    { "FREEDM0_4.WAD",      "0b072267bc279871327666c72e27caa3" },
    { "FRENCH_FUSION.WAD",  "d7de9600d49a951ca8d2ace790d0264e" },
    { "FRIKMAP01.WAD",      "589eec3333f1cc21a2922d78cfaa2a2c" },
    { "FSTMPS1A.WAD",       "08184467e745cbcf05ddc04c30bf6a61" },
    { "FSTMPS2A.WAD",       "e06c053bed22fdad03ea098a7ab4aa56" },
    { "FSTMPS3A.WAD",       "40eedda515a6f8d441a5ad5bafb01129" },
    { "FSTMPS4.WAD",        "d405c390b42c1f280e09f2ca60b4932d" },
    { "FWFCARGO.WAD",       "ed3c176351aac7def45aa20d854424c1" },
    { "FWFCARGO2.WAD",      "97d81f6f85d1e9bcaced0ac393fbd7b3" },
    { "FWF_AZZY.WAD",       "fee66ff8dfde5c3e6864e2cca89c4709" },
    { "FWF_CB.WAD",         "42acdb08753a510a50f1fe5b631a51c4" },
    { "GDUDM2.WAD",         "6557ca0f2445fe97003c3ee860883f13" },
    { "GHOSTMPS.WAD",       "149580bbff4aae5d340a50519b57f928" },
    { "GLORYTAG.WAD",       "8268554c94318f5ff412e12042907e57" },
    { "GOTDM1.WAD",         "b995226d842bd5703750b22d03c38181" },
    { "GOTHIC.WAD",         "42754cf3b6aa9dd96bc4204cbf5b2bd0" },
    { "GREYMODTEK.WAD",     "873b16379623ff9bcf0f5fcb4bbb95c7" },
    { "GSDM.WAD",           "d991fe7a3bf2dbac20cbfeda7bedb9a7" },
    { "HACX1495.WAD",       "901c5ba83342ef3ddbd6512f39fc5d5c" },
    { "HALO212.WAD",        "43d5a695898076041797e87174f680b7" },
    { "HOP.WAD",            "01344546788f388e69ce82a2f9ab0bd4" },
    { "HR.WAD",             "bb04d6c30c4bbee580063808828ea2da" },
    { "HR2FINAL.WAD",       "dad338e1968aea4df05d465e864d78f3" },
    { "HTMF.WAD",           "2d816896c50f3a82a198ffecb538508a" },
    { "HXCTFRC1.WAD",       "dc9a85d2987ab8271bfc660aecb75fd1" },
    { "ICARUS.WAD",         "bfa394e65a8e332f3ef0da905256ef1c" },
    { "ICEBERG.WAD",        "5fbe3a27e33a1b1c1cf0bf2f416fdef5" },
    { "ICEDEATH.WAD",       "1284294c77c1cf8c952183382f2e5be8" },
    { "IG-DW5-3.WAD",       "63e96b443a325d8d6c9ef480d58a424b" },
    { "IMPACT.WAD",         "53f4e640cb3257d1245c052f610bdf5b" },
    { "IMUSH2.WAD",         "0d84e7b52e547329e36fbd367c734baf" },
    { "INSANE1.WAD",        "323d2b62bd1ceebb32f0c6ac59484672" },
    { "INSTAGIB.WAD",       "63e96b443a325d8d6c9ef480d58a424b" },
    { "INTUITION.WAD",      "5be0752fdc9139380b302f5966380c70" },
    { "INVASION_UAC.WAD",   "02f765b4c9bf72a14b7bc0d3ab262274" },
    { "INVASION_UAC2.WAD",  "ecdb7be3a775ba6be41f74e54996f3e5" },
    { "INVASION_UAC3-.WAD", "6bb9ced884e291531d14fe177834c259" },
    { "IZMFFA1B.WAD",       "b22ce5e68a19bd0792f3c226fd21f7cc" },
    { "JAUNTOD03.WAD",      "0866ef839edf592431aed560206ace18" },
    { "JFL18.WAD",          "50c2fca7188025e44a335513441f3168" },
    { "JUDAS23.WAD",        "37afda7a49e02d9c70c76203c3820670" },
    { "JUDAS23_.WAD",       "bdc5d42776064a44da859026f289207c" },
    { "KAISER_13.WAD",      "0d535bf3749f7b0dbb8f3336f3dc8271" },
    { "KAISER_13_B.WAD",    "c40741172f9662fcd7cc7acec814837f" },
    { "KAISER_23.WAD",      "5cf6c60ee89621233f0a325e7df46db9" },
    { "KANDYMAN.WAD",       "61027c50ca8f1af89b31ca128c643a99" },
    { "KAOTIK.WAD",         "38803a3750096e4e57d6de06c29939d2" },
    { "KB-DM1.WAD",         "2d19726fe0cd8fa6b3d5cb8ac9f16ded" },
    { "KINGHILL.WAD",       "c52157eccb26563804607a214c71b4b8" },
    { "LAMASERY.WAD",       "c5e50762d14b8727ecb35e4a639d1e3d" },
    { "LAMEDOOM.WAD",       "64be639dd0dfad1a4f47dbc6be031602" },
    { "LESION_FIN.WAD",     "5bb8b75f411df6c46dd41d1aed179b3b" },
    { "LETHAL.WAD",         "720973241b30a051aa17bbd80cfeb9b5" },
    { "LETHALDM2PUBLICBETA09.WAD",  "f863d1aa30f4237560e45fb4b127c823" },
    { "LGCTF_B1.WAD",       "d2ca66a11decef1632d18060188328aa" },
    { "LGCTF_B2.WAD",       "3cbf8e022a2948b3f9b4815a58f40a1d" },
    { "LIZZY.WAD",          "4fce66c54ba8c83b2ecfb0512faed6f2" },
    { "M1CTF.WAD",          "f21f60d1bf5deaea2b63062d3676877a" },
    { "M1CTFA.WAD",         "34b4ff1db84d40a2fe9132afcc24b7f4" },
    { "MANCER01.WAD",       "7f775d040f3fddd50757909ec7b24f27" },
    { "MANCER02.WAD",       "7b72eaa89863a72cfa39ce39955706f9" },
    { "MANCER03.WAD",       "2992330b5232f0780aba20219538d1de" },
    { "MANCER04.WAD",       "e8086ee3674b4c25ea92aa7f2315569c" },
    { "MANCER05.WAD",       "8188b976cd5caaeb60398884d5f01e9c" },
    { "MANCER06.WAD",       "1e232d41a5aa5cdd454a622f0224b95a" },
    { "MANCER07.WAD",       "7f7e3f34f8e5f0127c8fcb398f834375" },
    { "MANCER08.WAD",       "31141aef8ec1e5e87277eea48bc4c0f5" },
    { "MANCER09.WAD",       "4d148268e8e3c21f7c33efcf7559105e" },
    { "MANCER10.WAD",       "fbc86298df66488e587ddc386017e2d6" },
    { "MANCER11.WAD",       "6cbb0ce421e651953efe416ceb7f2f63" },
    { "MANCER12.WAD",       "75b0c18210ca3d54700bec162e2dca96" },
    { "MANCERX.WAD",        "e8b17d6458101d6c6c79bc18121928bc" },
    { "MANCERX2.WAD",       "9d5593c5701db4e389715f653c2e6ed1" },
    { "MANCERX3.WAD",       "52d3c257b8c35c981a17dd3224db5c3f" },
    { "MANTRA.WAD",         "84ddf5abb439b477498aecd13528a136" },
    { "MAP01PATCH.WAD",     "ca2d6191d88b41ef9a7248853a547eb9" },
    { "MARSWAR.WAD",        "0dc5b2af23fc630ff43246ea7142b07b" },
    { "MASACRE.WAD",        "eed85cb438c980f77268f77bb2dd43f2" },
    { "MD6.WAD",            "5dc55fbeb366be2fa83724df26018f5e" },
    { "MD7.WAD",            "8782874445c565f02867bd06f49cbd6c" },
    { "METALLFORTRESS.WAD", "ac8ce75fae29118c2eead152b8fb29cd" },
    { "MM.WAD",             "ea4d51f7940b5af010d89afc8e1ea82e" },
    { "MM2.WAD",            "83414913d5c5c1685d633b7138cda387" },
    { "MM2MUS.WAD",         "eee117057694fb3598d18762fe7e83fb" },
    { "MOO1K.WAD",          "e0dedc879e5c1d42b2aa174ce4f34c67" },
    { "MOO1M.WAD",          "6854451d1ae9fd54f42b601cb8154ba3" },
    { "MOO2A.WAD",          "6789d57cea79b901aef812664041c677" },
    { "MOO2C.WAD",          "923e1602be0979865e565f61caa00dba" },
    { "MOO2D.WAD",          "2e4635df68da25f78fde58ab179b8c2c" },
    { "MOO3A.WAD",          "c8fb929258e6419e303fdede2375a281" },
    { "MOO4A.WAD",          "2fa869500145a95f3915cdeddeb53af3" },
    { "MOO5A.WAD",          "984e849ceacac745f5174c2604593988" },
    { "MOO5B.WAD",          "ab4768f0f555be5b388e418298b146b7" },
    { "MOO6A.WAD",          "2373a4ccd35bf6179b5be99d30cdcc26" },
    { "MORPH1.WAD",         "1caed59e3c6c5cb03220f1e96af3bd6c" },
    { "MRDOOM.WAD",         "68086f135eab31557879f022ebd13299" },
    { "MRDOOM30.WAD",       "70f4ffc8d317212b3a051f0f938c169f" },
    { "MULTIDWANGO.WAD",    "d2d6c5fc7a30d0b5bfc67f9f7c149ce0" },
    { "NECRODM.WAD",        "098c3e194b2efbf48f9724230b28b9c2" },
    { "NOBFG.WAD",          "95aece53e79ecbf15a8164c0bc5c7144" },
    { "NORL.WAD",           "d829e6330824c96745870a27cd3ff754" },
    { "NOWHEREX.WAD",       "88e0b4b9b805fa1eba5bb8878480cb2b" },
    { "NOWI_DM1.WAD",       "927ce47581f0af03cf6f61f68dfa8200" },
    { "NSEXL_A.WAD",        "b05620e23bc849748fc1e03200182252" },
    { "NUKEM3D.WAD",        "f462ec828a7c42c1b3325ca3101d35b3" },
    { "NZDCTF.WAD",         "e3b84a91af695b21f7e03601f06c175e" },
    { "OMEGADM.WAD",        "9fbda29ed3aac0a1054f981a7e97ea8c" },
    { "OMGMUS.WAD",         "ec9726b82360dc643176e2f3d19c678f" },
    { "ONS1096.WAD",        "c50b5a46eaa11c6d82d5b7491b4b72eb" },
    { "OSCTF-BETA2.WAD",    "06559c43b68c047934b6a8f70d63ec0a" },
    { "OSDM.WAD",           "9c4a6c2753b5bd258b3a224f213ccf00" },
    { "OSTHQ.WAD",          "486d603111f809d0bd4eec96dcd60856" },
    { "OZWANGO.WAD",        "a74457cd729438ee3a7c1899b4766a01" },
    { "PARANOID.WAD",       "aa52e9ff3459cb07df88697c4c98b874" },
    { "PIPES.WAD",          "cbb10d456975b76d0ea071b09ed89909" },
    { "PIPES2.WAD",         "124cbe2ed1b89bb0bc7a2370da82bb55" },
    { "PRISONDM.WAD",       "660d41d6e05735d6d5ba9314f9f5f120" },
    { "PUNISHME.WAD",       "5b111a2d291c5634d07b20e343dbac52" },
    { "PWDGUN3.WAD",        "6eba484af6a41f30cfca7a523f405f00" },
    { "QDPATH.WAD",         "3868881de13408e3d91839d3548bb434" },
    { "QNB.WAD",            "a17ad8e5f6338ede402c82bd6b9a205a" },
    { "QNBC.WAD",           "4887c98f0744a19de68b315f63404fbf" },
    { "QUADOOM.WAD",        "48a3133988f22cbb482e86b9411d9ba0" },
    { "QUADRADOOM.WAD",     "9e15583d90bc14cfff79c98828508ba8" },
    { "RAGE.WAD",           "64c73624a694e15dd4770811038f521e" },
    { "RAIDER12.WAD",       "0e3bd282a1806c384b3fa8cd7f16775a" },
    { "RAILS.WAD",          "98224bbcd2f82e3ee08b866e4d6172b7" },
    { "RARAAVIS4.WAD",      "f319a5f88df8d782c009c313a74d01aa" },
    { "RATTED.WAD",         "5eb5ea82da54ae79946cf8d59d208638" },
    { "RAVEN1.WAD",         "774bfd97661d22f9a0bb25bc05fd7f6d" },
    { "REBORN.WAD",         "cc19b826aa112f0b2ac57b853b729dd1" },
    { "RHM.WAD",            "b53ca29811f728dcbf9b72735c94e5ca" },
    { "RIPGROUNDS.WAD",     "103d0468f12f183d4c0ad4a4501bb857" },
    { "RJUMP_T2.WAD",       "e8a6505e1d8c1f7df2f4e0d0e4e2ac48" },
    { "ROSE.WAD",           "8ba26f50140cd5ddb9e5da123a8d6b9e" },
    { "RZSPOOF.WAD",        "5e87f52386837ecd172feaa311e3f7e1" },
    { "S5F.WAD",            "8f1e9fa36cf4d877f95575ec569945c6" },
    { "SEX10A.WAD",         "205e52167973856168eb18a66ad01ee9" },
    { "SEX10B.WAD",         "58040c7e3884872b0fc6fa52c511ccba" },
    { "SHAWNMZ.WAD",        "6c54fc2056bfb66dab40465c5dca8ad7" },
    { "SHOTGUN3.WAD",       "63b5db1bdd8be5b08d2d2b0c508f3cb9" },
    { "SHOTTY.WAD",         "5d2c9e02382b6058e2f3fc84fbba4b88" },
    { "SIRDM_5.WAD",        "20a0b295c7715db5727bc21872e41dea" },
    { "SIRDM_FINAL.WAD",    "eaf781204499e5f2d8f47b2dfb47f1bc" },
    { "SKINS.WAD",          "c071230f120b46625c412bcb1ea30617" },
    { "SKROOM.WAD",         "1e16dcb2503a3757efed3143ec6fab4f" },
    { "SLHQ4.WAD",          "2645e235e1303be0ee7375542884141b" },
    { "SMDM.WAD",           "5349f9128874e7c52483d055418bde77" },
    { "SOLSNKDM.WAD",       "0adbe9570bf177fa81bcbb5d9816c1a7" },
    { "SP4WAY5.WAD",        "6d74b6edc6f4bdcb0fbb4347d00d036d" },
    { "SPACESANTA.WAD",     "f35b479f4a272180ad7f5ee165504a47" },
    { "SPVSF.WAD",          "0604c3a2dac5ad9fb618cf513d73eff5" },
    { "SPYRODM002.WAD",     "95144f5e425bed70b17b179cf4a8c573" },
    { "SS-MAP1.WAD",        "b6c07fa27c5e475e6931e0826c38011b" },
    { "SSG2A.WAD",          "18ca9eb4583691f395681020d42098cb" },
    { "SSGONLY.WAD",        "2b808b0bc8d9e53f4d5f07fa0860cefe" },
    { "STACKER.WAD",        "941a19136a323a887da337439c5d490b" },
    { "SUPERGUN.WAD",       "e0b9c0bc79f54e045eaaadf2e9e7f4f2" },
    { "SUPER_MARKET.WAD",   "859d3dcfe40c0cf769afcd6df20631c2" },
    { "SURGE2.WAD",         "824077487de6ad17f596a9d631476fb0" },
    { "TDM1.WAD",           "b5880f2fc240094cd5278c10464677f9" },
    { "TEAMPLAY.WAD",       "617265e7119a36bacfd31136f0a7ad57" },
    { "TECHBETA1.WAD",      "6991e7ce746a28a4590542b4be8b2e53" },
    { "TECHBETA2.WAD",      "ae1b413c1d9301cfcc7826204fe588d6" },
    { "TECHNOCRACY_BETA.WAD",   "98035cf5214c20b9fb2694c8ebe8abfa" },
    { "TEST1.WAD",          "4d74bf506a0d81b21db6a43edab70eea" },
    { "TEYE01C.WAD",        "1e3f0d9b1bdb765944509b53283f6e30" },
    { "THELOWERHALLS.WAD",  "0e63720fb6e52325fc01c1c6ad12398e" },
    { "THOUSE.WAD",         "1e96aede01dfa23c9eca9071dd2ee341" },
    { "THSARENA.WAD",       "397ddcc93e1de2653adda11e1b75d6f6" },
    { "THUG.WAD",           "069cb9cf24d52ef19c46251dd2c4ad0c" },
    { "TIGERSON_AREA.WAD",  "dd9d89af3f7a1f8c4e5db0c1613c71e0" },
    { "TLSD2003.WAD",       "468686918f1d590c2412bdfa1390bc6f" },
    { "TLSDM.WAD",          "e6d781118e2f970de464e4797498247d" },
    { "TLSDM2.WAD",         "f58e5431edeae118e98a79a799e68ef9" },
    { "TLSDM2K3.WAD",       "1e64b348dcfb5892b931df3828d40eb5" },
    { "TLSXCTF1.WAD",       "0af8b239b239b2adbff494fa4c604622" },
    { "TLSXCTF_BETA.WAD",   "3c43234d55d9c04942ef2035b848555a" },
    { "TMSF1.WAD",          "6eb8354736913e9252b2987835c835b9" },
    { "TMSF2.WAD",          "e85896fc0454b02c84fd53572ce161e1" },
    { "TMSF3.WAD",          "5023a21dd9234e7b113c01c73cc8e051" },
    { "TOKEDM.WAD",         "82c545968c619a01a49a52cc9ceee6d8" },
    { "TOKETAGA.WAD",       "ba57354e44b57ee55f900f7a9033d5b4" },
    { "TOKETAGD.WAD",       "2a3be716157a27567e4979c84ad35d21" },
    { "TOKETAGE.WAD",       "ff9bcc2188f8b8ea1eef22fb6ce8bfbf" },
    { "TORNDM01.WAD",       "4cee13a046c83d5a776f8182fe18545b" },
    { "TPF2.WAD",           "d7417e66e64f697f818b4fea81e3d841" },
    { "TPFCANOMALYE.WAD",   "b8127c74a9da088903df60fdef21c1b8" },
    { "TRAN1A.WAD",         "9dd86cce2dd5cc2d72aa1b8ecddd0547" },
    { "TRAN2B.WAD",         "abd93aab83cc8ec0c2a0188ac44430a8" },
    { "TRAN3A.WAD",         "f9600d9fd41dcb1924e6ebbbcd8d389f" },
    { "TRAN4A.WAD",         "79731cb1fd4abf3674d141ec09967091" },
    { "TRAN4B.WAD",         "91f657b1df7b9a48efc80d614c230726" },
    { "TRANS2A.WAD",        "6230ae936efb68ac220f1d5f0c3600e0" },
    { "TRMT.WAD",           "d8962e39cbbb00450860ba081bae1a1b" },
    { "TSP.WAD",            "77517e08cd83aed71782b545c4a79d25" },
    { "TUOMIODMX3.WAD",     "8859af4ad737f489acaa075d7fc913fb" },
    { "TURRENTSCTF.WAD",    "f675b0311518e8e37587a9e70a0d8103" },
    { "TWIZTID.WAD",        "5c7703a0c81e32e3cba9385e646d3856" },
    { "TWZONE.WAD",         "646197997357375f8b49e692c2c06eb6" },
    { "TWZONE2.WAD",        "b9b6a029beeccfb529fe35c90a868005" },
    { "TX10C.WAD",          "07facfb32f60efb508233c9de6ce148b" },
    { "TX11C.WAD",          "bbaf3e13193c59c400e67d7dbfab513f" },
    { "TX11D.WAD",          "71b2ff1e4777f4534d4bb00520f790a7" },
    { "TX7.WAD",            "7a7d1364d86125bf2beb7d2ab99c7b56" },
    { "TX9B.WAD",           "1e7c812c836a26309c46a4cf725abc0d" },
    { "UDM1.WAD",           "bec209759eab1aec9321dbbc935f1785" },
    { "UDM2.WAD",           "06f1883ea108665f03ae191d0b402222" },
    { "UIGIB12.WAD",        "02b04dc023e053fc819bb6dc782b0b3e" },
    { "UNO0NUNO.WAD",       "94ffb174f3b4fb69734f3d6c121d4a8e" },
    { "UROCKETZ2.WAD",      "a096f1d8e5eed4caf6d64fea196883eb" },
    { "U_DTAG.WAD",         "32df5f8e9eba3700fe4fec5e434d55c5" },
    { "VB7A.WAD",           "1642013a9e4fde94418f4bef9e15629d" },
    { "VEX-DOOM.WAD",       "c0cb1f92ec3b4f3a3e82bd6e22434796" },
    { "VEX-SKIN.WAD",       "7b99529327fc764eea335cb3081c83c2" },
    { "VEX-ZDAEMON.WAD",    "d086b3fb602f4560feb22776b26d2fea" },
    { "VEX-ZDOOM.WAD",      "3a65e271e7fd54f3d9eea995493ba2f4" },
    { "VGMUSEUMCTF.WAD",    "995e688355d08685aa32e247aff0e079" },
    { "VGMUSEUMCTF_BETA3.WAD",  "6021fbc6f387f24653062eef57c7338b" },
    { "WINTERDM.WAD",       "3aaeda738af2ca3d712f9e611642b885" },
    { "WOLFDM.WAD",         "8f82301c9cb2626a56f89e0bc727537c" },
    { "WOLFIEDM.WAD",       "d8e041ba9b4119f55ed67e776d061be3" },
    { "WOOD_TO_THE_WIRE.WAD",   "f8c4bd0de0f5bf2125c35db6f1c338f7" },
    { "WORLD.WAD",          "4ef882e7ce5ede1f7ceb476d0d205a9f" },
    { "XCTFDEMO.WAD",       "7edceb20f934009b036b19ea96e9a426" },
    { "XENOSX9.WAD",        "32b3176a9df3192e45e6fd82206d6d50" },
    { "XOLERAS.WAD",        "ceac94f253cdc974e7d35bc2ea5f25af" },
    { "XXX.WAD",            "099e6a25e7c45c0d9a41a428adc6e607" },
    { "YALEXA_2.WAD",       "7f7568555025a0e701899ce4c87cf195" },
    { "YALEXA_5.WAD",       "a0a04b8cf1190e590a399c6936cc5db6" },
    { "ZD16FFA1A.WAD",      "947b812b38089aed92957dca2b1de612" },
    { "ZD16FFA1B.WAD",      "9ac88ac68caf8880d77f3490a2b20690" },
    { "ZD16FFA1C.WAD",      "9daabd8080a9ca4148f74b8523adb64a" },
    { "ZD1A.WAD",           "6846292f94eb040c8dd8b7d664e75b4c" },
    { "ZD2A.WAD",           "fefb7c89d5e7f5f4c28155c3bff2c632" },
    { "ZD3A.WAD",           "84b292ea5cfda65bd855baa71890de0e" },
    { "ZDARENA.WAD",        "5e8d753068efbdb16b6813020aaeaf69" },
    { "ZDCTF.WAD",          "2694e8762b428a262fd54c0e2e3a6371" },
    { "ZDCTFMP.WAD",        "e739adb34bef310311bbb50d6711646b" },
    { "ZDCTFMP2.WAD",       "3359d1560874812fabd41fd9619b1dc7" },
    { "ZDMAPPACK1.WAD",     "3117d66d531f55c358c5fca0e77bcf8a" },
    { "ZDSDM.WAD",          "db71595d4f62b331317b6053092f04b6" },
    { "ZVOX.WAD",           "c00e662405992561cbcc8d40712aaaff" },
    { "ZVOX2.WAD",          "081a2c8b5b34506633cf489a6223d085" },
    { "ZVOX2C.WAD",         "081a2c8b5b34506633cf489a6223d085" },
    { "ZVOX3.WAD",          "41275d6a787fc784fd8ad030e552648c" },

        // LAST MINUTE WADS (usually for Doom II)

    { "0.WAD",                      "c26e82c3cf9bcc68ff66c2c2dcf411e7" },
    { "0PTCH.WAD",                  "27a6b8213c378342f41818761c1de53c" },
    { "1.WAD",                      "1d4449c58b07a746511744152e7d64b1" },
    { "100GUNSX.WAD",               "a2b9e6b65133699d2c08c0b72d7af90e" },
    { "2DDMWEAP2A.WAD",             "8ff85fc5e126a4f2ba33c10d47c13523" },
    { "2DMMAPS.WAD",                "fe959bb578bd9f274f1ad2da00897866" },
    { "2DMPATCH.WAD",               "d1d3594edc6aa9802f22ddd75a656568" },
    { "3CTFEPIC.WAD",               "51380fa7ee000fec47d309e10d934f41" },
    { "8BITCTFST.WAD",              "8a459b6f5fa4e1ff9ac77fbd620a9d18" },
    { "99COOP.WAD",                 "3d3272f46e387b9f4a2aa785e6d0acfb" },
    { "A1.WAD",                     "a52a81dd411f3f59b9ca62e4d17bec31" },
    { "A2.WAD",                     "637a10410d6a40cc0f1ef680ed7b41c1" },
    { "A3.WAD",                     "842623a9d23ee926468a11f44c9130d9" },
    { "A4.WAD",                     "f152b41e6c385ef4a6cd89b0a9defeec" },
    { "ACIDPLNT.WAD",               "fa40ce0cda178af06da5c019a15945c0" },
    { "ACOLYTE.WAD",                "77bb39285b83db981bb4251ea2c42777" },
    { "ACTION.WAD",                 "e2962e0787f1fd66bf9866a9553eeafa" },
    { "ADVENTURE.WAD",              "480a830f25ecaaf700089fb9523fe5df" },
    { "AFMPS.WAD",                  "1ccf3e2164c68c89fdb2fe7b0359bdff" },
    { "ALINV.WAD",                  "4f3b837a0356825c4ff1617de478ddaa" },
    { "ANARCHY.WAD",                "ec7ceea71233ca698bf47948b23c8297" },
    { "ANTHROMECH.WAD",             "a8de83d7b57c90d05290072bed73865d" },
    { "AODTCLV1.WAD",               "dbc1a3ea5cd1bf53014305a9bffeac82" },
    { "AODTCLV2.WAD",               "6949a0d8033baf61aacd5d7234d0b0d1" },
    { "AODTCMS1.WAD",               "26b641727ca88ad6ff23a0e5e40c4c81" },
    { "AODTCMS2.WAD",               "c3e942506d0c39712c45ac6ef12ed2d9" },
    { "AODTCSND.WAD",               "f496c9c7ef0b8239a97765e3f6d78cca" },
    { "AODTCSPR.WAD",               "8649a4ab9b4c947b5d94a2bd493ac0d3" },
    { "AODTCTX1.WAD",               "07c0bd0d0f14d9a745d6bbdd5fdbc331" },
    { "AODTCTX2.WAD",               "3f553d7aa1961dc19c5452ef41fd0b72" },
    { "AODUP-D1.WAD",               "2df5f92b47dc3ddf98d1cf679bc04f02" },
    { "AODUP-D2.WAD",               "8d8cd59352526e2289c831215cf1a7e0" },
    { "ARCHGUN2.WAD",               "d82ad9036573d718b383965718460180" },
    { "AV.WAD",                     "6006c3a370aa1dc0be04e0f3976f1ca4" },
    { "AV20.WAD",                   "0dd100a024dbb77f333c2610cc9fef4e" },
    { "AVPVT2.WAD",                 "ec0fc35a9a41a71032a23b05bbe6cbb1" },
    { "AZDWANGO.WAD",               "6c5d6a20357af00bf2e94ee3a6d7e917" },
    { "BABELNIGHTS.WAD",            "c52c4aad1b90b1d62f624b4438b28777" },
    { "BARRELOFUN.WAD",             "2189604d9dabdf0e25316598d650b97c" },
    { "BEGINE.WAD",                 "3f911de2b29bc967298981d8f6794b94" },
    { "BFGBLASTV4.WAD",             "7c1e68cb233eb3e24064beeb07b02149" },
    { "BLACKOUT.WAD",               "e4b6757a15f8720974d9c1b8cef0f332" },
    { "BLASTAPHON+CYBORGS.WAD",     "2a79b79e0901f7e769ebfad2a70b3c74" },
    { "BLASTAPHONV7.WAD",           "361aac44c4ae5d4c585e0ef823d828f1" },
    { "BLIZZDM.WAD",                "e893cb3659072e183f0e7824fb6dde76" },
    { "BLIZZDMZZZ.WAD",             "c272086eb118a4a6dbf2c4baefa7bc10" },
    { "BLIZZDUEL.WAD",              "4ac37048206bd11c831df8beb488f891" },
    { "BLIZZINVASION.WAD",          "d7145563e46ef34bf72fcf69ea3188bb" },
    { "BLSTRIFLE.WAD",              "076d0bf8fe612d03d65f5b50ce7d0ca0" },
    { "BLUDBATH.WAD",               "49c1ac041b1ce2195f3a93461896fa3f" },
    { "BLUDHIRZ.WAD",               "ba3460ed17db862d17c76d7e6606d2dc" },
    { "BM-BFG2.WAD",                "0fd1f6a4afc143b02a42127b822d5c36" },
    { "BM-BFG3.WAD",                "7286e03d4814e39f83c0bbb1372df211" },
    { "BMYSTERY.WAD",               "10783b17c5e434b22c7d75915747fa94" },
    { "BOF_TOURETTES1.WAD",         "cfabb668f1027f980714301471ecc39d" },
    { "BOMBVEST.WAD",               "fd5634f0e36cb137307c4b7f2c567b2b" },
    { "BOO.WAD",                    "1f42a0d0d202d5361313914b3213b465" },
    { "BOOTHILL.WAD",               "f2c6f9eb1912f4975d2a198ca1e857b5" },
    { "BOSSMAPSDEMO.WAD",           "c80d7c0132dbc26706cf22c90b9b1590" },
    { "BOSSMAPS_V2.WAD",            "8a150b4fcd630847733b54c67661b8a1" },
    { "BOTTUMLESS.WAD",             "4b049b04a90e627b0063c6ba769b1017" },
    { "BOWELS.WAD",                 "c1ca82e626e060a885b4c9418c113f1e" },
    { "BREAKIN4.WAD",               "e355925e3183d8d302bbc6c4b6fed152" },
    { "BRIT10.WAD",                 "61c269d3daedc65340502493418bd5eb" },
    { "BRIT11.WAD",                 "4657cd2c84b10dde3ff10ad1bd686224" },
    { "BRITISH8.WAD",               "6a61aff4b0ca442e514caa9b39427f85" },
    { "CACODM.WAD",                 "67db2bd08c731be868a0d668eea81365" },
    { "CACOLICH.WAD",               "bd456b15778ba3f2b1c284e5f7e7e814" },
    { "CACO_INVASIONM.WAD",         "f931f204d05162fd460ebceec2888bc6" },
    { "CACO_INVM.WAD",              "72c522a83334a380551a784a70a8fa25" },
    { "CDMV1-0.WAD",                "82f0d5e1ead6b12f7fe0955c78309ff9" },
    { "CDOOM_LEGACYPTCH.WAD",       "9de79f159e85786494f37c2c4dbad9cc" },
    { "CDUD1.WAD",                  "49f2dc7c52451dd6cf923e6c63b177e6" },
    { "CHAMBER1.WAD",               "17939683afc25e5d8d0e71f724a13eff" },
    { "CHAOSCOOP.WAD",              "e1c434d58e396d973ee9257a344a4c78" },
    { "CHAOSMODFIX.WAD",            "15ee15b7f84faaf1d6b4e2a272c8d958" },
    { "CHAOSMOD_A42.WAD",           "6b2a71c0fef125e434156b40ab8d2770" },
    { "CHARPTCH.WAD",               "072359f90dae4c8a78e200e34b1c9f27" },
    { "CHATROOM.WAD",               "5638de9fa161c1906ea29d5349e178a7" },
    { "CHNGUNSG.WAD",               "3a013c284d20dec8e6e3f55792388782" },
    { "CHNGUNSG2.WAD",              "6c749b4dfc45b11d88db96cc2346f0a1" },
    { "CHRIS61DEH.WAD",             "82e7c6e6a49560568a893e1dc5c97d56" },
    { "CLIFFBASEBETA.WAD",          "8d38ba448da9310eefd762a6dc343565" },
    { "CNC-RENE.WAD",               "744eeda14109c82c7947f0cf5e6df097" },
    { "CO-OP MAP 1-4.WAD",          "6699abf2c79e2e52571dc7075a48a6da" },
    { "COINV01-V1E.WAD",            "e3c2f933b590f3fc984ec428e3c60393" },
    { "COINV01-V1F.WAD",            "cd47536d155ec6617c5518ceb88a615c" },
    { "COLOUREDCACO.WAD",           "adbef7de9f5c2630ccad1433f4381f64" },
    { "CONFUSIN.WAD",               "10a00d659e420a723173ab96d693df63" },
    { "CONSOLEDOOM.WAD",            "1d4abf068248f6bfd4493533fcbbe994" },
    { "COOLWAD2.WAD",               "413d62cb140a447377c98e0106d31401" },
    { "COOP-MAPS-V33ST.WAD",        "39d2cf2a1a49ef1da43ae8b5f6d7167d" },
    { "COOPBUILDLM.WAD",            "ca647575c04b493e79236430652f5cd4" },
    { "CRATE.WAD",                  "7f3036bcdb41ce28c16efc9d22c4398b" },
    { "CRAZY-NAZIMOD.WAD",          "3869069bf2c9fdef9a0befba1a50ac24" },
    { "CRUDREAM.WAD",               "9ce262488f40b2f9029c25a64900d98b" },
    { "CRUSHER.WAD",                "58f8125015c7886dfb2c8dbe94fa13a5" },
    { "CSVOX.WAD",                  "b3a0d31a41344e89a864efda0eb0f25c" },
    { "CSWP2_FIX.WAD",              "b369366d608f7c9019be939b36df318c" },
    { "CSWP3_FINAL_2.WAD",          "6d1978a2f310df9423778e5232c69ae5" },
    { "CTF02.WAD",                  "a910d3d67029212b2daf11739ccde2b9" },
    { "CTFDUKE.WAD",                "176e29cdebb4f1e86446f8c17aeeb0ca" },
    { "CTFJOUST.WAD",               "10719aac1551ca44bce1b990b43f274f" },
    { "CTFJOUSTV2.WAD",             "a9e77e834bfd5988a10a2ea4d9845cdd" },
    { "CURSEDDM.WAD",               "b1deab6461821f69ea4c63715a318297" },
    { "CW-SIN1.WAD",                "50f099da96df095e4e3aeaddab5f0b20" },
    { "CYBERCRIME3.WAD",            "ccf6ad5517b12e2cd1ca51014401b19f" },
    { "CYBORGMONSTERS.WAD",         "a5150c930befdbb082088b3732aaff12" },
    { "D2XSTUFF.WAD",               "66e43ecf4fc02c6e348acf7ca941a8ad" },
    { "D2XTREME.WAD",               "c029e579347af5ec2cc8ebe38c9c3ef6" },
    { "D3MOD2B.WAD",                "5f58dc9529674d5d7e76fd9faaa7456b" },
    { "D3MODA.WAD",                 "094076910227e6220a22b24f95dc7b7e" },
    { "DAT1.WAD",                   "823d4b75ba9a39339dfedafa4f32c6e4" },
    { "DCDWANGO.WAD",               "e6bd345fbf8ac0a20849ce38b9b3fdd1" },
    { "DD2.WAD",                    "d1902881204215433ad749fe253333e5" },
    { "DDMSET.WAD",                 "b73809be72246712c4e2f457f54d5a13" },
    { "DEATH.WAD",                  "a9d26b76eae2c19212877b896c409065" },
    { "DEATHKNI.WAD",               "ef908b82c74abb15a9990dccc7fd2a7b" },
    { "DEEP WATER.WAD",             "8d9d165069da782acc9c5fd6e8b298b0" },
    { "DEHWEAPS.WAD",               "4d7a86115573ae46c769ba7c1d62939e" },
    { "DEHWEAPS2.WAD",              "dcec15fb3808921c931f69253bc52986" },
    { "DEHWEAPS3.WAD",              "5f244654aeb44b8a20baf22f292043af" },
    { "DEHWEAPS4.WAD",              "a20fe02fb61d4493ba2cf591023ac932" },
    { "DEMONIC.WAD",                "059a9883b2551b72d862ab0a001a9912" },
    { "DERELICTBETA1.WAD",          "832ddf6a1dac36212a37efcd7310c8de" },
    { "DERELICTBETA2A.WAD",         "09561dfee2e56aa2b60cbc4577918d5b" },
    { "DESTINY.WAD",                "0de88b69e13153be27bcaa1b9baca8d6" },
    { "DEST_UNKNOWN_V16.WAD",       "ced01d9ab527127769b351decd83b83a" },
    { "DEST_UNKNOWN_V17B.WAD",      "2e3b5307cc69de178e7ae50edd9b415e" },
    { "DETHARENABETA1.WAD",         "cc96689f058d888df8acbdcba9e371ea" },
    { "DETHNELL.WAD",               "6b54e92a3f589f077726f2df6475772e" },
    { "DETHRAIL.WAD",               "22ce25e5eb350a862f5d05d993ed5a67" },
    { "DFDM.WAD",                   "ab71b7df41c70649db7f618a98cd8f11" },
    { "DG DM.WAD",                  "dd1219828554539358f12f53cc98ebcb" },
    { "DIB20B.WAD",                 "347b482ff18ca283c50a0f07da7fe87a" },
    { "DIB20D.WAD",                 "cb080c5514c503226ef169f5271c942b" },
    { "DISLEGACY.WAD",              "447cb9a1ae5a9c97e151171b8c701732" },
    { "DKID_PLANET.WAD",            "4c36d4bbf23fce6a23abe3052f495151" },
    { "DKSMAPS.WAD",                "da400ab18d5566337bd27ae74d162943" },
    { "DM03.WAD",                   "f500220c9ca0f6139d7a92a2d20b2508" },
    { "DM2FORDM.WAD",               "581776bd9c779f19b55440773b946b6b" },
    { "DMBITCH.WAD",                "bb433a1bad5c2a7168e434464f863af1" },
    { "DMPACK.WAD",                 "782618328b6e52c24c37ebcc67559cc9" },
    { "DO.WAD",                     "0587ae68af66e84b8036d8948b55ec0f" },
    { "DOMAIN1.WAD",                "493e811966bfb9344373a6a7d603906e" },
    { "DOMAIN2.WAD",                "8acb1ed9683ed91c05340a06b9836b70" },
    { "DOMAIN3.WAD",                "7b80869d4e7904d32a9513fab5eed433" },
    { "DOOM2050.WAD",               "2a280604d8a416c225e6db343ba64268" },
    { "DOOM2REVISITED1.0.WAD",      "208de5a2605d77b62bbb2cd5ea1d6512" },
    { "DOOM3057.WAD",               "fa39d7267433cd7174f4ad12ba1d0ada" },
    { "DOOMARENA2.WAD",             "7df082dbdd80cf6ed7a3ff78c71ac83c" },
    { "DOOMCITYSV11F.WAD",          "3b9a7ef01687bfe556f2f24bbeebe3c0" },
    { "DOOMEDINVASION.WAD",         "21bf86983d0bd32fc5af553d10c750ba" },
    { "DOOMHELL.WAD",               "52ffa590033a019ec79bc891d30a1996" },
    { "DOOMMALL.WAD",               "168545f93159234f61f085b95e7d9439" },
    { "DOOMSDAY.WAD",               "8e34debb346a9acbae83037fae0ce28e" },
    { "DOOMTIC.WAD",                "2c7c6475fa70ac7e6e73650d05f6100c" },
    { "DOOMZ.WAD",                  "07aa92dbd3a13bba4a330bd682e068b3" },
    { "DOOMZDEH.WAD",               "7e5ecdd4ca5047b369e75a22878eb45a" },
    { "DORM.WAD",                   "e80919026fbfc7a1ec8bfd44a1c5a173" },
    { "DOUBLEBETA8.WAD",            "a9529c7912aa9bb9114542625c73d7ab" },
    { "DRDM.WAD",                   "0b15fffb480ddd38e692e0903cd05714" },
    { "DRDUDE.WAD",                 "94bda9972273fffdd55760ad59825d11" },
    { "DTSDMS.WAD",                 "3d4691346636ede3b861e83976cd7b0e" },
    { "DUELEX.WAD",                 "4eaf077f36ed3c80285719fadf6cb5b5" },
    { "DUK.WAD",                    "75bbf8a6ab278c4607d6daa25a6c4579" },
    { "DUKE3D.WAD",                 "270b90a9c61dbb1549dc1237cf459d91" },
    { "DUKEGP.WAD",                 "06bb4b82abda9cefb46581dc2d8b5bce" },
    { "DUKEHH30.WAD",               "9992cb1857c80dcafe3aa5a62eda5e31" },
    { "DWANGO10.WAD",               "cab132fd8f37a8ad93913e28af4397f2" },
    { "DWANGO11.WAD",               "a0cca9545070110627861c80da7db17f" },
    { "DWANGO12.WAD",               "137cf80227e926b8aebd276dfab6b23d" },
    { "DWANGO2.WAD",                "a49ea878449cb6073f09c1a16ec703c6" },
    { "DWANGO3.WAD",                "5e0095e3c2544de18b5ed550b4575a6b" },
    { "DWANGO4.WAD",                "f5bdf394ba89256956b5f3db98b1616b" },
    { "DWANGO5.WAD",                "333ca955620fd1678619e62976fb96bb" },
    { "DWANGO6.WAD",                "38e41ffff78afd4b1a75e198ae3f5a5b" },
    { "DWANGO7.WAD",                "82170841f48367ad87f6e81cb5ce58bc" },
    { "DWANGO8.WAD",                "f82487959ca92f466655f956feef01c3" },
    { "DWELLER2.WAD",               "ae031835efe0b36c618378a18d7ccbc4" },
    { "DYNAMITE.WAD",               "c34d16d9d7a38a48b209df258b70c9ba" },
    { "EAE1M1.WAD",                 "887c512fc2c13efaff91cf697b038a7d" },
    { "EDM.WAD",                    "caa0fe992c3405fd838f9a7209eae4b3" },
    { "EDSFX.WAD",                  "daa954ebef085cd4d40a4c2cc46d3718" },
    { "EI.WAD",                     "fa1d9ce240a09ca5d7f87da029fb7e6a" },
    { "ELEVATO2.WAD",               "0a49226ec622c5bc98eb961b70b1dcb4" },
    { "ENFORCER.WAD",               "c2f79573989ce9eb2ad973f2b4dd11dc" },
    { "ETERNALL.WAD",               "e8683fd3bf9af11859c8b2fe48a2cf7f" },
    { "EVRIPAIN.WAD",               "8c9e851931324d370fc1a2ae1e4903e4" },
    { "EWEPS3.WAD",                 "6f66504afa53cd4e35609c2e3d36b711" },
    { "EWEPS4.WAD",                 "9ed726e0c9ccf100532fc8ab927bed57" },
    { "EWEPS5.WAD",                 "715935b5c9ac14632ca4cafccd72ea29" },
    { "EWEPS6.WAD",                 "a3b8cb6a0d1ca1b435c3320a01474ca9" },
    { "EWEPSF.WAD",                 "7747255e133216c48c8cd6d478532418" },
    { "EXEC.WAD",                   "3dd514a851af4360971c793034c10d6a" },
    { "EXTERMIN.WAD",               "d732add4844816a1535a39f563399e08" },
    { "EXTRMONS.WAD",               "f71b1307a1df4459347d67e7fc3251fd" },
    { "EYELESS.WAD",                "dfb9e15b78768f3024d850fc92d88921" },
    { "FACEVOX2SE.WAD",             "c617e60a01dd970824c943d4e08c48e9" },
    { "FACEWAD.WAD",                "047b0ed054966eea36e4ec64672cf5aa" },
    { "FD.WAD",                     "0c2235c60f9c348144322ab98ff5eb9b" },
    { "FDMV0.1.WAD",                "f90fb0b16e51d78b21e033dec5c691b4" },
    { "FDMV01.WAD",                 "f90fb0b16e51d78b21e033dec5c691b4" },
    { "FDTEX.WAD",                  "4007dd1ef42d5c19539f46939140c574" },
    { "FDTEXTURES.WAD",             "3e49ad6a956ee8a4af2ad4c6c320e3d0" },
    { "FETALDM7.WAD",               "d5dbb880e082c4642acc086e3b7f53c2" },
    { "FIRECITY.WAD",               "001c86b73008504083d6e34721f5bc7a" },
    { "FIRSTIN3.WAD",               "b4e8bbf7a21b6dc4665a5f9e1454ce2e" },
    { "FISTINGV02.WAD",             "94fb74d6b4504d6e1162ee7dd59b62c7" },
    { "FRAGAHOLIC.WAD",             "51fe4f9f12929245046db2e27b94eb05" },
    { "FREEDOOMPW.WAD",             "07cdeb209921df5e0e88a7988ff98afe" },
    { "FWMOOD-PREVIEW.WAD",         "ad9aec3fedf4df5cac99c2ac69ff3891" },
    { "FXDMS2.WAD",                 "619397f154dc11ec8d66b01f6ddb3de2" },
    { "GFGAIDEN.WAD",               "d716ab731c4218f27950b0414b99b060" },
    { "GFX.WAD",                    "ac3ef941814c9f14630850764607f97b" },
    { "GHOUL2.WAD",                 "dcfa296026b39f93dc96d9eb569b39f1" },
    { "GHOUL2B.WAD",                "a5079498df9ca43ca4d20bd07a4ff14b" },
    { "GHOUL2ST.WAD",               "50e7ff20cc8449471a7ac91171c36948" },
    { "GHOUL3.WAD",                 "db9139b2dd47f69fbc95c2d2663b4ac6" },
    { "GHOULST2.WAD",               "c01a84c8ff8d0d13976da08c554c631a" },
    { "GOBLIN.WAD",                 "5ebf29925e0c9a236d35f588084e4205" },
    { "GOTHIC2.WAD",                "64b013283d3c61542730190c9efa70d2" },
    { "GREENWAR.WAD",               "10fddac0b2a714eb9a02a8f172e4a28c" },
    { "GUNX.WAD",                   "a63154516f68ebf273b58b47804655a2" },
    { "GW2A1B.WAD",                 "da5737b367c318b7ef50ef65ef1b1e02" },
    { "H-I-UAC.WAD",                "4d376b6fc90776f9b0affb71c95da970" },
    { "H220WOOD.WAD",               "c41b6827484fe86f1c3649f62d73a80a" },
    { "HAHAHA.WAD",                 "c29234b8131c3aa1eb432c2110ae0bdf" },
    { "HALOGUNS.WAD",               "a71ad88dbce913be1ace92d06e604402" },
    { "HALOLVLS.WAD",               "e1f362aaf31d6d6453910ff49ed43d05" },
    { "HALOWEEN.WAD",               "3f0f91d8cb21071ef8cfbb5a9df360b7" },
    { "HATE.WAD",                   "08f50fc84ddb2e5f2047a32bd4e749e6" },
    { "HC20MP_FIX_V2.WAD",          "c422160ac003ecf342343d0f41e5cff0" },
    { "HDMA.WAD",                   "385fad0a0b9643cfdb576b7e9f0d75d3" },
    { "HELLTEST.WAD",               "4ac6653fc8a2a6950c364f9aabab069f" },
    { "HEREDOOM.WAD",               "1fb04247a9357a6fabb8aa98eabe20c1" },
    { "HERETIC.WAD",                "e7cd203b59f0ce3240a6f6bd3ead0f69" },
    { "HERETICCTFPATCH.WAD",        "4d71a3b09c18a80847605fe6e4704416" },
    { "HERETICCTFPATCHV1.WAD",      "2d23c91a7549f2868ad44ca570219cb1" },
    { "HERIAN.WAD",                 "76d5368b70fd87962d755d21cb96bbab" },
    { "HEXNDOOM.WAD",               "eaacf5708e31947e3677ea33fb0734c6" },
    { "HEXPACK.WAD",                "9052b0c9013bd23370fe711a75e813fb" },
    { "HIDENSEK.WAD",               "dc2eac571ac3040a649b7de53b75a351" },
    { "HLD2.WAD",                   "a3e18539de093751df168cace2537dc6" },
    { "HLTRSKLT.WAD",               "c6c1272d82f3871bc610f03cfd6d7b7e" },
    { "HOUSEMAP.WAD",               "fcc7562e71f00f3fc2f32291a7314762" },
    { "HPSBETA.WAD",                "b0126363f071a257561b5d69d884013f" },
    { "HR.WAD",                     "bb04d6c30c4bbee580063808828ea2da" },
    { "HR2FINAL.WAD",               "dad338e1968aea4df05d465e864d78f3" },
    { "HRMUS.WAD",                  "b80ebf10d3504742faa756ff705375ee" },
    { "HRTESTWAD.WAD",              "c0d5ad79c5c60c8322964d12e21d082f" },
    { "HTP-RAW.WAD",                "ba4d2564c72f7ec963be2f02c3c3e5f5" },
    { "HUGEDM1.WAD",                "81571ff35a643ec53f763398e496c299" },
    { "HUNTINGSHOTGUN.WAD",         "d00f4db54b260ccab127a7ff7710d402" },
    { "HUNTINGSHOTGUN_ST.WAD",      "d9725bce357fdb8388f2456192052222" },
    { "HUNTPACK.WAD",               "4401824392a3577091c771eaedb54e20" },
    { "ICE.WAD",                    "8743ddd5840bc11ff2dbcfc775916e15" },
    { "ICEMOUNT.WAD",               "cf5e57450f500000e874d9621318da18" },
    { "IMPSED2DM3.WAD",             "b0c57b2fcc88c207f43347c927c76ed2" },
    { "INACT-SE.WAD",               "cbff68acdd68b01505fdc902d100c955" },
    { "INVASION123.WAD",            "84c273ce5d0aa301c7bc24bb74079775" },
    { "INVASIONOFTHEGATEKEEPER.WAD","3a806e12e0479dcfad98de80d0d57256" },
    { "INVASIONPACK.WAD",           "c1446e8969dabec14a8ab60af7f6e9fa" },
    { "INVASION_UAC.WAD",           "02f765b4c9bf72a14b7bc0d3ab262274" },
    { "INVASION_UAC2.WAD",          "ecdb7be3a775ba6be41f74e54996f3e5" },
    { "INVB01.WAD",                 "8cda8c16b1d7b48007e2112f00e3cb4d" },
    { "INVENTORYFIX.WAD",           "c9836a0deebe2f4a74fc66eff3430fa5" },
    { "IU-PART1.WAD",               "ecbe7acc2bc3914488d410668db3c0ee" },
    { "IU-PART2.WAD",               "49f4ca5831cfaa39c79b4fe407c490ba" },
    { "J-O2DEMO.WAD",               "c7d47225836477b06c4c0d3c79f83607" },
    { "J-RIFLEMODST.WAD",           "f36a6cbbc942874727e16c33cf150b4d" },
    { "JCMS6BETA.WAD",              "49b316402b50dcef863b85548c841cd1" },
    { "JDMCOM1.WAD",                "fb29d04dc8c04178a345e7ee71377055" },
    { "JDMCOM2.WAD",                "4bb07e8277577163957253ff0802821c" },
    { "JETPACKMODV1.WAD",           "7bbe7a83afb7dcb818cbd84b7ad3aed8" },
    { "JETSONSFALLS.WAD",           "201f78dcbbecf1ee1429fc776915dfe6" },
    { "JUDAS23.WAD",                "37afda7a49e02d9c70c76203c3820670" },
    { "JUDAS23_.WAD",               "bdc5d42776064a44da859026f289207c" },
    { "JUNKIEBETA.WAD",             "9614a1892422a9711d5eb10b0b30abf4" },
    { "JUNKIEMAPS.WAD",             "cbbc70f72c37cd164ce4bee9afa1d898" },
    { "KG-VOMIT_1-2.WAD",           "38236119aa633306afba2ddd9e85087b" },
    { "KID_DUEL.WAD",               "21554f03e8aedcdd6f7bb47f053027d4" },
    { "KILLZONE.WAD",               "260c78a5883a561f65b0ce56632a341f" },
    { "KING1.WAD",                  "a675ccd9d4e86a63b8f27efba8e5d521" },
    { "KINGOTH.WAD",                "41884b073e26de7ecf5a75b0f5f010fe" },
    { "KINGOTHDB3.WAD",             "29066006eae94823917cdc512428b622" },
    { "KTCTF.WAD",                  "fa128b84d6c382c47f47fdc5cd72e328" },
    { "LAMBADA.WAD",                "58ba59d16a498dfc4f888606e76f0ef0" },
    { "LAZARUS1E.WAD",              "4ade16851c866965e9da82f891853c74" },
    { "LDSPRTS.WAD",                "4666edfe0037e808fbba366b55480ac9" },
    { "LEGOTEX.WAD",                "ad9692edfcb7bb035780fe714b8f8e30" },
    { "LESION_FIN.WAD",             "5bb8b75f411df6c46dd41d1aed179b3b" },
    { "LETHALDM1.WAD",              "378d64432de305872d005efb1169893f" },
    { "LETHALDM2PREVIEW.WAD",       "e060b40ebe02aeac6fd8109380997be4" },
    { "LIT-B1-2.WAD",               "33f4d941d2767bdaa9e8e40d0ab5fc06" },
    { "LIT-B1.WAD",                 "5a7211490644146bc88d8543c0f31432" },
    { "LITEHOUS.WAD",               "eda87ed38558e498323723e2277429de" },
    { "LOL.WAD",                    "20f54d1ca307e746f2756eb7f2e99334" },
    { "LOPEZDMV0.WAD",              "e0d3f0455f8d3b34a3992a37e60dfdfc" },
    { "MADCAT.WAD",                 "ec01611faa6eabc44ea7935bdf96564d" },
    { "MAGNETIC.WAD",               "4f52f6c2ccdcb1ec88c90ee0fc2d6ae7" },
    { "MAGNUMBAN.WAD",              "7440ab94cd9e12ebedf0c4a19a515b05" },
    { "MALICE.WAD",                 "855b37bd0e8fb683c03152ce75ce7d5c" },
    { "MARIOFORT.WAD",              "b3551dc72b17235b8805903aa3c91399" },
    { "MARIOFORTINV.WAD",           "833375555f44029530c373f27c207d35" },
    { "MASTERJUMPS.WAD",            "11bc187fec26e4c25cdca524b4c6b2b8" },
    { "MASTERJUMPS2.WAD",           "cbe81553d13ff502ce1fbe1409962070" },
    { "MASTERJUMPS4.WAD",           "7c85ef88643723f94a1f148682348b75" },
    { "MASTERJUMPS7.WAD",           "732879649ce8a68a987bd00c7830db30" },
    { "MATIDUEL.WAD",               "a8af18a21fc59cdaf81bfdc74f1a2e85" },
    { "MAZE.WAD",                   "82be7993d8e4a1953b51a6fa47e5fad5" },
    { "MBETA.WAD",                  "3f34ccd47dc96bccc99d40783b82e006" },
    { "MCSD15.WAD",                 "5147fa6e37952499a0b6c2fbae8b06b9" },
    { "MDV1.WAD",                   "462c00c0f132e099bd019454b010b0e0" },
    { "MEDIEVALPACK.WAD",           "aaa63163bc6567e50c6ab884bd8682c1" },
    { "METALICA.WAD",               "ce5e0a647ad0047e2c015afc54510711" },
    { "MICROCITY.WAD",              "2a99a6e33d91f5ea3731e78d7bc8bb4b" },
    { "MICROCITY2.WAD",             "02f1fb88f9d2199b12fd86edbdccf08f" },
    { "MICROCITY3.WAD",             "0207d472bae96785565b8b7c6b871dc3" },
    { "MICROCITY4.WAD",             "82018c9f4dd7fdfe7a6660cca8e180b7" },
    { "MININGTUNNELBETA2.WAD",      "1c6a5dfc85d902efd33856070580563e" },
    { "MISTYFALLS.WAD",             "9c7242eb3972f63d03dc08586ec64274" },
    { "MKDOOM1.WAD",                "35eaef8853a40e8968768109c73dbc16" },
    { "MLDBETA1.WAD",               "2430c30bf89bb21dc8969a233541ba60" },
    { "MLDBETA2A.WAD",              "e7d1b64c34e179d99f1f97aea099a549" },
    { "MM2.WAD",                    "83414913d5c5c1685d633b7138cda387" },
    { "MOCK2.WAD",                  "88ccea5b42b47e9e60428397ee1b8327" },
    { "MODDEST.WAD",                "e17ef091ec7c9486f8e319b080aa8d81" },
    { "MONSTERS.WAD",               "8badfcb8fce6882b044db080788860ce" },
    { "MOO2D.WAD",                  "2e4635df68da25f78fde58ab179b8c2c" },
    { "MOUNTAINWARCFT.WAD",         "2dd89f8b70461d7bae7ef54f1e3f991d" },
    { "MOUNTAINWARDM.WAD",          "a87b7b803af951bc72daea698abc0962" },
    { "MP.WAD",                     "667e200038a3e7626901e58c54a0486c" },
    { "MP1.WAD",                    "75fdfadf510582e71365f5fdeecf725b" },
    { "MPH1.WAD",                   "f500220c9ca0f6139d7a92a2d20b2508" },
    { "MRNVSHYB.WAD",               "54cb8dc31c931bab8f27d72566a478b2" },
    { "MS_CTF.WAD",                 "9cd3e79bf3c80d8b623808889ab4d537" },
    { "MURDERUS.WAD",               "c651c7ea771f6f9c359abb0af47fae50" },
    { "MUS.WAD",                    "c64c31e6fabbb72d1e5df2f66d2dea49" },
    { "MUS1.WAD",                   "59dcf378fea1bbcd3bccc66414339d50" },
    { "MY DECEMBER BRIDGE.WAD",     "0963dd434e3f4e3c2e69f4f7f8a40b8f" },
    { "MYCOSFINAL.WAD",             "7a37539c1a6686dfb6eb83ceb0bd2936" },
    { "NAZIMOD.WAD",                "704db93c031460ab2fcf03ba6ab9ffd7" },
    { "NCC1701.WAD",                "bf8fd18437afc991fa8d130b323de3c3" },
    { "NHCOOP01FIXED.WAD",          "a8949fc5e359c863ae694fee03b651f0" },
    { "NIMRODPD.WAD",               "94541175523fa836b1f2c0e1eb4d6639" },
    { "NIMTSP.WAD",                 "58b2f20518ff7280dc83d3eb30a03980" },
    { "NITEMARE.WAD",               "5b88b12d2632d6de113905a81fcb9833" },
    { "NOVEMBER.WAD",               "d609e1f4c24119b5307d1b818806365e" },
    { "NSEXL_A.WAD",                "b05620e23bc849748fc1e03200182252" },
    { "NUTS.WAD",                   "b00ef970f68039205657e904df40d209" },
    { "NZAUFPATCH.WAD",             "6ca3daa34f2301f8395807d31770da08" },
    { "OBERON3.WAD",                "dd4888d784eedcd99f18bf7b95237f6d" },
    { "ODACTF1.WAD",                "8f797b57ec26507447395c2f339af019" },
    { "OFFICE.WAD",                 "62acfd4ec3bc29d208ef831da82f3193" },
    { "OMGMAPS.WAD",                "b13886f61bbcc7aa117c407caa998c67" },
    { "OMGWEAPS.WAD",               "38db09381a08ec7a43a6e6b52c6a6290" },
    { "ONIRIA.WAD",                 "b58d12646903e98e023038387cb1c311" },
    { "OUTPOSTREDUXDEMO.WAD",       "c6efdf67a943264a9de3a4fa0318fe98" },
    { "OUTPOSTREDUXDEMO2.WAD",      "c91d29b2a194af9e2e4bdd611a4373d2" },
    { "OUTPOSTREDUXDEMO3.WAD",      "419667316a02d80e91d8797ad97eb3b2" },
    { "OUTPOSTREDUXDEMO4.WAD",      "6bd71a13e610372e3384ef00d6055f37" },
    { "PAFINAL.WAD",                "9176fed017036158ef0ccdd1564cbce6" },
    { "PARTHORIS1C_.WAD",           "8728948ea92248ff70732b08cb24760d" },
    { "PG-RAW.WAD",                 "22bde2b7714c4e059a557c009666265f" },
    { "PINKCACOLANTERN.WAD",        "77cf33b972fa06033ae4eec8afeb25a0" },
    { "PKST.WAD",                   "502c1671c69f8843aa55de3965e14955" },
    { "PLASMAPACK.WAD",             "9febd2541f6c2171432bfb9437fca489" },
    { "PLASMAPALETTE.WAD",          "d404720a91470b55922cdf5b18c2ec05" },
    { "POBLA8.WAD",                 "c0979a9bb638b99514a2185e17500884" },
    { "POWREMOV.WAD",               "63b1f665f70f4beb1af0ee44d93e85fd" },
    { "PP-PR5K.WAD",                "78ea9388c962b0bd709a9f821c862811" },
    { "PRJUMPIN_01.WAD",            "cb747c0126df371f372da56200cba922" },
    { "PROVE.WAD",                  "3d82f84d08099fb838d4a744afc8c6d9" },
    { "PYREM_V03.WAD",              "8784f3d416eca26afa2ee038fb3ab1de" },
    { "PYTHON2.WAD",                "7ac3cd0a3022c4088f28504b70d7263d" },
    { "QKEDOOM.WAD",                "aab4f574f0e7b050d53083f6aed24b8f" },
    { "QUADNOBFG.WAD",              "8b796529400037dc84bb506b47bf1d7d" },
    { "QUAKE2.WAD",                 "d2f9bcd883979533e4bf0346e2f66ce8" },
    { "QUICKDM.WAD",                "d41d8cd98f00b204e9800998ecf8427e" },
    { "RACE.WAD",                   "5f79b82322b0b7d1bd48e0a1c442b92f" },
    { "RAVENMEC.WAD",               "94776a6d941f4da169cc651419991d95" },
    { "RBCTF.WAD",                  "60f52322262d75585a05d0b6c48a569b" },
    { "RBDM97.WAD",                 "f2502f1973e30a8cc792e2732dc0130b" },
    { "RCMT_DUEL&DM.WAD",           "79601e0b4deea3e51678212502919a19" },
    { "RDOOMERSHQ.WAD",             "68bb1e0b0ced7d3b9232ecec77b48913" },
    { "RED.WAD",                    "3fd1b86e27588d80a90f4f81c6066900" },
    { "RENEGUNS.WAD",               "a4d65eaa9d32e9fb891fbd9b5c65a62c" },
    { "RENEGUNSFINAL.WAD",          "de0d875e373041364f05e97a05388a3a" },
    { "REQUIEM.WAD",                "f5bdfb5a32ead6f8c642fc13555074de" },
    { "RESTINPC.WAD",               "f11a673464ecf94f146140c2e4ae7715" },
    { "REVENANTSKIN.WAD",           "b2b587523903187a13cba40e137ffd75" },
    { "REVENANTSKIN2.WAD",          "2aa8205d3d0e4947bd5cdcef1e30a2db" },
    { "REVENGEDM.WAD",              "d915e8682f6a3106db7f64cb521e2603" },
    { "REVOLT.WAD",                 "d2a0ccdfa621474962515e8f53777eba" },
    { "REVOLTSBOTS1.WAD",           "70cb186b55908235bf489a10deaa7fc2" },
    { "REVRUNN.WAD",                "a2936b4eccfb7596363dd09990152499" },
    { "RG-B1.WAD",                  "2a0775541ef6239a9494f55fc236e527" },
    { "RG-B2.WAD",                  "53440261d77c25ef3bb04cd75e6a4def" },
    { "RG-B3.WAD",                  "208aef80171ffea0688154ab6e83ec80" },
    { "RG-B4.WAD",                  "bf48d2f3ae72b03536b3fd51a74ca871" },
    { "RG-B5.WAD",                  "2107d77b86aeb04e379c281fddd3acfc" },
    { "RGBSDMV1.WAD",               "c066ac047a90d804fcb034281b64f119" },
    { "RH.WAD",                     "8be44de68de69ff6ce256b9d3cb9496c" },
    { "RJSLOTH3A.WAD",              "06805ebeea1a14f11c2b7fcc1318e596" },
    { "RJUMP2V6.WAD",               "667086b81e24d7bd57b7c1bc156f3f2d" },
    { "RJUMPQ.WAD",                 "de08b15931525f7d89a27f4273a8db46" },
    { "RJUMP_N1.WAD",               "31c677674b0a3e0f638ac71962b7f141" },
    { "RL-PL-BFG-UPGRADE.WAD",      "f4171c4a3e2bf81508dff64b7fcd4a08" },
    { "ROCKETARENA.WAD",            "1e5ec0b90568bc007aad39454a53fa09" },
    { "ROCKETRIDERS.WAD",           "eb57b20a25c07f122e5bc6c728b504d8" },
    { "ROCKETRIDERSV2.WAD",         "a116fc7fe40734ab52be8aa0bed371a5" },
    { "ROH.WAD",                    "510acbffced943596c74378668f78f34" },
    { "ROKSDMST.WAD",               "f31390a8ba2a4ee090ccfbfb330c2567" },
    { "RR-HQ-01.WAD",               "5905de543497f3ac0970a6de6f5d892d" },
    { "S093UFO.WAD",                "6089fa21fff1f9794577661e90605b23" },
    { "S6BETA.WAD",                 "557f968c3d51f75eb4aaaffbafec7763" },
    { "S6BETA2.WAD",                "4de86c534750bd7db5088bdc21afee6d" },
    { "SAD01.WAD",                  "65bec615ffac7efb090bb82dd50b3a16" },
    { "SANDSTORM.WAD",              "33f715f852d113d9a8215030c5365e99" },
    { "SBBTMRTR.WAD",               "ce16d70c8dd5828bccffb67516cf3956" },
    { "SCYTHE.WAD",                 "3131213a9413a604c5c160848ddb3d9d" },
    { "SCYTHE2.WAD",                "0bade1ab0e0abb2d995f853ee10fa052" },
    { "SDM.WAD",                    "c36f6f90dca0c1f178b34edb57b9b498" },
    { "SEABASEZ010.WAD",            "886f1c2e5711b90221993e8408770bcb" },
    { "SHILDMOD.WAD",               "fd15e46a4e136f275f27cab8831ea1b3" },
    { "SHITWADBLIZZ.WAD",           "2b51ffc070d40e0ae39a2860d26ba10e" },
    { "SHITWADBLIZZ1.WAD",          "74d9bdbd4afa45ead9f452a016d6e27e" },
    { "SHITWADBLIZZ123.WAD",        "5a7c073366fa481ed5a90edd85a0e637" },
    { "SHITWADFINAL.WAD",           "70d797ca225be1782f8565f4bc24020a" },
    { "SHITWADFINAL2.WAD",          "16ae758dc1804110de8049f3c849478a" },
    { "SHOOT!.WAD",                 "8deb3933822232a820c14b51132471d6" },
    { "SILLYWOW.WAD",               "6c9c00497ba131b35a3f5a1881558cb7" },
    { "SKINS.WAD",                  "c071230f120b46625c412bcb1ea30617" },
    { "SKIRMISH4D.WAD",             "a9226195ac81f630aed7db9077e13e8c" },
    { "SKULLDIZZLE.WAD",            "af2cae1c61b2ca63fcace08d6060d294" },
    { "SKULLVOMIT01.WAD",           "479215ccb1ab79f5db2e5fd4708763b4" },
    { "SKULLVOMIT02.WAD",           "79c8ce19a7df07af2cf2d2b145af38ac" },
    { "SMDREMIX.WAD",               "b386204ac1df58eb3ca9f10a14d9650d" },
    { "SND.WAD",                    "898e607a9af4193e38b412b187a56ece" },
    { "SNEAKY.WAD",                 "a257692ad259d97baa51e7e64527f4df" },
    { "SOMESKINS.WAD",              "974e2598309527d59f6f99d2645a21ea" },
    { "SONICMUSIC.WAD",             "b4167c638b0d8b0e69d609f71dd20bc9" },
    { "SPACE STATION.WAD",          "6d94654d8ebbdf0069f2af717497b887" },
    { "SPACE.WAD",                  "6d94654d8ebbdf0069f2af717497b887" },
    { "SPACEDM5.WAD",               "61f20f855406164733d8a6cf63ccc2c3" },
    { "SPACEPORT.WAD",              "bf7d55e18a7155b9d2c9984ed227ce95" },
    { "SPEEDMAP.WAD",               "f4ba586a2aa949bfd8a6c576ddcc206e" },
    { "SPIRITCAVE.WAD",             "77235f67b40076026526cdbf85706cfa" },
    { "SSL.WAD",                    "77ee0ceb67354f7322cc7e4db077564e" },
    { "SSL2.WAD",                   "e5d863c72e1f5de577a3ae57745c107e" },
    { "SSL4.WAD",                   "81202c2065c899885b388fb93f902785" },
    { "STARPORTSHOWDOWNX.WAD",      "e7eabefccc91ee3168898f95230af1a7" },
    { "STBFG.WAD",                  "c14d95a7a20d8c047b7a8f3fc0b90a76" },
    { "STCTF.WAD",                  "62743c81e2530edcbdb43c82587d82ef" },
    { "STCTFMP.WAD",                "c6bc2b2fe25ec3d489d4e9d7b1ff723c" },
    { "STCTFMP2.WAD",               "de6886c49163f10fbdfadd40c49b85ff" },
    { "STDOM.WAD",                  "73b6ee7c3ea121f60fe3ff7fbd18c325" },
    { "STEALTHFINAL.WAD",           "979775e3c4dba6642e1d4f72106d1c0f" },
    { "STEALTHMATCH2.WAD",          "d66a6157cd38ce058a72f1118b1eee5a" },
    { "STEALTHMATCH3.WAD",          "0c21969e9d1ae50ae8a856b0476ca7a7" },
    { "STEALTHMOD1.WAD",            "f7c59a8f49d29922ad99f725ed0359b0" },
    { "STEALTHMOD2.WAD",            "d6dd42579b150f0d02d7f62a0f4a7992" },
    { "STEALTHMOD3.WAD",            "c9e6e94f02e1ed5459357b0b602a59b2" },
    { "STEALTHMODFINAL.WAD",        "eca8de9749f4903335517cf9b81dddc1" },
    { "STEALTHMODVCAMP.WAD",        "4d2efda1d9cacd23f1d2c6589fca7b51" },
    { "STLMSV3.WAD",                "bd9cce05fe7c95aa63ad22f60cea9d80" },
    { "STORMTEMPLE_V1_SMII.WAD",    "d41d8cd98f00b204e9800998ecf8427e" },
    { "STPLASMA.WAD",               "dcd23be5eb40373ba3ba87508511db6c" },
    { "STRIFEDM.WAD",               "bc8f245eb02ce834098c26cc404d3ad3" },
    { "STVOX1A.WAD",                "b6c4196f301f7e5785af99b1acb49e9d" },
    { "SUPERDM.WAD",                "b2154893f0fe6b2da6e6c180ac4428d1" },
    { "SUPERGUN2.WAD",              "bcf579661270d951124e3c74b76bbb5b" },
    { "SWCWD5.WAD",                 "c274bdf5d78304ab037eb0ad811e1b08" },
    { "SWW.WAD",                    "190d6f7093f66eff6b77d3021105945f" },
    { "T-TEKNIK.WAD",               "03730dd81c89f0fe646196df6ae22115" },
    { "T114HTAL.WAD",               "b158b7310be0f2669e421979739b530b" },
    { "TBCHQ-JAKE.WAD",             "5d7f742ce258be721297d744a1086bef" },
    { "TBF.WAD",                    "332d3b81646cb67c900dd2bec9377689" },
    { "TCD.WAD",                    "09159be7b47c67dbf91e5782c741d743" },
    { "TFX_RB.WAD",                 "7bd160ae7d8b5d4a61f7cbcd5a504e11" },
    { "TFX_V1.WAD",                 "afb0b14ae9ff1bced985703a634030d6" },
    { "TFX_V2.WAD",                 "d3cb4706a703d5d51591cc3c85e3e38b" },
    { "THECRYPT.WAD",               "2b498396a56a97f9def62fd039820bdc" },
    { "THEDUELV01.WAD",             "e5b364d725516a67955fcfbcb949963e" },
    { "THEONETOUSE.WAD",            "88c32a1809f4e857e166ddb69b418eab" },
    { "THE_XI_SECTOR.WAD",          "b16400ba29848279c96c0700bd5b16d1" },
    { "TLSD2004.WAD",               "1ed8a96147291262ff02f8188606efd0" },
    { "TLSD2004A.WAD",              "17b02536879ceb6dc1a7381e1eb9e8af" },
    { "TLSXCTF1.WAD",               "0af8b239b239b2adbff494fa4c604622" },
    { "TLSXCTFST.WAD",              "28572cf299a4bdeed84e49ea09235daf" },
    { "TMNTSKIN.WAD",               "7c6dacaf3c5bef8474f795e3b46afba7" },
    { "TOURETTES-START4.WAD",       "aa0219c4c4d52af34c61f69e9890f133" },
    { "TSKINS1E.WAD",               "47045cc91d4aa65ea8c681fcec3e4a0e" },
    { "TT1024GE.WAD",               "7eaa54d17eb1c8c070717d463a2aa9ae" },
    { "TTGRP.WAD",                  "3f7a6d1cb56175d69bad1ebcf3002dae" },
    { "TTM.WAD",                    "056edcf2c05dfcf8ccfa4bc124d9f2b7" },
    { "TUEHQ031.WAD",               "dd3c2480cf827616de134bc71876c277" },
    { "TUEHQ4.WAD",                 "4758c965328e3f8f161340b8dff181e1" },
    { "TWILIGHT.WAD",               "d1039c00bcae4ffe43c29160a85aed22" },
    { "UACBINV.WAD",                "d5695c4592fb14423e66a3aa1a1a4c8c" },
    { "UACMCV1.WAD",                "6104a4c4b4257fe4ef05e58038f03a99" },
    { "UDM1.WAD",                   "bec209759eab1aec9321dbbc935f1785" },
    { "UDM2.WAD",                   "06f1883ea108665f03ae191d0b402222" },
    { "UDM3.WAD",                   "3ad094eb5412bb1c711c438a3b0c4eb2" },
    { "UGBENNGOLD.WAD",             "b5757e4cf8e24e60dd1fdf4c034c2852" },
    { "ULSIMPDM.WAD",               "d3b8e57c757308aee139b1b77c1c0f31" },
    { "UNGAYST1.WAD",               "b3e7eb45f1318b643bb825e0fd6415cb" },
    { "UR-BR-M1.WAD",               "66af832bc56b77a91ad1561b361cc06b" },
    { "URBAN.WAD",                  "e5bab59178cdbfff4e1755d7cf2117cf" },
    { "URBAN1.WAD",                 "5e67d7472e3f8b18f25cd7983a6374f6" },
    { "USTAR23.WAD",                "6b75954fca3042747e9ae2e7c6dc6e0c" },
    { "VERT][_V01.WAD",             "ff8f38dfc81f789e28a7c51c6752a15b" },
    { "VERT_V01.WAD",               "0581a8c254388cb5a37781047e180610" },
    { "VEX-DOOM.WAD",               "1905b2a4fa71d9258b4636d7a69ff0d9" },
    { "VEX-SKULLTAG.WAD",           "d4f7ad60f9e0a7a6156f6a13a4887f56" },
    { "VLAB.WAD",                   "b2053e1f92a8508c14aa51e65f05ebf6" },
    { "VOIDJUMP1C.WAD",             "4f6a22c20e4ef7c950052fb52e4e3594" },
    { "VOLTWARRIOR.WAD",            "66b59062085941e3945834b9ddbc2308" },
    { "WAGICAVE.WAD",               "aec6a286a23923c872802ac8de44cd06" },
    { "WARZONE.WAD",                "e2398bc9afc046b9b2c5bae3756b693c" },
    { "WICKED.WAD",                 "2150a168ffc7b06b42bcaa572f76d7c5" },
    { "WICKEDGORE.WAD",             "9b00536b9a940b91e59b2a12bae5a0e5" },
    { "WLFDUEL.WAD",                "89049264f687042ddbc945f5ead7c27f" },
    { "WOLFMODFINAL.WAD",           "930d897ef21ab92d7978cf83350b9980" },
    { "WOLFMUSIC.WAD",              "e2900c6d8d479d0916d86ad5016eb336" },
    { "WOOTAGE.WAD",                "8216bb24f5db95e9a2436012b5d45897" },
    { "WOSA.WAD",                   "469a6e93ec78528fc0c604267d3f1e61" },
    { "WRW.WAD",                    "b800abac3445b4b90ec25172512f58ef" },
    { "WRWDEMO.WAD",                "a1ec9f1de6d4fb373411889c3f92e4b6" },
    { "WTFEXP_BETA.WAD",            "038d9960bdfcf93bdd12db984b0b9113" },
    { "XDCDM01.WAD",                "4fcbd5ba5befe3fcad094f6584e17176" },
    { "XDCDM02.WAD",                "a8730956dbd5b76fd33539a3c590c244" },
    { "XXX-MERCENARIES.WAD",        "82afc271d56d2870fe1d577879eec92d" },
    { "XXX.WAD",                    "73521b3943bd4cef20dcee55ea2bc98d" },
    { "YOSHISKN.WAD",               "6319070a855a39f8163a1b14de58270c" },
    { "ZBLOODMOD.WAD",              "893f256c8553bdc6f63f9a266175c2e5" },
    { "ZBLUDV33.WAD",               "bea1b3754c6e22dcdf2ecb55e7e57577" },
    { "ZCTFCONVST.WAD",             "d4ee2df2f2a5b0003bc3c16bc02dd7c1" },
    { "ZDCTFMP.WAD",                "e739adb34bef310311bbb50d6711646b" },
    { "ZDCTFMP2.WAD",               "3359d1560874812fabd41fd9619b1dc7" },
    { "ZDCTFMP3.WAD",               "68300bc9fcf6f124b618a069a5d6911b" },
    { "ZDOOM.WAD",                  "df37786331b390a5fda6b06daae954ce" },
    { "ZDUCTF.WAD",                 "2a214ba61112a7927196b1c3d964b0fd" },
    { "ZHCTFRES6.WAD",              "5feec67310fcd07776513b3fe17ccada" },
    { "ZHPCTF_F.WAD",               "6a3b8c01570eb80485a3196a728a8f0e" },
    { "ZMAS2K5_FINAL.WAD",          "8e28038550fada4168e98b360829353b" },
    { "ZOMBIE.WAD",                 "8e6316489db78c6f273b1631a6080ee9" },
    { "ZVOX.WAD",                   "c00e662405992561cbcc8d40712aaaff" },
    { "ZVOX2.WAD",                  "081a2c8b5b34506633cf489a6223d085" },
    { "ZVOX2ST.WAD",                "f66c009868a000b730fa2cabbd38d624" },
    { "ZZDOOR2.WAD",                "80d57581fdda9394c76189f539b38d49" },

    { NULL,                 NULL }
};


