/*
 * @(#)Curves.java	1.16 99/04/23
 *
 * Copyright (c) 1998, 1999 by Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Sun grants you ("Licensee") a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Sun.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
 * LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
 * LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
 * INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
 * OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * This software is not designed or intended for use in on-line control of
 * aircraft, air traffic, aircraft navigation or aircraft communications; or in
 * the design, construction, operation or maintenance of any nuclear
 * facility. Licensee represents and warrants that it will not use or
 * redistribute the Software for such purposes.
 */



import java.awt.*;
import java.awt.event.*;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.font.TextLayout;
import java.awt.font.FontRenderContext;
import java.awt.image.*;
import java.awt.print.*;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.*;
import javax.swing.*;
import java.awt.Color;
/**
 * CubicCurve2D & QuadCurve2D curves includes FlattenPathIterator example.
 */
public class Curve{
 
    private static Color colors[] = { Color.blue, Color.green, Color.red };
	private static Color _color;
    public Curve() {
        
    }


    public static Graphics2D drawDemo(int w, int h, Graphics2D g2) {

        int y = 0;
        g2.setColor(Color.black);
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout("QuadCurve2D", g2.getFont(), frc);
        float xx = (float) (w*.5-tl.getBounds().getWidth()/2);
        tl.draw(g2, xx, tl.getAscent());

        tl = new TextLayout("CubicCurve2D", g2.getFont(), frc);
        xx = (float) (w*.5-tl.getBounds().getWidth()/2);
        tl.draw(g2, xx, h*.5f);
        g2.setStroke(new BasicStroke(5.0f));

        float yy = 20;

        for (int i = 0; i < 2; i++) {
            for (int j = 0; j < 3; j++) {
                Shape shape = null;

                if (i == 0) {
                     shape = new QuadCurve2D.Float(w*.1f,yy,w*.5f,50,w*.9f,yy);
                } else {
                     shape = new CubicCurve2D.Float(w*.1f,yy,w*.4f,yy-15,
                                            w*.6f,yy+15,w*.9f,yy);
                }
                g2.setColor(colors[j]);
                if (j != 2)
                    g2.draw(shape);

                if (j == 1 ) {
                    g2.setColor(Color.lightGray);
                    PathIterator f = shape.getPathIterator(null);
                    while ( !f.isDone() ) {
                        float[] pts = new float[6];
                        switch ( f.currentSegment(pts) ) {
                            case PathIterator.SEG_MOVETO:
                            case PathIterator.SEG_LINETO:
                                g2.fill(new Rectangle2D.Float(pts[0], pts[1], 5, 5));
                                break;
                            case PathIterator.SEG_CUBICTO :
                            case PathIterator.SEG_QUADTO :
                                g2.fill(new Rectangle2D.Float(pts[0], pts[1], 5, 5));
                                if (pts[2] != 0) {
                                    g2.fill(new Rectangle2D.Float(pts[2], pts[3], 5, 5));
                                }
                                if (pts[4] != 0) {
                                    g2.fill(new Rectangle2D.Float(pts[4], pts[5], 5, 5));
                                }
                        }
                        f.next();
                    }
                } else if (j == 2) {
                    PathIterator p = shape.getPathIterator(null);
                    FlatteningPathIterator f = new FlatteningPathIterator(p,0.1);
                    while ( !f.isDone() ) {
                        float[] pts = new float[6];
                        switch ( f.currentSegment(pts) ) {
                            case PathIterator.SEG_MOVETO:
                            case PathIterator.SEG_LINETO:
                                g2.fill(new Ellipse2D.Float(pts[0], pts[1],3,3));
                        }
                        f.next();
                    }
                }
                yy += h/6;
            }
            yy = h/2+15;
        }
		
		return g2;
    }

	public static void paint()
	{      
        BufferedImage bimg = createBufferedImage(100, 200, BufferedImage.TYPE_INT_RGB);    
		
        Graphics2D g2 = createGraphics2D(100, 200, bimg);
        g2 = drawDemo(100, 200, g2);
		setColor();
		g2.setBackground(_color);
		Color color = g2.getBackground();
		ColorSpace cs = color.getColorSpace();
		
		int red=(int)(Math.random()*255); 
		int green=(int)(Math.random()*255);
		int blue=(int)(Math.random()*255);
		
		float[] result = cs.fromRGB(new float[] { ( float ) ( red / 1.0 ), ( float ) ( blue / 1.0 ),( float ) ( green / 1.0 ) } );
		/**/
	    g2.dispose();
              
    }
	
	 public static BufferedImage createBufferedImage(int w, int h, int imgType)
	 {
        BufferedImage bi = null;       
	    bi = new BufferedImage(w, h, imgType);      
        return bi;
    }
	
	 public static Graphics2D createGraphics2D(int width, int height, BufferedImage bi) 
	 {
        Graphics2D g2 = null;

        if (bi != null)
		{
            g2 = bi.createGraphics();
        } 
    
        return g2;
    }
	
	  public static void setColor()
	 {
	try
	{
	ICC_Profile prof = ICC_Profile.getInstance("C:/wamp/www/kodak.icm");
	//prof.setData(ICC_Profile.icSigChromaticityTag,prof.getData());
      
	ICC_ColorSpace srcCS = new ICC_ColorSpace(prof);
	
	
	int red=(int)(Math.random()*255); 
	int green=(int)(Math.random()*255);
    int blue=(int)(Math.random()*255);
 
	Color color = new Color(srcCS,new float[] { ( float ) ( red / 255.0 ), ( float ) ( blue / 255.0 ),( float ) ( green / 255.0 ) },(float)1 );
	
	//_color = color;
	_color = Color.blue;
	
	}
	catch (IOException c)
	{
	}
 
    }
	
    public static void main(String argv[]) 
	{		
try
	{	
       JFrame f = new JFrame();
        f.setSize(500,500);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);	
		
		ICC_Profile prof = ICC_Profile.getInstance("C:/wamp/www/kodak_dc.icm");
		//prof.setData(ICC_Profile.icSigChromaticityTag,prof.getData());
      
		ICC_ColorSpace srcCS = new ICC_ColorSpace(prof);
	
	
		int red=(int)(Math.random()*255); 
		int green=(int)(Math.random()*255);
		int blue=(int)(Math.random()*255);
 
		Color color = new Color(srcCS,new float[] { ( float ) ( red / 255.0 ), ( float ) ( blue / 255.0 ),( float ) ( green / 255.0 ) },(float)1 );
	
		
		MsgBox message = new MsgBox(f , "Hey you user, are you sure ?", true);
        
        if (message.isOk) 
		{
		
			paint();			
			System.out.println("Ok pressed");
		
		}       
        
        message.dispose();
		}
	catch (IOException c)
	{
	}
		
    }
}



class MsgBox extends Dialog implements ActionListener {
    private Button ok,can;
    public boolean isOk = false;

    /*
     * @param frame   parent frame 
     * @param msg     message to be displayed
     * @param okcan   true : ok cancel buttons, false : ok button only 
     */
    MsgBox(Frame frame, String msg, boolean okcan){
        super(frame, "Message", true);
        setLayout(new BorderLayout());
        add("Center",new Label(msg));
        addOKCancelPanel(okcan);
        createFrame();
        pack();
        setVisible(true);
    }
    
    MsgBox(Frame frame, String msg){
        this(frame, msg, false);
    }
    
    void addOKCancelPanel( boolean okcan ) {
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        createOKButton( p );
        if (okcan == true)
            createCancelButton( p );
        add("South",p);
    }

    void createOKButton(Panel p) {
        p.add(ok = new Button("OK"));
        ok.addActionListener(this); 
    }

    void createCancelButton(Panel p) {
        p.add(can = new Button("Cancel"));
        can.addActionListener(this);
    }

    void createFrame() {
        Dimension d = getToolkit().getScreenSize();
        setLocation(d.width/3,d.height/3);
    }

    public void actionPerformed(ActionEvent ae){
        if(ae.getSource() == ok) {
            isOk = true;
            setVisible(false);
        }
        else if(ae.getSource() == can) {
            setVisible(false);
        }
    }
    
       
}