#!/usr/bin/python
#
# This file accompanies the paper "Sophail: Applied attacks against Sophos Antivirus".
#
# Tavis Ormandy <taviso@cmpxchg8b.com>, September 2012
#
# Wrap an arbitrary file in a PDF compressed object, thanks to Felix for the awesome hint.
#

import zlib
import sys

stream = zlib.compress(sys.stdin.read(), zlib.Z_BEST_COMPRESSION)

sys.stderr.write("Compressed input to %u bytes\n" % (len(stream)))

sys.stdout.write("%%PDF-1.4\n0 0 obj << /Filter /FlateDecode >> stream\n%s\nendstream\nendobj\n" % (stream))
