function New-PDFJS {

    # Use the desidered params
        [CmdletBinding()]
    Param (
    # 
        [string]$js ="app.launchURL('C:\\Windows\\System32\\calc.exe') ",
        [string]$msg = "Hello PDF",
        [string]$filename = "C:\Users\Daniele\Desktop\calc.pdf"
        )

    # Use the PDFSharp-WPF.dll library path
    Add-Type -Path C:\Users\Daniele\Desktop\PdfSharp-WPF.dll

    $doc = New-Object PdfSharp.Pdf.PdfDocument
    $doc.Info.Title = $msg
    $doc.info.Creator = "AnonymousUser"
    $page = $doc.AddPage()

    $graphic = [PdfSharp.Drawing.XGraphics]::FromPdfPage($page)
    $font = New-Object PdfSharp.Drawing.XFont("Courier New", 20, [PdfSharp.Drawing.XFontStyle]::Bold)
    $box  = New-Object PdfSharp.Drawing.XRect(0,0,$page.Width, 100)
    $graphic.DrawString($msg, $font, [PdfSharp.Drawing.XBrushes]::Black, $box, [PdfSharp.Drawing.XStringFormats]::Center)

    $dictjs = New-Object PdfSharp.Pdf.PdfDictionary
    $dictjs.Elements["/S"]  = New-Object PdfSharp.Pdf.PdfName ("/JavaScript")
    $dictjs.Elements["/JS"] = New-Object PdfSharp.Pdf.PdfStringObject($doc, $js);
   
    $doc.Internals.AddObject($dictjs)

    $dict = New-Object PdfSharp.Pdf.PdfDictionary
    $pdfarray = New-Object PdfSharp.Pdf.PdfArray
    $embeddedstring = New-Object PdfSharp.Pdf.PdfString("EmbeddedJS")

    $dict.Elements["/Names"] = $pdfarray
    $pdfarray.Elements.Add($embeddedstring)
    $pdfarray.Elements.Add($dictjs.Reference)
    $doc.Internals.AddObject($dict)

    $dictgroup = New-Object PdfSharp.Pdf.PdfDictionary
    $dictgroup.Elements["/JavaScript"] = $dict.Reference
    $doc.Internals.Catalog.Elements["/Names"] = $dictgroup

    $doc.Save($filename)
}

