#pragma once

using namespace System;
using namespace System::Runtime::Serialization;
using namespace System::Reflection;

[Serializable]
ref class FakeDelegateEntry : public ISerializable
{
	FakeDelegateEntry^ _delegateEntry;
	String^ _typeName;
	String^ _assemblyName;
	String^ _targetTypeAssembly;
	String^ _targetTypeName;
	String^ _methodName;
	Object^ _target;

public:

	virtual void GetObjectData(SerializationInfo^ info, StreamingContext context)
	{
		Type^ t = Object::typeid->Assembly->GetType("System.DelegateSerializationHolder+DelegateEntry");

		info->SetType(t);

		// Alternatively use
		// info.AssemblyName = "mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
		// info.FullTypeName = "System.DelegateSerializationHolder+DelegateEntry";

		info->AddValue("delegateEntry", _delegateEntry);
		info->AddValue("methodName", _methodName);
		info->AddValue("targetTypeAssembly", _targetTypeAssembly);
		info->AddValue("targetTypeName", _targetTypeName);
		info->AddValue("assembly", _assemblyName);
		info->AddValue("type", _typeName);
		info->AddValue("target", _target);
	}

	FakeDelegateEntry(FakeDelegateEntry^ entry, String^ typeName, String^ assemblyName, String^ targetTypeAssembly, String^ targetTypeName, String^ methodName, Object^ target)
	{
		_delegateEntry = entry;
		_typeName = typeName;
		_assemblyName = assemblyName;
		_targetTypeAssembly = targetTypeAssembly;
		_targetTypeName = targetTypeName;
		_target = target;
		_methodName = methodName;
	}
};

