#include <windows.h>
#include <stdio.h>
#include <wininet.h>
#include "ltcommon.h"


/*
 print last error formats and prints error code and error message for GetLastError code 
 to the standard error output
*/

void print_last_error(void)
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}


/*
 get PEB returns pointer to Process Environment Block
*/

PVOID get_peb(void)
{
  PVOID res;
  __asm
  (
    "mov eax,fs:[0x30]          \n"
    "mov [%0],eax               \n"
    :
    : "m" (res)
  );
  return res;
}


/*
 get default browser name reads registry value DEFAULT_BROWSER_VALUE in DEFAULT_BROWSER_ROOT\DEFAULT_BROWSER_KEY to obtain 
 the path of default browser default browser is assumed to be allowed application for network communication
 the function returns the path of the default browser via the buffer specified in the first argument 
 its size is given in the second argument
 if the function succeed the return value is TRUE, otherwise it is FALSE
*/

int get_default_browser_name(char *buffer,size_t size)
{
  HKEY key;
  int res=FALSE;
  int ret=RegOpenKeyEx(HKEY_CLASSES_ROOT,"http\\shell\\open\\command",0,KEY_READ,&key);
  if (ret==ERROR_SUCCESS)
  {
    DWORD lsize=size;
    ret=RegQueryValueEx(key,"",NULL,NULL,buffer,&lsize);
    if (ret==ERROR_SUCCESS)
    {
      if (strlen(buffer))
      {
        char *dl=buffer;
        if (buffer[0]=='"')
        {
          do
          {
            dl[0]=dl[1];
            if (*dl!='"') dl++;
          } while (*dl && (*dl!='"'));
          if (*dl=='"') *dl='\0';
        } else 
        {
          dl=strchr(buffer,' ');
          if (dl) *dl='\0';
        }

        res=strlen(buffer)>0;
      } else fprintf(stderr,"The default browser's path is invalid.\n");
    } else 
    { 
      fprintf(stderr,"Unable to query the default value of \"HKCU\\http\\shell\\open\\command\".\n");
      print_last_error();
    } 

    RegCloseKey(key);
  } else 
  {
    fprintf(stderr,"Unable to open registry key \"HKCU\\http\\shell\\open\\command\".\n");
    print_last_error();
  }

  return res;
}


/*
 leaktest attempt tries to establish Internet connection and download web page
 if the function succeed the web page content is saved to the buffer of given size
 if the function succeed the return value is TRUE, otherwise it is FALSE
*/

int leaktest_attempt(char *page,char *buffer,size_t size)
{
  int res=FALSE;

  HINTERNET inet=InternetOpen("The Coat",INTERNET_OPEN_TYPE_PRECONFIG,NULL,NULL,0);
  if (inet)
  {
    HINTERNET iurl=InternetOpenUrl(inet,page,NULL,0,INTERNET_FLAG_NO_CACHE_WRITE,0);
    if (iurl)
    {
      char *bufptr=buffer;
      int totsize=0;
      DWORD rsize=0;

      while (InternetReadFile(iurl,bufptr,size-totsize-1,&rsize) && (rsize>0))
      {
        bufptr+=rsize;
        totsize+=rsize;
      }

      *bufptr='\0';
      if (totsize) res=TRUE;

      InternetCloseHandle(iurl);
    } else 
    {
      fprintf(stderr,"Unable to open Internet page \"%s\" InternetOpenUrl.\n",page);
      print_last_error();
    }

    InternetCloseHandle(inet);
  } else
  {
    fprintf(stderr,"Unable to open Internet connection using InternetOpen.\n");
    print_last_error();
  }

  return res;
}

