/*
 * omen  - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen  is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen  is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <ncurses.h>
#include <sys/time.h>

/* max size for a TCP/IP packet */
#define MAX_PKT_SIZE 65536

/* the configuration structure all paramz are here */
struct cbcPadConf
{
  int listenPort;            /* local listen port */
  char *host;                /* hostname of the server */
  int hostPort;              /* port of the server */
  int threshold;             /* threshold df vs. brm [microseconds] */
  int type;                  /* type of the attack */
  WINDOW *stdscr;            /* main ncurses window */
  WINDOW *tlsWin;            /* TLS ncurses window */
  WINDOW *debugWin;          /* debug ncurses window */
  WINDOW *pwWin;             /* Password ncurses window */
  int x;                     /* size of the screen */
  int y;                     /* size of the screen */
  int c;                     /* client socket */
  int m;                     /* listen local socket */
  int s;                     /* remote server socket */
  unsigned char *pkt;        /* packet */
  uint offset;               /* offset for pkt */
  int enc_ok;                /* test encryption one time */
  int first_data_flag;       /* allocate memory for cipher pkt */
  int pkt_size;              /* packet size */
  uint pkt_data;             /* current pkt data */
  uint pkt_data_end;         /* target pkt data */
  uint nb_block;             /* number of attacked blocks */
  unsigned char *passwd;     /* buffer of decrypted blocks */
  uint current_block;        /* current attacked block */
  uint current_word;         /* current attacked word */
  unsigned char *attack_word;/* word attacked with */
  uint first_attack;         /* trick for algorithm */
  struct timeval tv1;        /* for the time attack */
  struct timeval tv2;        /* for the time attack */
  struct timezone tz;        /* for the time attack */
};

/* parse argument and fill conf struct (only one exported function) */
void getargs(struct cbcPadConf *conf, int argc, char *argv[]);
