/*

Chaser checksum calculator 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    http://aluigi.altervista.org

This function calculates the 16bit checksum of the packets used
in the game Chaser http://www.chasergame.com/

A Chaser packet is composed as the following:

00 a1 c7 61 61 61 61
|  |     |
|  |     data
|  16bit checksum of data (little endian)
first byte (NULL)


LICENSE
=======
    Copyright 2004 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/



unsigned short chaser_crc(unsigned char *data, int len) {
    unsigned short  ax = 0;

    for(; len; len--, data++) {
        ax = *data ^ ((ax<<8)|(ax>>8));
        ax ^= (ax & 0xff) >> 4;
        ax ^= ax << 0xc;
        ax ^= (ax & 0xff) << 5;
    }

    return(ax);
}
