// RunDefenderScan.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

typedef struct _SCAN_FILE
{
	LPCWSTR file_type; // file or folder
	LPCWSTR file_name; // path
	DWORD   unk;	   // 0
} SCAN_FILE, *PSCAN_FILE;

typedef struct _SCAN_FILE_LIST
{
	DWORD count;
	PSCAN_FILE files;
} SCAN_FILE_LIST, *PSCAN_FILE_LIST;

typedef HRESULT(__stdcall *_MpCallbackFunction)(void* unk1, void* unk2);
typedef HRESULT(__stdcall *_MpHandleClose)(HANDLE Handle);
typedef HRESULT(__stdcall *_MpManagerOpen)(int unk, HANDLE* Handle);
typedef HRESULT(__stdcall *_MpConfigInitialize)();
typedef HRESULT(__stdcall *_MpScanStart)(HANDLE mgr, DWORD dwScanType, DWORD dwOptions, 
	PSCAN_FILE_LIST ScanDetails, _MpCallbackFunction Callback, HANDLE* ScanHandle);

// 0x4001

KNOWNFOLDERID GetFolderId()
{
#ifdef _WIN64
	return FOLDERID_ProgramFilesX64;
#else
	return FOLDERID_ProgramFilesX86;
#endif
}

bstr_t GetProgramFilesPath()
{
	PWSTR path;

	SHGetKnownFolderPath(GetFolderId(), 0, nullptr, &path);

	bstr_t ret = path;
	CoTaskMemFree(path);

	return ret;
}

// Get program files
bstr_t GetMpClientPath()
{
	return GetProgramFilesPath() + L"\\Windows Defender\\MPClient.dll";
}

bool IsWebClientRunning()
{
	bool ret = false;

	SC_HANDLE sc = OpenSCManager(NULL, SERVICES_ACTIVE_DATABASE, SC_MANAGER_CONNECT);
	if (sc)
	{
		SC_HANDLE service = OpenService(sc, L"webclient", SERVICE_QUERY_STATUS);
		if (service)
		{
			SERVICE_STATUS status;

			if (QueryServiceStatus(service, &status))
			{
				ret = status.dwCurrentState == SERVICE_RUNNING;
			}

			CloseServiceHandle(service);
		}
		else
		{
			printf("Error opening webclient service: %d\n", GetLastError());
		}
		CloseServiceHandle(sc);
	}
	else
	{
		printf("Error opening service manager %d\n", GetLastError());	
	}

	return ret;
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 2)
	{
		printf("Usage: path\n");
		return 1;
	}

	if (!IsWebClientRunning())
	{
		printf("WebClient service is not running, please start it manually\n");
		return 1;
	}	

	HMODULE hLib = LoadLibrary(GetMpClientPath().GetBSTR());

	_MpManagerOpen MpManagerOpen = (_MpManagerOpen)GetProcAddress(hLib, "MpManagerOpen");
	_MpHandleClose MpHandleClose = (_MpHandleClose)GetProcAddress(hLib, "MpHandleClose");
	_MpConfigInitialize MpConfigInitialize = (_MpConfigInitialize)GetProcAddress(hLib, "MpConfigInitialize");
	_MpScanStart MpScanStart = (_MpScanStart)GetProcAddress(hLib, "MpScanStart");

	HANDLE mgr;

	//MpConfigInitialize();

	HRESULT hr = MpManagerOpen(0, &mgr);
	if (SUCCEEDED(hr))
	{
		printf("Opened\n");
		HANDLE scan_handle = nullptr;

		SCAN_FILE_LIST list = { 0 };
		SCAN_FILE files[1] = { 0 };
		files[0].file_type = L"file";		
		files[0].file_name = argv[1];

		list.count = 1;
		list.files = files;

		hr = MpScanStart(mgr, 3, 0x4001, &list, nullptr, &scan_handle);
		printf("Scan: %08X\n", hr);

		Sleep(1000);

		MpHandleClose(mgr);
	}
	else
	{
		printf("Error: %08X\n", hr);
	}

	return 0;
}

