// shatterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "shatter.h"
#include "shatterDlg.h"
#include <string.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShatterDlg dialog

CShatterDlg::CShatterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CShatterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShatterDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CShatterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShatterDlg)
	DDX_Control(pDX, IDC_EDIT3, m_lparam_edit);
	DDX_Control(pDX, IDC_EDIT2, m_wparam_edit);
	DDX_Control(pDX, IDC_EDIT1, m_Handle);
	DDX_Control(pDX, IDC_LIST1, m_list1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CShatterDlg, CDialog)
	//{{AFX_MSG_MAP(CShatterDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON5, OnButton5)
	ON_BN_CLICKED(IDC_BUTTON6, OnButton6)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit2)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_BN_CLICKED(IDC_BUTTON7, OnButton7)
	ON_BN_CLICKED(IDC_BUTTON8, OnButton8)
	ON_BN_CLICKED(IDC_BUTTON9, OnButton9)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShatterDlg message handlers

BOOL CShatterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CShatterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CShatterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CALLBACK ChildCallbackFunc(HWND Handle, long Box)
{
char *HandleString = new char[100];
char *Title = new char[300];
char *String= new char[400];

itoa((unsigned int)Handle,HandleString,16);
GetWindowText(Handle,Title,280);
sprintf(String,"     %s - %s",HandleString,Title);
((CListBox *)Box)->AddString(String);
delete(String);
delete(HandleString);
delete(Title);
return true;
}


BOOL CALLBACK CallbackFunc(HWND Handle, long Box)
{
char *HandleString = new char[100];
char *Title = new char[300];
char *String= new char[400];

itoa((unsigned int)Handle,HandleString,16);
GetWindowText(Handle,Title,280);
sprintf(String,"%s - %s",HandleString,Title);
((CListBox *)Box)->AddString(String);

EnumChildWindows(Handle,&ChildCallbackFunc,Box);

delete(String);
delete(HandleString);
delete(Title);
return true;
}

void CShatterDlg::EmptyBox()
{
	while (m_list1.GetCount())
		m_list1.DeleteString (0);
}



void CShatterDlg::OnButton2() 
{
	EmptyBox();
	EnumWindows(&CallbackFunc,(DWORD)&m_list1);	
}



void CShatterDlg::OnButton5() 
{
	EmptyBox();
	POINT CursorPos;
	if (GetCursorPos(&CursorPos))
	{
		HWND CursorWindow = ::WindowFromPoint(CursorPos);
		char *HandleString = new char[10];
		char *Title = new char[32];
		char *String= new char[42];

		itoa((unsigned int)CursorWindow,HandleString,16);
		::GetWindowText(CursorWindow,Title,31);
		sprintf(String,"%s - %s",HandleString,Title);
		m_list1.AddString(String);
		delete(String);
		delete(HandleString);
		delete(Title);

		::EnumChildWindows(CursorWindow,&ChildCallbackFunc,(long)&m_list1);
	}
	
}

void CShatterDlg::OnButton6() 
{
	if (!::PostMessage((HWND)WindowHandle,WM_TIMER,m_wparam,m_lparam))
		MessageBox("Message failed!","Error:",MB_ICONWARNING|MB_OK);	
}

void CShatterDlg::OnChangeEdit1() 
{
	char *Text = new char[100];
	m_Handle.GetLine(0,Text,99);
	sscanf(Text,"%x",&WindowHandle);
	delete Text;	
}

void CShatterDlg::OnChangeEdit2() 
{
	char *Text = new char[100];
	m_wparam_edit.GetLine(0,Text,99);
	sscanf(Text,"%x",&m_wparam);
	delete Text;
	
}

void CShatterDlg::OnChangeEdit3() 
{
	char *Text = new char[100];
	m_lparam_edit.GetLine(0,Text,99);
	sscanf(Text,"%x",&m_lparam);
	delete Text;	
}

void CShatterDlg::OnButton7() 
{
	if (!::SendMessage((HWND)WindowHandle,WM_PASTE,m_wparam,m_lparam))
		MessageBox("Message failed!","Error:",MB_ICONWARNING|MB_OK);
}

void CShatterDlg::OnButton8() 
{
	if (!::PostMessage((HWND)WindowHandle,EM_GETLINE,m_wparam,m_lparam))
		MessageBox("Message failed!","Error:",MB_ICONWARNING|MB_OK);	
}

void CShatterDlg::OnButton9() 
{
	if (!::PostMessage((HWND)WindowHandle,EM_SETLIMITTEXT,m_wparam,m_lparam))
		MessageBox("Message failed!","Error:",MB_ICONWARNING|MB_OK);
}
