/*
    Copyright 2006-2013 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#define _WIN32_WINNT    0x0601
#define _WIN32_WINDOWS  0x0601
#define WINVER          0x0601

// gcc -o udpsz udpsz.c md5.c -lz -ldl -lpthread -lpcap
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ctype.h>
#include <sys/stat.h>
#include <errno.h>
#include <time.h>
#include <stdarg.h>
#include <math.h>
#include <inttypes.h>
#include <locale.h>
#include <fcntl.h>
#include <zlib.h>           // -lz
#include <pcap.h>           // -lpcap
//#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include <tlhelp32.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define sleepms sleep
    #define ONESEC  1000
    #define LOADDLL         hLib = LoadLibrary(fname); \
                            if(!hLib) winerr();
    #define GETFUNC(x,y)    x = (void *)GetProcAddress(hLib, y); \
                            if(!quiet) printf("  %-10s %p\n", y, x);
                            //if(!x) winerr();
    #define CLOSEDLL        FreeLibrary(hLib);
    #define set_priority    SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS)
    HINSTANCE   hLib    = NULL;
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <dlfcn.h>      // -ldl

    #define stricmp strcasecmp
    #define stristr strcasestr
    #define sleepms(X)  usleep(X * 1000)
    #define ONESEC  1
    #define LOADDLL         hLib = dlopen(fname, RTLD_LAZY); \
                            if(!hLib) { \
                                fprintf(stderr, "\nError: %s\n\n", dlerror()); \
                                exit(1); \
                            }
    #define GETFUNC(x,y)    x = (void *)dlsym(hLib, y); \
                            if(!quiet) printf("  %-10s %08x\n", y, (uint32_t)x);
                            //error = dlerror();
                            //if(error || !x) { // no checks!
                                //fprintf(stderr, "\nError: %s\n\n", error);
                                //exit(1);
    #define CLOSEDLL        dlclose(hLib);
    void        *hLib   = NULL;
    #define __cdecl
    typedef uint32_t DWORD;
    typedef char DEBUG_EVENT;
#endif

#ifdef WIN32
    #define quick_thread(NAME, ARG) DWORD WINAPI NAME(ARG)
    #define thread_id   HANDLE
#else
    #define quick_thread(NAME, ARG) void *NAME(ARG)
    #define thread_id   pthread_t
#endif

thread_id quick_threadx(void *func, void *data) {
    thread_id   tid;
#ifdef WIN32
    DWORD   tmp;

    tid = CreateThread(NULL, 0, func, data, 0, &tmp);
    if(!tid) return(0);
#else
    if(pthread_create(&tid, NULL, func, data)) return(0);
#endif
    return(tid);
}

void quick_threadz(thread_id tid) {
#ifdef WIN32
    DWORD   ret;

    for(;;) {
        if(!GetExitCodeThread(tid, &ret)) break;
        if(!ret) break;
        Sleep(100);
    }
#else
    pthread_join(tid, NULL);
#endif
}

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef int32_t     i32;
typedef uint32_t    u32;
typedef int64_t     i64;
typedef uint64_t    u64;



/*
  IMPORTANT NOTE
  this code is incredibly chaotic that even I get lost in it so
  if it looks crazy... yes it is!
  don't waste your time with this tool/code, it's used only for
  my requirements and maybe one day I will decide to rewrite it
  like any normal human should do!
*/



#define VER         "0.3.4"
#define ZLIBMAX(X)  ((X) + ((X) / 1000) + 12)
#define winerr      std_err
#define BUFF_ALLOC  if(sendsize > alloc_size) { \
                        alloc_size = sendsize + 0xffff; \
                        buff = realloc(buff, alloc_size + 1); \
                        if(!buff) std_err(); \
                    }

// the "sleepms(1)" below improves "A LOT" the performances with TCP, really!!!
// never use shutdown()
#define CLOSE_SD(X) { \
        if(sd > 0) { \
            if(pck_proto < 0) sleepms(1); \
            if(do_not_close_socket && dumprecv && randport) { \
                endless_recvshow_args.sd = sd; \
                endless_recvshow_args.pck_proto = pck_proto; \
                endless_recvshow_args.dumprecv = dumprecv; \
                quick_threadx(endless_recvshow, (void *)&endless_recvshow_args); \
            } else if(!do_not_close_socket) { \
                close(sd); \
            } \
            if(pck_proto < 0) sleepms(1); \
        } \
        sd = -1; \
    }
#define GET_PORT(X) ((X >= 0) ? htons(X) : htons(-X))
#define MYMAXINT    (((u32)-1) >> (u32)1)

#ifndef LITTLE_ENDIAN
    #define LITTLE_ENDIAN   0
    #define BIG_ENDIAN      1
#endif

#ifndef SO_EXCLUSIVEADDRUSE
    #define SO_EXCLUSIVEADDRUSE ((u_int)(~SO_REUSEADDR))
#endif
#ifndef TCP_NODELAY
    #define TCP_NODELAY 0x0001
#endif

enum {
    HASH_MD5 = 1,
    HASH_MD5_4,
    HASH_CRC64,
    HASH_CRC32,
    HASH_CRC16,
    HASH_CRC8,
    HASH_NONE
};



typedef struct {
    int     sd;
    int     pck_proto;
    int     dumprecv;
} endless_recvshow_args_t;



#include "rwbits.h"
#include "md5.h"
#include "crc.c"
#include "udpspoof.h"
void mypush(u64 **buff, int *el, u64 n);
void pcap_error(pcap_if_t *alldevs, char *err);
pcap_t *pcap_get_device(int dev);
int debug_privileges(void);
u32 *get_hosts(u8 *str);
DWORD get_pid(u8 *str);
quick_thread(endless_recvshow, endless_recvshow_args_t *args);
quick_thread(debugger, int pid);
void show_dump(unsigned char *data, unsigned int len, FILE *stream);
void loaddll(u8 *fname, u8 *par);
void load_content(u8 *filename, int type, int offset, int times, int offset_is_bits);
void lamemset(u8 *data, int chr, int size, int chr_bits);
int get_parameter_numbers(u8 *s, ...);
void myhash(int hash_algo, u8 *out, u8 *in, int insz, crc_context *crc_ctx);
int get_hash(u8 *str);
u32 randit(u32 *rnd);
int recvshow(int sd, int pck_proto, int dumprecv);
u8 *load_file(u8 *filename, int *contentsize);
int cstring(u8 *input, u8 *output, int maxchars, int *inlen);
int hex2byte(u8 *hex);
u8 *load_xstring(u8 *input, int hex, int *contentsize);
u8 *mystrchrs(u8 *str, u8 *chrs);
u64 *string2num(u8 *input, int *ret_size);
int create_socket(int pck_proto, int sd_already_set, struct sockaddr_in *peer);
u8 *get_byte(u8 *data, int *ret_chr, int *ret_chr_bits);
u64 get_num(u8 *data, int multi);
int create_rand_byte(u8 *data, int len, u32 *seed, u8 *charset);
u64 getxx(u8 *data, int bits, int endian);
int putxx(u8 *data, u64 num, int bits, int endian);
void memcpy_bits(u8 *buff, int pos, u8 *data, int len);
int zip(z_stream *z, u8 *in, u32 insz, u8 *out, u32 outsz);
char *stristr(const char *String, const char *Pattern);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



typedef struct {
    int     offset;
    u32     times;
    u32     curr;
    u8      *data;
    int     size;
    u8      offset_is_bits;
} content_t;
content_t           *content    = NULL;
static struct linger ling       = {1,1};
static const int    on          = 1;
int                 quiet       = 0,
                    Hendian     = LITTLE_ENDIAN,
                    debug       = 0,
                    dumpsend    = 0,
                    verbose     = 0,
                    do_not_close_socket = 0;

typedef struct {
    int         hash_offset;
    int         hash_algo;
    int         hash_start;
    int         hash_end;
    int         hash_seedsz;
    u8          *hash_seed;
    crc_context *crc_ctx;
} hashcrc_t;
int                 hashcrcs    = 0;
hashcrc_t           *hashcrc    = NULL;




#define MAX_PLUGINS 4   // 2 are more than enough
int         plugins = 0;
typedef struct {
    __cdecl int (* sudp_init)(u8 *);
    __cdecl int (* sudp_pck)(u8 *, int);
    __cdecl int (*mysend)(int s, char **retbuf, int len, int flags);
    __cdecl int (*mysendto)(int s, char **retbuf, int len, int flags, const struct sockaddr *to, int tolen);
    __cdecl int (*myrecv)(int s, char *buf, int len, int flags);
    __cdecl int (*myrecvfrom)(int s, char *buf, int len, int flags, struct sockaddr *from, int *fromlen);
} plugin_t;
plugin_t    plugin[MAX_PLUGINS + 1];



// avoid to force the users to have winpcap installed
static int      __cdecl (*_pcap_datalink)(pcap_t *)                             = NULL;
static int      __cdecl (*_pcap_findalldevs)(pcap_if_t **, char *)              = NULL;
static void     __cdecl (*_pcap_freealldevs)(pcap_if_t *)                       = NULL;
static pcap_t*  __cdecl (*_pcap_open_live)(const char *, int, int, int, char *) = NULL;
static int      __cdecl (*_pcap_sendpacket)(pcap_t *, const u_char *, int)      = NULL;

int pcap_antidll_init(void) {
#ifdef WIN32
    static HMODULE pcap_dll = NULL;

    if(!pcap_dll) pcap_dll = LoadLibrary("wpcap.dll");
    if(!pcap_dll) return(-1);
    if(!_pcap_datalink)    _pcap_datalink    = (void *)GetProcAddress(pcap_dll, "pcap_datalink");
    if(!_pcap_findalldevs) _pcap_findalldevs = (void *)GetProcAddress(pcap_dll, "pcap_findalldevs");
    if(!_pcap_freealldevs) _pcap_freealldevs = (void *)GetProcAddress(pcap_dll, "pcap_freealldevs");
    if(!_pcap_open_live)   _pcap_open_live   = (void *)GetProcAddress(pcap_dll, "pcap_open_live");
    if(!_pcap_sendpacket)  _pcap_sendpacket  = (void *)GetProcAddress(pcap_dll, "pcap_sendpacket");
#else
    if(!_pcap_datalink)    _pcap_datalink    = pcap_datalink;
    if(!_pcap_findalldevs) _pcap_findalldevs = pcap_findalldevs;
    if(!_pcap_freealldevs) _pcap_freealldevs = pcap_freealldevs;
    if(!_pcap_open_live)   _pcap_open_live   = pcap_open_live;
    if(!_pcap_sendpacket)  _pcap_sendpacket  = pcap_sendpacket;
#endif
    return(0);
}



int check_next_arg(int i, int argc, char **argv, int is_num) {
    u8      *p,
            c;

    i++;
    if(i >= argc) return(-1);
    p = argv[i];
    if(*p == '/') return(-1);
    if(*p == '-') {
        if(!is_num) return(-1);
        p++;  // for negative numbers
    }
    if(*p == '+') {
        if(is_num) return(0);
    }
    if(!is_num) return(0);

    c = tolower(*p);
    if((c >= '0') && (c <= '9')) return(0); // 0-9 covers also hex 0x

    return(-1);
}



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer,
                        peerl;
    endless_recvshow_args_t    endless_recvshow_args;
    z_stream            z;
    pcap_t  *fp             = NULL;
    thread_id   tid         = 0;
    DWORD   pid             = 0;
    u64     Xnumber         = 0,
            Xnumber_bck     = 0,
            Xmask           = 0,
            *Xfuzz_value    = NULL;
    u32     seed            = 0,
            print_time      = 0,
            total_sent      = 0,    // packets sent in the session (like -c sess1,sess2)
            total_pcks      = 0,    // total packets
            tcp_max1        = 0,
            dllwhen         = 1,
            *hosts          = NULL;
    int     sd              = -1,
            sdl             = -1,
            i               = 0,
            j               = 0,
            t               = 0,
            n               = 0,
            old_offset      = 0,
            old_content_n   = 0,
            zlen            = 0,
            size            = 0,
            sendsize        = 0,
            offset          = 0,
            offset_bits     = 0,
            zoffset         = 0,
            Xoffset         = 0,
            Xoffset_bck     = 0,
            Xfuzz_valuen    = 0,
            Xfuzz_values    = 0,
            Xbitflip        = -1,
            Xendian         = LITTLE_ENDIAN,
            randport        = 0,
            randbyte        = 0,
            loop            = 0,
            loopms          = 5,
            chr_bck         = 0,
            chr             = 0,    // int
            upsize          = 0,
            upsizex         = 0,
            Xbits           = 0,
            zbits           = 0,
            dumprecv        = 0,
            x_start         = 0,
            Xmagic          = 0,
            Xrandom         = 0,
            pck_proto       = 0,    // 0:udp negative:tcp positive:raw
            bind_mode       = 0,
            port_scan       = 0,
            content_n       = 0,
            dyn_size        = 0,
            //dyn_offset      = 0,
            alloc_size      = 0,
            sendlen         = 0,
            host_scan       = -1,
            chr_datasz      = 0,
            chr_bits        = 8;
    int     port            = 0,    // do NOT use u16, -1 is needed for the scanner
            sport           = 0;
    u8      tmp[16],
            *buff           = NULL,
            *oldbuf         = NULL, // used only for proxocket
            *sendbuff       = NULL,
            //*filename       = NULL,
            //*bstring        = NULL,
            //*xstring        = NULL,
            *spoof          = NULL,
            *recvbuff       = NULL,
            *dllname        = NULL,
            *dllpar         = NULL,
            *host           = NULL,
            *debug_pid      = NULL,
            *chr_data       = NULL,
            *str            = NULL,
            *p              = NULL,
            *seed_charset   = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);
    setbuf(stderr, NULL);
    fflush(stdin);  // useless?
    #ifdef O_BINARY
    setmode(fileno(stdin), O_BINARY);
    #endif

    fputs("\n"
        "UDPSZ " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s [options] <host> <port> <pck_size>\n"
            "\n"
            "Options:\n"
            "-b BYTE    fill the packet with BYTE which can be a char, hex or C string\n"
            "           example: -b a   or   -b 0x61   or   -b 61   -b \"hel\\x6c\\x6f\"\n"
            "           BYTE: -1       format string pattern\n"
            "                 <=0xff   8bit number\n"
            "                 >0xff    32bit little endian number\n"
            "                 char     char pattern, like -b a\n"
            "                 string   string pattern, like -b test\n"
            "-r [SEED]  random packet content\n"
            "-s         packet filled with incremental byte (suggested -b and -l)\n"
            "-p PORT    use source port PORT\n"
            "           PORT: <0  with -S will be decreased\n"
            "                 >0  with -S will be increased\n"
            "-R         random source port (suggested -l)\n"
            "-S         sequential source port (needs -l)\n"
            "-x [M] [E] the size of the packet will go from 0 or M to pck_size (needs -l)\n"
            "           if -x is followed by a number then it will be the start point (0)\n"
            "           if E is 1 and there is content smaller than the size of the packet\n"
            "           it will be expanded from the offset M (like \"contAAAAAAAAAAAAAent\")\n"
            "-y [M] [S] exactly as above but goes from pck_size to 0 or M, S at 1 shrinks\n"
            "-E ENDIAN  endianess, currently used only for -H\n"
            "-X O B E V special number content, the initial bytes of the packet (max 4)\n"
            "           are a number of B bits (from 8 to 32) of endianess E (l/i or b/n)\n"
            "           at offset O of the packet and incremented at each send (needs -l),\n"
            "           V is the initial value assigned to this number (e.g. -X 0 32 i 0)\n"
            "           after V you can add a special number that increases V each time and\n"
            "           increases also the offset when the cycle reaches the max... use -d\n"
            "-z O W     compress the data in the packet at offset O using W windowbits\n"
            "           (15 is the most commonly used or -15)\n"
            "-f FD [O]  load the content of the packet from FD, the size will be\n"
            "           truncated at pck_size, set it to -1 for using the real file size\n"
            "           from version 0.3.3 you can load all the files you want and you can\n"
            "           also specify the offset where placing them instead of using -o\n"
            "           if O is used then the contents are merged in one packet otherwise\n"
            "           one packet for each content\n"
            "-c STR [O] as above but the content is specified by STR (e.g. -c \"bye all\")\n"
            "           from version 0.2.3 STR is considered a C string like \"hel\\x6c\\x6f\"\n"
            "-C STR [O] as above but in hex format (e.g. -C \"12 34 00 56 789abcdef\")\n"
            "-o OFF     put the data of -f/c/C options at offset OFF of the packet (legacy)\n"
            "-l MS      send infinite packets with a delay of MS milliseconds\n"
            "-d [MAX]   show the hex dump of each packet (debug), optionally of MAX bytes\n"
            "-D [MAX]   try to receive a reply packet and visualize it (debug)\n"
            "           MAX:  -1  waits one millisecond for each receiving\n"
            "                 -2  waits less than one millisecond (default)\n"
            "                 -3  waits forever any receiving\n"
            "                 -4  waits forever only the first receiving\n"
            "                 >0  display only the first MAX bytes of the packet\n"
            "-T [X]     crazy TCP mode, will be used TCP connections instead of UDP packets\n"
            "           X:    -1  use the same connection sending endless packets\n"
            "                  0  close the connection after the first packet (default)\n"
            "                 >0  send X packets for each connection\n"
            "-H A O S E at offset O put the hash/crc defined by algorithm A calculated on\n"
            "           the part of packet that goes from offset S to E (E can be also <= 0)\n"
            "           supported algorithms: md5, md5_32, crc32, crc16\n"
            "           an additional argument is the seed used for tuning the crc algo:\n"
            "             polynomial, bits, init value, final xor, type, rever, bitmask_side\n"
            "-L DLL [P] load a myproxocket or sudppipe dll for customizing the packet:\n"
            "           int mysendto(...cut...);            // proxocket plugin\n"
            "           int sudp_init(char *data);          // if you need initialization\n"
            "           int sudp_pck(char *data, int len);  // each packet goes here\n"
#ifdef WIN32
            "-g PID     debug the process identified by its pid or name\n"
#endif
            "-P IP      spoof the source IP address of the packets, use IP 0 for random.\n"
            "           note that in some situations is not possible to send packets bigger\n"
            "           than a certain size so is better to stay under 1400 bytes.\n"
            "           if no port is specified (-p/R/S) will be used the source port 0\n"
            "-W PROTO   raw packet, the IP header can't be modified\n"
            "-q         don't show the dots for each packet sent\n"
            "-0         don't close the socket, interesting with -S/R\n"
            //"-v         verbose\n"
            "\n"
            "Special features and notes:\n"
            " a negative <port> forces the tool to send the packet to all the ports above\n"
            " -port, so port -20 will start the scan from port 20, 21, 22 and so on.\n"
            " a negative offset will put the contents at the end of the file.\n"
            " use ever -d for viewing the correctness of packet and effects of the options!\n"
            " <host> can be used also for scanning ranges of hosts, example:\n"
            " 10.0.0.4-100 or 10.0.0.0-255 or 10.0.0-255 or example.com,1.2.3.4,10.0.0.1-9\n"
            " <host> equal to \"\" allows to use the libpcap raw interface, use <port> to\n"
            " specify the interface to use or 0 for choosing it at runtime\n"
            "\n", argv[0]);
        exit(1);
    }

    plugins = 0;
    memset(&plugin, 0, sizeof(plugin));

    argc -= 3;
    for(i = 1; i < argc; i++) {
        if(((argv[i][0] != '-') && (argv[i][0] != '/')) || (strlen(argv[i]) != 2)) {
            fprintf(stderr, "\nError: wrong argument (%s)\n", argv[i]);
            exit(1);
        }
        switch(argv[i][1]) {
            case 'b': {
                chr_data = get_byte(argv[++i], &chr, &chr_bits);
                if(chr_data) {
                    chr_datasz = chr;
                    chr = 0;
                }
                break;
            }
            case 'r': {
                randbyte  = 1;
                if(!check_next_arg(i, argc, argv, 1)) seed = get_num(argv[++i], 1);
                if(!check_next_arg(i, argc, argv, 0)) seed_charset = argv[++i];
                break;
            }
            case 's': randbyte  = 2;                    break;
            case 'p': sport     = get_num(argv[++i], 1);   break;
            case 'R': randport  = 1;                    break;
            case 'S': randport  = 2;                    break;
            case 'x': {
                upsize          = 1;
                if(!check_next_arg(i, argc, argv, 1)) x_start = get_num(argv[++i], 1);
                if(!check_next_arg(i, argc, argv, 1)) upsizex = get_num(argv[++i], 1);
                break;
            }
            case 'y': {
                upsize          = -1;
                if(!check_next_arg(i, argc, argv, 1)) x_start = get_num(argv[++i], 1);
                if(!check_next_arg(i, argc, argv, 1)) upsizex = get_num(argv[++i], 1);
                break;
            }
            case 'E': {
                Hendian         = argv[++i][0];
                if((tolower(Hendian) == 'l') || (tolower(Hendian) == 'i')) {
                    Hendian = LITTLE_ENDIAN;
                } else {
                    Hendian = BIG_ENDIAN;
                }
                break;
            }
            case 'X': {
                Xoffset         = get_num(argv[++i], 1);
                Xbits           = get_num(argv[++i], 1);   // check Xbits later
                Xendian         = argv[++i][0];
                i++;
                if(mystrchrs(argv[i], ",;|")) {
                        // -X 0 8 l 0 "0x10,0x20,0x40"
                        // -X 0 8 l 0 "0,"
                        Xfuzz_value = string2num(argv[i], &Xfuzz_values);
                        if(Xfuzz_value) Xnumber = Xfuzz_value[Xfuzz_valuen++];
                } else if(!argv[i][0] || !stricmp(argv[i], "fuzz")) {
                    if(Xbits < 0) n = sizeof(Xnumber) * 8;
                    else          n = Xbits;
                    for(t = 0; t < n; t++) {
                        mypush(&Xfuzz_value, &Xfuzz_values, ((u64)1 << (u64)t) - (u64)1);
                        mypush(&Xfuzz_value, &Xfuzz_values,  (u64)1 << (u64)t);
                        mypush(&Xfuzz_value, &Xfuzz_values, ((u64)1 << (u64)t) + (u64)1);
                             if(t >= 32) mypush(&Xfuzz_value, &Xfuzz_values, ((u64)1 << (u64)(t % 8)) * (u64)0x0101010101010101LL);
                        else if(t >= 16) mypush(&Xfuzz_value, &Xfuzz_values, ((u64)1 << (u64)(t % 8)) * (u64)0x01010101);
                        else if(t >=  8) mypush(&Xfuzz_value, &Xfuzz_values, ((u64)1 << (u64)(t % 8)) * (u64)0x0101);
                    }
                    mypush(&Xfuzz_value, &Xfuzz_values, -1LL);
                    mypush(&Xfuzz_value, &Xfuzz_values, -2LL);
                } else if(!stricmp(argv[i], "bitflip")) {
                    Xbitflip = 0;
                } else {
                    Xnumber = get_num(argv[i], 1);
                }
                if(!check_next_arg(i, argc, argv, 0)) {
                    i++;
                    if(mystrchrs(argv[i], ",;|")) {
                        // -X 0 8 l 0 "0x10,0x20,0x40"
                        // -X 0 8 l 0 "0,"
                        Xfuzz_value = string2num(argv[i], &Xfuzz_values);
                        if(Xfuzz_value) Xnumber = Xfuzz_value[Xfuzz_valuen++];
                    } else {
                        // -X 0 8 l 0 1
                        Xmagic = get_num(argv[i], 1);
                    }
                }
                if((tolower(Xendian) == 'l') || (tolower(Xendian) == 'i')) {
                    Xendian = LITTLE_ENDIAN;
                } else if(tolower(Xendian) == 'r') {    // random
                    Xendian = LITTLE_ENDIAN;
                    Xrandom = 1;
                } else {
                    Xendian = BIG_ENDIAN;
                }

                if(Xbits < 0) {
                    Xbits = 8;
                    if(Xfuzz_value) {
                        for(t = 0; t < Xfuzz_values; t++) {
                            if(Xfuzz_value[t] > (u64)0xffffffffLL) if(Xbits < 64) Xbits = 64;
                            if(Xfuzz_value[t] > (u64)0x0000ffffLL) if(Xbits < 32) Xbits = 32;
                            if(Xfuzz_value[t] > (u64)0x000000ffLL) if(Xbits < 16) Xbits = 16;
                        }
                    }
                }
                if(Xbits > (sizeof(Xnumber) * 8)) Xbits = (sizeof(Xnumber) * 8);
                if(Xbits <= 4) Xbits /= 8;
                Xbits           = (Xbits + 7) & (~7);
                if(Xbits < (sizeof(Xnumber) * 8)) {
                    Xmask = 1;
                    Xmask <<= Xbits;
                }
                Xmask--;

                break;
            }
            case 'z': {
                zoffset         = get_num(argv[++i], 1);
                i++;
                if(!stricmp(argv[i], "zlib")) zbits = 15;
                else if(!stricmp(argv[i], "deflate")) zbits = -15;
                else zbits      = get_num(argv[i], 1);
                break;
            }
            case 'f': {
                str = argv[++i];
                t = MYMAXINT;
                j = 0; if(!check_next_arg(i, argc, argv, 0 /*was 1 but check 'b'*/)) { p = argv[++i]; if(tolower(p[0]) == 'b') { j = 1; p++; } t = get_num(p, 1); }
                n = 1;
                if(!check_next_arg(i, argc, argv, 1)) n = get_num(argv[++i], 1);
                load_content(str, -1, t, n, j);
                break;
            }
            case 'c': {
                str = argv[++i];
                t = MYMAXINT;
                j = 0; if(!check_next_arg(i, argc, argv, 0 /*was 1 but check 'b'*/)) { p = argv[++i]; if(tolower(p[0]) == 'b') { j = 1; p++; } t = get_num(p, 1); }
                n = 1;
                if(!check_next_arg(i, argc, argv, 1)) n = get_num(argv[++i], 1);
                load_content(str, 0, t, n, j);
                break;
            }
            case 'C': {
                str = argv[++i];
                t = MYMAXINT;
                j = 0; if(!check_next_arg(i, argc, argv, 0 /*was 1 but check 'b'*/)) { p = argv[++i]; if(tolower(p[0]) == 'b') { j = 1; p++; } t = get_num(p, 1); }
                n = 1;
                if(!check_next_arg(i, argc, argv, 1)) n = get_num(argv[++i], 1);
                load_content(str, 1, t, n, j);
                break;
            }
            case 'o': {
                offset          = get_num(argv[++i], 1);
                break;
            }
            case 'l': {
                loop            = 1;
                loopms          = get_num(argv[++i], 1);
                break;
            }
            case 'd': {
                dumpsend        = -1;
                if(!check_next_arg(i, argc, argv, 1)) dumpsend = get_num(argv[++i], 1);
                break;
            }
            case 'D': {
                dumprecv        = -2;
                if(!check_next_arg(i, argc, argv, 1)) dumprecv = get_num(argv[++i], 1);
                break;
            }
            case 'q': quiet     = 1;                    break;
            case 'P': spoof     = argv[++i];            break;
            case 'T': {
                pck_proto       = -1;
                if(!check_next_arg(i, argc, argv, 1)) tcp_max1 = get_num(argv[++i], 1);
                break;
            }
            case 'H': {
                hashcrc = realloc(hashcrc, (hashcrcs + 1) * sizeof(hashcrc_t));
                if(!hashcrc) std_err();
                memset(&hashcrc[hashcrcs], 0, sizeof(hashcrc_t));
                hashcrc[hashcrcs].hash_algo       = get_hash(argv[++i]);
                hashcrc[hashcrcs].hash_offset     = get_num(argv[++i], 1);
                hashcrc[hashcrcs].hash_start      = get_num(argv[++i], 1);
                hashcrc[hashcrcs].hash_end        = get_num(argv[++i], 1);
                if(!check_next_arg(i, argc, argv, 0)) hashcrc[hashcrcs].hash_seed = argv[++i];

                    if((hashcrc[hashcrcs].hash_algo == HASH_CRC64) || (hashcrc[hashcrcs].hash_algo == HASH_CRC32) || (hashcrc[hashcrcs].hash_algo == HASH_CRC16) || (hashcrc[hashcrcs].hash_algo == HASH_CRC8)) {
                        hashcrc[hashcrcs].crc_ctx = calloc(1, sizeof(crc_context));

                        if(hashcrc[hashcrcs].hash_algo == HASH_CRC32) {
                hashcrc[hashcrcs].crc_ctx->poly           = 0xedb88320;   // it's the one where the second element is 0x77073096
                hashcrc[hashcrcs].crc_ctx->bits           = 32;
                hashcrc[hashcrcs].crc_ctx->init           = -1;
                hashcrc[hashcrcs].crc_ctx->final          = -1;
                hashcrc[hashcrcs].crc_ctx->type           = 0;
                hashcrc[hashcrcs].crc_ctx->rever          = 0;
                hashcrc[hashcrcs].crc_ctx->bitmask_side   = 1;
                        } else if(hashcrc[hashcrcs].hash_algo == HASH_CRC8) {
                hashcrc[hashcrcs].crc_ctx->poly           = 0;
                hashcrc[hashcrcs].crc_ctx->bits           = 8;
                hashcrc[hashcrcs].crc_ctx->init           = 0;
                hashcrc[hashcrcs].crc_ctx->final          = 0;
                hashcrc[hashcrcs].crc_ctx->type           = 5;
                hashcrc[hashcrcs].crc_ctx->rever          = 0;
                hashcrc[hashcrcs].crc_ctx->bitmask_side   = 0;
                        } else if(hashcrc[hashcrcs].hash_algo == HASH_CRC16) {
                hashcrc[hashcrcs].crc_ctx->poly           = 0xa001;   // second value equal to 0xc0c1
                hashcrc[hashcrcs].crc_ctx->bits           = 16;
                hashcrc[hashcrcs].crc_ctx->init           = 0;
                hashcrc[hashcrcs].crc_ctx->final          = 0;
                hashcrc[hashcrcs].crc_ctx->type           = 0;
                hashcrc[hashcrcs].crc_ctx->rever          = 0;
                hashcrc[hashcrcs].crc_ctx->bitmask_side   = 1;
                        } else if(hashcrc[hashcrcs].hash_algo == HASH_CRC64) {
                hashcrc[hashcrcs].crc_ctx->poly           = 0xad93d23594c935a9LL;   // second value 0x7ad870c830358979
                hashcrc[hashcrcs].crc_ctx->bits           = 64;
                hashcrc[hashcrcs].crc_ctx->init           = 0;
                hashcrc[hashcrcs].crc_ctx->final          = 0;
                hashcrc[hashcrcs].crc_ctx->type           = 0;
                hashcrc[hashcrcs].crc_ctx->rever          = 1;
                hashcrc[hashcrcs].crc_ctx->bitmask_side   = 0;
                        }

                        if(hashcrc[hashcrcs].hash_seed) {
                            int     x0=hashcrc[hashcrcs].crc_ctx->poly,x1=hashcrc[hashcrcs].crc_ctx->init,x2=hashcrc[hashcrcs].crc_ctx->final,x3=hashcrc[hashcrcs].crc_ctx->bits;
                            get_parameter_numbers(hashcrc[hashcrcs].hash_seed,
                                &x0, &x3, &x1, &x2, &hashcrc[hashcrcs].crc_ctx->type, &hashcrc[hashcrcs].crc_ctx->rever, &hashcrc[hashcrcs].crc_ctx->bitmask_side, NULL);
                            hashcrc[hashcrcs].crc_ctx->poly=x0; hashcrc[hashcrcs].crc_ctx->init=x1; hashcrc[hashcrcs].crc_ctx->final=x2;
                            if(x3 > 0) hashcrc[hashcrcs].crc_ctx->bits = x3;
                            hashcrc[hashcrcs].hash_seed = NULL;
                        }
                        fprintf(stderr, "- crc values: %08x %d %08x %08x %d %d %d\n", (int)hashcrc[hashcrcs].crc_ctx->poly, hashcrc[hashcrcs].crc_ctx->bits, (int)hashcrc[hashcrcs].crc_ctx->init, (int)hashcrc[hashcrcs].crc_ctx->final, hashcrc[hashcrcs].crc_ctx->type, hashcrc[hashcrcs].crc_ctx->rever, hashcrc[hashcrcs].crc_ctx->bitmask_side);
                    } else {
                        if(hashcrc[hashcrcs].hash_seed) {
                            hashcrc[hashcrcs].hash_seedsz = cstring(hashcrc[hashcrcs].hash_seed, hashcrc[hashcrcs].hash_seed, -1, NULL);
                        }
                    }

                hashcrcs++;

                break;
            }
            case 'L': {
                dllname         = argv[++i];
                if(!check_next_arg(i, argc, argv, 0)) dllpar  = argv[++i];
                if(!check_next_arg(i, argc, argv, 1)) dllwhen = get_num(argv[++i], 1);
                loaddll(dllname, dllpar);
                break;
            }
            case 'g': debug_pid = argv[++i];            break;
            case 'W': pck_proto = get_num(argv[++i], 1);   break;
            case 'v': verbose   = 1;                    break;
            case '0': do_not_close_socket = 1;          break;
            default: {
                fprintf(stderr, "\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                break;
            }
        }
        if(i >= argc) {
            fprintf(stderr, "\nError: recheck your command-line arguments\n");
            exit(1);
        }
    }

    if((argv[argc][0] == '-') /* negative port problems! || (argv[argc + 1][0] == '-') */) {
        fprintf(stderr, "\nError: recheck your command-line arguments, you missed the last 3 mandatory ones\n");
        exit(1);
    }

    port                  = get_num(argv[argc + 1], 1);
    if(port < 0) {
        if(!loop) loop = -1;
        port_scan = 1;
        port = -port;
    }
    size                  = get_num(argv[argc + 2], 1);
    if(size < 0) dyn_size = 1;

    host                  = argv[argc];
    if(!host[0]) {
        // libpcap
        fp = pcap_get_device(port);
        peer.sin_addr.s_addr  = INADDR_ANY;
    } else if(mystrchrs(host, ",-")) {    // I can just call get_hosts directly
        if(!loop) loop = -1;                        // but in this way it's faster and safer
        host_scan = 0;
        hosts = get_hosts(host);
        if(!hosts) exit(1);
        peer.sin_addr.s_addr  = 0;
    } else {
        peer.sin_addr.s_addr  = resolv(host);
        if(!peer.sin_addr.s_addr) {
            if(!loop) loop = -1;
            bind_mode = 1;
        }
    }
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(0);
    peerl.sin_family      = AF_INET;
    if(spoof) {
        peerl.sin_addr.s_addr = resolv(spoof);
        if((peerl.sin_addr.s_addr == INADDR_NONE) || (peerl.sin_addr.s_addr == INADDR_ANY)) spoof = "";
    }

    if(peer.sin_addr.s_addr) {
        printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
    }
    if(!quiet) {
             if(pck_proto < 0) printf("- TCP mode\n");
        else if(!pck_proto)    printf("- UDP mode\n");
        else                   printf("- RAW mode (%d)\n", pck_proto);
    }

    if(!seed) seed = time(NULL);
    if(!quiet) printf("- random seed 0x%08x\n", seed);
    randit(&seed);

    //if(offset      < 0) offset = 0;   // NOT
    //if(offset      < 0) dyn_offset = 1;
    if(Xoffset     < 0) Xoffset = 0;
    if(zoffset     < 0) zoffset = 0;
    //if(hash_offset < 0) zoffset = 0;  // NOT

    if(content) {
        offset_bits = 0;
        old_offset = offset;
        t = 0;
        for(content_n = 0; content[content_n].data; content_n++) {
            offset = (content[content_n].offset == MYMAXINT) ? old_offset : content[content_n].offset;
            if(content[content_n].offset_is_bits) {
                offset_bits = offset;
                offset /= 8;
            }
            if((size >= 0) && (offset >= 0) && (content[content_n].size > (size - offset))) {
                content[content_n].size = size - offset;
            }
            if(t < content[content_n].size) t = content[content_n].size;
            if(offset < 0) {
                if(!quiet) printf("- appended content of %d bytes\n", content[content_n].size);
            } else {
                if(!quiet) printf("- content at offset %08x of %d bytes\n", offset, content[content_n].size);
            }
        }
        if(size < 0) {
            size = t;
            if(offset > 0) size += offset;
        }
        offset = old_offset;
    }
    if(size < 0) {
        fprintf(stderr, "\nError: pck_size must be major or equal than 0 and max 65535\n");
        exit(1);
    }
    if(!quiet) printf("- average or maximum packet size: %d\n", size);

    i = size;   // already contains also offset
    if(i < (Xoffset + 4))           i = Xoffset + 4;
    if(i < zoffset)                 i = zoffset;            // ???
    int hash_seedsz = 0;
    for(j = 0; j < hashcrcs; j++) if(hashcrc[j].hash_seedsz > hash_seedsz) hash_seedsz = hashcrc[j].hash_seedsz;
    if(i < (size + hash_seedsz))    i = size + hash_seedsz; // size already includes offset
    if(i < 0) i = 0;
    sendsize = i;
    BUFF_ALLOC  // useless, done later

    /*
    X checks
    */
    if((Xbits < 0) || (Xbits > (sizeof(Xnumber) * 8))) {
        fprintf(stderr, "\nError: wrong or unsupported -X bits value\n");
        exit(1);
    }
    if(Xbits) {
        if(!loop) {
            fprintf(stderr, "\nError: you must use the -l option with -X otherwise it does nothing\n");
            exit(1);
        }
    }
    if((Xoffset < 0) || (Xoffset > size)) {
        fprintf(stderr, "\nError: wrong -X offset value\n");
        exit(1);
    }
    if((zoffset < 0) || (zoffset > size)) {
        fprintf(stderr, "\nError: wrong -z offset value\n");
        exit(1);
    }

    if(randport) {
        peerl.sin_port      = htons((u16)~seed);
    } else {
        sd = create_socket(pck_proto, sd, NULL);
        if(sport) { // source port must be ever different than zero or the OS assigns the first free one
            peerl.sin_port  = GET_PORT(sport);
            if(!quiet) printf("- source port:  %hu\n", ntohs(peerl.sin_port));
            if(!spoof) {
                setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
                setsockopt(sd, SOL_SOCKET, SO_EXCLUSIVEADDRUSE, (char *)&on, sizeof(on));
                if(bind(sd, (struct sockaddr *)&peerl, sizeof(struct sockaddr_in))
                  < 0) std_err();
            }
        }
    }

    if(debug_pid) {
        debug_privileges();
        debug = 1;
        pid = get_pid(debug_pid);
        tid = quick_threadx(debugger, (void *)pid);
    }

    if(dllwhen >= 1) dllwhen--; // packet 1 must become packet 0

    content_n   = 0;
    // backups
    chr_bck     = chr;
    Xoffset_bck = Xoffset;
    Xnumber_bck = Xnumber;
    total_pcks  = 0;
redo:
    chr         = chr_bck;
    Xoffset     = Xoffset_bck;
    Xnumber     = Xnumber_bck;
    total_sent  = 0;

    if(content) {
        for(i = 0; content[i].data; i++) content[i].curr = 0;
    }

    // dyn_size must be fixed in some way or the multiple content with -l 0 will cause trouble!
    if(dyn_size && content) {
        size = (content[content_n].offset == MYMAXINT) ? old_offset : content[content_n].offset;
        if(content[content_n].offset_is_bits) {
            //size = 
            size /= 8;
        }
        size += content[content_n].size;
        if(verbose) printf("- content %d size %d\n", content_n, size);
    }
    if(size < 0) size = 0;
    //if(dyn_offset && content) offset = size - content[content_n].size;
    //if(offset < 0) offset = 0;

    sendsize = size;
    if(upsize) {
        if(!loop) {
            fprintf(stderr, "\nError: you must use the -l option with -x otherwise it does nothing\n");
            exit(1);
        }
        if(upsize > 0) sendsize = x_start;
    }
    if(sendsize > size) sendsize = size;

    if(!quiet) printf("\n- send packets:\n");
    print_time = time(NULL);
    for(;;) {
        if(debug_pid && !debug) break;
        if(host_scan >= 0) {
            peer.sin_addr.s_addr = hosts[host_scan++];
            if(!peer.sin_addr.s_addr) {
                if((loop <= 0) || (host_scan <= 1)) break;
                host_scan = 0;
                peer.sin_addr.s_addr = hosts[host_scan++];
            }
            if(!quiet) printf("\n");
            printf("- %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
        }

        if(loop && !bind_mode) {    // very useful
            if((u32)time(NULL) >= (print_time + 5)) {
                print_time = time(NULL);
                if(!quiet) printf("\n- Xoffset %08x   Xnumber %08x%08x   sendsize %08x/%d (%u)\n", Xoffset, (int)(Xnumber >> 32), (int)Xnumber, sendsize, sendsize, total_sent);
            }
        }

        if((pck_proto < 0) && !bind_mode) {
            if(!tcp_max1 || (tcp_max1 && !total_sent)) sd = create_socket(pck_proto, sd, NULL);
        }
        if(randport) {
            sd = create_socket(pck_proto, sd, NULL);
            i = 0;
            do {
                if(randport == 2) { // sequential
                    peerl.sin_port = GET_PORT(sport);
                    if(sport == -1) {
                        sport = -0xffff;
                    } else if(sport == 0xffff) {
                        sport = 1;
                    } else {
                        sport++;
                    }
                } else {
                    peerl.sin_port = randit(&seed);
                }
                if(spoof) break;
                i++;
                if(i > 10000) std_err();
            } while(bind(sd, (struct sockaddr *)&peerl, sizeof(struct sockaddr_in)) < 0);
        }

        BUFF_ALLOC
        if(chr_data) {
            for(i = 0; i < alloc_size; i++) {
                buff[i] = chr_data[i % chr_datasz];
            }
        } else {
            if(randbyte == 0) {
                lamemset(buff, chr, alloc_size, chr_bits);
            } else if(randbyte == 1) {
                create_rand_byte(buff, alloc_size, &seed, seed_charset);
            } else if(randbyte == 2) {
                //if(chr < 0) chr = 0;  // ok I leave uncommented because it's cool the format string
                lamemset(buff, chr, alloc_size, chr_bits);
                chr++;
            }
        }

        if(content) {
            offset_bits = 0;
            if(dyn_size) sendsize = 0;
            if(!content[content_n].data) content_n = 0;
            old_offset = offset;
            old_content_n = content_n;
            for(n = 0; content[content_n].data; n++) {
                if(content[content_n].curr >= content[content_n].times) {
                    content[content_n].curr = 0;
                    content_n++;
                    continue;
                }
                if(content[content_n].offset == MYMAXINT) {
                    if(n && (content[content_n].curr < content[content_n].times)) break;
                    if(content_n != old_content_n) break;
                }
                offset = (content[content_n].offset == MYMAXINT) ? old_offset : content[content_n].offset;
                if(content[content_n].offset_is_bits) {
                    offset_bits = offset;
                    offset /= 8;
                }
                t = content[content_n].size;
                //if(offset < 0) offset += (size - t) + 1;
                if(offset == -1) offset = -t;
                if(offset < 0) offset = size + offset;
                if(offset < 0) offset = 0;
                if(dyn_size) {
                    if((offset + t) > sendsize) sendsize = offset + t;
                } else {
                    if((offset + t) > sendsize) t = sendsize - offset;
                }
                BUFF_ALLOC

                if(t < 0) t = 0;
                if(t > 0) {
                    if((upsize > 0) && upsizex && (x_start >= offset) && ((offset + t) < sendsize)) {
                        i = x_start - offset;
                        if(i > t) i = t;
                        if(offset_bits) memcpy_bits(buff, offset_bits, content[content_n].data, i);
                        else            memcpy(buff + offset, content[content_n].data, i);
                        if(t > i) memcpy(buff + sendsize - (t - i), content[content_n].data + i, t - i);
                    } else if((upsize < 0) && upsizex && (x_start >= offset)) {
                        i = x_start - offset;
                        if(i > t) i = t;
                        if(offset_bits) memcpy_bits(buff, offset_bits, content[content_n].data, i);
                        else            memcpy(buff + offset, content[content_n].data, i);
                        //memcpy(buff + x_start, content[content_n].data + content[content_n].size - (sendsize - x_start), sendsize - x_start);
                        if(t > i) {
                            // offset_bits not supported here
                            memcpy(buff + sendsize - (t - i), content[content_n].data + content[content_n].size - (t - i), t - i);
                        }
                    } else {
                        if(offset_bits) memcpy_bits(buff, offset_bits, content[content_n].data, t);
                        else            memcpy(buff + offset, content[content_n].data, t);
                    }
                }
                content[content_n].curr++;
            }
            //content_n = old_content_n;
            offset = old_offset;
        }
        if(Xbits) {
            if(Xrandom) {
                putxx(buff + Xoffset, randit(&seed), Xbits, Xendian);
            } else {
                putxx(buff + Xoffset, Xnumber, Xbits, Xendian);
            }
        }

        zlen = 0;
        if(zbits) {
            if(!sendbuff) {
                z.zalloc = (alloc_func)0;
                z.zfree  = (free_func)0;
                z.opaque = (voidpf)0;
                if(deflateInit2(&z, Z_BEST_COMPRESSION, Z_DEFLATED, zbits, Z_BEST_COMPRESSION, Z_DEFAULT_STRATEGY) != Z_OK) {
                    fprintf(stderr, "\nError: zlib initialization error\n");
                    exit(1);
                }
                sendbuff = calloc(ZLIBMAX(alloc_size), 1);
                if(!sendbuff) std_err();
            }
            // sendbuff is needed because compression must take place on a different buffer
            memcpy(sendbuff, buff, sendsize);
            if(sendsize >= zoffset) {
                zlen = sendsize - zoffset;
                zlen = zip(&z, buff + zoffset, zlen, sendbuff + zoffset, ZLIBMAX(zlen));
                if(!quiet) printf("- zlen: %d\n", zlen);
                zlen = (zoffset + zlen) - sendsize;
            }
            sendlen  = sendsize + zlen;
        } else {
            sendbuff = buff;    // in case of realloc and so on... useless but saves memory
            sendlen  = sendsize;
        }

        oldbuf = sendbuff;  // keep it here to avoid free() bugs
        if(plugins && (total_pcks >= dllwhen)) {
            for(i = 0; i < plugins; i++) {
                if(plugin[i].sudp_pck) sendlen = plugin[i].sudp_pck(sendbuff, sendlen); // packets modification
                if(plugin[i].mysendto || plugin[i].mysend) {
                    if(plugin[i].mysendto) {
                        sendlen = plugin[i].mysendto(sd, (char **)&sendbuff, sendlen, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));
                    } else {
                        sendlen = plugin[i].mysend(sd, (char **)&sendbuff, sendlen, 0);
                    }
                    if(sendlen < 0) {
                        //fprintf(stderr, "\nError: mysend/mysendto plugin returned the error %d\n", sendlen);
                        //exit(1);
                    }
                }
            }
        }

        // from this point no longer use buff, use: sendbuff
        if(sendlen < 0) goto skip_send;

        for(j = 0; j < hashcrcs; j++) {
            if(hashcrc[j].hash_algo) { // no additional checks for this func, it's basic
                i = hashcrc[j].hash_end;   // like SEEK_END if negative
                if(!i) i = sendlen;
                if(i < 0) i = sendlen + hashcrc[j].hash_end; // + because it's negative
                if(i < 0) i = sendlen;
                t = hashcrc[j].hash_start;
                if(t < 0) t = i + hashcrc[j].hash_start;
                if(t < 0) t = 0;
                if(hashcrc[j].hash_seed && hashcrc[j].hash_seedsz) memcpy(sendbuff + i, hashcrc[j].hash_seed, hashcrc[j].hash_seedsz);
                myhash(hashcrc[j].hash_algo, sendbuff + hashcrc[j].hash_offset, sendbuff + t, (i - t) + hashcrc[j].hash_seedsz, hashcrc[j].crc_ctx);
            }
        }

        if(dumpsend) {
            i = sendlen;
            if(!quiet) printf("%u bytes (0x%x)\n", i, i);
            if((dumpsend > 0) && (i > dumpsend)) i = dumpsend;
            show_dump(sendbuff, i, stdout);
        } else {
            //if(!dumprecv && !quiet && !bind_mode) fputc('.', stdout);
            if(!quiet && !bind_mode) fputc('.', stdout);
        }
        if((pck_proto < 0) && !bind_mode) {  // connect it
            if(!tcp_max1 || (tcp_max1 && !total_sent)) sd = create_socket(pck_proto, sd, &peer);
        }

        // ICMP crc
        if((pck_proto == 1) && (sendlen >= 4)) {
            putxx(sendbuff + 2, 0, 16, BIG_ENDIAN);
            putxx(sendbuff + 2, ~crc_in_cksum(0, sendbuff, sendlen), 16, BIG_ENDIAN);

        // UDP crc
        } else if((pck_proto == 17) && (sendlen >= 8)) {
            typedef struct {
                u32     saddr;
                u32     daddr;
                u8      zero;
                u8      protocol;
                u16     length;
            } udp_pseudohdr_t;
            u8      *pseudohdr = NULL;

            putxx(sendbuff + 6, 0, 16, BIG_ENDIAN);
            pseudohdr = realloc(pseudohdr, sizeof(udp_pseudohdr_t) + sendlen);
            memcpy(pseudohdr + sizeof(udp_pseudohdr_t), sendbuff, sendlen);
            ((udp_pseudohdr_t *)pseudohdr)->saddr = 0;  // wrong, I don't know the interface. this code may be udpated in future
            ((udp_pseudohdr_t *)pseudohdr)->daddr = peer.sin_addr.s_addr;
            ((udp_pseudohdr_t *)pseudohdr)->zero = 0;
            ((udp_pseudohdr_t *)pseudohdr)->protocol = pck_proto;
            ((udp_pseudohdr_t *)pseudohdr)->length = htons(sendlen);
            putxx(sendbuff + 6, ~crc_in_cksum(0, pseudohdr, sizeof(udp_pseudohdr_t) + sendlen), 16, BIG_ENDIAN);
        }

        if(spoof) {
            if(!spoof[0]) peerl.sin_addr.s_addr = randit(&seed);
            if(udpspoof(peerl.sin_addr.s_addr, peerl.sin_port, peer.sin_addr.s_addr, peer.sin_port, sendbuff, sendlen) < 0) {
                fprintf(stderr, "\n"
                    "Error: spoofing failed, are you root or admin?\n"
                    "       does your OS support RAW sockets? has it limitations on spoofing?\n"
                    "       possible causes: OS or OS configuration, network configuration, being\n"
                    "       behind a router/NAT, ISP blocks spoofing and others...\n"
                    "\n"
                    "       if the problem is caused by the Operating System a solution can be the\n"
                    "       usage of another OS via a Virtual Machine: on the same computer where I\n"
                    "       have these problems it has been enough to launch Windows 2003 or Linux\n"
                    "       through VirtualBox for bypassing the spoofing limitations of Windows XP\n"
                    );
                exit(1);
            }
        } else {
            if(pck_proto < 0) {
                if(bind_mode) { // lame experiment, I don't care
                    if(sdl <= 0) {
                        peer.sin_addr.s_addr  = INADDR_ANY;
                        peer.sin_port         = htons(port);
                        peer.sin_family       = AF_INET;
                        sdl = create_socket(pck_proto, sdl, &peer);
                        setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
                        setsockopt(sdl, SOL_SOCKET, SO_EXCLUSIVEADDRUSE, (char *)&on, sizeof(on));
                        if(bind(sdl, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
                          < 0) std_err();
                        listen(sdl, SOMAXCONN);
                    }
                    i = sizeof(struct sockaddr_in);
                    sd = accept(sdl, (struct sockaddr *)&peer, &i);
                    if(!quiet) printf("- %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
                    if(dumprecv) {
                        n = recvshow(sd, pck_proto, dumprecv);
                        if(n == -2) {
                            if(!loop) break;
                        }
                        if(n == -1) break;
                    }
                }
                if(fp) {
                    if(_pcap_sendpacket(fp, sendbuff, sendlen) < 0) pcap_error(NULL, "pcap_sendpacket failure");
                } else {
                    send(sd, sendbuff, sendlen, 0); // better to not call std_err()
                }
            } else {
                if(bind_mode) { // lame experiment, I don't care
                    if(!recvbuff) recvbuff = malloc(0xffff);
                    peer.sin_addr.s_addr  = INADDR_ANY;
                    peer.sin_port         = htons(port);
                    peer.sin_family       = AF_INET;
                    setsockopt(sdl, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
                    setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
                    setsockopt(sdl, SOL_SOCKET, SO_EXCLUSIVEADDRUSE, (char *)&on, sizeof(on));
                    bind(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in));
                    for(;;) {
                        i = sizeof(struct sockaddr_in);
                        i = recvfrom(sd, recvbuff, 0xffff, 0, (struct sockaddr *)&peer, &i);
                        if(i >= 0) break;
                        //sleepms(500); // never
                    }
                    if(!quiet) printf("- %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));
                    show_dump(recvbuff, i, stdout);
                }
                if(fp) {
                    if(_pcap_sendpacket(fp, sendbuff, sendlen) < 0) pcap_error(NULL, "pcap_sendpacket failure");
                } else {
                    if(sendto(sd, sendbuff, sendlen, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
                     < 0) std_err();
                }
            }
        }
        //total_sent += sendlen;
        total_sent++;   // this is more useful than the total amount of bytes
        total_pcks++;

skip_send:
        // lame, only one is supported
        if(plugin[0].mysendto || plugin[0].mysend) {
            if(oldbuf != sendbuff) free(sendbuff);
            sendbuff = oldbuf;
        }

        if(dumprecv && !bind_mode) {

            if(do_not_close_socket && loop) {
                endless_recvshow_args.sd = sd; \
                endless_recvshow_args.pck_proto = pck_proto; \
                endless_recvshow_args.dumprecv = dumprecv; \
                quick_threadx(endless_recvshow, (void *)&endless_recvshow_args); \
            } else {
                n = recvshow(sd, pck_proto, dumprecv);
                if((n == -1) || (n == -2)) break;
            }
        }

        /* old solution that worked
        if(randport || (pck_proto < 0) {
            if(!tcp_max1) {
                CLOSE_SD(sd);
            } else if(tcp_max1 == (u32)-1) {
                // do nothing because it's endless
            } else if(total_sent >= tcp_max1) {
                CLOSE_SD(sd);
                break;
            }
        }
        */

            if(!tcp_max1) {
                // do nothing //CLOSE_SD(sd);
                if(!loop) break;
            } else if(tcp_max1 == (u32)-1) {
                // do nothing because it's endless
                if(!loop && content && !content[content_n].data) break;
            } else if(total_sent >= tcp_max1) {
                if(!loop) {
                    while(content[content_n].data) content_n++;
                    break;
                }
                total_sent = 0;
            }

        //if(!loop) break;

        if(port_scan) peer.sin_port = htons(++port);
        if(port > 65535) break;
        if(upsize > 0) {    // increase
            if(sendsize >= size) break;
            sendsize += upsize;
        }
        if(upsize < 0) {    // decrease
            if(sendsize <= x_start) break;
            sendsize += upsize; // + because upsize is negative
        }
        if(Xbits && !Xrandom) {
            if(Xfuzz_value) {
                if(Xfuzz_valuen >= Xfuzz_values) {
                    Xfuzz_valuen = 0;
                    Xoffset++;
                }
                Xnumber = Xfuzz_value[Xfuzz_valuen];
                Xfuzz_valuen++;
            } else if(Xbitflip >= 0) {
                if(Xbitflip >= Xbits) {
                    Xbitflip = 0;
                    Xoffset++;
                }
                Xnumber = getxx(buff + Xoffset, Xbits, Xendian);
                Xnumber ^= (u64)((u64)1 << (u64)Xbitflip);
                Xbitflip++;
            } else if(Xmagic) {
                Xnumber += Xmagic;
            } else {
                Xnumber++;
            }
            if(Xnumber > Xmask) {  // NOT >=
                if(Xfuzz_value) {
                    // do nothing, already handled
                } else {
                    if(!Xmagic) break;
                    Xnumber &= Xmask; //Xnumber = 0;
                    Xoffset++;
                    // why? because I want that also the last byte gets scanned :)
                    //if((Xoffset + (Xbits / 8)) > size) break;
                    if(Xoffset > size) break;
                }
            }
        }
        if(!upsize && (randbyte == 2)) { // sequential
            if(chr_data) {
                for(i = 0; i < chr_datasz; i++) {
                    chr_data[i]++;
                }
            } else {
                if(chr_bck == -1) {
                    if(chr > 0xff) break;
                } else {
                    if((chr & 0xff) == chr_bck) break;
                }
            }
        }
        if(randbyte == 2) {
            if(chr_data) {
            } else {
                if((chr_bck >= 0) && (chr_bck <= 0xff)) chr &= 0xff;
            }
        }

        if(loopms < 0) {
            fgets(tmp, sizeof(tmp), stdin);
        } else {
            sleepms(loopms);    // do it even if zero to limit congestion
        }

        if(randport || (pck_proto < 0)) {
            if(!tcp_max1) CLOSE_SD(sd);
        }
    }
    if(content && content[content_n].data) {
        if(content[content_n].curr >= content[content_n].times) {
            content[content_n].curr = 0;
            content_n++;
        }
        if(content[content_n].data) goto redo;
    }

    CLOSE_SD(sd);
    if(zbits) inflateEnd(&z);
    if(sendbuff && (sendbuff != buff)) free(sendbuff);
    if(buff) free(buff);
    if(hLib)  CLOSEDLL
    if(debug && tid) {
        printf("\n- wait the detaching of the debugger\n");
        debug = 0;
        quick_threadz(tid);
    }
    printf("\n- finished\n");
    return(0);
}



void mypush(u64 **buff, int *el, u64 n) {
    int     i;

    if(!buff || !el) return;

    for(i = 0; i < *el; i++) {
        if((*buff)[i] == n) return;
    }
    *buff = realloc(*buff, (*el + 1) * sizeof(**buff));
    if(!*buff) std_err();
    (*buff)[*el] = n;
    (*el)++;
}



void pcap_error(pcap_if_t *alldevs, char *err) {
    printf("\nError: %s\n", err);
    if(alldevs) _pcap_freealldevs(alldevs);
    exit(1);
}



pcap_t *pcap_get_device(int dev) {
    pcap_t      *fp;
    pcap_if_t   *alldevs,
                *d;
    int         i,
                inum;
    char        tmp[16],
                errbuf[PCAP_ERRBUF_SIZE];

    if(pcap_antidll_init() < 0) {
        fprintf(stderr, "\nError: you don't have WinPcap/libpcap installed\n");
        exit(1);
    }

    if(_pcap_findalldevs(&alldevs, errbuf) < 0) pcap_error(alldevs, errbuf);

    printf("- interfaces:\n\n");
    for(i = 0, d = alldevs; d; d = d->next) {
        printf("%-2d %s\n", ++i, d->name);
        if(d->description) printf("   %s\n", d->description);
    }

    if(i > 1) {
        if(dev <= 0) {
            printf("\n- enter the interface number (1 - %d): ", i);
            fgets(tmp, sizeof(tmp), stdin);
            sscanf(tmp, "%d", &inum);
        } else {
            inum = dev;
        }
        if(inum < 1 || inum > i) pcap_error(alldevs, "interface number out of range");
    } else if(!i) {
        pcap_error(alldevs,
            "No interfaces found or you don't have the needed permissions.\n"
            "       Make sure Pcap/WinPcap is installed and you are root or admin");
    } else {
        inum = 1;
    }

    for(inum--, d = alldevs, i = 0; i < inum; i++, d = d->next);
    printf("- adapter to use: %s\n", d->name);

    fp = _pcap_open_live(d->name, 0xffff, 1, 100, errbuf);
    if(!fp) pcap_error(alldevs, errbuf);

    _pcap_freealldevs(alldevs);

    _pcap_datalink(fp);
    //if_offset = pcap_hdrlen(pcap_datalink(fp));
    //if(if_offset < 0) pcap_error(alldevs, "pcap interface not supported by this tool");

    return(fp);
}



int debug_privileges(void)  {
#ifdef WIN32
    TOKEN_PRIVILEGES tp;
    HANDLE  hp;

    if(!OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY | TOKEN_ADJUST_PRIVILEGES, &hp)) return(-1);
    memset(&tp, 0, sizeof(tp));
    tp.PrivilegeCount = 1;
    tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
    if(!LookupPrivilegeValue(NULL, SE_DEBUG_NAME, &tp.Privileges[0].Luid)) return FALSE;
    if(!AdjustTokenPrivileges(hp, FALSE, &tp, sizeof(tp), NULL, NULL)) return(-1);
    CloseHandle(hp);
#endif
    return(0);
}



u32 *get_hosts(u8 *str) {
    u32     *ret    = NULL;
    int     i,
            n,
            a       = 0,
            b       = 0,
            c       = 0,
            d       = 0,
            x       = 0,
            hosts   = 0;
    u8      tmp[16] = "",
            *l;

    for(;;) {
        l = mystrchrs(str, ",;|");
        if(l) *l = 0;

        i = sscanf(str, "%d.%d.%d.%d%c", &a, &b, &c, &d, tmp);
        if(i == 3) {        // class B
            sscanf(str, "%d.%d.%d-%d", &a, &b, &c, &x);
            a &= 0xff;
            b &= 0xff;
            c &= 0xff;
            d &= 0xff;
            x &= 0xff;
            if(x < c) {
                //x = 255;
                fprintf(stderr, "\nError: you inserted a wrong IP range to scan (%s)\n", str);
                exit(1);
            }
            n = ((x - c) + 1) * 256;
            ret = realloc(ret, (hosts + n) * sizeof(u32));
            if(!ret) std_err();
            d = 1;  // 0 and 255 should be skipped, 0 for sure
            for(i = 0; i < n; i++) {
                if(d > 255) {
                    d = 0;
                    c++;
                }
                if(c > x) break;
                ret[hosts++] = a | (b << 8) | (c << 16) | (d << 24);
                d++;
            }

        } else if(i == 5) { // class C
            sscanf(str, "%d.%d.%d.%d-%d", &a, &b, &c, &d, &x);
            a &= 0xff;
            b &= 0xff;
            c &= 0xff;
            d &= 0xff;
            x &= 0xff;
            if(x < d) {
                //x = 255;
                fprintf(stderr, "\nError: you inserted a wrong IP range to scan (%s)\n", str);
                exit(1);
            }
            n = (x - d) + 1;
            ret = realloc(ret, (hosts + n) * sizeof(u32));
            if(!ret) std_err();
            for(i = 0; i < n; i++) {
                if(d > x) break;
                ret[hosts++] = a | (b << 8) | (c << 16) | (d << 24);
                d++;
            }

        } else {
            ret = realloc(ret, (hosts + 1) * sizeof(u32));
            if(!ret) std_err();
            ret[hosts++] = resolv(str);
        }

        if(!l) break;
        str = l + 1;
    }

    if(ret) {
        ret = realloc(ret, (hosts + 1) * sizeof(u32));
        if(!ret) std_err();
        ret[hosts] = 0;
    }
    return(ret);
}



u8 *process_list(u8 *myname, DWORD *mypid, DWORD *size) {
#ifdef WIN32
    PROCESSENTRY32  Process;
    MODULEENTRY32   Module;
    HANDLE          snapProcess,
                    snapModule;
    DWORD           retpid = 0;
    int             len;
    BOOL            b;
    u8              tmpbuff[60],
                    *process_name,
                    *module_name,
                    *module_print,
                    *tmp;

    if(mypid) retpid = *mypid;
    if(!myname && !retpid) {
        printf(
            "  pid/addr/size       process/module name\n"
            "  ---------------------------------------\n");
    }

#define START(X,Y) \
            snap##X = CreateToolhelp32Snapshot(Y, Process.th32ProcessID); \
            X.dwSize = sizeof(X); \
            for(b = X##32First(snap##X, &X); b; b = X##32Next(snap##X, &X)) { \
                X.dwSize = sizeof(X);
#define END(X) \
            } \
            CloseHandle(snap##X);

    Process.th32ProcessID = 0;
    START(Process, TH32CS_SNAPPROCESS)
        process_name = Process.szExeFile;

        if(!myname && !retpid) {
            printf("  %-10lu ******** %s\n",
                Process.th32ProcessID,
                process_name);
        }
        if(myname && stristr(process_name, myname)) {
            retpid = Process.th32ProcessID;
        }

        START(Module, TH32CS_SNAPMODULE)
            module_name = Module.szExePath; // szModule?

            len = strlen(module_name);
            if(len >= 60) {
                tmp = strrchr(module_name, '\\');
                if(!tmp) tmp = strrchr(module_name, '/');
                if(!tmp) tmp = module_name;
                len -= (tmp - module_name);
                sprintf(tmpbuff,
                    "%.*s...%s",
                    54 - len,
                    module_name,
                    tmp);
                module_print = tmpbuff;
            } else {
                module_print = module_name;
            }

            if(!myname && !retpid) {
                printf("    %p %08lx %s\n",
                    Module.modBaseAddr,
                    Module.modBaseSize,
                    module_print);
            }
            if(!retpid) {
                if(myname && stristr(module_name, myname)) {
                    retpid = Process.th32ProcessID;
                }
            }
            if(retpid && mypid && (Process.th32ProcessID == retpid)) {
                printf("- %p %08lx %s\n",
                    Module.modBaseAddr,
                    Module.modBaseSize,
                    module_print);
                *mypid = retpid;
                if(size) *size = Module.modBaseSize;
                return(Module.modBaseAddr);
            }

        END(Module)

    END(Process)

#undef START
#undef END

#else

    //system("ps -eo pid,cmd");
    printf("\n"
        "- use ps to know the pids of your processes, like:\n"
        "  ps -eo pid,cmd\n");

#endif

    return(NULL);
}



DWORD get_pid(u8 *str) {
    DWORD   pid;
    u8      *baddr;

    if(!str) return(0);
    if((str[0] >= '0') && (str[0] <= '9')) return(atoi(str));
    baddr = process_list(str, &pid, NULL);
    if(!baddr) {
        fprintf(stderr, "\nError: process name/PID not found, use -p\n");
        exit(1);
    }
    return(pid);
}



#ifdef WIN32
static BOOL WINAPI (*_DebugSetProcessKillOnExit)(BOOL) = NULL;
static BOOL WINAPI (*_DebugActiveProcessStop)(DWORD) = NULL;
int debug_missing(void) {
    static HMODULE kernel32 = NULL;

    if(!kernel32) kernel32 = LoadLibrary("kernel32.dll");
    if(kernel32) {
        if(!_DebugSetProcessKillOnExit)
            _DebugSetProcessKillOnExit = (void *)GetProcAddress(kernel32, "DebugSetProcessKillOnExit");
        if(!_DebugActiveProcessStop)
            _DebugActiveProcessStop = (void *)GetProcAddress(kernel32, "DebugActiveProcessStop");
        if(_DebugSetProcessKillOnExit && _DebugActiveProcessStop) return(0);
    }
    return(-1);
}



u8 *show_exception(DWORD status) {
    static u8   tmp[32];
    u8          *ret = "";

    switch(status) {
        case STATUS_ACCESS_VIOLATION:           ret = "ACCESS_VIOLATION"; break;
        case STATUS_IN_PAGE_ERROR:              ret = "IN_PAGE_ERROR"; break;
        case STATUS_INVALID_HANDLE:             ret = "INVALID_HANDLE"; break;
        case STATUS_NO_MEMORY:                  ret = "NO_MEMORY"; break;
        case STATUS_ILLEGAL_INSTRUCTION:        ret = "ILLEGAL_INSTRUCTION"; break;
        case STATUS_NONCONTINUABLE_EXCEPTION:   ret = "NONCONTINUABLE_EXCEPTION"; break;
        case STATUS_INVALID_DISPOSITION:        ret = "INVALID_DISPOSITION"; break;
        case STATUS_ARRAY_BOUNDS_EXCEEDED:      ret = "ARRAY_BOUNDS_EXCEEDED"; break;
        case STATUS_FLOAT_DENORMAL_OPERAND:     ret = "FLOAT_DENORMAL_OPERAND"; break;
        case STATUS_FLOAT_DIVIDE_BY_ZERO:       ret = "FLOAT_DIVIDE_BY_ZERO"; break;
        case STATUS_FLOAT_INEXACT_RESULT:       ret = "FLOAT_INEXACT_RESULT"; break;
        case STATUS_FLOAT_INVALID_OPERATION:    ret = "FLOAT_INVALID_OPERATION"; break;
        case STATUS_FLOAT_OVERFLOW:             ret = "FLOAT_OVERFLOW"; break;
        case STATUS_FLOAT_STACK_CHECK:          ret = "FLOAT_STACK_CHECK"; break;
        case STATUS_FLOAT_UNDERFLOW:            ret = "FLOAT_UNDERFLOW"; break;
        case STATUS_INTEGER_DIVIDE_BY_ZERO:     ret = "INTEGER_DIVIDE_BY_ZERO"; break;
        case STATUS_INTEGER_OVERFLOW:           ret = "INTEGER_OVERFLOW"; break;
        case STATUS_PRIVILEGED_INSTRUCTION:     ret = "PRIVILEGED_INSTRUCTION"; break;
        case STATUS_STACK_OVERFLOW:             ret = "STACK_OVERFLOW"; break;
        case STATUS_CONTROL_C_EXIT:             ret = "CONTROL_C_EXIT"; break;
        //case STATUS_DLL_INIT_FAILED:            ret = "DLL_INIT_FAILED"; break;
        //case STATUS_DLL_INIT_FAILED_LOGOFF:     ret = "DLL_INIT_FAILED_LOGOFF"; break;
        default: {
            sprintf(tmp, "%08x", (int)status);
            ret = tmp;
            break;
        }
    }
    return(ret);
}



quick_thread(endless_recvshow, endless_recvshow_args_t *args) {
    int     n;

    for(;;) {
        n = recvshow(args->sd, args->pck_proto, args->dumprecv);
        if(n == -1) break;
    }
    return 0;
}



// the debugging stuff must be handled by the same thread or will not work
quick_thread(debugger, int pid) {
    DEBUG_EVENT *dbg = NULL;
    int     i,
            dbg_do;

    if(!pid) return(0);

    for(i = 5; i >= 0; i--) {
        if(DebugActiveProcess(pid)) break;
        Sleep(ONESEC);
    }
    if(i < 0) goto quit; //winerr();
    printf("- debugger attached to pid %d\n", (int)pid);

    dbg = calloc(1, sizeof(DEBUG_EVENT));
    while(debug) {
        if(!WaitForDebugEvent(dbg, 500)) continue;
        dbg_do = DBG_CONTINUE;
        if(dbg->dwDebugEventCode == EXCEPTION_DEBUG_EVENT) {
            if((dbg->u.Exception.ExceptionRecord.ExceptionCode & 0xff000000) == 0xc0000000) {
                // dbg->u.Exception.dwFirstChance not handled to catch also the non critical errors
                printf("\n\nDEBUG exception: %08x %s:",
                    (int)dbg->u.Exception.ExceptionRecord.ExceptionAddress,
                    show_exception(dbg->u.Exception.ExceptionRecord.ExceptionCode));
                for(i = 0; i < dbg->u.Exception.ExceptionRecord.NumberParameters; i++) {
                    printf(" %08x", (int)dbg->u.Exception.ExceptionRecord.ExceptionInformation[i]);
                }
                printf("\n");
            }
            dbg_do = DBG_EXCEPTION_NOT_HANDLED;

        } else if(dbg->dwDebugEventCode == EXIT_PROCESS_DEBUG_EVENT) {
            printf("\n\nDEBUG exit: %08x\n\n",
                (int)dbg->u.ExitProcess.dwExitCode);
            break;

        } else if(dbg->dwDebugEventCode == RIP_EVENT) {
            printf("\n\nDEBUG rip: %08x %08x\n\n",
                (int)dbg->u.RipInfo.dwError,
                (int)dbg->u.RipInfo.dwType);
            break;
        }
        if(!ContinueDebugEvent(dbg->dwProcessId, dbg->dwThreadId, dbg_do)) break;
    }
quit:
    debug_missing();
    _DebugActiveProcessStop(pid);
    printf("- debugger detached\n");
    free(dbg);
    debug = 0;
    return(0);
}
#else
quick_thread(debugger, int pid) {
    return(0);
}
#endif



void show_dump(unsigned char *data, unsigned int len, FILE *stream) {
    int                 t,
                        rem,
                        left = 2 + 8 + 2;
    static const char   hex[16] = "0123456789abcdef";
    unsigned char       leftbuff[80],
                        buff[67],
                        chr,
                        *bytes,
                        *p,
                        *limit,
                        *glimit = data + len,
                        *base_data = data;

    u8      fast_stdout[BUFSIZ];    // Win7 is a pain
    setbuf(stdout, fast_stdout);

    memset(buff + 2, ' ', 48);
    memset(leftbuff, ' ', sizeof(leftbuff));

    while(data < glimit) {
        t = sprintf(leftbuff, "  %08x ", data - base_data);
        leftbuff[t] = ' ';

        limit = data + 16;
        if(limit > glimit) {
            limit = glimit;
            memset(buff, ' ', 48);
        }

        p     = buff;
        bytes = p + 50;
        while(data < limit) {
            chr = *data;
            *p++ = hex[chr >> 4];
            *p++ = hex[chr & 15];
            p++;
            *bytes++ = ((chr < ' ') || (chr >= 0x7f)) ? '.' : chr;
            data++;
        }
        *bytes++ = '\n';

        for(rem = left; rem >= (int)sizeof(leftbuff); rem -= sizeof(leftbuff)) {
            fwrite(leftbuff, sizeof(leftbuff), 1, stream);
        }
        if(rem > 0) fwrite(leftbuff, rem, 1, stream);
        fwrite(buff, bytes - buff, 1, stream);
    }

    setbuf(stdout, NULL);
}



void loaddll(u8 *fname, u8 *par) {
    if(!fname) return;

    if(!quiet) printf("- load library %s\n", fname);

    if(strchr(fname, ',')) {
        fprintf(stderr, "\nError: you must use another -L option if you want to use multiple libraries\n");
        exit(1);
    }

    if(plugins >= MAX_PLUGINS) {
        fprintf(stderr, "\nError: you can't use additional plugins\n");
        exit(1);
    }
    LOADDLL
    GETFUNC(plugin[plugins].sudp_init,  "sudp_init")
    GETFUNC(plugin[plugins].sudp_pck,   "sudp_pck")
    GETFUNC(plugin[plugins].mysend,     "mysend")
    GETFUNC(plugin[plugins].mysendto,   "mysendto")
    GETFUNC(plugin[plugins].myrecv,     "myrecv")
    GETFUNC(plugin[plugins].myrecvfrom, "myrecvfrom")

    if(plugin[plugins].sudp_init && par && plugin[plugins].sudp_init(par)) {
        fprintf(stderr, "\nError: plugin initialization failed\n\n");
        CLOSEDLL
        exit(1);
    }
    plugins++;
}



void load_content(u8 *filename, int type, int offset, int times, int offset_is_bits) {

#define LOAD_CONTENT_DOIT { \
                    data = load_xstring(p, type, &size); \
                    memset(&content[contents + i], 0, sizeof(content_t)); \
                    content[contents + i].offset = offset; \
                    content[contents + i].offset_is_bits = offset_is_bits; \
                    if(!times) times = 1; \
                    content[contents + i].times  = times; \
                    content[contents + i].data   = data; \
                    content[contents + i].size   = size; \
                }
    int     i,
            size,
            doit,
            contents    = 0;
    u8      *data,
            *p,
            *l;

    if(!filename) return;
    if(content) {
        for(i = 0; content[i].data; i++);
        contents = i;
    }

    if(type < 0) {  // file
        for(doit = 0; doit < 2; doit++) {
            i = 0;
            for(p = filename; p && *p; p = l + 1) {
                l = mystrchrs(p, ",;|");
                if(doit) {
                    if(l) *l = 0;
                    LOAD_CONTENT_DOIT
                }
                i++;
                if(!l) break;
            }
            if(!doit && i) {
                content = realloc(content, (contents + i + 1) * sizeof(content_t));
                if(!content) std_err();
            }
        }
    } else {
        i = 1;
        content = realloc(content, (contents + i + 1) * sizeof(content_t));
        if(!content) std_err();
        i = 0;
        p = filename;
        LOAD_CONTENT_DOIT
        i++;
    }

    memset(&content[contents + i], 0, sizeof(content_t));
    content[contents + i].offset = MYMAXINT;
    content[contents + i].offset_is_bits = 0;
    content[contents + i].times  = 0;
    content[contents + i].data   = NULL;
    content[contents + i].size   = 0;
}



void lamemset(u8 *data, int chr, int size, int chr_bits) {
    int     i;

    if(chr == -1) { // format string... bad boy :)
        for(i = 0; i < size; i++) {
            if(i & 1) {
                if((i % 11) == 2) data[i] = 'n';
                else data[i] = 's';
            } else {
                data[i] = '%';
            }
        }
    //} else if((chr >= 0) && (chr <= 0xff)) {
    } else if(chr_bits == 8) {
        memset(data, chr, size);
    } else if(chr_bits == 16) {
        for(i = 0; (i + 2) <= size; i += 2) {
            putxx(data + i, chr, 16, LITTLE_ENDIAN);
        }
        memset(data + i, chr, size - i);
    } else {
        for(i = 0; (i + 4) <= size; i += 4) {
            putxx(data + i, chr, 32, LITTLE_ENDIAN);
        }
        memset(data + i, chr, size - i);
    }
}



int myisalnum(int chr) {
    if((chr >= '0') && (chr <= '9')) return(1);
    if((chr >= 'a') && (chr <= 'z')) return(1);
    if((chr >= 'A') && (chr <= 'Z')) return(1);
    if(chr == '-') return(1);   // negative number
    //if(chr == '+') return(1);   // positive number
    return(0);
}



// alternative to sscanf so it's possible to use also commas and hex numbers
int get_parameter_numbers(u8 *s, ...) {
    va_list ap;
    int     i,
            *par;

    // do NOT reset the parameters because they could have default values different than 0!

    if(!s) return(0);
    va_start(ap, s);
    for(i = 0;; i++) {
        par = va_arg(ap, int *);
        if(!par) break;

        while(*s && !myisalnum(*s)) s++;
        if(!*s) break;
        *par = get_num(s, 0);
        while(*s && myisalnum(*s)) s++;
        if(!*s) break;
    }
    va_end(ap);
    return(i);
}



void myhash(int hash_algo, u8 *out, u8 *in, int insz, crc_context *crc_ctx) {
    static int  init = 0;
    u32     crc,
            *p32;
    u8      tmp[32];

    if(insz < 0) return;    // insz equal to zero has a valid CRC and hash!
    switch(hash_algo) {
        case HASH_MD5: {
            if((out > in) && ((out + 16) <= (in + insz))) memset(out, 0, 16);
            md5(in, insz, out);
            break;
        }
        case HASH_MD5_4: {
            if((out > in) && ((out + 4) <= (in + insz))) memset(out, 0, 4);
            md5(in, insz, tmp);
            p32 = (u32 *)tmp;
            putxx(out, p32[0] ^ p32[1] ^ p32[2] ^ p32[3], 32, Hendian);
            break;
        }

        #define myhash_crc(BITS) \
        case HASH_CRC##BITS: { \
            if(!crc_ctx) { \
                fprintf(stderr, "\nError: crc_ctx is NULL, contact me\n"); \
                exit(1); \
            } \
            if((out > in) && ((out + (BITS / 8)) <= (in + insz))) memset(out, 0, (BITS / 8)); \
            if(!init) crc_make_table((void *)crc_ctx->table, NULL, crc_ctx->poly, crc_ctx->bits, Hendian, crc_ctx->rever, crc_ctx->bitmask_side, NULL); \
            crc = crc_calc(crc_ctx, in, insz); \
            putxx(out, crc, BITS, Hendian); \
            break; \
        }

        myhash_crc(64)
        myhash_crc(32)
        myhash_crc(16)
        myhash_crc(8)

        default: break;
    }
    if(!init) init = 1;
}



int get_hash(u8 *str) {
    if(!stricmp(str, "md5"))        return(HASH_MD5);
    if(!stricmp(str, "md5_4"))      return(HASH_MD5_4);
    if(!stricmp(str, "md5_32"))     return(HASH_MD5_4);
    if(!stricmp(str, "crc"))        return(HASH_CRC32); // poly is already default
    if(!stricmp(str, "checksum"))   return(HASH_CRC32);
    if(!stricmp(str, "crc64"))      return(HASH_CRC64);
    if(!stricmp(str, "crc32"))      return(HASH_CRC32);
    if(!stricmp(str, "crc16"))      return(HASH_CRC16);
    if(!stricmp(str, "crc8"))       return(HASH_CRC8);
    fprintf(stderr, "\nError: unsupported hash algorithm (%s)\n", str);
    exit(1);
    return(-1);
}



u32 randit(u32 *rnd) {
    *rnd = (*rnd * 0x343FD) + 0x269EC3;
    *rnd = ~((*rnd >> 1) - 1);  // *rnd >>= 1 was enough
    return(*rnd);
}



int recvshow(int sd, int pck_proto, int dumprecv) {
    struct sockaddr_in  peerl;
    int     i,
            t,
            psz,
            len,
            pck;
    u8      *buff   = NULL;

    if(dumprecv == -3) {
        // wait forever
    } else if(dumprecv == -4) {
        // wait forever
    } else {
        if(timeout(sd, 1) < 0) {
            len = -3;
            goto quit;
        }
    }

    buff = malloc(0xffff + 1);
    if(!buff) std_err();

    len = -1;
    for(pck = 0;; pck++) {
        memset(&peerl, 0, sizeof(struct sockaddr_in));
        psz = sizeof(struct sockaddr_in);
        if(pck_proto < 0) {
            len = recv(sd, buff, 0xffff, 0);
        } else {
            len = recvfrom(sd, buff, 0xffff, 0, (struct sockaddr *)&peerl, &psz);
        }
        if(len >= 0) {
        if(plugins/* && (total_pcks >= dllwhen)*/) {
            buff[len] = 0;  // in case of bad plugins
            for(i = 0; i < plugins; i++) {
                if(plugin[i].sudp_pck) len = plugin[i].sudp_pck(buff, len); // packets modification
                if(plugin[i].myrecvfrom || plugin[i].myrecv) {
                    if(plugin[i].myrecvfrom) {
                        len = plugin[i].myrecvfrom(sd, buff, len, 0, (struct sockaddr *)&peerl, &psz);
                    } else {
                        len = plugin[i].myrecv(sd, buff, len, 0);
                    }
                }
            }
        }
        }
        if(!len) {
            if(pck_proto < 0) { len = -2; goto quit; }
            break;
        }
        if(len < 0) { len = -1; goto quit; }

        t = len;
        if((dumprecv > 0) && (t > dumprecv)) t = dumprecv;
        fputc('\n', stdout);
        show_dump(buff, t, stdout);
        if(dumprecv == -1) {
            if(timeout(sd, 1) < 0) break;
        } else if(dumprecv == -3) {
            // none, wait forever
        } else if(dumprecv == -4) {
            break;  // wait only the first packet
        } else {
            if(timeout(sd, 0) < 0) break;
        }
    }

quit:
    if(buff) free(buff);
    return(len);
}



u8 *load_file(u8 *filename, int *contentsize) {
    struct  stat    xstat;
    int     len;
    FILE    *fd;
    u8      *buff;

    if(!quiet) printf("- load file:    %s\n", filename);
    if(!strcmp(filename, "-")) {
        fd = stdin;
    } else {
        fd = fopen(filename, "rb");
        if(!fd) std_err();
    }

    if(fd == stdin) {
        len = 0xffff;
    } else {
        fstat(fileno(fd), &xstat);
        len = xstat.st_size;
    }
    buff = malloc(len);
    if(!buff) std_err();
    len = fread(buff, 1, len, fd);
    if(fd != stdin) fclose(fd);
    if(contentsize) *contentsize = len;
    return(buff);
}



int cstring(u8 *input, u8 *output, int maxchars, int *inlen) {
    int     n,
            len;
    u8      *p,
            *o;

    if(!input || !output) {
        if(inlen) *inlen = 0;
        return(0);
    }

    p = input;
    o = output;
    while(*p) {
        if(maxchars >= 0) {
            if((o - output) >= maxchars) break;
        }
        if(*p == '\\') {
            p++;
            switch(*p) {
                case 0:  return(-1); break;
                //case '0':  n = '\0'; break;
                case 'a':  n = '\a'; break;
                case 'b':  n = '\b'; break;
                case 'e':  n = '\e'; break;
                case 'f':  n = '\f'; break;
                case 'n':  n = '\n'; break;
                case 'r':  n = '\r'; break;
                case 't':  n = '\t'; break;
                case 'v':  n = '\v'; break;
                case '\"': n = '\"'; break;
                case '\'': n = '\''; break;
                case '\\': n = '\\'; break;
                case '?':  n = '\?'; break;
                case '.':  n = '.';  break;
                case ' ':  n = ' ';  break;
                case 'x': {
                    //n = readbase(p + 1, 16, &len);
                    //if(len <= 0) return(-1);
                    if(sscanf(p + 1, "%02x%n", &n, &len) != 1) return(-1);
                    if(len > 2) len = 2;
                    p += len;
                    break;
                }
                default: {
                    //n = readbase(p, 8, &len);
                    //if(len <= 0) return(-1);
                    if(sscanf(p, "%3o%n", &n, &len) != 1) return(-1);
                    if(len > 3) len = 3;
                    p += (len - 1); // work-around for the subsequent p++;
                    break;
                }
            }
            *o++ = n;
        } else {
            *o++ = *p;
        }
        p++;
    }
    *o = 0;
    len = o - output;
    if(inlen) *inlen = p - input;
    return(len);
}



int hex2byte(u8 *hex) {
    static const u8 hextable[256] =
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\xff\xff\xff\xff\xff\xff"
        "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
        "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff";

    if(hextable[hex[0]] > 15) return(-1);
    if(hextable[hex[1]] > 15) return(-1);
    return((hextable[hex[0]] << 4) | hextable[hex[1]]);
}



u8 *load_xstring(u8 *input, int hex, int *contentsize) {
    int     i,
            c,
            len;
    u8      *buff,
            *p;

    if(hex < 0) {
        return(load_file(input, contentsize));
    }

    len = strlen(input);
    buff = malloc(len + 1);
    if(!buff) std_err();

    if(hex) {
        p = buff;
        for(i = 0; i < len; i++) {
            c = hex2byte(input + i);
            if(c < 0) continue;
            *p++ = c;
            i++;    // +2
        }
        len = p - buff;
    } else {
        len = cstring(input, buff, len, NULL);
    }
    if(contentsize) *contentsize = len;
    return(buff);
}



u8 *mystrchrs(u8 *str, u8 *chrs) {
    //int     i;
    u8      *p,
            *ret = NULL;

    if(str && chrs) {
        for(p = str; *p; p++) {
            if(strchr(chrs, *p)) return(p);
        }
        /*
        for(i = 0; chrs[i]; i++) {
            p = strchr(str, chrs[i]);
            if(p && (!ret || (p < ret))) {
                ret = p;
            }
        }
        */
    }
    return(ret);
}



u64 *string2num(u8 *input, int *ret_size) {
    u64     *ret    = NULL;
    int     i;
    u8      *p,
            *l;

    i = 0;
    for(p = input; *p; p = l + 1) {
        while(strchr(" \t\r\n", *p)) p++;
        l = mystrchrs(p, ",;|");
        if(l) {
            *l = 0;
            if(!*p) continue;
        }

        ret = realloc(ret, (i + 1) * sizeof(*ret));
        if(!ret) std_err();
        ret[i] = get_num(p, 0);
        i++;

        if(!l) break;
    }
    if(ret_size) *ret_size = i;
    return ret;
}



int create_socket(int pck_proto, int sd_already_set, struct sockaddr_in *peer) {
    static int  first_time  = 1;
    static int  size        = 0xffff;
    struct sockaddr_in  tmp;
    int     sd  = -1,
            psz;

    for(;;) {
        if(sd_already_set <= 0) {
            for(;;) {
                if(pck_proto < 0) {
                    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
                } else if(!pck_proto) {
                    sd = socket(AF_INET, SOCK_DGRAM,  IPPROTO_UDP);
                } else {
                    sd = socket(AF_INET, SOCK_RAW,    pck_proto /*don't use IPPROTO_RAW or will result in 0xff*/);
                }
                if(sd > 0) break;
                sleepms(500);
            }
        } else {
            sd = sd_already_set;
        }
        // SO_LINGER makes the sending a bit slower because it really sends
        // the whole full data and it's sure almost at 100% that it's received
        setsockopt(sd, SOL_SOCKET, SO_LINGER,    (char *)&ling, sizeof(ling));
        setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&on,   sizeof(on));
        setsockopt(sd, SOL_SOCKET, SO_SNDBUF,    (char *)&size, sizeof(size));  // useless
        if(pck_proto >= 0) break;   // packets

        setsockopt(sd, IPPROTO_TCP, TCP_NODELAY, (char *)&on,   sizeof(on));
        if(!peer) break;
        psz = sizeof(struct sockaddr_in);
        if(getpeername(sd, (struct sockaddr *)&tmp, &psz) < 0) {
            if(peer->sin_addr.s_addr == INADDR_NONE) break;
            if(peer->sin_addr.s_addr == INADDR_ANY) break;
            if(verbose) {
                printf("- TCP connect to %s:%u\n", inet_ntoa(peer->sin_addr), ntohs(peer->sin_port));
            } else if(!dumpsend) {
                fputc('O', stdout);
            }
            if(!connect(sd, (struct sockaddr *)peer, sizeof(struct sockaddr_in))) {
                if(first_time) first_time = 0;
                break;
            }
            if(first_time) std_err();
        }
        close(sd);
        sd = 0;
        sd_already_set = -1;
        sleepms(500);
    }
    return(sd);
}



u8 *get_byte(u8 *data, int *ret_chr, int *ret_chr_bits) {
    int     chr,
            len;
    u8      *ret    = NULL;

    len = strlen(data);
    *ret_chr = 0;
    *ret_chr_bits = 8;
    if(len < 1)  {
        *ret_chr = 0;
    } else if(len == 1) {
        *ret_chr = data[0];
    } else if(data[0] == '-') {
        *ret_chr = atoi(data);  // negative for the format string test
    } else if(len <= 10) {      // 0x00000000
        if((data[0] == '0') && (tolower(data[1]) == 'x')) data += 2;
        if(sscanf(data, "%x", &chr) == 1) {
            *ret_chr = chr;
            *ret_chr_bits = strlen(data) * 4;
            if(*ret_chr_bits < 8)  *ret_chr_bits = 8;
            else if(*ret_chr_bits > 64) *ret_chr_bits = 64; // max
            else if(*ret_chr_bits > 32) *ret_chr_bits = 64;
            else if(*ret_chr_bits > 16) *ret_chr_bits = 32;
            else if(*ret_chr_bits > 8)  *ret_chr_bits = 16;
        } else {
            goto string_failsafe;
        }
    } else {    // experimental string
        goto string_failsafe;
    }
    return(ret);
string_failsafe:
    ret = strdup(data);
    *ret_chr = cstring(ret, ret, -1, NULL);
    return(ret);
}



u64 readbase(u8 *data, int size, int *readn) {
    static const u8 table[256] =    // fast performances
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\xff\xff\xff\xff\xff\xff"
            "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"
            "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff";
    u64     num     = 0;
    int     sign;
    u8      c,
            *s,
            *hex_fix;

    s = data;
    if(!data || !size || !data[0]) {
        // do nothing (for readn)
    } else {
        // useful in some occasions, for example if the input is external!
        for(; *s; s++) {
            if(!strchr(" \t\r\n", *s)) break;
        }
        if(*s == '-') {
            sign = -1;
            s++;
        } else {
            sign = 0;
        }
        hex_fix = s;
        for(; *s; s++) {
            c = *s;
            //if((c == 'x') || (c == 'X') || (c == '$')) {  // auto base switching
            if(
                (((c == 'h') || (c == 'x') || (c == 'X')) && (s > hex_fix)) // 0x and 100h, NOT x123 or h123
             || (c == '$')                                                  // $1234 or 1234$
            ) {
                size = 16;
                continue;
            }
            c = table[c];
            if(c >= size) break;    // necessary to recognize the invalid chars based on the size
            num = (num * size) + c;
        }
        if(sign) num = -num;
    }
    if(readn) *readn = s - data;
    return(num);
}



u64 get_num(u8 *data, int multi) {
    u64     num     = 0,
            tot     = 0;
    int     op      = 0,
            sign    = 1,
            t;

    while(data[0]) {
        while(data[0] && (data[0] <= ' ')) data++;
        if(!data[0]) break;
        if(strchr("+-*/%^|&<>~!", data[0])) {
            op = data[0];
            data++;
        }
        while(data[0] && (data[0] <= ' ')) data++;
        if(!data[0]) break;

        sign = 1;
        if(op == '-') sign = -1;

        num = 0;
        t = 0;
        if(!strncmp(data, "MAXINT", 6)) {
            num = 0; num--; num >>= 1;  // alternative to MYMAXINT64
            t   = 6;
        } else if((strlen(data) > 1) && (tolower(data[1]) == 'x')) {
            data += 2;
            num = readbase(data, 16, &t);   //sscanf(data, "%x%n", &num, &t);
        } else if((data[0] == '$') || (data[0] == '#')) {
            data++;
            num = readbase(data, 16, &t);   //sscanf(data, "%x%n", &num, &t);
        } else if(sign < 0) {
            if(!((data[0] >= '0') && (data[0] <= '9'))) {
                if(data[0] != 'l') {    // yeah l and 1 are very similar
                    fprintf(stderr, "\n"
                        "Error: recheck your options because seems that some arguments are wrong\n"
                        "       for example \"%s\" should be a number\n", data);
                    exit(1);
                }
            }
            num = readbase(data, 10, &t);    //sscanf(data, "%i%n", &num, &t);
        } else {
            num = readbase(data, 10, &t);    //sscanf(data, "%u%n", &num, &t);
        }
        if(t <= 0) t = 1;
        data += t;

        //if(sign < 0) num = -num;

             if(op == '+') tot += num;
        else if(op == '-') tot -= num;
        else if(op == '*') tot *= num;
        else if(op == '/') tot /= num;
        else if(op == '%') tot %= num;
        else if(op == '^') tot ^= num;
        else if(op == '|') tot |= num;
        else if(op == '&') tot &= num;
        else if(op == '<') tot <<= num;
        else if(op == '>') tot >>= num;
        else if(op == '~') tot = ~num;
        else if(op == '!') tot = !num;
        else               tot = num;
        op = 0;

        if(!multi) break;
    }
    return(tot);
}



int create_rand_byte(u8 *data, int len, u32 *seed, u8 *charset) {
    static int  inc = 0;
    u32     rnd = 0,
            c;
    int     i;

    if(seed) rnd = *seed;
    for(i = 0; i < len; i++) {
        randit(&rnd);
        rnd += inc;
        inc++;
        c = rnd;

        if(charset) c = charset[c % strlen(charset)];

        data[i] = c;
    }
    if(seed) *seed = rnd;
    return(len);
}



u64 getxx(u8 *data, int bits, int endian) {
    u64     num     = 0;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        if(endian == BIG_ENDIAN) {
            num |= ((u64)data[i] << (u64)((bytes - (u64)1 - i) << (u64)3));
        } else {
            num |= ((u64)data[i] << (u64)(i << (u64)3));
        }
    }
    return(num);
}



int putxx(u8 *data, u64 num, int bits, int endian) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        if(endian == BIG_ENDIAN) {
            data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
        } else {
            data[i] = (num >> (i << 3)) & 0xff;
        }
    }
    return(bytes);
}



void memcpy_bits(u8 *buff, int pos, u8 *data, int len) {
    int     i;
    for(i = 0; i < len; i++) {
        pos = write_bits(data[i], 8, buff, pos);
    }
}



int zip(z_stream *z, u8 *in, u32 insz, u8 *out, u32 outsz) {
    deflateReset(z);

    z->next_in   = in;
    z->avail_in  = insz;
    z->next_out  = out;
    z->avail_out = outsz;
    if(deflate(z, Z_FINISH) != Z_STREAM_END) {
        fprintf(stderr, "\nError: the compressed output is wrong or incomplete\n");
        exit(1);
    }
    return(z->total_out);
}



char *stristr(const char *String, const char *Pattern)
{
      char *pptr, *sptr, *start;

      for (start = (char *)String; *start; start++)
      {
            /* find start of pattern in string */
            for ( ; (*start && (toupper(*start) != toupper(*Pattern))); start++)
                  ;
            if (!*start)
                  return 0;

            pptr = (char *)Pattern;
            sptr = (char *)start;

            while (toupper(*sptr) == toupper(*pptr))
            {
                  sptr++;
                  pptr++;

                  /* if end of pattern then pattern was found */

                  if (!*pptr)
                        return (start);
            }
      }
      return 0;
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            fprintf(stderr, "\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


