/*
 * Modified by sili@l0pht.com 10/1/99
 *  .. added source addr spoofing
 *
 * ccm
 * Lars Kellogg-Stedman <lars@larsshack.org>
 * Ken Raeburn <raeburn@raeburn.org>
 *
 * $Id: ccmcmd.c,v 1.64 1999/08/31 20:03:21 lars Exp $
 *
 */

#include <config.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
#include <signal.h>
#include <errno.h>

#include <libnet.h>

#ifdef HAVE_LIBREADLINE
#	ifdef HAVE_READLINE_H
#		include <readline.h>
#	else
#		include <readline/readline.h>
#	endif
#endif /* HAVE_LIBREADLINE */

#include <ccmcmd.h>
#include <version.h>
#include <output.h>

/*
 * GLOBALS
 */

/* this header gets prepended to outgoing commands */
unsigned char prefix[] = {
  /* transaction id */
  0x00, 0x00, 0x00, 0x00,

  /* I have no idea what any of this data means.  */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  
  /* this must be 1 for things to work.  sequence count? */
  0x01,

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

/* socket used for our communication */
int	s;

u_long  SPOOFADDR = NULL;

struct	sockaddr_in	myaddr,
			hisaddr;
int	hisaddrlen	= sizeof (struct sockaddr_in);

int	user_abort	= 0;

struct	_target		*current_target;
int	next_target_number	= 1;

struct {
	int	interactive;
	int	debug;
	int	verbose;
} flags = {0,0,0};

struct {
	int	timeout;
	int	retries;
	char	*input_filename;
} options = {DEFAULT_TIMEOUT, DEFAULT_RETRIES, NULL};

struct	_target *targets;

char	*exe_name;
char	*rcs_version="Mmmmm beer";

struct	_command local_commands[]={
	{CMD_TARGET,		"switch targets or display current target"},
	{CMD_DROP,		"delete targets from list"},
	{CMD_TIMEOUT,		"change or display timeout value"},
	{CMD_RETRIES,		"change or display number of retries"},
	{CMD_NEXT,		"switch to next target in list"},
	{CMD_PREV,		"switch to previous target in list"},
	{CMD_LIST,		"list all available targets"},
	{CMD_LOAD,		"read a list of targets from a file"},
	{CMD_APPLY,		"apply command to marked targets"},
	{CMD_VERBOSE,		"toggle setting of verbose flag"},
	{CMD_DEBUG,		"toggle setting of debug flag"},
	{CMD_HELP,		"show local commands"},
	{CMD_REMOTEHELP,	"show remote commands"},
	{CMD_VERSION,		"display version information"},
	{CMD_MARK,		"mark targets"},
	{CMD_UNMARK,		"unmark targets"},
	{CMD_SPOOF,		"Change src addr. Set to zero to disable"},

	{NULL,		NULL}
};

struct _command remote_commands[]={
	{"arp",		"display cable modem's ARP table"},
	{"asystat",	"serial line status"},
	{"attach",	"attach interfaces"},
	{"backchan",	"set backchannel"},
	{"bulletin",	"set/display bulletin"},
	{"cfgstats",	NULL},
	{"config",	NULL},
	{"connect",	"dial modem"},
	{"dhcp",	"turn dhcp server on or off"},
	{"dial",	NULL},
	{"dlog",	"display cable modem log"},
	{"domain",	"manipulate dns server settings"},
	{"eeconfig",	"eeprom configuration commands"},
	{"enet",	"control LAN watchdog timers"},
	{"exit",	"reboot the cable modem"},
	{"hagstats",	NULL},
	{"hangup",	"hangup modem"},
	{"help",	"display available commands"},
	{"hipinstall",	NULL},
	{"hipstatus",	NULL},
	{"hipuninstall",	NULL},
	{"hostname",	"set/display hostname"},
	{"hsmpstats",	"display HSMP statistics"},
	{"hupdisable",	NULL},
	{"huphardwire",	NULL},
	{"hybkeyexch",	NULL},
	{"hupline",	NULL},
	{"hupstats",	NULL},
	{"hybstats",	NULL},
	{"icmp",	"set/display icmp options"},
	{"ifconfig",	"set/display network interface configuration"},
	{"ip",		"set/display ip related options"},
	{"listdebug",	NULL},
	{"listnodes",	"list dhcp clients of current target"},
	{"loadstats",	NULL},
	{"macaddress",	NULL},
	{"popmacaddr",	NULL},
	{"ppp",		NULL},
	{"qaminit",	"reset qam"},
	{"qamstat",	"signal quality statistics"},
	{"qpsk",	"enter qpsk subcommands (try 'qpsk help')"},
	{"reverserouter",	NULL},
	{"route",	"display routing tables"},
	{"scan",	NULL},
	{"set",		"set debugging levels"},
	{"setnodes",	"add additional ip addresses to dhcp server"},
	{"setproxy",	NULL},
	{"tune",	NULL},
	{"tuneadjust",	NULL},
	{"upstreamid",	NULL},
	{"uptune",	NULL},
	{"version",	"display NOS version, model info, etc."},

	{NULL,		NULL}
};

/*
 * FUNCTIONS
 */

int main (int argc, char *argv[]) {
	char	*cmd;
	int	cmdlen,
		c,
		one = 1;
	struct	in_addr	tmpaddr;
	FILE	*input_file;

	initialize_globals(argc, argv);

	while ((c = getopt(argc, argv, OPTSTRING)) != EOF) {
		switch(c) {
			case OPT_FILE:
				options.input_filename = strdup(optarg);
				break;

			case OPT_SPOOF:
				SPOOFADDR = inet_addr(optarg);
				break;

			case OPT_INTERACTIVE:
				flags.interactive=1;
				break;

			case OPT_MODEM:
				if (resolve_address(optarg, &tmpaddr)) {
					add_target(tmpaddr, optarg);
				} else {
					exit_err(EX_ERROR, "unable to resolve address: %s", optarg);
				}
				break;

			case OPT_TIMEOUT:
				options.timeout=atoi(optarg);
				break;

			case OPT_RETRIES:
				options.retries=atoi(optarg);
				break;

			case OPT_DEBUG:
				flags.debug=1;
				/* fall through */

			case OPT_VERBOSE:
				flags.verbose=1;
				break;

			case OPT_VERSION:
				show_version();
				exit(EX_OK);
				break;

			case OPT_HELP:
				show_usage(stdout);
				exit(EX_OK);
				break;

			default:
				show_usage(stderr);
				exit(EX_USAGE);
		}
	}

	/* process input file, if any */
	if (options.input_filename) {
		if (! process_file(options.input_filename))
			exit(EX_ERROR);
	}

	/* add the default target if user has not defined any on 
	 * the command line. */

	if (! targets) {
		char *env_target;

		if (env_target=getenv("CCM_DEFAULT_TARGET")) {
			if (resolve_address(env_target, &tmpaddr)) {
				add_target(tmpaddr, env_target);
			} else {
				print_err("unable to resolve address: %s", env_target);
			}
		}

		/* if target is still null, add the default target */
		if (! targets) {
			tmpaddr.s_addr=DEFAULT_TARGET;
			add_target(tmpaddr, "[default]");
		}
	}

	/* create and bind our socket here, so we only have to do
	 * it once. */
	s = socket (AF_INET, SOCK_DGRAM, 0);
	if (s == -1) {
		print_err("socket(): %s", strerror(errno));
		exit (EX_ERROR);
	}
	if (setsockopt (s, SOL_SOCKET, SO_REUSEADDR, &one, sizeof (one)) < 0)
		print_err ("setsockopt(REUSEADDR): %s", strerror(errno));
	if (setsockopt (s, SOL_SOCKET, SO_BROADCAST, &one, sizeof (one)) < 0)
		print_err ("setsockopt(BROADCAST): %s", strerror(errno));
	if (bind (s, (struct sockaddr *) &myaddr, sizeof(myaddr)) < 0) {
		print_err ("bind(): %s", strerror(errno));
		exit(EX_ERROR);
	}

	if (flags.interactive) {
		if (optind != argc) {
			print_err("interactive mode: ignoring additional command line arguments");
		}

		current_target=targets;
		ccm_shell();
	} else {
		struct	_target *cur = targets;
		int 	newargc;
		char	**newargv;

		/* build new command line vector */
		if (argc == optind) {
			char *default_argv[]={DEFAULT_COMMAND,0};

			/* set up default command */
			newargv=default_argv;
			newargc=1;
		} else {
			/* get command from command line */
			newargc=argc-optind;
			newargv=argv + optind;
		}
		
		/* apply command to all targets */
		start_sigint_handling;
		while (cur && ! user_abort) {
			handle_remote_command(newargc, newargv, cur);
			cur=cur->next;
		}
		stop_sigint_handling;
	}
}

void show_usage(FILE *out)
{
	fprintf(out,"%s: usage: %s [-S <src addr> ] [ -f <input_file> ] [-m <modem address> [ -m <modem address> ... ] ] [ -r <retries> ] [ -t <timeout> ] [ -ihvV ] [command]\n", exe_name, exe_name);
}

void show_version()
{
	printf("Client Cable Modem (CCM) Info for Unix\n");
	printf("Version %d.%d.%d sp00f\n\n",
			VERSION_MAJOR,
			VERSION_MINOR,
			VERSION_REVISION);

	printf("by Lars Kellogg-Stedman <lars@larsshack.org> and\n");
	printf("Ken Raeburn <raeburn@raeburn.org>\n");
	printf("-->sp00fability added by sili@l0pht.com\n\n");

#ifdef HOST_ALIAS
	printf("compiled for yer m0mma");
#endif

	printf("\nOptions: ");
	printf("sp00fability ");
#ifdef HAVE_LIBREADLINE
	printf("readline ");
#endif /* HAVE_LIBREADLINE */
	printf("\n\n");

	printf("%s\n\n", rcs_version);
}


/* return TRUE if addr looks like a numeric IP address, 0 otherwise */
int is_ip(char *addr)
{
	char *c=addr;
	int numdots = 0;

	while (*c) {
		if (*c == '.') { numdots++; c++; continue; }
		if (*c < '0' || *c > '9') return FALSE;
		c++;
	}

	/* if we got this far, it's all numbers and dots */
	if (numdots != 3) {
		return -1;
	}

	return TRUE;
}

/* takes an argument vector and converts it to a single 
 * space-delimited string */
char *build_command(int argc, char *argv[])
{
	int	i,
		len = 0;
	char	*cmd;

	/* prescan vector to figure out size of our command */
	for (i=0; i<argc; i++) {
		len += strlen(argv[i]) + 1;
	}

	cmd = (char *)malloc(len + 1);
	memset(cmd,0,len + 1);

	for (i=0; i<argc; i++) {
		strcat(cmd, argv[i]);
		strcat(cmd, " ");
	}

	if (cmd[strlen(cmd) - 1] == ' ') cmd[strlen(cmd) - 1] = '\0';

	if (flags.debug) print_err("debug: built command \"%s\".", cmd);
	return cmd;

}

/* sends a single remote command and displays the response */
int handle_remote_command(int argc, char *argv[], struct _target *t)
{
	unsigned char	datagram[SEND_PACKET_LENGTH],
			response[RESPONSE_PACKET_LENGTH];

	struct	_recv_header recv_header;

	int		msglen,
			len,
			i,
			done	= 0,
			tries	= 0,
			res;

	struct timeval	timeout;
	fd_set		readfds;

	char 		*cmd;
	int		cmdlen;

        u_char *buffy=NULL;
        int sock,blah;

	static 	unsigned long	send_transid=0;

	if (flags.debug) print_err("debug: entering handle_remote_command()...");
	cmd=build_command(argc, argv);
	cmdlen=strlen(cmd);

	/* make sure we don't overflow our buffers */
	msglen = sizeof (prefix);
	if (msglen + cmdlen >= SEND_PACKET_LENGTH) {
		print_err("data overrun, can't send command.");
		print_err("command was: %s", cmd);
		return DO_NOT_QUIT;
	}

	hisaddr.sin_addr=t->addr;

	timeout.tv_sec=options.timeout;
	timeout.tv_usec=0;

	/* increment transaction id for each command */
	++send_transid;

	/* build datagram */
	memset(datagram,0,SEND_PACKET_LENGTH);
	memcpy (datagram, prefix, msglen);

	/* set the transaction id on the outgoing packet */
	send_transid=htonl(send_transid);
	memcpy(datagram,&send_transid,TRANSID_LENGTH);
	send_transid=ntohl(send_transid);

	/* add the command to the packet */
	memcpy (datagram + msglen, cmd, cmdlen); /* include nul */
	msglen += cmdlen + 1;

	if (SPOOFADDR != 0) {
                    
          printf("spoofing..");
          buffy=malloc(IP_H+UDP_H+msglen);
          
          if ( (buffy = malloc(IP_H+UDP_H+msglen)) == NULL ) {
            perror("malloc: ");
            exit(-1);
          }
          
          if ( (sock = libnet_open_raw_sock(IPPROTO_RAW)) == -1 ) {
            perror("socket: ");
            exit(-1);
          }
	  
          libnet_build_ip(UDP_H+msglen, 101, 0, IP_DF,  64,  IPPROTO_UDP,
                          SPOOFADDR, hisaddr.sin_addr.s_addr, NULL, 0, buffy);
          
          libnet_build_udp(7778, 7777, datagram, msglen, buffy+IP_H);
          
          libnet_do_checksum(buffy, IPPROTO_UDP, UDP_H);
          blah=libnet_write_ip(sock, buffy, IP_H+UDP_H+msglen);   
          printf("wrote: %d of %d\n",blah, IP_H+UDP_H+msglen);
	  
          return;
	}
	
	do {
		t->last_status=STATUS_OKAY;
		if (flags.verbose) printf("[%d:%d] >>> %s >>> %s [%s]\n", 
				send_transid,
				tries,
				cmd,
				t->name,
				inet_ntoa(t->addr));

		/* send command */

		if (flags.debug) {
			print_err("debug: sending header:");
			hexdump(datagram, sizeof(prefix));
		}

		/* send out the packet.  if we can't send it, just exit 
		 * immediately */
		if (sendto (s, &datagram, msglen, 0,
				(struct sockaddr *) &hisaddr, sizeof (hisaddr)) < 0) 
		{
			print_err ("sendto() failed: %s", strerror(errno));
			t->last_status=STATUS_SEND_FAILED;
			return DO_NOT_QUIT;
		}

		do {
			FD_ZERO (&readfds);
			FD_SET (s, &readfds);
			t->last_status=STATUS_OKAY;

			/* waits until a response is available or until timeout 
			   expires */
			if ((res = select (s + 1, &readfds, 0, 0, &timeout)) == 
					0) {
				print_err("timeout waiting for data from %s [%s].",
						t->name, inet_ntoa(t->addr));
				break;
			} else if (res < 0) {
				if (! user_abort) {
					print_err("select() failed: %s", strerror(errno));
					t->last_status=STATUS_SELECT_FAILED;
				}
				return DO_NOT_QUIT;
			}


			len = recvfrom (s, &response, sizeof (response), 0,
					(struct sockaddr *) &hisaddr, &hisaddrlen);
			if (len < 0) {
				print_err("recvfrom() failed: %s", strerror(errno));
				t->last_status=STATUS_RECEIVE_FAILED;
				return DO_NOT_QUIT;
			}

			memcpy(&recv_header,response,sizeof(recv_header));
			recv_header.transid=ntohl(recv_header.transid);

			if (flags.debug) {
				print_err("debug: received header:");
				hexdump(response, sizeof(recv_header));
			}

			if (recv_header.transid != send_transid) {
				print_err("transid mismatch: expected %d, received %d.",
						send_transid,
						recv_header.transid);
				continue;
			}

			/* if we get this far, we've received an appropriate
			 * response... */
			for (i = HEADER_LENGTH + 1;i < len; i++) {
				int c = response[i];
				printf ((isprint (c) || isspace (c)) 
						? "%c"
						: "<%02X>", 
						c);
			}
			printf("\n");

			/* so we check if more packets follow this one, and if
			 * not we just exit. */
			if (! recv_header.fragments_follow) {
				done=1;
				break;
			}
		} while (TRUE);
	} while (! done && tries++ < options.retries);

	if (!done) t->last_status=STATUS_RETRIES_EXCEEDED;

	if (flags.debug) print_err("debug: leaving handle_remote_command()...");
	return DO_NOT_QUIT;
}

void hexdump(unsigned char *buf, int len)
{
	int	i;

	for (i = 0;i < len; i++) {
		int c = buf[i];
		fprintf (stderr, "<%02X>", c); 
	}
	printf("\n");
}

/* parse a command line into whitespace-seperated tokens, and then pass it
 * as argc and argv to another function for handling */
int parse_command(char *cmd, int (*handle_command)(int, char *[], struct _target *), struct _target *ct)
{
	char	**argv,
		*tmp,
		*token;
	int	argc	= 0,
		i	= 0,
		r;

	if (flags.debug) print_err("debug: entering parse_command(%s)", cmd);

	/*
	 * prescan the command line to figure out argc; we'll need this before
	 * we can allocate space for argv.
	 */

	tmp=strdup(cmd);
	token=strtok(tmp,WHITESPACE);
	while (token) {
		++argc;
		
		token=strtok(NULL,WHITESPACE);
	}
	free(tmp);

	argv = (char **)malloc(argc * sizeof(char *));

	/*
	 * now, scan the command line a second time, this time filling in
	 * argv.
	 */

	tmp=strdup(cmd);
	token=strtok(tmp,WHITESPACE);
	while (token) {
		argv[i++]=strdup(token);
		token=strtok(NULL,WHITESPACE);
	}
	free(tmp);

	r = handle_command(argc, argv, ct);

	/* deallocate the space we used */
	for (i=0; i<argc; i++) {
		if (flags.debug) print_err("debug: freeing argv[%d].", i);
		free(argv[i]);
	}
	if (flags.debug) print_err("debug: freeing argv.");
	free(argv);

	if (flags.debug) print_err("debug: returning from parse_command()...");
	return r;
}

/* process a single local command */
int handle_local_command(int argc, char *argv[], struct _target *ct)
{
	struct	in_addr tmpaddr;
	char	*cmd;
	static	char	*all[] = {"all",'\0'};
	static	char	*marked[] = {"marked",'\0'};

	if (argc <1 || is_all_whitespace(argv[0], strlen(argv[0]))) {
		print_err("null command.");
		return DO_NOT_QUIT;
	}

	cmd=argv[0];

	if (strcmp(cmd, CMD_QUIT) == 0)
		return QUIT;

	if (strcmp(cmd, CMD_RETRIES) == 0) {
		if (argc >= 2) options.retries=atoi(argv[1]);

		printf("retries: %d\n", options.retries);
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_TIMEOUT) == 0) {
		if (argc >= 2) options.timeout=atoi(argv[1]);
		printf("timeout: %d\n", options.timeout);
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_NEXT) == 0) {
		if (current_target->next) {
			current_target=find_next_undeleted(current_target);
		} else {
			print_err("no more targets.");
		}
		show_current_target;
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_PREV) == 0) {
		if (current_target->prev) {
			current_target=find_prev_undeleted(current_target);
		} else {
			print_err("no more targets.");
		}
		show_current_target;
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_VERBOSE) == 0) {
		flags.verbose=!flags.verbose;
		if (flags.verbose) printf("Verbose mode is ON.\n");
		else printf("Verbose mode is OFF.\n");
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_DEBUG) == 0) {
		flags.debug=!flags.debug;
		if (flags.debug) printf("Debug mode is ON.\n");
		else printf("Debug mode is OFF.\n");
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_VERSION) == 0) {
		show_version();
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_SPOOF) == 0) {
	        SPOOFADDR = inet_addr(argv[1]);
		return DO_NOT_QUIT;
	}
	

	if (strcmp(cmd, CMD_LIST) == 0) {
		struct	_tlist	*l;

		if (argc < 2) {
			l = build_list(1, all);
		} else {
			l = build_list(argc - 1, &argv[1]);
		}

		while (l) {
				show_target(l->t, current_target);
				l=l->next;
		}

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_MARK) == 0) {
		struct	_tlist	*l;

		if (argc < 2) {
			l = build_list(1, all);
		} else {
			l = build_list(argc - 1, &argv[1]);
		}

		while (l) {
				l->t->marked = 1;
				l=l->next;
		}

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_UNMARK) == 0) {
		struct	_tlist	*l;

		if (argc < 2) {
			l = build_list(1, all);
		} else {
			l = build_list(argc - 1, &argv[1]);
		}

		while (l) {
				l->t->marked = 0;
				l=l->next;
		}

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_LOAD) == 0) {
		if (argc < 2) {
			print_err("load command requires an argument.");
			return DO_NOT_QUIT;
		}

		process_file(argv[1]);
		current_target=find_next_undeleted(current_target);
		show_current_target;

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_DROP) == 0) {
		struct _tlist *t;

		if (argc >= 2) {
			t = build_list(argc - 1, &argv[1]);
			while (t) {
				delete_target(t->t);
				t = t->next;
			}
		} else {
			if (! current_target) {
				print_err("no current target.");
				return DO_NOT_QUIT;
			}
			
			printf("Deleting %s [%s]...\n", current_target->name,
					inet_ntoa(current_target->addr));
			delete_target(current_target);
		}
		
		if (current_target->deleted)
			current_target=find_first_undeleted();
		if (current_target) show_current_target;
		return DO_NOT_QUIT;
	}

	/* usage: /apply <cmd...> */
	if (strcmp(cmd, CMD_APPLY) == 0) {
		struct _tlist *l;
		char	*new_cmd;

		if (argc < 2) {
			print_err("wrong number of arguments to %s.",cmd);
			return DO_NOT_QUIT;
		}
		
		new_cmd=build_command(argc - 1, &argv[1]);
		l=build_list(1,marked);

		start_sigint_handling;
		while (l && ! user_abort) {
			parse_command(new_cmd, handle_remote_command, l->t);
			l=l->next;
		}
		stop_sigint_handling;

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_TARGET) == 0) {
		if (argc >= 2) {
			if (is_all_numbers(argv[1], strlen(argv[1]))) {
				struct _target *t;

				t=pick_target(atoi(argv[1]));
				if (t) {
					current_target=t;
				} else {
					print_err("unable to select target %s.", argv[1]);
				}
			} else if (resolve_address(argv[1], &tmpaddr)) {
				current_target=add_target(tmpaddr, argv[1]);
			} else {
				print_err("error resolving address: %s", argv[1]);
				print_err("target has not been changed.");
			}
		}
		show_current_target;
		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_REMOTEHELP) == 0) {
		int	i=0;

		printf("available remote commands:\n\n");

		while (remote_commands[i].name) {
			printf("%-20s %s\n",
				remote_commands[i].name,
				remote_commands[i].description
					? remote_commands[i].description
					: "");
			i++;
		}

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, CMD_HELP) == 0) {
		int	i=0;

		printf("available commands:\n\n");

		while (local_commands[i].name) {
			printf("%-20s %s\n",
				local_commands[i].name,
				local_commands[i].description
					? local_commands[i].description
					: "");
			i++;
		}

		printf("\nAll local commands must start with the '%s' character.\n", COMMAND_CHAR);

		return DO_NOT_QUIT;
	}

	if (strcmp(cmd, "foo") == 0) {
		struct _tlist	*list,
				*cur;
		int	i = 0;

		if (argc < 2) {
			print_err("foo requires an argument.");
			return DO_NOT_QUIT;
		}

		list=build_list(argc -1, &argv[1]);
		cur=list;

		while(cur) {
			++i;
			printf("%4d: %-40s [%-15s] %-8s\n", 
					i,
					cur->t->name,
					inet_ntoa(cur->t->addr),
					status_to_string(cur->t->last_status));
			cur=cur->next;
		}

		return DO_NOT_QUIT;
	}

	print_err("unknown command \"%s\".", cmd);
	return DO_NOT_QUIT;
}

/* driver for interactive mode */
void ccm_shell()
{
	char 	*s,
		quit = DO_NOT_QUIT;

#ifdef HAVE_LIBREADLINE
	char	*cmd = NULL;
	char    *prompt = "ccm> ";

	/* bind our completion function */
	rl_attempted_completion_function=
		(CPPFunction *)local_or_remote_completion;
#else
	char	cmd[COMMAND_BUFFER_LENGTH];
#endif /* HAVE_LIBREADLINE */

	printf(INTERACTIVE_BANNER);

	show_current_target;
	while (quit != QUIT) {

#ifdef HAVE_LIBREADLINE
		if (cmd) free(cmd);
		if (SPOOFADDR != 0)
		  prompt="ccm-sp00f-mode> ";
		else
		  prompt="ccm> ";

		if (cmd=readline(prompt)) {
#else
		memset(cmd, 0, COMMAND_BUFFER_LENGTH);
		if (SPOOFADDR != 0)
		  printf("ccm-sp00f-mode> ");
		else
		  printf("ccm> ");

		if (fgets(cmd, COMMAND_BUFFER_LENGTH - 1, stdin)) {
#endif /* HAVE_LIBREADLINE */
			if (flags.debug) print_err("debug: got command: \"%s\".", cmd);
			if (cmd[strlen(cmd)-1] == '\n')
				cmd[strlen(cmd)-1] = 0;

			if (strlen(cmd) == 0) continue;
			if (is_all_whitespace(cmd,strlen(cmd))) continue;

#ifdef HAVE_LIBREADLINE
			/* now that we have a non-null command,
			 * add it to the history buffer */
			add_history(cmd);
#endif /* HAVE_LIBREADLINE */
			quit = dispatch(cmd);
		} else {
			quit = QUIT;
		}
	}
}

int dispatch(char *cmd)
{
	int	quit;

	if (cmd[0] == *COMMAND_CHAR) {
		quit = parse_command(cmd + 1, handle_local_command, current_target);
	} else {
		start_sigint_handling;
		quit = parse_command(cmd, handle_remote_command, current_target);
		stop_sigint_handling;
	}

	return quit;
}

/* find the first valid host in the list */
struct _target *find_first_undeleted()
{
	struct _target *cur = targets;

	while (cur) {
		if (! cur->deleted) return cur;
		cur = cur->next;
	}

	return NULL;
}

struct _target *find_next_undeleted(struct _target *start)
{
	struct _target *cur = start->next;

	while (cur) {
		if (! cur->deleted) return cur;
		cur = cur->next;
	}

	return NULL;
}

struct _target *find_prev_undeleted(struct _target *start)
{
	struct _target *cur = start->prev;

	while (cur) {
		if (! cur->deleted) return cur;
		cur = cur->prev;
	}

	return NULL;
}

/* resolve a hostname or address passed as a string value */
int resolve_address(char *addr, struct in_addr *addr_struct)
{
	int	answer;

	if (flags.debug)
		printf("resolving address: %s\n", addr);

	if (answer=is_ip(addr) < 0) {
		print_err("bad address: %s", addr);
		return FALSE;
	} else if (answer) {
		addr_struct->s_addr=inet_addr(addr);
		if (addr_struct->s_addr == INADDR_NONE) {
			print_err("%s: bad address", addr);
			return FALSE;
		}
		return TRUE;
	} else {
		struct hostent *h;

		if ((h=gethostbyname(addr)) == NULL) {
			return FALSE;
		}

		if (h->h_addr == 0) {
			return FALSE;
		} else {
			memcpy(&addr_struct->s_addr, h->h_addr_list[0], h->h_length);
			return TRUE;
		}

	}
}

/* standard display routine */
void show_target(struct _target *t, struct _target *cur)
{
	if (t->deleted)
		printf("DEL ");
	else if (t == cur)
		printf("--> ");
	else if (t->marked)
		printf("  * ");
	else
		printf("    ");
	printf("%4d: %-40s [%-15s] %-8s\n", 
			t->id,
			t->name,
			inet_ntoa(t->addr),
			status_to_string(t->last_status));
}

/* add a new target to list of available targets */
struct _target *add_target(struct in_addr addr, char *name)
{
	struct	_target	*new,
			*cur;

	new=(struct _target *)malloc(sizeof(struct _target));
	new->addr	= addr;
	new->name	= strdup(name);
	new->last_status= STATUS_OKAY;
	new->deleted	= 0;
	new->id		= next_target_number++;
	new->marked	= 0;
	new->next	= NULL;
	new->prev	= NULL;

	if (targets) {
		cur=targets;

		while (cur->next) {
			cur=cur->next;
		}

		cur->next=new;
		new->prev=cur;
	} else {
		targets=new;
	}

	return new;
}

struct _target *pick_target(int target_index)
{
	struct	_target	*cur = targets;

	while (cur && cur->id <= target_index) {
		if (cur->id == target_index && ! cur->deleted) return cur;
		cur=cur->next;
	}

	return NULL;
}

/* remove targets from the list, optionally based on some condition */
void delete_many_targets(int use_status, int delete_failed)
{
	struct	_target	*cur,
			*tmp;

	cur=targets;
	while (cur) {
		tmp=cur;
		cur=cur->next;

		if (use_status) {
			if (delete_failed && tmp->last_status == STATUS_OKAY)
				continue;
			if (! delete_failed && tmp->last_status != STATUS_OKAY)
				continue;
		}

		delete_target(tmp);
	}

}

/* remove target from the list of available targets */
void delete_target(struct _target *junk)
{
	junk->deleted = 1;

	/*
	if (junk == targets) targets=targets->next;

	if (junk->prev) junk->prev->next=junk->next;
	if (junk->next) junk->next->prev=junk->prev;
	
	free(junk);
	*/
}

/* return TRUE if a string consists entirely of whitespace characters */
int is_all_whitespace(char *text, int len)
{
	char	*c	= text;
	int	i	= 0;

	while (i++ < len && c && *c) {
		if (! isspace(*c++)) return FALSE;
	}

	return TRUE;
}

/* return TRUE if a string consists entirely of numbers */
int is_all_numbers(char *text, int len)
{
	char	*c	= text;
	int	i	= 0;

	if (! text) return FALSE;

	while (i++ < len && c && *c) {
		if (! isdigit(*c++)) return FALSE;
	}

	return TRUE;
}

void initialize_globals(int argc, char *argv[])
{
	myaddr.sin_family=AF_INET;
	myaddr.sin_port=htons(DEFAULT_SRC_PORT);
	myaddr.sin_addr.s_addr=INADDR_ANY;
	
	hisaddr.sin_family=AF_INET;
	hisaddr.sin_port=htons(DEFAULT_DST_PORT);
	hisaddr.sin_addr.s_addr=DEFAULT_TARGET;

#ifdef HAVE_SIN_LEN
	myaddr.sin_len=sizeof(struct sockaddr_in);
	hisaddr.sin_len=sizeof(struct sockaddr_in);
#endif /* HAVE_SIN_LEN */

	user_abort=0;

	exe_name=strrchr(argv[0],'/');
	if (exe_name) exe_name++;
	else exe_name=argv[0];
}

void sigint_handler(int sig)
{
	if (flags.debug) print_err("debug: received SIGINT.");
	user_abort=1;
}

int process_file(char *filename)
{
	FILE	*input_file;
	char	host[COMMAND_BUFFER_LENGTH];
	struct	in_addr	tmpaddr;
	int	target_count = 0;

	if (strcmp(filename, "-") == 0) {
		if (flags.interactive) {
			print_err("can't get input from stdin in interactive mode.");
			return FALSE;
		}
		
		input_file=stdin;
	} else {
		input_file=fopen(filename, "r");
		if (!input_file) {
			print_err("unable to open input file \"%s\".",
					filename);
			return FALSE;
		}
	}

	memset(host, 0, COMMAND_BUFFER_LENGTH);
	while (fgets(host, COMMAND_BUFFER_LENGTH-1, input_file)) {
		if (host[strlen(host)-1] == '\n')
			host[strlen(host)-1]='\0';
		if (resolve_address(host, &tmpaddr)) {
			add_target(tmpaddr, host);
			++target_count;
		} else {
			print_err("unable to resolve address: %s", host);
		}

		memset(host, 0, COMMAND_BUFFER_LENGTH);
	}

	if (strcmp(filename, "-") != 0) {
		fclose(input_file);
	}

	printf("Loaded %d targets.\n", target_count);
	
	return TRUE;
}

/* convert a status code to a string */
char *status_to_string(int s)
{
	switch(s) {
		case STATUS_OKAY:
				return "";
				break;

		case STATUS_SEND_FAILED:
				return "[SEND]";
				break;

		case STATUS_RECEIVE_FAILED:
				return "[RECEIVE]";
				break;

		case STATUS_SELECT_FAILED:
				return "[SELECT]";
				break;

		case STATUS_RETRIES_EXCEEDED:
				return "[RETRIES]";
				break;

		default:
				return "[UNKNOWN]";
				break;
	}
}

void add_to_list(struct _tlist **l, struct _target *t)
{
	struct	_tlist	*new = (struct _tlist *)malloc(sizeof (struct _tlist)),
			*cur;

	if (t == NULL ) return;
	if (t->deleted) return;

	new->next = NULL;
	new->t = t;

	if (*l == NULL) {
		*l = new;
	} else {
		cur=*l;
		while (cur->next) cur=cur->next;
		cur->next = new;
	}
}

struct _tlist *build_list(int argc, char *argv[]) {
	struct	_tlist	*l = NULL;
	struct	_target	*t;

	int	i = 0;
	char	*r;

	while (i < argc) {
		if (strcmp(argv[i], "failed") == 0) {
			t = targets;

			while (t) {
				if (t->last_status != STATUS_OKAY)
					add_to_list(&l, t);
				t=t->next;
			}
		} else if (strcmp(argv[i], "okay") == 0) {
			t = targets;

			while (t) {
				if (t->last_status == STATUS_OKAY)
					add_to_list(&l, t);
				t=t->next;
			}
		} else if (strcmp(argv[i], "all") == 0) {
			t = targets;

			while (t) {
				add_to_list(&l, t);
				t=t->next;
			}

		} else if (strcmp(argv[i], "marked") == 0) {
			t = targets;

			while (t) {
				if (t->marked)
					add_to_list(&l, t);
				t=t->next;
			}

		} else if (r = strchr(argv[i], '-')) {
			int	a,
				b,
				c;
			*r='\0';
			r++;

			if (*argv[i])
				a=atoi(argv[i]);
			else
				a=1;

			if (*r)
				b=atoi(r);
			else
				b=next_target_number - 1;

			c=a;
			while (c <= b) {
				add_to_list(&l, pick_target(c));
				c++;
			}
		} else if (is_all_numbers(argv[i], strlen(argv[i]))) {
			add_to_list(&l, pick_target(atoi(argv[i])));
		} else {
			print_err("ignoring invalid target specifier: %s",
					argv[i]);
		}

		++i;
	}

	return l;
}

#ifdef HAVE_LIBREADLINE

/*
 * READLINE SUPPORT FUNCTIONS
 */

/* complete local commands */
char *local_command_completion_function(char *text, int state)
{
	static int	i,
			len;
	char		*cmd,
			*cmd_with_prefix;

	if (state == 0) {
		i=0;
		len=strlen(text);
	}

	
	while (cmd = local_commands[i].name) {
		i++;

		if (strncmp (cmd, text, len) == 0) {
			cmd_with_prefix=(char *)malloc(strlen(cmd) + 2);
			strcpy(cmd_with_prefix, COMMAND_CHAR);
			strcat(cmd_with_prefix,cmd);
			return (cmd_with_prefix);
		}
	}

	return (char *)NULL;
}

/* complete remote commands */
char *remote_command_completion_function(char *text, int state)
{
	static int	i,
			len;
	char		*cmd;

	if (state == 0) {
		i=0;
		len=strlen(text);
	}

	while (cmd = remote_commands[i].name) {
		i++;

		if (strncmp (cmd, text, len) == 0)
			return (strdup(cmd));
	}

	return (char *)NULL;
}

/* pass partial word to correct completion routine, based on whether or not
 * it starts with the command character. */
char **local_or_remote_completion(char *text, int start, int end)
{
	char **matches = (char **)NULL;

	if (*text == *COMMAND_CHAR)
		matches = completion_matches (text + 1, local_command_completion_function);
	else
		matches = completion_matches (text, remote_command_completion_function);

	return(matches);
}

#endif /* HAVE_LIBREADLINE */
