/* must be compiled as 32-bit binary */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "m2m1shot.h"

int main(int argc, char** argv) {
        int fd;
        struct m2m1shot mshot;

        fd = open("/dev/m2m1shot_jpeg", O_RDWR);

        if (fd < 0) {
                printf("Could not open /dev/m2m1shot_jpeg");
                return 0;
        }

        memset(&mshot, 0, sizeof(struct m2m1shot));

        mshot.buf_out.num_planes = 255;

        if (ioctl(fd, M2M1SHOT_IOC_PROCESS, &mshot) < 0) {
                perror("ioctl");
                printf("%x (%d)\n", errno, errno);
        }

        printf("m2m1shot\n");

        close(fd);

        return 0;
}
